/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzlg;
import com.google.android.gms.internal.zzqd;
import com.google.android.gms.internal.zzqi;
import com.google.android.gms.internal.zzql;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.tagmanager.zzbg;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class zzqo
implements Runnable {
    private final Context mContext;
    private final zzqn zzaQb;
    private final zzqm zzaMS;
    private final zzqd zzaPU;
    private final zzqi zzaQc;

    public zzqo(Context context, zzqd zzqd2, zzqn zzqn2) {
        this(context, zzqd2, zzqn2, new zzqm(), new zzqi());
    }

    public zzqo(Context context, zzqd zzqd2, zzqn zzqn2, String string2) {
        this(context, zzqd2, zzqn2, new zzqm(), new zzqi());
        this.zzaQc.zzeU(string2);
    }

    zzqo(Context context, zzqd zzqd2, zzqn zzqn2, zzqm zzqm2, zzqi zzqi2) {
        zzu.zzu(context);
        zzu.zzu(zzqn2);
        this.mContext = context;
        this.zzaPU = zzqd2;
        this.zzaQb = zzqn2;
        this.zzaMS = zzqm2;
        this.zzaQc = zzqi2;
    }

    @Override
    public void run() {
        this.zzeH();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void zzeH() {
        block11: {
            if (!this.zzAI()) {
                this.zzaQb.zza(zzqn.zza.zzaPW);
                return;
            }
            zzbg.zzaB("NetworkLoader: Starting to load resource from Network.");
            InputStream inputStream = null;
            try (zzql zzql2 = this.zzaMS.zzAG();){
                String string2 = this.zzaQc.zzt(this.zzaPU.zzAf());
                try {
                    inputStream = zzql2.zzfd(string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    zzbg.zzaz("NetworkLoader: No data is retrieved from the given url: " + string2);
                    this.zzaQb.zza(zzqn.zza.zzaPY);
                    zzql2.close();
                    return;
                }
                catch (IOException iOException) {
                    zzbg.zzb("NetworkLoader: Error when loading resource from url: " + string2 + " " + iOException.getMessage(), iOException);
                    this.zzaQb.zza(zzqn.zza.zzaPX);
                    zzql2.close();
                    return;
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    zzlg.zza(inputStream, byteArrayOutputStream);
                    this.zzaQb.zzu(byteArrayOutputStream.toByteArray());
                    break block11;
                }
                catch (IOException iOException) {
                    zzbg.zzb("NetworkLoader: Error when parsing downloaded resources from url: " + string2 + " " + iOException.getMessage(), iOException);
                    this.zzaQb.zza(zzqn.zza.zzaPY);
                    zzql2.close();
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        zzbg.zzaB("NetworkLoader: Resource loaded.");
    }

    boolean zzAI() {
        if (!this.zzba("android.permission.INTERNET")) {
            zzbg.zzaz("Missing android.permission.INTERNET. Please add the following declaration to your AndroidManifest.xml: <uses-permission android:name=\"android.permission.INTERNET\" />");
            return false;
        }
        if (!this.zzba("android.permission.ACCESS_NETWORK_STATE")) {
            zzbg.zzaz("Missing android.permission.ACCESS_NETWORK_STATE. Please add the following declaration to your AndroidManifest.xml: <uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />");
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbg.zzaC("NetworkLoader: No network connectivity - Offline");
            return false;
        }
        return true;
    }

    boolean zzba(String string2) {
        return this.mContext.getPackageManager().checkPermission(string2, this.mContext.getPackageName()) == 0;
    }
}

