/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzdt;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzid;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgd
public class zzaz
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzqt = new Object();
    private final WeakReference<zzha> zzqy;
    private WeakReference<ViewTreeObserver> zzqz;
    private final WeakReference<View> zzqA;
    private final zzax zzqB;
    private final Context zzqw;
    private final zzdt zzqC;
    private final zzdt.zzd zzqD;
    private boolean zzqE;
    private final WindowManager zzqF;
    private final PowerManager zzqG;
    private final KeyguardManager zzqH;
    private zzba zzqI;
    private boolean zzqJ;
    private boolean zzpj = false;
    private boolean zzqK = false;
    private boolean zzqL;
    private boolean zzqM;
    private BroadcastReceiver zzqN;
    private final HashSet<zzaw> zzqO = new HashSet();
    private zzhq zzqm;
    private final zzdg zzqP = new zzdg(){

        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
            if (!zzaz.this.zzb(map)) {
                return;
            }
            zzaz.this.zza((View)zzid2.getWebView(), map);
        }
    };
    private final zzdg zzqQ = new zzdg(){

        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
            if (!zzaz.this.zzb(map)) {
                return;
            }
            zzb.zzay("Received request to untrack: " + zzaz.this.zzqB.zzbT());
            zzaz.this.destroy();
        }
    };
    private final zzdg zzqR = new zzdg(){

        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
            if (!zzaz.this.zzb(map)) {
                return;
            }
            if (!map.containsKey("isVisible")) {
                return;
            }
            Boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
            zzaz.this.zzg(bl);
        }
    };

    public zzaz(AdSizeParcel adSizeParcel, zzha zzha2, VersionInfoParcel versionInfoParcel, View view, zzdt zzdt2) {
        this.zzqC = zzdt2;
        this.zzqy = new WeakReference<zzha>(zzha2);
        this.zzqA = new WeakReference<View>(view);
        this.zzqz = new WeakReference<Object>(null);
        this.zzqL = true;
        this.zzqm = new zzhq(200L);
        this.zzqB = new zzax(UUID.randomUUID().toString(), versionInfoParcel, adSizeParcel.zzsm, zzha2.zzFl, zzha2.zzbU());
        this.zzqD = this.zzqC.zzdU();
        this.zzqF = (WindowManager)view.getContext().getSystemService("window");
        this.zzqG = (PowerManager)view.getContext().getApplicationContext().getSystemService("power");
        this.zzqH = (KeyguardManager)view.getContext().getSystemService("keyguard");
        this.zzqw = view.getContext().getApplicationContext();
        try {
            final JSONObject jSONObject = this.zzd(view);
            this.zzqD.zza(new zzhx.zzc<zzbe>(){

                public void zzb(zzbe zzbe2) {
                    zzaz.this.zza(jSONObject);
                }

                @Override
                public /* synthetic */ void zzc(Object object) {
                    this.zzb((zzbe)object);
                }
            }, new zzhx.zza(){

                @Override
                public void run() {
                }
            });
        }
        catch (JSONException jSONException) {
        }
        catch (RuntimeException runtimeException) {
            zzb.zzb("Failure while processing active view data.", runtimeException);
        }
        this.zzqD.zza(new zzhx.zzc<zzbe>(){

            public void zzb(zzbe zzbe2) {
                zzaz.this.zzqE = true;
                zzaz.this.zza(zzbe2);
                zzaz.this.zzbV();
                zzaz.this.zzh(false);
            }

            @Override
            public /* synthetic */ void zzc(Object object) {
                this.zzb((zzbe)object);
            }
        }, new zzhx.zza(){

            @Override
            public void run() {
                zzaz.this.destroy();
            }
        });
        zzb.zzay("Tracking ad unit: " + this.zzqB.zzbT());
    }

    public void zza(zzaw zzaw2) {
        this.zzqO.add(zzaw2);
    }

    protected void zzg(boolean bl) {
        for (zzaw zzaw2 : this.zzqO) {
            zzaw2.zza(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzbV() {
        Object object = this.zzqt;
        synchronized (object) {
            if (this.zzqN != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zzqN = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzaz.this.zzh(false);
                }
            };
            this.zzqw.registerReceiver(this.zzqN, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzbW() {
        Object object = this.zzqt;
        synchronized (object) {
            if (this.zzqN != null) {
                this.zzqw.unregisterReceiver(this.zzqN);
                this.zzqN = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzcb();
            this.zzbW();
            this.zzqL = false;
            this.zzbY();
            this.zzqD.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbX() {
        Object object = this.zzqt;
        synchronized (object) {
            if (this.zzqL) {
                this.zzqM = true;
                try {
                    JSONObject jSONObject = this.zzcd();
                    this.zza(jSONObject);
                }
                catch (JSONException jSONException) {
                    zzb.zzb("JSON failure while processing active view data.", jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzb.zzb("Failure while processing active view data.", runtimeException);
                }
                zzb.zzay("Untracking ad unit: " + this.zzqB.zzbT());
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzh(boolean bl) {
        Object object = this.zzqt;
        synchronized (object) {
            boolean bl2;
            if (!this.zzqE || !this.zzqL) {
                return;
            }
            if (bl && !this.zzqm.tryAcquire()) {
                return;
            }
            zzha zzha2 = (zzha)this.zzqy.get();
            View view = (View)this.zzqA.get();
            boolean bl3 = bl2 = view == null || zzha2 == null;
            if (bl2) {
                this.zzbX();
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject);
            }
            catch (RuntimeException | JSONException throwable) {
                zzb.zza("Active view update failed.", throwable);
            }
            this.zzca();
            this.zzbY();
        }
    }

    protected void zzbY() {
        if (this.zzqI != null) {
            this.zzqI.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzbZ() {
        Object object = this.zzqt;
        synchronized (object) {
            return this.zzqL;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzca() {
        View view = (View)this.zzqA.get();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzqz.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzcb();
        if (!this.zzqJ || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zzqJ = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzqz = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    protected boolean zzb(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzqB.zzbT());
    }

    protected void zza(zzbe zzbe2) {
        zzbe2.zza("/updateActiveView", this.zzqP);
        zzbe2.zza("/untrackActiveViewUnit", this.zzqQ);
        zzbe2.zza("/visibilityChanged", this.zzqR);
    }

    protected void zzcb() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzqz.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzcc() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzqB.zzbR()).put("activeViewJSON", (Object)this.zzqB.zzbS()).put("timestamp", zzo.zzbz().elapsedRealtime()).put("adFormat", (Object)this.zzqB.zzbQ()).put("hashCode", (Object)this.zzqB.zzbT()).put("isMraid", this.zzqB.zzbU());
        return jSONObject;
    }

    protected void zza(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = new JSONArray();
            final JSONObject jSONObject2 = new JSONObject();
            jSONArray.put((Object)jSONObject);
            jSONObject2.put("units", (Object)jSONArray);
            this.zzqD.zza(new zzhx.zzc<zzbe>(){

                public void zzb(zzbe zzbe2) {
                    zzbe2.zza("AFMA_updateActiveView", jSONObject2);
                }

                @Override
                public /* synthetic */ void zzc(Object object) {
                    this.zzb((zzbe)object);
                }
            }, new zzhx.zzb());
        }
        catch (Throwable throwable) {
            zzb.zzb("Skipping active view message.", throwable);
        }
    }

    protected JSONObject zzd(View view) throws JSONException {
        boolean bl = zzo.zzbx().zzk(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzb.zzb("Failure getting view location.", exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zzqF.getDefaultDisplay().getWidth();
        rect2.bottom = this.zzqF.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzcc();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isStopped", this.zzqK).put("isPaused", this.zzpj).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", this.zze(view));
        return jSONObject;
    }

    protected boolean zze(View view) {
        return view.getVisibility() == 0 && view.isShown() && this.isScreenOn() && (!this.zzqH.inKeyguardRestrictedInputMode() || zzo.zzbv().zzgl());
    }

    boolean isScreenOn() {
        return this.zzqG.isScreenOn();
    }

    protected JSONObject zzcd() throws JSONException {
        JSONObject jSONObject = this.zzcc();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzh(true);
    }

    public void onGlobalLayout() {
        this.zzh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzba zzba2) {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzqI = zzba2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzqK = true;
            this.zzh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzpj = true;
            this.zzh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzpj = false;
            this.zzh(false);
        }
    }
}

