/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntityCreator;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;

public final class SnapshotEntity
implements SafeParcelable,
Snapshot {
    public static final Parcelable.Creator<SnapshotEntity> CREATOR = new SnapshotEntityCreator();
    private final int zzCY;
    private final SnapshotMetadataEntity zzavk;
    private final SnapshotContentsEntity zzavl;

    public SnapshotEntity(SnapshotMetadata metadata, SnapshotContentsEntity contents) {
        this(2, metadata, contents);
    }

    SnapshotEntity(int versionCode, SnapshotMetadata metadata, SnapshotContentsEntity contents) {
        this.zzCY = versionCode;
        this.zzavk = new SnapshotMetadataEntity(metadata);
        this.zzavl = contents;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public SnapshotMetadata getMetadata() {
        return this.zzavk;
    }

    @Override
    public SnapshotContents getSnapshotContents() {
        return this.isClosed() ? null : this.zzavl;
    }

    private boolean isClosed() {
        return this.zzavl.isClosed();
    }

    @Override
    public Snapshot freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotEntity.zzb(this);
    }

    static int zzb(Snapshot snapshot) {
        return zzt.hashCode(snapshot.getMetadata(), snapshot.getSnapshotContents());
    }

    public boolean equals(Object obj) {
        return SnapshotEntity.zza(this, obj);
    }

    static boolean zza(Snapshot snapshot, Object object) {
        if (!(object instanceof Snapshot)) {
            return false;
        }
        if (snapshot == object) {
            return true;
        }
        Snapshot snapshot2 = (Snapshot)object;
        return zzt.equal(snapshot2.getMetadata(), snapshot.getMetadata()) && zzt.equal(snapshot2.getSnapshotContents(), snapshot.getSnapshotContents());
    }

    public String toString() {
        return SnapshotEntity.zzc(this);
    }

    static String zzc(Snapshot snapshot) {
        return zzt.zzt(snapshot).zzg("Metadata", snapshot.getMetadata()).zzg("HasContents", snapshot.getSnapshotContents() != null).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotEntityCreator.zza(this, out, flags);
    }
}

