/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntityCreator;

public final class GameBadgeEntity
extends GamesDowngradeableSafeParcel
implements GameBadge {
    public static final GameBadgeEntityCreator CREATOR = new GameBadgeEntityCreatorCompat();
    private final int zzCY;
    private int zzSq;
    private String zzadv;
    private String zzakM;
    private Uri zzanf;

    public GameBadgeEntity(GameBadge gameBadge) {
        this.zzCY = 1;
        this.zzSq = gameBadge.getType();
        this.zzadv = gameBadge.getTitle();
        this.zzakM = gameBadge.getDescription();
        this.zzanf = gameBadge.getIconImageUri();
    }

    GameBadgeEntity(int versionCode, int type, String title, String description, Uri iconImageUri) {
        this.zzCY = versionCode;
        this.zzSq = type;
        this.zzadv = title;
        this.zzakM = description;
        this.zzanf = iconImageUri;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public int getType() {
        return this.zzSq;
    }

    @Override
    public String getTitle() {
        return this.zzadv;
    }

    @Override
    public String getDescription() {
        return this.zzakM;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzanf;
    }

    public GameBadge zzti() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameBadgeEntity.zza(this);
    }

    static int zza(GameBadge gameBadge) {
        return zzt.hashCode(gameBadge.getType(), gameBadge.getTitle(), gameBadge.getDescription(), gameBadge.getIconImageUri());
    }

    public boolean equals(Object obj) {
        return GameBadgeEntity.zza(this, obj);
    }

    static boolean zza(GameBadge gameBadge, Object object) {
        if (!(object instanceof GameBadge)) {
            return false;
        }
        if (gameBadge == object) {
            return true;
        }
        GameBadge gameBadge2 = (GameBadge)object;
        return zzt.equal(gameBadge2.getType(), gameBadge.getTitle()) && zzt.equal(gameBadge2.getDescription(), gameBadge.getIconImageUri());
    }

    public String toString() {
        return GameBadgeEntity.zzb(this);
    }

    static String zzb(GameBadge gameBadge) {
        return zzt.zzt(gameBadge).zzg("Type", gameBadge.getType()).zzg("Title", gameBadge.getTitle()).zzg("Description", gameBadge.getDescription()).zzg("IconImageUri", gameBadge.getIconImageUri()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zznF()) {
            GameBadgeEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeInt(this.zzSq);
            dest.writeString(this.zzadv);
            dest.writeString(this.zzakM);
            dest.writeString(this.zzanf == null ? null : this.zzanf.toString());
        }
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.zzti();
    }

    static final class GameBadgeEntityCreatorCompat
    extends GameBadgeEntityCreator {
        GameBadgeEntityCreatorCompat() {
        }

        @Override
        public GameBadgeEntity zzdE(Parcel parcel) {
            boolean bl = GameBadgeEntity.zzd(GameBadgeEntity.zznE());
            if (bl || GameBadgeEntity.zzca(GameBadgeEntity.class.getCanonicalName())) {
                return super.zzdE(parcel);
            }
            int n = parcel.readInt();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            return new GameBadgeEntity(1, n, string2, string3, uri);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdE(x0);
        }
    }
}

