/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.appstate.AppStateBuffer;
import com.google.android.gms.appstate.AppStateManager;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjd;
import java.util.Set;

public final class zzjb
extends zzi<zzjd> {
    public zzjb(Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 7, connectionCallbacks, onConnectionFailedListener, zze2);
    }

    @Override
    public boolean requiresSignIn() {
        return true;
    }

    @Override
    protected Set<Scope> zza(Set<Scope> set) {
        zzu.zza(set.contains(new Scope("https://www.googleapis.com/auth/appstate")), (Object)String.format("App State APIs requires %s to function.", "https://www.googleapis.com/auth/appstate"));
        return set;
    }

    @Override
    protected String getStartServiceAction() {
        return "com.google.android.gms.appstate.service.START";
    }

    @Override
    protected String getServiceDescriptor() {
        return "com.google.android.gms.appstate.internal.IAppStateService";
    }

    protected zzjd zzaj(IBinder iBinder) {
        return zzjd.zza.zzal(iBinder);
    }

    public int zzkV() {
        int n = 2;
        try {
            n = ((zzjd)this.zznM()).zzkV();
        }
        catch (RemoteException remoteException) {
            Log.w((String)"AppStateClient", (String)"service died");
        }
        return n;
    }

    public int zzkW() {
        int n = 2;
        try {
            n = ((zzjd)this.zznM()).zzkW();
        }
        catch (RemoteException remoteException) {
            Log.w((String)"AppStateClient", (String)"service died");
        }
        return n;
    }

    public void zza(zza.zzb<AppStateManager.StateResult> zzb2, int n, byte[] byArray) throws RemoteException {
        zze zze2 = zzb2 == null ? null : new zze(zzb2);
        ((zzjd)this.zznM()).zza(zze2, n, byArray);
    }

    public void zza(zza.zzb<AppStateManager.StateDeletedResult> zzb2, int n) throws RemoteException {
        ((zzjd)this.zznM()).zzb(new zza(zzb2), n);
    }

    public void zzb(zza.zzb<AppStateManager.StateResult> zzb2, int n) throws RemoteException {
        ((zzjd)this.zznM()).zza(new zze(zzb2), n);
    }

    @Override
    public void zza(zza.zzb<AppStateManager.StateListResult> zzb2) throws RemoteException {
        ((zzjd)this.zznM()).zza(new zzc(zzb2));
    }

    public void zza(zza.zzb<AppStateManager.StateResult> zzb2, int n, String string2, byte[] byArray) throws RemoteException {
        ((zzjd)this.zznM()).zza(new zze(zzb2), n, string2, byArray);
    }

    public void zzb(zza.zzb<Status> zzb2) throws RemoteException {
        ((zzjd)this.zznM()).zzb(new zzg(zzb2));
    }

    @Override
    protected /* synthetic */ IInterface zzT(IBinder iBinder) {
        return this.zzaj(iBinder);
    }

    private static final class zzb
    implements AppStateManager.StateDeletedResult {
        private final Status zzOt;
        private final int zzOu;

        public zzb(Status status, int n) {
            this.zzOt = status;
            this.zzOu = n;
        }

        @Override
        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public int getStateKey() {
            return this.zzOu;
        }
    }

    private static final class zzd
    extends com.google.android.gms.common.api.zzc
    implements AppStateManager.StateListResult {
        private final AppStateBuffer zzOv;

        public zzd(DataHolder dataHolder) {
            super(dataHolder);
            this.zzOv = new AppStateBuffer(dataHolder);
        }

        @Override
        public AppStateBuffer getStateBuffer() {
            return this.zzOv;
        }
    }

    private static final class zzf
    extends com.google.android.gms.common.api.zzc
    implements AppStateManager.StateConflictResult,
    AppStateManager.StateLoadedResult,
    AppStateManager.StateResult {
        private final int zzOu;
        private final AppStateBuffer zzOv;

        public zzf(int n, DataHolder dataHolder) {
            super(dataHolder);
            this.zzOu = n;
            this.zzOv = new AppStateBuffer(dataHolder);
        }

        @Override
        public String getResolvedVersion() {
            if (this.zzOv.getCount() == 0) {
                return null;
            }
            return this.zzOv.get(0).getConflictVersion();
        }

        @Override
        public byte[] getServerData() {
            if (this.zzOv.getCount() == 0) {
                return null;
            }
            return this.zzOv.get(0).getConflictData();
        }

        @Override
        public int getStateKey() {
            return this.zzOu;
        }

        @Override
        public byte[] getLocalData() {
            if (this.zzOv.getCount() == 0) {
                return null;
            }
            return this.zzOv.get(0).getLocalData();
        }

        private boolean zzkX() {
            return this.zzOt.getStatusCode() == 2000;
        }

        @Override
        public AppStateManager.StateLoadedResult getLoadedResult() {
            return this.zzkX() ? null : this;
        }

        @Override
        public AppStateManager.StateConflictResult getConflictResult() {
            return this.zzkX() ? this : null;
        }

        @Override
        public void release() {
            this.zzOv.release();
        }
    }

    private static final class zzg
    extends zzja {
        private final zza.zzb<Status> zzOs;

        public zzg(zza.zzb<Status> zzb2) {
            this.zzOs = zzu.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzkU() {
            Status status = new Status(0);
            this.zzOs.zzm(status);
        }
    }

    private static final class zza
    extends zzja {
        private final zza.zzb<AppStateManager.StateDeletedResult> zzOs;

        public zza(zza.zzb<AppStateManager.StateDeletedResult> zzb2) {
            this.zzOs = zzu.zzb(zzb2, (Object)"Result holder must not be null");
        }

        @Override
        public void zzg(int n, int n2) {
            Status status = new Status(n);
            this.zzOs.zzm(new zzb(status, n2));
        }
    }

    private static final class zzc
    extends zzja {
        private final zza.zzb<AppStateManager.StateListResult> zzOs;

        public zzc(zza.zzb<AppStateManager.StateListResult> zzb2) {
            this.zzOs = zzu.zzb(zzb2, (Object)"Result holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder) {
            this.zzOs.zzm(new zzd(dataHolder));
        }
    }

    private static final class zze
    extends zzja {
        private final zza.zzb<AppStateManager.StateResult> zzOs;

        public zze(zza.zzb<AppStateManager.StateResult> zzb2) {
            this.zzOs = zzu.zzb(zzb2, (Object)"Result holder must not be null");
        }

        @Override
        public void zza(int n, DataHolder dataHolder) {
            this.zzOs.zzm(new zzf(n, dataHolder));
        }
    }
}

