/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzgd;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;

@zzgd
public class zzgc
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler zzCa;
    private Thread.UncaughtExceptionHandler zzCb;
    private Context mContext;
    private VersionInfoParcel zzCc;

    public static zzgc zza(Context context, Thread thread, VersionInfoParcel versionInfoParcel) {
        if (context == null || thread == null || versionInfoParcel == null) {
            return null;
        }
        if (!zzgc.zzz(context)) {
            return null;
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = thread.getUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler2 = thread.getDefaultUncaughtExceptionHandler();
        zzgc zzgc2 = new zzgc(context, versionInfoParcel, uncaughtExceptionHandler, uncaughtExceptionHandler2);
        if (uncaughtExceptionHandler == null || !(uncaughtExceptionHandler instanceof zzgc)) {
            try {
                thread.setUncaughtExceptionHandler(zzgc2);
                return zzgc2;
            }
            catch (SecurityException securityException) {
                zzb.zzc("Fail to set UncaughtExceptionHandler.", securityException);
            }
        } else {
            return (zzgc)uncaughtExceptionHandler;
        }
        return null;
    }

    private static boolean zzz(Context context) {
        return zzbz.zztG.get();
    }

    public zzgc(Context context, VersionInfoParcel versionInfoParcel, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Thread.UncaughtExceptionHandler uncaughtExceptionHandler2) {
        this.zzCa = uncaughtExceptionHandler;
        this.zzCb = uncaughtExceptionHandler2;
        this.mContext = context;
        this.zzCc = versionInfoParcel;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        if (this.zza(exception)) {
            if (Looper.getMainLooper().getThread() != thread) {
                this.zza(exception, true);
                return;
            }
            this.zza(exception, false);
        }
        if (this.zzCa != null) {
            this.zzCa.uncaughtException(thread, exception);
        } else if (this.zzCb != null) {
            this.zzCb.uncaughtException(thread, exception);
        }
    }

    protected boolean zza(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (throwable != null) {
            StackTraceElement[] stackTraceElementArray;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                if (this.zzal(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!this.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
            throwable = throwable.getCause();
        }
        return bl && !bl2;
    }

    protected boolean zzal(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if (string2.startsWith("com.google.android.gms.ads")) {
            return true;
        }
        if (string2.startsWith("com.google.ads")) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            return clazz.isAnnotationPresent(zzgd.class);
        }
        catch (Exception exception) {
            zzb.zza("Fail to check class type for class " + string2, exception);
            return false;
        }
    }

    protected boolean zzam(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.startsWith("android.") || string2.startsWith("java.");
    }

    public void zza(Throwable throwable, boolean bl) {
        if (!zzgc.zzz(this.mContext)) {
            return;
        }
        Throwable throwable2 = this.zzb(throwable);
        if (throwable2 == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.zzb(throwable2, bl));
        zzo.zzbv().zza(this.mContext, this.zzCc.zzGG, arrayList, zzo.zzby().zzgb());
    }

    String zzb(Throwable throwable, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        Uri.Builder builder = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", zzo.zzbv().zzgo()).appendQueryParameter("js", this.zzCc.zzGG).appendQueryParameter("appid", this.mContext.getApplicationContext().getPackageName()).appendQueryParameter("stacktrace", stringWriter.toString()).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzbz.zzdb())).appendQueryParameter("trapped", String.valueOf(bl));
        return builder.toString();
    }

    private Throwable zzb(Throwable throwable) {
        Throwable throwable2;
        if (zzbz.zztH.get().booleanValue()) {
            return throwable;
        }
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            linkedList.push(throwable2);
        }
        Throwable throwable3 = null;
        while (!linkedList.isEmpty()) {
            throwable2 = (Throwable)linkedList.pop();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            arrayList.add(new StackTraceElement(throwable2.getClass().getName(), "<filtered>", "<filtered>", 1));
            boolean bl = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (this.zzal(stackTraceElement.getClassName())) {
                    bl = true;
                    arrayList.add(stackTraceElement);
                    continue;
                }
                if (this.zzam(stackTraceElement.getClassName())) {
                    arrayList.add(stackTraceElement);
                    continue;
                }
                StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                arrayList.add(stackTraceElement2);
            }
            if (!bl) continue;
            throwable3 = throwable3 == null ? new Throwable(throwable2.getMessage()) : new Throwable(throwable2.getMessage(), throwable3);
            throwable3.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        }
        return throwable3;
    }
}

