/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;

public final class EventsImpl
implements Events {
    @Override
    public PendingResult<Events.LoadEventsResult> loadByIds(GoogleApiClient apiClient, final boolean forceReload, final String ... eventIds) {
        return apiClient.zza(new LoadImpl(apiClient){

            @Override
            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza(this, forceReload, eventIds);
            }
        });
    }

    @Override
    public PendingResult<Events.LoadEventsResult> load(GoogleApiClient apiClient, final boolean forceReload) {
        return apiClient.zza(new LoadImpl(apiClient){

            @Override
            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzd(this, forceReload);
            }
        });
    }

    @Override
    public void increment(GoogleApiClient apiClient, final String eventId, final int incrementAmount) {
        GamesClientImpl gamesClientImpl = Games.zzc(apiClient, false);
        if (gamesClientImpl == null) {
            return;
        }
        if (gamesClientImpl.isConnected()) {
            gamesClientImpl.zzp(eventId, incrementAmount);
        } else {
            apiClient.zzb(new UpdateImpl(apiClient){

                @Override
                public void zza(GamesClientImpl gamesClientImpl) {
                    gamesClientImpl.zzp(eventId, incrementAmount);
                }
            });
        }
    }

    private static abstract class UpdateImpl
    extends Games.BaseGamesApiMethodImpl<Result> {
        private UpdateImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        public Result createFailedResult(final Status status) {
            return new Result(){

                @Override
                public Status getStatus() {
                    return status;
                }
            };
        }
    }

    private static abstract class LoadImpl
    extends Games.BaseGamesApiMethodImpl<Events.LoadEventsResult> {
        private LoadImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Events.LoadEventsResult zzW(final Status status) {
            return new Events.LoadEventsResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public void release() {
                }

                @Override
                public EventBuffer getEvents() {
                    return new EventBuffer(DataHolder.zzbi(14));
                }
            };
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzW(x0);
        }
    }
}

