/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzrq;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public final class zzrg {
    private final ByteBuffer zzaVT;

    private zzrg(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzrg(ByteBuffer byteBuffer) {
        this.zzaVT = byteBuffer;
    }

    public static zzrg zzA(byte[] byArray) {
        return zzrg.zzb(byArray, 0, byArray.length);
    }

    public static zzrg zzb(byte[] byArray, int n, int n2) {
        return new zzrg(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzC(n, 1);
        this.zzh(d);
    }

    public void zzb(int n, float f) throws IOException {
        this.zzC(n, 5);
        this.zzi(f);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzC(n, 0);
        this.zzW(l);
    }

    public void zzy(int n, int n2) throws IOException {
        this.zzC(n, 0);
        this.zzkH(n2);
    }

    public void zzb(int n, boolean bl) throws IOException {
        this.zzC(n, 0);
        this.zzar(bl);
    }

    public void zzb(int n, String string2) throws IOException {
        this.zzC(n, 2);
        this.zzfi(string2);
    }

    public void zza(int n, zzrn zzrn2) throws IOException {
        this.zzC(n, 2);
        this.zzc(zzrn2);
    }

    public void zza(int n, byte[] byArray) throws IOException {
        this.zzC(n, 2);
        this.zzB(byArray);
    }

    public void zzz(int n, int n2) throws IOException {
        this.zzC(n, 0);
        this.zzkI(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzC(n, 0);
        this.zzX(l);
    }

    public void zzh(double d) throws IOException {
        this.zzac(Double.doubleToLongBits(d));
    }

    public void zzi(float f) throws IOException {
        this.zzkP(Float.floatToIntBits(f));
    }

    public void zzW(long l) throws IOException {
        this.zzaa(l);
    }

    public void zzkH(int n) throws IOException {
        if (n >= 0) {
            this.zzkN(n);
        } else {
            this.zzaa(n);
        }
    }

    public void zzar(boolean bl) throws IOException {
        this.zzkL(bl ? 1 : 0);
    }

    public void zzfi(String string2) throws IOException {
        try {
            int n = zzrg.zzkO(string2.length());
            int n2 = zzrg.zzkO(string2.length() * 3);
            if (n == n2) {
                int n3 = this.zzaVT.position();
                this.zzaVT.position(n3 + n);
                zzrg.zza((CharSequence)string2, this.zzaVT);
                int n4 = this.zzaVT.position();
                this.zzaVT.position(n3);
                this.zzkN(n4 - n3 - n);
                this.zzaVT.position(n4);
            } else {
                this.zzkN(zzrg.zza(string2));
                zzrg.zza((CharSequence)string2, this.zzaVT);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new zza(this.zzaVT.position(), this.zzaVT.limit());
        }
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zzrg.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n3 + 0x100000000L));
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + i);
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzrg.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zzrg.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
            }
            int n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n5 < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n5 + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n5 + n4;
        }
        n5 += n3;
        while (n3 < n4) {
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                char c2;
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (n3 - 1));
                }
                int n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + n5);
            }
            ++n3;
        }
        return n5;
    }

    public void zzb(zzrn zzrn2) throws IOException {
        zzrn2.zza(this);
    }

    public void zzc(zzrn zzrn2) throws IOException {
        this.zzkN(zzrn2.zzBU());
        zzrn2.zza(this);
    }

    public void zzB(byte[] byArray) throws IOException {
        this.zzkN(byArray.length);
        this.zzD(byArray);
    }

    public void zzkI(int n) throws IOException {
        this.zzkN(zzrg.zzkQ(n));
    }

    public void zzX(long l) throws IOException {
        this.zzaa(zzrg.zzad(l));
    }

    public static int zzb(int n, double d) {
        return zzrg.zzkM(n) + zzrg.zzi(d);
    }

    public static int zzc(int n, float f) {
        return zzrg.zzkM(n) + zzrg.zzj(f);
    }

    public static int zzd(int n, long l) {
        return zzrg.zzkM(n) + zzrg.zzY(l);
    }

    public static int zzA(int n, int n2) {
        return zzrg.zzkM(n) + zzrg.zzkJ(n2);
    }

    public static int zzc(int n, boolean bl) {
        return zzrg.zzkM(n) + zzrg.zzas(bl);
    }

    public static int zzk(int n, String string2) {
        return zzrg.zzkM(n) + zzrg.zzfj(string2);
    }

    public static int zzb(int n, zzrn zzrn2) {
        return zzrg.zzkM(n) * 2 + zzrg.zzd(zzrn2);
    }

    public static int zzc(int n, zzrn zzrn2) {
        return zzrg.zzkM(n) + zzrg.zze(zzrn2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zzrg.zzkM(n) + zzrg.zzC(byArray);
    }

    public static int zzB(int n, int n2) {
        return zzrg.zzkM(n) + zzrg.zzkK(n2);
    }

    public static int zze(int n, long l) {
        return zzrg.zzkM(n) + zzrg.zzZ(l);
    }

    public static int zzi(double d) {
        return 8;
    }

    public static int zzj(float f) {
        return 4;
    }

    public static int zzY(long l) {
        return zzrg.zzab(l);
    }

    public static int zzkJ(int n) {
        if (n >= 0) {
            return zzrg.zzkO(n);
        }
        return 10;
    }

    public static int zzas(boolean bl) {
        return 1;
    }

    public static int zzfj(String string2) {
        int n = zzrg.zza(string2);
        return zzrg.zzkO(n) + n;
    }

    public static int zzd(zzrn zzrn2) {
        return zzrn2.zzBV();
    }

    public static int zze(zzrn zzrn2) {
        int n = zzrn2.zzBV();
        return zzrg.zzkO(n) + n;
    }

    public static int zzC(byte[] byArray) {
        return zzrg.zzkO(byArray.length) + byArray.length;
    }

    public static int zzkK(int n) {
        return zzrg.zzkO(zzrg.zzkQ(n));
    }

    public static int zzZ(long l) {
        return zzrg.zzab(zzrg.zzad(l));
    }

    public int zzBG() {
        return this.zzaVT.remaining();
    }

    public void zzBH() {
        if (this.zzBG() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzb(byte by) throws IOException {
        if (!this.zzaVT.hasRemaining()) {
            throw new zza(this.zzaVT.position(), this.zzaVT.limit());
        }
        this.zzaVT.put(by);
    }

    public void zzkL(int n) throws IOException {
        this.zzb((byte)n);
    }

    public void zzD(byte[] byArray) throws IOException {
        this.zzc(byArray, 0, byArray.length);
    }

    public void zzc(byte[] byArray, int n, int n2) throws IOException {
        if (this.zzaVT.remaining() < n2) {
            throw new zza(this.zzaVT.position(), this.zzaVT.limit());
        }
        this.zzaVT.put(byArray, n, n2);
    }

    public void zzC(int n, int n2) throws IOException {
        this.zzkN(zzrq.zzD(n, n2));
    }

    public static int zzkM(int n) {
        return zzrg.zzkO(zzrq.zzD(n, 0));
    }

    public void zzkN(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzkL(n);
                return;
            }
            this.zzkL(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzkO(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzaa(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzkL((int)l);
                return;
            }
            this.zzkL((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzab(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzkP(int n) throws IOException {
        this.zzkL(n & 0xFF);
        this.zzkL(n >> 8 & 0xFF);
        this.zzkL(n >> 16 & 0xFF);
        this.zzkL(n >> 24 & 0xFF);
    }

    public void zzac(long l) throws IOException {
        this.zzkL((int)l & 0xFF);
        this.zzkL((int)(l >> 8) & 0xFF);
        this.zzkL((int)(l >> 16) & 0xFF);
        this.zzkL((int)(l >> 24) & 0xFF);
        this.zzkL((int)(l >> 32) & 0xFF);
        this.zzkL((int)(l >> 40) & 0xFF);
        this.zzkL((int)(l >> 48) & 0xFF);
        this.zzkL((int)(l >> 56) & 0xFF);
    }

    public static int zzkQ(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzad(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space (pos " + n + " limit " + n2 + ").");
        }
    }
}

