/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.os.SystemClock;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zzc;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzm
extends zzc {
    private static final String NAMESPACE = zzf.zzbE("com.google.cast.media");
    private long zzUY;
    private MediaStatus zzUZ;
    private final List<zzp> zzTo;
    private final zzp zzVa = new zzp(86400000L);
    private final zzp zzVb = new zzp(86400000L);
    private final zzp zzVc = new zzp(86400000L);
    private final zzp zzVd = new zzp(86400000L);
    private final zzp zzVe = new zzp(86400000L);
    private final zzp zzVf = new zzp(86400000L);
    private final zzp zzVg = new zzp(86400000L);
    private final zzp zzVh = new zzp(86400000L);
    private final zzp zzVi = new zzp(86400000L);
    private final zzp zzVj = new zzp(86400000L);
    private final zzp zzVk = new zzp(86400000L);
    private final zzp zzVl = new zzp(86400000L);
    private final zzp zzVm = new zzp(86400000L);
    private final zzp zzVn = new zzp(86400000L);

    public zzm(String string2) {
        super(NAMESPACE, "MediaControlChannel", string2, 1000L);
        this.zzTo = new ArrayList<zzp>();
        this.zzTo.add(this.zzVa);
        this.zzTo.add(this.zzVb);
        this.zzTo.add(this.zzVc);
        this.zzTo.add(this.zzVd);
        this.zzTo.add(this.zzVe);
        this.zzTo.add(this.zzVf);
        this.zzTo.add(this.zzVg);
        this.zzTo.add(this.zzVh);
        this.zzTo.add(this.zzVi);
        this.zzTo.add(this.zzVj);
        this.zzTo.add(this.zzVk);
        this.zzTo.add(this.zzVl);
        this.zzTo.add(this.zzVm);
        this.zzTo.add(this.zzVn);
        this.zzmc();
    }

    public long zza(zzo zzo2, MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzlK();
        this.zzVa.zza(l2, zzo2);
        this.zzQ(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.toJson());
            jSONObject2.put("autoplay", bl);
            jSONObject2.put("currentTime", zzf.zzA(l));
            if (lArray != null) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzo zzo2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzlK();
        this.zzVb.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzls());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzb(zzo zzo2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzlK();
        this.zzVd.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzls());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzc(zzo zzo2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzlK();
        this.zzVc.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzls());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, long l, int n, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzlK();
        this.zzVe.zza(l2, zzo2);
        this.zzQ(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zzls());
            jSONObject2.put("currentTime", zzf.zzA(l));
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzo zzo2, double d, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzlK();
        this.zzVf.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzls());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, boolean bl, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzlK();
        this.zzVg.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzls());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzlK();
        this.zzVh.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzUZ != null) {
                jSONObject.put("mediaSessionId", this.zzUZ.zzls());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, long[] lArray) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzlK();
        this.zzVi.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzls());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, TextTrackStyle textTrackStyle) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzlK();
        this.zzVj.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zzls());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zzUY == 0L) {
            return 0L;
        }
        double d = this.zzUZ.getPlaybackRate();
        long l = this.zzUZ.getStreamPosition();
        int n = this.zzUZ.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        long l2 = SystemClock.elapsedRealtime() - this.zzUY;
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l2 == 0L) {
            return l;
        }
        long l3 = mediaInfo.getStreamDuration();
        long l4 = l + (long)((double)l2 * d);
        if (l3 > 0L && l4 > l3) {
            l4 = l3;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.zzUZ;
    }

    public MediaInfo getMediaInfo() {
        return this.zzUZ == null ? null : this.zzUZ.getMediaInfo();
    }

    public long zza(zzo zzo2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IOException, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= mediaQueueItemArray.length) {
            throw new IllegalArgumentException("Invalid startIndex: " + n);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzlK();
        this.zzVa.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            switch (n2) {
                case 0: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                    break;
                }
                case 1: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                    break;
                }
                case 2: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                    break;
                }
                case 3: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid repeat mode: " + n2);
                }
            }
            jSONObject2.put("startIndex", n);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, MediaQueueItem[] mediaQueueItemArray, int n, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalStateException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzlK();
        this.zzVk.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zzls());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, int n, MediaQueueItem[] mediaQueueItemArray, int n2, Integer n3, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzlK();
        this.zzVl.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zzls());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && mediaQueueItemArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                    jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                        break;
                    }
                    case 1: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                        break;
                    }
                    case 2: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                        break;
                    }
                    case 3: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                        break;
                    }
                }
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, int[] nArray, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzlK();
        this.zzVm.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zzls());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, int[] nArray, int n, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzlK();
        this.zzVn.zza(l, zzo2);
        this.zzQ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zzls());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    @Override
    public final void zzbB(String string2) {
        this.zzUi.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            if (string3.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.zza(l, jSONArray.getJSONObject(0));
                } else {
                    this.zzUZ = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.onQueueStatusUpdated();
                    this.onPreloadStatusUpdated();
                    this.zzVh.zzc(l, 0);
                }
            } else if (string3.equals("INVALID_PLAYER_STATE")) {
                this.zzUi.zzf("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                for (zzp zzp2 : this.zzTo) {
                    zzp2.zzc(l, 2100, jSONObject2);
                }
            } else if (string3.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.zzVa.zzc(l, 2100, jSONObject3);
            } else if (string3.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.zzVa.zzc(l, 2101, jSONObject4);
            } else if (string3.equals("INVALID_REQUEST")) {
                this.zzUi.zzf("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                for (zzp zzp3 : this.zzTo) {
                    zzp3.zzc(l, 2100, jSONObject5);
                }
            }
        }
        catch (JSONException jSONException) {
            this.zzUi.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
        }
    }

    private void zza(long l, JSONObject jSONObject) throws JSONException {
        boolean bl = this.zzVa.zzB(l);
        boolean bl2 = this.zzVe.zzme() && !this.zzVe.zzB(l);
        boolean bl3 = this.zzVf.zzme() && !this.zzVf.zzB(l) || this.zzVg.zzme() && !this.zzVg.zzB(l);
        int n = 0;
        if (bl2) {
            n |= 2;
        }
        if (bl3) {
            n |= 1;
        }
        int n2 = 0;
        if (bl || this.zzUZ == null) {
            this.zzUZ = new MediaStatus(jSONObject);
            this.zzUY = SystemClock.elapsedRealtime();
            n2 = 31;
        } else {
            n2 = this.zzUZ.zza(jSONObject, n);
        }
        if ((n2 & 1) != 0) {
            this.zzUY = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n2 & 2) != 0) {
            this.zzUY = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n2 & 4) != 0) {
            this.onMetadataUpdated();
        }
        if ((n2 & 8) != 0) {
            this.onQueueStatusUpdated();
        }
        if ((n2 & 0x10) != 0) {
            this.onPreloadStatusUpdated();
        }
        for (zzp zzp2 : this.zzTo) {
            zzp2.zzc(l, 0);
        }
    }

    public long zzls() throws IllegalStateException {
        if (this.zzUZ == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.zzUZ.zzls();
    }

    protected void onStatusUpdated() {
    }

    protected void onMetadataUpdated() {
    }

    protected void onQueueStatusUpdated() {
    }

    protected void onPreloadStatusUpdated() {
    }

    private void zzmc() {
        this.zzUY = 0L;
        this.zzUZ = null;
        for (zzp zzp2 : this.zzTo) {
            zzp2.clear();
        }
    }

    @Override
    public void zzlJ() {
        super.zzlJ();
        this.zzmc();
    }

    @Override
    public void zzb(long l, int n) {
        for (zzp zzp2 : this.zzTo) {
            zzp2.zzc(l, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzz(long l) {
        for (zzp object2 : this.zzTo) {
            object2.zzd(l, 2102);
        }
        boolean bl = false;
        Object object = zzp.zzVr;
        synchronized (object) {
            for (zzp zzp2 : this.zzTo) {
                if (!zzp2.zzme()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

