/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.util.SparseArray;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.internal.zzf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaStatus {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    private int zzSa = 0;
    private long zzSb;
    private MediaInfo zzRK;
    private double zzSc;
    private int zzSd;
    private int zzSe;
    private long zzSf;
    private long zzSg;
    private double zzSh;
    private boolean zzSi;
    private long[] zzRY;
    private JSONObject zzRJ;
    private int zzSj = 0;
    private int zzSk = 0;
    private final zza zzSl = new zza();

    public MediaStatus(JSONObject json) throws JSONException {
        this.zza(json, 0);
    }

    public long zzls() {
        return this.zzSb;
    }

    public int getPlayerState() {
        return this.zzSd;
    }

    public int getIdleReason() {
        return this.zzSe;
    }

    public double getPlaybackRate() {
        return this.zzSc;
    }

    public MediaInfo getMediaInfo() {
        return this.zzRK;
    }

    public long getStreamPosition() {
        return this.zzSf;
    }

    public boolean isMediaCommandSupported(long mediaCommand) {
        return (this.zzSg & mediaCommand) != 0L;
    }

    public double getStreamVolume() {
        return this.zzSh;
    }

    public boolean isMute() {
        return this.zzSi;
    }

    public long[] getActiveTrackIds() {
        return this.zzRY;
    }

    public JSONObject getCustomData() {
        return this.zzRJ;
    }

    public int getCurrentItemId() {
        return this.zzSa;
    }

    public int getLoadingItemId() {
        return this.zzSj;
    }

    public int getPreloadedItemId() {
        return this.zzSk;
    }

    public int getQueueRepeatMode() {
        return this.zzSl.getRepeatMode();
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzSl.zzlt();
    }

    public int getQueueItemCount() {
        return this.zzSl.getItemCount();
    }

    public MediaQueueItem getQueueItemById(int itemId) {
        return this.zzSl.zzaD(itemId);
    }

    public MediaQueueItem getQueueItem(int index) {
        return this.zzSl.zzaE(index);
    }

    public int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        int n3;
        int n4;
        long l;
        long l2;
        double d;
        int n5 = 0;
        long l3 = jSONObject.getLong("mediaSessionId");
        if (l3 != this.zzSb) {
            this.zzSb = l3;
            n5 |= 1;
        }
        if (jSONObject.has("playerState")) {
            int n6 = 0;
            String string2 = jSONObject.getString("playerState");
            if (string2.equals("IDLE")) {
                n6 = 1;
            } else if (string2.equals("PLAYING")) {
                n6 = 2;
            } else if (string2.equals("PAUSED")) {
                n6 = 3;
            } else if (string2.equals("BUFFERING")) {
                n6 = 4;
            }
            if (n6 != this.zzSd) {
                this.zzSd = n6;
                n5 |= 2;
            }
            if (n6 == 1 && jSONObject.has("idleReason")) {
                int n7 = 0;
                string2 = jSONObject.getString("idleReason");
                if (string2.equals("CANCELLED")) {
                    n7 = 2;
                } else if (string2.equals("INTERRUPTED")) {
                    n7 = 3;
                } else if (string2.equals("FINISHED")) {
                    n7 = 1;
                } else if (string2.equals("ERROR")) {
                    n7 = 4;
                }
                if (n7 != this.zzSe) {
                    this.zzSe = n7;
                    n5 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.zzSc != (d = jSONObject.getDouble("playbackRate"))) {
            this.zzSc = d;
            n5 |= 2;
        }
        if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = zzf.zze(jSONObject.getDouble("currentTime"))) != this.zzSf) {
            this.zzSf = l2;
            n5 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzSg) {
            this.zzSg = l;
            n5 |= 2;
        }
        if (jSONObject.has("volume") && (n & 1) == 0) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d2 = jSONObject2.getDouble("level");
            if (d2 != this.zzSh) {
                this.zzSh = d2;
                n5 |= 2;
            }
            if ((n4 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.zzSi) {
                this.zzSi = n4;
                n5 |= 2;
            }
        }
        boolean bl = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n8;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            n4 = jSONArray.length();
            lArray = new long[n4];
            for (n8 = 0; n8 < n4; ++n8) {
                lArray[n8] = jSONArray.getLong(n8);
            }
            if (this.zzRY == null) {
                bl = true;
            } else if (this.zzRY.length != n4) {
                bl = true;
            } else {
                for (n8 = 0; n8 < n4; ++n8) {
                    if (this.zzRY[n8] == lArray[n8]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.zzRY = lArray;
            }
        } else if (this.zzRY != null) {
            bl = true;
        }
        if (bl) {
            this.zzRY = lArray;
            n5 |= 2;
        }
        if (jSONObject.has("customData")) {
            this.zzRJ = jSONObject.getJSONObject("customData");
            n5 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            this.zzRK = new MediaInfo(jSONObject3);
            n5 |= 2;
            if (jSONObject3.has("metadata")) {
                n5 |= 4;
            }
        }
        if (jSONObject.has("currentItemId") && this.zzSa != (n3 = jSONObject.getInt("currentItemId"))) {
            this.zzSa = n3;
            n5 |= 2;
        }
        if (this.zzSk != (n2 = jSONObject.optInt("preloadedItemId", 0))) {
            this.zzSk = n2;
            n5 |= 0x10;
        }
        if (this.zzSj != (n4 = jSONObject.optInt("loadingItemId", 0))) {
            this.zzSj = n4;
            n5 |= 2;
        }
        if (!this.zzh(this.zzSd, this.zzSj)) {
            if (this.zzSl.zzg(jSONObject)) {
                n5 |= 8;
            }
        } else {
            this.zzSa = 0;
            this.zzSj = 0;
            this.zzSk = 0;
            if (this.zzSl.getItemCount() > 0) {
                this.zzSl.clear();
                n5 |= 8;
            }
        }
        return n5;
    }

    private boolean zzh(int n, int n2) {
        return n == 1 && n2 == 0;
    }

    private class zza {
        private int zzSm = 0;
        private List<MediaQueueItem> zzSn = new ArrayList<MediaQueueItem>();
        private SparseArray<Integer> zzSo = new SparseArray();

        zza() {
        }

        private boolean zzg(JSONObject jSONObject) throws JSONException {
            int n;
            String string2;
            boolean bl = false;
            if (jSONObject.has("repeatMode")) {
                String string3;
                int n2 = this.zzSm;
                string2 = string3 = jSONObject.getString("repeatMode");
                n = -1;
                switch (string2.hashCode()) {
                    case 1645952171: {
                        if (!string2.equals("REPEAT_OFF")) break;
                        n = 0;
                        break;
                    }
                    case 1645938909: {
                        if (!string2.equals("REPEAT_ALL")) break;
                        n = 1;
                        break;
                    }
                    case -962896020: {
                        if (!string2.equals("REPEAT_SINGLE")) break;
                        n = 2;
                        break;
                    }
                    case -1118317585: {
                        if (!string2.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                        n = 3;
                    }
                }
                switch (n) {
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    case 1: {
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                    }
                }
                if (this.zzSm != n2) {
                    this.zzSm = n2;
                    bl = true;
                }
            }
            if (jSONObject.has("items")) {
                JSONArray jSONArray = jSONObject.getJSONArray("items");
                int n3 = jSONArray.length();
                string2 = new SparseArray();
                for (n = 0; n < n3; ++n) {
                    string2.put(n, (Object)jSONArray.getJSONObject(n).getInt("itemId"));
                }
                MediaQueueItem[] mediaQueueItemArray = new MediaQueueItem[n3];
                for (int i = 0; i < n3; ++i) {
                    Integer n4 = (Integer)string2.get(i);
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    MediaQueueItem mediaQueueItem = this.zzaD(n4);
                    if (mediaQueueItem != null) {
                        bl |= mediaQueueItem.zzg(jSONObject2);
                        mediaQueueItemArray[i] = mediaQueueItem;
                        if (i == this.zzaF(n4)) continue;
                        bl = true;
                        continue;
                    }
                    bl = true;
                    if (n4 == MediaStatus.this.zzSa) {
                        mediaQueueItemArray[i] = new MediaQueueItem.Builder(MediaStatus.this.zzRK).build();
                        mediaQueueItemArray[i].zzg(jSONObject2);
                        continue;
                    }
                    mediaQueueItemArray[i] = new MediaQueueItem(jSONObject2);
                }
                if (this.zzSn.size() != n3) {
                    bl = true;
                }
                this.zza(mediaQueueItemArray);
            }
            return bl;
        }

        public int getRepeatMode() {
            return this.zzSm;
        }

        public List<MediaQueueItem> zzlt() {
            return Collections.unmodifiableList(this.zzSn);
        }

        public int getItemCount() {
            return this.zzSn.size();
        }

        public MediaQueueItem zzaD(int n) {
            Integer n2 = (Integer)this.zzSo.get(n);
            return n2 == null ? null : this.zzSn.get(n2);
        }

        public MediaQueueItem zzaE(int n) {
            if (n < 0 || n >= this.zzSn.size()) {
                return null;
            }
            return this.zzSn.get(n);
        }

        private Integer zzaF(int n) {
            return (Integer)this.zzSo.get(n);
        }

        private void zza(MediaQueueItem[] mediaQueueItemArray) {
            this.zzSn.clear();
            this.zzSo.clear();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
                this.zzSn.add(mediaQueueItem);
                this.zzSo.put(mediaQueueItem.getItemId(), (Object)i);
            }
        }

        private void clear() {
            this.zzSm = 0;
            this.zzSn.clear();
            this.zzSo.clear();
        }
    }
}

