/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzlg;
import com.google.android.gms.internal.zzqb;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqg;
import com.google.android.gms.tagmanager.zzbg;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class zzqh {
    public static final Integer zzaPM = 0;
    public static final Integer zzaPN = 1;
    private final Context mContext;
    private final ExecutorService zzaNb;

    public zzqh(Context context) {
        this(context, Executors.newSingleThreadExecutor());
    }

    zzqh(Context context, ExecutorService executorService) {
        this.mContext = context;
        this.zzaNb = executorService;
    }

    public void zza(final String string2, final Integer n, final zzqb zzqb2, final zzqg zzqg2) {
        this.zzaNb.execute(new Runnable(){

            @Override
            public void run() {
                zzqh.this.zzb(string2, n, zzqb2, zzqg2);
            }
        });
    }

    void zzb(String string2, Integer n, zzqb zzqb2, zzqg zzqg2) {
        Object object;
        InputStream inputStream;
        zzbg.zzaB("DiskLoader: Starting to load resource from Disk.");
        try {
            inputStream = new FileInputStream(this.zzfb(string2));
            object = zzqb2.zzt(this.zzm(inputStream));
            if (object != null) {
                zzbg.zzaB("Saved resource loaded: " + this.zzfc(string2));
                zzqg2.zza(Status.zzXP, object, zzaPN, this.zzfa(string2));
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.zzaz("Saved resource not found: " + this.zzfc(string2));
        }
        catch (zzqf.zzg zzg2) {
            zzbg.zzaz("Saved resource is corrupted: " + this.zzfc(string2));
        }
        if (n == null) {
            zzqg2.zza(Status.zzXR, null, null, 0L);
            return;
        }
        try {
            inputStream = this.mContext.getResources().openRawResource(n.intValue());
            if (inputStream != null && (object = zzqb2.zzt(this.zzm(inputStream))) != null) {
                zzbg.zzaB("Default resource loaded: " + this.mContext.getResources().getResourceEntryName(n.intValue()));
                zzqg2.zza(Status.zzXP, object, zzaPM, 0L);
                return;
            }
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbg.zzaz("Default resource not found. ID: " + n);
        }
        catch (zzqf.zzg zzg3) {
            zzbg.zzaz("Default resource resource is corrupted: " + n);
        }
        zzqg2.zza(Status.zzXR, null, null, 0L);
    }

    public void zze(final String string2, final byte[] byArray) {
        this.zzaNb.execute(new Runnable(){

            @Override
            public void run() {
                zzqh.this.zzf(string2, byArray);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzf(String string2, byte[] byArray) {
        String string3;
        FileOutputStream fileOutputStream;
        File file = this.zzfb(string2);
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string4 = "Error opening resource file for writing";
            zzbg.zzaz(string4);
            return;
        }
        try {
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            string3 = "Error writing resource to disk. Removing resource from disk";
            zzbg.zzaz(string3);
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
                zzbg.zzaB("Resource " + string2 + " saved on Disk.");
            }
            catch (IOException iOException) {
                string3 = "Error closing stream for writing resource to disk";
                zzbg.zzaz(string3);
            }
        }
    }

    public long zzfa(String string2) {
        File file = this.zzfb(string2);
        return file.exists() ? file.lastModified() : 0L;
    }

    File zzfb(String string2) {
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, this.zzfc(string2));
    }

    private String zzfc(String string2) {
        return "resource_" + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zzm(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            zzlg.zza(inputStream, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            zzbg.zzaC("Failed to read the resource from disk");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzaC("Error closing stream for reading resource from disk");
                return null;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }
}

