/**************************************************************************
   mystuff - custom menu in popup window

   Copyright 2010-2016 Michael Cornelison
   source URL: kornelix.net
   contact: kornelix@posteo.de
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.

***************************************************************************/

#include "zfuncs.h"

#define fversion "mystuff 2.5"                                                   //  version


//  main program

int main(int argc, char *argv[])
{
   void callbackfunc(cchar *menu);

   char     *file, menufile[200];
   
   if (argc > 1 && strmatch(argv[1],"-v")) {
      printf(fversion "\n");                                                     //  print program and version
      exit(0);
   }

   gtk_init(&argc,&argv);                                                        //  initz. GTK
   zinitapp("mystuff");                                                          //  get app directories

   get_hardware_info();                                                          //  v.2.2
   
   if (argc > 1) file = argv[1];                                                 //  multiple pages   v.2.4
   else file = (char *) "menu.txt";
   snprintf(menufile,199,"%s/%s",get_zuserdir(),file);                           //  menu file /home/<user>/.mystuff/menu.txt
   
   gmenuz(null,fversion,menufile,callbackfunc);                                  //  create popup menu window
   
   gtk_main();                                                                   //  process window events
   return 0;
}


//  popup menu window calls this function when a menu is clicked

void callbackfunc(cchar *menu)
{
   if (strmatch(menu,"quit")) {
      gtk_main_quit();                                                           //  exit application
      return;
   }

   shell_ack("%s &",menu);                                                       //  run command
   return;
}


//  supply unused zdialog callback function

void KBstate(GdkEventKey *event, int state) 
{ return; }




