/**
*** \file informationitemoptions.cpp
*** \brief informationitemoptions.h implementation.
*** \details Implementation file for informationitemoptions.h.
**/

/*
** This file is part of moonphase.
** Copyright (C) 2014-2018 by Alan Wise <awisesoftware@gmail.com>.
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/**
*** \brief informationitemoptions.cpp identifier.
*** \details Identifier for informationitemoptions.cpp.
**/
#define   INFORMATIONITEMOPTIONS_CPP


/****
*****
***** INCLUDES
*****
****/

#include  "informationitemoptions.h"
#ifdef    DEBUG_OPTIONS_CPP
#ifndef   USE_DEBUGLOG
#define   USE_DEBUGLOG
#endif    /* USE_DEBUGLOG */
#endif    /* DEBUG_OPTIONS_CPP */
#include  "debuglog.h"
#include  "messagelog.h"


/****
*****
***** DEFINES
*****
****/


/****
*****
***** DATA TYPES
*****
****/


/****
*****
***** PROTOTYPES
*****
****/


/****
*****
***** DATA
*****
****/


/****
*****
***** VARIABLES
*****
****/


/****
*****
***** FUNCTIONS
*****
****/

INFORMATIONITEMOPTIONS_C::INFORMATIONITEMOPTIONS_C(void)
{
  DEBUGLOG_Printf0(
      "INFORMATIONITEMOPTIONS_C::INFORMATIONITEMOPTIONS_C()");
  DEBUGLOG_LogIn();

  m_DateTimeOptions.Flags=DATETIMEFLAG_4DIGITYEAR;
  m_DateTimeOptions.DateStyleIndex=-1;
  m_UnitFormatIndex=-1;

  DEBUGLOG_LogOut();
  return;
}

INFORMATIONITEMOPTIONS_C::INFORMATIONITEMOPTIONS_C(
    INFORMATIONITEMOPTIONS_C const &Options)
{
  DEBUGLOG_Printf1(
      "INFORMATIONITEMOPTIONS_C::INFORMATIONITEMOPTIONS_C(%p)",&Options);
  DEBUGLOG_LogIn();

  *this=Options;

  DEBUGLOG_LogOut();
  return;
}

INFORMATIONITEMOPTIONS_C::~INFORMATIONITEMOPTIONS_C(void)
{
  DEBUGLOG_Printf0("INFORMATIONITEMOPTIONS_C::~INFORMATIONITEMOPTIONS_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}

INFORMATIONITEMOPTIONS_C & INFORMATIONITEMOPTIONS_C::operator=(
    INFORMATIONITEMOPTIONS_C const &RHS)
{
  DEBUGLOG_Printf1("INFORMATIONITEMOPTIONS_C::operator=(%p)",&RHS);
  DEBUGLOG_LogIn();

  m_DateTimeOptions=RHS.m_DateTimeOptions;
  m_UnitFormatIndex=RHS.m_UnitFormatIndex;

  DEBUGLOG_LogOut();
  return(*this);
}

bool INFORMATIONITEMOPTIONS_C::operator==(
    INFORMATIONITEMOPTIONS_C const &RHS) const
{
  bool Return;


  DEBUGLOG_Printf1("INFORMATIONITEMOPTIONS_C::operator==(%p)",&RHS);
  DEBUGLOG_LogIn();

  Return=
      (m_DateTimeOptions==RHS.m_DateTimeOptions) &&
      (m_UnitFormatIndex==RHS.m_UnitFormatIndex);

  DEBUGLOG_LogOut();
  return(Return);
}

bool INFORMATIONITEMOPTIONS_C::operator!=(
    INFORMATIONITEMOPTIONS_C const &RHS) const
{
  DEBUGLOG_Printf1("INFORMATIONITEMOPTIONS_C::operator!=(%p)",&RHS);
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(!((*this)==RHS));
}

void INFORMATIONITEMOPTIONS_C::Convert(DATETIMEOPTIONS_T &DateTimeOptions)
{
  DEBUGLOG_Printf1("INFORMATIONITEMOPTIONS_C::Convert(%p)",&DateTimeOptions);
  DEBUGLOG_LogIn();

  memcpy(&DateTimeOptions,&m_DateTimeOptions,sizeof(DateTimeOptions));

  DEBUGLOG_LogOut();
  return;
}

bool INFORMATIONITEMOPTIONS_C::Get24HourFormatFlag(void) const
{
  DEBUGLOG_Printf0("INFORMATIONITEMOPTIONS_C::Get24HourFormatFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_DateTimeOptions.Flags&DATETIMEFLAG_24HOURFORMAT);
}

bool INFORMATIONITEMOPTIONS_C::Get4DigitYearFlag(void) const
{
  DEBUGLOG_Printf0("INFORMATIONITEMOPTIONS_C::Get4DigitYearFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_DateTimeOptions.Flags&DATETIMEFLAG_4DIGITYEAR);
}

bool INFORMATIONITEMOPTIONS_C::GetLongDayOfWeekFormatFlag(void) const
{
  DEBUGLOG_Printf0("INFORMATIONITEMOPTIONS_C::GetLongDayOfWeekFormatFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_DateTimeOptions.Flags&DATETIMEFLAG_LONGDAYOFWEEKFORMAT);
}

bool INFORMATIONITEMOPTIONS_C::GetLongMonthFormatFlag(void) const
{
  DEBUGLOG_Printf0("INFORMATIONITEMOPTIONS_C::GetLongMonthFormatFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_DateTimeOptions.Flags&DATETIMEFLAG_LONGMONTHFORMAT);
}

bool INFORMATIONITEMOPTIONS_C::GetShowDayOfWeekFlag(void) const
{
  DEBUGLOG_Printf0("INFORMATIONITEMOPTIONS_C::GetShowDayOfWeekFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_DateTimeOptions.Flags&DATETIMEFLAG_SHOWDAYOFWEEK);
}

bool INFORMATIONITEMOPTIONS_C::GetShowSecondsFlag(void) const
{
  DEBUGLOG_Printf0("INFORMATIONITEMOPTIONS_C::GetShowSecondsFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_DateTimeOptions.Flags&DATETIMEFLAG_SHOWSECONDS);
}

int INFORMATIONITEMOPTIONS_C::GetUnitFormatIndex(void) const
{
  DEBUGLOG_Printf0("INFORMATIONITEMOPTIONS_C::GetUnitFormatIndex()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_UnitFormatIndex);
}

void INFORMATIONITEMOPTIONS_C::Set24HourFormatFlag(bool Flag)
{
  DEBUGLOG_Printf1("INFORMATIONITEMOPTIONS_C::Set24HourFormatFlag(%u)",Flag);
  DEBUGLOG_LogIn();

  if (Flag==0)
    m_DateTimeOptions.Flags&=~DATETIMEFLAG_24HOURFORMAT;
  else
    m_DateTimeOptions.Flags|=DATETIMEFLAG_24HOURFORMAT;

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONITEMOPTIONS_C::Set4DigitYearFlag(bool Flag)
{
  DEBUGLOG_Printf1("INFORMATIONITEMOPTIONS_C::Set4DigitYearFlag(%u)",Flag);
  DEBUGLOG_LogIn();

  if (Flag==0)
    m_DateTimeOptions.Flags&=~DATETIMEFLAG_4DIGITYEAR;
  else
    m_DateTimeOptions.Flags|=DATETIMEFLAG_4DIGITYEAR;

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONITEMOPTIONS_C::SetLongDayOfWeekFormatFlag(bool Flag)
{
  DEBUGLOG_Printf1(
      "INFORMATIONITEMOPTIONS_C::SetLongDayOfWeekFormatFlag(%u)",Flag);
  DEBUGLOG_LogIn();

  if (Flag==0)
    m_DateTimeOptions.Flags&=~DATETIMEFLAG_LONGDAYOFWEEKFORMAT;
  else
    m_DateTimeOptions.Flags|=DATETIMEFLAG_LONGDAYOFWEEKFORMAT;

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONITEMOPTIONS_C::SetLongMonthFormatFlag(bool Flag)
{
  DEBUGLOG_Printf1("INFORMATIONITEMOPTIONS_C::SetLongMonthFormatFlag(%u)",Flag);
  DEBUGLOG_LogIn();

  if (Flag==0)
    m_DateTimeOptions.Flags&=~DATETIMEFLAG_LONGMONTHFORMAT;
  else
    m_DateTimeOptions.Flags|=DATETIMEFLAG_LONGMONTHFORMAT;

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONITEMOPTIONS_C::SetShowDayOfWeekFlag(bool Flag)
{
  DEBUGLOG_Printf1("INFORMATIONITEMOPTIONS_C::SetShowDayOfWeekFlag(%u)",Flag);
  DEBUGLOG_LogIn();

  if (Flag==0)
    m_DateTimeOptions.Flags&=~DATETIMEFLAG_SHOWDAYOFWEEK;
  else
    m_DateTimeOptions.Flags|=DATETIMEFLAG_SHOWDAYOFWEEK;

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONITEMOPTIONS_C::SetShowSecondsFlag(bool Flag)
{
  DEBUGLOG_Printf1("INFORMATIONITEMOPTIONS_C::SetShowSecondsFlag(%u)",Flag);
  DEBUGLOG_LogIn();

  if (Flag==0)
    m_DateTimeOptions.Flags&=~DATETIMEFLAG_SHOWSECONDS;
  else
    m_DateTimeOptions.Flags|=DATETIMEFLAG_SHOWSECONDS;

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONITEMOPTIONS_C::SetUnitFormatIndex(int Index)
{
  DEBUGLOG_Printf1("INFORMATIONITEMOPTIONS_C::SetUnitFormatIndex(%d)",Index);
  DEBUGLOG_LogIn();

  m_UnitFormatIndex=Index;

  DEBUGLOG_LogOut();
  return;
}

INFORMATIONPANELITEMOPTIONS_C::INFORMATIONPANELITEMOPTIONS_C(void)
{
  DEBUGLOG_Printf0(
      "INFORMATIONPANELITEMOPTIONS_C::INFORMATIONPANELITEMOPTIONS_C()");
  DEBUGLOG_LogIn();

  m_BackgroundColor=QColor();
  m_Font=QFont();
  m_Margin=0;
  m_TextColor=QColor();
  m_UseSystemBackgroundColorFlag=true;
  m_UseSystemFontFlag=true;
  m_UseSystemTextColorFlag=true;

  DEBUGLOG_LogOut();
  return;
}

INFORMATIONPANELITEMOPTIONS_C::~INFORMATIONPANELITEMOPTIONS_C(void)
{
  DEBUGLOG_Printf0(
      "INFORMATIONPANELITEMOPTIONS_C::~INFORMATIONPANELITEMOPTIONS_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}

bool INFORMATIONPANELITEMOPTIONS_C::operator==(
    INFORMATIONPANELITEMOPTIONS_C const &RHS) const
{
  bool Return;


  DEBUGLOG_Printf1("INFORMATIONPANELITEMOPTIONS_C::operator==(%p)",&RHS);
  DEBUGLOG_LogIn();

  Return=INFORMATIONITEMOPTIONS_C::operator==(RHS) &&
      (m_BackgroundColor==RHS.m_BackgroundColor) &&
      (m_Font==RHS.m_Font) &&
      (m_Margin==RHS.m_Margin) &&
      (m_TextColor==RHS.m_TextColor) &&
      (m_UseSystemBackgroundColorFlag==RHS.m_UseSystemBackgroundColorFlag) &&
      (m_UseSystemFontFlag==RHS.m_UseSystemFontFlag) &&
      (m_UseSystemTextColorFlag==RHS.m_UseSystemTextColorFlag);

  DEBUGLOG_LogOut();
  return(Return);
}

bool INFORMATIONPANELITEMOPTIONS_C::operator!=(
    INFORMATIONPANELITEMOPTIONS_C const &RHS) const
{
  DEBUGLOG_Printf1("INFORMATIONPANELITEMOPTIONS_C::operator!=(%p)",&RHS);
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(!((*this)==RHS));
}

QString INFORMATIONPANELITEMOPTIONS_C::BuildStyleSheetString(void) const
{
  QString StyleSheetString;


  DEBUGLOG_Printf0("INFORMATIONPANELITEMOPTIONS_C::BuildStyleSheetString()");
  DEBUGLOG_LogIn();

  /* Prepare the text color string. */
  if (GetTextColor()!=QColor())
    StyleSheetString=QString("color: rgb(%1,%2,%3")
        .arg(GetTextColor().red())
        .arg(GetTextColor().green())
        .arg(GetTextColor().blue())+");";

  /* Prepare the background color string. */
  if (GetBackgroundColor()!=QColor())
    StyleSheetString+=QString("background-color: rgb(%1,%2,%3")
      .arg(GetBackgroundColor().red())
      .arg(GetBackgroundColor().green())
      .arg(GetBackgroundColor().blue())+");";

  DEBUGLOG_LogOut();
  return(StyleSheetString);
}

QColor INFORMATIONPANELITEMOPTIONS_C::GetBackgroundColor(void) const
{
  DEBUGLOG_Printf0("INFORMATIONPANELITEMOPTIONS_C::GetBackgroundColor()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_BackgroundColor);
}

QFont INFORMATIONPANELITEMOPTIONS_C::GetFont(void) const
{
  DEBUGLOG_Printf0("INFORMATIONPANELITEMOPTIONS_C::GetFont()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_Font);
}

int INFORMATIONPANELITEMOPTIONS_C::GetMargin(void) const
{
  DEBUGLOG_Printf0("INFORMATIONPANELITEMOPTIONS_C::GetMargin()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_Margin);
}

QColor INFORMATIONPANELITEMOPTIONS_C::GetTextColor(void) const
{
  DEBUGLOG_Printf0("INFORMATIONPANELITEMOPTIONS_C::GetTextColor()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_TextColor);
}

bool INFORMATIONPANELITEMOPTIONS_C::GetUseSystemBackgroundColorFlag(void) const
{
  DEBUGLOG_Printf0(
      "INFORMATIONPANELITEMOPTIONS_C::GetUseSystemBackgroundColorFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_UseSystemBackgroundColorFlag);
}

bool INFORMATIONPANELITEMOPTIONS_C::GetUseSystemFontFlag(void) const
{
  DEBUGLOG_Printf0("INFORMATIONPANELITEMOPTIONS_C::GetUseSystemFontFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_UseSystemFontFlag);
}

bool INFORMATIONPANELITEMOPTIONS_C::GetUseSystemTextColorFlag(void) const
{
  DEBUGLOG_Printf0(
      "INFORMATIONPANELITEMOPTIONS_C::GetUseSystemTextColorFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_UseSystemTextColorFlag);
}

void INFORMATIONPANELITEMOPTIONS_C::SetBackgroundColor(QColor Color)
{
  DEBUGLOG_Printf1(
      "INFORMATIONPANELITEMOPTIONS_C::SetBackgroundColor(%p)",&Color);
  DEBUGLOG_LogIn();

  m_BackgroundColor=Color;

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONPANELITEMOPTIONS_C::SetFont(QFont Font)
{
  DEBUGLOG_Printf1("INFORMATIONPANELITEMOPTIONS_C::SetFont(%p)",&Font);
  DEBUGLOG_LogIn();

  m_Font=Font;

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONPANELITEMOPTIONS_C::SetMargin(int Margin)
{
  DEBUGLOG_Printf1("INFORMATIONPANELITEMOPTIONS_C::SetMargin(%p)",&Margin);
  DEBUGLOG_LogIn();

  m_Margin=Margin;

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONPANELITEMOPTIONS_C::SetTextColor(QColor Color)
{
  DEBUGLOG_Printf1("INFORMATIONPANELITEMOPTIONS_C::SetTextColor(%p)",&Color);
  DEBUGLOG_LogIn();

  m_TextColor=Color;

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONPANELITEMOPTIONS_C::SetUseSystemBackgroundColorFlag(bool Flag)
{
  DEBUGLOG_Printf1("INFORMATIONPANELITEMOPTIONS_C::"
      "SetUseSystemBackgroundColorFlag(%u)",Flag);
  DEBUGLOG_LogIn();

  m_UseSystemBackgroundColorFlag=Flag;
  if (Flag==true)
    SetBackgroundColor(QColor());

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONPANELITEMOPTIONS_C::SetUseSystemFontFlag(bool Flag)
{
  DEBUGLOG_Printf1(
      "INFORMATIONPANELITEMOPTIONS_C::SetUseSystemFontFlag(%u)",Flag);
  DEBUGLOG_LogIn();

  m_UseSystemFontFlag=Flag;
  if (Flag==true)
    SetFont(QFont());

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONPANELITEMOPTIONS_C::SetUseSystemTextColorFlag(bool Flag)
{
  DEBUGLOG_Printf1(
      "INFORMATIONPANELITEMOPTIONS_C::SetUseSystemTextColorFlag(%u)",Flag);
  DEBUGLOG_LogIn();

  m_UseSystemTextColorFlag=Flag;
  if (Flag==true)
    SetTextColor(QColor());

  DEBUGLOG_LogOut();
  return;
}

TOOLTIPITEMOPTIONS_C::TOOLTIPITEMOPTIONS_C(void)
{
  DEBUGLOG_Printf0("TOOLTIPITEMOPTIONS_C::TOOLTIPITEMOPTIONS_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}

TOOLTIPITEMOPTIONS_C::~TOOLTIPITEMOPTIONS_C(void)
{
  DEBUGLOG_Printf0("TOOLTIPITEMOPTIONS_C::~TOOLTIPITEMOPTIONS_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}


#undef    INFORMAIONITEMOPTIONS_CPP


/**
*** informationitemoptions.cpp
**/
