/**
*** \file informationitem.cpp
*** \brief informationitem.h implementation.
*** \details Implementation file for informationitem.h.
**/

/*
** This file is part of moonphase.
** Copyright (C) 2014-2018 by Alan Wise <awisesoftware@gmail.com>.
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/**
*** \brief informationitem.cpp identifier.
*** \details Identifier for informationitem.cpp.
**/
#define   INFORMATIONITEM_CPP


/****
*****
***** INCLUDES
*****
****/

#include  "informationitem.h"
#ifdef    DEBUG_INFORMATIONITEM_CPP
#ifndef   USE_DEBUGLOG
#define   USE_DEBUGLOG
#endif    /* USE_DEBUGLOG */
#endif    /* DEBUG_INFORMATIONITEM_CPP */
#include  "debuglog.h"
#include  "messagelog.h"


/****
*****
***** DEFINES
*****
****/


/****
*****
***** DATA TYPES
*****
****/


/****
*****
***** PROTOTYPES
*****
****/


/****
*****
***** DATA
*****
****/


/****
*****
***** VARIABLES
*****
****/


/****
*****
***** FUNCTIONS
*****
****/

INFORMATIONITEM_C::INFORMATIONITEM_C(void)
{
  DEBUGLOG_Printf0("INFORMATIONITEM_C::INFORMATIONITEM_C()");
  DEBUGLOG_LogIn();

  m_InformationIndex=-1;

  DEBUGLOG_LogOut();
  return;
}

INFORMATIONITEM_C::~INFORMATIONITEM_C(void)
{
  DEBUGLOG_Printf0("INFORMATIONITEM_C::~INFORMATIONITEM_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}

int INFORMATIONITEM_C::GetInformationIndex(void)
{
  DEBUGLOG_Printf0("INFORMATIONITEM_C::GetInformationIndex()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_InformationIndex);
}

int INFORMATIONITEM_C::GetUnitFormatIndex(void)
{
  DEBUGLOG_Printf0("INFORMATIONITEM_C::GetUnitFormatIndex()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_Options.GetUnitFormatIndex());
}

void INFORMATIONITEM_C::SetInformationIndex(int Index)
{
  DEBUGLOG_Printf1("INFORMATIONITEM_C::SetInformationIndex(%d)",Index);
  DEBUGLOG_LogIn();

  m_InformationIndex=Index;

  DEBUGLOG_LogOut();
  return;
}

void INFORMATIONITEM_C::SetUnitFormatIndex(int Index)
{
  DEBUGLOG_Printf1("INFORMATIONITEM_C::SetUnitFormatIndex(%d)",Index);
  DEBUGLOG_LogIn();

  m_Options.SetUnitFormatIndex(Index);

  DEBUGLOG_LogOut();
  return;
}

INFORMATIONPANELITEM_C::INFORMATIONPANELITEM_C(void)
{
  DEBUGLOG_Printf0("INFORMATIONPANELITEM_C::INFORMATIONPANELITEM_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}

INFORMATIONPANELITEM_C::~INFORMATIONPANELITEM_C(void)
{
  DEBUGLOG_Printf0("INFORMATIONPANELITEM_C::~INFORMATIONPANELITEM_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}

INFORMATIONPANELITEMOPTIONS_C const & INFORMATIONPANELITEM_C::GetOptions(void)
{
  DEBUGLOG_Printf0("INFORMATIONPANELITEM_C::GetOptions()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_Options);
}

void INFORMATIONPANELITEM_C::SetOptions(
    INFORMATIONPANELITEMOPTIONS_C const &Options)
{
  DEBUGLOG_Printf1("INFORMATIONPANELITEM_C::SetOptions(%p)",&Options);
  DEBUGLOG_LogIn();

  m_Options=Options;

  DEBUGLOG_LogOut();
  return;
}


#undef    INFORMATIONITEM_CPP


/**
*** informationitem.cpp
**/
