/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   ISO 3166 countries & UN M.49 regions

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

// ------------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iso3166_list" rake target.
// ------------------------------------------------------------------------

#include "common/common_pch.h"

#include "common/iso3166.h"

namespace mtx::iso3166 {

std::vector<region_t> g_regions;

void
init() {
  g_regions.reserve(323);

  g_regions.emplace_back(""s,   ""s,      2, u8"Africa"s,                                               u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     19, u8"Americas"s,                                             u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,    142, u8"Asia"s,                                                 u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     53, u8"Australia and New Zealand"s,                            u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     29, u8"Caribbean"s,                                            u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     13, u8"Central America"s,                                      u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,    143, u8"Central Asia"s,                                         u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,    830, u8"Channel Islands"s,                                      u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     14, u8"Eastern Africa"s,                                       u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     30, u8"Eastern Asia"s,                                         u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,    151, u8"Eastern Europe"s,                                       u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,    150, u8"Europe"s,                                               u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,    419, u8"Latin America and the Caribbean"s,                      u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     54, u8"Melanesia"s,                                            u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     57, u8"Micronesia"s,                                           u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     17, u8"Middle Africa"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     15, u8"Northern Africa"s,                                      u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     21, u8"Northern America"s,                                     u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,    154, u8"Northern Europe"s,                                      u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,      9, u8"Oceania"s,                                              u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     61, u8"Polynesia"s,                                            u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,    680, u8"Sark"s,                                                 u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,      5, u8"South America"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     35, u8"South-eastern Asia"s,                                   u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     18, u8"Southern Africa"s,                                      u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     34, u8"Southern Asia"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     39, u8"Southern Europe"s,                                      u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,    202, u8"Sub-Saharan Africa"s,                                   u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,     11, u8"Western Africa"s,                                       u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,    145, u8"Western Asia"s,                                         u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,    155, u8"Western Europe"s,                                       u8""s                                                                                                                              );
  g_regions.emplace_back(""s,   ""s,      1, u8"World"s,                                                u8""s                                                                                                                              );
  g_regions.emplace_back("AA"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("AD"s, "AND"s,  20, u8"Andorra"s,                                              u8"Principality of Andorra"s                                                                                                       );
  g_regions.emplace_back("AE"s, "ARE"s, 784, u8"United Arab Emirates"s,                                 u8""s                                                                                                                              );
  g_regions.emplace_back("AF"s, "AFG"s,   4, u8"Afghanistan"s,                                          u8"Islamic Republic of Afghanistan"s                                                                                               );
  g_regions.emplace_back("AG"s, "ATG"s,  28, u8"Antigua and Barbuda"s,                                  u8""s                                                                                                                              );
  g_regions.emplace_back("AI"s, "AIA"s, 660, u8"Anguilla"s,                                             u8""s                                                                                                                              );
  g_regions.emplace_back("AL"s, "ALB"s,   8, u8"Albania"s,                                              u8"Republic of Albania"s                                                                                                           );
  g_regions.emplace_back("AM"s, "ARM"s,  51, u8"Armenia"s,                                              u8"Republic of Armenia"s                                                                                                           );
  g_regions.emplace_back("AO"s, "AGO"s,  24, u8"Angola"s,                                               u8"Republic of Angola"s                                                                                                            );
  g_regions.emplace_back("AQ"s, "ATA"s,  10, u8"Antarctica"s,                                           u8"All land and ice shelves south of the 60th parallel south"s                                                                     );
  g_regions.emplace_back("AR"s, "ARG"s,  32, u8"Argentina"s,                                            u8"Argentine Republic"s                                                                                                            );
  g_regions.emplace_back("AS"s, "ASM"s,  16, u8"American Samoa"s,                                       u8"Territory of American Samoa"s                                                                                                   );
  g_regions.emplace_back("AT"s, "AUT"s,  40, u8"Austria"s,                                              u8"Republic of Austria"s                                                                                                           );
  g_regions.emplace_back("AU"s, "AUS"s,  36, u8"Australia"s,                                            u8"Commonwealth of Australia"s                                                                                                     );
  g_regions.emplace_back("AW"s, "ABW"s, 533, u8"Aruba"s,                                                u8""s                                                                                                                              );
  g_regions.emplace_back("AX"s, "ALA"s, 248, u8"Åland Islands"s,                                        u8"Åland"s                                                                                                                         );
  g_regions.emplace_back("AZ"s, "AZE"s,  31, u8"Azerbaijan"s,                                           u8"Republic of Azerbaijan"s                                                                                                        );
  g_regions.emplace_back("BA"s, "BIH"s,  70, u8"Bosnia and Herzegovina"s,                               u8""s                                                                                                                              );
  g_regions.emplace_back("BB"s, "BRB"s,  52, u8"Barbados"s,                                             u8""s                                                                                                                              );
  g_regions.emplace_back("BD"s, "BGD"s,  50, u8"Bangladesh"s,                                           u8"People's Republic of Bangladesh"s                                                                                               );
  g_regions.emplace_back("BE"s, "BEL"s,  56, u8"Belgium"s,                                              u8"Kingdom of Belgium"s                                                                                                            );
  g_regions.emplace_back("BF"s, "BFA"s, 854, u8"Burkina Faso"s,                                         u8""s                                                                                                                              );
  g_regions.emplace_back("BG"s, "BGR"s, 100, u8"Bulgaria"s,                                             u8"Republic of Bulgaria"s                                                                                                          );
  g_regions.emplace_back("BH"s, "BHR"s,  48, u8"Bahrain"s,                                              u8"Kingdom of Bahrain"s                                                                                                            );
  g_regions.emplace_back("BI"s, "BDI"s, 108, u8"Burundi"s,                                              u8"Republic of Burundi"s                                                                                                           );
  g_regions.emplace_back("BJ"s, "BEN"s, 204, u8"Benin"s,                                                u8"Republic of Benin"s                                                                                                             );
  g_regions.emplace_back("BL"s, "BLM"s, 652, u8"Saint Barthélemy"s,                                     u8"Collectivity of Saint-Barthélemy"s                                                                                              );
  g_regions.emplace_back("BM"s, "BMU"s,  60, u8"Bermuda"s,                                              u8""s                                                                                                                              );
  g_regions.emplace_back("BN"s, "BRN"s,  96, u8"Brunei Darussalam"s,                                    u8"Nation of Brunei, the Abode of Peace"s                                                                                          );
  g_regions.emplace_back("BO"s, "BOL"s,  68, u8"Bolivia (Plurinational State of)"s,                     u8"Plurinational State of Bolivia"s                                                                                                );
  g_regions.emplace_back("BQ"s, "BES"s, 535, u8"Bonaire, Sint Eustatius and Saba"s,                     u8""s                                                                                                                              );
  g_regions.emplace_back("BR"s, "BRA"s,  76, u8"Brazil"s,                                               u8"Federative Republic of Brazil"s                                                                                                 );
  g_regions.emplace_back("BS"s, "BHS"s,  44, u8"Bahamas"s,                                              u8"Commonwealth of The Bahamas"s                                                                                                   );
  g_regions.emplace_back("BT"s, "BTN"s,  64, u8"Bhutan"s,                                               u8"Kingdom of Bhutan"s                                                                                                             );
  g_regions.emplace_back("BV"s, "BVT"s,  74, u8"Bouvet Island"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("BW"s, "BWA"s,  72, u8"Botswana"s,                                             u8"Republic of Botswana"s                                                                                                          );
  g_regions.emplace_back("BY"s, "BLR"s, 112, u8"Belarus"s,                                              u8"Republic of Belarus"s                                                                                                           );
  g_regions.emplace_back("BZ"s, "BLZ"s,  84, u8"Belize"s,                                               u8""s                                                                                                                              );
  g_regions.emplace_back("CA"s, "CAN"s, 124, u8"Canada"s,                                               u8""s                                                                                                                              );
  g_regions.emplace_back("CC"s, "CCK"s, 166, u8"Cocos (Keeling) Islands"s,                              u8"Territory of Cocos (Keeling) Islands"s                                                                                          );
  g_regions.emplace_back("CD"s, "COD"s, 180, u8"Congo (the Democratic Republic of the)"s,               u8"Democratic Republic of the Congo"s                                                                                              );
  g_regions.emplace_back("CF"s, "CAF"s, 140, u8"Central African Republic"s,                             u8""s                                                                                                                              );
  g_regions.emplace_back("CG"s, "COG"s, 178, u8"Congo"s,                                                u8"Republic of the Congo"s                                                                                                         );
  g_regions.emplace_back("CH"s, "CHE"s, 756, u8"Switzerland"s,                                          u8"Swiss Confederation"s                                                                                                           );
  g_regions.emplace_back("CI"s, "CIV"s, 384, u8"Côte d'Ivoire"s,                                        u8"Republic of Côte d'Ivoire"s                                                                                                     );
  g_regions.emplace_back("CK"s, "COK"s, 184, u8"Cook Islands"s,                                         u8""s                                                                                                                              );
  g_regions.emplace_back("CL"s, "CHL"s, 152, u8"Chile"s,                                                u8"Republic of Chile"s                                                                                                             );
  g_regions.emplace_back("CM"s, "CMR"s, 120, u8"Cameroon"s,                                             u8"Republic of Cameroon"s                                                                                                          );
  g_regions.emplace_back("CN"s, "CHN"s, 156, u8"China"s,                                                u8"People's Republic of China"s                                                                                                    );
  g_regions.emplace_back("CO"s, "COL"s, 170, u8"Colombia"s,                                             u8"Republic of Colombia"s                                                                                                          );
  g_regions.emplace_back("CR"s, "CRI"s, 188, u8"Costa Rica"s,                                           u8"Republic of Costa Rica"s                                                                                                        );
  g_regions.emplace_back("CU"s, "CUB"s, 192, u8"Cuba"s,                                                 u8"Republic of Cuba"s                                                                                                              );
  g_regions.emplace_back("CV"s, "CPV"s, 132, u8"Cabo Verde"s,                                           u8"Republic of Cabo Verde"s                                                                                                        );
  g_regions.emplace_back("CW"s, "CUW"s, 531, u8"Curaçao"s,                                              u8"Country of Curaçao"s                                                                                                            );
  g_regions.emplace_back("CX"s, "CXR"s, 162, u8"Christmas Island"s,                                     u8"Territory of Christmas Island"s                                                                                                 );
  g_regions.emplace_back("CY"s, "CYP"s, 196, u8"Cyprus"s,                                               u8"Republic of Cyprus"s                                                                                                            );
  g_regions.emplace_back("CZ"s, "CZE"s, 203, u8"Czechia"s,                                              u8"Czech Republic"s                                                                                                                );
  g_regions.emplace_back("DE"s, "DEU"s, 276, u8"Germany"s,                                              u8"Federal Republic of Germany"s                                                                                                   );
  g_regions.emplace_back("DJ"s, "DJI"s, 262, u8"Djibouti"s,                                             u8"Republic of Djibouti"s                                                                                                          );
  g_regions.emplace_back("DK"s, "DNK"s, 208, u8"Denmark"s,                                              u8"Kingdom of Denmark"s                                                                                                            );
  g_regions.emplace_back("DM"s, "DMA"s, 212, u8"Dominica"s,                                             u8"Commonwealth of Dominica"s                                                                                                      );
  g_regions.emplace_back("DO"s, "DOM"s, 214, u8"Dominican Republic"s,                                   u8""s                                                                                                                              );
  g_regions.emplace_back("DZ"s, "DZA"s,  12, u8"Algeria"s,                                              u8"People's Democratic Republic of Algeria"s                                                                                       );
  g_regions.emplace_back("EC"s, "ECU"s, 218, u8"Ecuador"s,                                              u8"Republic of Ecuador"s                                                                                                           );
  g_regions.emplace_back("EE"s, "EST"s, 233, u8"Estonia"s,                                              u8"Republic of Estonia"s                                                                                                           );
  g_regions.emplace_back("EG"s, "EGY"s, 818, u8"Egypt"s,                                                u8"Arab Republic of Egypt"s                                                                                                        );
  g_regions.emplace_back("EH"s, "ESH"s, 732, u8"Western Sahara"s,                                       u8"Sahrawi Arab Democratic Republic"s                                                                                              );
  g_regions.emplace_back("ER"s, "ERI"s, 232, u8"Eritrea"s,                                              u8"State of Eritrea"s                                                                                                              );
  g_regions.emplace_back("ES"s, "ESP"s, 724, u8"Spain"s,                                                u8"Kingdom of Spain"s                                                                                                              );
  g_regions.emplace_back("ET"s, "ETH"s, 231, u8"Ethiopia"s,                                             u8"Federal Democratic Republic of Ethiopia"s                                                                                       );
  g_regions.emplace_back("FI"s, "FIN"s, 246, u8"Finland"s,                                              u8"Republic of Finland"s                                                                                                           );
  g_regions.emplace_back("FJ"s, "FJI"s, 242, u8"Fiji"s,                                                 u8"Republic of Fiji"s                                                                                                              );
  g_regions.emplace_back("FK"s, "FLK"s, 238, u8"Falkland Islands"s,                                     u8""s                                                                                                                              );
  g_regions.emplace_back("FM"s, "FSM"s, 583, u8"Micronesia (Federated States of)"s,                     u8"Federated States of Micronesia"s                                                                                                );
  g_regions.emplace_back("FO"s, "FRO"s, 234, u8"Faroe Islands"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("FR"s, "FRA"s, 250, u8"France"s,                                               u8"French Republic"s                                                                                                               );
  g_regions.emplace_back("GA"s, "GAB"s, 266, u8"Gabon"s,                                                u8"Gabonese Republic"s                                                                                                             );
  g_regions.emplace_back("GB"s, "GBR"s, 826, u8"United Kingdom of Great Britain and Northern Ireland"s, u8""s                                                                                                                              );
  g_regions.emplace_back("GD"s, "GRD"s, 308, u8"Grenada"s,                                              u8""s                                                                                                                              );
  g_regions.emplace_back("GE"s, "GEO"s, 268, u8"Georgia"s,                                              u8""s                                                                                                                              );
  g_regions.emplace_back("GF"s, "GUF"s, 254, u8"French Guiana"s,                                        u8"Guyane"s                                                                                                                        );
  g_regions.emplace_back("GG"s, "GGY"s, 831, u8"Guernsey"s,                                             u8"Bailiwick of Guernsey"s                                                                                                         );
  g_regions.emplace_back("GH"s, "GHA"s, 288, u8"Ghana"s,                                                u8"Republic of Ghana"s                                                                                                             );
  g_regions.emplace_back("GI"s, "GIB"s, 292, u8"Gibraltar"s,                                            u8""s                                                                                                                              );
  g_regions.emplace_back("GL"s, "GRL"s, 304, u8"Greenland"s,                                            u8"Kalaallit Nunaat"s                                                                                                              );
  g_regions.emplace_back("GM"s, "GMB"s, 270, u8"Gambia"s,                                               u8"Republic of The Gambia"s                                                                                                        );
  g_regions.emplace_back("GN"s, "GIN"s, 324, u8"Guinea"s,                                               u8"Republic of Guinea"s                                                                                                            );
  g_regions.emplace_back("GP"s, "GLP"s, 312, u8"Guadeloupe"s,                                           u8""s                                                                                                                              );
  g_regions.emplace_back("GQ"s, "GNQ"s, 226, u8"Equatorial Guinea"s,                                    u8"Republic of Equatorial Guinea"s                                                                                                 );
  g_regions.emplace_back("GR"s, "GRC"s, 300, u8"Greece"s,                                               u8"Hellenic Republic"s                                                                                                             );
  g_regions.emplace_back("GS"s, "SGS"s, 239, u8"South Georgia and the South Sandwich Islands"s,         u8""s                                                                                                                              );
  g_regions.emplace_back("GT"s, "GTM"s, 320, u8"Guatemala"s,                                            u8"Republic of Guatemala"s                                                                                                         );
  g_regions.emplace_back("GU"s, "GUM"s, 316, u8"Guam"s,                                                 u8"Territory of Guam"s                                                                                                             );
  g_regions.emplace_back("GW"s, "GNB"s, 624, u8"Guinea-Bissau"s,                                        u8"Republic of Guinea-Bissau"s                                                                                                     );
  g_regions.emplace_back("GY"s, "GUY"s, 328, u8"Guyana"s,                                               u8"Co-operative Republic of Guyana"s                                                                                               );
  g_regions.emplace_back("HK"s, "HKG"s, 344, u8"Hong Kong"s,                                            u8"Hong Kong Special Administrative Region of China"s                                                                              );
  g_regions.emplace_back("HM"s, "HMD"s, 334, u8"Heard Island and McDonald Islands"s,                    u8"Territory of Heard Island and McDonald Islands"s                                                                                );
  g_regions.emplace_back("HN"s, "HND"s, 340, u8"Honduras"s,                                             u8"Republic of Honduras"s                                                                                                          );
  g_regions.emplace_back("HR"s, "HRV"s, 191, u8"Croatia"s,                                              u8"Republic of Croatia"s                                                                                                           );
  g_regions.emplace_back("HT"s, "HTI"s, 332, u8"Haiti"s,                                                u8"Republic of Haiti"s                                                                                                             );
  g_regions.emplace_back("HU"s, "HUN"s, 348, u8"Hungary"s,                                              u8""s                                                                                                                              );
  g_regions.emplace_back("ID"s, "IDN"s, 360, u8"Indonesia"s,                                            u8"Republic of Indonesia"s                                                                                                         );
  g_regions.emplace_back("IE"s, "IRL"s, 372, u8"Ireland"s,                                              u8""s                                                                                                                              );
  g_regions.emplace_back("IL"s, "ISR"s, 376, u8"Israel"s,                                               u8"State of Israel"s                                                                                                               );
  g_regions.emplace_back("IM"s, "IMN"s, 833, u8"Isle of Man"s,                                          u8""s                                                                                                                              );
  g_regions.emplace_back("IN"s, "IND"s, 356, u8"India"s,                                                u8"Republic of India"s                                                                                                             );
  g_regions.emplace_back("IO"s, "IOT"s,  86, u8"British Indian Ocean Territory"s,                       u8""s                                                                                                                              );
  g_regions.emplace_back("IQ"s, "IRQ"s, 368, u8"Iraq"s,                                                 u8"Republic of Iraq"s                                                                                                              );
  g_regions.emplace_back("IR"s, "IRN"s, 364, u8"Iran (Islamic Republic of)"s,                           u8"Islamic Republic of Iran"s                                                                                                      );
  g_regions.emplace_back("IS"s, "ISL"s, 352, u8"Iceland"s,                                              u8""s                                                                                                                              );
  g_regions.emplace_back("IT"s, "ITA"s, 380, u8"Italy"s,                                                u8"Italian Republic"s                                                                                                              );
  g_regions.emplace_back("JE"s, "JEY"s, 832, u8"Jersey"s,                                               u8"Bailiwick of Jersey"s                                                                                                           );
  g_regions.emplace_back("JM"s, "JAM"s, 388, u8"Jamaica"s,                                              u8""s                                                                                                                              );
  g_regions.emplace_back("JO"s, "JOR"s, 400, u8"Jordan"s,                                               u8"Hashemite Kingdom of Jordan"s                                                                                                   );
  g_regions.emplace_back("JP"s, "JPN"s, 392, u8"Japan"s,                                                u8""s                                                                                                                              );
  g_regions.emplace_back("KE"s, "KEN"s, 404, u8"Kenya"s,                                                u8"Republic of Kenya"s                                                                                                             );
  g_regions.emplace_back("KG"s, "KGZ"s, 417, u8"Kyrgyzstan"s,                                           u8"Kyrgyz Republic"s                                                                                                               );
  g_regions.emplace_back("KH"s, "KHM"s, 116, u8"Cambodia"s,                                             u8"Kingdom of Cambodia"s                                                                                                           );
  g_regions.emplace_back("KI"s, "KIR"s, 296, u8"Kiribati"s,                                             u8"Republic of Kiribati"s                                                                                                          );
  g_regions.emplace_back("KM"s, "COM"s, 174, u8"Comoros"s,                                              u8"Union of the Comoros"s                                                                                                          );
  g_regions.emplace_back("KN"s, "KNA"s, 659, u8"Saint Kitts and Nevis"s,                                u8""s                                                                                                                              );
  g_regions.emplace_back("KP"s, "PRK"s, 408, u8"Korea (the Democratic People's Republic of)"s,          u8"Democratic People's Republic of Korea"s                                                                                         );
  g_regions.emplace_back("KR"s, "KOR"s, 410, u8"Korea (the Republic of)"s,                              u8"Republic of Korea"s                                                                                                             );
  g_regions.emplace_back("KW"s, "KWT"s, 414, u8"Kuwait"s,                                               u8"State of Kuwait"s                                                                                                               );
  g_regions.emplace_back("KY"s, "CYM"s, 136, u8"Cayman Islands"s,                                       u8""s                                                                                                                              );
  g_regions.emplace_back("KZ"s, "KAZ"s, 398, u8"Kazakhstan"s,                                           u8"Republic of Kazakhstan"s                                                                                                        );
  g_regions.emplace_back("LA"s, "LAO"s, 418, u8"Lao People's Democratic Republic"s,                     u8""s                                                                                                                              );
  g_regions.emplace_back("LB"s, "LBN"s, 422, u8"Lebanon"s,                                              u8"Lebanese Republic"s                                                                                                             );
  g_regions.emplace_back("LC"s, "LCA"s, 662, u8"Saint Lucia"s,                                          u8""s                                                                                                                              );
  g_regions.emplace_back("LI"s, "LIE"s, 438, u8"Liechtenstein"s,                                        u8"Principality of Liechtenstein"s                                                                                                 );
  g_regions.emplace_back("LK"s, "LKA"s, 144, u8"Sri Lanka"s,                                            u8"Democratic Socialist Republic of Sri Lanka"s                                                                                    );
  g_regions.emplace_back("LR"s, "LBR"s, 430, u8"Liberia"s,                                              u8"Republic of Liberia"s                                                                                                           );
  g_regions.emplace_back("LS"s, "LSO"s, 426, u8"Lesotho"s,                                              u8"Kingdom of Lesotho"s                                                                                                            );
  g_regions.emplace_back("LT"s, "LTU"s, 440, u8"Lithuania"s,                                            u8"Republic of Lithuania"s                                                                                                         );
  g_regions.emplace_back("LU"s, "LUX"s, 442, u8"Luxembourg"s,                                           u8"Grand Duchy of Luxembourg"s                                                                                                     );
  g_regions.emplace_back("LV"s, "LVA"s, 428, u8"Latvia"s,                                               u8"Republic of Latvia"s                                                                                                            );
  g_regions.emplace_back("LY"s, "LBY"s, 434, u8"Libya"s,                                                u8"State of Libya"s                                                                                                                );
  g_regions.emplace_back("MA"s, "MAR"s, 504, u8"Morocco"s,                                              u8"Kingdom of Morocco"s                                                                                                            );
  g_regions.emplace_back("MC"s, "MCO"s, 492, u8"Monaco"s,                                               u8"Principality of Monaco"s                                                                                                        );
  g_regions.emplace_back("MD"s, "MDA"s, 498, u8"Moldova (the Republic of)"s,                            u8"Republic of Moldova"s                                                                                                           );
  g_regions.emplace_back("ME"s, "MNE"s, 499, u8"Montenegro"s,                                           u8""s                                                                                                                              );
  g_regions.emplace_back("MF"s, "MAF"s, 663, u8"Saint Martin (French part)"s,                           u8"Collectivity of Saint-Martin"s                                                                                                  );
  g_regions.emplace_back("MG"s, "MDG"s, 450, u8"Madagascar"s,                                           u8"Republic of Madagascar"s                                                                                                        );
  g_regions.emplace_back("MH"s, "MHL"s, 584, u8"Marshall Islands"s,                                     u8"Republic of the Marshall Islands"s                                                                                              );
  g_regions.emplace_back("MK"s, "MKD"s, 807, u8"North Macedonia"s,                                      u8"Republic of North Macedonia"s                                                                                                   );
  g_regions.emplace_back("ML"s, "MLI"s, 466, u8"Mali"s,                                                 u8"Republic of Mali"s                                                                                                              );
  g_regions.emplace_back("MM"s, "MMR"s, 104, u8"Myanmar"s,                                              u8"Republic of the Union of Myanmar"s                                                                                              );
  g_regions.emplace_back("MN"s, "MNG"s, 496, u8"Mongolia"s,                                             u8""s                                                                                                                              );
  g_regions.emplace_back("MO"s, "MAC"s, 446, u8"Macao"s,                                                u8"Macao Special Administrative Region of China"s                                                                                  );
  g_regions.emplace_back("MP"s, "MNP"s, 580, u8"Northern Mariana Islands"s,                             u8"Commonwealth of the Northern Mariana Islands"s                                                                                  );
  g_regions.emplace_back("MQ"s, "MTQ"s, 474, u8"Martinique"s,                                           u8""s                                                                                                                              );
  g_regions.emplace_back("MR"s, "MRT"s, 478, u8"Mauritania"s,                                           u8"Islamic Republic of Mauritania"s                                                                                                );
  g_regions.emplace_back("MS"s, "MSR"s, 500, u8"Montserrat"s,                                           u8""s                                                                                                                              );
  g_regions.emplace_back("MT"s, "MLT"s, 470, u8"Malta"s,                                                u8"Republic of Malta"s                                                                                                             );
  g_regions.emplace_back("MU"s, "MUS"s, 480, u8"Mauritius"s,                                            u8"Republic of Mauritius"s                                                                                                         );
  g_regions.emplace_back("MV"s, "MDV"s, 462, u8"Maldives"s,                                             u8"Republic of Maldives"s                                                                                                          );
  g_regions.emplace_back("MW"s, "MWI"s, 454, u8"Malawi"s,                                               u8"Republic of Malawi"s                                                                                                            );
  g_regions.emplace_back("MX"s, "MEX"s, 484, u8"Mexico"s,                                               u8"United Mexican States"s                                                                                                         );
  g_regions.emplace_back("MY"s, "MYS"s, 458, u8"Malaysia"s,                                             u8""s                                                                                                                              );
  g_regions.emplace_back("MZ"s, "MOZ"s, 508, u8"Mozambique"s,                                           u8"Republic of Mozambique"s                                                                                                        );
  g_regions.emplace_back("NA"s, "NAM"s, 516, u8"Namibia"s,                                              u8"Republic of Namibia"s                                                                                                           );
  g_regions.emplace_back("NC"s, "NCL"s, 540, u8"New Caledonia"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("NE"s, "NER"s, 562, u8"Niger"s,                                                u8"Republic of the Niger"s                                                                                                         );
  g_regions.emplace_back("NF"s, "NFK"s, 574, u8"Norfolk Island"s,                                       u8"Territory of Norfolk Island"s                                                                                                   );
  g_regions.emplace_back("NG"s, "NGA"s, 566, u8"Nigeria"s,                                              u8"Federal Republic of Nigeria"s                                                                                                   );
  g_regions.emplace_back("NI"s, "NIC"s, 558, u8"Nicaragua"s,                                            u8"Republic of Nicaragua"s                                                                                                         );
  g_regions.emplace_back("NL"s, "NLD"s, 528, u8"Netherlands"s,                                          u8"Kingdom of the Netherlands"s                                                                                                    );
  g_regions.emplace_back("NO"s, "NOR"s, 578, u8"Norway"s,                                               u8"Kingdom of Norway"s                                                                                                             );
  g_regions.emplace_back("NP"s, "NPL"s, 524, u8"Nepal"s,                                                u8"Federal Democratic Republic of Nepal"s                                                                                          );
  g_regions.emplace_back("NR"s, "NRU"s, 520, u8"Nauru"s,                                                u8"Republic of Nauru"s                                                                                                             );
  g_regions.emplace_back("NU"s, "NIU"s, 570, u8"Niue"s,                                                 u8""s                                                                                                                              );
  g_regions.emplace_back("NZ"s, "NZL"s, 554, u8"New Zealand"s,                                          u8""s                                                                                                                              );
  g_regions.emplace_back("OM"s, "OMN"s, 512, u8"Oman"s,                                                 u8"Sultanate of Oman"s                                                                                                             );
  g_regions.emplace_back("PA"s, "PAN"s, 591, u8"Panama"s,                                               u8"Republic of Panamá"s                                                                                                            );
  g_regions.emplace_back("PE"s, "PER"s, 604, u8"Peru"s,                                                 u8"Republic of Perú"s                                                                                                              );
  g_regions.emplace_back("PF"s, "PYF"s, 258, u8"French Polynesia"s,                                     u8""s                                                                                                                              );
  g_regions.emplace_back("PG"s, "PNG"s, 598, u8"Papua New Guinea"s,                                     u8"Independent State of Papua New Guinea"s                                                                                         );
  g_regions.emplace_back("PH"s, "PHL"s, 608, u8"Philippines"s,                                          u8"Republic of the Philippines"s                                                                                                   );
  g_regions.emplace_back("PK"s, "PAK"s, 586, u8"Pakistan"s,                                             u8"Islamic Republic of Pakistan"s                                                                                                  );
  g_regions.emplace_back("PL"s, "POL"s, 616, u8"Poland"s,                                               u8"Republic of Poland"s                                                                                                            );
  g_regions.emplace_back("PM"s, "SPM"s, 666, u8"Saint Pierre and Miquelon"s,                            u8"Overseas Collectivity of Saint-Pierre and Miquelon"s                                                                            );
  g_regions.emplace_back("PN"s, "PCN"s, 612, u8"Pitcairn"s,                                             u8"Pitcairn, Henderson, Ducie and Oeno Islands"s                                                                                   );
  g_regions.emplace_back("PR"s, "PRI"s, 630, u8"Puerto Rico"s,                                          u8"Commonwealth of Puerto Rico"s                                                                                                   );
  g_regions.emplace_back("PS"s, "PSE"s, 275, u8"Palestine, State of"s,                                  u8"State of Palestine"s                                                                                                            );
  g_regions.emplace_back("PT"s, "PRT"s, 620, u8"Portugal"s,                                             u8"Portuguese Republic"s                                                                                                           );
  g_regions.emplace_back("PW"s, "PLW"s, 585, u8"Palau"s,                                                u8"Republic of Palau"s                                                                                                             );
  g_regions.emplace_back("PY"s, "PRY"s, 600, u8"Paraguay"s,                                             u8"Republic of Paraguay"s                                                                                                          );
  g_regions.emplace_back("QA"s, "QAT"s, 634, u8"Qatar"s,                                                u8"State of Qatar"s                                                                                                                );
  g_regions.emplace_back("QM"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QN"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QO"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QP"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QQ"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QR"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QS"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QT"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QU"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QV"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QW"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QX"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QY"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("QZ"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("RE"s, "REU"s, 638, u8"Réunion"s,                                              u8""s                                                                                                                              );
  g_regions.emplace_back("RO"s, "ROU"s, 642, u8"Romania"s,                                              u8""s                                                                                                                              );
  g_regions.emplace_back("RS"s, "SRB"s, 688, u8"Serbia"s,                                               u8"Republic of Serbia"s                                                                                                            );
  g_regions.emplace_back("RU"s, "RUS"s, 643, u8"Russian Federation"s,                                   u8""s                                                                                                                              );
  g_regions.emplace_back("RW"s, "RWA"s, 646, u8"Rwanda"s,                                               u8"Republic of Rwanda"s                                                                                                            );
  g_regions.emplace_back("SA"s, "SAU"s, 682, u8"Saudi Arabia"s,                                         u8"Kingdom of Saudi Arabia"s                                                                                                       );
  g_regions.emplace_back("SB"s, "SLB"s,  90, u8"Solomon Islands"s,                                      u8""s                                                                                                                              );
  g_regions.emplace_back("SC"s, "SYC"s, 690, u8"Seychelles"s,                                           u8"Republic of Seychelles"s                                                                                                        );
  g_regions.emplace_back("SD"s, "SDN"s, 729, u8"Sudan"s,                                                u8"Republic of the Sudan"s                                                                                                         );
  g_regions.emplace_back("SE"s, "SWE"s, 752, u8"Sweden"s,                                               u8"Kingdom of Sweden"s                                                                                                             );
  g_regions.emplace_back("SG"s, "SGP"s, 702, u8"Singapore"s,                                            u8"Republic of Singapore"s                                                                                                         );
  g_regions.emplace_back("SH"s, "SHN"s, 654, u8"Saint Helena, Ascension Island and Tristan da Cunha"s,  u8"Saint Helena, Ascension and Tristan da Cunha"s                                                                                  );
  g_regions.emplace_back("SI"s, "SVN"s, 705, u8"Slovenia"s,                                             u8"Republic of Slovenia"s                                                                                                          );
  g_regions.emplace_back("SJ"s, "SJM"s, 744, u8"Svalbard, Jan Mayen"s,                                  u8"Svalbard and Jan Mayen"s                                                                                                        );
  g_regions.emplace_back("SK"s, "SVK"s, 703, u8"Slovakia"s,                                             u8"Slovak Republic"s                                                                                                               );
  g_regions.emplace_back("SL"s, "SLE"s, 694, u8"Sierra Leone"s,                                         u8"Republic of Sierra Leone"s                                                                                                      );
  g_regions.emplace_back("SM"s, "SMR"s, 674, u8"San Marino"s,                                           u8"Republic of San Marino"s                                                                                                        );
  g_regions.emplace_back("SN"s, "SEN"s, 686, u8"Senegal"s,                                              u8"Republic of Senegal"s                                                                                                           );
  g_regions.emplace_back("SO"s, "SOM"s, 706, u8"Somalia"s,                                              u8"Federal Republic of Somalia"s                                                                                                   );
  g_regions.emplace_back("SR"s, "SUR"s, 740, u8"Suriname"s,                                             u8"Republic of Suriname"s                                                                                                          );
  g_regions.emplace_back("SS"s, "SSD"s, 728, u8"South Sudan"s,                                          u8"Republic of South Sudan"s                                                                                                       );
  g_regions.emplace_back("ST"s, "STP"s, 678, u8"Sao Tome and Principe"s,                                u8"Democratic Republic of São Tomé and Príncipe"s                                                                                  );
  g_regions.emplace_back("SV"s, "SLV"s, 222, u8"El Salvador"s,                                          u8"Republic of El Salvador"s                                                                                                       );
  g_regions.emplace_back("SX"s, "SXM"s, 534, u8"Sint Maarten (Dutch part)"s,                            u8"Sint Maarten"s                                                                                                                  );
  g_regions.emplace_back("SY"s, "SYR"s, 760, u8"Syrian Arab Republic"s,                                 u8""s                                                                                                                              );
  g_regions.emplace_back("SZ"s, "SWZ"s, 748, u8"Eswatini"s,                                             u8"Kingdom of Eswatini"s                                                                                                           );
  g_regions.emplace_back("TC"s, "TCA"s, 796, u8"Turks and Caicos Islands"s,                             u8""s                                                                                                                              );
  g_regions.emplace_back("TD"s, "TCD"s, 148, u8"Chad"s,                                                 u8"Republic of Chad"s                                                                                                              );
  g_regions.emplace_back("TF"s, "ATF"s, 260, u8"French Southern Territories"s,                          u8"French Southern and Antarctic Lands"s                                                                                           );
  g_regions.emplace_back("TG"s, "TGO"s, 768, u8"Togo"s,                                                 u8"Togolese Republic"s                                                                                                             );
  g_regions.emplace_back("TH"s, "THA"s, 764, u8"Thailand"s,                                             u8"Kingdom of Thailand"s                                                                                                           );
  g_regions.emplace_back("TJ"s, "TJK"s, 762, u8"Tajikistan"s,                                           u8"Republic of Tajikistan"s                                                                                                        );
  g_regions.emplace_back("TK"s, "TKL"s, 772, u8"Tokelau"s,                                              u8""s                                                                                                                              );
  g_regions.emplace_back("TL"s, "TLS"s, 626, u8"Timor-Leste"s,                                          u8"Democratic Republic of Timor-Leste"s                                                                                            );
  g_regions.emplace_back("TM"s, "TKM"s, 795, u8"Turkmenistan"s,                                         u8""s                                                                                                                              );
  g_regions.emplace_back("TN"s, "TUN"s, 788, u8"Tunisia"s,                                              u8"Republic of Tunisia"s                                                                                                           );
  g_regions.emplace_back("TO"s, "TON"s, 776, u8"Tonga"s,                                                u8"Kingdom of Tonga"s                                                                                                              );
  g_regions.emplace_back("TR"s, "TUR"s, 792, u8"Turkey"s,                                               u8"Republic of Turkey"s                                                                                                            );
  g_regions.emplace_back("TT"s, "TTO"s, 780, u8"Trinidad and Tobago"s,                                  u8"Republic of Trinidad and Tobago"s                                                                                               );
  g_regions.emplace_back("TV"s, "TUV"s, 798, u8"Tuvalu"s,                                               u8""s                                                                                                                              );
  g_regions.emplace_back("TW"s, "TWN"s, 158, u8"Taiwan (Province of China)"s,                           u8"Republic of China"s                                                                                                             );
  g_regions.emplace_back("TZ"s, "TZA"s, 834, u8"Tanzania, the United Republic of"s,                     u8"United Republic of Tanzania"s                                                                                                   );
  g_regions.emplace_back("UA"s, "UKR"s, 804, u8"Ukraine"s,                                              u8""s                                                                                                                              );
  g_regions.emplace_back("UG"s, "UGA"s, 800, u8"Uganda"s,                                               u8"Republic of Uganda"s                                                                                                            );
  g_regions.emplace_back("UM"s, "UMI"s, 581, u8"United States Minor Outlying Islands"s,                 u8"BakerIsland, HowlandIsland, JarvisIsland, JohnstonAtoll, KingmanReef, MidwayAtoll, NavassaIsland, PalmyraAtoll, and WakeIsland"s);
  g_regions.emplace_back("US"s, "USA"s, 840, u8"United States of America"s,                             u8""s                                                                                                                              );
  g_regions.emplace_back("UY"s, "URY"s, 858, u8"Uruguay"s,                                              u8"Oriental Republic of Uruguay"s                                                                                                  );
  g_regions.emplace_back("UZ"s, "UZB"s, 860, u8"Uzbekistan"s,                                           u8"Republic of Uzbekistan"s                                                                                                        );
  g_regions.emplace_back("VA"s, "VAT"s, 336, u8"Holy See"s,                                             u8""s                                                                                                                              );
  g_regions.emplace_back("VC"s, "VCT"s, 670, u8"Saint Vincent and the Grenadines"s,                     u8""s                                                                                                                              );
  g_regions.emplace_back("VE"s, "VEN"s, 862, u8"Venezuela (Bolivarian Republic of)"s,                   u8"Bolivarian Republic of Venezuela"s                                                                                              );
  g_regions.emplace_back("VG"s, "VGB"s,  92, u8"Virgin Islands (British)"s,                             u8"Virgin Islands"s                                                                                                                );
  g_regions.emplace_back("VI"s, "VIR"s, 850, u8"Virgin Islands (U.S.)"s,                                u8"Virgin Islands of the United States"s                                                                                           );
  g_regions.emplace_back("VN"s, "VNM"s, 704, u8"Viet Nam"s,                                             u8"Socialist Republic of Viet Nam"s                                                                                                );
  g_regions.emplace_back("VU"s, "VUT"s, 548, u8"Vanuatu"s,                                              u8"Republic of Vanuatu"s                                                                                                           );
  g_regions.emplace_back("WF"s, "WLF"s, 876, u8"Wallis and Futuna"s,                                    u8"Territory of the Wallis and Futuna Islands"s                                                                                    );
  g_regions.emplace_back("WS"s, "WSM"s, 882, u8"Samoa"s,                                                u8"Independent State of Samoa"s                                                                                                    );
  g_regions.emplace_back("XA"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XB"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XC"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XD"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XE"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XF"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XG"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XH"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XI"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XJ"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XK"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XL"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XM"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XN"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XO"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XP"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XQ"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XR"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XS"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XT"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XU"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XV"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XW"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XX"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XY"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("XZ"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
  g_regions.emplace_back("YE"s, "YEM"s, 887, u8"Yemen"s,                                                u8"Republic of Yemen"s                                                                                                             );
  g_regions.emplace_back("YT"s, "MYT"s, 175, u8"Mayotte"s,                                              u8"Department of Mayotte"s                                                                                                         );
  g_regions.emplace_back("ZA"s, "ZAF"s, 710, u8"South Africa"s,                                         u8"Republic of South Africa"s                                                                                                      );
  g_regions.emplace_back("ZM"s, "ZMB"s, 894, u8"Zambia"s,                                               u8"Republic of Zambia"s                                                                                                            );
  g_regions.emplace_back("ZW"s, "ZWE"s, 716, u8"Zimbabwe"s,                                             u8"Republic of Zimbabwe"s                                                                                                          );
  g_regions.emplace_back("ZZ"s, ""s,      0, u8"User-assigned"s,                                        u8""s                                                                                                                              );
}

} // namespace mtx::iso3166
