/*
 * devices.h - Device names and characteristics.
 *
 * This file is a part of Minipro.
 *
 * Minipro is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Minipro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

/* Note, this file really isn't copyrightable. */

{
	.name = "14001",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa001,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14011",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa011,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14012",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa012,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14013",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa013,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14014",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa014,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14015",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa015,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14017",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa017,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14018",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa018,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14021",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa014,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14023",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa023,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14025",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa025,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14049",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa049,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14050",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa050,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14051",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa051,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14052",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa052,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14053",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa053,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14069",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x04,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14070",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa070,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14071",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa071,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14073",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa073,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14075",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa075,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14077",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa077,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14081",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa081,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14093",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa093,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "14160",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x160,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14161",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x161,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14162",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x160,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14163",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x161,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14174",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x174,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "14175",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x175,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "24AA00",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x10,
	.write_buffer_size = 0x01,
	.code_memory_size = 0x10,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "24AA00 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x10,
	.write_buffer_size = 0x01,
	.code_memory_size = 0x10,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24AA00 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x10,
	.write_buffer_size = 0x01,
	.code_memory_size = 0x10,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24AA00 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x10,
	.write_buffer_size = 0x01,
	.code_memory_size = 0x10,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24AA01",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA01 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA01 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA01 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA014",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA014 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA014 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA02 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA024",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA024 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA024 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA024 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA025",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA025 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA025 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA025 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA04 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA08 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA128 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA16 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA256 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA32 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA32A",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA32A @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA32A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA32A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA512",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "24AA512 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24AA512 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24AA512 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24AA64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA64 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA65",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA65 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA65 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24AA65 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C00",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x10,
	.write_buffer_size = 0x01,
	.code_memory_size = 0x10,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "24C00 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x10,
	.write_buffer_size = 0x01,
	.code_memory_size = 0x10,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24C00 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x10,
	.write_buffer_size = 0x01,
	.code_memory_size = 0x10,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24C00 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x10,
	.write_buffer_size = 0x01,
	.code_memory_size = 0x10,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24C01",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x02,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x02,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C01A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x02,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x02,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C01A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x02,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x02,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C01C",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C01C @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C01C @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C02 #2",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x02,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x02,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C02A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x02,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x02,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C02A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x02,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x02,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C02C",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C02C @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C02C @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C04 #2",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C04A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C04A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C04A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C08 #2",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C08 @SOIC8 #2",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C08B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C08B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C16 #2",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C16 @SOIC8 #2",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C16B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C16B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C32 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24C65",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24C65 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC128 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC16 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC256 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC32 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC512",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "24FC512 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24FC512 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24FC512 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24FC64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC64 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC65",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC65 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC65 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24FC65 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC00",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x10,
	.write_buffer_size = 0x01,
	.code_memory_size = 0x10,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "24LC00 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x10,
	.write_buffer_size = 0x01,
	.code_memory_size = 0x10,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24LC00 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x10,
	.write_buffer_size = 0x01,
	.code_memory_size = 0x10,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24LC00 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x10,
	.write_buffer_size = 0x01,
	.code_memory_size = 0x10,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24LC01",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x04,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x04,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC01 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x04,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x04,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC014",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC014 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC014 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC01A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC01A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC01A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC01B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC01B @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC01B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC01B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC024",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC024 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC024 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC024 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC025",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC025 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC025 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC025 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC02A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC02A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC02A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC02B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC02B @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC02B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC02B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC04A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC04A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC04A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC04B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC04B @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC04B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC04B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC08A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC08A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC08A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC08B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC08B @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC08B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC08B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC128 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC16A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC16A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC16A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC16B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC16B @DFN8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC16B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC16B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC21",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC21 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC21A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC21A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC256 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32 #2",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32 #3",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32 @SOIC8 #2",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32 @SOIC8 #3",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32 @TSSOP8 #2",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32A",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32A @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC32A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC512",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "24LC512 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24LC512 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24LC512 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24LC64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC64 #2",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "24LC64 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC64 @SOIC8 #2",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "24LC64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC65",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC65 @DFN8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC65 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LC65 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LCS21",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LCS21 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "24LCS21A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "24LCS21A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "25AA010A",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA010A @DFN8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA010A @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA010A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA010A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA020A",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA020A @DFN8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA020A @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA020A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA020A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA040",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA040 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA040 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA040A",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA040A @DFN8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA040A @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA040A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA040A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080A",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080A @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080B",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080B @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080C",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080C @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080C @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080C @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080D",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080D @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080D @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA080D @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA1024",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404210,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "25AA1024 @DFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404210,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "25AA1024 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404210,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "25AA128",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA128 @DFN8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA128 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA128 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA160",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA160 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA160A",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA160A @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA160A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA160A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA160B",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA160B @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA160B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA160B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA256",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA256 @DFN8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA256 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA256 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA320",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA320 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA320 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA512",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA512 @DFN8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA512 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA640",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA640 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25AA640 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25C040",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25C040 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25C040 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25C080",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25C080 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25C160",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25C160 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25C320",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25C320 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25C320 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25C640",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25C640 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25C640 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC010A",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC010A @DFN8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC010A @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC010A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC010A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC020A",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC020A @DFN8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC020A @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC020A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC020A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC040",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC040 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC040 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC040A",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC040A @DFN8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC040A @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC040A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC040A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080A",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080A @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080B",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080B @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080C",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080C @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080C @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080C @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080D",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080D @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080D @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC080D @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC1024",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404210,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "25LC1024 @DFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404210,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "25LC1024 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404210,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "25LC128",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC128 @DFN8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC128 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC128 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC160",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC160 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC160A",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC160A @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC160A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC160A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC160B",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC160B @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC160B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC160B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC256",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC256 @DFN8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC256 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC256 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC320",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC320 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC320 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC512",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC512 @DFN8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC512 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC640",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC640 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "25LC640 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "27128A @DIP28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8989,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "27128A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8989,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "2732A @DIP24",
	.protocol_id = 0x38,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x1f4,
	.opts4 = 0x48,
	.package_details = 0x18000000,
	.write_unlock = 0x0d,
},
{
	.name = "27512 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x890d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "27512 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x890d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "2764A @DIP28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8908,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "2764A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8908,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "27C010 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8935,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "27C010 @DIP32 #2",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1525,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x02,
},
{
	.name = "27C010 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8935,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27C010 @PLCC32 #2",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1525,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "27C010 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1525,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "27C010A @DIP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8935,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "27C010A @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8935,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27C020 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8934,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "27C020 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8934,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27C040 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x893d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "27C040 @DIP32 #2",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xf53e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x02,
},
{
	.name = "27C040 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x893d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27C040 @PLCC32 #2",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xf53e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "27C040 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xf53e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "27C128 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8983,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27C128 @DIP28 #2",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2983,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27C128 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8983,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27C128 @PLCC32 #2",
	.protocol_id = 0x37,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2983,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27C128 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2983,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "27C210 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8900ee11,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "27C210 @DIP40 #2",
	.protocol_id = 0x39,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x15ff17ff,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "27C220 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8900ee22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "27C240 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8900ee44,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "27C240 @DIP40 #2",
	.protocol_id = 0x39,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x15ff20ff,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "27C256 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x898c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27C256 @DIP28 #2",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x298c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27C256 @DIP28 #3",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "27C256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x898c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27C256 @PLCC32 #2",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x298c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27C256 @PLCC32 #3",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "27C256 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x298c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "27C32A @DIP24",
	.protocol_id = 0x38,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0xc8,
	.opts4 = 0x48,
	.package_details = 0x18000000,
	.write_unlock = 0x3e,
},
{
	.name = "27C512 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x89fd,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27C512 @DIP28 #2",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x290d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27C512 @DIP28 #3",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "27C512 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x89fd,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27C512 @PLCC32 #2",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x290d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27C512 @PLCC32 #3",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x3e8,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "27C512A @DIP28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x290d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27C512A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x290d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27C512A @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x290d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "27C64 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2902,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27C64 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2902,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27C64 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2902,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "27CX010 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "27CX010 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27CX256 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x110,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27CX256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x110,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27HC256 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2994,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27HC256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2994,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27HC256 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2994,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "27HC256L @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2994,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27HC256L @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2994,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27HC256L @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2994,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "27HC64 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2991,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27HC64 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2991,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27LV256 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x298c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27LV256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x298c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27LV256 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x298c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "27LV64 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2902,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "27LV64 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2902,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "27LV64 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2902,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "2804",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x18000000,
	.write_unlock = 0x34,
},
{
	.name = "2816",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x18000000,
	.write_unlock = 0x34,
},
{
	.name = "2817",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x1c000000,
	.write_unlock = 0x34,
},
{
	.name = "28C010",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "28C010 @PLCC32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "28C010 @TSOP32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "28C010T",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "28C010T @PLCC32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "28C010T @TSOP32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "28C011",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "28C011 @PLCC32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "28C011 @TSOP32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "28C011T",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "28C011T @PLCC32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "28C011T @TSOP32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "28C04A",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x02,
},
{
	.name = "28C04A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "28C04A @SOIC24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x98000000,
	.write_unlock = 0x02,
},
{
	.name = "28C04AF",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x3e,
},
{
	.name = "28C04AF @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "28C04AF @SOIC24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x98000000,
	.write_unlock = 0x3e,
},
{
	.name = "28C16A",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x02,
},
{
	.name = "28C16A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "28C16A @SOIC24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x98000000,
	.write_unlock = 0x02,
},
{
	.name = "28C16AF",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x3e,
},
{
	.name = "28C16AF @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "28C16AF @SOIC24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x98000000,
	.write_unlock = 0x3e,
},
{
	.name = "28C17A",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "28C17A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "28C17A @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x02,
},
{
	.name = "28C17AF",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x3e,
},
{
	.name = "28C17AF @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "28C17AF @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x3e,
},
{
	.name = "28C256",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "28C256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "28C256F",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x40,
	.opts3 = 0xbb8,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x1d3,
},
{
	.name = "28C256F @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x40,
	.opts3 = 0xbb8,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x1d3,
},
{
	.name = "28C64A",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "28C64A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "28C64A @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x02,
},
{
	.name = "28C64AF",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x3e,
},
{
	.name = "28C64AF @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "28C64AF @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x3e,
},
{
	.name = "28C64B",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x34,
},
{
	.name = "28C64B @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x34,
},
{
	.name = "28C64B @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0xc010,
	.package_details = 0x9c000000,
	.write_unlock = 0x34,
},
{
	.name = "28LV64A",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1402,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "28LV64A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1402,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "28LV64A @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1402,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x02,
},
{
	.name = "4001",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa001,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4011",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa011,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4012",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa012,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4013",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa013,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4014",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa014,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "4015",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa015,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "40160",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x160,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "40161",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x161,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "40162",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x160,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "40163",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x161,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "4017",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa017,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "40174",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x174,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "40175",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x175,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "4018",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa018,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "4019",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa019,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "40192",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x192,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "40193",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x193,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "4021",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa014,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "4023",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa023,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4025",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa025,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4030",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa070,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4049",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa049,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "4050",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa050,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "4051",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa051,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "4052",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa052,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "4053",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa053,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "4069",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x04,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4070",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa070,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4071",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa071,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4073",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa073,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4075",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa075,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4077",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa077,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4081",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa081,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "4093",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0xa093,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "6116",
	.protocol_id = 0xd0,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x18000000,
	.write_unlock = 0x02,
},
{
	.name = "61256",
	.protocol_id = 0xd1,
	.variant = 0x02,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "61512",
	.protocol_id = 0xd2,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x20000000,
	.write_unlock = 0x02,
},
{
	.name = "6164",
	.protocol_id = 0xd1,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "62256",
	.protocol_id = 0xd1,
	.variant = 0x02,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "62512",
	.protocol_id = 0xd2,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x20000000,
	.write_unlock = 0x02,
},
{
	.name = "6264",
	.protocol_id = 0xd1,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "628128",
	.protocol_id = 0xd2,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x20000000,
	.write_unlock = 0x02,
},
{
	.name = "628256",
	.protocol_id = 0xd2,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x20000000,
	.write_unlock = 0x02,
},
{
	.name = "628512",
	.protocol_id = 0xd2,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x20000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)00",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)01",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x01,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)02",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x02,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)03",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)04",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x04,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)05",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x04,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)06",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x04,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)07",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x07,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)08",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x08,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)09",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x08,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)10",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x10,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x84,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)11",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x11,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)112",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x112,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)12",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x10,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)122",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x122,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)123",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x123,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)125",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x125,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)126",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x126,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)128",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x02,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)13",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x13,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)132",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)133",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x133,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)134",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x134,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)136",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x86,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)138",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x138,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)139",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x139,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)14",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x04,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)140",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x13,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)145",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x42,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)15",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x11,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)153",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x153,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x84,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)155",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x156,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)156",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x156,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)157",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x157,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)158",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x158,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)16",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x04,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)160",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x160,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)161",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x161,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)162",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x160,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)163",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x161,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)164",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x164,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)165",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x165,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)166",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x166,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)17",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x07,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)174",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x174,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)175",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x175,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)18",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x13,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)19",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x04,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)192",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x192,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)193",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x193,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)20",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x13,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x84,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)21",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x21,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)22",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x13,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)24",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)240",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x240,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)241",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x241,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)244",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x244,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)245",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x245,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)257",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x157,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)258",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x158,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)26",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)266",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x266,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)268",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x268,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)27",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x27,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)273",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x273,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)28",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x02,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)30",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x30,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)32",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x32,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)33",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x02,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)34",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x07,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)35",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x07,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)36",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x36,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)367",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x367,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x84,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)37",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)373",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x373,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)374",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x374,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)377",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x373,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)378",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x378,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)38",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)386",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x386,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)39",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x01,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)390",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x390,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)393",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x393,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)40",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x13,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x84,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)42",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x42,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)43",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x43,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)45",
	.protocol_id = 0x00,
	.variant = 0x08,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x42,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)563",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x576,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)564",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x576,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)573",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x573,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)574",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x573,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)576",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x576,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)580",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x576,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)640",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x640,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x84,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)641",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x640,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)642",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x640,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)643",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x640,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)644",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x640,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)645",
	.protocol_id = 0x00,
	.variant = 0x0a,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x640,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x14000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)74",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x74,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x84,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)86",
	.protocol_id = 0x00,
	.variant = 0x07,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x86,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0xe000000,
	.write_unlock = 0x02,
},
{
	.name = "74HC(LS)93",
	.protocol_id = 0x00,
	.variant = 0x16,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x0a,
	.data_memory_size = 0x93,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x80,
	.package_details = 0x10000000,
	.write_unlock = 0x02,
},
{
	.name = "87C257 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8924,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "87C257 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x8924,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "87C51",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "87C51 @PLCC44",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0xfd000000,
	.write_unlock = 0x05,
},
{
	.name = "87C51FA",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "87C51FA @PLCC44",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0xfd000000,
	.write_unlock = 0x05,
},
{
	.name = "87C51FB",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "87C51FB @PLCC44",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0xfd000000,
	.write_unlock = 0x05,
},
{
	.name = "87C51FC",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "87C51FC @PLCC44",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0xfd000000,
	.write_unlock = 0x05,
},
{
	.name = "87C52",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "87C52 @PLCC44",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0xfd000000,
	.write_unlock = 0x05,
},
{
	.name = "87C54",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "87C54 @PLCC44",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0xfd000000,
	.write_unlock = 0x05,
},
{
	.name = "87C58",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "87C58 @PLCC44",
	.protocol_id = 0x85,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1e00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x60c68,
	.package_details = 0xfd000000,
	.write_unlock = 0x05,
},
{
	.name = "93AA46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46B(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46C(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA46C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56B(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56C(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA56C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66B(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66C(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA66C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76B(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76C(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA76C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86B(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86C(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93AA86C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C06(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x20,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x20,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C06(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x20,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x20,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46 @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46A",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46A @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46B(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46C(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46X(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C46X(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56A",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56A @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56B(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56C(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C56C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66A",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66A @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66B(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66C(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C66C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76B(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76C(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C76C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86B(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86C(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93C86C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93CX46",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93CX46 @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93CX56",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93CX56 @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93CX66",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93CX66 @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46B(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46C(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC46C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56B(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56C(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC56C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66B(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66C(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC66C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76B(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76C(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC76C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86A(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86A(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86B(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86B(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86B(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86B(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86B(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86C(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86C(x16) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86C(x16) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86C(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86C(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86C(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86C(x8) @DFN8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86C(x8) @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86C(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LC86C(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LCS46",
	.protocol_id = 0x02,
	.variant = 0xa9,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LCS46 @SOIC14",
	.protocol_id = 0x02,
	.variant = 0xa9,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8e000000,
	.write_unlock = 0x03,
},
{
	.name = "93LCS46 @SOIC8",
	.protocol_id = 0x02,
	.variant = 0xa9,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LCS56",
	.protocol_id = 0x02,
	.variant = 0xab,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LCS56 @SOIC14",
	.protocol_id = 0x02,
	.variant = 0xab,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8e000000,
	.write_unlock = 0x03,
},
{
	.name = "93LCS56 @SOIC8",
	.protocol_id = 0x02,
	.variant = 0xab,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "93LCS66",
	.protocol_id = 0x02,
	.variant = 0xab,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "93LCS66 @SOIC14",
	.protocol_id = 0x02,
	.variant = 0xab,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8e000000,
	.write_unlock = 0x03,
},
{
	.name = "93LCS66 @SOIC8",
	.protocol_id = 0x02,
	.variant = 0xab,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "A24C02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "A24C02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "A24C02 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "A24C04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "A24C04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "A24C04 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "A24C08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "A24C08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "A24C08 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "A24C16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "A24C16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "A24C16 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "A25L010 @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L010 @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L010 @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L016 @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L016 @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L016 @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L020 @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L020 @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L020 @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L032 @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L032 @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x90000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L032 @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L040 @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L040 @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L040 @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L05PT @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372020,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L05PT @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372020,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L05PT @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372020,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L05PU @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L05PU @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L05PU @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L080 @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L080 @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L080 @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L10PT @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372021,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L10PT @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372021,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L10PT @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372021,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L10PU @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L10PU @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L10PU @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L16PT @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372025,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L16PT @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372025,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L16PT @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372025,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L16PU @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L16PU @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L16PU @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L20PT @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372022,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L20PT @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372022,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L20PT @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372022,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L20PU @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L20PU @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L20PU @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L40PT @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372023,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L40PT @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372023,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L40PT @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372023,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L40PU @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L40PU @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L40PU @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L512 @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L512 @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L512 @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L80PT @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372024,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L80PT @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372024,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L80PT @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372024,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L80PU @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L80PU @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x34,
},
{
	.name = "A25L80PU @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25LQ16 @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x374015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25LQ16 @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x374015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x34,
},
{
	.name = "A25LQ16 @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x374015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A25LQ32A @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x374016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "A25LQ32A @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x374016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x90000000,
	.write_unlock = 0x34,
},
{
	.name = "A25LQ32A @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x374016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "A27020 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3764,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "A27020 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3764,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "A27020L @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3764,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "A276308 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "A276308 @SOP28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "A276308A @DIP28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "A276308A @SOP28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "A276308AL @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x372c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "A276308L @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x373d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "A278308 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3761,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "A278308A @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3764,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "A278308AL @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3764,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "A278308L @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3761,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "A290011T",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x05,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A290011T @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x05,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A290011T @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x05,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A290011U",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x374c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x06,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A290011U @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x374c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x06,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A290011U @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x374c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x06,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29001T",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x05,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A29001T @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x05,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A29001T @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x05,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29001U",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x374c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x06,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A29001U @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x374c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x06,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A29001U @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x374c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x06,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A290021T",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x378c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A290021T @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x378c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A290021T @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x378c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A290021U",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A290021U @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A290021U @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29002T",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x378c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A29002T @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x378c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A29002T @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x378c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29002U",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A29002U @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A29002U @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29010",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0b,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A29010 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0b,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A29010 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0b,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29040",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A29040 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A29040 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29040A",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A29040A @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A29040A @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29040B",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A29040B @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A29040B @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29400TM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700b0b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29400TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700b0b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29400UM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370031b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29400UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370031b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29512",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A29512 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A29512 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29512A",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A29512A @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xa0000000,
	.write_unlock = 0x03,
},
{
	.name = "A29512A @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37a1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29800TM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37000eb3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29800TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37000eb3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29800UM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37008fb3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29800UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37008fb3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29801TM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700d622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff40,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29801TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700d622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff40,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29801UM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff40,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29801UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff40,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29DL162TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37002d22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29DL162UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37002e22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29DL163TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37002822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29DL163UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37002b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29DL164TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37003322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29DL164UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37003522,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29DL322TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37005522,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29DL322UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37005622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29DL323TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37005022,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29DL323UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37005322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29DL324TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37005c22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29DL324UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37005f22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L004ATL @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "A29L004ATV @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "A29L004ATW @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x1a,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x142,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "A29L004ATX @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "A29L004ATY @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "A29L004AUL @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37b5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "A29L004AUV @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37b5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "A29L004AUW @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x1a,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37b5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x142,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "A29L004AUX @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37b5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "A29L004AUY @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37b5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "A29L004TL @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "A29L004TV @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "A29L004TW @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x142,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "A29L004TX @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "A29L004UL @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37b5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "A29L004UV @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37b5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "A29L004UW @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37b5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x142,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "A29L004UX @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37b5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "A29L008ATV @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x1a,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x371a,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x142,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "A29L008AUV @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x1a,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x379b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x142,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "A29L008TV @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x371a,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x142,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "A29L008UV @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x379b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x142,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "A29L040 @DIP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3792,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A29L040 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3792,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "A29L040 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3792,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29L040A @DIP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3792,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "A29L040A @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3792,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "A29L040A @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3792,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A29L160ATV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700c422,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L160AUV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37004922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L160TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700a8b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L160UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370029b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L320ATV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700f622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L320AUV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700f922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L320TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700f622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L320UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700f922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L400ATM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370034b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29L400ATV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370034b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L400AUM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700b5b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29L400AUV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700b5b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L400TM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370034b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29L400TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x370034b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L400UM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700b5b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29L400UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700b5b3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L640TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700c922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x142,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L640UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3700cb22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x142,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L800ATM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37001ab3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29L800ATV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37001ab3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L800AUM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37009bb3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29L800AUV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37009bb3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L800TM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37001ab3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29L800TV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37001ab3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A29L800UM @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37009bb3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "A29L800UV @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x37009bb3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "A49FL004TL @PLCC32",
	.protocol_id = 0x50,
	.variant = 0xa1,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3799,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "A49FL004TX @TSOP32",
	.protocol_id = 0x50,
	.variant = 0xa1,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3799,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A49LF004TL @PLCC32",
	.protocol_id = 0x50,
	.variant = 0xa1,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3795,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "A49LF004TX @TSOP32",
	.protocol_id = 0x50,
	.variant = 0xa1,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x3795,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A49LF040ATL @PLCC32",
	.protocol_id = 0x50,
	.variant = 0xa1,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x379d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "A49LF040ATX @TSOP32",
	.protocol_id = 0x50,
	.variant = 0xa1,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x379d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "A49LF040TL @PLCC32",
	.protocol_id = 0x50,
	.variant = 0xa1,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x379d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "A49LF040TX @TSOP32",
	.protocol_id = 0x50,
	.variant = 0xa1,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x379d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AB28F200B5-B @SOP44",
	.protocol_id = 0x52,
	.variant = 0x81,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x89007522,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x800,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AB28F200B5-T @SOP44",
	.protocol_id = 0x52,
	.variant = 0x81,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x89007422,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x800,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AB28F200BX-B @SOP44",
	.protocol_id = 0x52,
	.variant = 0x81,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x89007522,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x800,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AB28F200BX-T @SOP44",
	.protocol_id = 0x52,
	.variant = 0x81,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x89007422,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x800,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AB28F400B5-B @SOP44",
	.protocol_id = 0x52,
	.variant = 0x81,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x89007144,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x800,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AB28F400B5-T @SOP44",
	.protocol_id = 0x52,
	.variant = 0x81,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x89007044,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x800,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AB28F400BX-B @SOP44",
	.protocol_id = 0x52,
	.variant = 0x81,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x89007144,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x800,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AB28F400BX-T @SOP44",
	.protocol_id = 0x52,
	.variant = 0x81,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x89007044,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x800,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AB28F800B5-B @SOP44",
	.protocol_id = 0x52,
	.variant = 0x81,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x89009d88,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x900,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AB28F800B5-T @SOP44",
	.protocol_id = 0x52,
	.variant = 0x81,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x89009c88,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x900,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AC25LV010",
	.protocol_id = 0x03,
	.variant = 0x06,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AC25LV010 @SOP8",
	.protocol_id = 0x03,
	.variant = 0x06,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AC25LV512",
	.protocol_id = 0x03,
	.variant = 0x06,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AC25LV512 @SOP8",
	.protocol_id = 0x03,
	.variant = 0x06,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AC39LV010 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AC39LV010 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AC39LV020 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AC39LV020 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AC39LV040 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x7f29,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AC39LV040 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x7f29,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AC39LV080 @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x08,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x7f21,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AC39LV512 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AC39LV512 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "ACE24C02A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C02A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C02A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C02B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C02B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C02B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C04A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C04A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C04A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C04B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C04B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C04B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C08A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C08A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C08A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C08B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C08B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C08B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C1024",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "ACE24C1024 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "ACE24C128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C16A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C16A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C16A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C16B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C16B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C16B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C512",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "ACE24C512 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "ACE24C512 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "ACE24C64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24C64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24LC02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24LC02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24LC02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24LC04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24LC04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24LC04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24LC08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24LC08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24LC08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24LC16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24LC16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE24LC16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "ACE93C46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C46(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C46(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C56(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C56(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C66(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "ACE93C66(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AE29F1008 @DIP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xdac1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AE29F1008 @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xdac1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AE29F1008 @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xdac1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AE29F2008 @DIP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xda45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AE29F2008 @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xda45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AE29F2008 @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xda45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AE29F4008 @DIP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xda46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AE29F4008 @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xda46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AE29F4008 @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xda46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AE49F2008 @DIP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xda0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x14,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AE49F2008 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xda0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x14,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AE49F2008 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0xda0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x14,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC01",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x04,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x04,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC01 #2",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC01 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x04,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x04,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC01 @SOIC8 #2",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC01 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x04,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x04,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC01 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC02 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC04 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC08 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC16 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24BC64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C128 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C256 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C32 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C64 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF24C64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC08",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC08 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC08 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC128",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC128 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC128 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC16",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC16 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC16 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC256",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC256 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC256 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC32",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC32 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC32 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC64",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC64 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF25BC64 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AF93BC46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC46(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC46(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC56(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC56(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC66(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC66(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC86(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC86(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC86(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC86(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC86(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93BC86(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C46(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C46(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C46(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C46(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C56(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C56(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C56(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C56(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C66(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C66(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C66(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C66(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C86(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C86(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C86(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C86(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C86(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C86(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C86(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AF93C86(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C10AF @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8f,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C45",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C45AF @SOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C45AV @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C45BH @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C45BL @SON8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C45CL @SON8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C45CT @TMSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C45CU @USON8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C45F @SOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C46",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C46F @SOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C46M",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C46MF @SOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C55",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C55AF @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C55AV @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C55BH @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C55BL @SON8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C55CL @SON8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C55CT @TMSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C55CU @USON8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C55F @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C56",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C56F @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C65",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C65AF @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C65AV @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C65BH @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C65BL @SON8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C65CL @SON8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C65CT @TMSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C65CU @USON8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C65F @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C66",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C66F @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C75",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C75AF @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C75AV @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C75BH @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C75F @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C85AF @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C85AM @SSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AK93C95AF @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM24LC02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC21",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC21 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC21 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC21B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC21B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AM24LC21B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AM27128A @DIP28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x189,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0xc8,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x3e,
},
{
	.name = "AM27128A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x189,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0xc8,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "AM2716B @DIP24",
	.protocol_id = 0x38,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x1f4,
	.opts4 = 0x48,
	.package_details = 0x18000000,
	.write_unlock = 0x0d,
},
{
	.name = "AM27256 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x104,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0xc8,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x3e,
},
{
	.name = "AM27256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x104,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0xc8,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "AM2732B @DIP24",
	.protocol_id = 0x38,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x1f4,
	.opts4 = 0x48,
	.package_details = 0x18000000,
	.write_unlock = 0x0d,
},
{
	.name = "AM27512 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x185,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0xc8,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x3e,
},
{
	.name = "AM27512 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x185,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0xc8,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "AM2764A @DIP28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x108,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x1f4,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x0d,
},
{
	.name = "AM2764A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x108,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x1f4,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x0d,
},
{
	.name = "AM27C010 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C010 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C020 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C020 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C040 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x19b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C040 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x19b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C080 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x11c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C080 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x11c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C1024 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1008c00,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C128 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x116,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C128 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x116,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C2048 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1009800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C256 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x110,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x110,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C4096 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1001900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C512 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x191,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C512 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x191,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C64 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x115,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27C64 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x115,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27H010 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27H010 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27H010 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AM27H256 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x110,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27H256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x110,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27HB010 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27HB010 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27HB010 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV010 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV010 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV010 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x10e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV020 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV020 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV020 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV020B @DIP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV020B @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV020B @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV040 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x19b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV040 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x19b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV040 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x19b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV080 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x11c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV080 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x11c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AM27LV080 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x11c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3002,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AM28C16A @DIP24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x18000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C16A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C17A @DIP28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C17A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C17A @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x1400,
	.opts2 = 0x01,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C64A @DIP28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C64A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C64A @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C64AE @DIP28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C64AE @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C64AE @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C64B @DIP28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C64B @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C64B @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C64BE @DIP28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C64BE @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28C64BE @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AM28F010",
	.protocol_id = 0x40,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a7,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM28F010 @PLCC32",
	.protocol_id = 0x40,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a7,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM28F010 @TSOP32",
	.protocol_id = 0x40,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a7,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM28F020",
	.protocol_id = 0x40,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x12a,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM28F020 @PLCC32",
	.protocol_id = 0x40,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x12a,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM28F020 @TSOP32",
	.protocol_id = 0x40,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x12a,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM28F256",
	.protocol_id = 0x40,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM28F256 @PLCC32",
	.protocol_id = 0x40,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM28F256 @TSOP32",
	.protocol_id = 0x40,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM28F512",
	.protocol_id = 0x40,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x125,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM28F512 @PLCC32",
	.protocol_id = 0x40,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x125,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM28F512 @TSOP32",
	.protocol_id = 0x40,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x125,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM29BL162CB @SOP56",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1000322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x06,
	.write_unlock = 0x03,
},
{
	.name = "AM29BL802CB @SOP56",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1008122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x06,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL161DB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1003922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL161DT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1003622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL162DB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1002e22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL162DT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1002d22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL163DB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1002b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL163DT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1002822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL164DB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1003522,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL164DT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1003322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL322DB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL322DT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005522,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL322GB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL322GT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005522,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL323DB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL323DT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005022,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL323GB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL323GT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005022,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL324DB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005f22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL324DT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005c22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL324GB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005f22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL324GT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005c22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL400BB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1000f22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL400BB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1000f22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL400BT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1000c22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL400BT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1000c22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL800BB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100cb22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL800BB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100cb22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL800BT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1004a22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29DL800BT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1004a22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002B @DIP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002B @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002B @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002BB @DIP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002BB @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002BB @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002BT @DIP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002BT @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002BT @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002NB @DIP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002NB @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002NB @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002NBB @DIP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002NBB @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002NBB @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x08,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002NBT @DIP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002NBT @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002NBT @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002NT @DIP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002NT @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002NT @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002T @DIP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002T @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F002T @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x07,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM29F010 @DIP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x120,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x02,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x02,
},
{
	.name = "AM29F010 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x120,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x02,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AM29F010 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x120,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x02,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "AM29F010B @DIP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x120,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x02,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x02,
},
{
	.name = "AM29F010B @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x120,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x02,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AM29F010B @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x120,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x02,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "AM29F016D @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x68,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1ad,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29F040 @DIP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F040 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F040 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM29F040B @DIP2",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F040B @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29F040B @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM29F080 @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x68,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1d5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29F080B @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x68,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1d5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29F100AB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100df22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F100AB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100df22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F100AT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F100AT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F100B @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100df22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F100B @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100df22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F100T @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F100T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F160DB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F160DT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d222,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F200AB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F200AB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F200AT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F200AT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F200BB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F200BB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F200BT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F200BT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F400AB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100ab22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F400AB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100ab22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F400AT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1002322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F400AT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1002322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F400BB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100ab22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F400BB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100ab22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F400BT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1002322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F400BT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1002322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F800AB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F800AB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F800AT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F800AT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F800B @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F800B @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F800BB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F800BB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F800BT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F800BT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29F800T @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29F800T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV001B @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x16d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AM29LV001B @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x16d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "AM29LV001BB @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x16d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AM29LV001BB @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x16d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "AM29LV001BT @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1ed,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AM29LV001BT @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1ed,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "AM29LV001T @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1ed,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AM29LV001T @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1ed,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "AM29LV002B @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1c2,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV002T @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x140,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV004B @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b6,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV004BB @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b6,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV004BT @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV004T @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1b5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV008B @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x137,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV008BB @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x137,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV008BT @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x13e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV008T @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x13e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV010B @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x16e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x02,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AM29LV010B @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x16e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x02,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "AM29LV017 @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1c8,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV020B @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x03,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AM29LV020B @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x03,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "AM29LV033C @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1a3,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV033M @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x17e,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV040B @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x14f,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV040B @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x14f,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x04,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV081 @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x138,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV160BB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1004922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV160BT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100c422,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV160DB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1004922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV160DT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100c422,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV200B @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100bf22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV200B @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100bf22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV200BB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100bf22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV200BB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100bf22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV200BT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1003b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV200BT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1003b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV200T @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1003b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV200T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1003b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV320DB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100f922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV320DT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100f622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV320MB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1007e22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV320MT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x38,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1007e22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV400B @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100ba22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV400B @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100ba22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV400BB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100ba22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV400BB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100ba22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV400BT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100b922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV400BT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100b922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV400T @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100b922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV400T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100b922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV641D @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x28,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100d722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV800B @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV800B @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV800BB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV800BB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV800BT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100da22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV800BT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100da22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV800DB @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV800DB @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1005b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV800DT @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100da22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV800DT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100da22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV800T @SOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100da22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AM29LV800T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x100da22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC46(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC46(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0a,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC56(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC56(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC66(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8b,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC66(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0c,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC86(x16)",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC86(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC86(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8d,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC86(x8)",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x8000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC86(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AM93LC86(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0e,
	.read_buffer_size = 0x40,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x50,
	.package_details = 0x88000000,
	.write_unlock = 0x03,
},
{
	.name = "AS29F002B",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x5234,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x02,
},
{
	.name = "AS29F002B @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x5234,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AS29F002B @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x5234,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "AS29F002T",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x52b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x02,
},
{
	.name = "AS29F002T @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x52b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AS29F002T @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x52b0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x00,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x02,
},
{
	.name = "AS29F200B @PSOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x52005722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AS29F200B @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x52005722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AS29F200T @PSOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x52005122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AS29F200T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x52005122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AS29LV160B @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x52004922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AS29LV160T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x5200c422,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AS29LV400B @PSOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x5200ba22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AS29LV400B @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x5200ba22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AS29LV400T @PSOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x5200b922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AS29LV400T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x5200b922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AS29LV800B @PSOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x52005b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AS29LV800B @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x52005b22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AS29LV800T @PSOP44",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x5200da22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x02,
	.write_unlock = 0x03,
},
{
	.name = "AS29LV800T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x5200da22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT24C01",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x04,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x04,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C01 @MSOP8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x04,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x04,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C01 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x04,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x04,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C01 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x04,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x04,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C01A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C01A @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C01A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C01A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C01B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C01B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C01B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C01B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02C",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02C @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C02C @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C04 @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C04A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C04A @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C04A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C04A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C04B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C04B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C04B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C04B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C08 @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C08A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C08A @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C08A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C08A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C08B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C08B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C08B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C08B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C1024",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C1024 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C1024B",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C1024B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C128 (3.3V)",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C128 (3.3V) @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C128 (3.3V) @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C128 (3.3V) @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C128 @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C128B",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C128B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C128B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C128B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C16A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C16A @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C16A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C16A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C16B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C16B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C16B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C16B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x10,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C21",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C21 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x400,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C256 (3.3V)",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C256 (3.3V) @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C256 (3.3V) @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C256 (3.3V) @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C256 @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C256B",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C256B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C256B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C256B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32A",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32A @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32C",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32C @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32C @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32C @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32D",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32D @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C32D @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24C512",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512 (3.3V)",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512 (3.3V) @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512 (3.3V) @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512 (3.3V) @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512 @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512B",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512C",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512C @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C512C @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64A",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64A @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64B",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64C",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64C @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64C @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64C @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64D",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64D @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24C64D @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x1388,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT24HC02B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24HC02B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24HC02B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x80,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24RF08A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x20,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x100,
	.opts2 = 0x10,
	.opts3 = 0x4e20,
	.opts4 = 0x800,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24RF08B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x20,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x100,
	.opts2 = 0x10,
	.opts3 = 0x4e20,
	.opts4 = 0x800,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT24RF08C @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x10,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x20,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x100,
	.opts2 = 0x10,
	.opts3 = 0x4e20,
	.opts4 = 0x800,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25010",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25010 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25010-1.8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25010-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25010A",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25010A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25010A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x80,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25020",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25020 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25020-1.8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25020-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25020A",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25020A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25020A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x100,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25040",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25040 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25040-1.8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25040-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25040A",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25040A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25040A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x08,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x08,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25080",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25080 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25080-1.8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25080-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25080A",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25080A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25080A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25080B",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25080B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25080B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x400,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25128",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25128 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25128-1.8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25128-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25128A",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25128A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25128B",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25128B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25128B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25160",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25160 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25160-1.8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25160-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25160A",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25160A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25160B",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25160B @MAP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25160B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25160B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25256",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25256 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25256-1.8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25256-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25256A",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25256A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25256B",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25256B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25256B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25320",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25320 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25320-1.8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25320-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25320A",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25320A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25320B",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25320B @MAP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25320B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25320B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25512",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25512 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25512 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25512-1.8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25512-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25512-1.8 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25640",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25640 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25640-1.8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25640-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25640A",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25640A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25640B",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25640B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25640B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25DF021",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f43,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF021 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f43,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF021 @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f43,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF041",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f44,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF041 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f44,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF041 @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f44,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF041A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f44,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF041A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f44,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF041A @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f44,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF081",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF081 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF081 @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF081A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF081A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF081A @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF161",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF161 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF161 @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF321",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF321 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF321A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF321A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25DF321A @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT25F1024",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f60,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F1024 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f60,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F1024 @VQFPN8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f60,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F1024A",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f60,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F1024A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f60,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F1024A @VQFPN8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f60,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F2048",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F2048 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F2048 @VQFPN8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F2048A",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F2048A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F2048A @VQFPN8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F4096",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f64,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F4096 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f64,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F4096 @VQFPN8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f64,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F4096A",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f64,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F4096A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f64,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F4096A @VQFPN8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f64,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F512",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f65,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F512 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f65,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F512 @VQFPN8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f65,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F512A",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f65,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F512A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f65,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25F512A @VQFPN8",
	.protocol_id = 0x03,
	.variant = 0x56,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f65,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25HP256",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25HP256 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25HP256-1.8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25HP256-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25HP512",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25HP512 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25HP512-1.8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT25HP512-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x2710,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT26DF081 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF081 @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF081A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF081A @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF161 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF161 @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF161A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF161A @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF321",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF321 @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x90000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF321 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF321A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x8000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF321A @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x90000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26DF321A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x34,
},
{
	.name = "AT26F004",
	.protocol_id = 0x03,
	.variant = 0x62,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x400030,
	.package_details = 0x8000000,
	.write_unlock = 0x01,
},
{
	.name = "AT26F004 @MLF8",
	.protocol_id = 0x03,
	.variant = 0x62,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x400030,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT26F004 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x62,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x400030,
	.package_details = 0x88000000,
	.write_unlock = 0x01,
},
{
	.name = "AT27256 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2904,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0xc8,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT27256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x2904,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0xc8,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT2732A @DIP24",
	.protocol_id = 0x38,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x1f4,
	.opts4 = 0x48,
	.package_details = 0x18000000,
	.write_unlock = 0x0d,
},
{
	.name = "AT27BV010",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV010 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV010 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV010 @VSOP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV020",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV020 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV020 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV020 @VSOP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV040",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV040 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV040 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV040 @VSOP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV1024 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e00f100,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV2048 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e00f700,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV256",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV256 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV4096 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e00f400,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV512",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV512 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27BV512 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C010 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C010 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C010 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27C010L @DIP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C010L @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C010L @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27C020 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C020 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C020 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27C040 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C040 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C040 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27C080 @DIP32",
	.protocol_id = 0x32,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8a,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x32,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT27C080 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8a,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x32,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT27C080 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8a,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x32,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT27C1024 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e00f100,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C1024L @DIP40",
	.protocol_id = 0x39,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e00f100,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C128 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x13,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f83,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C128 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f83,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C2048 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e00f700,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C256 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x298c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x298c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C256R @DIP28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C256R @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C256R @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C4096 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e00f400,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C512 @DIP28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C512 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C512R @DIP28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C512R @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27C512R @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27HC1024 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e006100,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27HC256",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27HC256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27HC256L",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27HC256L @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27HC256R",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27HC256R @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27HC256RL",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27HC256RL @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV010",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV010 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV010 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV010 @VSOP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV010A",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV010A @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV010A @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV010A @VSOP32",
	.protocol_id = 0x32,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV020",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV020 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV020 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV020 @VSOP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV020A",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV020A @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV020A @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV020A @VSOP32",
	.protocol_id = 0x32,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV040",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV040 @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV040 @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV040 @VSOP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV040A",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x20000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV040A @PLCC32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV040A @TSOP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV040A @VSOP32",
	.protocol_id = 0x32,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x05,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV1024 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x00,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e00f100,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV2048 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x01,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e00f700,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV256A",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV256A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV256A @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV256R",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV256R @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV256R @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x11,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e8c,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV4096 @DIP40",
	.protocol_id = 0x39,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e00f400,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x3030,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV512A",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV512A @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV512A @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV512R",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x1c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV512R @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x03,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0xff000000,
	.write_unlock = 0x05,
},
{
	.name = "AT27LV512R @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x10,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1e0d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x4000,
	.opts2 = 0x00,
	.opts3 = 0x64,
	.opts4 = 0x68,
	.package_details = 0x9c000000,
	.write_unlock = 0x05,
},
{
	.name = "AT28BV256",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28BV256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28BV64",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x01,
	.opts3 = 0xbb8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28BV64 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x01,
	.opts3 = 0xbb8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28BV64 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x01,
	.opts3 = 0xbb8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28BV64B",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28BV64B @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28BV64B @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C010",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C010 @PLCC32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C010 @TSOP32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT28C010E",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C010E @PLCC32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C010E @TSOP32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT28C04 @DIP24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C04 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C04 @SOIC24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x98000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C040",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C040 @PLCC32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C040 @TSOP32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT28C040E",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C040E @PLCC32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C040E @TSOP32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT28C04E @DIP24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C04E @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C04E @SOIC24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x98000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C04F @DIP24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C04F @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C04F @SOIC24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x98000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C16 @DIP24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C16 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C16 @SOIC24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x98000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C16E @DIP24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C16E @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C16E @SOIC24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x98000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C16F @DIP24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C16F @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C16F @SOIC24",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x98000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C17",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C17 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C17 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C17E",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C17E @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C17E @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C17F",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C17F @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C17F @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C256",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C256 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C256E",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0xbb8,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28C256E @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0xbb8,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28C256E @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0xbb8,
	.opts4 = 0xc010,
	.package_details = 0x9c000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28C256F",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0xbb8,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28C256F @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0xbb8,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28C256F @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0xbb8,
	.opts4 = 0xc010,
	.package_details = 0x9c000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28C64",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C64 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C64 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C64B",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C64B @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C64B @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28C64E",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C64E @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C64E @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C64F",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28C64F @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28C64F @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0xc8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x3e,
},
{
	.name = "AT28HC04",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28HC04 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x80,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x200,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28HC16",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28HC16L",
	.protocol_id = 0x38,
	.variant = 0x10,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x800,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x18000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28HC256",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC256E",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC256E @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC256F",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0xbb8,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28HC256F @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0xbb8,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28HC256L",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC256L @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC64",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28HC64 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x2710,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC64 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28HC64B",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC64B @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC64B @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC64BF",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC64BF @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC64BF @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC64L",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28HC64L @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x2710,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28HC64L @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x01,
	.opts3 = 0x3e8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x02,
},
{
	.name = "AT28LV010",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28LV010 @PLCC32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28LV010 @TSOP32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT28LV256",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28LV256 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28LV64",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x01,
	.opts3 = 0xbb8,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28LV64 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x01,
	.opts3 = 0xbb8,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28LV64 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x01,
	.opts3 = 0xbb8,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x1d3,
},
{
	.name = "AT28LV64B",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28LV64B @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28LV64B @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x202,
	.opts2 = 0x40,
	.opts3 = 0x2710,
	.opts4 = 0xc010,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28MC010",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc000,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28MC010 @PLCC32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc000,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28MC010 @TSOP32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc000,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT28MC020",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc000,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28MC020 @PLCC32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc000,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28MC020 @TSOP32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc000,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT28MC040",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc000,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28MC040 @PLCC32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc000,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28MC040 @TSOP32",
	.protocol_id = 0x3a,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x2710,
	.opts4 = 0xc000,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT28PC64",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28PC64 @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28PC64 @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28PC64E",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x10,
	.package_details = 0x1c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28PC64E @PLCC32",
	.protocol_id = 0x37,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x10,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT28PC64E @SOIC28",
	.protocol_id = 0x31,
	.variant = 0x26,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x20,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x200,
	.opts2 = 0x20,
	.opts3 = 0x2710,
	.opts4 = 0x10,
	.package_details = 0x9c000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29BV010A",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f35,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29BV010A @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f35,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29BV010A @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f35,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT29BV020",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fba,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29BV020 @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fba,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29BV020 @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fba,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT29BV040",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f3b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x200,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29BV040 @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f3b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x200,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29BV040 @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f3b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x200,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT29BV040A",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fc4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29BV040A @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fc4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29BV040A @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fc4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT29C010A",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fd5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C010A @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fd5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C010A @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fd5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT29C020",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fda,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C020 @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fda,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C020 @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fda,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT29C040",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f5b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x200,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C040 @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f5b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x200,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C040 @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f5b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x200,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT29C040A",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fa4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C040A @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fa4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C040A @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fa4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x100,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT29C256 @DIP28",
	.protocol_id = 0x30,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fdc,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x1c000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C257",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fdc,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C257 @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fdc,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x40,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C512",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f5d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C512 @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f5d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29C512 @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f5d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x80,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT29LV010A",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f35,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV010A @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f35,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV010A @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f35,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV020",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fba,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV020 @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fba,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV020 @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fba,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV040",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f3b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x200,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV040 @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f3b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x200,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV040 @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f3b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x200,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV040A",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fc4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV040A @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fc4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV040A @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fc4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV256 @DIP28",
	.protocol_id = 0x30,
	.variant = 0x01,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x40,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1fbc,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x40,
	.opts3 = 0x0a,
	.opts4 = 0x40c030,
	.package_details = 0x1c000000,
	.write_unlock = 0x03,
},
{
	.name = "AT29LV512",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f3d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x20000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV512 @PLCC32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f3d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0xff000000,
	.write_unlock = 0x01,
},
{
	.name = "AT29LV512 @TSOP32",
	.protocol_id = 0x30,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x80,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f3d,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x80,
	.opts3 = 0x14,
	.opts4 = 0x40c030,
	.package_details = 0x05,
	.write_unlock = 0x01,
},
{
	.name = "AT45DB011B @ICSP",
	.protocol_id = 0x04,
	.variant = 0x01,
	.read_buffer_size = 0x108,
	.write_buffer_size = 0x108,
	.code_memory_size = 0x21000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x108,
	.opts3 = 0x00,
	.opts4 = 0x600000,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB011D[Page256] @ICSP",
	.protocol_id = 0x04,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x1f24,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x00,
	.opts4 = 0x680a30,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB011D[Page264] @ICSP",
	.protocol_id = 0x04,
	.variant = 0x00,
	.read_buffer_size = 0x108,
	.write_buffer_size = 0x108,
	.code_memory_size = 0x21000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x1f24,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x108,
	.opts3 = 0x00,
	.opts4 = 0x680a30,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB021B @ICSP",
	.protocol_id = 0x04,
	.variant = 0x01,
	.read_buffer_size = 0x108,
	.write_buffer_size = 0x108,
	.code_memory_size = 0x42000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x108,
	.opts3 = 0x00,
	.opts4 = 0x600000,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB021D[Page256] @ICSP",
	.protocol_id = 0x04,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x1f24,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x00,
	.opts4 = 0x680a30,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB021D[Page264] @ICSP",
	.protocol_id = 0x04,
	.variant = 0x00,
	.read_buffer_size = 0x108,
	.write_buffer_size = 0x108,
	.code_memory_size = 0x42000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x1f24,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x108,
	.opts3 = 0x00,
	.opts4 = 0x680a30,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB041B @ICSP",
	.protocol_id = 0x04,
	.variant = 0x01,
	.read_buffer_size = 0x108,
	.write_buffer_size = 0x108,
	.code_memory_size = 0x84000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x108,
	.opts3 = 0x00,
	.opts4 = 0x600000,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB041D[Page256] @ICSP",
	.protocol_id = 0x04,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x1f24,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x00,
	.opts4 = 0x680a30,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB041D[Page264] @ICSP",
	.protocol_id = 0x04,
	.variant = 0x00,
	.read_buffer_size = 0x108,
	.write_buffer_size = 0x108,
	.code_memory_size = 0x84000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x1f24,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x108,
	.opts3 = 0x00,
	.opts4 = 0x680a30,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB081B @ICSP",
	.protocol_id = 0x04,
	.variant = 0x01,
	.read_buffer_size = 0x108,
	.write_buffer_size = 0x108,
	.code_memory_size = 0x108000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x108,
	.opts3 = 0x00,
	.opts4 = 0x600000,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB081D[Page256] @ICSP",
	.protocol_id = 0x04,
	.variant = 0x02,
	.read_buffer_size = 0x100,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x1f25,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x100,
	.opts3 = 0x00,
	.opts4 = 0x680a30,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB081D[Page264] @ICSP",
	.protocol_id = 0x04,
	.variant = 0x00,
	.read_buffer_size = 0x108,
	.write_buffer_size = 0x108,
	.code_memory_size = 0x108000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x1f25,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x108,
	.opts3 = 0x00,
	.opts4 = 0x680a30,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB161B @ICSP",
	.protocol_id = 0x04,
	.variant = 0x01,
	.read_buffer_size = 0x210,
	.write_buffer_size = 0x210,
	.code_memory_size = 0x210000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x00,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x02,
	.opts2 = 0x210,
	.opts3 = 0x00,
	.opts4 = 0x600000,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB161D[Page512] @ICSP",
	.protocol_id = 0x04,
	.variant = 0x02,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x200,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x1f26,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x200,
	.opts3 = 0x00,
	.opts4 = 0x680a30,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT45DB161D[Page528] @ICSP",
	.protocol_id = 0x04,
	.variant = 0x00,
	.read_buffer_size = 0x210,
	.write_buffer_size = 0x210,
	.code_memory_size = 0x210000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x40,
	.chip_id = 0x1f26,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x210,
	.opts3 = 0x00,
	.opts4 = 0x680a30,
	.package_details = 0x500,
	.write_unlock = 0x02,
},
{
	.name = "AT49BV001",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001 @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001A",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001A @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001A @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001A @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001AN",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001AN @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001AN @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001AN @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001ANT",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001ANT @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001ANT @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001ANT @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001AT",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001AT @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001AT @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001AT @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001N",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001N @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001N @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001N @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001NT",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001NT @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001NT @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001NT @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001T",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001T @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001T @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV001T @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002 @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002A",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002A @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002A @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002A @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002AN",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002AN @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002AN @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002AN @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002ANT",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002ANT @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002ANT @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002ANT @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002AT",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002AT @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002AT @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002AT @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002N",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002N @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002N @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002N @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002NT",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002NT @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002NT @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002NT @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002T",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002T @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002T @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV002T @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV004 @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f11,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV004T @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f20,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV008A @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f22,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV008AT @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x18,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f21,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x102,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV010",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV010 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV010 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV010 @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV020",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV020 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV020 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV020 @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f0b,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040 @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040A",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040A @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040A @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040A @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040B",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040B @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040B @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040B @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040T",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040T @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040T @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV040T @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV080 @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x68,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f23,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV080T @TSOP40",
	.protocol_id = 0x53,
	.variant = 0x68,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f27,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x03,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV1024A @VSOP40",
	.protocol_id = 0x54,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f008700,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x04,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV160 @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x48,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV1604 @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x28,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV1604T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x28,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV160T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x48,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV161 @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x48,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV1614 @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x28,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV1614T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x28,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV161T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x48,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV162A @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x58,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV162AT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x58,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV163A @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x08,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV163AT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x08,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV2048A @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x28,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f008200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV320 @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x08,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV320D @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x40,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c590,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV320T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x08,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV321 @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x08,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV3218 @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x48,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00d800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV3218T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x48,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00d900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV321T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x08,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV322 @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x08,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV322T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x08,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV4096A @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x28,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f009200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV4096AT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x28,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f009000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV512",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV512 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV512 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV512 @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV6416 @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x48,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00d600,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV6416T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x48,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00d200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV8011 @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x28,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00cb00,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV8011T @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x28,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f004a00,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV802A @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x08,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c100,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV802AT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x08,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00c300,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff02,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV8192A @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x28,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00a000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49BV8192AT @TSOP48",
	.protocol_id = 0x52,
	.variant = 0x28,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f00a300,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0xff42,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x1002078,
	.package_details = 0x01,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001 @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001 @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001 @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001A",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001A @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001A @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001A @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001AN",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001AN @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001AN @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001AN @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001ANT",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x20000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001ANT @PLCC32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0xff000000,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001ANT @TSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001ANT @VSOP32",
	.protocol_id = 0x36,
	.variant = 0x00,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memory2_size = 0x00,
	.chip_id = 0x1f04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x00,
	.opts2 = 0x00,
	.opts3 = 0x0a,
	.opts4 = 0x78,
	.package_details = 0x05,
	.write_unlock = 0x03,
},
{
	.name = "AT49F001AT",
	.protocol_id = 0x36,
	.variant = 0x80,
	.read_buffer_size = 0x200,
	.write_buffer_size = 0x100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x00,
	.data_memo