
/*
 * infoic2plus_devices.h - Device names and characteristics.
 *
 * This file is a part of Minipro.
 *
 * Minipro is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Minipro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

/* Note, this file really isn't copyrightable. */

{
	.name = "ACE24AC02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC32D",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC32D @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC32D @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24AC512",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24AC512 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24AC512 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24AC1024",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24AC1024 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24C02A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C02A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C02A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C02B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C02B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C02B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C04A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C04A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C04A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C04B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C04B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C04B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C08A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C08A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C08A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C08B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C08B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C08B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C16A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C16A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C16A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C16B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C16B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C16B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C512",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24C512 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24C512 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24C1024",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24C1024 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24LA02A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LA02A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LA02A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LA04A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LA04A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LA04A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LA08A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LA08A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LA08A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LA16A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LA16A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LA16A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C64A",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C64A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C64A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C256A",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C256A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C256A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24C512A",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24C512A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24C512A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE24LC02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LC02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LC02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LC04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LC04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LC04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LC08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LC08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LC08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LC16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LC16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE24LC16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ACE25AC512G",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE4010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25AC512G @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE4010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25AC512G @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE4010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25AC100G",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE4011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25AC100G @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE4011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25AC100G @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE4011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25AC200G",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE4012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25AC200G @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE4012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25AC200G @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE4012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25AC400G",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE4013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25AC400G @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE4013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25AC400G @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE4013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C512C",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C512C @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C512C @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C512C(OTP)",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0300,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0020,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C512C(OTP) @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0300,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0020,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C512C(OTP) @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0300,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0020,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C100C",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C100C @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C100C @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C100C(OTP)",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0300,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0020,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C100C(OTP) @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0300,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0020,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C100C(OTP) @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0300,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0020,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C200C",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C200C @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C200C @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C200C(OTP)",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0300,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0020,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C200C(OTP) @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0300,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0020,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C200C(OTP) @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0300,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0020,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C400C",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C400C @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C400C @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C400C(OTP)",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0300,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0020,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C400C(OTP) @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0300,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0020,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25C400C(OTP) @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0300,
	.data_memory2_size = 0x0000,
	.chip_id = 0x856013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0020,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA512G",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA512G @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA512G @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA100G",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA100G @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA100G @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA200G",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA200G @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA200G @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA400G",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA400G @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA400G @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA800G",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA800G @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA800G @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA160G",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA160G @SON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE25QA160G @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "ACE93C46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C46(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C46(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C46A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C46A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C46A(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C46A(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C46A(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C46A(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C56(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C56(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C56A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C56A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C56A(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C56A(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C56A(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C56A(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C66(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C66(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C66A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C66A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C66A(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C66A(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C66A(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ACE93C66A(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC86(x8)",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC86(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC86(x16)",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93LC86(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AC25LV512",
	.protocol_id = 0x03,
	.variant = 0x06,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AC25LV512 @SOP8",
	.protocol_id = 0x03,
	.variant = 0x06,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AC25LV010",
	.protocol_id = 0x03,
	.variant = 0x06,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AC25LV010 @SOP8",
	.protocol_id = 0x03,
	.variant = 0x06,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404210,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AC39LV010  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AC39LV010  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AC39LV020  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AC39LV020  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AC39LV040  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x7F29,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AC39LV040  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x7F29,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AC39LV080  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x7F21,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AC39LV512  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AC39LV512  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AF24BC01",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0004,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0004,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC01 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0004,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0004,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC01 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0004,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0004,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC02 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC04 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC08 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC16 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C32 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C64 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C128 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C256 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF93C46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C46(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C46(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C56(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C56(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C66(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C66(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C86(x8)",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C86(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C86(x8) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C86(x16)",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C86(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C86(x16) @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "A24C02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "A24C02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "A24C02 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "A24C04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "A24C04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "A24C04 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "A24C08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "A24C08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "A24C08 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "A24C16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "A24C16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "A24C16 @TSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "A93C46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C46(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C46(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C66(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "A93C66(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "M8720",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0014,
	.opts4 = 0x0058,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "M8720 @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0014,
	.opts4 = 0x0058,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AS29F002T",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x52B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0002,
},
{
	.name = "AS29F002T @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x52B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AS29F002T @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x52B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "AS29F002B",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x5234,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0002,
},
{
	.name = "AS29F002B @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x5234,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AS29F002B @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x5234,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "AS29LV160T @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x5200C422,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AS29LV160B @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x52004922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AS29F200B @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x52005722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AS29F200B @PSOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x52005722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AS29F200T @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x52005122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AS29F200T @PSOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x52005122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AS29LV400B @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x5200BA22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AS29LV400B @PSOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x5200BA22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AS29LV400T @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x5200B922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AS29LV400T @PSOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x5200B922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AS29LV800B @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x52005B22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AS29LV800B @PSOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x52005B22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AS29LV800T @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x5200DA22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AS29LV800T @PSOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x5200DA22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM2716B    @DIP24",
	.protocol_id = 0x0B,
	.variant = 0x00,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x01F4,
	.opts4 = 0x0048,
	.package_details = 0x18000000,
	.write_unlock = 0x000D,
},
{
	.name = "AM2732B    @DIP24",
	.protocol_id = 0x0B,
	.variant = 0x01,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x01F4,
	.opts4 = 0x0048,
	.package_details = 0x18000000,
	.write_unlock = 0x000D,
},
{
	.name = "AM2764A    @DIP28",
	.protocol_id = 0x07,
	.variant = 0x13,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0108,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x01F4,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x000D,
},
{
	.name = "AM2764A    @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x00,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0108,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x01F4,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x000D,
},
{
	.name = "AM27128A   @DIP28",
	.protocol_id = 0x07,
	.variant = 0x13,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0189,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x00C8,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x003E,
},
{
	.name = "AM27128A   @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x01,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0189,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x00C8,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x003E,
},
{
	.name = "AM27256    @DIP28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0104,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x00C8,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x003E,
},
{
	.name = "AM27256    @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0104,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x00C8,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x003E,
},
{
	.name = "AM27512    @DIP28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0185,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x00C8,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x003E,
},
{
	.name = "AM27512    @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x03,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0185,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x00C8,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x003E,
},
{
	.name = "AM27C64    @DIP28",
	.protocol_id = 0x07,
	.variant = 0x13,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0115,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C64    @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x00,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0115,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C010   @DIP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C010   @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C020   @DIP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C020   @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C040   @DIP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x019B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C040   @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x019B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C080   @DIP32",
	.protocol_id = 0x08,
	.variant = 0x03,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x011C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C080   @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x03,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x011C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C128   @DIP28",
	.protocol_id = 0x07,
	.variant = 0x13,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0116,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C128   @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x01,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0116,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C256   @DIP28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0110,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C256   @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0110,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C512   @DIP28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0191,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C512   @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x03,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0191,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C1024  @DIP40",
	.protocol_id = 0x09,
	.variant = 0x00,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1008C00,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C2048  @DIP40",
	.protocol_id = 0x09,
	.variant = 0x01,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1009800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27C4096  @DIP40",
	.protocol_id = 0x09,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1001900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV010  @DIP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV010  @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV010  @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV020  @DIP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV020  @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV020  @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV020B @DIP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV020B @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV020B @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0197,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV040  @DIP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x019B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV040  @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x019B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV040  @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x019B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV080  @DIP32",
	.protocol_id = 0x08,
	.variant = 0x03,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x011C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV080  @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x03,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x011C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27LV080  @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x03,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x011C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AM27H010   @DIP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27H010   @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27H010   @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AM27H256   @DIP28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0110,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27H256   @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0110,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27HB010  @DIP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27HB010  @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AM27HB010  @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AM28C16A @DIP24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0014,
	.opts2 = 0x0001,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x18000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C16A @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0014,
	.opts2 = 0x0001,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C17A @DIP28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0014,
	.opts2 = 0x0001,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C17A @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0014,
	.opts2 = 0x0001,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C17A @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0014,
	.opts2 = 0x0001,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C64A @DIP28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C64A @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C64A @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C64AE @DIP28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C64AE @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C64AE @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C64B @DIP28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C64B @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C64B @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C64BE @DIP28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C64BE @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28C64BE @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM28F256",
	.protocol_id = 0x10,
	.variant = 0x00,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM28F256 @PLCC32",
	.protocol_id = 0x10,
	.variant = 0x00,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM28F256 @TSOP32",
	.protocol_id = 0x10,
	.variant = 0x00,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM28F512",
	.protocol_id = 0x10,
	.variant = 0x00,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0125,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM28F512 @PLCC32",
	.protocol_id = 0x10,
	.variant = 0x00,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0125,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM28F512 @TSOP32",
	.protocol_id = 0x10,
	.variant = 0x00,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0125,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM28F010",
	.protocol_id = 0x10,
	.variant = 0x00,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A7,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM28F010 @PLCC32",
	.protocol_id = 0x10,
	.variant = 0x00,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A7,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM28F010 @TSOP32",
	.protocol_id = 0x10,
	.variant = 0x00,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A7,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM28F020",
	.protocol_id = 0x10,
	.variant = 0x00,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x012A,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM28F020 @PLCC32",
	.protocol_id = 0x10,
	.variant = 0x00,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x012A,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM28F020 @TSOP32",
	.protocol_id = 0x10,
	.variant = 0x00,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x012A,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM29BL162CB  @SOP56",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1000322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000006,
	.write_unlock = 0x0003,
},
{
	.name = "AM29BL802CB  @SOP56",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1008122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000006,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL161DB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1003922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL161DT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1003622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL162DB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1002E22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL162DT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1002D22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL163DB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1002B22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL163DT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1002822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL164DB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1003522,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL164DT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1003322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL322DB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL322DT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005522,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL322GB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL322GT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005522,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL323DB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL323DT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005022,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL323GB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL323GT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005022,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL324DB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005F22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL324DT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005C22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL324GB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005F22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL324GT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005C22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL400BB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1000F22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL400BB  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1000F22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL400BT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1000C22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL400BT  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1000C22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL800BB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100CB22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL800BB  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100CB22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL800BT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1004A22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29DL800BT  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1004A22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002B   @DIP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002B   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002B   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002BB  @DIP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002BB  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002BB  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002BT  @DIP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002BT  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002BT  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002NB  @DIP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002NB  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002NB  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002NBB @DIP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002NBB @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002NBB @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0134,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002NBT @DIP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002NBT @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002NBT @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002NT  @DIP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002NT  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002NT  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002T   @DIP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002T   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F002T   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F010    @DIP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0120,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0002,
},
{
	.name = "AM29F010    @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0120,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AM29F010    @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0120,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "AM29F010B   @DIP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0120,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0002,
},
{
	.name = "AM29F010B   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0120,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AM29F010B   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0120,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "AM29F016D   @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x68,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01AD,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F040    @DIP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F040    @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F040    @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F040B   @DIP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F040B   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F040B   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F080    @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x68,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01D5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F080B   @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x68,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01D5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F100AB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100DF22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F100AB  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100DF22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F100AT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F100AT  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F100B   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100DF22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F100B   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100DF22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F100T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F100T   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F160DB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F160DT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D222,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F200AB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F200AB  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F200AT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F200AT  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F200BB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F200BB  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F200BT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F200BT  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005122,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F400AB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100AB22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F400AB  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100AB22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F400AT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1002322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F400AT  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1002322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F400BB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100AB22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F400BB  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100AB22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F400BT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1002322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F400BT  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1002322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F800AB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F800AB  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F800AT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F800AT  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F800B   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F800B   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F800BB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F800BB  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F800BT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F800BT  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F800T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29F800T   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV001B  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x016D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AM29LV001B  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x016D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "AM29LV001BB @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x016D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AM29LV001BB @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x016D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "AM29LV001BT @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01ED,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AM29LV001BT @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01ED,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "AM29LV001T  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01ED,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AM29LV001T  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01ED,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "AM29LV002B  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01C2,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV002T  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0140,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV004B  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B6,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV004BB @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B6,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV004BT @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV004T  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01B5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV008B  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0137,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV008BB @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0137,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV008BT @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x013E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV008T  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x013E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV010B  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x016E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AM29LV010B  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x016E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "AM29LV017   @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01C8,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV020B  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0003,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AM29LV020B  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0003,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "AM29LV033C  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x01A3,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV033M  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x017E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV040B  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x014F,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV040B  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x014F,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV081   @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0138,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV160BB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1004922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV160BT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100C422,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV160DB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1004922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV160DT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100C422,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV200B   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100BF22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV200B   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100BF22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV200BB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100BF22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV200BB  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100BF22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV200BT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1003B22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV200BT  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1003B22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV200T   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1003B22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV200T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1003B22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV320DB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100F922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV320DT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100F622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV320MB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1007E22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV320MT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1007E22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV400B   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100BA22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV400B   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100BA22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV400BB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100BA22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV400BB  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100BA22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV400BT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100B922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV400BT  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100B922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV400T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100B922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV400T   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100B922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV641D   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100D722,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV800B   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005B22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV800B   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005B22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV800BB  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005B22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV800BB  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1005B22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV800BT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100DA22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV800BT  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100DA22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV800T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100DA22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AM29LV800T   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x100DA22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A25L05PT @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372020,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L05PT @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372020,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L05PT @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372020,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L05PU @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L05PU @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L05PU @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L10PT @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372021,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L10PT @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372021,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L10PT @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372021,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L10PU @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L10PU @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L10PU @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L20PT @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372022,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L20PT @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372022,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L20PT @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372022,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L20PU @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L20PU @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L20PU @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L40PT @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372023,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L40PT @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372023,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L40PT @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372023,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L40PU @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L40PU @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L40PU @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L80PT @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372024,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L80PT @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372024,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L80PT @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372024,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L80PU @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L80PU @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L80PU @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L16PT @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372025,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L16PT @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372025,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L16PT @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372025,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L16PU @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L16PU @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L16PU @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L512  @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L512  @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L512  @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L010  @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L010  @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L010  @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L020  @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L020  @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L020  @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L040  @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L040  @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L040  @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L080  @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L080  @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L080  @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L016  @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L016  @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L016  @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L032  @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L032  @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25L032  @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LQ16   @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LQ16   @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LQ16   @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LQ32  @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LQ32  @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LQ32  @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LQ32A  @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LQ32A  @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LQ32A  @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LQ64  @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374017,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LQ64  @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374017,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LQ64  @SOP16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374017,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400030,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LS512A  @DIP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LS512A  @SOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A25LS512A  @TSOP8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "A27020    @DIP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3764,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "A27020    @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3764,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "A27020L   @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3764,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "A276308   @DIP28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "A276308   @SOP28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x9C000000,
	.write_unlock = 0x0005,
},
{
	.name = "A276308L  @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x03,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x373D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "A276308A  @DIP28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "A276308A  @SOP28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x9C000000,
	.write_unlock = 0x0005,
},
{
	.name = "A276308AL @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x03,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x372C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "A278308   @DIP28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3761,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "A278308L  @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3761,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "A278308A  @DIP28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3764,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "A278308AL @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3764,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "A29001T",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0005,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29001T  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0005,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29001T  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0005,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A29001U",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0006,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29001U  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0006,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29001U  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0006,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A290011T",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0005,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A290011T @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0005,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A290011T @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0005,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A290011U",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0006,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A290011U @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0006,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A290011U @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x374C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0006,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A29002T",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x378C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29002T  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x378C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29002T  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x378C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A29002U",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29002U  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29002U  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A290021T",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x378C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A290021T @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x378C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A290021T @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x378C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0007,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A290021U",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A290021U @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A290021U @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0008,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A29512",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29512   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29512   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A29512A",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29512A  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29512A  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A29010",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000B,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29010   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000B,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29010   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37A4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000B,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A29040",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29040   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29040   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A29040A",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29040A  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29040A  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A29040B",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29040B  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0xA0000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29040B  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3786,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A29400TV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700B0B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29400TM   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700B0B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29400UV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370031B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29400UM   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370031B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29800TV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37000EB3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29800TM   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37000EB3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29800UV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37008FB3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29800UM   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37008FB3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29801TV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700D622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29801TM   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700D622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29801UV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29801UM   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37005822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29DL162TV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37002D22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29DL162UV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37002E22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29DL163TV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37002822,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29DL163UV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37002B22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29DL164TV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37003322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29DL164UV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37003522,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29DL322TV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37005522,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29DL322UV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37005622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29DL323TV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37005022,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29DL323UV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37005322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29DL324TV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37005C22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29DL324UV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37005F22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L040    @DIP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3792,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29L040    @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3792,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29L040    @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3792,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A29L040A   @DIP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3792,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29L040A   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3792,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "A29L040A   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3792,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A29L004ATL @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004ATV @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004ATW @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x1A,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "A29L004ATX @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004ATY @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004AUL @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37B5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004AUV @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37B5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004AUW @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x1A,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37B5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "A29L004AUX @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37B5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004AUY @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37B5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004TL  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004TV  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004TW  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "A29L004TX  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3734,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004UL  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37B5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004UV  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37B5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "A29L004UW  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37B5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "A29L004UX  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37B5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0000,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0002,
},
{
	.name = "A29L008TV  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x371A,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "A29L008UV  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x379B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "A29L008ATV @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x1A,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x371A,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "A29L008AUV @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x1A,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x379B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "A29L400TV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370034B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L400TM   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370034B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29L400UV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700B5B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L400UM   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700B5B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29L400ATV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370034B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L400ATM  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370034B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29L400AUM  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700B5B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29L400AUV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700B5B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L800TV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37001AB3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L800TM   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37001AB3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29L800UV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37009BB3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L800UM   @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37009BB3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29L800ATV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37001AB3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L800ATM  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37001AB3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29L800AUV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37009BB3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L800AUM  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37009BB3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "A29L160TV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700A8B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L160UV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x370029B3,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L160ATV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700C422,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L160AUV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x37004922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L320TV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700F622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L320UV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700F922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L320ATV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700F622,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L320AUV  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700F922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L640TV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700C922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A29L640UV   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x38,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3700CB22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "A49LF004TL  @PLCC32",
	.protocol_id = 0x11,
	.variant = 0xA1,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3795,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "A49LF004TX  @TSOP32",
	.protocol_id = 0x11,
	.variant = 0xA1,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3795,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A49LF040TL  @PLCC32",
	.protocol_id = 0x11,
	.variant = 0xA1,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x379D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "A49LF040TX  @TSOP32",
	.protocol_id = 0x11,
	.variant = 0xA1,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x379D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A49LF040ATL @PLCC32",
	.protocol_id = 0x11,
	.variant = 0xA1,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x379D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "A49LF040ATX @TSOP32",
	.protocol_id = 0x11,
	.variant = 0xA1,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x379D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "A49FL004TL  @PLCC32",
	.protocol_id = 0x11,
	.variant = 0xA1,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3799,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "A49FL004TX  @TSOP32",
	.protocol_id = 0x11,
	.variant = 0xA1,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x3799,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "27CX010   @DIP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "27CX010   @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x010E,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "27CX256   @DIP28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0110,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "27CX256   @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0110,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "93C46",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93C46  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93C46A",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93C46A @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93C56A",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93C56A @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93C66A",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93C66A @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93CX46",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93CX46 @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93CX56",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93CX56 @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "93CX66",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "93CX66 @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM24LC02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC21",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0004,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC21 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0004,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC21 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0004,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC21B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0004,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC21B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0004,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM24LC21B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0004,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AM93LC46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC46(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC46(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC56(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC56(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC66(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC66(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC86(x8)",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC86(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC86(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC86(x16)",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC86(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AM93LC86(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF24BC01",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC01 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24BC256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF24C256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC08",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC08 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC08 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC16",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC16 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC16 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC32",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC32 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC32 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC64",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC64 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC64 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC128",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC128 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC128 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC256",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC256 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF25BC256 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AF93BC46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC46(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC46(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC56(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC56(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC66(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC66(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC86(x8)",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC86(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC86(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC86(x16)",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC86(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93BC86(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C46(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C46(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C56(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C56(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C66(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C66(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C86(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AF93C86(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "24AA02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24AA02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24AA02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC01A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC01A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC01A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC01B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC01B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC01B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC02A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC02A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC02A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC02B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC02B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC02B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC04A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC04A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC04A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC04B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC04B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC04B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC08A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC08A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC08A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC08B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC08B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC08B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC16A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC16A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC16A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24LC256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AK6416A",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0082,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK6416AM",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0080,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK6416BH",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0080,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK6420A",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0082,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK6420AM",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0080,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK6420BH",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0080,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK6440A",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0082,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK6440AM",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0080,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK6440BH",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0080,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK6480A",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0082,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK6480AM",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0080,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK6480BH",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0080,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK6510CM @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AK6510CL @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AK6512CM @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AK6512CL @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AK6514CM @MSOP8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AK6514CL @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AK6516CF @DFN8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x404200,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AK93C45",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C45F  @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C45AV @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C45AF @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C45BH @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C45BL @SON8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C45CT @TMSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C45CL @SON8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C45CU @USON8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C46",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C46F  @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C46M",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C46MF @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C55",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C55F  @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C55AV @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C55AF @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C55BH @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C55BL @SON8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C55CT @TMSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C55CL @SON8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C55CU @USON8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C56",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C56F  @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C65",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C65F  @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C65AV @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C65AF @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C65BH @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C65BL @SON8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C65CT @TMSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C65CL @SON8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C65CU @USON8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C66",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C66F  @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C75",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C75F  @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C75AV @TSSOP8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C75AF @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C75BH @MSOP8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C85AM @SSOP8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C85AF @SOP8 *",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C95AF @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AK93C10AF @SOP8",
	.protocol_id = 0x02,
	.variant = 0x8F,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AE29F1008 @DIP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xDAC1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AE29F1008 @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xDAC1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AE29F1008 @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xDAC1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AE29F2008 @DIP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xDA45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AE29F2008 @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xDA45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AE29F2008 @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xDA45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AE29F4008 @DIP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xDA46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AE29F4008 @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xDA46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AE29F4008 @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xDA46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AE49F2008 @DIP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xDA0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0014,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AE49F2008 @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xDA0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0014,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AE49F2008 @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xDA0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0014,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AX24C02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AX24C02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AX24C04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AX24C04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AX24C08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AX24C08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AX24C16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AX24C16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "SMJ27C010A @DIP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x97D6,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "SMJ27C010A @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x97D6,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "SMJ27C010A @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x97D6,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "SMJ27C040 @DIP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x9750,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "SMJ27C040 @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x9750,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "SMJ27C040 @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x9750,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "SMJ27C128 @DIP28",
	.protocol_id = 0x07,
	.variant = 0x13,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x9783,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "SMJ27C128 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x01,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x9783,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "SMJ27C256 @DIP28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x9704,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "SMJ27C256 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x9704,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "SMJ27C512 @DIP28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x9785,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "SMJ27C512 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x03,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x9785,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "ATC24C02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24C02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24C02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24C04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24C04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24C04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24C08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24C08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24C08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24C16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24C16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24C16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24LC02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24LC02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24LC02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24LC04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24LC04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24LC04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24LC08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24LC08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24LC08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24LC16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24LC16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC24LC16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATC93C46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C46(x8)  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C46(x16)  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C46R(x8) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C46R(x16) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C56(x8)  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C56(x16)  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C56R(x8) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C56R(x16) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C66(x8)  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C66(x16)  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C66R(x8) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93C66R(x16) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC46(x8)  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC46(x16)  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC46R(x8) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC46R(x16) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC56(x8)  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC56(x16)  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC56R(x8) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC56R(x16) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC66(x8)  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC66(x16)  @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC66R(x8) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATC93LC66R(x16) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT24C01",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0004,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0004,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C01 @MSOP8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0004,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0004,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C01 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0004,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0004,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C01 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0004,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0004,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C01A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C01A @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C01A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C01A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C01B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C01B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C01B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C01B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02C",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02C @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C02C @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C04 @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C04A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C04A @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C04A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C04A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C04B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C04B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C04B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C04B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C08 @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C08A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C08A @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C08A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C08A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C08B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C08B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C08B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C08B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C16A",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C16A @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C16A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C16A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C16B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C16B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C16B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C16B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C21",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0004,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C21 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0004,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32A",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32A @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32C",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32C @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32C @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32C @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32D",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32D @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C32D @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24C64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64A",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64A @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64A @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64B",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64C",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64C @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64C @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64C @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64D",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64D @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C64D @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C128 @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C128 (3.3V)",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C128 (3.3V) @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C128 (3.3V) @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C128 (3.3V) @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C128B",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C128B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C128B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C128B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C256 @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C256 (3.3V)",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C256 (3.3V) @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C256 (3.3V) @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C256 (3.3V) @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C256B",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C256B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C256B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C256B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512 @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512 (3.3V)",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512 (3.3V) @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512 (3.3V) @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512 (3.3V) @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512B",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512B @MAP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512C",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512C @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C512C @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C1024",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C1024 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C1024B",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24C1024B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT24HC02B",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24HC02B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24HC02B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24RF08A @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0020,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0001,
	.opts2 = 0x0010,
	.opts3 = 0x4E20,
	.opts4 = 0x0800,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24RF08B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0020,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0001,
	.opts2 = 0x0010,
	.opts3 = 0x4E20,
	.opts4 = 0x0800,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT24RF08C @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0020,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0001,
	.opts2 = 0x0010,
	.opts3 = 0x4E20,
	.opts4 = 0x0800,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25010",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25010 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25010-1.8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25010-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25010A",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25010A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25010A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25020",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25020  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25020-1.8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25020-1.8  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25020A",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25020A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25020A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25040",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25040 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25040-1.8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25040-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25040A",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25040A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25040A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25080",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25080 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25080-1.8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25080-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25080A",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25080A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25080A @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25080B",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25080B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25080B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25160",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25160 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25160-1.8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25160-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25160A",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25160A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25160B",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25160B @MAP8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25160B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25160B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25320",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25320 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25320-1.8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25320-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25320A",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25320A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25320B",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25320B @MAP8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25320B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25320B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25640",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25640 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25640-1.8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25640-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25640A",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25640A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25640B",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25640B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25640B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25128",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25128 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25128-1.8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25128-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25128A",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25128A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25128B",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25128B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25128B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25256",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25256 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25256-1.8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25256-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25256A",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25256A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25256B",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25256B @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25256B @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25512",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25512 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25512 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25512-1.8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25512-1.8 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25512-1.8 @TSSOP8",
	.protocol_id = 0x03,
	.variant = 0x81,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x1388,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF021",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4300,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF021 @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4300,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF021 @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4300,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF041",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4400,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF041  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4400,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF041  @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4400,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF041A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4400,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF041A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4400,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF041A @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4400,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF081",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4500,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF081  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4500,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF081  @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4500,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF081A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4500,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF081A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4500,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF081A @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4500,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF161",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4600,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF161  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4600,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF161  @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4600,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF321",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4700,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF321   @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4700,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF321  @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4700,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF321A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4700,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF321A  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4700,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF321A  @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4700,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF321A  @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4700,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF641   @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4800,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25DF641  @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F4800,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT25F512",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F65,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F512  @SOIC8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F65,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F512  @VQFPN8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F65,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F512A",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F65,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F512A @SOIC8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F65,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F512A @VQFPN8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F65,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F1024",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F60,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F1024  @SOIC8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F60,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F1024  @VQFPN8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F60,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F1024A",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F60,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F1024A @SOIC8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F60,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F1024A @VQFPN8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F60,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F2048",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F2048  @SOIC8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F2048  @VQFPN8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F2048A",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F2048A @SOIC8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F2048A @VQFPN8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F4096",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F64,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F4096  @SOIC8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F64,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F4096  @VQFPN8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F64,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F4096A",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F64,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F4096A @SOIC8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F64,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25F4096A @VQFPN8",
	.protocol_id = 0x0F,
	.variant = 0x56,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F64,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x2710,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT25HP256",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0001,
},
{
	.name = "AT25HP256  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AT25HP256-1.8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0001,
},
{
	.name = "AT25HP256-1.8  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AT25HP512",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0001,
},
{
	.name = "AT25HP512  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AT25HP512-1.8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x08000500,
	.write_unlock = 0x0001,
},
{
	.name = "AT25HP512-1.8  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x2710,
	.opts4 = 0x104200,
	.package_details = 0x88000500,
	.write_unlock = 0x0001,
},
{
	.name = "AT26DF081   @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF081   @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF081A  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF081A  @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F45,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF161   @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF161   @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF161A  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF161A  @UDFN8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F46,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF321",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF321   @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF321   @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF321A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF321A  @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26DF321A  @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F47,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404030,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "AT26F004",
	.protocol_id = 0x0F,
	.variant = 0x62,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x0014,
	.opts4 = 0x400030,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT26F004 @MLF8",
	.protocol_id = 0x0F,
	.variant = 0x62,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x0014,
	.opts4 = 0x400030,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT26F004 @SOIC8",
	.protocol_id = 0x0F,
	.variant = 0x62,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x0014,
	.opts4 = 0x400030,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT2732A @DIP24",
	.protocol_id = 0x0B,
	.variant = 0x01,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x01F4,
	.opts4 = 0x0048,
	.package_details = 0x18000000,
	.write_unlock = 0x000D,
},
{
	.name = "AT27256 @DIP28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x2904,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x00C8,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT27256 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x2904,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x00C8,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT27C010 @DIP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C010 @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C010 @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C010L @DIP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C010L @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C010L @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C020 @DIP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C020 @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C020 @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C040 @DIP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C040 @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C040 @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C080 @DIP32",
	.protocol_id = 0x08,
	.variant = 0x03,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8A,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0032,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT27C080 @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x03,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8A,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0032,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT27C080 @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x03,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8A,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0032,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT27C128  @DIP28",
	.protocol_id = 0x07,
	.variant = 0x13,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F83,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C128  @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x01,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F83,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C256  @DIP28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x298C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C256  @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x298C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C256R @DIP28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C256R @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C256R @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x9C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C512  @DIP28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C512  @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x03,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C512R @DIP28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C512R @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x03,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C512R @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x9C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C1024  @DIP40",
	.protocol_id = 0x09,
	.variant = 0x00,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E00F100,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C1024L @DIP40",
	.protocol_id = 0x09,
	.variant = 0x00,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E00F100,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C2048  @DIP40",
	.protocol_id = 0x09,
	.variant = 0x01,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E00F700,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27C4096  @DIP40",
	.protocol_id = 0x09,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E00F400,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27HC256",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27HC256   @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27HC256L",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27HC256L  @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27HC256R",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27HC256R  @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27HC256RL",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27HC256RL @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E94,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27HC1024  @DIP40",
	.protocol_id = 0x09,
	.variant = 0x00,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E006100,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV010",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV010 @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV010 @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV010 @VSOP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV020",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV020 @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV020 @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV020 @VSOP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV040",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV040 @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV040 @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV040 @VSOP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV256",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV256 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV256 @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x9C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV512",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV512 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x03,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV512 @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x9C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV1024 @DIP40",
	.protocol_id = 0x09,
	.variant = 0x00,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E00F100,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV2048 @DIP40",
	.protocol_id = 0x09,
	.variant = 0x01,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E00F700,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27BV4096 @DIP40",
	.protocol_id = 0x09,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E00F400,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV010",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV010 @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV010 @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV010 @VSOP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV010A",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV010A @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV010A @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV010A @VSOP32",
	.protocol_id = 0x08,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV020",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV020 @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV020 @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV020 @VSOP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV020A",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV020A @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV020A @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV020A @VSOP32",
	.protocol_id = 0x08,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E86,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV040",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV040 @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV040 @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV040 @VSOP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV040A",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x20000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV040A @PLCC32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV040A @TSOP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV040A @VSOP32",
	.protocol_id = 0x08,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x00000005,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV256A",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV256A @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV256A @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x9C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV256R",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV256R @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV256R @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x11,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E8C,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x9C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV512A",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV512A @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x03,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV512A @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x9C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV512R",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x1C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV512R @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x03,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0xFF000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV512R @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x10,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E0D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0040,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x0068,
	.package_details = 0x9C000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV1024 @DIP40",
	.protocol_id = 0x09,
	.variant = 0x00,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E00F100,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV2048 @DIP40",
	.protocol_id = 0x09,
	.variant = 0x01,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E00F700,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT27LV4096 @DIP40",
	.protocol_id = 0x09,
	.variant = 0x02,
	.read_buffer_size = 0x0400,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E00F400,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0050,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x1002068,
	.package_details = 0x28000000,
	.write_unlock = 0x0005,
},
{
	.name = "AT28BV64",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x0BB8,
	.opts4 = 0x0010,
	.package_details = 0x1C000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28BV64 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x0BB8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28BV64 @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x0BB8,
	.opts4 = 0x0010,
	.package_details = 0x9C000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28BV64B",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28BV64B @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28BV64B @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28BV256",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28BV256 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C010",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C010 @PLCC32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C010 @TSOP32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C010E",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C010E @PLCC32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C010E @TSOP32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C04 @DIP24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x18000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C04 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C04 @SOIC24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x98000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C04E @DIP24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x18000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C04E @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C04E @SOIC24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x98000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C04F @DIP24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x18000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C04F @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C04F @SOIC24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x98000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C040",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C040 @PLCC32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C040 @TSOP32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C040E",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C040E @PLCC32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C040E @TSOP32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C16 @DIP24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x18000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C16 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C16 @SOIC24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x98000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C16E @DIP24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x18000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C16E @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C16E @SOIC24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x98000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C16F @DIP24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x18000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C16F @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C16F @SOIC24",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x98000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C17",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C17 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C17 @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x9C000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C17E",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x1C000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C17E @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C17E @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x9C000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C17F",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x1C000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C17F @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C17F @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x9C000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C256",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C256 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C256 @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C256E",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x0BB8,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28C256E @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x0BB8,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28C256E @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x0BB8,
	.opts4 = 0xC010,
	.package_details = 0x9C000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28C256F",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x0BB8,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28C256F @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x0BB8,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28C256F @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x0BB8,
	.opts4 = 0xC010,
	.package_details = 0x9C000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28C64",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C64 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C64 @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x9C000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C64B",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C64B @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C64B @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28C64E",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x1C000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C64E @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C64E @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x9C000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C64F",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x1C000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28C64F @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28C64F @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x00C8,
	.opts4 = 0x0010,
	.package_details = 0x9C000000,
	.write_unlock = 0x003E,
},
{
	.name = "AT28HC04",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x18000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28HC04 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28HC16",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x18000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28HC16L",
	.protocol_id = 0x0B,
	.variant = 0x10,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x18000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28HC256",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC256 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC256E",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC256E @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC256F",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x0BB8,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28HC256F @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x0BB8,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28HC256L",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC256L @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC64",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28HC64 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x2710,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC64 @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x9C000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28HC64B",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC64B @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC64B @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC64BF",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC64BF @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC64BF @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC64L",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28HC64L @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x2710,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28HC64L @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x03E8,
	.opts4 = 0x0010,
	.package_details = 0x9C000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT28LV64",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x0BB8,
	.opts4 = 0x0010,
	.package_details = 0x1C000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28LV64 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x0BB8,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28LV64 @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0001,
	.opts3 = 0x0BB8,
	.opts4 = 0x0010,
	.package_details = 0x9C000000,
	.write_unlock = 0x01D3,
},
{
	.name = "AT28LV64B",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28LV64B @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28LV64B @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28LV256",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28LV256 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0xC010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28LV010",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28LV010 @PLCC32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28LV010 @TSOP32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC058,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT28MC010",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC048,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28MC010 @PLCC32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC048,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28MC010 @TSOP32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC048,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT28MC020",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC048,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28MC020 @PLCC32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC048,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28MC020 @TSOP32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC048,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT28MC040",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC048,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28MC040 @PLCC32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC048,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28MC040 @TSOP32",
	.protocol_id = 0x0D,
	.variant = 0x00,
	.read_buffer_size = 0x0800,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x2710,
	.opts4 = 0xC048,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT28PC64",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28PC64 @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28PC64  @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0010,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28PC64E",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0010,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28PC64E @PLCC32",
	.protocol_id = 0x0A,
	.variant = 0x80,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0010,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT28PC64E @SOIC28",
	.protocol_id = 0x07,
	.variant = 0x26,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0010,
	.package_details = 0x9C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29BV010A",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F35,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29BV010A @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F35,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29BV010A @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F35,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29BV020",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FBA,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29BV020  @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FBA,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29BV020  @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FBA,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29BV040",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F3B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0200,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29BV040  @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F3B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0200,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29BV040  @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F3B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0200,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29BV040A",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FC4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29BV040A @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FC4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29BV040A @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FC4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C256 @DIP28",
	.protocol_id = 0x05,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FDC,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C257",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FDC,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C257  @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FDC,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C512",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F5D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C512  @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F5D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C512  @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F5D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C010A",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FD5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C010A @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FD5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C010A @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FD5,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C020",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FDA,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C020  @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FDA,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C020  @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FDA,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C040",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F5B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0200,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C040  @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F5B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0200,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C040  @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F5B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0200,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C040A",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FA4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C040A @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FA4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29C040A @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FA4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV256 @DIP28",
	.protocol_id = 0x05,
	.variant = 0x01,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FBC,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV512",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F3D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV512  @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F3D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV512  @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F3D,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV010A",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F35,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV010A @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F35,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV010A @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F35,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0080,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV020",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FBA,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV020  @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FBA,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV020  @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FBA,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV040",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F3B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0200,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV040  @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F3B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0200,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV040  @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0200,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F3B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0200,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV040A",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FC4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x20000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV040A @PLCC32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FC4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT29LV040A @TSOP32",
	.protocol_id = 0x05,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FC4,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x4E20,
	.opts4 = 0x40C078,
	.package_details = 0x00000005,
	.write_unlock = 0x0001,
},
{
	.name = "AT45DB011B",
	.protocol_id = 0x04,
	.variant = 0x01,
	.read_buffer_size = 0x1080,
	.write_buffer_size = 0x0108,
	.code_memory_size = 0x21000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0108,
	.opts3 = 0x0000,
	.opts4 = 0x0058,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB021B",
	.protocol_id = 0x04,
	.variant = 0x01,
	.read_buffer_size = 0x1080,
	.write_buffer_size = 0x0108,
	.code_memory_size = 0x42000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0108,
	.opts3 = 0x0000,
	.opts4 = 0x0058,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB041B",
	.protocol_id = 0x04,
	.variant = 0x01,
	.read_buffer_size = 0x1080,
	.write_buffer_size = 0x0108,
	.code_memory_size = 0x84000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0108,
	.opts3 = 0x0000,
	.opts4 = 0x0058,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB081B",
	.protocol_id = 0x04,
	.variant = 0x01,
	.read_buffer_size = 0x1080,
	.write_buffer_size = 0x0108,
	.code_memory_size = 0x108000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0108,
	.opts3 = 0x0000,
	.opts4 = 0x0058,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB161B",
	.protocol_id = 0x04,
	.variant = 0x01,
	.read_buffer_size = 0x2100,
	.write_buffer_size = 0x0210,
	.code_memory_size = 0x210000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0210,
	.opts3 = 0x0000,
	.opts4 = 0x0058,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB011D[Page264]",
	.protocol_id = 0x04,
	.variant = 0x00,
	.read_buffer_size = 0x1080,
	.write_buffer_size = 0x0108,
	.code_memory_size = 0x21000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F22,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0108,
	.opts3 = 0x0000,
	.opts4 = 0x0278,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB011D[Page256]",
	.protocol_id = 0x04,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F22,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x0000,
	.opts4 = 0x0278,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB021D[Page264]",
	.protocol_id = 0x04,
	.variant = 0x00,
	.read_buffer_size = 0x1080,
	.write_buffer_size = 0x0108,
	.code_memory_size = 0x42000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F23,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0108,
	.opts3 = 0x0000,
	.opts4 = 0x0278,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB021D[Page256]",
	.protocol_id = 0x04,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F23,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x0000,
	.opts4 = 0x0278,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB041D[Page264]",
	.protocol_id = 0x04,
	.variant = 0x00,
	.read_buffer_size = 0x1080,
	.write_buffer_size = 0x0108,
	.code_memory_size = 0x84000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F24,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0108,
	.opts3 = 0x0000,
	.opts4 = 0x0278,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB041D[Page256]",
	.protocol_id = 0x04,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F24,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x0000,
	.opts4 = 0x0278,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB081D[Page264]",
	.protocol_id = 0x04,
	.variant = 0x00,
	.read_buffer_size = 0x1080,
	.write_buffer_size = 0x0108,
	.code_memory_size = 0x108000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F25,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0108,
	.opts3 = 0x0000,
	.opts4 = 0x0278,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB081D[Page256]",
	.protocol_id = 0x04,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F25,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x0000,
	.opts4 = 0x0278,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB161D[Page528]",
	.protocol_id = 0x04,
	.variant = 0x00,
	.read_buffer_size = 0x2100,
	.write_buffer_size = 0x0210,
	.code_memory_size = 0x210000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F26,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0210,
	.opts3 = 0x0000,
	.opts4 = 0x0278,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB161D[Page512]",
	.protocol_id = 0x04,
	.variant = 0x02,
	.read_buffer_size = 0x2000,
	.write_buffer_size = 0x0200,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F26,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0200,
	.opts3 = 0x0000,
	.opts4 = 0x0278,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB321E[Page528]*",
	.protocol_id = 0x04,
	.variant = 0x00,
	.read_buffer_size = 0x2100,
	.write_buffer_size = 0x0210,
	.code_memory_size = 0x420000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F27,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0210,
	.opts3 = 0x0000,
	.opts4 = 0x0278,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT45DB321E[Page512]*",
	.protocol_id = 0x04,
	.variant = 0x02,
	.read_buffer_size = 0x2000,
	.write_buffer_size = 0x0200,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F27,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0200,
	.opts3 = 0x0000,
	.opts4 = 0x0278,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
},
{
	.name = "AT49BV001",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001A",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001A   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001A   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001A   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001AN",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001AN  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001AN  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001AN  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001ANT",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001ANT @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001ANT @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001ANT @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001AT",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001AT  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001AT  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001AT  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001N",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001N  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001N  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001N  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001NT",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001NT @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001NT @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001NT @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001T",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001T  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001T  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV001T  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002    @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002    @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002    @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002A",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002A   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002A   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002A   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002AN",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002AN  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002AN  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002AN  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002ANT",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002ANT @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002ANT @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002ANT @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002AT",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002AT  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002AT  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002AT  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002N",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002N   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002N   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002N   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002NT",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002NT  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002NT  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002NT  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002T",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002T   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002T   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV002T   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV004   @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F11,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV004T  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F20,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV008A  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F22,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV008AT @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F21,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV010",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV010   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV010   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV010   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV020",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV020   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV020   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV020   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040A",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040A  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040A  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040A  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040B",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040B  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040B  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040B  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040T",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040T  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040T  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV040T  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV080  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x68,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F23,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV080T @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x68,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F27,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV1024A  @VSOP40",
	.protocol_id = 0x14,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F008700,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000004,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV160    @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV160T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV161    @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV161T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV1604   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV1604T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV1614   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV1614T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV162A   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x58,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV162AT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x58,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV163A   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV163AT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV2048A  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F008200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV320    @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV320T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV320D   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x40,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C590,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV321    @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV321T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV322    @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV322T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV3218   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00D800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV3218T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00D900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV4096A  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F009200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV4096AT @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F009000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV512",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV512    @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV512    @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV512    @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV6416   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00D600,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV6416T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00D200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV8011   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00CB00,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV8011T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F004A00,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV802A   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C100,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV802AT  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C300,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV8192A  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00A000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49BV8192AT @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00A300,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001    @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001    @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001    @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001A",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001A    @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001A    @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001A    @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001AN",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001AN   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001AN   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001AN   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001ANT",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001ANT  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001ANT  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001ANT  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001AT",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001AT   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001AT   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001AT   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001N",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001N   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001N   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001N   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001NT",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001NT  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001NT  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001NT  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001T",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001T   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001T   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F001T   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002A",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002A   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002A   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002A   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002AN",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002AN  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002AN  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002AN  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002ANT",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002ANT @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002ANT @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002ANT @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002AT",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002AT  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002AT  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002AT  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002N",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002N  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002N  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002N  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002NT",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002NT @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002NT @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002NT @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002T",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002T  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002T  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F002T  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F004    @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F11,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F004T   @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F20,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F008    @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F22,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F008A   @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F22,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F008AT  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F21,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F010",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F010  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F010  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F020",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F020  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F020  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F040",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F040  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F040  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F040A",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F040A @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F040A @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F040T",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F040T @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F040T @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F080    @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x68,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F23,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F080T   @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x68,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F27,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F1024   @VSOP40",
	.protocol_id = 0x14,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F008700,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000004,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F1024A  @VSOP40",
	.protocol_id = 0x14,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F008700,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000004,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F1604   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F1604T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F1614   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F1614T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F2048   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F008200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F2048A  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F008200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F4096   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F009200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F4096A  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F009200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F4096AT @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F009000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F512",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F512    @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F512    @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F512    @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F8011   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00CB00,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F8011T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F004A00,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F8192   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00A000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F8192A  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00A000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F8192AT @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00A300,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49F8192T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00A300,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49HBV010",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49HBV010   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49HBV010   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49HBV010   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49HF010 @DIP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49HF010 @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49HF010 @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49HLV010",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49HLV010   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49HLV010   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49HLV010   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LH002 @PLCC32",
	.protocol_id = 0x11,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FE9,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0019,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT49LH002 @TSOP40",
	.protocol_id = 0x11,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FE9,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x0019,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0001,
},
{
	.name = "AT49LH004 @PLCC32",
	.protocol_id = 0x11,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FEE,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0019,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0001,
},
{
	.name = "AT49LH004 @TSOP40",
	.protocol_id = 0x11,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FEE,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x0019,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0001,
},
{
	.name = "AT49LL020  @PLCC32",
	.protocol_id = 0x11,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FE9,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LL020  @TSOP40",
	.protocol_id = 0x11,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FE9,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LL040  @PLCC32",
	.protocol_id = 0x11,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FEA,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LL040  @TSOP40",
	.protocol_id = 0x11,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FEA,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LL080  @PLCC32",
	.protocol_id = 0x11,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FEB,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LL080  @TSOP40",
	.protocol_id = 0x11,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FEB,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001N",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001N  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001N  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001N  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F05,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001NT",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001NT @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001NT @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001NT @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001T",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001T  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001T  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV001T  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F04,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002    @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002    @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002    @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002N",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002N   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002N   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002N   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F07,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002NT",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002NT  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002NT  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002NT  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002T",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002T   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002T   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV002T   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x80,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F08,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV008A  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F22,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV008AT @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F21,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV010",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV010   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV010   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV010   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F17,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV020",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV020   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV020   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV020   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F0B,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV040",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV040   @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV040   @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV040   @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F13,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV040T",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV040T  @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV040T  @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV040T  @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV080   @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x68,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F23,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV080T  @TSOP40",
	.protocol_id = 0x13,
	.variant = 0x68,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F27,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV1024   @VSOP40",
	.protocol_id = 0x14,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F008700,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000004,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV1024A  @VSOP40",
	.protocol_id = 0x14,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F008700,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000004,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV160    @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49lV160T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV161    @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV161T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV1614   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV1614T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV2048   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F008200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV2048A  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F008200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV320    @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV320T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV320D   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x40,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C590,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV321    @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV321T   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x08,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00C900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV3218   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00D800,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV3218T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x48,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00D900,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV4096   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F009200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV4096A  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F009200,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV4096AT @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F009000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV512",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x20000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV512    @PLCC32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV512    @TSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV512    @VSOP32",
	.protocol_id = 0x06,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F03,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000005,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV8011   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00CB00,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV8011T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F004A00,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV8192   @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00A000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV8192A  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00A000,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV8192AT @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00A300,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LV8192T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x28,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1F00A300,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LW040 @PLCC32",
	.protocol_id = 0x11,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FE0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LW040 @TSOP40",
	.protocol_id = 0x11,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FE0,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LW080 @PLCC32",
	.protocol_id = 0x11,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FE1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0xFF000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT49LW080 @TSOP40",
	.protocol_id = 0x11,
	.variant = 0x00,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1FE1,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0001,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0078,
	.package_details = 0x00000003,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C1051",
	.protocol_id = 0x1F,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E11,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0014,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40430,
	.package_details = 0x14000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C1051   @SOIC20",
	.protocol_id = 0x1F,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E11,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0014,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40430,
	.package_details = 0x94000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C1051U",
	.protocol_id = 0x1F,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0014,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40430,
	.package_details = 0x14000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C1051U  @SOIC20",
	.protocol_id = 0x1F,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E12,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0014,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40430,
	.package_details = 0x94000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C2051",
	.protocol_id = 0x1F,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E21,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0014,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40430,
	.package_details = 0x14000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C2051   @SOIC20",
	.protocol_id = 0x1F,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E21,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0014,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40430,
	.package_details = 0x94000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C2051x2",
	.protocol_id = 0x1F,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E22,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0014,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40430,
	.package_details = 0x14000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C2051x2 @SOIC20",
	.protocol_id = 0x1F,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E22,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0014,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40430,
	.package_details = 0x94000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C4051",
	.protocol_id = 0x1F,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E41,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0014,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40430,
	.package_details = 0x14000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C4051   @SOIC20",
	.protocol_id = 0x1F,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E41,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0014,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40430,
	.package_details = 0x94000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C51",
	.protocol_id = 0x21,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E51FF,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40478,
	.package_details = 0x28000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C51     @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E51FF,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40478,
	.package_details = 0xFD000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C52",
	.protocol_id = 0x21,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E52FF,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40478,
	.package_details = 0x28000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C52     @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E52FF,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40478,
	.package_details = 0xFD000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C55",
	.protocol_id = 0x21,
	.variant = 0x06,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x5000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E55FF,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40478,
	.package_details = 0x28000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C55     @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x06,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x5000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E55FF,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40478,
	.package_details = 0xFD000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C55WD",
	.protocol_id = 0x21,
	.variant = 0x03,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x5000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E5506,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0478,
	.package_details = 0x28000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C55WD   @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x03,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x5000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E5506,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0478,
	.package_details = 0xFD000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C51RC",
	.protocol_id = 0x21,
	.variant = 0x03,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E5107,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0478,
	.package_details = 0x28000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89C51RC   @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x03,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E5107,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0478,
	.package_details = 0xFD000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LS51",
	.protocol_id = 0x21,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E5106,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x100478,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LS51    @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E5106,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x100478,
	.package_details = 0xFD000100,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LS52",
	.protocol_id = 0x21,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E5206,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x100478,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LS52    @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E5206,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x100478,
	.package_details = 0xFD000100,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LS53",
	.protocol_id = 0x21,
	.variant = 0x05,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x3000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0678,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LS53    @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x05,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x3000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E63,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0678,
	.package_details = 0xFD000100,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LS8252",
	.protocol_id = 0x21,
	.variant = 0x05,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E82,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0019,
	.opts2 = 0x2000,
	.opts3 = 0x000A,
	.opts4 = 0x1678,
	.package_details = 0x28000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LS8252  @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x05,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E82,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0019,
	.opts2 = 0x2000,
	.opts3 = 0x000A,
	.opts4 = 0x1678,
	.package_details = 0xFD000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LS8253",
	.protocol_id = 0x21,
	.variant = 0x04,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x3000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0040,
	.chip_id = 0x1E83,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0E38,
	.package_details = 0x28000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LS8253  @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x04,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x3000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0040,
	.chip_id = 0x1E83,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0E38,
	.package_details = 0xFD000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LV51",
	.protocol_id = 0x21,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E61FF,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40478,
	.package_details = 0x28000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LV51    @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E61FF,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40478,
	.package_details = 0xFD000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LV52",
	.protocol_id = 0x21,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E62FF,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40478,
	.package_details = 0x28000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LV52    @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E62FF,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40478,
	.package_details = 0xFD000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LV55",
	.protocol_id = 0x21,
	.variant = 0x06,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x5000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E65FF,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40478,
	.package_details = 0x28000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89LV55    @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x06,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x5000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E65FF,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x40478,
	.package_details = 0xFD000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89S51",
	.protocol_id = 0x21,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E5106,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x100478,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
},
{
	.name = "AT89S51     @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E5106,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x100478,
	.package_details = 0xFD000100,
	.write_unlock = 0x0003,
},
{
	.name = "AT89S52",
	.protocol_id = 0x21,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E5206,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x100478,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
},
{
	.name = "AT89S52     @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x02,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E5206,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x100478,
	.package_details = 0xFD000100,
	.write_unlock = 0x0003,
},
{
	.name = "AT89S53",
	.protocol_id = 0x21,
	.variant = 0x05,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x3000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E53,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0678,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
},
{
	.name = "AT89S53     @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x05,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x3000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E53,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0678,
	.package_details = 0xFD000100,
	.write_unlock = 0x0003,
},
{
	.name = "AT89S8252",
	.protocol_id = 0x21,
	.variant = 0x05,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E72,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0019,
	.opts2 = 0x2000,
	.opts3 = 0x000A,
	.opts4 = 0x1678,
	.package_details = 0x28000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89S8252   @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x05,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E72,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0019,
	.opts2 = 0x2000,
	.opts3 = 0x000A,
	.opts4 = 0x1678,
	.package_details = 0xFD000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89S8253",
	.protocol_id = 0x21,
	.variant = 0x04,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x3000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0040,
	.chip_id = 0x1E73,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0E38,
	.package_details = 0x28000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT89S8253   @PLCC44",
	.protocol_id = 0x21,
	.variant = 0x04,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x3000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0040,
	.chip_id = 0x1E73,
	.chip_id_bytes_count = 0x02,
	.opts1 = 0x0019,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0E38,
	.package_details = 0xFD000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT90S1200",
	.protocol_id = 0x1D,
	.variant = 0x61,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9001,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0001,
	.opts4 = 0x2630,
	.package_details = 0x14000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90S1200  @SOIC20",
	.protocol_id = 0x1D,
	.variant = 0x61,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9001,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0001,
	.opts4 = 0x2630,
	.package_details = 0x94000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90S1200  @SSOP20",
	.protocol_id = 0x1D,
	.variant = 0x61,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9001,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0001,
	.opts4 = 0x2630,
	.package_details = 0x94000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90S2313",
	.protocol_id = 0x1D,
	.variant = 0x61,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9101,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x2630,
	.package_details = 0x14000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90S2313  @SOIC20",
	.protocol_id = 0x1D,
	.variant = 0x61,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9101,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x2630,
	.package_details = 0x94000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90S2333",
	.protocol_id = 0x1D,
	.variant = 0x44,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9105,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0003,
	.opts4 = 0x2630,
	.package_details = 0x1C000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90S4414",
	.protocol_id = 0x1D,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9201,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x2630,
	.package_details = 0x28000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90S4433",
	.protocol_id = 0x1D,
	.variant = 0x44,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9203,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0003,
	.opts4 = 0x2630,
	.package_details = 0x1C000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90S4434",
	.protocol_id = 0x1D,
	.variant = 0x21,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9502,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x2630,
	.package_details = 0x28000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90S8515",
	.protocol_id = 0x1D,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9301,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x2630,
	.package_details = 0x28000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90S8535",
	.protocol_id = 0x1D,
	.variant = 0x21,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9303,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x2630,
	.package_details = 0x28000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90SLS2313",
	.protocol_id = 0x1D,
	.variant = 0x61,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9101,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x2630,
	.package_details = 0x14000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90SLS2313 @SOIC20",
	.protocol_id = 0x1D,
	.variant = 0x61,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9101,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x2630,
	.package_details = 0x94000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90SLS2333",
	.protocol_id = 0x1D,
	.variant = 0x44,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9105,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0003,
	.opts4 = 0x2630,
	.package_details = 0x1C000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90SLS4414",
	.protocol_id = 0x1D,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9201,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x2630,
	.package_details = 0x28000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90SLS4433",
	.protocol_id = 0x1D,
	.variant = 0x44,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9203,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0003,
	.opts4 = 0x2630,
	.package_details = 0x1C000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90SLS4434",
	.protocol_id = 0x1D,
	.variant = 0x21,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9502,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x2630,
	.package_details = 0x28000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90SLS8515",
	.protocol_id = 0x1D,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9301,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x2630,
	.package_details = 0x28000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT90SLS8535",
	.protocol_id = 0x1D,
	.variant = 0x21,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9303,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0002,
	.opts4 = 0x2630,
	.package_details = 0x28000000,
	.write_unlock = 0x0002,
	.fuses = avr_fuses,
},
{
	.name = "AT93C46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46A",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46A @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46A @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46C",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46C @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46C @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46D(x8)",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46D(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46D(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46D(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46D(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46D(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46E",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46E @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46E @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46R(x8) *",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46R(x8) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46R(x8) @TSOP8 *",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46R(x16) *",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46R(x16) @SOIC8 *",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C46R(x16) @TSOP8 *",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0002,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C56A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C56A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C56A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C56A(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C56A(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C56A(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C57(x8)",
	.protocol_id = 0x02,
	.variant = 0x0B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C57(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C57(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C57(x16)",
	.protocol_id = 0x02,
	.variant = 0x8A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C57(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C57(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C66(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C66(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C66A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C66A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C66A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C66A(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C66A(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C66A(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C86(x8)",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C86(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C86(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C86(x16)",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C86(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C86(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C86A(x8)",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C86A(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C86A(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0E,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C86A(x16)",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C86A(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "AT93C86A(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8D,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATF16V8B",
	.protocol_id = 0x2A,
	.variant = 0x02,
	.read_buffer_size = 0x0000,
	.write_buffer_size = 0x0000,
	.code_memory_size = 0x0892,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0064,
	.opts4 = 0x2040410,
	.package_details = 0x14000000,
	.write_unlock = 0x0005,
},
{
	.name = "ATMEGA8",
	.protocol_id = 0x1D,
	.variant = 0x43,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9307,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x0001,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATMEGA8L",
	.protocol_id = 0x1D,
	.variant = 0x43,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9307,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x0001,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATMEGA8A",
	.protocol_id = 0x1D,
	.variant = 0x43,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9307,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x0001,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATMEGA16",
	.protocol_id = 0x1D,
	.variant = 0x20,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9403,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x0002,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATMEGA16L",
	.protocol_id = 0x1D,
	.variant = 0x20,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9403,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x0002,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATMEGA16A",
	.protocol_id = 0x1D,
	.variant = 0x20,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9403,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x0002,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATMEGA32",
	.protocol_id = 0x1D,
	.variant = 0x20,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0400,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9502,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x0003,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATMEGA32L",
	.protocol_id = 0x1D,
	.variant = 0x20,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0400,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9502,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x0003,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATMEGA32A",
	.protocol_id = 0x1D,
	.variant = 0x20,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0400,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9502,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x0003,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATMEGA48",
	.protocol_id = 0x1D,
	.variant = 0x48,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9205,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x0007,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA48V",
	.protocol_id = 0x1D,
	.variant = 0x48,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9205,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x0007,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA48A",
	.protocol_id = 0x1D,
	.variant = 0x48,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9205,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x0007,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA48PA",
	.protocol_id = 0x1D,
	.variant = 0x48,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E920A,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x0007,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA64   @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9602,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0004,
	.opts4 = 0x182630,
	.package_details = 0x00000607,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA64A  @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9602,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0004,
	.opts4 = 0x182630,
	.package_details = 0x00000607,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA64L  @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9602,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0004,
	.opts4 = 0x182630,
	.package_details = 0x00000607,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA88",
	.protocol_id = 0x1D,
	.variant = 0x49,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930A,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x0008,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA88V",
	.protocol_id = 0x1D,
	.variant = 0x49,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930A,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x0008,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA88A",
	.protocol_id = 0x1D,
	.variant = 0x49,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930A,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x0008,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA88PA",
	.protocol_id = 0x1D,
	.variant = 0x49,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930F,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x0008,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA128     @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x1000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9702,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0005,
	.opts4 = 0x182630,
	.package_details = 0x00000607,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA128A    @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x1000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9702,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0005,
	.opts4 = 0x182630,
	.package_details = 0x00000607,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA128L    @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x1000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9702,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0005,
	.opts4 = 0x182630,
	.package_details = 0x00000607,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA162",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9404,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x000B,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA162V",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9404,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x000B,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA164A",
	.protocol_id = 0x1D,
	.variant = 0x2A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E940F,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x000C,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA164PA",
	.protocol_id = 0x1D,
	.variant = 0x2A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E940A,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x000C,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA165A  @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9407,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA165P  @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9405,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA165PA @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9407,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA165PV @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9405,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA168",
	.protocol_id = 0x1D,
	.variant = 0x49,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9406,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x0009,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA168A",
	.protocol_id = 0x1D,
	.variant = 0x49,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9406,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x0009,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA168PA",
	.protocol_id = 0x1D,
	.variant = 0x49,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E940B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x0009,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA168V",
	.protocol_id = 0x1D,
	.variant = 0x49,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9406,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x0009,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA169A   @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9405,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA169P   @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9405,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA169PA  @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9405,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA169PV  @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9405,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA324A",
	.protocol_id = 0x1D,
	.variant = 0x2A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0400,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9515,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x000C,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA324PA",
	.protocol_id = 0x1D,
	.variant = 0x2A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0400,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9511,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x000C,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA325A   @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0400,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E950D,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA325PA  @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0400,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E950D,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA328",
	.protocol_id = 0x1D,
	.variant = 0x49,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0400,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9514,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x000A,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA328P",
	.protocol_id = 0x1D,
	.variant = 0x49,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0400,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E950F,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x000A,
	.opts4 = 0x182630,
	.package_details = 0x1C000700,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA329A   @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0400,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E950B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA329PA  @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0400,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E950B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA644A",
	.protocol_id = 0x1D,
	.variant = 0x2A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9609,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x000C,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA644PA",
	.protocol_id = 0x1D,
	.variant = 0x2A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E960A,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x000C,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA645A @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E960D,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA645P @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E960D,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA649A @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E960B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA649P @TQFP64",
	.protocol_id = 0x1D,
	.variant = 0x0A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0800,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E960B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0008,
	.opts2 = 0x0080,
	.opts3 = 0x0006,
	.opts4 = 0x182630,
	.package_details = 0x00000807,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA1284",
	.protocol_id = 0x1D,
	.variant = 0x2A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x1000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9706,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x000C,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA1284P",
	.protocol_id = 0x1D,
	.variant = 0x2A,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0080,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x1000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9705,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0080,
	.opts3 = 0x000C,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATMEGA8515",
	.protocol_id = 0x1D,
	.variant = 0x00,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9306,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x000D,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATMEGA8515L",
	.protocol_id = 0x1D,
	.variant = 0x00,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9306,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x000D,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATMEGA8535",
	.protocol_id = 0x1D,
	.variant = 0x22,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9308,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x000E,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATMEGA8535L",
	.protocol_id = 0x1D,
	.variant = 0x22,
	.read_buffer_size = 0x0100,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9308,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x000E,
	.opts4 = 0x182630,
	.package_details = 0x28000100,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY11",
	.protocol_id = 0x1E,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9004,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x2630,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATTINY11  @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9004,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x2630,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATTINY11L",
	.protocol_id = 0x1E,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9004,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x2630,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATTINY11L @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9004,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0004,
	.opts4 = 0x2630,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "ATTINY12",
	.protocol_id = 0x1E,
	.variant = 0x00,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9005,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0012,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATTINY12  @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x00,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9005,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0012,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATTINY12V",
	.protocol_id = 0x1E,
	.variant = 0x00,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9005,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0012,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATTINY12V @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x00,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9005,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0012,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATTINY12L",
	.protocol_id = 0x1E,
	.variant = 0x00,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9005,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0012,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATTINY12L @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x00,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9005,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0012,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATTINY13",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9007,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x0013,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY13  @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9007,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x0013,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY13V",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9007,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x0013,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY13V @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9007,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x0013,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY13A",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9007,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x0013,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY13A @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9007,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x0013,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY15",
	.protocol_id = 0x1E,
	.variant = 0x01,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9006,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0014,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATTINY15  @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x01,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9006,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0014,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATTINY15L",
	.protocol_id = 0x1E,
	.variant = 0x01,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9006,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0014,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATTINY15L @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x01,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0040,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9006,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0014,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "ATTINY24",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E910B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x0E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY24 @SOIC14",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E910B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x8E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY24A",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E910B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x0E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY24A @SOIC14",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E910B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x8E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY24V",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E910B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x0E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY24V @SOIC14",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E910B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x8E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY25",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9108,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x0015,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY25  @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9108,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x0015,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY25V",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9108,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x0015,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY25V @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9108,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x0015,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY26",
	.protocol_id = 0x1D,
	.variant = 0x85,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9109,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0020,
	.opts3 = 0x0010,
	.opts4 = 0x82630,
	.package_details = 0x14000000,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY26 @SOIC20",
	.protocol_id = 0x1D,
	.variant = 0x85,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9109,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0020,
	.opts3 = 0x0010,
	.opts4 = 0x82630,
	.package_details = 0x94000000,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY26 @SSOP20",
	.protocol_id = 0x1D,
	.variant = 0x85,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9109,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0020,
	.opts3 = 0x0010,
	.opts4 = 0x82630,
	.package_details = 0x94000000,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY26L",
	.protocol_id = 0x1D,
	.variant = 0x85,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9109,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0020,
	.opts3 = 0x0010,
	.opts4 = 0x82630,
	.package_details = 0x14000000,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY26L @SOIC20",
	.protocol_id = 0x1D,
	.variant = 0x85,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9109,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0020,
	.opts3 = 0x0010,
	.opts4 = 0x82630,
	.package_details = 0x94000000,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY26L @SSOP20",
	.protocol_id = 0x1D,
	.variant = 0x85,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9109,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0020,
	.opts3 = 0x0010,
	.opts4 = 0x82630,
	.package_details = 0x94000000,
	.write_unlock = 0x0002,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY28L",
	.protocol_id = 0x1D,
	.variant = 0x44,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9107,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0011,
	.opts4 = 0x82630,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
	.fuses = avr_fuses,
},
{
	.name = "ATTINY28V",
	.protocol_id = 0x1D,
	.variant = 0x44,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9107,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x0011,
	.opts4 = 0x82630,
	.package_details = 0x1C000000,
	.write_unlock = 0x0001,
	.fuses = avr_fuses,
},
{
	.name = "ATTINY44",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9207,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x0E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY44 @SOIC14",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9207,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x8E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY44A",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9207,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x0E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY44A @SOIC14",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9207,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x8E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY44V",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9207,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x0E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY44V @SOIC14",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9207,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x8E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY45",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9206,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0015,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY45 @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9206,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0015,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY45V",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9206,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0015,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY45V @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E9206,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0015,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY84",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930C,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x0E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY84 @SOIC14",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930C,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x8E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY84A",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930C,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x0E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY84A @SOIC14",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930C,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x8E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY84V",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930C,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x0E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY84V @SOIC14",
	.protocol_id = 0x1E,
	.variant = 0x12,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930C,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0016,
	.opts4 = 0x82630,
	.package_details = 0x8E000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY85",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0015,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY85 @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0015,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY85V",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0015,
	.opts4 = 0x82630,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY85V @SOIC8",
	.protocol_id = 0x1E,
	.variant = 0x10,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0200,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E930B,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x0015,
	.opts4 = 0x82630,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
	.fuses = avr2_fuses,
},
{
	.name = "ATTINY2313",
	.protocol_id = 0x1D,
	.variant = 0x6B,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E910A,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0020,
	.opts3 = 0x000F,
	.opts4 = 0x82630,
	.package_details = 0x14000000,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATTINY2313 @SOIC20",
	.protocol_id = 0x1D,
	.variant = 0x6B,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E910A,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0020,
	.opts3 = 0x000F,
	.opts4 = 0x82630,
	.package_details = 0x94000000,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATTINY2313V",
	.protocol_id = 0x1D,
	.variant = 0x6B,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E910A,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0020,
	.opts3 = 0x000F,
	.opts4 = 0x82630,
	.package_details = 0x14000000,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATTINY2313V @SOIC20",
	.protocol_id = 0x1D,
	.variant = 0x6B,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E910A,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0020,
	.opts3 = 0x000F,
	.opts4 = 0x82630,
	.package_details = 0x94000000,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATTINY2313A",
	.protocol_id = 0x1D,
	.variant = 0x6B,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E910A,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0020,
	.opts3 = 0x000F,
	.opts4 = 0x82630,
	.package_details = 0x14000000,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATTINY2313A @SOIC20",
	.protocol_id = 0x1D,
	.variant = 0x6B,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0080,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E910A,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0020,
	.opts3 = 0x000F,
	.opts4 = 0x82630,
	.package_details = 0x94000000,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATTINY4313",
	.protocol_id = 0x1D,
	.variant = 0x6B,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E920D,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x000F,
	.opts4 = 0x82630,
	.package_details = 0x14000000,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "ATTINY4313 @SOIC20",
	.protocol_id = 0x1D,
	.variant = 0x6B,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0100,
	.data_memory2_size = 0x0000,
	.chip_id = 0x1E920D,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0004,
	.opts2 = 0x0040,
	.opts3 = 0x000F,
	.opts4 = 0x82630,
	.package_details = 0x94000000,
	.write_unlock = 0x0003,
	.fuses = avr3_fuses,
},
{
	.name = "BL24C02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C128 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C256",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C256 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL24C256 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x8000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BL93C46(x8)",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C46(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C46(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0A,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C46(x16)",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C46(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C46(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x89,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C56(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C56(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C56(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C56(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C66(x8)",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C66(x8) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C66(x8) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x0C,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x0050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C66(x16)",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x08000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C66(x16) @SOIC8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "BL93C66(x16) @TSOP8",
	.protocol_id = 0x02,
	.variant = 0x8B,
	.read_buffer_size = 0x0040,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002050,
	.package_details = 0x88000000,
	.write_unlock = 0x0003,
},
{
	.name = "BG25Q512A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q512A @WSON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q512A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q10A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q10A @WSON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q10A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q20A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q20A @WSON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q20A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q40A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q40A @WSON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q40A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q80A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q80A @WSON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q80A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q16A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q16A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q16A @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q32A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q32A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q32A @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q64A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04017,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q64A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04017,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q64A @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04017,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q128A",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x1000000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04018,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q128A @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x1000000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04018,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BG25Q128A @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x1000000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE04018,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "BJX24LC02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "BJX24LC02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BJX24LC02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BJX24LC04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "BJX24LC04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BJX24LC04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BJX24LC08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "BJX24LC08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BJX24LC08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BJX24LC16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "BJX24LC16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BJX24LC16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "BM29LV160B  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x8A004922,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "BM29LV160T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x8A00C422,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "24C02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C04",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C04 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C08",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C08 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C16",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C16 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C32",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C32 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C32 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x1000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "24C64",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "24C64 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "24C64 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0020,
	.code_memory_size = 0x2000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0020,
	.opts3 = 0x1388,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BM29F400B  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xAD00AB22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "BM29F400B  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xAD00AB22,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "BM29F400T  @TSOP48",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xAD002322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000001,
	.write_unlock = 0x0003,
},
{
	.name = "BM29F400T  @SOP44",
	.protocol_id = 0x12,
	.variant = 0x18,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xAD002322,
	.chip_id_bytes_count = 0x04,
	.opts1 = 0x00FF,
	.opts2 = 0x0000,
	.opts3 = 0x000A,
	.opts4 = 0x1002078,
	.package_details = 0x00000002,
	.write_unlock = 0x0003,
},
{
	.name = "BY25D05AS @SOP8-150",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25D05AS @SOP8-208",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25D10AS @SOP8-150",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25D10AS @SOP8-208",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25D20AS @SOP8-150",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25D20AS @SOP8-208",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25D40AS @SOP8-150",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25D40AS @SOP8-208",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25D80AS @SOP8-150",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25D80AS @SOP8-208",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25D16AS @SOP8-150",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25D16AS @SOP8-208",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q512AS",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q512AS @WSON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q512AS @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x10000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684010,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q10AS",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q10AS @WSON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q10AS @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x20000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684011,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q20AS",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q20AS @WSON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q20AS @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x40000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684012,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q40AS",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q40AS @WSON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q40AS @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q80AS",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q80AS @WSON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q80AS @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q16AS",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q16AS @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q16AS @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q32AS",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q32AS @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q32AS @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q64AS",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684017,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q64AS @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684017,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q64AS @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684017,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q128AS",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x1000000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684018,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x08000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q128AS @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x1000000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684018,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q128AS @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x1000000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x684018,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q40AL(1.8V) @WSON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE06013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q40AL(1.8V) @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x80000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE06013,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q80AL(1.8V) @WSON8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE06014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q80AL(1.8V) @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x100000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE06014,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q16AL(1.8V) @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE06015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q16AL(1.8V) @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x200000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE06015,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q32AL(1.8V) @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE06016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q32AL(1.8V) @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x400000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE06016,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q64AL(1.8V) @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE06017,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q64AL(1.8V) @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x800000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE06017,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q128AL(1.8V) @SOIC8",
	.protocol_id = 0x03,
	.variant = 0x02,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x1000000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE06018,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x88000000,
	.write_unlock = 0x0034,
},
{
	.name = "BY25Q128AL(1.8V) @SOIC16",
	.protocol_id = 0x03,
	.variant = 0x22,
	.read_buffer_size = 0x1000,
	.write_buffer_size = 0x0100,
	.code_memory_size = 0x1000000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0xE06018,
	.chip_id_bytes_count = 0x03,
	.opts1 = 0x0000,
	.opts2 = 0x0100,
	.opts3 = 0x1388,
	.opts4 = 0x404230,
	.package_details = 0x90000000,
	.write_unlock = 0x0034,
},
{
	.name = "CAT24AA01 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24AA02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24AA04 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0200,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24AA08 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0400,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24AA16 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0800,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24AC128",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24AC128 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x01,
	.read_buffer_size = 0x0200,
	.write_buffer_size = 0x0040,
	.code_memory_size = 0x4000,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0040,
	.opts3 = 0x2710,
	.opts4 = 0x400000,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C00",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0010,
	.write_buffer_size = 0x0001,
	.code_memory_size = 0x0010,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0001,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C00 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0010,
	.write_buffer_size = 0x0001,
	.code_memory_size = 0x0010,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0001,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C00 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0010,
	.write_buffer_size = 0x0001,
	.code_memory_size = 0x0010,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0001,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C01",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C01 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C01 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C01B",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0004,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0004,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C01B @MSOP8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0004,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0004,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C01B @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0004,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0004,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C01B @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x02,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0004,
	.code_memory_size = 0x0080,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0004,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C02",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C02 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C02 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0008,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0008,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C03",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x08000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C03 @SOIC8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	.name = "CAT24C03 @TSSOP8",
	.protocol_id = 0x01,
	.variant = 0x00,
	.read_buffer_size = 0x0080,
	.write_buffer_size = 0x0010,
	.code_memory_size = 0x0100,
	.data_memory_size = 0x0000,
	.data_memory2_size = 0x0000,
	.chip_id = 0x0000,
	.chip_id_bytes_count = 0x00,
	.opts1 = 0x0000,
	.opts2 = 0x0010,
	.opts3 = 0x2710,
	.opts4 = 0x0080,
	.package_details = 0x88000000,
	.write_unlock = 0x0001,
},
{
	