/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "transport.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "./transport_p.h"

#include <gwenhywfar/misc.h>
#include <gwenhywfar/debug.h>

/* code headers */

/* macro functions */
GWEN_INHERIT_FUNCTIONS(AQFINTS_TRANSPORT)


AQFINTS_TRANSPORT *AQFINTS_Transport_new(void) {
  AQFINTS_TRANSPORT *p_struct;

  GWEN_NEW_OBJECT(AQFINTS_TRANSPORT, p_struct)
  p_struct->_refCount=1;
  GWEN_INHERIT_INIT(AQFINTS_TRANSPORT, p_struct)
  /* members */
  p_struct->url=NULL;
  p_struct->runtimeFlags=0;
  /* virtual functions */

  return p_struct;
}

void AQFINTS_Transport_free(AQFINTS_TRANSPORT *p_struct) {
  if (p_struct) {
  assert(p_struct->_refCount);
  if (p_struct->_refCount==1) {
    GWEN_INHERIT_FINI(AQFINTS_TRANSPORT, p_struct)
  /* members */
    free(p_struct->url); p_struct->url=NULL;
    p_struct->_refCount=0;
    GWEN_FREE_OBJECT(p_struct);
  }
  else
    p_struct->_refCount--;
  }
}

void AQFINTS_Transport_Attach(AQFINTS_TRANSPORT *p_struct) {
  assert(p_struct);
  assert(p_struct->_refCount);
  p_struct->_refCount++;
}

const char *AQFINTS_Transport_GetUrl(const AQFINTS_TRANSPORT *p_struct) {
  assert(p_struct);
  return p_struct->url;
}

uint32_t AQFINTS_Transport_GetRuntimeFlags(const AQFINTS_TRANSPORT *p_struct) {
  assert(p_struct);
  return p_struct->runtimeFlags;
}

void AQFINTS_Transport_SetUrl(AQFINTS_TRANSPORT *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->url) {
    free(p_struct->url); p_struct->url=NULL;
  }
  if (p_src) {
    p_struct->url=strdup(p_src);
  }
  else {
    p_struct->url=NULL;
  }
}

void AQFINTS_Transport_SetRuntimeFlags(AQFINTS_TRANSPORT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->runtimeFlags=p_src;
}

void AQFINTS_Transport_AddRuntimeFlags(AQFINTS_TRANSPORT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->runtimeFlags|=p_src;
}

void AQFINTS_Transport_SubRuntimeFlags(AQFINTS_TRANSPORT *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->runtimeFlags&=~p_src;
}

/* code for virtual functions */
int AQFINTS_Transport_Connect(AQFINTS_TRANSPORT *p_struct) {
  assert(p_struct);
  if (p_struct->connectFn)
    return p_struct->connectFn(p_struct);
  else
    return GWEN_ERROR_NOT_IMPLEMENTED;
}

int AQFINTS_Transport_Disconnect(AQFINTS_TRANSPORT *p_struct) {
  assert(p_struct);
  if (p_struct->disconnectFn)
    return p_struct->disconnectFn(p_struct);
  else
    return GWEN_ERROR_NOT_IMPLEMENTED;
}

int AQFINTS_Transport_SendMessage(AQFINTS_TRANSPORT *p_struct, const char* ptrBuffer, int lenBuffer) {
  assert(p_struct);
  if (p_struct->sendMessageFn)
    return p_struct->sendMessageFn(p_struct, ptrBuffer, lenBuffer);
  else
    return GWEN_ERROR_NOT_IMPLEMENTED;
}

int AQFINTS_Transport_ReceiveMessage(AQFINTS_TRANSPORT *p_struct, GWEN_BUFFER* buffer) {
  assert(p_struct);
  if (p_struct->receiveMessageFn)
    return p_struct->receiveMessageFn(p_struct, buffer);
  else
    return GWEN_ERROR_NOT_IMPLEMENTED;
}

/* setters for virtual functions */
AQFINTS_TRANSPORT_CONNECT_FN AQFINTS_Transport_SetConnectFn(AQFINTS_TRANSPORT *p_struct, AQFINTS_TRANSPORT_CONNECT_FN fn){
  AQFINTS_TRANSPORT_CONNECT_FN oldFn;

  assert(p_struct);
  oldFn=p_struct->connectFn;
  p_struct->connectFn=fn;
  return oldFn;
}

AQFINTS_TRANSPORT_DISCONNECT_FN AQFINTS_Transport_SetDisconnectFn(AQFINTS_TRANSPORT *p_struct, AQFINTS_TRANSPORT_DISCONNECT_FN fn){
  AQFINTS_TRANSPORT_DISCONNECT_FN oldFn;

  assert(p_struct);
  oldFn=p_struct->disconnectFn;
  p_struct->disconnectFn=fn;
  return oldFn;
}

AQFINTS_TRANSPORT_SENDMESSAGE_FN AQFINTS_Transport_SetSendMessageFn(AQFINTS_TRANSPORT *p_struct, AQFINTS_TRANSPORT_SENDMESSAGE_FN fn){
  AQFINTS_TRANSPORT_SENDMESSAGE_FN oldFn;

  assert(p_struct);
  oldFn=p_struct->sendMessageFn;
  p_struct->sendMessageFn=fn;
  return oldFn;
}

AQFINTS_TRANSPORT_RECEIVEMESSAGE_FN AQFINTS_Transport_SetReceiveMessageFn(AQFINTS_TRANSPORT *p_struct, AQFINTS_TRANSPORT_RECEIVEMESSAGE_FN fn){
  AQFINTS_TRANSPORT_RECEIVEMESSAGE_FN oldFn;

  assert(p_struct);
  oldFn=p_struct->receiveMessageFn;
  p_struct->receiveMessageFn=fn;
  return oldFn;
}

int AQFINTS_Transport_DetermineMessageSize(const char *ptr) { const char *p1; const char *p2; char *copiedString=NULL; int msgSize; /* seek to begin of size */ p1=strchr(ptr, '+'); if (p1==NULL) { DBG_ERROR(AQFINTS_LOGDOMAIN, "Bad data (missing '+')"); return GWEN_ERROR_BAD_DATA; } p1++; /* seek to end of size */ p2=strchr(p1, '+'); if (p2==NULL) { DBG_ERROR(AQFINTS_LOGDOMAIN, "Bad data (missing second '+')"); return GWEN_ERROR_BAD_DATA; } /* read message size */ copiedString=strndup(p1, (p2-p1)); assert(copiedString); if (1!=sscanf(p1, "%d", &msgSize)) { DBG_ERROR(AQFINTS_LOGDOMAIN, "Bad size field [%s]", copiedString); free(copiedString); return GWEN_ERROR_BAD_DATA; } free(copiedString); return msgSize; }

/* code headers */

