; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck %s

; Make sure the branch targets are correct after lowering llvm.amdgcn.if

define i32 @divergent_if_swap_brtarget_order0(i32 %value) {
; CHECK-LABEL: divergent_if_swap_brtarget_order0:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CHECK-NEXT:    ; implicit-def: $vgpr0
; CHECK-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; CHECK-NEXT:    ; mask branch BB0_2
; CHECK-NEXT:    s_cbranch_execz BB0_2
; CHECK-NEXT:  BB0_1: ; %if.true
; CHECK-NEXT:    global_load_dword v0, v[0:1], off
; CHECK-NEXT:  BB0_2: ; %endif
; CHECK-NEXT:    s_or_b64 exec, exec, s[4:5]
; CHECK-NEXT:    s_waitcnt vmcnt(0)
; CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %c = icmp ne i32 %value, 0
  br i1 %c, label %if.true, label %endif

if.true:
  %val = load volatile i32, i32 addrspace(1)* undef
  br label %endif

endif:
  %v = phi i32 [ %val, %if.true ], [ undef, %entry ]
  ret i32 %v
}

define i32 @divergent_if_swap_brtarget_order1(i32 %value) {
; CHECK-LABEL: divergent_if_swap_brtarget_order1:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CHECK-NEXT:    ; implicit-def: $vgpr0
; CHECK-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; CHECK-NEXT:    ; mask branch BB1_2
; CHECK-NEXT:  BB1_1: ; %endif
; CHECK-NEXT:    s_or_b64 exec, exec, s[4:5]
; CHECK-NEXT:    s_setpc_b64 s[30:31]
; CHECK-NEXT:  BB1_2: ; %if.true
; CHECK-NEXT:    global_load_dword v0, v[0:1], off
; CHECK-NEXT:    s_or_b64 exec, exec, s[4:5]
; CHECK-NEXT:    s_waitcnt vmcnt(0)
; CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %c = icmp ne i32 %value, 0
  br i1 %c, label %if.true, label %endif

endif:
  %v = phi i32 [ %val, %if.true ], [ undef, %entry ]
  ret i32 %v

if.true:
  %val = load volatile i32, i32 addrspace(1)* undef
  br label %endif
}
