/*
 * Decompiled with CFR 0.152.
 */
package de.dimaki.refuel.updater.control;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ZipHandler.class);
    private static final String ROOT_PATH = "/";
    private static final String ZIP_EXTENSION = ".zip";

    private ZipHandler() {
    }

    public static Set<Path> unzip(Path zipFile, final Path targetDir, boolean deleteAfterUnzip) throws Exception {
        final HashSet<Path> extractedFiles = new HashSet<Path>();
        if (zipFile != null && zipFile.toString().endsWith(ZIP_EXTENSION)) {
            try (FileSystem zipFileSystem = FileSystems.newFileSystem(zipFile, null);){
                Path root = zipFileSystem.getPath(ROOT_PATH, new String[0]);
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path destFile = Paths.get(targetDir.toString(), file.toString());
                        extractedFiles.add(Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING));
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path dirToCreate = Paths.get(targetDir.toString(), dir.toString());
                        if (Files.notExists(dirToCreate, new LinkOption[0])) {
                            Files.createDirectory(dirToCreate, new FileAttribute[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            if (deleteAfterUnzip) {
                LOG.debug("Deleting zip file ''{}''", (Object)zipFile);
                Files.deleteIfExists(zipFile);
            }
        } else {
            LOG.debug("No zip file ''{}''!", (Object)zipFile);
            extractedFiles.add(zipFile);
        }
        return extractedFiles;
    }
}

