/*
 * Decompiled with CFR 0.152.
 */
package de.dimaki.refuel.appcast.boundary;

import de.dimaki.refuel.appcast.control.AppcastException;
import de.dimaki.refuel.appcast.entity.Appcast;
import de.dimaki.refuel.appcast.entity.Enclosure;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class AppcastManager {
    public static final String MANIFEST_APPCAST_VERSION = "Appcast-Version";
    public static final String MANIFEST_APPCAST_URL = "Appcast-Url";
    public static final int DEFAULT_CONNECT_TIMEOUT = 8000;
    public static final int DEFAULT_READ_TIMEOUT = 8000;
    Unmarshaller unmarshaller;

    public AppcastManager() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Appcast.class});
        this.unmarshaller = jc.createUnmarshaller();
    }

    public Appcast fetch(URL url) throws AppcastException {
        return this.fetch(url, null, 8000, 8000);
    }

    public Appcast fetch(URL url, Proxy proxy, int connectTimeout, int readTimeout) throws AppcastException {
        return this.fetch(url, proxy, connectTimeout, readTimeout, null);
    }

    public Appcast fetch(URL url, Proxy proxy, int connectTimeout, int readTimeout, Map<String, String> requestProperties) throws AppcastException {
        Appcast appcast = null;
        try {
            URLConnection conn = proxy == null ? url.openConnection() : url.openConnection(proxy);
            if (requestProperties != null) {
                requestProperties.forEach((k, v) -> conn.setRequestProperty((String)k, (String)v));
            }
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            conn.connect();
            appcast = (Appcast)this.unmarshaller.unmarshal(conn.getInputStream());
        }
        catch (JAXBException jbe) {
            throw new AppcastException("Could not read appcast from URL", url, 404, jbe.getMessage());
        }
        catch (SocketTimeoutException ste) {
            throw new AppcastException("Timeout reading appcast from URL", url, 408, ste.getCause() != null ? ste.getCause().getMessage() : ste.getMessage());
        }
        catch (UnknownHostException uhe) {
            throw new AppcastException("Unknown Host", url, 404, uhe.getMessage());
        }
        catch (IOException ex) {
            throw new AppcastException("Could not establish connection to URL", url, 403, ex.getMessage());
        }
        return appcast;
    }

    public String getLatestVersion(URL url) throws AppcastException {
        return this.getLatestVersion(url, null, 8000, 8000);
    }

    public String getLatestVersion(URL url, Proxy proxy, int connectTimeout, int readTimeout) throws AppcastException {
        String version = null;
        Appcast appcast = this.fetch(url, proxy, connectTimeout, readTimeout);
        if (appcast != null) {
            version = appcast.getLatestVersion();
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path download(Appcast appcast, Path targetDir) throws IOException, Exception {
        String url;
        Path downloaded = null;
        Enclosure enclosure = appcast.getLatestEnclosure();
        if (enclosure != null && (url = enclosure.getUrl()) != null && !url.isEmpty()) {
            URL enclosureUrl = new URL(url);
            String targetName = url.substring(url.lastIndexOf(47) + 1, url.length());
            long length = enclosure.getLength();
            File tmpFile = null;
            ReadableByteChannel rbc = null;
            FileOutputStream fos = null;
            try {
                long size;
                tmpFile = File.createTempFile("ac-", ".part");
                rbc = Channels.newChannel(enclosureUrl.openStream());
                fos = new FileOutputStream(tmpFile);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                if (length > 0L && length != (size = Files.size(tmpFile.toPath()))) {
                    throw new Exception("Downloaded file has wrong size! Expected: " + length + " -- Actual: " + size);
                }
                String md5 = enclosure.getMd5();
                if (md5 != null) {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    md.reset();
                    byte[] bytes = new byte[2048];
                    try (FileInputStream is = new FileInputStream(tmpFile);){
                        int numBytes;
                        while ((numBytes = is.read(bytes)) != -1) {
                            md.update(bytes, 0, numBytes);
                        }
                    }
                    String hash = AppcastManager.toHex(md.digest());
                    if (!md5.equalsIgnoreCase(hash)) {
                        throw new Exception("Downloaded file has wrong MD5 hash! Expected: " + md5 + " -- Actual: " + hash);
                    }
                }
                downloaded = Files.copy(tmpFile.toPath(), targetDir.resolve(targetName), StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (rbc != null) {
                        rbc.close();
                    }
                }
                catch (IOException iOException) {}
                if (tmpFile != null) {
                    Files.deleteIfExists(tmpFile.toPath());
                }
            }
        }
        return downloaded;
    }

    private static String toHex(byte[] arrayBytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arrayBytes.length; ++i) {
            sb.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

