/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusComboBehavior;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class ChoiceBoxBehavior<T>
extends BehaviorBase<ChoiceBox<T>> {
    private final InputMap<ChoiceBox<T>> choiceBoxInputMap = this.createInputMap();
    private TwoLevelFocusComboBehavior tlFocus;

    public ChoiceBoxBehavior(ChoiceBox<T> choiceBox) {
        super(choiceBox);
        this.addDefaultMapping(this.choiceBoxInputMap, new InputMap.KeyMapping(KeyCode.SPACE, (EventType<KeyEvent>)KeyEvent.KEY_PRESSED, (EventHandler<KeyEvent>)((EventHandler)this::keyPressed)), new InputMap.KeyMapping(KeyCode.SPACE, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, (EventHandler<KeyEvent>)((EventHandler)this::keyReleased)), new InputMap.KeyMapping(KeyCode.ESCAPE, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.cancel())), new InputMap.KeyMapping(KeyCode.DOWN, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.showPopup())), new InputMap.KeyMapping(KeyCode.CANCEL, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.cancel())), new InputMap.MouseMapping((EventType<MouseEvent>)MouseEvent.MOUSE_PRESSED, (EventHandler<MouseEvent>)((EventHandler)this::mousePressed)), new InputMap.MouseMapping((EventType<MouseEvent>)MouseEvent.MOUSE_RELEASED, (EventHandler<MouseEvent>)((EventHandler)this::mouseReleased)));
        InputMap<ChoiceBox<T>> inputMap = new InputMap<ChoiceBox<T>>(choiceBox);
        inputMap.setInterceptor(event -> !Utils.isTwoLevelFocus());
        inputMap.getMappings().addAll((Object[])new InputMap.Mapping[]{new InputMap.KeyMapping(KeyCode.ENTER, (EventType<KeyEvent>)KeyEvent.KEY_PRESSED, (EventHandler<KeyEvent>)((EventHandler)this::keyPressed)), new InputMap.KeyMapping(KeyCode.ENTER, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, (EventHandler<KeyEvent>)((EventHandler)this::keyReleased))});
        this.addDefaultChildMap(this.choiceBoxInputMap, inputMap);
        if (Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusComboBehavior((Node)choiceBox);
        }
    }

    @Override
    public InputMap<ChoiceBox<T>> getInputMap() {
        return this.choiceBoxInputMap;
    }

    @Override
    public void dispose() {
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
        }
        super.dispose();
    }

    public void select(int n) {
        SingleSelectionModel singleSelectionModel = ((ChoiceBox)this.getNode()).getSelectionModel();
        if (singleSelectionModel == null) {
            return;
        }
        ((SelectionModel)singleSelectionModel).select(n);
    }

    public void close() {
        ((ChoiceBox)this.getNode()).hide();
    }

    public void showPopup() {
        ((ChoiceBox)this.getNode()).show();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        ChoiceBox choiceBox = (ChoiceBox)this.getNode();
        if (choiceBox.isFocusTraversable()) {
            choiceBox.requestFocus();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        ChoiceBox choiceBox = (ChoiceBox)this.getNode();
        if (choiceBox.isShowing() || !choiceBox.contains(mouseEvent.getX(), mouseEvent.getY())) {
            choiceBox.hide();
        } else if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            choiceBox.show();
        }
    }

    private void keyPressed(KeyEvent keyEvent) {
        ChoiceBox choiceBox = (ChoiceBox)this.getNode();
        if (!choiceBox.isShowing()) {
            choiceBox.show();
        }
    }

    private void keyReleased(KeyEvent keyEvent) {
    }

    public void cancel() {
        ChoiceBox choiceBox = (ChoiceBox)this.getNode();
        choiceBox.hide();
    }
}

