/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import contrib.com.jgoodies.looks.common.FontPolicy;
import contrib.com.jgoodies.looks.common.FontSet;
import java.awt.Insets;
import org.jvnet.substance.SubstanceLookAndFeel;

public class SubstanceSizeUtils {
    private static int controlFontSize = -1;

    public static void setControlFontSize(int size) {
        controlFontSize = size;
    }

    public static int getControlFontSize() {
        if (controlFontSize > 0) {
            return controlFontSize;
        }
        FontPolicy fPolicy = SubstanceLookAndFeel.getFontPolicy();
        FontSet fSet = fPolicy.getFontSet("Substance", null);
        controlFontSize = fSet.getControlFont().getSize();
        return controlFontSize;
    }

    public static int getScrollBarWidth() {
        return SubstanceSizeUtils.getControlFontSize() + 4;
    }

    public static int getArrowIconWidth() {
        int result = SubstanceSizeUtils.getControlFontSize() - 2;
        if (result % 2 == 0) {
            --result;
        }
        return result;
    }

    public static int getArrowIconHeight() {
        return 6 + (SubstanceSizeUtils.getControlFontSize() - 11) / 2;
    }

    public static int getTabCloseIconSize() {
        return 8 + (SubstanceSizeUtils.getControlFontSize() - 6) / 2;
    }

    public static int getTitlePaneIconSize() {
        return 5 + SubstanceSizeUtils.getControlFontSize();
    }

    public static int getSliderIconSize() {
        int result = SubstanceSizeUtils.getControlFontSize() + 5;
        if (result % 2 == 1) {
            --result;
        }
        return result;
    }

    public static int getMenuCheckMarkSize() {
        int result = SubstanceSizeUtils.getControlFontSize() - 2;
        if (result % 2 == 0) {
            --result;
        }
        return result;
    }

    public static int getCheckBoxMarkSize() {
        return 5 + SubstanceSizeUtils.getControlFontSize();
    }

    public static int getRadioButtonMarkSize() {
        int result = SubstanceSizeUtils.getControlFontSize();
        if (result % 2 == 0) {
            --result;
        }
        return result;
    }

    public static int getSliderTrackSize() {
        return Math.max(4, 5 + (SubstanceSizeUtils.getControlFontSize() - 11) / 2);
    }

    public static float getArrowStrokeWidth() {
        return (float)SubstanceSizeUtils.getControlFontSize() / 6.0f;
    }

    public static float getDoubleArrowStrokeWidth() {
        return (float)SubstanceSizeUtils.getControlFontSize() / 8.0f;
    }

    public static float getTabCloseButtonStrokeWidth() {
        return (float)SubstanceSizeUtils.getControlFontSize() / 10.0f;
    }

    public static int getSpinnerButtonWidth() {
        return SubstanceSizeUtils.getArrowIconWidth() * 3 / 2;
    }

    public static int getPasswordDotDiameter() {
        int result = SubstanceSizeUtils.getControlFontSize() - 5;
        if (result % 2 == 0) {
            ++result;
        }
        return result;
    }

    public static int getPasswordDotGap() {
        return (SubstanceSizeUtils.getControlFontSize() - 6) / 3;
    }

    public static int getMinButtonWidth() {
        return (int)(3.5 * (double)SubstanceSizeUtils.getMinButtonHeight());
    }

    public static int getMinButtonHeight() {
        return 11 + (SubstanceSizeUtils.getControlFontSize() - 5) * 3 / 2;
    }

    public static int getExtraPadding() {
        int cfs = SubstanceSizeUtils.getControlFontSize();
        if (cfs < 14) {
            return 0;
        }
        return (cfs - 11) / 3;
    }

    public static int getExtraPadding(int baseSize) {
        int cfs = SubstanceSizeUtils.getControlFontSize();
        if (cfs < 14) {
            return 0;
        }
        return (cfs - 11) / (6 - baseSize);
    }

    public static Insets getTextBorderInsets() {
        int borderPadding = SubstanceSizeUtils.getExtraPadding();
        return new Insets(3 + borderPadding, 4 + borderPadding, 3 + borderPadding, 4 + borderPadding);
    }

    public static Insets getComboBorderInsets() {
        int borderPadding = SubstanceSizeUtils.getExtraPadding();
        return new Insets(1 + borderPadding, 2 + borderPadding, 1 + borderPadding, 2 + borderPadding);
    }

    public static Insets getSpinnerArrowButtonInsets() {
        int borderPadding = SubstanceSizeUtils.getExtraPadding();
        return new Insets(2 + borderPadding, borderPadding, 2 + borderPadding, 2 + borderPadding);
    }

    public static Insets getSpinnerBorderInsets() {
        int borderPadding = SubstanceSizeUtils.getExtraPadding();
        return new Insets(3 + borderPadding, 3 + borderPadding, 3 + borderPadding, 3 + borderPadding);
    }

    public static float getFocusStrokeWidth() {
        return (float)SubstanceSizeUtils.getControlFontSize() / 10.0f;
    }
}

