/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.optimizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.TreeSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.optimizer.ClassConstantsCollector;
import org.objectweb.asm.optimizer.ClassOptimizer;
import org.objectweb.asm.optimizer.Constant;
import org.objectweb.asm.optimizer.ConstantPool;
import org.objectweb.asm.optimizer.NameMapping;
import org.objectweb.asm.optimizer.Shrinker$ConstantComparator;

public class Shrinker {
    public static void main(String[] stringArray) throws IOException {
        NameMapping nameMapping = new NameMapping(stringArray[0]);
        File file = new File(stringArray[1]);
        File file2 = new File(stringArray[2]);
        Shrinker.optimize(file, file2, nameMapping);
        Iterator iterator = nameMapping.unused.iterator();
        while (iterator.hasNext()) {
            System.out.println("INFO: unused mapping " + iterator.next());
        }
    }

    static void optimize(File file, File file2, NameMapping nameMapping) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Shrinker.optimize(fileArray[i], file2, nameMapping);
            }
        } else if (file.getName().endsWith(".class")) {
            Object object;
            ConstantPool constantPool = new ConstantPool();
            ClassReader classReader = new ClassReader(new FileInputStream(file));
            ClassWriter classWriter = new ClassWriter(false);
            ClassConstantsCollector classConstantsCollector = new ClassConstantsCollector(classWriter, constantPool);
            ClassOptimizer classOptimizer = new ClassOptimizer(classConstantsCollector, nameMapping);
            classReader.accept(classOptimizer, true);
            TreeSet treeSet = new TreeSet(new Shrinker$ConstantComparator());
            treeSet.addAll(constantPool.values());
            classReader = new ClassReader(classWriter.toByteArray());
            classWriter = new ClassWriter(false);
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                object = (Constant)iterator.next();
                ((Constant)object).write(classWriter);
            }
            classReader.accept(classWriter, true);
            object = nameMapping.map(classOptimizer.getClassName());
            File file3 = new File(file2, (String)object + ".class");
            if (!file3.exists() || file3.lastModified() < file.lastModified()) {
                file3.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                ((OutputStream)fileOutputStream).write(classWriter.toByteArray());
                ((OutputStream)fileOutputStream).close();
            }
        }
    }
}

