/*
    LANShare - LAN file transfer.
    Copyright (C) 2016 Abdul Aris R. <abdularisrahmanudin10@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef SINGLEINSTANCE_H
#define SINGLEINSTANCE_H

#include <QObject>
#include <QtNetwork/QLocalServer>

/*
 * SingleInstance, digunakan agar aplikasi hanya memiliki satu instance
 * yang berjalan disistem operasi
 */
class SingleInstance : public QObject
{
    Q_OBJECT

public:
    SingleInstance(const QString& id, QObject* parent = 0);
    ~SingleInstance();

    QString getLastErrorString() const;
    bool start();
    bool hasPreviousInstance();

Q_SIGNALS:
    void newInstanceCreated();

private Q_SLOTS:
    void onNewConnection();

private:

    QLocalServer mServer;
    QString mName;
};

#endif // SINGLEINSTANCE_H
