//
//	
//    The Laxkit, a windowing toolkit
//    Please consult http://laxkit.sourceforge.net about where to send any
//    correspondence about this software.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    Copyright (C) 2016 by Tom Lechner
//
#ifndef _LAX_NODEINTERFACE_H
#define _LAX_NODEINTERFACE_H

#include <lax/interfaces/aninterface.h>


namespace Laidout { 

//default node types:
//  string
//  int
//  double
//  boolean
//  color
//  file
//  date
//  image


//---------------------------- Nodes ------------------------------------

class NodeInput
{
  public:
	NodeBase *owner;

	char *label;
	Laxkit::ScreenColor color;
	Laxkit::PtrStack<NodeOutput> sources;
	anObject *default_source;

	flatpoint pos; //relative to parent NodeBase origin

	NodeInput();
	virtual ~NodeInput();
};

class NodeOutput
{
  public:
	char *label;
	Laxkit::ScreenColor color;
	Laxkit::PtrStack<NodeInput> targets;
	anObject *output;

	flatpoint pos; //clickable spot relative to parent NodeBase origin

	NodeOutput();
	virtual ~NodeOutput();
};

-------

class NodeConnection
{
  public:
	Laxkit::ScreenColor *color; //NULL means use parent's color

	Laxkit::NumStack<flatpoint> path; //points between (and including) start and end points for custom winding,
									  //though start and end are taken from the connected node properties

	NodeBase *from, *to;
	NodeProperty *fromprop, *toprop;

	NodeConnection();
	virtual ~NodeConnection();
};

class NodeProperty
{
  public:
	char *name;
	char *Name;

	Laxkit::anObject *data;
	bool is_input; //or output
	bool is_inputable; //default true for something that allows links in

	Laxkit::ScreenColor color;
	Laxkit::PtrStack<NodeConnector> connections;

	flatpoint pos; //clickable spot relative to parent NodeBase origin

	NodeProperty();
	virtual ~NodeProperty();
	virtual anInterface *PropInterface() { return NULL; } //for custom interfaces on properties
};

class NodeColors : Laxkit::anObject
{
  public:
	//LaxFont *font;

	Laxkit::ScreenColor border;
	Laxkit::ScreenColor bg;
	Laxkit::ScreenColor fg;
	Laxkit::ScreenColor text;

	Laxkit::ScreenColor mo_border;
	Laxkit::ScreenColor mo_bg;

	Laxkit::ScreenColor selected_border;
	Laxkit::ScreenColor selected_mo_border;
	Laxkit::ScreenColor selected_bg;
	Laxkit::ScreenColor selected_mo_bg;

	unsigned int state; //normal | selected | mouseOver
	NodeColors *next; //one node per state

	NodeColors() { next=NULL; }
	virtual ~NodeColors() { if (next) next->dec_count(); }
};

class NodeBase : public Laxkit::anObject, public Laxkit::DoubleRectangle
{
  public:
	 //state
	char *Name;
	bool collapsed;
	bool deletable;
	Laxkit::LaxImage *total_preview;

	Laxkit::PtrStack<NodeProperty> properties; //includes inputs and outputs

	 //styling:
	 //  border mo_border  selected_border selected_mo_border
	 //  bg     mo_bg      selected_bg     selected_mo_bg
	 //
	NodeColors *colors;

	NodeBase();
	virtual ~NodeBase();
	virtual int InstallColors(NodeColors newcolors);
	virtual const char *Label() { return object_idstr; }

	virtual int Update();
	virtual int Wrap();
};


/*! \class NodeGroup
 * Class to hold a collection of nodes.
 */

class NodeGroup : public NodeBase
{
  public:
	Laxkit::Affine m;
	Laxkit::PtrStack<NodeBase> nodes; //nodes wrapped into this group
	Laxkit::PtrStack<NodeConnection> connections;
};

typedef NodeGroup Nodes;


//---------------------------- NodeInterface ------------------------------------

class NodeInterface : public anInterface
{
  protected:
	int showdecs;


	Laxkit::PtrStack<NodeBase> selected;

	Laxkit::PtrStack<NodeTypes> nodetypes;
	Nodes *nodes;
	double slot_radius; //as fraction of text size
	Laxkit::LaxFont *font;

	Laxkit::Affine transform; //from nodes to screen coords

	Laxkit::ScreenColor color_connection;
	Laxkit::ScreenColor color_connection_selected;
	Laxkit::ScreenColor color_node_selected;
	Laxkit::ScreenColor color_node_default;

	Laxkit::ShortcutHandler *sc;

	virtual int send();

  public:
	unsigned int node_interface_style;

	NodeInterface(anInterface *nowner, int nid,Laxkit::Displayer *ndp);
	virtual ~NodeInterface();
	virtual anInterface *duplicate(anInterface *dup);
	virtual const char *IconId() { return "Node"; }
	const char *Name();
	const char *whattype() { return "NodeInterface"; }
	const char *whatdatatype();
	Laxkit::MenuInfo *ContextMenu(int x,int y,int deviceid, Laxkit::MenuInfo *menu);
	virtual int Event(const Laxkit::EventData *data, const char *mes);
	virtual Laxkit::ShortcutHandler *GetShortcuts();
	virtual int PerformAction(int action);

	virtual int UseThis(Laxkit::anObject *nlinestyle,unsigned int mask=0);
	virtual int InterfaceOn();
	virtual int InterfaceOff();
	virtual void Clear(SomeData *d);
	virtual int Refresh();
	virtual int MouseMove(int x,int y,unsigned int state, const Laxkit::LaxMouse *d);
	virtual int LBDown(int x,int y,unsigned int state,int count, const Laxkit::LaxMouse *d);
	virtual int LBUp(int x,int y,unsigned int state, const Laxkit::LaxMouse *d);
	virtual int MBDown(int x,int y,unsigned int state,int count, const Laxkit::LaxMouse *d);
	virtual int MBUp(int x,int y,unsigned int state, const Laxkit::LaxMouse *d);
	virtual int WheelUp  (int x,int y,unsigned int state,int count, const Laxkit::LaxMouse *d);
	virtual int WheelDown(int x,int y,unsigned int state,int count, const Laxkit::LaxMouse *d);
	virtual int CharInput(unsigned int ch, const char *buffer,int len,unsigned int state, const Laxkit::LaxKeyboard *d);
	virtual int KeyUp(unsigned int ch,unsigned int state, const Laxkit::LaxKeyboard *d);

};

} // namespace Laidout

#endif

