//
//	
//    The Laxkit, a windowing toolkit
//    Please consult http://laxkit.sourceforge.net about where to send any
//    correspondence about this software.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    Copyright (C) 2016 by Tom Lechner
//



#include <lax/interfaces/nodeinterface.h>

#include <lax/interfaces/somedatafactory.h>
#include <lax/laxutils.h>
#include <lax/language.h>


//You need this if you use any of the Laxkit stack templates in lax/lists.h
#include <lax/lists.cc>


using namespace Laxkit;


#include <iostream>
using namespace std;
#define DBG 


namespace Laidout {


//-------------------------------------- NodeBase --------------------------

/*! \class NodeBase
 *
 * Class to hold node information for a NodeInterface.
 */


NodeBase::NodeBase()
{
	colors = NULL;
	collapsed = false;
	deletable = true;
}

NodeBase::~NodeBase()
{
	if (colors) colors->dec_count();
}


/*! Passing in NULL will set this->colors to NULL.
 */
int NodeBase::InstallColors(NodeColors newcolors)
{
	if (colors) colors->dec_count();
	colors = newcolors;
	if (colors) colors->inc_count();
	return 0;
}

/*! Call whenever any of the inputs change, update outputs.
 * Default placeolder is to do nothing.
 */
int NodeBase::Update()
{
	return 1;
}

/*! Update the bounds to be just enough to encase everything.
 */
int NodeBase::Wrap()
{ ***
	double th= *** ;

	width = *** ;
	height = th*(1+.5+properties.n);
}


//-------------------------------------- NodeInterface --------------------------

/*! \class NodeInterface
 * \ingroup interfaces
 */


NodeInterface::NodeInterface(anInterface *nowner, int nid, Displayer *ndp)
 : anInterface(nowner,nid,ndp)
{
	node_interface_style=0;

	nodes=NULL;

	showdecs=1;
	needtodraw=1;
	font = app->defaultlaxfont;
	font->inc_count();

	sc=NULL; //shortcut list, define as needed in GetShortcuts()
}

NodeInterface::~NodeInterface()
{ ***
	if (nodes) nodes->dec_count();
	if (sc) sc->dec_count();
}

const char *NodeInterface::whatdatatype()
{ *** 
	return "Nodes";
}

/*! Name as displayed in menus, for instance.
 */
const char *NodeInterface::Name()
{ return _("Node tool"); }


//! Return new NodeInterface.
/*! If dup!=NULL and it cannot be cast to NodeInterface, then return NULL.
 */
anInterface *NodeInterface::duplicate(anInterface *dup)
{
	if (dup==NULL) dup=new NodeInterface(NULL,id,NULL);
	else if (!dynamic_cast<NodeInterface *>(dup)) return NULL;
	return anInterface::duplicate(dup);
}

/*! Normally this will accept some common things like changes to line styles, like a current color.
 */
int NodeInterface::UseThis(anObject *nobj, unsigned int mask)
{
	if (!nobj) return 1;
//	LineStyle *ls=dynamic_cast<LineStyle *>(nobj);
//	if (ls!=NULL) {
//		if (mask&GCForeground) { 
//			linecolor=ls->color;
//		}
////		if (mask&GCLineWidth) {
////			linecolor.width=ls->width;
////		}
//		needtodraw=1;
//		return 1;
//	}
	return 0;
}

/*! Any setup when an interface is activated, which usually means when it is added to 
 * the interface stack of a viewport.
 */
int NodeInterface::InterfaceOn()
{ 
	showdecs=1;
	needtodraw=1;
	return 0;
}

/*! Any cleanup when an interface is deactivated, which usually means when it is removed from
 * the interface stack of a viewport.
 */
int NodeInterface::InterfaceOff()
{ 
	Clear(NULL);
	showdecs=0;
	needtodraw=1;
	return 0;
}

void NodeInterface::Clear(SomeData *d)
{
}

Laxkit::MenuInfo *NodeInterface::ContextMenu(int x,int y,int deviceid, Laxkit::MenuInfo *menu)
{
	//if (no menu for x,y) return NULL;

	if (!menu) menu=new MenuInfo;
	if (!menu->n()) menu->AddSep(_("Nodes"));

	menu->AddItem(_("Add node..."), NODE_Add_New);
	//menu->AddItem(_("Add node..."), NODE_Add_New, LAX_ISTOGGLE|(istyle&FREEHAND_Raw_Path)?LAX_CHECKED:0);
	//menu->AddItem(_("Some menu item"), SOME_MENU_VALUE);
	//menu->AddSep(_("Some separator text"));
	//menu->AddItem(_("Et Cetera"), SOME_OTHER_VALUE);

	return menu;
}

int NodeInterface::Event(const Laxkit::EventData *data, const char *mes)
{
    if (!strcmp(mes,"menuevent")) {
        const SimpleMessage *s=dynamic_cast<const SimpleMessage*>(e_data);
        int i =s->info2; //id of menu item

        if ( i==SOME_MENU_VALUE) {
			...
		}

		return 0; 
	}

	return 1; //event not absorbed
}

/*! Draw an open path such that first point is BG() and last point is FG().
 * Assume points are a bez path, v-c-c-v-...-v-c-c-v.
 *
 * n is the number of points in pts.
 *
 * Pretty slow for long paths.
 */
void DrawColoredPath(flatpoint *pts, int n)
{
	flatpoint bpts[20*(n)/3];

	 //find length
	double length=0, l=0;

	 //grab polyline from bez
	bez_points(bpts, (n-1)/3+1, pts, 20);

	for (int c2=1; c2<((n-1)/3+1)*20; c2++) {
		length += norm(bpts[c2]-bpts[c2-1]);
	}

	 //draw points based on percent total length
	for (int c2=0; c2<((n-1)/3+1)*20; c2++) {
		dp->NewFG(coloravg(bg, fg, l/length));
		dp->drawline(bpts[c2], bpts[c2+1]);

		l+=norm(bpts[c2+1]-bpts[c2]):
	}
}

int NodeInterface::Refresh()
{ *** 

	if (needtodraw==0) return 0;
	needtodraw=0;


	if (!nodes) return 0;

	dp->PushAxes();
	dp->NewTransform(nodes->m);
	dp->font(font);

	 //---draw connections
	for (int c=0; c<nodes->connections.n; c++) {
		***
	}

	 //---draw nodes:
	 //  box+border
	 //  label
	 //  expanded arrow
	 //  preview
	 //  ins/outs
	NodeBase *node;
	ScreenColor *border, *bg;
	NodeColors *colors=NULL;
	double th = dp->textheight();

	for (int c=0; c<nodes->nodes.n; c++) {
		 //set up colors based on whether the node is selected or mouse overed
		if (node->colors) colors=node->colors;
		else colors = nodes->colors;

		border = &colors->border;
		bg = &colors->bg;
		if (IsMouseOver(node)) {
			border = &colors->mo_border;
			bg     = &colors->mo_bg;
		}
		if (IsSelected(node))  { 
			border = &colors->selected_border;
			bg     = &colors->selected_bg;
		}
		dp->NewFG(border);
		dp->NewBG(bg);

		 //draw whole rect
		dp->DrawRoundedRect(node->x, node->y, node->width, node->height,
							th/3, false, th/3, false, 2); 

		 //draw label
		dp->textout(node->BBoxPoint(.5,0), node->Name, -1, LAX_TOP|LAX_HCENTER);

		flatpoint p(node->x+node->width, node->y);
		if (node->collapsed) dp->drawthing(p.x-th, p.y+th/2, th,th, 1, THING_Triangle_Right);
		else {
			 //node is expanded
			dp->drawthing(p.x-th, p.y+th/2, th,th, 1, THING_Triangle_Down);

			 //draw preview
			if (node->total_preview) {
				double ph = (node->width-th)*node->total_preview->h()/node->totalpreview->w();
				dp->imageout(node->totalpreview, node->x, node->y+th, node->width, ph);
			}

			 //draw ins and outs
			double y=node->y+th*1.5;
			NodeProperty *prop;
			for (int c2=0; c2<node->properties.n; c2++) {
				prop = node->properties.e[c2];

				 // *** NEEDS BETTER!!
				if (prop->is_input) 
					 dp->textout(node->x+th/2, y, prop->Name,-1, LAX_LEFT|LAX_TOP);
				else dp->textout(node->x+node->width-th/2, y, prop->Name,-1, LAX_RIGHT|LAX_TOP);
			}
		}
	}


	dp->PopAxes();

	return 0;
}

//! Start a new freehand line.
int NodeInterface::LBDown(int x,int y,unsigned int state,int count, const Laxkit::LaxMouse *d) 
{ ***
	buttondown.down(d->id,LEFTBUTTON,x,y);

	//int device=d->subid; //normal id is the core mouse, not the controlling sub device
	//DBG cerr <<"device: "<<d->id<<"  subdevice: "<<d->subid<<endl;
	//LaxDevice *dv=app->devicemanager->findDevice(device);
	//device_name=dv->name;

	needtodraw=1;
	return 0; //return 0 for absorbing event, or 1 for ignoring
}

//! Finish a new freehand line by calling newData with it.
int NodeInterface::LBUp(int x,int y,unsigned int state, const Laxkit::LaxMouse *d) 
{ ***
	buttondown.up(d->id,LEFTBUTTON);
	return 0; //return 0 for absorbing event, or 1 for ignoring
}

int NodeInterface::MouseMove(int x,int y,unsigned int state, const Laxkit::LaxMouse *d)
{ ***
	if (!buttondown.any()) {
		// update any mouse over state
		// ...
		return 1;
	}

	//else deal with mouse dragging...
	*** control mouse drag over non-nodes breaks any connections
	
	*** drag out selection area for selecting or deselecting

	*** move a bunch of nodes

	//needtodraw=1;
	return 0; //MouseMove is always called for all interfaces, return value doesn't inherently matter
}

int NodeInterface::WheelUp(int x,int y,unsigned int state,int count, const Laxkit::LaxMouse *d)
{ ***
	return 1; //wheel up ignored
}

int NodeInterface::WheelDown(int x,int y,unsigned int state,int count, const Laxkit::LaxMouse *d)
{ ***
	return 1; //wheel down ignored
}


int NodeInterface::send()
{ ***
//	if (owner) {
//		RefCountedEventData *data=new RefCountedEventData(paths);
//		app->SendMessage(data,owner->object_id,"NodeInterface", object_id);
//
//	} else {
//		if (viewport) viewport->NewData(paths,NULL);
//	}

	return 0;
}

int NodeInterface::CharInput(unsigned int ch, const char *buffer,int len,unsigned int state, const Laxkit::LaxKeyboard *d)
{ ***
	if ((state&LAX_STATE_MASK)==(ControlMask|ShiftMask|AltMask|MetaMask)) {
		//deal with various modified keys...
	}

	if (ch==LAX_Esc) { //the various possible keys beyond normal ascii printable chars are defined in lax/laxdefs.h
		needtodraw=1;
		return 0;
	}

	return 1; //key not dealt with, propagate to next interface
}

int NodeInterface::KeyUp(unsigned int ch,unsigned int state, const Laxkit::LaxKeyboard *d)
{ ***
	return 1; //key not dealt with
}

Laxkit::ShortcutHandler *NodeInterface::GetShortcuts()
{ ***
}

int NodeInterface::PerformAction(int action)
{
	if (action==NODES_Group_Nodes) {
		***

	} else if (action==NODES_Ungroup_Nodes) {
		***

	} else if (action==NODES_Add_Node) {
		***

	}
}

} // namespace Laidout

