#!/bin/bash
#set -ueo pipefail
#set -x

REPO_DIR=$(cd $(dirname $0) && pwd)

DEST_DIR=/usr/share/icons
THEME_NAME=Capitaine
THEME_DIR=${DEST_DIR}/${THEME_NAME}


#echo  "Customize '${THEME_DIR}'..."
  #./build.sh

usage() {
  printf "%s\n" "Usage: $0 [OPTIONS...]"
  printf "\n%s\n" "OPTIONS:"
  printf "  %-25s%s\n" "-d, --dest DIR" "Specify theme destination directory (Default: ${DEST_DIR})"
  printf "  %-25s%s\n" "-n, --name NAME" "Specify theme name (Default: ${THEME_NAME})"
  printf "  %-25s%s\n" "-h, --help" "Show this help"
  printf "\n%s\n" "INSTALLATION EXAMPLES:"
  printf "%s\n" "Install all theme variants into ~/.icons"
  printf "  %s\n" "$0 --dest ~/.icons"
}

install() {
  local dest=${1}
  local name=${2}

  local THEME_DIR=${dest}/${name}

  [[ -d ${THEME_DIR} ]] && rm -rf ${THEME_DIR}

  echo "Installing '${THEME_DIR}'..."

  mkdir -p  ${THEME_DIR}
  cp -r ${REPO_DIR}/COPYING ${THEME_DIR}
  cp -pr ${REPO_DIR}/dist/* ${THEME_DIR}
}

while [[ $# -gt 0 ]]; do
  case "${1}" in
    -d|--dest)
      dest="${2}"
      if [[ ! -d "${dest}" ]]; then
        echo "ERROR: Destination directory does not exist."
        exit 1
      fi
      shift 2
      ;;
    -n|--name)
      name="${2}"
      shift 2
      ;;
    -h|--help)
      usage
      exit 0
      ;;
    *)
      echo "ERROR: Unrecognized installation option '$1'."
      echo "Try '$0 --help' for more information."
      exit 1
      ;;
  esac
done

if [[ ! -w "${dest:-${DEST_DIR}}" ]]; then
  echo "Please run as root."
  exit 1
fi

install "${dest:-${DEST_DIR}}" "${name:-${THEME_NAME}}"

#echo "Updating icon cache..."
#update-alternatives --install /usr/share/icons/default/index.theme \
        #x-cursor-theme /usr/share/icons/Capitaine/index.theme 90
