(* iTunes installer script for iGoom *)


(* If application is running, warn and quit it *)
set pid to do shell script "ps -U ${USER} | grep /Applications/iTunes.app/Contents/MacOS/iTunes | grep -v grep | cut -c1-5"
if pid is not "" then
	display dialog "iTunes must not be running while installing. Can I quit it?" with icon 2
	tell application "iTunes"
		quit
	end tell
end if

(* Install the new plugin *)
set cmd to "\\rm -rf ~/\"Library/iTunes/iTunes Plug-ins\"iGoom.bundle"
do shell script cmd

set r to "err"
set cmd to "\\cp -Rf /Volumes/iGoom/iGoom.bundle ~/\"Library/iTunes/iTunes Plug-ins\""
try
	do shell script cmd
	set r to ""
end try
if r is not "" then
	(* Troubleshooting *)
	display dialog "There was a problem during installation." buttons {"Open ReadMe", "Forum", "OK"} default button 1 with icon 0
	set dresult to button returned of result
	
	if dresult is "Open ReadMe" then
		do shell script "open /Volumes/iGoom/ReadMe.rtf"
	else
		if dresult is "Forum" then
			open location "http://www.ios-software.com/?page=forum&quoi=1"
		end if
	end if
else
	
	(* relaunch, but not too quickly ! *)
	set relaunched to false
	repeat until relaunched is true
		try
			tell application "iTunes"
				activate
			end tell
			set relaunched to true
		end try
	end repeat
	
	(* Select the new plugin et show it if possible *)
	tell application "iTunes"
		repeat with i in visuals
			if name of i is "iGoom" then
				set current visual to i
				try
					set full screen to false
					set visuals enabled to true
					play first item of library playlists
				end try
			end if
		end repeat
	end tell
	
	(* Tell the user the plugin was successfully installed *)
	activate
	display dialog "Installation was successful. If you like Goom, consider donating or buying some goodies !" buttons {"iOS Store", "Donate", "Use Goom"} default button "iOS Store" with icon 1
	set dresult to button returned of result
	
	if dresult is "iOS Store" then
		open location "http://www.cafepress.com/iossoftware"
	end if
	if dresult is "Donate" then
		open location "http://www.ios-software.com/?page=index&what=about"
	end if
	if dresult is "Use Goom" then
		tell application "iTunes"
			activate
		end tell
	end if
	
end if
