
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file generated/gsiDeclQUdpSocket_EventAdaptor.cc
*  @brief Event adaptor implementations for QUdpSocket
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQUdpSocket_EventAdaptor.h"

// -----------------------------------------------------------------------
// class QUdpSocket_EventAdaptor

QUdpSocket_EventAdaptor::QUdpSocket_EventAdaptor (QObject *host)
  : QObject ()
{
  connect (host, SIGNAL(aboutToClose()), this, SLOT(aboutToClose()));
  connect (host, SIGNAL(bytesWritten(qint64)), this, SLOT(bytesWritten(qint64)));
  connect (host, SIGNAL(connected()), this, SLOT(connected()));
  connect (host, SIGNAL(destroyed(QObject *)), this, SLOT(destroyed(QObject *)));
  connect (host, SIGNAL(disconnected()), this, SLOT(disconnected()));
  connect (host, SIGNAL(error(QAbstractSocket::SocketError)), this, SLOT(error(QAbstractSocket::SocketError)));
  connect (host, SIGNAL(hostFound()), this, SLOT(hostFound()));
  connect (host, SIGNAL(proxyAuthenticationRequired(const QNetworkProxy &, QAuthenticator *)), this, SLOT(proxyAuthenticationRequired(const QNetworkProxy &, QAuthenticator *)));
  connect (host, SIGNAL(readChannelFinished()), this, SLOT(readChannelFinished()));
  connect (host, SIGNAL(readyRead()), this, SLOT(readyRead()));
  connect (host, SIGNAL(stateChanged(QAbstractSocket::SocketState)), this, SLOT(stateChanged(QAbstractSocket::SocketState)));
}

//  Event QUdpSocket::aboutToClose()
void QUdpSocket_EventAdaptor::aboutToClose() {
BEGIN_PROTECTED
  aboutToClose_e_0();
END_PROTECTED
}

//  Event QUdpSocket::bytesWritten(qint64 bytes)
void QUdpSocket_EventAdaptor::bytesWritten(qint64 bytes) {
BEGIN_PROTECTED
  bytesWritten_e_986(bytes);
END_PROTECTED
}

//  Event QUdpSocket::connected()
void QUdpSocket_EventAdaptor::connected() {
BEGIN_PROTECTED
  connected_e_0();
END_PROTECTED
}

//  Event QUdpSocket::destroyed(QObject *arg1)
void QUdpSocket_EventAdaptor::destroyed(QObject *arg1) {
BEGIN_PROTECTED
  destroyed_e_1302(arg1);
END_PROTECTED
}

//  Event QUdpSocket::disconnected()
void QUdpSocket_EventAdaptor::disconnected() {
BEGIN_PROTECTED
  disconnected_e_0();
END_PROTECTED
}

//  Event QUdpSocket::error(QAbstractSocket::SocketError arg1)
void QUdpSocket_EventAdaptor::error(QAbstractSocket::SocketError arg1) {
BEGIN_PROTECTED
  error_e_3209(qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketError>(arg1));
END_PROTECTED
}

//  Event QUdpSocket::hostFound()
void QUdpSocket_EventAdaptor::hostFound() {
BEGIN_PROTECTED
  hostFound_e_0();
END_PROTECTED
}

//  Event QUdpSocket::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)
void QUdpSocket_EventAdaptor::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator) {
BEGIN_PROTECTED
  proxyAuthenticationRequired_e_4652(proxy, authenticator);
END_PROTECTED
}

//  Event QUdpSocket::readChannelFinished()
void QUdpSocket_EventAdaptor::readChannelFinished() {
BEGIN_PROTECTED
  readChannelFinished_e_0();
END_PROTECTED
}

//  Event QUdpSocket::readyRead()
void QUdpSocket_EventAdaptor::readyRead() {
BEGIN_PROTECTED
  readyRead_e_0();
END_PROTECTED
}

//  Event QUdpSocket::stateChanged(QAbstractSocket::SocketState arg1)
void QUdpSocket_EventAdaptor::stateChanged(QAbstractSocket::SocketState arg1) {
BEGIN_PROTECTED
  stateChanged_e_3200(qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketState>(arg1));
END_PROTECTED
}
