
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTreeWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTreeWidget_EventAdaptor.h"
#include "gsiDeclQTreeWidget_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTreeWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTreeWidget::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QTreeWidget::addTopLevelItem(QTreeWidgetItem *item)


static void _init_f_addTopLevelItem_2114 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addTopLevelItem_2114 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  qt_gsi::qt_keep (arg1);
  ((QTreeWidget *)cls)->addTopLevelItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_addTopLevelItem_2114 ()
{
  return new qt_gsi::GenericMethod ("addTopLevelItem", "@brief Method void QTreeWidget::addTopLevelItem(QTreeWidgetItem *item)\n", false, &_init_f_addTopLevelItem_2114, &_call_f_addTopLevelItem_2114);
}

// void QTreeWidget::addTopLevelItems(const QList<QTreeWidgetItem *> &items)


static void _init_f_addTopLevelItems_3606 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addTopLevelItems_3606 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type & > ();
  qt_gsi::qt_keep (arg1);
  ((QTreeWidget *)cls)->addTopLevelItems (qt_gsi::QtToCppAdaptor<QList<QTreeWidgetItem *> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_addTopLevelItems_3606 ()
{
  return new qt_gsi::GenericMethod ("addTopLevelItems", "@brief Method void QTreeWidget::addTopLevelItems(const QList<QTreeWidgetItem *> &items)\n", false, &_init_f_addTopLevelItems_3606, &_call_f_addTopLevelItems_3606);
}

// void QTreeWidget::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QTreeWidget::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// void QTreeWidget::closePersistentEditor(QTreeWidgetItem *item, int column)


static void _init_f_closePersistentEditor_2773 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_closePersistentEditor_2773 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  ((QTreeWidget *)cls)->closePersistentEditor (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_closePersistentEditor_2773 ()
{
  return new qt_gsi::GenericMethod ("closePersistentEditor", "@brief Method void QTreeWidget::closePersistentEditor(QTreeWidgetItem *item, int column)\n", false, &_init_f_closePersistentEditor_2773, &_call_f_closePersistentEditor_2773);
}

// void QTreeWidget::collapseItem(const QTreeWidgetItem *item)


static void _init_f_collapseItem_2809 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_collapseItem_2809 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  ((QTreeWidget *)cls)->collapseItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_collapseItem_2809 ()
{
  return new qt_gsi::GenericMethod ("collapseItem", "@brief Method void QTreeWidget::collapseItem(const QTreeWidgetItem *item)\n", false, &_init_f_collapseItem_2809, &_call_f_collapseItem_2809);
}

// int QTreeWidget::columnCount()


static void _init_f_columnCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_columnCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTreeWidget *)cls)->columnCount ());
}

static qt_gsi::GenericMethod *_create_f_columnCount_c0 ()
{
  return new qt_gsi::GenericMethod (":columnCount", "@brief Method int QTreeWidget::columnCount()\n", true, &_init_f_columnCount_c0, &_call_f_columnCount_c0);
}

// int QTreeWidget::currentColumn()


static void _init_f_currentColumn_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentColumn_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTreeWidget *)cls)->currentColumn ());
}

static qt_gsi::GenericMethod *_create_f_currentColumn_c0 ()
{
  return new qt_gsi::GenericMethod ("currentColumn", "@brief Method int QTreeWidget::currentColumn()\n", true, &_init_f_currentColumn_c0, &_call_f_currentColumn_c0);
}

// QTreeWidgetItem *QTreeWidget::currentItem()


static void _init_f_currentItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTreeWidgetItem * > ();
}

static void _call_f_currentItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTreeWidgetItem * > ((QTreeWidgetItem *)((QTreeWidget *)cls)->currentItem ());
}

static qt_gsi::GenericMethod *_create_f_currentItem_c0 ()
{
  return new qt_gsi::GenericMethod (":currentItem", "@brief Method QTreeWidgetItem *QTreeWidget::currentItem()\n", true, &_init_f_currentItem_c0, &_call_f_currentItem_c0);
}

// void QTreeWidget::editItem(QTreeWidgetItem *item, int column)


static void _init_f_editItem_2773 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_editItem_2773 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  ((QTreeWidget *)cls)->editItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_editItem_2773 ()
{
  return new qt_gsi::GenericMethod ("editItem", "@brief Method void QTreeWidget::editItem(QTreeWidgetItem *item, int column)\n", false, &_init_f_editItem_2773, &_call_f_editItem_2773);
}

// void QTreeWidget::expandItem(const QTreeWidgetItem *item)


static void _init_f_expandItem_2809 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_expandItem_2809 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  ((QTreeWidget *)cls)->expandItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_expandItem_2809 ()
{
  return new qt_gsi::GenericMethod ("expandItem", "@brief Method void QTreeWidget::expandItem(const QTreeWidgetItem *item)\n", false, &_init_f_expandItem_2809, &_call_f_expandItem_2809);
}

// QList<QTreeWidgetItem *> QTreeWidget::findItems(const QString &text, QFlags<Qt::MatchFlag> flags, int column)


static void _init_f_findItems_c4892 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("column", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type > ();
}

static void _call_f_findItems_c4892 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > ();
  int arg3 = args ? args.read<int > () : (int)(0);
  ret.write<qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type > ((qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QTreeWidgetItem *> >(((QTreeWidget *)cls)->findItems (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::MatchFlag> >(arg2).cref(), arg3)));
}

static qt_gsi::GenericMethod *_create_f_findItems_c4892 ()
{
  return new qt_gsi::GenericMethod ("findItems", "@brief Method QList<QTreeWidgetItem *> QTreeWidget::findItems(const QString &text, QFlags<Qt::MatchFlag> flags, int column)\n", true, &_init_f_findItems_c4892, &_call_f_findItems_c4892);
}

// QTreeWidgetItem *QTreeWidget::headerItem()


static void _init_f_headerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTreeWidgetItem * > ();
}

static void _call_f_headerItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTreeWidgetItem * > ((QTreeWidgetItem *)((QTreeWidget *)cls)->headerItem ());
}

static qt_gsi::GenericMethod *_create_f_headerItem_c0 ()
{
  return new qt_gsi::GenericMethod (":headerItem", "@brief Method QTreeWidgetItem *QTreeWidget::headerItem()\n", true, &_init_f_headerItem_c0, &_call_f_headerItem_c0);
}

// int QTreeWidget::indexOfTopLevelItem(QTreeWidgetItem *item)


static void _init_f_indexOfTopLevelItem_2114 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_indexOfTopLevelItem_2114 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  ret.write<int > ((int)((QTreeWidget *)cls)->indexOfTopLevelItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_indexOfTopLevelItem_2114 ()
{
  return new qt_gsi::GenericMethod ("indexOfTopLevelItem", "@brief Method int QTreeWidget::indexOfTopLevelItem(QTreeWidgetItem *item)\n", false, &_init_f_indexOfTopLevelItem_2114, &_call_f_indexOfTopLevelItem_2114);
}

// int QTreeWidget::indexOfTopLevelItem(QTreeWidgetItem *item)


static void _init_f_indexOfTopLevelItem_c2114 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_indexOfTopLevelItem_c2114 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  ret.write<int > ((int)((QTreeWidget *)cls)->indexOfTopLevelItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_indexOfTopLevelItem_c2114 ()
{
  return new qt_gsi::GenericMethod ("indexOfTopLevelItem", "@brief Method int QTreeWidget::indexOfTopLevelItem(QTreeWidgetItem *item)\n", true, &_init_f_indexOfTopLevelItem_c2114, &_call_f_indexOfTopLevelItem_c2114);
}

// void QTreeWidget::insertTopLevelItem(int index, QTreeWidgetItem *item)


static void _init_f_insertTopLevelItem_2773 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertTopLevelItem_2773 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QTreeWidgetItem *arg2 = args.read<QTreeWidgetItem * > ();
  qt_gsi::qt_keep (arg2);
  ((QTreeWidget *)cls)->insertTopLevelItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertTopLevelItem_2773 ()
{
  return new qt_gsi::GenericMethod ("insertTopLevelItem", "@brief Method void QTreeWidget::insertTopLevelItem(int index, QTreeWidgetItem *item)\n", false, &_init_f_insertTopLevelItem_2773, &_call_f_insertTopLevelItem_2773);
}

// void QTreeWidget::insertTopLevelItems(int index, const QList<QTreeWidgetItem *> &items)


static void _init_f_insertTopLevelItems_4265 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("items");
  decl->add_arg<const qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertTopLevelItems_4265 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type & arg2 = args.read<const qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type & > ();
  qt_gsi::qt_keep (arg2);
  ((QTreeWidget *)cls)->insertTopLevelItems (arg1, qt_gsi::QtToCppAdaptor<QList<QTreeWidgetItem *> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_insertTopLevelItems_4265 ()
{
  return new qt_gsi::GenericMethod ("insertTopLevelItems", "@brief Method void QTreeWidget::insertTopLevelItems(int index, const QList<QTreeWidgetItem *> &items)\n", false, &_init_f_insertTopLevelItems_4265, &_call_f_insertTopLevelItems_4265);
}

// QTreeWidgetItem *QTreeWidget::invisibleRootItem()


static void _init_f_invisibleRootItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTreeWidgetItem * > ();
}

static void _call_f_invisibleRootItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTreeWidgetItem * > ((QTreeWidgetItem *)((QTreeWidget *)cls)->invisibleRootItem ());
}

static qt_gsi::GenericMethod *_create_f_invisibleRootItem_c0 ()
{
  return new qt_gsi::GenericMethod ("invisibleRootItem", "@brief Method QTreeWidgetItem *QTreeWidget::invisibleRootItem()\n", true, &_init_f_invisibleRootItem_c0, &_call_f_invisibleRootItem_c0);
}

// bool QTreeWidget::isFirstItemColumnSpanned(const QTreeWidgetItem *item)


static void _init_f_isFirstItemColumnSpanned_c2809 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isFirstItemColumnSpanned_c2809 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  ret.write<bool > ((bool)((QTreeWidget *)cls)->isFirstItemColumnSpanned (arg1));
}

static qt_gsi::GenericMethod *_create_f_isFirstItemColumnSpanned_c2809 ()
{
  return new qt_gsi::GenericMethod ("isFirstItemColumnSpanned?", "@brief Method bool QTreeWidget::isFirstItemColumnSpanned(const QTreeWidgetItem *item)\n", true, &_init_f_isFirstItemColumnSpanned_c2809, &_call_f_isFirstItemColumnSpanned_c2809);
}

// bool QTreeWidget::isItemExpanded(const QTreeWidgetItem *item)


static void _init_f_isItemExpanded_c2809 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isItemExpanded_c2809 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  ret.write<bool > ((bool)((QTreeWidget *)cls)->isItemExpanded (arg1));
}

static qt_gsi::GenericMethod *_create_f_isItemExpanded_c2809 ()
{
  return new qt_gsi::GenericMethod ("isItemExpanded?", "@brief Method bool QTreeWidget::isItemExpanded(const QTreeWidgetItem *item)\n", true, &_init_f_isItemExpanded_c2809, &_call_f_isItemExpanded_c2809);
}

// bool QTreeWidget::isItemHidden(const QTreeWidgetItem *item)


static void _init_f_isItemHidden_c2809 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isItemHidden_c2809 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  ret.write<bool > ((bool)((QTreeWidget *)cls)->isItemHidden (arg1));
}

static qt_gsi::GenericMethod *_create_f_isItemHidden_c2809 ()
{
  return new qt_gsi::GenericMethod ("isItemHidden?", "@brief Method bool QTreeWidget::isItemHidden(const QTreeWidgetItem *item)\n", true, &_init_f_isItemHidden_c2809, &_call_f_isItemHidden_c2809);
}

// bool QTreeWidget::isItemSelected(const QTreeWidgetItem *item)


static void _init_f_isItemSelected_c2809 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isItemSelected_c2809 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  ret.write<bool > ((bool)((QTreeWidget *)cls)->isItemSelected (arg1));
}

static qt_gsi::GenericMethod *_create_f_isItemSelected_c2809 ()
{
  return new qt_gsi::GenericMethod ("isItemSelected?", "@brief Method bool QTreeWidget::isItemSelected(const QTreeWidgetItem *item)\n", true, &_init_f_isItemSelected_c2809, &_call_f_isItemSelected_c2809);
}

// bool QTreeWidget::isSortingEnabled()


static void _init_f_isSortingEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSortingEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTreeWidget *)cls)->isSortingEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isSortingEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isSortingEnabled?|:sortingEnabled", "@brief Method bool QTreeWidget::isSortingEnabled()\n", true, &_init_f_isSortingEnabled_c0, &_call_f_isSortingEnabled_c0);
}

// QTreeWidgetItem *QTreeWidget::itemAbove(const QTreeWidgetItem *item)


static void _init_f_itemAbove_c2809 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  decl->set_return<QTreeWidgetItem * > ();
}

static void _call_f_itemAbove_c2809 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  ret.write<QTreeWidgetItem * > ((QTreeWidgetItem *)((QTreeWidget *)cls)->itemAbove (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemAbove_c2809 ()
{
  return new qt_gsi::GenericMethod ("itemAbove", "@brief Method QTreeWidgetItem *QTreeWidget::itemAbove(const QTreeWidgetItem *item)\n", true, &_init_f_itemAbove_c2809, &_call_f_itemAbove_c2809);
}

// QTreeWidgetItem *QTreeWidget::itemAt(const QPoint &p)


static void _init_f_itemAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QTreeWidgetItem * > ();
}

static void _call_f_itemAt_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QTreeWidgetItem * > ((QTreeWidgetItem *)((QTreeWidget *)cls)->itemAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c1916 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QTreeWidgetItem *QTreeWidget::itemAt(const QPoint &p)\n", true, &_init_f_itemAt_c1916, &_call_f_itemAt_c1916);
}

// QTreeWidgetItem *QTreeWidget::itemAt(int x, int y)


static void _init_f_itemAt_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QTreeWidgetItem * > ();
}

static void _call_f_itemAt_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QTreeWidgetItem * > ((QTreeWidgetItem *)((QTreeWidget *)cls)->itemAt (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c1426 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QTreeWidgetItem *QTreeWidget::itemAt(int x, int y)\n", true, &_init_f_itemAt_c1426, &_call_f_itemAt_c1426);
}

// QTreeWidgetItem *QTreeWidget::itemBelow(const QTreeWidgetItem *item)


static void _init_f_itemBelow_c2809 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  decl->set_return<QTreeWidgetItem * > ();
}

static void _call_f_itemBelow_c2809 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  ret.write<QTreeWidgetItem * > ((QTreeWidgetItem *)((QTreeWidget *)cls)->itemBelow (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemBelow_c2809 ()
{
  return new qt_gsi::GenericMethod ("itemBelow", "@brief Method QTreeWidgetItem *QTreeWidget::itemBelow(const QTreeWidgetItem *item)\n", true, &_init_f_itemBelow_c2809, &_call_f_itemBelow_c2809);
}

// QWidget *QTreeWidget::itemWidget(QTreeWidgetItem *item, int column)


static void _init_f_itemWidget_c2773 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QWidget * > ();
}

static void _call_f_itemWidget_c2773 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  int arg2 = args.read<int > ();
  ret.write<QWidget * > ((QWidget *)((QTreeWidget *)cls)->itemWidget (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_itemWidget_c2773 ()
{
  return new qt_gsi::GenericMethod ("itemWidget", "@brief Method QWidget *QTreeWidget::itemWidget(QTreeWidgetItem *item, int column)\n", true, &_init_f_itemWidget_c2773, &_call_f_itemWidget_c2773);
}

// void QTreeWidget::openPersistentEditor(QTreeWidgetItem *item, int column)


static void _init_f_openPersistentEditor_2773 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_openPersistentEditor_2773 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  ((QTreeWidget *)cls)->openPersistentEditor (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_openPersistentEditor_2773 ()
{
  return new qt_gsi::GenericMethod ("openPersistentEditor", "@brief Method void QTreeWidget::openPersistentEditor(QTreeWidgetItem *item, int column)\n", false, &_init_f_openPersistentEditor_2773, &_call_f_openPersistentEditor_2773);
}

// void QTreeWidget::removeItemWidget(QTreeWidgetItem *item, int column)


static void _init_f_removeItemWidget_2773 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_removeItemWidget_2773 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  int arg2 = args.read<int > ();
  ((QTreeWidget *)cls)->removeItemWidget (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_removeItemWidget_2773 ()
{
  return new qt_gsi::GenericMethod ("removeItemWidget", "@brief Method void QTreeWidget::removeItemWidget(QTreeWidgetItem *item, int column)\n", false, &_init_f_removeItemWidget_2773, &_call_f_removeItemWidget_2773);
}

// void QTreeWidget::scrollToItem(const QTreeWidgetItem *item, QAbstractItemView::ScrollHint hint)


static void _init_f_scrollToItem_5990 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemView::EnsureVisible");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scrollToItem_5990 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > () : (const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type &)(qt_gsi::CppToQtReadAdaptor<QAbstractItemView::ScrollHint>(heap, QAbstractItemView::EnsureVisible));
  ((QTreeWidget *)cls)->scrollToItem (arg1, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_scrollToItem_5990 ()
{
  return new qt_gsi::GenericMethod ("scrollToItem", "@brief Method void QTreeWidget::scrollToItem(const QTreeWidgetItem *item, QAbstractItemView::ScrollHint hint)\n", false, &_init_f_scrollToItem_5990, &_call_f_scrollToItem_5990);
}

// QList<QTreeWidgetItem *> QTreeWidget::selectedItems()


static void _init_f_selectedItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type > ();
}

static void _call_f_selectedItems_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type > ((qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QTreeWidgetItem *> >(((QTreeWidget *)cls)->selectedItems ()));
}

static qt_gsi::GenericMethod *_create_f_selectedItems_c0 ()
{
  return new qt_gsi::GenericMethod ("selectedItems", "@brief Method QList<QTreeWidgetItem *> QTreeWidget::selectedItems()\n", true, &_init_f_selectedItems_c0, &_call_f_selectedItems_c0);
}

// void QTreeWidget::setColumnCount(int columns)


static void _init_f_setColumnCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("columns");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColumnCount_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTreeWidget *)cls)->setColumnCount (arg1);
}

static qt_gsi::GenericMethod *_create_f_setColumnCount_767 ()
{
  return new qt_gsi::GenericMethod ("setColumnCount|columnCount=", "@brief Method void QTreeWidget::setColumnCount(int columns)\n", false, &_init_f_setColumnCount_767, &_call_f_setColumnCount_767);
}

// void QTreeWidget::setCurrentItem(QTreeWidgetItem *item)


static void _init_f_setCurrentItem_2114 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentItem_2114 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  ((QTreeWidget *)cls)->setCurrentItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCurrentItem_2114 ()
{
  return new qt_gsi::GenericMethod ("setCurrentItem|currentItem=", "@brief Method void QTreeWidget::setCurrentItem(QTreeWidgetItem *item)\n", false, &_init_f_setCurrentItem_2114, &_call_f_setCurrentItem_2114);
}

// void QTreeWidget::setCurrentItem(QTreeWidgetItem *item, int column)


static void _init_f_setCurrentItem_2773 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCurrentItem_2773 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  int arg2 = args.read<int > ();
  ((QTreeWidget *)cls)->setCurrentItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setCurrentItem_2773 ()
{
  return new qt_gsi::GenericMethod ("setCurrentItem", "@brief Method void QTreeWidget::setCurrentItem(QTreeWidgetItem *item, int column)\n", false, &_init_f_setCurrentItem_2773, &_call_f_setCurrentItem_2773);
}

// void QTreeWidget::setCurrentItem(QTreeWidgetItem *item, int column, QFlags<QItemSelectionModel::SelectionFlag> command)


static void _init_f_setCurrentItem_7136 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("command");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setCurrentItem_7136 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  int arg2 = args.read<int > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg3 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QTreeWidget *)cls)->setCurrentItem (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_setCurrentItem_7136 ()
{
  return new qt_gsi::GenericMethod ("setCurrentItem", "@brief Method void QTreeWidget::setCurrentItem(QTreeWidgetItem *item, int column, QFlags<QItemSelectionModel::SelectionFlag> command)\n", false, &_init_f_setCurrentItem_7136, &_call_f_setCurrentItem_7136);
}

// void QTreeWidget::setFirstItemColumnSpanned(const QTreeWidgetItem *item, bool span)


static void _init_f_setFirstItemColumnSpanned_3565 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("span");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFirstItemColumnSpanned_3565 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  bool arg2 = args.read<bool > ();
  ((QTreeWidget *)cls)->setFirstItemColumnSpanned (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setFirstItemColumnSpanned_3565 ()
{
  return new qt_gsi::GenericMethod ("setFirstItemColumnSpanned", "@brief Method void QTreeWidget::setFirstItemColumnSpanned(const QTreeWidgetItem *item, bool span)\n", false, &_init_f_setFirstItemColumnSpanned_3565, &_call_f_setFirstItemColumnSpanned_3565);
}

// void QTreeWidget::setHeaderItem(QTreeWidgetItem *item)


static void _init_f_setHeaderItem_2114 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeaderItem_2114 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  ((QTreeWidget *)cls)->setHeaderItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHeaderItem_2114 ()
{
  return new qt_gsi::GenericMethod ("setHeaderItem|headerItem=", "@brief Method void QTreeWidget::setHeaderItem(QTreeWidgetItem *item)\n", false, &_init_f_setHeaderItem_2114, &_call_f_setHeaderItem_2114);
}

// void QTreeWidget::setHeaderLabel(const QString &label)


static void _init_f_setHeaderLabel_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeaderLabel_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QTreeWidget *)cls)->setHeaderLabel (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHeaderLabel_2025 ()
{
  return new qt_gsi::GenericMethod ("setHeaderLabel", "@brief Method void QTreeWidget::setHeaderLabel(const QString &label)\n", false, &_init_f_setHeaderLabel_2025, &_call_f_setHeaderLabel_2025);
}

// void QTreeWidget::setHeaderLabels(const QStringList &labels)


static void _init_f_setHeaderLabels_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("labels");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeaderLabels_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QTreeWidget *)cls)->setHeaderLabels (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setHeaderLabels_2437 ()
{
  return new qt_gsi::GenericMethod ("setHeaderLabels", "@brief Method void QTreeWidget::setHeaderLabels(const QStringList &labels)\n", false, &_init_f_setHeaderLabels_2437, &_call_f_setHeaderLabels_2437);
}

// void QTreeWidget::setItemExpanded(const QTreeWidgetItem *item, bool expand)


static void _init_f_setItemExpanded_3565 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("expand");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemExpanded_3565 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  bool arg2 = args.read<bool > ();
  ((QTreeWidget *)cls)->setItemExpanded (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setItemExpanded_3565 ()
{
  return new qt_gsi::GenericMethod ("setItemExpanded", "@brief Method void QTreeWidget::setItemExpanded(const QTreeWidgetItem *item, bool expand)\n", false, &_init_f_setItemExpanded_3565, &_call_f_setItemExpanded_3565);
}

// void QTreeWidget::setItemHidden(const QTreeWidgetItem *item, bool hide)


static void _init_f_setItemHidden_3565 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hide");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemHidden_3565 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  bool arg2 = args.read<bool > ();
  ((QTreeWidget *)cls)->setItemHidden (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setItemHidden_3565 ()
{
  return new qt_gsi::GenericMethod ("setItemHidden", "@brief Method void QTreeWidget::setItemHidden(const QTreeWidgetItem *item, bool hide)\n", false, &_init_f_setItemHidden_3565, &_call_f_setItemHidden_3565);
}

// void QTreeWidget::setItemSelected(const QTreeWidgetItem *item, bool select)


static void _init_f_setItemSelected_3565 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("select");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemSelected_3565 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  bool arg2 = args.read<bool > ();
  ((QTreeWidget *)cls)->setItemSelected (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setItemSelected_3565 ()
{
  return new qt_gsi::GenericMethod ("setItemSelected", "@brief Method void QTreeWidget::setItemSelected(const QTreeWidgetItem *item, bool select)\n", false, &_init_f_setItemSelected_3565, &_call_f_setItemSelected_3565);
}

// void QTreeWidget::setItemWidget(QTreeWidgetItem *item, int column, QWidget *widget)


static void _init_f_setItemWidget_3980 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setItemWidget_3980 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  int arg2 = args.read<int > ();
  QWidget *arg3 = args.read<QWidget * > ();
  ((QTreeWidget *)cls)->setItemWidget (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setItemWidget_3980 ()
{
  return new qt_gsi::GenericMethod ("setItemWidget", "@brief Method void QTreeWidget::setItemWidget(QTreeWidgetItem *item, int column, QWidget *widget)\n", false, &_init_f_setItemWidget_3980, &_call_f_setItemWidget_3980);
}

// void QTreeWidget::setSelectionModel(QItemSelectionModel *selectionModel)


static void _init_f_setSelectionModel_2533 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionModel");
  decl->add_arg<QItemSelectionModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelectionModel_2533 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QItemSelectionModel *arg1 = args.read<QItemSelectionModel * > ();
  ((QTreeWidget *)cls)->setSelectionModel (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSelectionModel_2533 ()
{
  return new qt_gsi::GenericMethod ("setSelectionModel|selectionModel=", "@brief Method void QTreeWidget::setSelectionModel(QItemSelectionModel *selectionModel)\nThis is a reimplementation of QTreeView::setSelectionModel", false, &_init_f_setSelectionModel_2533, &_call_f_setSelectionModel_2533);
}

// void QTreeWidget::setSortingEnabled(bool enable)


static void _init_f_setSortingEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSortingEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTreeWidget *)cls)->setSortingEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSortingEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setSortingEnabled|sortingEnabled=", "@brief Method void QTreeWidget::setSortingEnabled(bool enable)\n", false, &_init_f_setSortingEnabled_864, &_call_f_setSortingEnabled_864);
}

// int QTreeWidget::sortColumn()


static void _init_f_sortColumn_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_sortColumn_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTreeWidget *)cls)->sortColumn ());
}

static qt_gsi::GenericMethod *_create_f_sortColumn_c0 ()
{
  return new qt_gsi::GenericMethod ("sortColumn", "@brief Method int QTreeWidget::sortColumn()\n", true, &_init_f_sortColumn_c0, &_call_f_sortColumn_c0);
}

// void QTreeWidget::sortItems(int column, Qt::SortOrder order)


static void _init_f_sortItems_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sortItems_2340 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  ((QTreeWidget *)cls)->sortItems (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_sortItems_2340 ()
{
  return new qt_gsi::GenericMethod ("sortItems", "@brief Method void QTreeWidget::sortItems(int column, Qt::SortOrder order)\n", false, &_init_f_sortItems_2340, &_call_f_sortItems_2340);
}

// QTreeWidgetItem *QTreeWidget::takeTopLevelItem(int index)


static void _init_f_takeTopLevelItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QTreeWidgetItem * > ();
}

static void _call_f_takeTopLevelItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTreeWidgetItem * > ((QTreeWidgetItem *)((QTreeWidget *)cls)->takeTopLevelItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_takeTopLevelItem_767 ()
{
  return new qt_gsi::GenericMethod ("takeTopLevelItem", "@brief Method QTreeWidgetItem *QTreeWidget::takeTopLevelItem(int index)\n", false, &_init_f_takeTopLevelItem_767, &_call_f_takeTopLevelItem_767);
}

// QTreeWidgetItem *QTreeWidget::topLevelItem(int index)


static void _init_f_topLevelItem_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTreeWidgetItem * > ();
}

static void _call_f_topLevelItem_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTreeWidgetItem * > ((QTreeWidgetItem *)((QTreeWidget *)cls)->topLevelItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_topLevelItem_c767 ()
{
  return new qt_gsi::GenericMethod ("topLevelItem", "@brief Method QTreeWidgetItem *QTreeWidget::topLevelItem(int index)\n", true, &_init_f_topLevelItem_c767, &_call_f_topLevelItem_c767);
}

// int QTreeWidget::topLevelItemCount()


static void _init_f_topLevelItemCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_topLevelItemCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTreeWidget *)cls)->topLevelItemCount ());
}

static qt_gsi::GenericMethod *_create_f_topLevelItemCount_c0 ()
{
  return new qt_gsi::GenericMethod (":topLevelItemCount", "@brief Method int QTreeWidget::topLevelItemCount()\n", true, &_init_f_topLevelItemCount_c0, &_call_f_topLevelItemCount_c0);
}

// QRect QTreeWidget::visualItemRect(const QTreeWidgetItem *item)


static void _init_f_visualItemRect_c2809 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QTreeWidgetItem * > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_visualItemRect_c2809 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTreeWidgetItem *arg1 = args.read<const QTreeWidgetItem * > ();
  ret.write<QRect > ((QRect)((QTreeWidget *)cls)->visualItemRect (arg1));
}

static qt_gsi::GenericMethod *_create_f_visualItemRect_c2809 ()
{
  return new qt_gsi::GenericMethod ("visualItemRect", "@brief Method QRect QTreeWidget::visualItemRect(const QTreeWidgetItem *item)\n", true, &_init_f_visualItemRect_c2809, &_call_f_visualItemRect_c2809);
}

// static QString QTreeWidget::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTreeWidget::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTreeWidget::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QTreeWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTreeWidget::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTreeWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QTreeWidget::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTreeWidget::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTreeWidget::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QTreeWidget::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTreeWidget::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTreeWidget::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QTreeWidget, QTreeWidget_EventAdaptor> ea_QTreeWidget;

namespace gsi
{
extern gsi::Class<QTreeView> decl_QTreeView;

gsi::Class<QTreeWidget> decl_QTreeWidget (ea_QTreeWidget, decl_QTreeView, "QTreeWidget_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_addTopLevelItem_2114 ()) +
  gsi::Methods(_create_f_addTopLevelItems_3606 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_closePersistentEditor_2773 ()) +
  gsi::Methods(_create_f_collapseItem_2809 ()) +
  gsi::Methods(_create_f_columnCount_c0 ()) +
  gsi::Methods(_create_f_currentColumn_c0 ()) +
  gsi::Methods(_create_f_currentItem_c0 ()) +
  gsi::Methods(_create_f_editItem_2773 ()) +
  gsi::Methods(_create_f_expandItem_2809 ()) +
  gsi::Methods(_create_f_findItems_c4892 ()) +
  gsi::Methods(_create_f_headerItem_c0 ()) +
  gsi::Methods(_create_f_indexOfTopLevelItem_2114 ()) +
  gsi::Methods(_create_f_indexOfTopLevelItem_c2114 ()) +
  gsi::Methods(_create_f_insertTopLevelItem_2773 ()) +
  gsi::Methods(_create_f_insertTopLevelItems_4265 ()) +
  gsi::Methods(_create_f_invisibleRootItem_c0 ()) +
  gsi::Methods(_create_f_isFirstItemColumnSpanned_c2809 ()) +
  gsi::Methods(_create_f_isItemExpanded_c2809 ()) +
  gsi::Methods(_create_f_isItemHidden_c2809 ()) +
  gsi::Methods(_create_f_isItemSelected_c2809 ()) +
  gsi::Methods(_create_f_isSortingEnabled_c0 ()) +
  gsi::Methods(_create_f_itemAbove_c2809 ()) +
  gsi::Methods(_create_f_itemAt_c1916 ()) +
  gsi::Methods(_create_f_itemAt_c1426 ()) +
  gsi::Methods(_create_f_itemBelow_c2809 ()) +
  gsi::Methods(_create_f_itemWidget_c2773 ()) +
  gsi::Methods(_create_f_openPersistentEditor_2773 ()) +
  gsi::Methods(_create_f_removeItemWidget_2773 ()) +
  gsi::Methods(_create_f_scrollToItem_5990 ()) +
  gsi::Methods(_create_f_selectedItems_c0 ()) +
  gsi::Methods(_create_f_setColumnCount_767 ()) +
  gsi::Methods(_create_f_setCurrentItem_2114 ()) +
  gsi::Methods(_create_f_setCurrentItem_2773 ()) +
  gsi::Methods(_create_f_setCurrentItem_7136 ()) +
  gsi::Methods(_create_f_setFirstItemColumnSpanned_3565 ()) +
  gsi::Methods(_create_f_setHeaderItem_2114 ()) +
  gsi::Methods(_create_f_setHeaderLabel_2025 ()) +
  gsi::Methods(_create_f_setHeaderLabels_2437 ()) +
  gsi::Methods(_create_f_setItemExpanded_3565 ()) +
  gsi::Methods(_create_f_setItemHidden_3565 ()) +
  gsi::Methods(_create_f_setItemSelected_3565 ()) +
  gsi::Methods(_create_f_setItemWidget_3980 ()) +
  gsi::Methods(_create_f_setSelectionModel_2533 ()) +
  gsi::Methods(_create_f_setSortingEnabled_864 ()) +
  gsi::Methods(_create_f_sortColumn_c0 ()) +
  gsi::Methods(_create_f_sortItems_2340 ()) +
  gsi::Methods(_create_f_takeTopLevelItem_767 ()) +
  gsi::Methods(_create_f_topLevelItem_c767 ()) +
  gsi::Methods(_create_f_topLevelItemCount_c0 ()) +
  gsi::Methods(_create_f_visualItemRect_c2809 ()) +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, const QModelIndex &> ("activated", &QTreeWidget_EventAdaptor::activated_e_2395, gsi::arg("index"), "@brief Signal declaration for QTreeWidget::activated(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, const QModelIndex &> ("clicked", &QTreeWidget_EventAdaptor::clicked_e_2395, gsi::arg("index"), "@brief Signal declaration for QTreeWidget::clicked(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, const QModelIndex &> ("collapsed", &QTreeWidget_EventAdaptor::collapsed_e_2395, gsi::arg("index"), "@brief Signal declaration for QTreeWidget::collapsed(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, QTreeWidgetItem *, QTreeWidgetItem *> ("currentItemChanged", &QTreeWidget_EventAdaptor::currentItemChanged_e_4120, gsi::arg("current"), gsi::arg("previous"), "@brief Signal declaration for QTreeWidget::currentItemChanged(QTreeWidgetItem *current, QTreeWidgetItem *previous)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QTreeWidget_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QTreeWidget::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, QObject *> ("destroyed", &QTreeWidget_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QTreeWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, const QModelIndex &> ("doubleClicked", &QTreeWidget_EventAdaptor::doubleClicked_e_2395, gsi::arg("index"), "@brief Signal declaration for QTreeWidget::doubleClicked(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, const QModelIndex &> ("entered", &QTreeWidget_EventAdaptor::entered_e_2395, gsi::arg("index"), "@brief Signal declaration for QTreeWidget::entered(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, const QModelIndex &> ("expanded", &QTreeWidget_EventAdaptor::expanded_e_2395, gsi::arg("index"), "@brief Signal declaration for QTreeWidget::expanded(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, QTreeWidgetItem *, int> ("itemActivated", &QTreeWidget_EventAdaptor::itemActivated_e_2773, gsi::arg("item"), gsi::arg("column"), "@brief Signal declaration for QTreeWidget::itemActivated(QTreeWidgetItem *item, int column)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, QTreeWidgetItem *, int> ("itemChanged", &QTreeWidget_EventAdaptor::itemChanged_e_2773, gsi::arg("item"), gsi::arg("column"), "@brief Signal declaration for QTreeWidget::itemChanged(QTreeWidgetItem *item, int column)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, QTreeWidgetItem *, int> ("itemClicked", &QTreeWidget_EventAdaptor::itemClicked_e_2773, gsi::arg("item"), gsi::arg("column"), "@brief Signal declaration for QTreeWidget::itemClicked(QTreeWidgetItem *item, int column)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, QTreeWidgetItem *> ("itemCollapsed", &QTreeWidget_EventAdaptor::itemCollapsed_e_2114, gsi::arg("item"), "@brief Signal declaration for QTreeWidget::itemCollapsed(QTreeWidgetItem *item)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, QTreeWidgetItem *, int> ("itemDoubleClicked", &QTreeWidget_EventAdaptor::itemDoubleClicked_e_2773, gsi::arg("item"), gsi::arg("column"), "@brief Signal declaration for QTreeWidget::itemDoubleClicked(QTreeWidgetItem *item, int column)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, QTreeWidgetItem *, int> ("itemEntered", &QTreeWidget_EventAdaptor::itemEntered_e_2773, gsi::arg("item"), gsi::arg("column"), "@brief Signal declaration for QTreeWidget::itemEntered(QTreeWidgetItem *item, int column)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, QTreeWidgetItem *> ("itemExpanded", &QTreeWidget_EventAdaptor::itemExpanded_e_2114, gsi::arg("item"), "@brief Signal declaration for QTreeWidget::itemExpanded(QTreeWidgetItem *item)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, QTreeWidgetItem *, int> ("itemPressed", &QTreeWidget_EventAdaptor::itemPressed_e_2773, gsi::arg("item"), gsi::arg("column"), "@brief Signal declaration for QTreeWidget::itemPressed(QTreeWidgetItem *item, int column)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor> ("itemSelectionChanged", &QTreeWidget_EventAdaptor::itemSelectionChanged_e_0, "@brief Signal declaration for QTreeWidget::itemSelectionChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor, const QModelIndex &> ("pressed", &QTreeWidget_EventAdaptor::pressed_e_2395, gsi::arg("index"), "@brief Signal declaration for QTreeWidget::pressed(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTreeWidget, QTreeWidget_EventAdaptor> ("viewportEntered", &QTreeWidget_EventAdaptor::viewportEntered_e_0, "@brief Signal declaration for QTreeWidget::viewportEntered()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QTreeWidget");
}


class QTreeWidget_Adaptor : public QTreeWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTreeWidget_Adaptor();

  //  [adaptor ctor] QTreeWidget::QTreeWidget(QWidget *parent)
  QTreeWidget_Adaptor() : QTreeWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTreeWidget::QTreeWidget(QWidget *parent)
  QTreeWidget_Adaptor(QWidget *parent) : QTreeWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QTreeWidget::columnCountChanged(int oldCount, int newCount)
  void fp_QTreeWidget_columnCountChanged_1426 (int oldCount, int newCount) {
    QTreeWidget::columnCountChanged(oldCount, newCount);
  }

  //  void QTreeWidget::columnMoved()
  void fp_QTreeWidget_columnMoved_0 () {
    QTreeWidget::columnMoved();
  }

  //  void QTreeWidget::columnResized(int column, int oldSize, int newSize)
  void fp_QTreeWidget_columnResized_2085 (int column, int oldSize, int newSize) {
    QTreeWidget::columnResized(column, oldSize, newSize);
  }

  //  void QTreeWidget::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QTreeWidget_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QTreeWidget::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QTreeWidget::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QTreeWidget_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QTreeWidget::destroy(destroyWindow, destroySubWindows);
  }

  //  QPoint QTreeWidget::dirtyRegionOffset()
  QPoint fp_QTreeWidget_dirtyRegionOffset_c0 () const {
    return QTreeWidget::dirtyRegionOffset();
  }

  //  void QTreeWidget::doAutoScroll()
  void fp_QTreeWidget_doAutoScroll_0 () {
    QTreeWidget::doAutoScroll();
  }

  //  void QTreeWidget::drawFrame(QPainter *)
  void fp_QTreeWidget_drawFrame_1426 (QPainter *arg1) {
    QTreeWidget::drawFrame(arg1);
  }

  //  void QTreeWidget::drawTree(QPainter *painter, const QRegion &region)
  void fp_QTreeWidget_drawTree_c3324 (QPainter *painter, const QRegion &region) const {
    QTreeWidget::drawTree(painter, region);
  }

  //  QAbstractItemView::DropIndicatorPosition QTreeWidget::dropIndicatorPosition()
  unsigned int fp_QTreeWidget_dropIndicatorPosition_c0 () const {
    return (unsigned int)(QTreeWidget::dropIndicatorPosition());
  }

  //  void QTreeWidget::executeDelayedItemsLayout()
  void fp_QTreeWidget_executeDelayedItemsLayout_0 () {
    QTreeWidget::executeDelayedItemsLayout();
  }

  //  bool QTreeWidget::focusNextChild()
  bool fp_QTreeWidget_focusNextChild_0 () {
    return QTreeWidget::focusNextChild();
  }

  //  bool QTreeWidget::focusPreviousChild()
  bool fp_QTreeWidget_focusPreviousChild_0 () {
    return QTreeWidget::focusPreviousChild();
  }

  //  int QTreeWidget::horizontalStepsPerItem()
  int fp_QTreeWidget_horizontalStepsPerItem_c0 () const {
    return QTreeWidget::horizontalStepsPerItem();
  }

  //  QModelIndex QTreeWidget::indexFromItem(QTreeWidgetItem *item, int column)
  QModelIndex fp_QTreeWidget_indexFromItem_c2773 (QTreeWidgetItem *item, int column) const {
    return QTreeWidget::indexFromItem(item, column);
  }

  //  int QTreeWidget::indexRowSizeHint(const QModelIndex &index)
  int fp_QTreeWidget_indexRowSizeHint_c2395 (const QModelIndex &index) const {
    return QTreeWidget::indexRowSizeHint(index);
  }

  //  QTreeWidgetItem *QTreeWidget::itemFromIndex(const QModelIndex &index)
  QTreeWidgetItem * fp_QTreeWidget_itemFromIndex_c2395 (const QModelIndex &index) const {
    return QTreeWidget::itemFromIndex(index);
  }

  //  QList<QTreeWidgetItem *> QTreeWidget::items(const QMimeData *data)
  qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type fp_QTreeWidget_items_c2168 (const QMimeData *data) const {
    return qt_gsi::CppToQtAdaptor<QList<QTreeWidgetItem *> >(QTreeWidget::items(data));
  }

  //  int QTreeWidget::receivers(const char *signal)
  int fp_QTreeWidget_receivers_c1731 (const char *signal) const {
    return QTreeWidget::receivers(signal);
  }

  //  void QTreeWidget::reexpand()
  void fp_QTreeWidget_reexpand_0 () {
    QTreeWidget::reexpand();
  }

  //  void QTreeWidget::resetInputContext()
  void fp_QTreeWidget_resetInputContext_0 () {
    QTreeWidget::resetInputContext();
  }

  //  int QTreeWidget::rowHeight(const QModelIndex &index)
  int fp_QTreeWidget_rowHeight_c2395 (const QModelIndex &index) const {
    return QTreeWidget::rowHeight(index);
  }

  //  void QTreeWidget::rowsRemoved(const QModelIndex &parent, int first, int last)
  void fp_QTreeWidget_rowsRemoved_3713 (const QModelIndex &parent, int first, int last) {
    QTreeWidget::rowsRemoved(parent, first, last);
  }

  //  void QTreeWidget::scheduleDelayedItemsLayout()
  void fp_QTreeWidget_scheduleDelayedItemsLayout_0 () {
    QTreeWidget::scheduleDelayedItemsLayout();
  }

  //  void QTreeWidget::scrollDirtyRegion(int dx, int dy)
  void fp_QTreeWidget_scrollDirtyRegion_1426 (int dx, int dy) {
    QTreeWidget::scrollDirtyRegion(dx, dy);
  }

  //  QObject *QTreeWidget::sender()
  QObject * fp_QTreeWidget_sender_c0 () const {
    return QTreeWidget::sender();
  }

  //  void QTreeWidget::setDirtyRegion(const QRegion &region)
  void fp_QTreeWidget_setDirtyRegion_2006 (const QRegion &region) {
    QTreeWidget::setDirtyRegion(region);
  }

  //  void QTreeWidget::setHorizontalStepsPerItem(int steps)
  void fp_QTreeWidget_setHorizontalStepsPerItem_767 (int steps) {
    QTreeWidget::setHorizontalStepsPerItem(steps);
  }

  //  void QTreeWidget::setState(QAbstractItemView::State state)
  void fp_QTreeWidget_setState_2776 (unsigned int state) {
    QTreeWidget::setState(QAbstractItemView::State(state));
  }

  //  void QTreeWidget::setVerticalStepsPerItem(int steps)
  void fp_QTreeWidget_setVerticalStepsPerItem_767 (int steps) {
    QTreeWidget::setVerticalStepsPerItem(steps);
  }

  //  void QTreeWidget::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QTreeWidget_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QTreeWidget::setViewportMargins(left, top, right, bottom);
  }

  //  void QTreeWidget::setViewportMargins(const QMargins &margins)
  void fp_QTreeWidget_setViewportMargins_2115 (const QMargins &margins) {
    QTreeWidget::setViewportMargins(margins);
  }

  //  void QTreeWidget::setupViewport(QWidget *viewport)
  void fp_QTreeWidget_setupViewport_1315 (QWidget *viewport) {
    QTreeWidget::setupViewport(viewport);
  }

  //  void QTreeWidget::startAutoScroll()
  void fp_QTreeWidget_startAutoScroll_0 () {
    QTreeWidget::startAutoScroll();
  }

  //  QAbstractItemView::State QTreeWidget::state()
  unsigned int fp_QTreeWidget_state_c0 () const {
    return (unsigned int)(QTreeWidget::state());
  }

  //  void QTreeWidget::stopAutoScroll()
  void fp_QTreeWidget_stopAutoScroll_0 () {
    QTreeWidget::stopAutoScroll();
  }

  //  void QTreeWidget::updateMicroFocus()
  void fp_QTreeWidget_updateMicroFocus_0 () {
    QTreeWidget::updateMicroFocus();
  }

  //  int QTreeWidget::verticalStepsPerItem()
  int fp_QTreeWidget_verticalStepsPerItem_c0 () const {
    return QTreeWidget::verticalStepsPerItem();
  }

  //  [adaptor impl] void QTreeWidget::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  void cbs_dataChanged_4682_0(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    QTreeWidget::dataChanged(topLeft, bottomRight);
  }

  virtual void dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    if (cb_dataChanged_4682_0.can_issue()) {
      cb_dataChanged_4682_0.issue<QTreeWidget_Adaptor, const QModelIndex &, const QModelIndex &>(&QTreeWidget_Adaptor::cbs_dataChanged_4682_0, topLeft, bottomRight);
    } else {
      QTreeWidget::dataChanged(topLeft, bottomRight);
    }
  }

  //  [adaptor impl] void QTreeWidget::doItemsLayout()
  void cbs_doItemsLayout_0_0()
  {
    QTreeWidget::doItemsLayout();
  }

  virtual void doItemsLayout()
  {
    if (cb_doItemsLayout_0_0.can_issue()) {
      cb_doItemsLayout_0_0.issue<QTreeWidget_Adaptor>(&QTreeWidget_Adaptor::cbs_doItemsLayout_0_0);
    } else {
      QTreeWidget::doItemsLayout();
    }
  }

  //  [adaptor impl] bool QTreeWidget::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QTreeWidget::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTreeWidget_Adaptor, bool, QObject *, QEvent *>(&QTreeWidget_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QTreeWidget::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QTreeWidget::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QTreeWidget::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QTreeWidget_Adaptor, int, int>(&QTreeWidget_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QTreeWidget::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QModelIndex QTreeWidget::indexAt(const QPoint &p)
  QModelIndex cbs_indexAt_c1916_0(const QPoint &p) const
  {
    return QTreeWidget::indexAt(p);
  }

  virtual QModelIndex indexAt(const QPoint &p) const
  {
    if (cb_indexAt_c1916_0.can_issue()) {
      return cb_indexAt_c1916_0.issue<QTreeWidget_Adaptor, QModelIndex, const QPoint &>(&QTreeWidget_Adaptor::cbs_indexAt_c1916_0, p);
    } else {
      return QTreeWidget::indexAt(p);
    }
  }

  //  [adaptor impl] QVariant QTreeWidget::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QTreeWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QTreeWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QTreeWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QTreeWidget::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] void QTreeWidget::keyboardSearch(const QString &search)
  void cbs_keyboardSearch_2025_0(const QString &search)
  {
    QTreeWidget::keyboardSearch(search);
  }

  virtual void keyboardSearch(const QString &search)
  {
    if (cb_keyboardSearch_2025_0.can_issue()) {
      cb_keyboardSearch_2025_0.issue<QTreeWidget_Adaptor, const QString &>(&QTreeWidget_Adaptor::cbs_keyboardSearch_2025_0, search);
    } else {
      QTreeWidget::keyboardSearch(search);
    }
  }

  //  [adaptor impl] QSize QTreeWidget::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QTreeWidget::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QTreeWidget_Adaptor, QSize>(&QTreeWidget_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QTreeWidget::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QTreeWidget::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QTreeWidget::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QTreeWidget_Adaptor, QPaintEngine *>(&QTreeWidget_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QTreeWidget::paintEngine();
    }
  }

  //  [adaptor impl] void QTreeWidget::reset()
  void cbs_reset_0_0()
  {
    QTreeWidget::reset();
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QTreeWidget_Adaptor>(&QTreeWidget_Adaptor::cbs_reset_0_0);
    } else {
      QTreeWidget::reset();
    }
  }

  //  [adaptor impl] void QTreeWidget::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  void cbs_scrollTo_5576_1(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & hint)
  {
    QTreeWidget::scrollTo(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(hint).cref());
  }

  virtual void scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  {
    if (cb_scrollTo_5576_1.can_issue()) {
      cb_scrollTo_5576_1.issue<QTreeWidget_Adaptor, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type &>(&QTreeWidget_Adaptor::cbs_scrollTo_5576_1, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::ScrollHint>(hint));
    } else {
      QTreeWidget::scrollTo(index, hint);
    }
  }

  //  [adaptor impl] void QTreeWidget::selectAll()
  void cbs_selectAll_0_0()
  {
    QTreeWidget::selectAll();
  }

  virtual void selectAll()
  {
    if (cb_selectAll_0_0.can_issue()) {
      cb_selectAll_0_0.issue<QTreeWidget_Adaptor>(&QTreeWidget_Adaptor::cbs_selectAll_0_0);
    } else {
      QTreeWidget::selectAll();
    }
  }

  //  [adaptor impl] void QTreeWidget::setRootIndex(const QModelIndex &index)
  void cbs_setRootIndex_2395_0(const QModelIndex &index)
  {
    QTreeWidget::setRootIndex(index);
  }

  virtual void setRootIndex(const QModelIndex &index)
  {
    if (cb_setRootIndex_2395_0.can_issue()) {
      cb_setRootIndex_2395_0.issue<QTreeWidget_Adaptor, const QModelIndex &>(&QTreeWidget_Adaptor::cbs_setRootIndex_2395_0, index);
    } else {
      QTreeWidget::setRootIndex(index);
    }
  }

  //  [adaptor impl] void QTreeWidget::setSelectionModel(QItemSelectionModel *selectionModel)
  void cbs_setSelectionModel_2533_0(QItemSelectionModel *selectionModel)
  {
    QTreeWidget::setSelectionModel(selectionModel);
  }

  virtual void setSelectionModel(QItemSelectionModel *selectionModel)
  {
    if (cb_setSelectionModel_2533_0.can_issue()) {
      cb_setSelectionModel_2533_0.issue<QTreeWidget_Adaptor, QItemSelectionModel *>(&QTreeWidget_Adaptor::cbs_setSelectionModel_2533_0, selectionModel);
    } else {
      QTreeWidget::setSelectionModel(selectionModel);
    }
  }

  //  [adaptor impl] void QTreeWidget::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QTreeWidget::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QTreeWidget_Adaptor, bool>(&QTreeWidget_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QTreeWidget::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QTreeWidget::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QTreeWidget::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QTreeWidget_Adaptor, QSize>(&QTreeWidget_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QTreeWidget::sizeHint();
    }
  }

  //  [adaptor impl] int QTreeWidget::sizeHintForRow(int row)
  int cbs_sizeHintForRow_c767_0(int row) const
  {
    return QTreeWidget::sizeHintForRow(row);
  }

  virtual int sizeHintForRow(int row) const
  {
    if (cb_sizeHintForRow_c767_0.can_issue()) {
      return cb_sizeHintForRow_c767_0.issue<QTreeWidget_Adaptor, int, int>(&QTreeWidget_Adaptor::cbs_sizeHintForRow_c767_0, row);
    } else {
      return QTreeWidget::sizeHintForRow(row);
    }
  }

  //  [adaptor impl] QRect QTreeWidget::visualRect(const QModelIndex &index)
  QRect cbs_visualRect_c2395_0(const QModelIndex &index) const
  {
    return QTreeWidget::visualRect(index);
  }

  virtual QRect visualRect(const QModelIndex &index) const
  {
    if (cb_visualRect_c2395_0.can_issue()) {
      return cb_visualRect_c2395_0.issue<QTreeWidget_Adaptor, QRect, const QModelIndex &>(&QTreeWidget_Adaptor::cbs_visualRect_c2395_0, index);
    } else {
      return QTreeWidget::visualRect(index);
    }
  }

  //  [adaptor impl] void QTreeWidget::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QTreeWidget::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QTreeWidget_Adaptor, QActionEvent *>(&QTreeWidget_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QTreeWidget::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QTreeWidget::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QTreeWidget_Adaptor, QEvent *>(&QTreeWidget_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QTreeWidget::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QTreeWidget::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTreeWidget_Adaptor, QChildEvent *>(&QTreeWidget_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QTreeWidget::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  void cbs_closeEditor_4926_0(QWidget *editor, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & hint)
  {
    QTreeWidget::closeEditor(editor, qt_gsi::QtToCppAdaptor<QAbstractItemDelegate::EndEditHint>(hint).cref());
  }

  virtual void closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  {
    if (cb_closeEditor_4926_0.can_issue()) {
      cb_closeEditor_4926_0.issue<QTreeWidget_Adaptor, QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type &>(&QTreeWidget_Adaptor::cbs_closeEditor_4926_0, editor, qt_gsi::CppToQtAdaptor<QAbstractItemDelegate::EndEditHint>(hint));
    } else {
      QTreeWidget::closeEditor(editor, hint);
    }
  }

  //  [adaptor impl] void QTreeWidget::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QTreeWidget::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QTreeWidget_Adaptor, QCloseEvent *>(&QTreeWidget_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QTreeWidget::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::commitData(QWidget *editor)
  void cbs_commitData_1315_0(QWidget *editor)
  {
    QTreeWidget::commitData(editor);
  }

  virtual void commitData(QWidget *editor)
  {
    if (cb_commitData_1315_0.can_issue()) {
      cb_commitData_1315_0.issue<QTreeWidget_Adaptor, QWidget *>(&QTreeWidget_Adaptor::cbs_commitData_1315_0, editor);
    } else {
      QTreeWidget::commitData(editor);
    }
  }

  //  [adaptor impl] void QTreeWidget::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QTreeWidget::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QTreeWidget_Adaptor, QContextMenuEvent *>(&QTreeWidget_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QTreeWidget::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::currentChanged(const QModelIndex &current, const QModelIndex &previous)
  void cbs_currentChanged_4682_0(const QModelIndex &current, const QModelIndex &previous)
  {
    QTreeWidget::currentChanged(current, previous);
  }

  virtual void currentChanged(const QModelIndex &current, const QModelIndex &previous)
  {
    if (cb_currentChanged_4682_0.can_issue()) {
      cb_currentChanged_4682_0.issue<QTreeWidget_Adaptor, const QModelIndex &, const QModelIndex &>(&QTreeWidget_Adaptor::cbs_currentChanged_4682_0, current, previous);
    } else {
      QTreeWidget::currentChanged(current, previous);
    }
  }

  //  [adaptor impl] void QTreeWidget::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QTreeWidget::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTreeWidget_Adaptor, QEvent *>(&QTreeWidget_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QTreeWidget::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QTreeWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QTreeWidget_Adaptor, const char *>(&QTreeWidget_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QTreeWidget::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QTreeWidget::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QTreeWidget::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QTreeWidget_Adaptor, QDragEnterEvent *>(&QTreeWidget_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QTreeWidget::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QTreeWidget::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QTreeWidget::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QTreeWidget_Adaptor, QDragLeaveEvent *>(&QTreeWidget_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QTreeWidget::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QTreeWidget::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QTreeWidget::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QTreeWidget_Adaptor, QDragMoveEvent *>(&QTreeWidget_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QTreeWidget::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QTreeWidget::drawBranches(QPainter *painter, const QRect &rect, const QModelIndex &index)
  void cbs_drawBranches_c5397_0(QPainter *painter, const QRect &rect, const QModelIndex &index) const
  {
    QTreeWidget::drawBranches(painter, rect, index);
  }

  virtual void drawBranches(QPainter *painter, const QRect &rect, const QModelIndex &index) const
  {
    if (cb_drawBranches_c5397_0.can_issue()) {
      cb_drawBranches_c5397_0.issue<QTreeWidget_Adaptor, QPainter *, const QRect &, const QModelIndex &>(&QTreeWidget_Adaptor::cbs_drawBranches_c5397_0, painter, rect, index);
    } else {
      QTreeWidget::drawBranches(painter, rect, index);
    }
  }

  //  [adaptor impl] void QTreeWidget::drawRow(QPainter *painter, const QStyleOptionViewItem &options, const QModelIndex &index)
  void cbs_drawRow_c6971_0(QPainter *painter, const QStyleOptionViewItem &options, const QModelIndex &index) const
  {
    QTreeWidget::drawRow(painter, options, index);
  }

  virtual void drawRow(QPainter *painter, const QStyleOptionViewItem &options, const QModelIndex &index) const
  {
    if (cb_drawRow_c6971_0.can_issue()) {
      cb_drawRow_c6971_0.issue<QTreeWidget_Adaptor, QPainter *, const QStyleOptionViewItem &, const QModelIndex &>(&QTreeWidget_Adaptor::cbs_drawRow_c6971_0, painter, options, index);
    } else {
      QTreeWidget::drawRow(painter, options, index);
    }
  }

  //  [adaptor impl] void QTreeWidget::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QTreeWidget::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QTreeWidget_Adaptor, QDropEvent *>(&QTreeWidget_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QTreeWidget::dropEvent(event);
    }
  }

  //  [adaptor impl] bool QTreeWidget::dropMimeData(QTreeWidgetItem *parent, int index, const QMimeData *data, Qt::DropAction action)
  bool cbs_dropMimeData_6485_0(QTreeWidgetItem *parent, int index, const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action)
  {
    return QTreeWidget::dropMimeData(parent, index, data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref());
  }

  virtual bool dropMimeData(QTreeWidgetItem *parent, int index, const QMimeData *data, Qt::DropAction action)
  {
    if (cb_dropMimeData_6485_0.can_issue()) {
      return cb_dropMimeData_6485_0.issue<QTreeWidget_Adaptor, bool, QTreeWidgetItem *, int, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &>(&QTreeWidget_Adaptor::cbs_dropMimeData_6485_0, parent, index, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action));
    } else {
      return QTreeWidget::dropMimeData(parent, index, data, action);
    }
  }

  //  [adaptor impl] bool QTreeWidget::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  bool cbs_edit_6773_0(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & trigger, QEvent *event)
  {
    return QTreeWidget::edit(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::EditTrigger>(trigger).cref(), event);
  }

  virtual bool edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  {
    if (cb_edit_6773_0.can_issue()) {
      return cb_edit_6773_0.issue<QTreeWidget_Adaptor, bool, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type &, QEvent *>(&QTreeWidget_Adaptor::cbs_edit_6773_0, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::EditTrigger>(trigger), event);
    } else {
      return QTreeWidget::edit(index, trigger, event);
    }
  }

  //  [adaptor impl] void QTreeWidget::editorDestroyed(QObject *editor)
  void cbs_editorDestroyed_1302_0(QObject *editor)
  {
    QTreeWidget::editorDestroyed(editor);
  }

  virtual void editorDestroyed(QObject *editor)
  {
    if (cb_editorDestroyed_1302_0.can_issue()) {
      cb_editorDestroyed_1302_0.issue<QTreeWidget_Adaptor, QObject *>(&QTreeWidget_Adaptor::cbs_editorDestroyed_1302_0, editor);
    } else {
      QTreeWidget::editorDestroyed(editor);
    }
  }

  //  [adaptor impl] void QTreeWidget::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QTreeWidget::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QTreeWidget_Adaptor, bool>(&QTreeWidget_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QTreeWidget::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QTreeWidget::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QTreeWidget_Adaptor, QEvent *>(&QTreeWidget_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QTreeWidget::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QTreeWidget::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QTreeWidget::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTreeWidget_Adaptor, bool, QEvent *>(&QTreeWidget_Adaptor::cbs_event_1217_0, e);
    } else {
      return QTreeWidget::event(e);
    }
  }

  //  [adaptor impl] void QTreeWidget::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QTreeWidget::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QTreeWidget_Adaptor, QFocusEvent *>(&QTreeWidget_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QTreeWidget::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QTreeWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QTreeWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QTreeWidget_Adaptor, bool, bool>(&QTreeWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QTreeWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QTreeWidget::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QTreeWidget::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QTreeWidget_Adaptor, QFocusEvent *>(&QTreeWidget_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QTreeWidget::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QTreeWidget::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QTreeWidget::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QTreeWidget_Adaptor, const QFont &>(&QTreeWidget_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QTreeWidget::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QTreeWidget::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QTreeWidget_Adaptor, QHideEvent *>(&QTreeWidget_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QTreeWidget::hideEvent(arg1);
    }
  }

  //  [adaptor impl] int QTreeWidget::horizontalOffset()
  int cbs_horizontalOffset_c0_0() const
  {
    return QTreeWidget::horizontalOffset();
  }

  virtual int horizontalOffset() const
  {
    if (cb_horizontalOffset_c0_0.can_issue()) {
      return cb_horizontalOffset_c0_0.issue<QTreeWidget_Adaptor, int>(&QTreeWidget_Adaptor::cbs_horizontalOffset_c0_0);
    } else {
      return QTreeWidget::horizontalOffset();
    }
  }

  //  [adaptor impl] void QTreeWidget::horizontalScrollbarAction(int action)
  void cbs_horizontalScrollbarAction_767_0(int action)
  {
    QTreeWidget::horizontalScrollbarAction(action);
  }

  virtual void horizontalScrollbarAction(int action)
  {
    if (cb_horizontalScrollbarAction_767_0.can_issue()) {
      cb_horizontalScrollbarAction_767_0.issue<QTreeWidget_Adaptor, int>(&QTreeWidget_Adaptor::cbs_horizontalScrollbarAction_767_0, action);
    } else {
      QTreeWidget::horizontalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QTreeWidget::horizontalScrollbarValueChanged(int value)
  void cbs_horizontalScrollbarValueChanged_767_0(int value)
  {
    QTreeWidget::horizontalScrollbarValueChanged(value);
  }

  virtual void horizontalScrollbarValueChanged(int value)
  {
    if (cb_horizontalScrollbarValueChanged_767_0.can_issue()) {
      cb_horizontalScrollbarValueChanged_767_0.issue<QTreeWidget_Adaptor, int>(&QTreeWidget_Adaptor::cbs_horizontalScrollbarValueChanged_767_0, value);
    } else {
      QTreeWidget::horizontalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] void QTreeWidget::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QTreeWidget::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QTreeWidget_Adaptor, QInputMethodEvent *>(&QTreeWidget_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QTreeWidget::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] bool QTreeWidget::isIndexHidden(const QModelIndex &index)
  bool cbs_isIndexHidden_c2395_0(const QModelIndex &index) const
  {
    return QTreeWidget::isIndexHidden(index);
  }

  virtual bool isIndexHidden(const QModelIndex &index) const
  {
    if (cb_isIndexHidden_c2395_0.can_issue()) {
      return cb_isIndexHidden_c2395_0.issue<QTreeWidget_Adaptor, bool, const QModelIndex &>(&QTreeWidget_Adaptor::cbs_isIndexHidden_c2395_0, index);
    } else {
      return QTreeWidget::isIndexHidden(index);
    }
  }

  //  [adaptor impl] void QTreeWidget::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QTreeWidget::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QTreeWidget_Adaptor, QKeyEvent *>(&QTreeWidget_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QTreeWidget::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QTreeWidget::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QTreeWidget::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QTreeWidget_Adaptor, QKeyEvent *>(&QTreeWidget_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QTreeWidget::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::languageChange()
  void cbs_languageChange_0_0()
  {
    QTreeWidget::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QTreeWidget_Adaptor>(&QTreeWidget_Adaptor::cbs_languageChange_0_0);
    } else {
      QTreeWidget::languageChange();
    }
  }

  //  [adaptor impl] void QTreeWidget::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QTreeWidget::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QTreeWidget_Adaptor, QEvent *>(&QTreeWidget_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QTreeWidget::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QTreeWidget::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QTreeWidget::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QTreeWidget_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QTreeWidget_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QTreeWidget::metric(arg1);
    }
  }

  //  [adaptor impl] QMimeData *QTreeWidget::mimeData(const QList<QTreeWidgetItem *> items)
  QMimeData * cbs_mimeData_c3424_0(const qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type & items) const
  {
    return QTreeWidget::mimeData(qt_gsi::QtToCppAdaptor<QList<QTreeWidgetItem *> >(items).cref());
  }

  virtual QMimeData * mimeData(const QList<QTreeWidgetItem *> items) const
  {
    if (cb_mimeData_c3424_0.can_issue()) {
      return cb_mimeData_c3424_0.issue<QTreeWidget_Adaptor, QMimeData *, const qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type &>(&QTreeWidget_Adaptor::cbs_mimeData_c3424_0, qt_gsi::CppToQtAdaptor<QList<QTreeWidgetItem *> >(items));
    } else {
      return QTreeWidget::mimeData(items);
    }
  }

  //  [adaptor impl] QStringList QTreeWidget::mimeTypes()
  qt_gsi::Converter<QStringList>::target_type cbs_mimeTypes_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QStringList>(QTreeWidget::mimeTypes());
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStringList>(cb_mimeTypes_c0_0.issue<QTreeWidget_Adaptor, qt_gsi::Converter<QStringList>::target_type>(&QTreeWidget_Adaptor::cbs_mimeTypes_c0_0)).cref();
    } else {
      return QTreeWidget::mimeTypes();
    }
  }

  //  [adaptor impl] void QTreeWidget::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QTreeWidget::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QTreeWidget_Adaptor, QMouseEvent *>(&QTreeWidget_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QTreeWidget::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QTreeWidget::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QTreeWidget::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QTreeWidget_Adaptor, QMouseEvent *>(&QTreeWidget_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QTreeWidget::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QTreeWidget::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QTreeWidget::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QTreeWidget_Adaptor, QMouseEvent *>(&QTreeWidget_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QTreeWidget::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QTreeWidget::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QTreeWidget::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QTreeWidget_Adaptor, QMouseEvent *>(&QTreeWidget_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QTreeWidget::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] QModelIndex QTreeWidget::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  QModelIndex cbs_moveCursor_6476_0(unsigned int cursorAction, const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & modifiers)
  {
    return QTreeWidget::moveCursor(QAbstractItemView::CursorAction(cursorAction), qt_gsi::QtToCppAdaptor<QFlags<Qt::KeyboardModifier> >(modifiers).cref());
  }

  virtual QModelIndex moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  {
    if (cb_moveCursor_6476_0.can_issue()) {
      return cb_moveCursor_6476_0.issue<QTreeWidget_Adaptor, QModelIndex, unsigned int, const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type &>(&QTreeWidget_Adaptor::cbs_moveCursor_6476_0, (unsigned int)(cursorAction), qt_gsi::CppToQtAdaptor<QFlags<Qt::KeyboardModifier> >(modifiers));
    } else {
      return QTreeWidget::moveCursor(cursorAction, modifiers);
    }
  }

  //  [adaptor impl] void QTreeWidget::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QTreeWidget::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QTreeWidget_Adaptor, QMoveEvent *>(&QTreeWidget_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QTreeWidget::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QTreeWidget::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QTreeWidget_Adaptor, QPaintEvent *>(&QTreeWidget_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QTreeWidget::paintEvent(event);
    }
  }

  //  [adaptor impl] void QTreeWidget::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QTreeWidget::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QTreeWidget_Adaptor, const QPalette &>(&QTreeWidget_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QTreeWidget::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QTreeWidget::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QTreeWidget_Adaptor, QResizeEvent *>(&QTreeWidget_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QTreeWidget::resizeEvent(event);
    }
  }

  //  [adaptor impl] void QTreeWidget::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  void cbs_rowsAboutToBeRemoved_3713_0(const QModelIndex &parent, int start, int end)
  {
    QTreeWidget::rowsAboutToBeRemoved(parent, start, end);
  }

  virtual void rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsAboutToBeRemoved_3713_0.can_issue()) {
      cb_rowsAboutToBeRemoved_3713_0.issue<QTreeWidget_Adaptor, const QModelIndex &, int, int>(&QTreeWidget_Adaptor::cbs_rowsAboutToBeRemoved_3713_0, parent, start, end);
    } else {
      QTreeWidget::rowsAboutToBeRemoved(parent, start, end);
    }
  }

  //  [adaptor impl] void QTreeWidget::rowsInserted(const QModelIndex &parent, int start, int end)
  void cbs_rowsInserted_3713_0(const QModelIndex &parent, int start, int end)
  {
    QTreeWidget::rowsInserted(parent, start, end);
  }

  virtual void rowsInserted(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsInserted_3713_0.can_issue()) {
      cb_rowsInserted_3713_0.issue<QTreeWidget_Adaptor, const QModelIndex &, int, int>(&QTreeWidget_Adaptor::cbs_rowsInserted_3713_0, parent, start, end);
    } else {
      QTreeWidget::rowsInserted(parent, start, end);
    }
  }

  //  [adaptor impl] void QTreeWidget::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QTreeWidget::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QTreeWidget_Adaptor, int, int>(&QTreeWidget_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QTreeWidget::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QTreeWidget::selectedIndexes()
  qt_gsi::Converter<QList<QModelIndex> >::target_type cbs_selectedIndexes_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QTreeWidget::selectedIndexes());
  }

  virtual QList<QModelIndex> selectedIndexes() const
  {
    if (cb_selectedIndexes_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(cb_selectedIndexes_c0_0.issue<QTreeWidget_Adaptor, qt_gsi::Converter<QList<QModelIndex> >::target_type>(&QTreeWidget_Adaptor::cbs_selectedIndexes_c0_0)).cref();
    } else {
      return QTreeWidget::selectedIndexes();
    }
  }

  //  [adaptor impl] void QTreeWidget::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  void cbs_selectionChanged_5346_0(const QItemSelection &selected, const QItemSelection &deselected)
  {
    QTreeWidget::selectionChanged(selected, deselected);
  }

  virtual void selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  {
    if (cb_selectionChanged_5346_0.can_issue()) {
      cb_selectionChanged_5346_0.issue<QTreeWidget_Adaptor, const QItemSelection &, const QItemSelection &>(&QTreeWidget_Adaptor::cbs_selectionChanged_5346_0, selected, deselected);
    } else {
      QTreeWidget::selectionChanged(selected, deselected);
    }
  }

  //  [adaptor impl] QFlags<QItemSelectionModel::SelectionFlag> QTreeWidget::selectionCommand(const QModelIndex &index, const QEvent *event)
  qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type cbs_selectionCommand_c4199_1(const QModelIndex &index, const QEvent *event) const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(QTreeWidget::selectionCommand(index, event));
  }

  virtual QFlags<QItemSelectionModel::SelectionFlag> selectionCommand(const QModelIndex &index, const QEvent *event) const
  {
    if (cb_selectionCommand_c4199_1.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(cb_selectionCommand_c4199_1.issue<QTreeWidget_Adaptor, qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type, const QModelIndex &, const QEvent *>(&QTreeWidget_Adaptor::cbs_selectionCommand_c4199_1, index, event)).cref();
    } else {
      return QTreeWidget::selectionCommand(index, event);
    }
  }

  //  [adaptor impl] void QTreeWidget::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  void cbs_setSelection_6155_0(const QRect &rect, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & command)
  {
    QTreeWidget::setSelection(rect, qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(command).cref());
  }

  virtual void setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    if (cb_setSelection_6155_0.can_issue()) {
      cb_setSelection_6155_0.issue<QTreeWidget_Adaptor, const QRect &, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type &>(&QTreeWidget_Adaptor::cbs_setSelection_6155_0, rect, qt_gsi::CppToQtAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(command));
    } else {
      QTreeWidget::setSelection(rect, command);
    }
  }

  //  [adaptor impl] void QTreeWidget::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QTreeWidget::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QTreeWidget_Adaptor, QShowEvent *>(&QTreeWidget_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QTreeWidget::showEvent(arg1);
    }
  }

  //  [adaptor impl] int QTreeWidget::sizeHintForColumn(int column)
  int cbs_sizeHintForColumn_c767_0(int column) const
  {
    return QTreeWidget::sizeHintForColumn(column);
  }

  virtual int sizeHintForColumn(int column) const
  {
    if (cb_sizeHintForColumn_c767_0.can_issue()) {
      return cb_sizeHintForColumn_c767_0.issue<QTreeWidget_Adaptor, int, int>(&QTreeWidget_Adaptor::cbs_sizeHintForColumn_c767_0, column);
    } else {
      return QTreeWidget::sizeHintForColumn(column);
    }
  }

  //  [adaptor impl] void QTreeWidget::startDrag(QFlags<Qt::DropAction> supportedActions)
  void cbs_startDrag_2456_0(const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & supportedActions)
  {
    QTreeWidget::startDrag(qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(supportedActions).cref());
  }

  virtual void startDrag(QFlags<Qt::DropAction> supportedActions)
  {
    if (cb_startDrag_2456_0.can_issue()) {
      cb_startDrag_2456_0.issue<QTreeWidget_Adaptor, const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type &>(&QTreeWidget_Adaptor::cbs_startDrag_2456_0, qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(supportedActions));
    } else {
      QTreeWidget::startDrag(supportedActions);
    }
  }

  //  [adaptor impl] void QTreeWidget::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QTreeWidget::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QTreeWidget_Adaptor, QStyle &>(&QTreeWidget_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QTreeWidget::styleChange(arg1);
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QTreeWidget::supportedDropActions()
  qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type cbs_supportedDropActions_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(QTreeWidget::supportedDropActions());
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(cb_supportedDropActions_c0_0.issue<QTreeWidget_Adaptor, qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type>(&QTreeWidget_Adaptor::cbs_supportedDropActions_c0_0)).cref();
    } else {
      return QTreeWidget::supportedDropActions();
    }
  }

  //  [adaptor impl] void QTreeWidget::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QTreeWidget::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QTreeWidget_Adaptor, QTabletEvent *>(&QTreeWidget_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QTreeWidget::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QTreeWidget::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTreeWidget_Adaptor, QTimerEvent *>(&QTreeWidget_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QTreeWidget::timerEvent(event);
    }
  }

  //  [adaptor impl] void QTreeWidget::updateEditorData()
  void cbs_updateEditorData_0_0()
  {
    QTreeWidget::updateEditorData();
  }

  virtual void updateEditorData()
  {
    if (cb_updateEditorData_0_0.can_issue()) {
      cb_updateEditorData_0_0.issue<QTreeWidget_Adaptor>(&QTreeWidget_Adaptor::cbs_updateEditorData_0_0);
    } else {
      QTreeWidget::updateEditorData();
    }
  }

  //  [adaptor impl] void QTreeWidget::updateEditorGeometries()
  void cbs_updateEditorGeometries_0_0()
  {
    QTreeWidget::updateEditorGeometries();
  }

  virtual void updateEditorGeometries()
  {
    if (cb_updateEditorGeometries_0_0.can_issue()) {
      cb_updateEditorGeometries_0_0.issue<QTreeWidget_Adaptor>(&QTreeWidget_Adaptor::cbs_updateEditorGeometries_0_0);
    } else {
      QTreeWidget::updateEditorGeometries();
    }
  }

  //  [adaptor impl] void QTreeWidget::updateGeometries()
  void cbs_updateGeometries_0_0()
  {
    QTreeWidget::updateGeometries();
  }

  virtual void updateGeometries()
  {
    if (cb_updateGeometries_0_0.can_issue()) {
      cb_updateGeometries_0_0.issue<QTreeWidget_Adaptor>(&QTreeWidget_Adaptor::cbs_updateGeometries_0_0);
    } else {
      QTreeWidget::updateGeometries();
    }
  }

  //  [adaptor impl] int QTreeWidget::verticalOffset()
  int cbs_verticalOffset_c0_0() const
  {
    return QTreeWidget::verticalOffset();
  }

  virtual int verticalOffset() const
  {
    if (cb_verticalOffset_c0_0.can_issue()) {
      return cb_verticalOffset_c0_0.issue<QTreeWidget_Adaptor, int>(&QTreeWidget_Adaptor::cbs_verticalOffset_c0_0);
    } else {
      return QTreeWidget::verticalOffset();
    }
  }

  //  [adaptor impl] void QTreeWidget::verticalScrollbarAction(int action)
  void cbs_verticalScrollbarAction_767_0(int action)
  {
    QTreeWidget::verticalScrollbarAction(action);
  }

  virtual void verticalScrollbarAction(int action)
  {
    if (cb_verticalScrollbarAction_767_0.can_issue()) {
      cb_verticalScrollbarAction_767_0.issue<QTreeWidget_Adaptor, int>(&QTreeWidget_Adaptor::cbs_verticalScrollbarAction_767_0, action);
    } else {
      QTreeWidget::verticalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QTreeWidget::verticalScrollbarValueChanged(int value)
  void cbs_verticalScrollbarValueChanged_767_0(int value)
  {
    QTreeWidget::verticalScrollbarValueChanged(value);
  }

  virtual void verticalScrollbarValueChanged(int value)
  {
    if (cb_verticalScrollbarValueChanged_767_0.can_issue()) {
      cb_verticalScrollbarValueChanged_767_0.issue<QTreeWidget_Adaptor, int>(&QTreeWidget_Adaptor::cbs_verticalScrollbarValueChanged_767_0, value);
    } else {
      QTreeWidget::verticalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] QStyleOptionViewItem QTreeWidget::viewOptions()
  QStyleOptionViewItem cbs_viewOptions_c0_0() const
  {
    return QTreeWidget::viewOptions();
  }

  virtual QStyleOptionViewItem viewOptions() const
  {
    if (cb_viewOptions_c0_0.can_issue()) {
      return cb_viewOptions_c0_0.issue<QTreeWidget_Adaptor, QStyleOptionViewItem>(&QTreeWidget_Adaptor::cbs_viewOptions_c0_0);
    } else {
      return QTreeWidget::viewOptions();
    }
  }

  //  [adaptor impl] bool QTreeWidget::viewportEvent(QEvent *event)
  bool cbs_viewportEvent_1217_0(QEvent *event)
  {
    return QTreeWidget::viewportEvent(event);
  }

  virtual bool viewportEvent(QEvent *event)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QTreeWidget_Adaptor, bool, QEvent *>(&QTreeWidget_Adaptor::cbs_viewportEvent_1217_0, event);
    } else {
      return QTreeWidget::viewportEvent(event);
    }
  }

  //  [adaptor impl] QRegion QTreeWidget::visualRegionForSelection(const QItemSelection &selection)
  QRegion cbs_visualRegionForSelection_c2727_0(const QItemSelection &selection) const
  {
    return QTreeWidget::visualRegionForSelection(selection);
  }

  virtual QRegion visualRegionForSelection(const QItemSelection &selection) const
  {
    if (cb_visualRegionForSelection_c2727_0.can_issue()) {
      return cb_visualRegionForSelection_c2727_0.issue<QTreeWidget_Adaptor, QRegion, const QItemSelection &>(&QTreeWidget_Adaptor::cbs_visualRegionForSelection_c2727_0, selection);
    } else {
      return QTreeWidget::visualRegionForSelection(selection);
    }
  }

  //  [adaptor impl] void QTreeWidget::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QTreeWidget::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QTreeWidget_Adaptor, QWheelEvent *>(&QTreeWidget_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QTreeWidget::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QTreeWidget::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QTreeWidget::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QTreeWidget_Adaptor, bool>(&QTreeWidget_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QTreeWidget::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_dataChanged_4682_0;
  gsi::Callback cb_doItemsLayout_0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexAt_c1916_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_keyboardSearch_2025_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_scrollTo_5576_1;
  gsi::Callback cb_selectAll_0_0;
  gsi::Callback cb_setRootIndex_2395_0;
  gsi::Callback cb_setSelectionModel_2533_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_sizeHintForRow_c767_0;
  gsi::Callback cb_visualRect_c2395_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEditor_4926_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_commitData_1315_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_currentChanged_4682_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_drawBranches_c5397_0;
  gsi::Callback cb_drawRow_c6971_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_dropMimeData_6485_0;
  gsi::Callback cb_edit_6773_0;
  gsi::Callback cb_editorDestroyed_1302_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_horizontalOffset_c0_0;
  gsi::Callback cb_horizontalScrollbarAction_767_0;
  gsi::Callback cb_horizontalScrollbarValueChanged_767_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_isIndexHidden_c2395_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mimeData_c3424_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveCursor_6476_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_rowsAboutToBeRemoved_3713_0;
  gsi::Callback cb_rowsInserted_3713_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_selectedIndexes_c0_0;
  gsi::Callback cb_selectionChanged_5346_0;
  gsi::Callback cb_selectionCommand_c4199_1;
  gsi::Callback cb_setSelection_6155_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_sizeHintForColumn_c767_0;
  gsi::Callback cb_startDrag_2456_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateEditorData_0_0;
  gsi::Callback cb_updateEditorGeometries_0_0;
  gsi::Callback cb_updateGeometries_0_0;
  gsi::Callback cb_verticalOffset_c0_0;
  gsi::Callback cb_verticalScrollbarAction_767_0;
  gsi::Callback cb_verticalScrollbarValueChanged_767_0;
  gsi::Callback cb_viewOptions_c0_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_visualRegionForSelection_c2727_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QTreeWidget_Adaptor::~QTreeWidget_Adaptor() { }

//  Constructor QTreeWidget::QTreeWidget(QWidget *parent) (adaptor class)

static void _init_ctor_QTreeWidget_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QTreeWidget_Adaptor *> ();
}

static void _call_ctor_QTreeWidget_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QTreeWidget_Adaptor *> (new QTreeWidget_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTreeWidget_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTreeWidget::QTreeWidget(QWidget *parent)\nThis method creates an object of class QTreeWidget.", &_init_ctor_QTreeWidget_Adaptor_1315, &_call_ctor_QTreeWidget_Adaptor_1315);
}

// void QTreeWidget::columnCountChanged(int oldCount, int newCount)

static void _init_fp_columnCountChanged_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldCount");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("newCount");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_columnCountChanged_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_columnCountChanged_1426 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_columnCountChanged_1426 ()
{
  return new qt_gsi::GenericMethod("*columnCountChanged", "@brief Method void QTreeWidget::columnCountChanged(int oldCount, int newCount)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_columnCountChanged_1426, &_call_fp_columnCountChanged_1426);
}


// void QTreeWidget::columnMoved()

static void _init_fp_columnMoved_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_columnMoved_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_columnMoved_0 ();
}

static qt_gsi::GenericMethod*_create_fp_columnMoved_0 ()
{
  return new qt_gsi::GenericMethod("*columnMoved", "@brief Method void QTreeWidget::columnMoved()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_columnMoved_0, &_call_fp_columnMoved_0);
}


// void QTreeWidget::columnResized(int column, int oldSize, int newSize)

static void _init_fp_columnResized_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldSize");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("newSize");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_columnResized_2085 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_columnResized_2085 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_columnResized_2085 ()
{
  return new qt_gsi::GenericMethod("*columnResized", "@brief Method void QTreeWidget::columnResized(int column, int oldSize, int newSize)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_columnResized_2085, &_call_fp_columnResized_2085);
}


// void QTreeWidget::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QTreeWidget::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QTreeWidget::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QTreeWidget::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// QPoint QTreeWidget::dirtyRegionOffset()

static void _init_fp_dirtyRegionOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_fp_dirtyRegionOffset_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint > ((QPoint)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_dirtyRegionOffset_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_dirtyRegionOffset_c0 ()
{
  return new qt_gsi::GenericMethod("*dirtyRegionOffset", "@brief Method QPoint QTreeWidget::dirtyRegionOffset()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dirtyRegionOffset_c0, &_call_fp_dirtyRegionOffset_c0);
}


// void QTreeWidget::doAutoScroll()

static void _init_fp_doAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_doAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_doAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_doAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*doAutoScroll", "@brief Method void QTreeWidget::doAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_doAutoScroll_0, &_call_fp_doAutoScroll_0);
}


// void QTreeWidget::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_drawFrame_1426 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_drawFrame_1426 ()
{
  return new qt_gsi::GenericMethod("*drawFrame", "@brief Method void QTreeWidget::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
}


// void QTreeWidget::drawTree(QPainter *painter, const QRegion &region)

static void _init_fp_drawTree_c3324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("region");
  decl->add_arg<const QRegion & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_drawTree_c3324 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRegion &arg2 = args.read<const QRegion & > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_drawTree_c3324 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_drawTree_c3324 ()
{
  return new qt_gsi::GenericMethod("*drawTree", "@brief Method void QTreeWidget::drawTree(QPainter *painter, const QRegion &region)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_drawTree_c3324, &_call_fp_drawTree_c3324);
}


// QAbstractItemView::DropIndicatorPosition QTreeWidget::dropIndicatorPosition()

static void _init_fp_dropIndicatorPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_dropIndicatorPosition_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_dropIndicatorPosition_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_dropIndicatorPosition_c0 ()
{
  return new qt_gsi::GenericMethod("*dropIndicatorPosition", "@brief Method QAbstractItemView::DropIndicatorPosition QTreeWidget::dropIndicatorPosition()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dropIndicatorPosition_c0, &_call_fp_dropIndicatorPosition_c0);
}


// void QTreeWidget::executeDelayedItemsLayout()

static void _init_fp_executeDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_executeDelayedItemsLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_executeDelayedItemsLayout_0 ();
}

static qt_gsi::GenericMethod*_create_fp_executeDelayedItemsLayout_0 ()
{
  return new qt_gsi::GenericMethod("*executeDelayedItemsLayout", "@brief Method void QTreeWidget::executeDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_executeDelayedItemsLayout_0, &_call_fp_executeDelayedItemsLayout_0);
}


// bool QTreeWidget::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QTreeWidget::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QTreeWidget::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QTreeWidget::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QTreeWidget::horizontalStepsPerItem()

static void _init_fp_horizontalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_horizontalStepsPerItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_horizontalStepsPerItem_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_horizontalStepsPerItem_c0 ()
{
  return new qt_gsi::GenericMethod("*horizontalStepsPerItem", "@brief Method int QTreeWidget::horizontalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_horizontalStepsPerItem_c0, &_call_fp_horizontalStepsPerItem_c0);
}


// QModelIndex QTreeWidget::indexFromItem(QTreeWidgetItem *item, int column)

static void _init_fp_indexFromItem_c2773 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_indexFromItem_c2773 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  ret.write<QModelIndex > ((QModelIndex)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_indexFromItem_c2773 (arg1, arg2));
}

static qt_gsi::GenericMethod*_create_fp_indexFromItem_c2773 ()
{
  return new qt_gsi::GenericMethod("*indexFromItem", "@brief Method QModelIndex QTreeWidget::indexFromItem(QTreeWidgetItem *item, int column)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_indexFromItem_c2773, &_call_fp_indexFromItem_c2773);
}


// int QTreeWidget::indexRowSizeHint(const QModelIndex &index)

static void _init_fp_indexRowSizeHint_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_indexRowSizeHint_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<int > ((int)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_indexRowSizeHint_c2395 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_indexRowSizeHint_c2395 ()
{
  return new qt_gsi::GenericMethod("*indexRowSizeHint", "@brief Method int QTreeWidget::indexRowSizeHint(const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_indexRowSizeHint_c2395, &_call_fp_indexRowSizeHint_c2395);
}


// QTreeWidgetItem *QTreeWidget::itemFromIndex(const QModelIndex &index)

static void _init_fp_itemFromIndex_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QTreeWidgetItem * > ();
}

static void _call_fp_itemFromIndex_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QTreeWidgetItem * > ((QTreeWidgetItem *)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_itemFromIndex_c2395 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_itemFromIndex_c2395 ()
{
  return new qt_gsi::GenericMethod("*itemFromIndex", "@brief Method QTreeWidgetItem *QTreeWidget::itemFromIndex(const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_itemFromIndex_c2395, &_call_fp_itemFromIndex_c2395);
}


// QList<QTreeWidgetItem *> QTreeWidget::items(const QMimeData *data)

static void _init_fp_items_c2168 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type > ();
}

static void _call_fp_items_c2168 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMimeData *arg1 = args.read<const QMimeData * > ();
  ret.write<qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type > ((qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_items_c2168 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_items_c2168 ()
{
  return new qt_gsi::GenericMethod("*items", "@brief Method QList<QTreeWidgetItem *> QTreeWidget::items(const QMimeData *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_items_c2168, &_call_fp_items_c2168);
}


// int QTreeWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QTreeWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QTreeWidget::reexpand()

static void _init_fp_reexpand_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_reexpand_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_reexpand_0 ();
}

static qt_gsi::GenericMethod*_create_fp_reexpand_0 ()
{
  return new qt_gsi::GenericMethod("*reexpand", "@brief Method void QTreeWidget::reexpand()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_reexpand_0, &_call_fp_reexpand_0);
}


// void QTreeWidget::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QTreeWidget::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// int QTreeWidget::rowHeight(const QModelIndex &index)

static void _init_fp_rowHeight_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_rowHeight_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<int > ((int)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_rowHeight_c2395 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_rowHeight_c2395 ()
{
  return new qt_gsi::GenericMethod("*rowHeight", "@brief Method int QTreeWidget::rowHeight(const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_rowHeight_c2395, &_call_fp_rowHeight_c2395);
}


// void QTreeWidget::rowsRemoved(const QModelIndex &parent, int first, int last)

static void _init_fp_rowsRemoved_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_rowsRemoved_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_rowsRemoved_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_rowsRemoved_3713 ()
{
  return new qt_gsi::GenericMethod("*rowsRemoved", "@brief Method void QTreeWidget::rowsRemoved(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_rowsRemoved_3713, &_call_fp_rowsRemoved_3713);
}


// void QTreeWidget::scheduleDelayedItemsLayout()

static void _init_fp_scheduleDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_scheduleDelayedItemsLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_scheduleDelayedItemsLayout_0 ();
}

static qt_gsi::GenericMethod*_create_fp_scheduleDelayedItemsLayout_0 ()
{
  return new qt_gsi::GenericMethod("*scheduleDelayedItemsLayout", "@brief Method void QTreeWidget::scheduleDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scheduleDelayedItemsLayout_0, &_call_fp_scheduleDelayedItemsLayout_0);
}


// void QTreeWidget::scrollDirtyRegion(int dx, int dy)

static void _init_fp_scrollDirtyRegion_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_scrollDirtyRegion_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_scrollDirtyRegion_1426 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_scrollDirtyRegion_1426 ()
{
  return new qt_gsi::GenericMethod("*scrollDirtyRegion", "@brief Method void QTreeWidget::scrollDirtyRegion(int dx, int dy)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scrollDirtyRegion_1426, &_call_fp_scrollDirtyRegion_1426);
}


// QObject *QTreeWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QTreeWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QTreeWidget::setDirtyRegion(const QRegion &region)

static void _init_fp_setDirtyRegion_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setDirtyRegion_2006 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_setDirtyRegion_2006 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setDirtyRegion_2006 ()
{
  return new qt_gsi::GenericMethod("*setDirtyRegion", "@brief Method void QTreeWidget::setDirtyRegion(const QRegion &region)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setDirtyRegion_2006, &_call_fp_setDirtyRegion_2006);
}


// void QTreeWidget::setHorizontalStepsPerItem(int steps)

static void _init_fp_setHorizontalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setHorizontalStepsPerItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_setHorizontalStepsPerItem_767 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setHorizontalStepsPerItem_767 ()
{
  return new qt_gsi::GenericMethod("*setHorizontalStepsPerItem", "@brief Method void QTreeWidget::setHorizontalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setHorizontalStepsPerItem_767, &_call_fp_setHorizontalStepsPerItem_767);
}


// void QTreeWidget::setState(QAbstractItemView::State state)

static void _init_fp_setState_2776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setState_2776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_setState_2776 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setState_2776 ()
{
  return new qt_gsi::GenericMethod("*setState", "@brief Method void QTreeWidget::setState(QAbstractItemView::State state)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setState_2776, &_call_fp_setState_2776);
}


// void QTreeWidget::setVerticalStepsPerItem(int steps)

static void _init_fp_setVerticalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setVerticalStepsPerItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_setVerticalStepsPerItem_767 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setVerticalStepsPerItem_767 ()
{
  return new qt_gsi::GenericMethod("*setVerticalStepsPerItem", "@brief Method void QTreeWidget::setVerticalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setVerticalStepsPerItem_767, &_call_fp_setVerticalStepsPerItem_767);
}


// void QTreeWidget::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2744 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QTreeWidget::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
}


// void QTreeWidget::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMargins &arg1 = args.read<const QMargins & > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_setViewportMargins_2115 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2115 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QTreeWidget::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
}


// void QTreeWidget::setupViewport(QWidget *viewport)

static void _init_fp_setupViewport_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setupViewport_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_setupViewport_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setupViewport_1315 ()
{
  return new qt_gsi::GenericMethod("*setupViewport", "@brief Method void QTreeWidget::setupViewport(QWidget *viewport)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setupViewport_1315, &_call_fp_setupViewport_1315);
}


// void QTreeWidget::startAutoScroll()

static void _init_fp_startAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_startAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_startAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_startAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*startAutoScroll", "@brief Method void QTreeWidget::startAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_startAutoScroll_0, &_call_fp_startAutoScroll_0);
}


// QAbstractItemView::State QTreeWidget::state()

static void _init_fp_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_state_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_state_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_state_c0 ()
{
  return new qt_gsi::GenericMethod("*state", "@brief Method QAbstractItemView::State QTreeWidget::state()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_state_c0, &_call_fp_state_c0);
}


// void QTreeWidget::stopAutoScroll()

static void _init_fp_stopAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_stopAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_stopAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_stopAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*stopAutoScroll", "@brief Method void QTreeWidget::stopAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_stopAutoScroll_0, &_call_fp_stopAutoScroll_0);
}


// void QTreeWidget::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QTreeWidget::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// int QTreeWidget::verticalStepsPerItem()

static void _init_fp_verticalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_verticalStepsPerItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTreeWidget_Adaptor *)cls)->fp_QTreeWidget_verticalStepsPerItem_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_verticalStepsPerItem_c0 ()
{
  return new qt_gsi::GenericMethod("*verticalStepsPerItem", "@brief Method int QTreeWidget::verticalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_verticalStepsPerItem_c0, &_call_fp_verticalStepsPerItem_c0);
}


// void QTreeWidget::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)

static void _init_cbs_dataChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_dataChanged_4682_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_dataChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_dataChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_dataChanged_4682_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dataChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("dataChanged", "@hide", false, &_init_cbs_dataChanged_4682_0, &_call_cbs_dataChanged_4682_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dataChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("dataChanged", "@brief Virtual method void QTreeWidget::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dataChanged_4682_0, &_call_cbs_dataChanged_4682_0, &_set_callback_cbs_dataChanged_4682_0);
}


// void QTreeWidget::doItemsLayout()

static void _init_cbs_doItemsLayout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_doItemsLayout_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->cbs_doItemsLayout_0_0 ();
}

static void _set_callback_cbs_doItemsLayout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_doItemsLayout_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_doItemsLayout_0_0 ()
{
  return new qt_gsi::GenericMethod ("doItemsLayout", "@hide", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_doItemsLayout_0_0 ()
{
  return new qt_gsi::GenericMethod ("doItemsLayout", "@brief Virtual method void QTreeWidget::doItemsLayout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0, &_set_callback_cbs_doItemsLayout_0_0);
}


// bool QTreeWidget::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTreeWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTreeWidget::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QTreeWidget::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QTreeWidget_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QTreeWidget::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QModelIndex QTreeWidget::indexAt(const QPoint &p)

static void _init_cbs_indexAt_c1916_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_indexAt_c1916_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QModelIndex > ((QModelIndex)((QTreeWidget_Adaptor *)cls)->cbs_indexAt_c1916_0 (arg1));
}

static void _set_callback_cbs_indexAt_c1916_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_indexAt_c1916_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_indexAt_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("indexAt", "@hide", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_indexAt_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("indexAt", "@brief Virtual method QModelIndex QTreeWidget::indexAt(const QPoint &p)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0, &_set_callback_cbs_indexAt_c1916_0);
}


// QVariant QTreeWidget::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QTreeWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QTreeWidget::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// void QTreeWidget::keyboardSearch(const QString &search)

static void _init_cbs_keyboardSearch_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("search");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyboardSearch_2025_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_keyboardSearch_2025_0 (arg1);
}

static void _set_callback_cbs_keyboardSearch_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_keyboardSearch_2025_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyboardSearch_2025_0 ()
{
  return new qt_gsi::GenericMethod ("keyboardSearch", "@hide", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyboardSearch_2025_0 ()
{
  return new qt_gsi::GenericMethod ("keyboardSearch", "@brief Virtual method void QTreeWidget::keyboardSearch(const QString &search)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0, &_set_callback_cbs_keyboardSearch_2025_0);
}


// QSize QTreeWidget::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QTreeWidget_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QTreeWidget::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QTreeWidget::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QTreeWidget_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QTreeWidget::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QTreeWidget::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_reset_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QTreeWidget::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
}


// void QTreeWidget::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)

static void _init_cbs_scrollTo_5576_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollTo_5576_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_scrollTo_5576_1 (arg1, arg2);
}

static void _set_callback_cbs_scrollTo_5576_1 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_scrollTo_5576_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_scrollTo_5576_1 ()
{
  return new qt_gsi::GenericMethod ("scrollTo", "@hide", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_scrollTo_5576_1 ()
{
  return new qt_gsi::GenericMethod ("scrollTo", "@brief Virtual method void QTreeWidget::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1, &_set_callback_cbs_scrollTo_5576_1);
}


// void QTreeWidget::selectAll()

static void _init_cbs_selectAll_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_selectAll_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->cbs_selectAll_0_0 ();
}

static void _set_callback_cbs_selectAll_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_selectAll_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectAll_0_0 ()
{
  return new qt_gsi::GenericMethod ("selectAll", "@hide", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectAll_0_0 ()
{
  return new qt_gsi::GenericMethod ("selectAll", "@brief Virtual method void QTreeWidget::selectAll()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0, &_set_callback_cbs_selectAll_0_0);
}


// void QTreeWidget::setRootIndex(const QModelIndex &index)

static void _init_cbs_setRootIndex_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setRootIndex_2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_setRootIndex_2395_0 (arg1);
}

static void _set_callback_cbs_setRootIndex_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_setRootIndex_2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setRootIndex_2395_0 ()
{
  return new qt_gsi::GenericMethod ("setRootIndex", "@hide", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setRootIndex_2395_0 ()
{
  return new qt_gsi::GenericMethod ("setRootIndex", "@brief Virtual method void QTreeWidget::setRootIndex(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0, &_set_callback_cbs_setRootIndex_2395_0);
}


// void QTreeWidget::setSelectionModel(QItemSelectionModel *selectionModel)

static void _init_cbs_setSelectionModel_2533_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionModel");
  decl->add_arg<QItemSelectionModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSelectionModel_2533_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QItemSelectionModel *arg1 = args.read<QItemSelectionModel * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_setSelectionModel_2533_0 (arg1);
}

static void _set_callback_cbs_setSelectionModel_2533_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_setSelectionModel_2533_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setSelectionModel_2533_0 ()
{
  return new qt_gsi::GenericMethod ("setSelectionModel", "@hide", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setSelectionModel_2533_0 ()
{
  return new qt_gsi::GenericMethod ("setSelectionModel", "@brief Virtual method void QTreeWidget::setSelectionModel(QItemSelectionModel *selectionModel)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0, &_set_callback_cbs_setSelectionModel_2533_0);
}


// void QTreeWidget::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QTreeWidget::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QTreeWidget::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QTreeWidget_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QTreeWidget::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// int QTreeWidget::sizeHintForRow(int row)

static void _init_cbs_sizeHintForRow_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForRow_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QTreeWidget_Adaptor *)cls)->cbs_sizeHintForRow_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForRow_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_sizeHintForRow_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHintForRow_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForRow", "@hide", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHintForRow_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForRow", "@brief Virtual method int QTreeWidget::sizeHintForRow(int row)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0, &_set_callback_cbs_sizeHintForRow_c767_0);
}


// QRect QTreeWidget::visualRect(const QModelIndex &index)

static void _init_cbs_visualRect_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_cbs_visualRect_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QRect > ((QRect)((QTreeWidget_Adaptor *)cls)->cbs_visualRect_c2395_0 (arg1));
}

static void _set_callback_cbs_visualRect_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_visualRect_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_visualRect_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("visualRect", "@hide", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_visualRect_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("visualRect", "@brief Virtual method QRect QTreeWidget::visualRect(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0, &_set_callback_cbs_visualRect_c2395_0);
}


// void QTreeWidget::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QTreeWidget::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QTreeWidget::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QTreeWidget::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QTreeWidget::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTreeWidget::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QTreeWidget::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)

static void _init_cbs_closeEditor_4926_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_closeEditor_4926_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_closeEditor_4926_0 (arg1, arg2);
}

static void _set_callback_cbs_closeEditor_4926_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_closeEditor_4926_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEditor_4926_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEditor", "@hide", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEditor_4926_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEditor", "@brief Virtual method void QTreeWidget::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0, &_set_callback_cbs_closeEditor_4926_0);
}


// void QTreeWidget::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QTreeWidget::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QTreeWidget::commitData(QWidget *editor)

static void _init_cbs_commitData_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_commitData_1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_commitData_1315_0 (arg1);
}

static void _set_callback_cbs_commitData_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_commitData_1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_commitData_1315_0 ()
{
  return new qt_gsi::GenericMethod ("*commitData", "@hide", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_commitData_1315_0 ()
{
  return new qt_gsi::GenericMethod ("*commitData", "@brief Virtual method void QTreeWidget::commitData(QWidget *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0, &_set_callback_cbs_commitData_1315_0);
}


// void QTreeWidget::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QTreeWidget::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QTreeWidget::currentChanged(const QModelIndex &current, const QModelIndex &previous)

static void _init_cbs_currentChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("previous");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_currentChanged_4682_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_currentChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_currentChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_currentChanged_4682_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_currentChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*currentChanged", "@hide", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_currentChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*currentChanged", "@brief Virtual method void QTreeWidget::currentChanged(const QModelIndex &current, const QModelIndex &previous)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0, &_set_callback_cbs_currentChanged_4682_0);
}


// void QTreeWidget::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTreeWidget::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QTreeWidget::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTreeWidget::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QTreeWidget::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QTreeWidget::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QTreeWidget::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QTreeWidget::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QTreeWidget::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QTreeWidget::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QTreeWidget::drawBranches(QPainter *painter, const QRect &rect, const QModelIndex &index)

static void _init_cbs_drawBranches_c5397_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_drawBranches_c5397_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRect &arg2 = args.read<const QRect & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_drawBranches_c5397_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_drawBranches_c5397_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_drawBranches_c5397_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawBranches_c5397_0 ()
{
  return new qt_gsi::GenericMethod ("*drawBranches", "@hide", true, &_init_cbs_drawBranches_c5397_0, &_call_cbs_drawBranches_c5397_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawBranches_c5397_0 ()
{
  return new qt_gsi::GenericMethod ("*drawBranches", "@brief Virtual method void QTreeWidget::drawBranches(QPainter *painter, const QRect &rect, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawBranches_c5397_0, &_call_cbs_drawBranches_c5397_0, &_set_callback_cbs_drawBranches_c5397_0);
}


// void QTreeWidget::drawRow(QPainter *painter, const QStyleOptionViewItem &options, const QModelIndex &index)

static void _init_cbs_drawRow_c6971_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("options");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_drawRow_c6971_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_drawRow_c6971_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_drawRow_c6971_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_drawRow_c6971_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawRow_c6971_0 ()
{
  return new qt_gsi::GenericMethod ("*drawRow", "@hide", true, &_init_cbs_drawRow_c6971_0, &_call_cbs_drawRow_c6971_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawRow_c6971_0 ()
{
  return new qt_gsi::GenericMethod ("*drawRow", "@brief Virtual method void QTreeWidget::drawRow(QPainter *painter, const QStyleOptionViewItem &options, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawRow_c6971_0, &_call_cbs_drawRow_c6971_0, &_set_callback_cbs_drawRow_c6971_0);
}


// void QTreeWidget::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QTreeWidget::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// bool QTreeWidget::dropMimeData(QTreeWidgetItem *parent, int index, const QMimeData *data, Qt::DropAction action)

static void _init_cbs_dropMimeData_6485_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QTreeWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data");
  decl->add_arg<const QMimeData * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_6485_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTreeWidgetItem *arg1 = args.read<QTreeWidgetItem * > ();
  int arg2 = args.read<int > ();
  const QMimeData *arg3 = args.read<const QMimeData * > ();
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg4 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > ();
  ret.write<bool > ((bool)((QTreeWidget_Adaptor *)cls)->cbs_dropMimeData_6485_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_dropMimeData_6485_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_dropMimeData_6485_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropMimeData_6485_0 ()
{
  return new qt_gsi::GenericMethod ("*dropMimeData", "@hide", false, &_init_cbs_dropMimeData_6485_0, &_call_cbs_dropMimeData_6485_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropMimeData_6485_0 ()
{
  return new qt_gsi::GenericMethod ("*dropMimeData", "@brief Virtual method bool QTreeWidget::dropMimeData(QTreeWidgetItem *parent, int index, const QMimeData *data, Qt::DropAction action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_6485_0, &_call_cbs_dropMimeData_6485_0, &_set_callback_cbs_dropMimeData_6485_0);
}


// bool QTreeWidget::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)

static void _init_cbs_edit_6773_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("trigger");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("event");
  decl->add_arg<QEvent * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_edit_6773_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > ();
  QEvent *arg3 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTreeWidget_Adaptor *)cls)->cbs_edit_6773_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_edit_6773_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_edit_6773_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_edit_6773_0 ()
{
  return new qt_gsi::GenericMethod ("*edit", "@hide", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_edit_6773_0 ()
{
  return new qt_gsi::GenericMethod ("*edit", "@brief Virtual method bool QTreeWidget::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0, &_set_callback_cbs_edit_6773_0);
}


// void QTreeWidget::editorDestroyed(QObject *editor)

static void _init_cbs_editorDestroyed_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_editorDestroyed_1302_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_editorDestroyed_1302_0 (arg1);
}

static void _set_callback_cbs_editorDestroyed_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_editorDestroyed_1302_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_editorDestroyed_1302_0 ()
{
  return new qt_gsi::GenericMethod ("*editorDestroyed", "@hide", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_editorDestroyed_1302_0 ()
{
  return new qt_gsi::GenericMethod ("*editorDestroyed", "@brief Virtual method void QTreeWidget::editorDestroyed(QObject *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0, &_set_callback_cbs_editorDestroyed_1302_0);
}


// void QTreeWidget::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QTreeWidget::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QTreeWidget::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QTreeWidget::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QTreeWidget::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTreeWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QTreeWidget::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QTreeWidget::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QTreeWidget::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QTreeWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QTreeWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QTreeWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QTreeWidget::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QTreeWidget::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QTreeWidget::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QTreeWidget::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QTreeWidget::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QTreeWidget::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// int QTreeWidget::horizontalOffset()

static void _init_cbs_horizontalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_horizontalOffset_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTreeWidget_Adaptor *)cls)->cbs_horizontalOffset_c0_0 ());
}

static void _set_callback_cbs_horizontalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_horizontalOffset_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalOffset", "@hide", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalOffset", "@brief Virtual method int QTreeWidget::horizontalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0, &_set_callback_cbs_horizontalOffset_c0_0);
}


// void QTreeWidget::horizontalScrollbarAction(int action)

static void _init_cbs_horizontalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarAction_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_horizontalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_horizontalScrollbarAction_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@hide", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@brief Virtual method void QTreeWidget::horizontalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0, &_set_callback_cbs_horizontalScrollbarAction_767_0);
}


// void QTreeWidget::horizontalScrollbarValueChanged(int value)

static void _init_cbs_horizontalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_horizontalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_horizontalScrollbarValueChanged_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@hide", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@brief Virtual method void QTreeWidget::horizontalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0, &_set_callback_cbs_horizontalScrollbarValueChanged_767_0);
}


// void QTreeWidget::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QTreeWidget::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// bool QTreeWidget::isIndexHidden(const QModelIndex &index)

static void _init_cbs_isIndexHidden_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isIndexHidden_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QTreeWidget_Adaptor *)cls)->cbs_isIndexHidden_c2395_0 (arg1));
}

static void _set_callback_cbs_isIndexHidden_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_isIndexHidden_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isIndexHidden_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("*isIndexHidden", "@hide", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isIndexHidden_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("*isIndexHidden", "@brief Virtual method bool QTreeWidget::isIndexHidden(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0, &_set_callback_cbs_isIndexHidden_c2395_0);
}


// void QTreeWidget::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QTreeWidget::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QTreeWidget::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QTreeWidget::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QTreeWidget::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QTreeWidget::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QTreeWidget::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QTreeWidget::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QTreeWidget::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QTreeWidget_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QTreeWidget::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// QMimeData *QTreeWidget::mimeData(const QList<QTreeWidgetItem *> items)

static void _init_cbs_mimeData_c3424_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3424_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QTreeWidgetItem *> >::target_type & > ();
  ret.write<QMimeData * > ((QMimeData *)((QTreeWidget_Adaptor *)cls)->cbs_mimeData_c3424_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3424_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_mimeData_c3424_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeData_c3424_0 ()
{
  return new qt_gsi::GenericMethod ("*mimeData", "@hide", true, &_init_cbs_mimeData_c3424_0, &_call_cbs_mimeData_c3424_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeData_c3424_0 ()
{
  return new qt_gsi::GenericMethod ("*mimeData", "@brief Virtual method QMimeData *QTreeWidget::mimeData(const QList<QTreeWidgetItem *> items)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3424_0, &_call_cbs_mimeData_c3424_0, &_set_callback_cbs_mimeData_c3424_0);
}


// QStringList QTreeWidget::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)((QTreeWidget_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*mimeTypes", "@brief Virtual method QStringList QTreeWidget::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
}


// void QTreeWidget::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QTreeWidget::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QTreeWidget::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QTreeWidget::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QTreeWidget::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QTreeWidget::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QTreeWidget::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QTreeWidget::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// QModelIndex QTreeWidget::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)

static void _init_cbs_moveCursor_6476_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursorAction");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("modifiers");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & > (argspec_1);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_moveCursor_6476_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & > ();
  ret.write<QModelIndex > ((QModelIndex)((QTreeWidget_Adaptor *)cls)->cbs_moveCursor_6476_0 (arg1, arg2));
}

static void _set_callback_cbs_moveCursor_6476_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_moveCursor_6476_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveCursor_6476_0 ()
{
  return new qt_gsi::GenericMethod ("*moveCursor", "@hide", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveCursor_6476_0 ()
{
  return new qt_gsi::GenericMethod ("*moveCursor", "@brief Virtual method QModelIndex QTreeWidget::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0, &_set_callback_cbs_moveCursor_6476_0);
}


// void QTreeWidget::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QTreeWidget::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QTreeWidget::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QTreeWidget::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QTreeWidget::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QTreeWidget::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QTreeWidget::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QTreeWidget::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QTreeWidget::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsAboutToBeRemoved_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsAboutToBeRemoved_3713_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_rowsAboutToBeRemoved_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsAboutToBeRemoved_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_rowsAboutToBeRemoved_3713_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowsAboutToBeRemoved_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@hide", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowsAboutToBeRemoved_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@brief Virtual method void QTreeWidget::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0, &_set_callback_cbs_rowsAboutToBeRemoved_3713_0);
}


// void QTreeWidget::rowsInserted(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsInserted_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsInserted_3713_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_rowsInserted_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsInserted_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_rowsInserted_3713_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowsInserted_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsInserted", "@hide", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowsInserted_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsInserted", "@brief Virtual method void QTreeWidget::rowsInserted(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0, &_set_callback_cbs_rowsInserted_3713_0);
}


// void QTreeWidget::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QTreeWidget::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
}


// QList<QModelIndex> QTreeWidget::selectedIndexes()

static void _init_cbs_selectedIndexes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_cbs_selectedIndexes_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QTreeWidget_Adaptor *)cls)->cbs_selectedIndexes_c0_0 ());
}

static void _set_callback_cbs_selectedIndexes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_selectedIndexes_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectedIndexes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*selectedIndexes", "@hide", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectedIndexes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*selectedIndexes", "@brief Virtual method QList<QModelIndex> QTreeWidget::selectedIndexes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0, &_set_callback_cbs_selectedIndexes_c0_0);
}


// void QTreeWidget::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)

static void _init_cbs_selectionChanged_5346_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selected");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deselected");
  decl->add_arg<const QItemSelection & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_selectionChanged_5346_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  const QItemSelection &arg2 = args.read<const QItemSelection & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_selectionChanged_5346_0 (arg1, arg2);
}

static void _set_callback_cbs_selectionChanged_5346_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_selectionChanged_5346_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectionChanged_5346_0 ()
{
  return new qt_gsi::GenericMethod ("*selectionChanged", "@hide", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectionChanged_5346_0 ()
{
  return new qt_gsi::GenericMethod ("*selectionChanged", "@brief Virtual method void QTreeWidget::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0, &_set_callback_cbs_selectionChanged_5346_0);
}


// QFlags<QItemSelectionModel::SelectionFlag> QTreeWidget::selectionCommand(const QModelIndex &index, const QEvent *event)

static void _init_cbs_selectionCommand_c4199_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<const QEvent * > (argspec_1);
  decl->set_return<qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type > ();
}

static void _call_cbs_selectionCommand_c4199_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QEvent *arg2 = args.read<const QEvent * > ();
  ret.write<qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type > ((qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type)((QTreeWidget_Adaptor *)cls)->cbs_selectionCommand_c4199_1 (arg1, arg2));
}

static void _set_callback_cbs_selectionCommand_c4199_1 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_selectionCommand_c4199_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectionCommand_c4199_1 ()
{
  return new qt_gsi::GenericMethod ("*selectionCommand", "@hide", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectionCommand_c4199_1 ()
{
  return new qt_gsi::GenericMethod ("*selectionCommand", "@brief Virtual method QFlags<QItemSelectionModel::SelectionFlag> QTreeWidget::selectionCommand(const QModelIndex &index, const QEvent *event)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1, &_set_callback_cbs_selectionCommand_c4199_1);
}


// void QTreeWidget::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)

static void _init_cbs_setSelection_6155_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setSelection_6155_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_setSelection_6155_0 (arg1, arg2);
}

static void _set_callback_cbs_setSelection_6155_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_setSelection_6155_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setSelection_6155_0 ()
{
  return new qt_gsi::GenericMethod ("*setSelection", "@hide", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setSelection_6155_0 ()
{
  return new qt_gsi::GenericMethod ("*setSelection", "@brief Virtual method void QTreeWidget::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0, &_set_callback_cbs_setSelection_6155_0);
}


// void QTreeWidget::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QTreeWidget::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// int QTreeWidget::sizeHintForColumn(int column)

static void _init_cbs_sizeHintForColumn_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForColumn_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QTreeWidget_Adaptor *)cls)->cbs_sizeHintForColumn_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForColumn_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_sizeHintForColumn_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHintForColumn_c767_0 ()
{
  return new qt_gsi::GenericMethod ("*sizeHintForColumn", "@hide", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHintForColumn_c767_0 ()
{
  return new qt_gsi::GenericMethod ("*sizeHintForColumn", "@brief Virtual method int QTreeWidget::sizeHintForColumn(int column)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0, &_set_callback_cbs_sizeHintForColumn_c767_0);
}


// void QTreeWidget::startDrag(QFlags<Qt::DropAction> supportedActions)

static void _init_cbs_startDrag_2456_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("supportedActions");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_startDrag_2456_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_startDrag_2456_0 (arg1);
}

static void _set_callback_cbs_startDrag_2456_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_startDrag_2456_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_startDrag_2456_0 ()
{
  return new qt_gsi::GenericMethod ("*startDrag", "@hide", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_startDrag_2456_0 ()
{
  return new qt_gsi::GenericMethod ("*startDrag", "@brief Virtual method void QTreeWidget::startDrag(QFlags<Qt::DropAction> supportedActions)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0, &_set_callback_cbs_startDrag_2456_0);
}


// void QTreeWidget::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QTreeWidget::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// QFlags<Qt::DropAction> QTreeWidget::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ((qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type)((QTreeWidget_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QTreeWidget::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
}


// void QTreeWidget::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QTreeWidget::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QTreeWidget::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTreeWidget::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QTreeWidget::updateEditorData()

static void _init_cbs_updateEditorData_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorData_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->cbs_updateEditorData_0_0 ();
}

static void _set_callback_cbs_updateEditorData_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_updateEditorData_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateEditorData_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorData", "@hide", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateEditorData_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorData", "@brief Virtual method void QTreeWidget::updateEditorData()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0, &_set_callback_cbs_updateEditorData_0_0);
}


// void QTreeWidget::updateEditorGeometries()

static void _init_cbs_updateEditorGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometries_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->cbs_updateEditorGeometries_0_0 ();
}

static void _set_callback_cbs_updateEditorGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_updateEditorGeometries_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateEditorGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorGeometries", "@hide", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateEditorGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorGeometries", "@brief Virtual method void QTreeWidget::updateEditorGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0, &_set_callback_cbs_updateEditorGeometries_0_0);
}


// void QTreeWidget::updateGeometries()

static void _init_cbs_updateGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometries_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTreeWidget_Adaptor *)cls)->cbs_updateGeometries_0_0 ();
}

static void _set_callback_cbs_updateGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_updateGeometries_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateGeometries", "@hide", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateGeometries", "@brief Virtual method void QTreeWidget::updateGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0, &_set_callback_cbs_updateGeometries_0_0);
}


// int QTreeWidget::verticalOffset()

static void _init_cbs_verticalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_verticalOffset_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTreeWidget_Adaptor *)cls)->cbs_verticalOffset_c0_0 ());
}

static void _set_callback_cbs_verticalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_verticalOffset_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalOffset", "@hide", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalOffset", "@brief Virtual method int QTreeWidget::verticalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0, &_set_callback_cbs_verticalOffset_c0_0);
}


// void QTreeWidget::verticalScrollbarAction(int action)

static void _init_cbs_verticalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarAction_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_verticalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_verticalScrollbarAction_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@hide", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@brief Virtual method void QTreeWidget::verticalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0, &_set_callback_cbs_verticalScrollbarAction_767_0);
}


// void QTreeWidget::verticalScrollbarValueChanged(int value)

static void _init_cbs_verticalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_verticalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_verticalScrollbarValueChanged_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@hide", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@brief Virtual method void QTreeWidget::verticalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0, &_set_callback_cbs_verticalScrollbarValueChanged_767_0);
}


// QStyleOptionViewItem QTreeWidget::viewOptions()

static void _init_cbs_viewOptions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyleOptionViewItem > ();
}

static void _call_cbs_viewOptions_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStyleOptionViewItem > ((QStyleOptionViewItem)((QTreeWidget_Adaptor *)cls)->cbs_viewOptions_c0_0 ());
}

static void _set_callback_cbs_viewOptions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_viewOptions_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_viewOptions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*viewOptions", "@hide", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_viewOptions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*viewOptions", "@brief Virtual method QStyleOptionViewItem QTreeWidget::viewOptions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0, &_set_callback_cbs_viewOptions_c0_0);
}


// bool QTreeWidget::viewportEvent(QEvent *event)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTreeWidget_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QTreeWidget::viewportEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
}


// QRegion QTreeWidget::visualRegionForSelection(const QItemSelection &selection)

static void _init_cbs_visualRegionForSelection_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QRegion > ();
}

static void _call_cbs_visualRegionForSelection_c2727_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  ret.write<QRegion > ((QRegion)((QTreeWidget_Adaptor *)cls)->cbs_visualRegionForSelection_c2727_0 (arg1));
}

static void _set_callback_cbs_visualRegionForSelection_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_visualRegionForSelection_c2727_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_visualRegionForSelection_c2727_0 ()
{
  return new qt_gsi::GenericMethod ("*visualRegionForSelection", "@hide", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_visualRegionForSelection_c2727_0 ()
{
  return new qt_gsi::GenericMethod ("*visualRegionForSelection", "@brief Virtual method QRegion QTreeWidget::visualRegionForSelection(const QItemSelection &selection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0, &_set_callback_cbs_visualRegionForSelection_c2727_0);
}


// void QTreeWidget::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QTreeWidget::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QTreeWidget::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTreeWidget_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeWidget_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QTreeWidget::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QTreeWidget> decl_QTreeWidget;

gsi::Class<QTreeWidget_Adaptor> decl_QTreeWidget_Adaptor (decl_QTreeWidget, "QTreeWidget",
  gsi::Methods(_create_fp_columnCountChanged_1426 ()) +
  gsi::Methods(_create_fp_columnMoved_0 ()) +
  gsi::Methods(_create_fp_columnResized_2085 ()) +
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_dirtyRegionOffset_c0 ()) +
  gsi::Methods(_create_fp_doAutoScroll_0 ()) +
  gsi::Methods(_create_fp_drawFrame_1426 ()) +
  gsi::Methods(_create_fp_drawTree_c3324 ()) +
  gsi::Methods(_create_fp_dropIndicatorPosition_c0 ()) +
  gsi::Methods(_create_fp_executeDelayedItemsLayout_0 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_horizontalStepsPerItem_c0 ()) +
  gsi::Methods(_create_fp_indexFromItem_c2773 ()) +
  gsi::Methods(_create_fp_indexRowSizeHint_c2395 ()) +
  gsi::Methods(_create_fp_itemFromIndex_c2395 ()) +
  gsi::Methods(_create_fp_items_c2168 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_reexpand_0 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_rowHeight_c2395 ()) +
  gsi::Methods(_create_fp_rowsRemoved_3713 ()) +
  gsi::Methods(_create_fp_scheduleDelayedItemsLayout_0 ()) +
  gsi::Methods(_create_fp_scrollDirtyRegion_1426 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_setDirtyRegion_2006 ()) +
  gsi::Methods(_create_fp_setHorizontalStepsPerItem_767 ()) +
  gsi::Methods(_create_fp_setState_2776 ()) +
  gsi::Methods(_create_fp_setVerticalStepsPerItem_767 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2744 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2115 ()) +
  gsi::Methods(_create_fp_setupViewport_1315 ()) +
  gsi::Methods(_create_fp_startAutoScroll_0 ()) +
  gsi::Methods(_create_fp_state_c0 ()) +
  gsi::Methods(_create_fp_stopAutoScroll_0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_fp_verticalStepsPerItem_c0 ()) +
  gsi::Methods(_create_cbs_dataChanged_4682_0 ()) +
  gsi::Methods(_create_callback_cbs_dataChanged_4682_0 ()) +
  gsi::Methods(_create_cbs_doItemsLayout_0_0 ()) +
  gsi::Methods(_create_callback_cbs_doItemsLayout_0_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_indexAt_c1916_0 ()) +
  gsi::Methods(_create_callback_cbs_indexAt_c1916_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_keyboardSearch_2025_0 ()) +
  gsi::Methods(_create_callback_cbs_keyboardSearch_2025_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_reset_0_0 ()) +
  gsi::Methods(_create_callback_cbs_reset_0_0 ()) +
  gsi::Methods(_create_cbs_scrollTo_5576_1 ()) +
  gsi::Methods(_create_callback_cbs_scrollTo_5576_1 ()) +
  gsi::Methods(_create_cbs_selectAll_0_0 ()) +
  gsi::Methods(_create_callback_cbs_selectAll_0_0 ()) +
  gsi::Methods(_create_cbs_setRootIndex_2395_0 ()) +
  gsi::Methods(_create_callback_cbs_setRootIndex_2395_0 ()) +
  gsi::Methods(_create_cbs_setSelectionModel_2533_0 ()) +
  gsi::Methods(_create_callback_cbs_setSelectionModel_2533_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_sizeHintForRow_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHintForRow_c767_0 ()) +
  gsi::Methods(_create_cbs_visualRect_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_visualRect_c2395_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEditor_4926_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEditor_4926_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_commitData_1315_0 ()) +
  gsi::Methods(_create_callback_cbs_commitData_1315_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_currentChanged_4682_0 ()) +
  gsi::Methods(_create_callback_cbs_currentChanged_4682_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_drawBranches_c5397_0 ()) +
  gsi::Methods(_create_callback_cbs_drawBranches_c5397_0 ()) +
  gsi::Methods(_create_cbs_drawRow_c6971_0 ()) +
  gsi::Methods(_create_callback_cbs_drawRow_c6971_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_dropMimeData_6485_0 ()) +
  gsi::Methods(_create_callback_cbs_dropMimeData_6485_0 ()) +
  gsi::Methods(_create_cbs_edit_6773_0 ()) +
  gsi::Methods(_create_callback_cbs_edit_6773_0 ()) +
  gsi::Methods(_create_cbs_editorDestroyed_1302_0 ()) +
  gsi::Methods(_create_callback_cbs_editorDestroyed_1302_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_horizontalOffset_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalOffset_c0_0 ()) +
  gsi::Methods(_create_cbs_horizontalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_cbs_horizontalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_isIndexHidden_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_isIndexHidden_c2395_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mimeData_c3424_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeData_c3424_0 ()) +
  gsi::Methods(_create_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveCursor_6476_0 ()) +
  gsi::Methods(_create_callback_cbs_moveCursor_6476_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_rowsAboutToBeRemoved_3713_0 ()) +
  gsi::Methods(_create_callback_cbs_rowsAboutToBeRemoved_3713_0 ()) +
  gsi::Methods(_create_cbs_rowsInserted_3713_0 ()) +
  gsi::Methods(_create_callback_cbs_rowsInserted_3713_0 ()) +
  gsi::Methods(_create_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_callback_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_cbs_selectedIndexes_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_selectedIndexes_c0_0 ()) +
  gsi::Methods(_create_cbs_selectionChanged_5346_0 ()) +
  gsi::Methods(_create_callback_cbs_selectionChanged_5346_0 ()) +
  gsi::Methods(_create_cbs_selectionCommand_c4199_1 ()) +
  gsi::Methods(_create_callback_cbs_selectionCommand_c4199_1 ()) +
  gsi::Methods(_create_cbs_setSelection_6155_0 ()) +
  gsi::Methods(_create_callback_cbs_setSelection_6155_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_sizeHintForColumn_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHintForColumn_c767_0 ()) +
  gsi::Methods(_create_cbs_startDrag_2456_0 ()) +
  gsi::Methods(_create_callback_cbs_startDrag_2456_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_updateEditorData_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateEditorData_0_0 ()) +
  gsi::Methods(_create_cbs_updateEditorGeometries_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateEditorGeometries_0_0 ()) +
  gsi::Methods(_create_cbs_updateGeometries_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateGeometries_0_0 ()) +
  gsi::Methods(_create_cbs_verticalOffset_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalOffset_c0_0 ()) +
  gsi::Methods(_create_cbs_verticalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_cbs_verticalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_cbs_viewOptions_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_viewOptions_c0_0 ()) +
  gsi::Methods(_create_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_visualRegionForSelection_c2727_0 ()) +
  gsi::Methods(_create_callback_cbs_visualRegionForSelection_c2727_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QTreeWidget_Adaptor_1315 ()),
  "@qt\n@brief Binding of QTreeWidget");

}

