
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQThread.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQThread_EventAdaptor.h"
#include "gsiDeclQThread_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QThread

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QThread::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QThread::exit(int retcode)


static void _init_f_exit_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("retcode", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_exit_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(0);
  ((QThread *)cls)->exit (arg1);
}

static qt_gsi::GenericMethod *_create_f_exit_767 ()
{
  return new qt_gsi::GenericMethod ("exit", "@brief Method void QThread::exit(int retcode)\n", false, &_init_f_exit_767, &_call_f_exit_767);
}

// bool QThread::isFinished()


static void _init_f_isFinished_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFinished_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QThread *)cls)->isFinished ());
}

static qt_gsi::GenericMethod *_create_f_isFinished_c0 ()
{
  return new qt_gsi::GenericMethod ("isFinished?", "@brief Method bool QThread::isFinished()\n", true, &_init_f_isFinished_c0, &_call_f_isFinished_c0);
}

// bool QThread::isRunning()


static void _init_f_isRunning_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRunning_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QThread *)cls)->isRunning ());
}

static qt_gsi::GenericMethod *_create_f_isRunning_c0 ()
{
  return new qt_gsi::GenericMethod ("isRunning?", "@brief Method bool QThread::isRunning()\n", true, &_init_f_isRunning_c0, &_call_f_isRunning_c0);
}

// QThread::Priority QThread::priority()


static void _init_f_priority_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QThread::Priority>::target_type > ();
}

static void _call_f_priority_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QThread::Priority>::target_type > ((qt_gsi::Converter<QThread::Priority>::target_type)qt_gsi::CppToQtAdaptor<QThread::Priority>(((QThread *)cls)->priority ()));
}

static qt_gsi::GenericMethod *_create_f_priority_c0 ()
{
  return new qt_gsi::GenericMethod (":priority", "@brief Method QThread::Priority QThread::priority()\n", true, &_init_f_priority_c0, &_call_f_priority_c0);
}

// void QThread::quit()


static void _init_f_quit_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_quit_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QThread *)cls)->quit ();
}

static qt_gsi::GenericMethod *_create_f_quit_0 ()
{
  return new qt_gsi::GenericMethod ("quit", "@brief Method void QThread::quit()\n", false, &_init_f_quit_0, &_call_f_quit_0);
}

// void QThread::setPriority(QThread::Priority priority)


static void _init_f_setPriority_2099 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("priority");
  decl->add_arg<const qt_gsi::Converter<QThread::Priority>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPriority_2099 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QThread::Priority>::target_type & arg1 = args.read<const qt_gsi::Converter<QThread::Priority>::target_type & > ();
  ((QThread *)cls)->setPriority (qt_gsi::QtToCppAdaptor<QThread::Priority>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setPriority_2099 ()
{
  return new qt_gsi::GenericMethod ("setPriority|priority=", "@brief Method void QThread::setPriority(QThread::Priority priority)\n", false, &_init_f_setPriority_2099, &_call_f_setPriority_2099);
}

// void QThread::setStackSize(unsigned int stackSize)


static void _init_f_setStackSize_1772 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stackSize");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStackSize_1772 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ((QThread *)cls)->setStackSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStackSize_1772 ()
{
  return new qt_gsi::GenericMethod ("setStackSize|stackSize=", "@brief Method void QThread::setStackSize(unsigned int stackSize)\n", false, &_init_f_setStackSize_1772, &_call_f_setStackSize_1772);
}

// unsigned int QThread::stackSize()


static void _init_f_stackSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_f_stackSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QThread *)cls)->stackSize ());
}

static qt_gsi::GenericMethod *_create_f_stackSize_c0 ()
{
  return new qt_gsi::GenericMethod (":stackSize", "@brief Method unsigned int QThread::stackSize()\n", true, &_init_f_stackSize_c0, &_call_f_stackSize_c0);
}

// void QThread::start(QThread::Priority)


static void _init_f_start_2099 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "QThread::InheritPriority");
  decl->add_arg<const qt_gsi::Converter<QThread::Priority>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_start_2099 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QThread::Priority>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QThread::Priority>::target_type & > () : (const qt_gsi::Converter<QThread::Priority>::target_type &)(qt_gsi::CppToQtReadAdaptor<QThread::Priority>(heap, QThread::InheritPriority));
  ((QThread *)cls)->start (qt_gsi::QtToCppAdaptor<QThread::Priority>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_start_2099 ()
{
  return new qt_gsi::GenericMethod ("start", "@brief Method void QThread::start(QThread::Priority)\n", false, &_init_f_start_2099, &_call_f_start_2099);
}

// void QThread::terminate()


static void _init_f_terminate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_terminate_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QThread *)cls)->terminate ();
}

static qt_gsi::GenericMethod *_create_f_terminate_0 ()
{
  return new qt_gsi::GenericMethod ("terminate", "@brief Method void QThread::terminate()\n", false, &_init_f_terminate_0, &_call_f_terminate_0);
}

// bool QThread::wait(unsigned long int time)


static void _init_f_wait_2348 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time", true, "ULONG_MAX");
  decl->add_arg<unsigned long int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_wait_2348 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned long int arg1 = args ? args.read<unsigned long int > () : (unsigned long int)(ULONG_MAX);
  ret.write<bool > ((bool)((QThread *)cls)->wait (arg1));
}

static qt_gsi::GenericMethod *_create_f_wait_2348 ()
{
  return new qt_gsi::GenericMethod ("wait", "@brief Method bool QThread::wait(unsigned long int time)\n", false, &_init_f_wait_2348, &_call_f_wait_2348);
}

// static QThread *QThread::currentThread()


static void _init_f_currentThread_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QThread * > ();
}

static void _call_f_currentThread_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QThread * > ((QThread *)QThread::currentThread ());
}

static qt_gsi::GenericStaticMethod *_create_f_currentThread_0 ()
{
  return new qt_gsi::GenericStaticMethod ("currentThread", "@brief Static method QThread *QThread::currentThread()\nThis method is static and can be called without an instance.", &_init_f_currentThread_0, &_call_f_currentThread_0);
}

// static Qt::HANDLE QThread::currentThreadId()


static void _init_f_currentThreadId_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<Qt::HANDLE > ();
}

static void _call_f_currentThreadId_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<Qt::HANDLE > ((Qt::HANDLE)QThread::currentThreadId ());
}

static qt_gsi::GenericStaticMethod *_create_f_currentThreadId_0 ()
{
  return new qt_gsi::GenericStaticMethod ("currentThreadId", "@brief Static method Qt::HANDLE QThread::currentThreadId()\nThis method is static and can be called without an instance.", &_init_f_currentThreadId_0, &_call_f_currentThreadId_0);
}

// static int QThread::idealThreadCount()


static void _init_f_idealThreadCount_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_idealThreadCount_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)QThread::idealThreadCount ());
}

static qt_gsi::GenericStaticMethod *_create_f_idealThreadCount_0 ()
{
  return new qt_gsi::GenericStaticMethod ("idealThreadCount", "@brief Static method int QThread::idealThreadCount()\nThis method is static and can be called without an instance.", &_init_f_idealThreadCount_0, &_call_f_idealThreadCount_0);
}

// static QString QThread::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QThread::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QThread::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QThread::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QThread::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QThread::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QThread::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QThread::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QThread::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QThread::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QThread::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QThread::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

// static void QThread::yieldCurrentThread()


static void _init_f_yieldCurrentThread_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_yieldCurrentThread_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QThread::yieldCurrentThread ();
}

static qt_gsi::GenericStaticMethod *_create_f_yieldCurrentThread_0 ()
{
  return new qt_gsi::GenericStaticMethod ("yieldCurrentThread", "@brief Static method void QThread::yieldCurrentThread()\nThis method is static and can be called without an instance.", &_init_f_yieldCurrentThread_0, &_call_f_yieldCurrentThread_0);
}

static qt_gsi::QObjectConnector<QThread, QThread_EventAdaptor> ea_QThread;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QThread> decl_QThread (ea_QThread, decl_QObject, "QThread_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_exit_767 ()) +
  gsi::Methods(_create_f_isFinished_c0 ()) +
  gsi::Methods(_create_f_isRunning_c0 ()) +
  gsi::Methods(_create_f_priority_c0 ()) +
  gsi::Methods(_create_f_quit_0 ()) +
  gsi::Methods(_create_f_setPriority_2099 ()) +
  gsi::Methods(_create_f_setStackSize_1772 ()) +
  gsi::Methods(_create_f_stackSize_c0 ()) +
  gsi::Methods(_create_f_start_2099 ()) +
  gsi::Methods(_create_f_terminate_0 ()) +
  gsi::Methods(_create_f_wait_2348 ()) +
  qt_gsi::qt_signal<QThread, QThread_EventAdaptor, QObject *> ("destroyed", &QThread_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QThread::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QThread, QThread_EventAdaptor> ("finished", &QThread_EventAdaptor::finished_e_0, "@brief Signal declaration for QThread::finished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QThread, QThread_EventAdaptor> ("started", &QThread_EventAdaptor::started_e_0, "@brief Signal declaration for QThread::started()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QThread, QThread_EventAdaptor> ("terminated", &QThread_EventAdaptor::terminated_e_0, "@brief Signal declaration for QThread::terminated()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_currentThread_0 ()) +
  gsi::Methods(_create_f_currentThreadId_0 ()) +
  gsi::Methods(_create_f_idealThreadCount_0 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()) +
  gsi::Methods(_create_f_yieldCurrentThread_0 ()),
  "@hide\n@alias QThread");
}


class QThread_Adaptor : public QThread, public qt_gsi::QtObjectBase
{
public:

  virtual ~QThread_Adaptor();

  //  [adaptor ctor] QThread::QThread(QObject *parent)
  QThread_Adaptor() : QThread()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QThread::QThread(QObject *parent)
  QThread_Adaptor(QObject *parent) : QThread(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QThread::exec()
  int fp_QThread_exec_0 () {
    return QThread::exec();
  }

  //  void QThread::msleep(unsigned long int)
  static void fp_QThread_msleep_2348 (unsigned long int arg1) {
    QThread::msleep(arg1);
  }

  //  int QThread::receivers(const char *signal)
  int fp_QThread_receivers_c1731 (const char *signal) const {
    return QThread::receivers(signal);
  }

  //  QObject *QThread::sender()
  QObject * fp_QThread_sender_c0 () const {
    return QThread::sender();
  }

  //  void QThread::setTerminationEnabled(bool enabled)
  static void fp_QThread_setTerminationEnabled_864 (bool enabled) {
    QThread::setTerminationEnabled(enabled);
  }

  //  void QThread::sleep(unsigned long int)
  static void fp_QThread_sleep_2348 (unsigned long int arg1) {
    QThread::sleep(arg1);
  }

  //  void QThread::usleep(unsigned long int)
  static void fp_QThread_usleep_2348 (unsigned long int arg1) {
    QThread::usleep(arg1);
  }

  //  [adaptor impl] bool QThread::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QThread::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QThread_Adaptor, bool, QEvent *>(&QThread_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QThread::event(arg1);
    }
  }

  //  [adaptor impl] bool QThread::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QThread::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QThread_Adaptor, bool, QObject *, QEvent *>(&QThread_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QThread::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QThread::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QThread::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QThread_Adaptor, QChildEvent *>(&QThread_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QThread::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QThread::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QThread::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QThread_Adaptor, QEvent *>(&QThread_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QThread::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QThread::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QThread::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QThread_Adaptor, const char *>(&QThread_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QThread::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QThread::run()
  void cbs_run_0_0()
  {
    QThread::run();
  }

  virtual void run()
  {
    if (cb_run_0_0.can_issue()) {
      cb_run_0_0.issue<QThread_Adaptor>(&QThread_Adaptor::cbs_run_0_0);
    } else {
      QThread::run();
    }
  }

  //  [adaptor impl] void QThread::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QThread::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QThread_Adaptor, QTimerEvent *>(&QThread_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QThread::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_run_0_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QThread_Adaptor::~QThread_Adaptor() { }

//  Constructor QThread::QThread(QObject *parent) (adaptor class)

static void _init_ctor_QThread_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QThread_Adaptor *> ();
}

static void _call_ctor_QThread_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QThread_Adaptor *> (new QThread_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QThread_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QThread::QThread(QObject *parent)\nThis method creates an object of class QThread.", &_init_ctor_QThread_Adaptor_1302, &_call_ctor_QThread_Adaptor_1302);
}

// int QThread::exec()

static void _init_fp_exec_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_exec_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QThread_Adaptor *)cls)->fp_QThread_exec_0 ());
}

static qt_gsi::GenericMethod*_create_fp_exec_0 ()
{
  return new qt_gsi::GenericMethod("*exec", "@brief Method int QThread::exec()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_exec_0, &_call_fp_exec_0);
}


// void QThread::msleep(unsigned long int)

static void _init_fp_msleep_2348 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<unsigned long int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_msleep_2348 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned long int arg1 = args.read<unsigned long int > ();
  QThread_Adaptor::fp_QThread_msleep_2348 (arg1);
}

static qt_gsi::GenericStaticMethod*_create_fp_msleep_2348 ()
{
  return new qt_gsi::GenericStaticMethod("*msleep", "@brief Method void QThread::msleep(unsigned long int)\nThis method is protected and can only be called from inside a derived class.", &_init_fp_msleep_2348, &_call_fp_msleep_2348);
}


// int QThread::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QThread_Adaptor *)cls)->fp_QThread_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QThread::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QThread::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QThread_Adaptor *)cls)->fp_QThread_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QThread::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QThread::setTerminationEnabled(bool enabled)

static void _init_fp_setTerminationEnabled_864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setTerminationEnabled_864 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  QThread_Adaptor::fp_QThread_setTerminationEnabled_864 (arg1);
}

static qt_gsi::GenericStaticMethod*_create_fp_setTerminationEnabled_864 ()
{
  return new qt_gsi::GenericStaticMethod("*setTerminationEnabled", "@brief Method void QThread::setTerminationEnabled(bool enabled)\nThis method is protected and can only be called from inside a derived class.", &_init_fp_setTerminationEnabled_864, &_call_fp_setTerminationEnabled_864);
}


// void QThread::sleep(unsigned long int)

static void _init_fp_sleep_2348 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<unsigned long int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_sleep_2348 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned long int arg1 = args.read<unsigned long int > ();
  QThread_Adaptor::fp_QThread_sleep_2348 (arg1);
}

static qt_gsi::GenericStaticMethod*_create_fp_sleep_2348 ()
{
  return new qt_gsi::GenericStaticMethod("*sleep", "@brief Method void QThread::sleep(unsigned long int)\nThis method is protected and can only be called from inside a derived class.", &_init_fp_sleep_2348, &_call_fp_sleep_2348);
}


// void QThread::usleep(unsigned long int)

static void _init_fp_usleep_2348 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<unsigned long int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_usleep_2348 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned long int arg1 = args.read<unsigned long int > ();
  QThread_Adaptor::fp_QThread_usleep_2348 (arg1);
}

static qt_gsi::GenericStaticMethod*_create_fp_usleep_2348 ()
{
  return new qt_gsi::GenericStaticMethod("*usleep", "@brief Method void QThread::usleep(unsigned long int)\nThis method is protected and can only be called from inside a derived class.", &_init_fp_usleep_2348, &_call_fp_usleep_2348);
}


// bool QThread::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QThread_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QThread::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QThread::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QThread_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QThread::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QThread::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QThread_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QThread::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QThread::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QThread_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QThread::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QThread::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QThread_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QThread::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QThread::run()

static void _init_cbs_run_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_run_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QThread_Adaptor *)cls)->cbs_run_0_0 ();
}

static void _set_callback_cbs_run_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_run_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_run_0_0 ()
{
  return new qt_gsi::GenericMethod ("*run", "@hide", false, &_init_cbs_run_0_0, &_call_cbs_run_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_run_0_0 ()
{
  return new qt_gsi::GenericMethod ("*run", "@brief Virtual method void QThread::run()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_run_0_0, &_call_cbs_run_0_0, &_set_callback_cbs_run_0_0);
}


// void QThread::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QThread_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QThread::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QThread> decl_QThread;

gsi::Class<QThread_Adaptor> decl_QThread_Adaptor (decl_QThread, "QThread",
  gsi::Methods(_create_fp_exec_0 ()) +
  gsi::Methods(_create_fp_msleep_2348 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_setTerminationEnabled_864 ()) +
  gsi::Methods(_create_fp_sleep_2348 ()) +
  gsi::Methods(_create_fp_usleep_2348 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_run_0_0 ()) +
  gsi::Methods(_create_callback_cbs_run_0_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QThread_Adaptor_1302 ()),
  "@qt\n@brief Binding of QThread");

}


//  Implementation of the enum wrapper class for QThread::Priority
namespace qt_gsi
{

static QThread_Priority_Enum *c_1_QThread_Priority_Enum () { return new QThread_Priority_Enum (QThread::IdlePriority); }
static QThread_Priority_Enum *c_2_QThread_Priority_Enum () { return new QThread_Priority_Enum (QThread::LowestPriority); }
static QThread_Priority_Enum *c_3_QThread_Priority_Enum () { return new QThread_Priority_Enum (QThread::LowPriority); }
static QThread_Priority_Enum *c_4_QThread_Priority_Enum () { return new QThread_Priority_Enum (QThread::NormalPriority); }
static QThread_Priority_Enum *c_5_QThread_Priority_Enum () { return new QThread_Priority_Enum (QThread::HighPriority); }
static QThread_Priority_Enum *c_6_QThread_Priority_Enum () { return new QThread_Priority_Enum (QThread::HighestPriority); }
static QThread_Priority_Enum *c_7_QThread_Priority_Enum () { return new QThread_Priority_Enum (QThread::TimeCriticalPriority); }
static QThread_Priority_Enum *c_8_QThread_Priority_Enum () { return new QThread_Priority_Enum (QThread::InheritPriority); }

static gsi::Methods mkdefs_QThread_Priority () {
  return
    gsi::constant ("IdlePriority", &qt_gsi::c_1_QThread_Priority_Enum, "@brief Enum constant QThread::IdlePriority") +
    gsi::constant ("LowestPriority", &qt_gsi::c_2_QThread_Priority_Enum, "@brief Enum constant QThread::LowestPriority") +
    gsi::constant ("LowPriority", &qt_gsi::c_3_QThread_Priority_Enum, "@brief Enum constant QThread::LowPriority") +
    gsi::constant ("NormalPriority", &qt_gsi::c_4_QThread_Priority_Enum, "@brief Enum constant QThread::NormalPriority") +
    gsi::constant ("HighPriority", &qt_gsi::c_5_QThread_Priority_Enum, "@brief Enum constant QThread::HighPriority") +
    gsi::constant ("HighestPriority", &qt_gsi::c_6_QThread_Priority_Enum, "@brief Enum constant QThread::HighestPriority") +
    gsi::constant ("TimeCriticalPriority", &qt_gsi::c_7_QThread_Priority_Enum, "@brief Enum constant QThread::TimeCriticalPriority") +
    gsi::constant ("InheritPriority", &qt_gsi::c_8_QThread_Priority_Enum, "@brief Enum constant QThread::InheritPriority");
}

static std::string to_s_QThread_Priority_Enum (const QThread_Priority_Enum *e)
{
  if (e->value () == QThread::IdlePriority) { return tl::sprintf ("IdlePriority (%u)", (unsigned int) e->value ()); }
  if (e->value () == QThread::LowestPriority) { return tl::sprintf ("LowestPriority (%u)", (unsigned int) e->value ()); }
  if (e->value () == QThread::LowPriority) { return tl::sprintf ("LowPriority (%u)", (unsigned int) e->value ()); }
  if (e->value () == QThread::NormalPriority) { return tl::sprintf ("NormalPriority (%u)", (unsigned int) e->value ()); }
  if (e->value () == QThread::HighPriority) { return tl::sprintf ("HighPriority (%u)", (unsigned int) e->value ()); }
  if (e->value () == QThread::HighestPriority) { return tl::sprintf ("HighestPriority (%u)", (unsigned int) e->value ()); }
  if (e->value () == QThread::TimeCriticalPriority) { return tl::sprintf ("TimeCriticalPriority (%u)", (unsigned int) e->value ()); }
  if (e->value () == QThread::InheritPriority) { return tl::sprintf ("InheritPriority (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QThread_Priority_Enum (const QThread_Priority_Enum *e)
{
  return (unsigned int) e->value ();
}

static QThread_Priority_Enum *from_i_QThread_Priority_Enum (unsigned int i)
{
  return new QThread_Priority_Enum ((QThread::Priority) i);
}

static bool equalQThread_Priority_Enum (const QThread_Priority_Enum *e, QThread_Priority_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QThread_Priority_Enum (const QThread_Priority_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QThread_Priority_Enums oropQThread_Priority_Enums (const QThread_Priority_Enums *e, const QThread_Priority_Enums &d)
{
  return e->flags () | d.flags ();
}

static QThread_Priority_Enums andopQThread_Priority_Enums (const QThread_Priority_Enums *e, const QThread_Priority_Enums &d)
{
  return e->flags () & d.flags ();
}

static QThread_Priority_Enums xoropQThread_Priority_Enums (const QThread_Priority_Enums *e, const QThread_Priority_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QThread_Priority_Enums (const QThread_Priority_Enums *e)
{
  std::string l;
  if (e->testFlag (QThread::IdlePriority)) { if (!l.empty ()) l += "|"; l += "IdlePriority"; }
  if (e->testFlag (QThread::LowestPriority)) { if (!l.empty ()) l += "|"; l += "LowestPriority"; }
  if (e->testFlag (QThread::LowPriority)) { if (!l.empty ()) l += "|"; l += "LowPriority"; }
  if (e->testFlag (QThread::NormalPriority)) { if (!l.empty ()) l += "|"; l += "NormalPriority"; }
  if (e->testFlag (QThread::HighPriority)) { if (!l.empty ()) l += "|"; l += "HighPriority"; }
  if (e->testFlag (QThread::HighestPriority)) { if (!l.empty ()) l += "|"; l += "HighestPriority"; }
  if (e->testFlag (QThread::TimeCriticalPriority)) { if (!l.empty ()) l += "|"; l += "TimeCriticalPriority"; }
  if (e->testFlag (QThread::InheritPriority)) { if (!l.empty ()) l += "|"; l += "InheritPriority"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QThread_Priority_Enums (const QThread_Priority_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QThread_Priority_Enums (const QThread_Priority_Enums *e, const QThread_Priority_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QThread_Priority_Enums> decl_QThread_Priority_Enums ("QThread_QFlags_Priority",
  gsi::method_ext ("|", &qt_gsi::oropQThread_Priority_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQThread_Priority_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQThread_Priority_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QThread_Priority_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QThread_Priority_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QThread_Priority_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QThread::Priority> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QThread_Priority_Enum> decl_QThread_Priority_Enum (decl_QThread_Priority_Enums, "QThread_Priority",
  qt_gsi::mkdefs_QThread_Priority () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QThread_Priority_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QThread_Priority_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQThread_Priority_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QThread_Priority_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QThread_Priority_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QThread::Priority enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QThread> inject_QThread_Priority_Enum_in_parent (qt_gsi::mkdefs_QThread_Priority ());
static gsi::ClassExt<QThread> decl_QThread_Priority_Enum_as_child (decl_QThread_Priority_Enum, "Priority");

}

