
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextList.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTextList_EventAdaptor.h"
#include "gsiDeclQTextList_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextList

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTextList::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QTextList::add(const QTextBlock &block)


static void _init_f_add_2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_add_2306 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ((QTextList *)cls)->add (arg1);
}

static qt_gsi::GenericMethod *_create_f_add_2306 ()
{
  return new qt_gsi::GenericMethod ("add", "@brief Method void QTextList::add(const QTextBlock &block)\n", false, &_init_f_add_2306, &_call_f_add_2306);
}

// int QTextList::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextList *)cls)->count ());
}

static qt_gsi::GenericMethod *_create_f_count_c0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Method int QTextList::count()\n", true, &_init_f_count_c0, &_call_f_count_c0);
}

// QTextListFormat QTextList::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextListFormat > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextListFormat > ((QTextListFormat)((QTextList *)cls)->format ());
}

static qt_gsi::GenericMethod *_create_f_format_c0 ()
{
  return new qt_gsi::GenericMethod (":format", "@brief Method QTextListFormat QTextList::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
}

// bool QTextList::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextList *)cls)->isEmpty ());
}

static qt_gsi::GenericMethod *_create_f_isEmpty_c0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QTextList::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
}

// QTextBlock QTextList::item(int i)


static void _init_f_item_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextBlock > ();
}

static void _call_f_item_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextBlock > ((QTextBlock)((QTextList *)cls)->item (arg1));
}

static qt_gsi::GenericMethod *_create_f_item_c767 ()
{
  return new qt_gsi::GenericMethod ("item", "@brief Method QTextBlock QTextList::item(int i)\n", true, &_init_f_item_c767, &_call_f_item_c767);
}

// int QTextList::itemNumber(const QTextBlock &)


static void _init_f_itemNumber_c2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_itemNumber_c2306 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ret.write<int > ((int)((QTextList *)cls)->itemNumber (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemNumber_c2306 ()
{
  return new qt_gsi::GenericMethod ("itemNumber", "@brief Method int QTextList::itemNumber(const QTextBlock &)\n", true, &_init_f_itemNumber_c2306, &_call_f_itemNumber_c2306);
}

// QString QTextList::itemText(const QTextBlock &)


static void _init_f_itemText_c2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_itemText_c2306 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ret.write<QString > ((QString)((QTextList *)cls)->itemText (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemText_c2306 ()
{
  return new qt_gsi::GenericMethod ("itemText", "@brief Method QString QTextList::itemText(const QTextBlock &)\n", true, &_init_f_itemText_c2306, &_call_f_itemText_c2306);
}

// void QTextList::remove(const QTextBlock &)


static void _init_f_remove_2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_remove_2306 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ((QTextList *)cls)->remove (arg1);
}

static qt_gsi::GenericMethod *_create_f_remove_2306 ()
{
  return new qt_gsi::GenericMethod ("remove", "@brief Method void QTextList::remove(const QTextBlock &)\n", false, &_init_f_remove_2306, &_call_f_remove_2306);
}

// void QTextList::removeItem(int i)


static void _init_f_removeItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTextList *)cls)->removeItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeItem_767 ()
{
  return new qt_gsi::GenericMethod ("removeItem", "@brief Method void QTextList::removeItem(int i)\n", false, &_init_f_removeItem_767, &_call_f_removeItem_767);
}

// void QTextList::setFormat(const QTextListFormat &format)


static void _init_f_setFormat_2844 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextListFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_2844 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextListFormat &arg1 = args.read<const QTextListFormat & > ();
  ((QTextList *)cls)->setFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFormat_2844 ()
{
  return new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QTextList::setFormat(const QTextListFormat &format)\n", false, &_init_f_setFormat_2844, &_call_f_setFormat_2844);
}

// static QString QTextList::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTextList::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTextList::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QTextList::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTextList::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTextList::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QTextList::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTextList::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTextList::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QTextList::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTextList::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTextList::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QTextList, QTextList_EventAdaptor> ea_QTextList;

namespace gsi
{
extern gsi::Class<QTextBlockGroup> decl_QTextBlockGroup;

gsi::Class<QTextList> decl_QTextList (ea_QTextList, decl_QTextBlockGroup, "QTextList_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_add_2306 ()) +
  gsi::Methods(_create_f_count_c0 ()) +
  gsi::Methods(_create_f_format_c0 ()) +
  gsi::Methods(_create_f_isEmpty_c0 ()) +
  gsi::Methods(_create_f_item_c767 ()) +
  gsi::Methods(_create_f_itemNumber_c2306 ()) +
  gsi::Methods(_create_f_itemText_c2306 ()) +
  gsi::Methods(_create_f_remove_2306 ()) +
  gsi::Methods(_create_f_removeItem_767 ()) +
  gsi::Methods(_create_f_setFormat_2844 ()) +
  qt_gsi::qt_signal<QTextList, QTextList_EventAdaptor, QObject *> ("destroyed", &QTextList_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QTextList::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QTextList");
}


class QTextList_Adaptor : public QTextList, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTextList_Adaptor();

  //  [adaptor ctor] QTextList::QTextList(QTextDocument *doc)
  QTextList_Adaptor(QTextDocument *doc) : QTextList(doc)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  QList<QTextBlock> QTextList::blockList()
  qt_gsi::Converter<QList<QTextBlock> >::target_type fp_QTextList_blockList_c0 () const {
    return qt_gsi::CppToQtAdaptor<QList<QTextBlock> >(QTextList::blockList());
  }

  //  int QTextList::receivers(const char *signal)
  int fp_QTextList_receivers_c1731 (const char *signal) const {
    return QTextList::receivers(signal);
  }

  //  QObject *QTextList::sender()
  QObject * fp_QTextList_sender_c0 () const {
    return QTextList::sender();
  }

  //  [adaptor impl] bool QTextList::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QTextList::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTextList_Adaptor, bool, QEvent *>(&QTextList_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QTextList::event(arg1);
    }
  }

  //  [adaptor impl] bool QTextList::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QTextList::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTextList_Adaptor, bool, QObject *, QEvent *>(&QTextList_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QTextList::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QTextList::blockFormatChanged(const QTextBlock &block)
  void cbs_blockFormatChanged_2306_0(const QTextBlock &block)
  {
    QTextList::blockFormatChanged(block);
  }

  virtual void blockFormatChanged(const QTextBlock &block)
  {
    if (cb_blockFormatChanged_2306_0.can_issue()) {
      cb_blockFormatChanged_2306_0.issue<QTextList_Adaptor, const QTextBlock &>(&QTextList_Adaptor::cbs_blockFormatChanged_2306_0, block);
    } else {
      QTextList::blockFormatChanged(block);
    }
  }

  //  [adaptor impl] void QTextList::blockInserted(const QTextBlock &block)
  void cbs_blockInserted_2306_0(const QTextBlock &block)
  {
    QTextList::blockInserted(block);
  }

  virtual void blockInserted(const QTextBlock &block)
  {
    if (cb_blockInserted_2306_0.can_issue()) {
      cb_blockInserted_2306_0.issue<QTextList_Adaptor, const QTextBlock &>(&QTextList_Adaptor::cbs_blockInserted_2306_0, block);
    } else {
      QTextList::blockInserted(block);
    }
  }

  //  [adaptor impl] void QTextList::blockRemoved(const QTextBlock &block)
  void cbs_blockRemoved_2306_0(const QTextBlock &block)
  {
    QTextList::blockRemoved(block);
  }

  virtual void blockRemoved(const QTextBlock &block)
  {
    if (cb_blockRemoved_2306_0.can_issue()) {
      cb_blockRemoved_2306_0.issue<QTextList_Adaptor, const QTextBlock &>(&QTextList_Adaptor::cbs_blockRemoved_2306_0, block);
    } else {
      QTextList::blockRemoved(block);
    }
  }

  //  [adaptor impl] void QTextList::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QTextList::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTextList_Adaptor, QChildEvent *>(&QTextList_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QTextList::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextList::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QTextList::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTextList_Adaptor, QEvent *>(&QTextList_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QTextList::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextList::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QTextList::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QTextList_Adaptor, const char *>(&QTextList_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QTextList::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QTextList::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QTextList::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTextList_Adaptor, QTimerEvent *>(&QTextList_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QTextList::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_blockFormatChanged_2306_0;
  gsi::Callback cb_blockInserted_2306_0;
  gsi::Callback cb_blockRemoved_2306_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QTextList_Adaptor::~QTextList_Adaptor() { }

//  Constructor QTextList::QTextList(QTextDocument *doc) (adaptor class)

static void _init_ctor_QTextList_Adaptor_1955 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("doc");
  decl->add_arg<QTextDocument * > (argspec_0);
  decl->set_return_new<QTextList_Adaptor *> ();
}

static void _call_ctor_QTextList_Adaptor_1955 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextDocument *arg1 = args.read<QTextDocument * > ();
  ret.write<QTextList_Adaptor *> (new QTextList_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextList_Adaptor_1955 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextList::QTextList(QTextDocument *doc)\nThis method creates an object of class QTextList.", &_init_ctor_QTextList_Adaptor_1955, &_call_ctor_QTextList_Adaptor_1955);
}

// QList<QTextBlock> QTextList::blockList()

static void _init_fp_blockList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QTextBlock> >::target_type > ();
}

static void _call_fp_blockList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QTextBlock> >::target_type > ((qt_gsi::Converter<QList<QTextBlock> >::target_type)((QTextList_Adaptor *)cls)->fp_QTextList_blockList_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_blockList_c0 ()
{
  return new qt_gsi::GenericMethod("*blockList", "@brief Method QList<QTextBlock> QTextList::blockList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_blockList_c0, &_call_fp_blockList_c0);
}


// int QTextList::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QTextList_Adaptor *)cls)->fp_QTextList_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QTextList::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QTextList::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QTextList_Adaptor *)cls)->fp_QTextList_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QTextList::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QTextList::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTextList_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextList_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QTextList::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QTextList::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTextList_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextList_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTextList::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QTextList::blockFormatChanged(const QTextBlock &block)

static void _init_cbs_blockFormatChanged_2306_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_blockFormatChanged_2306_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ((QTextList_Adaptor *)cls)->cbs_blockFormatChanged_2306_0 (arg1);
}

static void _set_callback_cbs_blockFormatChanged_2306_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextList_Adaptor *)cls)->cb_blockFormatChanged_2306_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_blockFormatChanged_2306_0 ()
{
  return new qt_gsi::GenericMethod ("*blockFormatChanged", "@hide", false, &_init_cbs_blockFormatChanged_2306_0, &_call_cbs_blockFormatChanged_2306_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_blockFormatChanged_2306_0 ()
{
  return new qt_gsi::GenericMethod ("*blockFormatChanged", "@brief Virtual method void QTextList::blockFormatChanged(const QTextBlock &block)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_blockFormatChanged_2306_0, &_call_cbs_blockFormatChanged_2306_0, &_set_callback_cbs_blockFormatChanged_2306_0);
}


// void QTextList::blockInserted(const QTextBlock &block)

static void _init_cbs_blockInserted_2306_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_blockInserted_2306_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ((QTextList_Adaptor *)cls)->cbs_blockInserted_2306_0 (arg1);
}

static void _set_callback_cbs_blockInserted_2306_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextList_Adaptor *)cls)->cb_blockInserted_2306_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_blockInserted_2306_0 ()
{
  return new qt_gsi::GenericMethod ("*blockInserted", "@hide", false, &_init_cbs_blockInserted_2306_0, &_call_cbs_blockInserted_2306_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_blockInserted_2306_0 ()
{
  return new qt_gsi::GenericMethod ("*blockInserted", "@brief Virtual method void QTextList::blockInserted(const QTextBlock &block)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_blockInserted_2306_0, &_call_cbs_blockInserted_2306_0, &_set_callback_cbs_blockInserted_2306_0);
}


// void QTextList::blockRemoved(const QTextBlock &block)

static void _init_cbs_blockRemoved_2306_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_blockRemoved_2306_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ((QTextList_Adaptor *)cls)->cbs_blockRemoved_2306_0 (arg1);
}

static void _set_callback_cbs_blockRemoved_2306_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextList_Adaptor *)cls)->cb_blockRemoved_2306_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_blockRemoved_2306_0 ()
{
  return new qt_gsi::GenericMethod ("*blockRemoved", "@hide", false, &_init_cbs_blockRemoved_2306_0, &_call_cbs_blockRemoved_2306_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_blockRemoved_2306_0 ()
{
  return new qt_gsi::GenericMethod ("*blockRemoved", "@brief Virtual method void QTextList::blockRemoved(const QTextBlock &block)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_blockRemoved_2306_0, &_call_cbs_blockRemoved_2306_0, &_set_callback_cbs_blockRemoved_2306_0);
}


// void QTextList::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QTextList_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextList_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTextList::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QTextList::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QTextList_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextList_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTextList::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QTextList::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QTextList_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextList_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTextList::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QTextList::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QTextList_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextList_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTextList::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QTextList> decl_QTextList;

gsi::Class<QTextList_Adaptor> decl_QTextList_Adaptor (decl_QTextList, "QTextList",
  gsi::Methods(_create_fp_blockList_c0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_blockFormatChanged_2306_0 ()) +
  gsi::Methods(_create_callback_cbs_blockFormatChanged_2306_0 ()) +
  gsi::Methods(_create_cbs_blockInserted_2306_0 ()) +
  gsi::Methods(_create_callback_cbs_blockInserted_2306_0 ()) +
  gsi::Methods(_create_cbs_blockRemoved_2306_0 ()) +
  gsi::Methods(_create_callback_cbs_blockRemoved_2306_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QTextList_Adaptor_1955 ()),
  "@qt\n@brief Binding of QTextList");

}

