
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQStyledItemDelegate.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQStyledItemDelegate_EventAdaptor.h"
#include "gsiDeclQStyledItemDelegate_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QStyledItemDelegate

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QStyledItemDelegate::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QWidget *QStyledItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_createEditor_c6860 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_f_createEditor_c6860 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<QWidget * > ((QWidget *)((QStyledItemDelegate *)cls)->createEditor (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_createEditor_c6860 ()
{
  return new qt_gsi::GenericMethod ("createEditor", "@brief Method QWidget *QStyledItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::createEditor", true, &_init_f_createEditor_c6860, &_call_f_createEditor_c6860);
}

// QString QStyledItemDelegate::displayText(const QVariant &value, const QLocale &locale)


static void _init_f_displayText_c3997 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QVariant & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("locale");
  decl->add_arg<const QLocale & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_displayText_c3997 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  const QLocale &arg2 = args.read<const QLocale & > ();
  ret.write<QString > ((QString)((QStyledItemDelegate *)cls)->displayText (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_displayText_c3997 ()
{
  return new qt_gsi::GenericMethod ("displayText", "@brief Method QString QStyledItemDelegate::displayText(const QVariant &value, const QLocale &locale)\n", true, &_init_f_displayText_c3997, &_call_f_displayText_c3997);
}

// QItemEditorFactory *QStyledItemDelegate::itemEditorFactory()


static void _init_f_itemEditorFactory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QItemEditorFactory * > ();
}

static void _call_f_itemEditorFactory_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QItemEditorFactory * > ((QItemEditorFactory *)((QStyledItemDelegate *)cls)->itemEditorFactory ());
}

static qt_gsi::GenericMethod *_create_f_itemEditorFactory_c0 ()
{
  return new qt_gsi::GenericMethod (":itemEditorFactory", "@brief Method QItemEditorFactory *QStyledItemDelegate::itemEditorFactory()\n", true, &_init_f_itemEditorFactory_c0, &_call_f_itemEditorFactory_c0);
}

// void QStyledItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_paint_c6971 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paint_c6971 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QStyledItemDelegate *)cls)->paint (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_paint_c6971 ()
{
  return new qt_gsi::GenericMethod ("paint", "@brief Method void QStyledItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::paint", true, &_init_f_paint_c6971, &_call_f_paint_c6971);
}

// void QStyledItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)


static void _init_f_setEditorData_c3602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setEditorData_c3602 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QStyledItemDelegate *)cls)->setEditorData (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setEditorData_c3602 ()
{
  return new qt_gsi::GenericMethod ("setEditorData", "@brief Method void QStyledItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::setEditorData", true, &_init_f_setEditorData_c3602, &_call_f_setEditorData_c3602);
}

// void QStyledItemDelegate::setItemEditorFactory(QItemEditorFactory *factory)


static void _init_f_setItemEditorFactory_2445 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("factory");
  decl->add_arg<QItemEditorFactory * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemEditorFactory_2445 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QItemEditorFactory *arg1 = args.read<QItemEditorFactory * > ();
  ((QStyledItemDelegate *)cls)->setItemEditorFactory (arg1);
}

static qt_gsi::GenericMethod *_create_f_setItemEditorFactory_2445 ()
{
  return new qt_gsi::GenericMethod ("setItemEditorFactory|itemEditorFactory=", "@brief Method void QStyledItemDelegate::setItemEditorFactory(QItemEditorFactory *factory)\n", false, &_init_f_setItemEditorFactory_2445, &_call_f_setItemEditorFactory_2445);
}

// void QStyledItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)


static void _init_f_setModelData_c5913 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setModelData_c5913 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  QAbstractItemModel *arg2 = args.read<QAbstractItemModel * > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QStyledItemDelegate *)cls)->setModelData (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setModelData_c5913 ()
{
  return new qt_gsi::GenericMethod ("setModelData", "@brief Method void QStyledItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::setModelData", true, &_init_f_setModelData_c5913, &_call_f_setModelData_c5913);
}

// QSize QStyledItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_sizeHint_c5653 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c5653 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QStyleOptionViewItem &arg1 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ret.write<QSize > ((QSize)((QStyledItemDelegate *)cls)->sizeHint (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c5653 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Method QSize QStyledItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::sizeHint", true, &_init_f_sizeHint_c5653, &_call_f_sizeHint_c5653);
}

// void QStyledItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_updateEditorGeometry_c6860 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_updateEditorGeometry_c6860 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QStyledItemDelegate *)cls)->updateEditorGeometry (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_updateEditorGeometry_c6860 ()
{
  return new qt_gsi::GenericMethod ("updateEditorGeometry", "@brief Method void QStyledItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::updateEditorGeometry", true, &_init_f_updateEditorGeometry_c6860, &_call_f_updateEditorGeometry_c6860);
}

// static QString QStyledItemDelegate::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QStyledItemDelegate::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStyledItemDelegate::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QStyledItemDelegate::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QStyledItemDelegate::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStyledItemDelegate::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QStyledItemDelegate::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QStyledItemDelegate::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStyledItemDelegate::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QStyledItemDelegate::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QStyledItemDelegate::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStyledItemDelegate::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QStyledItemDelegate, QStyledItemDelegate_EventAdaptor> ea_QStyledItemDelegate;

namespace gsi
{
extern gsi::Class<QAbstractItemDelegate> decl_QAbstractItemDelegate;

gsi::Class<QStyledItemDelegate> decl_QStyledItemDelegate (ea_QStyledItemDelegate, decl_QAbstractItemDelegate, "QStyledItemDelegate_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_createEditor_c6860 ()) +
  gsi::Methods(_create_f_displayText_c3997 ()) +
  gsi::Methods(_create_f_itemEditorFactory_c0 ()) +
  gsi::Methods(_create_f_paint_c6971 ()) +
  gsi::Methods(_create_f_setEditorData_c3602 ()) +
  gsi::Methods(_create_f_setItemEditorFactory_2445 ()) +
  gsi::Methods(_create_f_setModelData_c5913 ()) +
  gsi::Methods(_create_f_sizeHint_c5653 ()) +
  gsi::Methods(_create_f_updateEditorGeometry_c6860 ()) +
  qt_gsi::qt_signal<QStyledItemDelegate, QStyledItemDelegate_EventAdaptor, QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type &> ("closeEditor", &QStyledItemDelegate_EventAdaptor::closeEditor_e_4926, gsi::arg("editor"), gsi::arg("hint"), "@brief Signal declaration for QStyledItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStyledItemDelegate, QStyledItemDelegate_EventAdaptor, QWidget *> ("commitData", &QStyledItemDelegate_EventAdaptor::commitData_e_1315, gsi::arg("editor"), "@brief Signal declaration for QStyledItemDelegate::commitData(QWidget *editor)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStyledItemDelegate, QStyledItemDelegate_EventAdaptor, QObject *> ("destroyed", &QStyledItemDelegate_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QStyledItemDelegate::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStyledItemDelegate, QStyledItemDelegate_EventAdaptor, const QModelIndex &> ("sizeHintChanged", &QStyledItemDelegate_EventAdaptor::sizeHintChanged_e_2395, gsi::arg("arg1"), "@brief Signal declaration for QStyledItemDelegate::sizeHintChanged(const QModelIndex &)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QStyledItemDelegate");
}


class QStyledItemDelegate_Adaptor : public QStyledItemDelegate, public qt_gsi::QtObjectBase
{
public:

  virtual ~QStyledItemDelegate_Adaptor();

  //  [adaptor ctor] QStyledItemDelegate::QStyledItemDelegate(QObject *parent)
  QStyledItemDelegate_Adaptor() : QStyledItemDelegate()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStyledItemDelegate::QStyledItemDelegate(QObject *parent)
  QStyledItemDelegate_Adaptor(QObject *parent) : QStyledItemDelegate(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QStyledItemDelegate::receivers(const char *signal)
  int fp_QStyledItemDelegate_receivers_c1731 (const char *signal) const {
    return QStyledItemDelegate::receivers(signal);
  }

  //  QObject *QStyledItemDelegate::sender()
  QObject * fp_QStyledItemDelegate_sender_c0 () const {
    return QStyledItemDelegate::sender();
  }

  //  [adaptor impl] QWidget *QStyledItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)
  QWidget * cbs_createEditor_c6860_0(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    return QStyledItemDelegate::createEditor(parent, option, index);
  }

  virtual QWidget * createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_createEditor_c6860_0.can_issue()) {
      return cb_createEditor_c6860_0.issue<QStyledItemDelegate_Adaptor, QWidget *, QWidget *, const QStyleOptionViewItem &, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_createEditor_c6860_0, parent, option, index);
    } else {
      return QStyledItemDelegate::createEditor(parent, option, index);
    }
  }

  //  [adaptor impl] QString QStyledItemDelegate::displayText(const QVariant &value, const QLocale &locale)
  QString cbs_displayText_c3997_0(const QVariant &value, const QLocale &locale) const
  {
    return QStyledItemDelegate::displayText(value, locale);
  }

  virtual QString displayText(const QVariant &value, const QLocale &locale) const
  {
    if (cb_displayText_c3997_0.can_issue()) {
      return cb_displayText_c3997_0.issue<QStyledItemDelegate_Adaptor, QString, const QVariant &, const QLocale &>(&QStyledItemDelegate_Adaptor::cbs_displayText_c3997_0, value, locale);
    } else {
      return QStyledItemDelegate::displayText(value, locale);
    }
  }

  //  [adaptor impl] bool QStyledItemDelegate::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QStyledItemDelegate::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QStyledItemDelegate_Adaptor, bool, QEvent *>(&QStyledItemDelegate_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QStyledItemDelegate::event(arg1);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)
  void cbs_paint_c6971_0(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    QStyledItemDelegate::paint(painter, option, index);
  }

  virtual void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_paint_c6971_0.can_issue()) {
      cb_paint_c6971_0.issue<QStyledItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_paint_c6971_0, painter, option, index);
    } else {
      QStyledItemDelegate::paint(painter, option, index);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)
  void cbs_setEditorData_c3602_0(QWidget *editor, const QModelIndex &index) const
  {
    QStyledItemDelegate::setEditorData(editor, index);
  }

  virtual void setEditorData(QWidget *editor, const QModelIndex &index) const
  {
    if (cb_setEditorData_c3602_0.can_issue()) {
      cb_setEditorData_c3602_0.issue<QStyledItemDelegate_Adaptor, QWidget *, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_setEditorData_c3602_0, editor, index);
    } else {
      QStyledItemDelegate::setEditorData(editor, index);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)
  void cbs_setModelData_c5913_0(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
  {
    QStyledItemDelegate::setModelData(editor, model, index);
  }

  virtual void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
  {
    if (cb_setModelData_c5913_0.can_issue()) {
      cb_setModelData_c5913_0.issue<QStyledItemDelegate_Adaptor, QWidget *, QAbstractItemModel *, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_setModelData_c5913_0, editor, model, index);
    } else {
      QStyledItemDelegate::setModelData(editor, model, index);
    }
  }

  //  [adaptor impl] QSize QStyledItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)
  QSize cbs_sizeHint_c5653_0(const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    return QStyledItemDelegate::sizeHint(option, index);
  }

  virtual QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_sizeHint_c5653_0.can_issue()) {
      return cb_sizeHint_c5653_0.issue<QStyledItemDelegate_Adaptor, QSize, const QStyleOptionViewItem &, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_sizeHint_c5653_0, option, index);
    } else {
      return QStyledItemDelegate::sizeHint(option, index);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)
  void cbs_updateEditorGeometry_c6860_0(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    QStyledItemDelegate::updateEditorGeometry(editor, option, index);
  }

  virtual void updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_updateEditorGeometry_c6860_0.can_issue()) {
      cb_updateEditorGeometry_c6860_0.issue<QStyledItemDelegate_Adaptor, QWidget *, const QStyleOptionViewItem &, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_updateEditorGeometry_c6860_0, editor, option, index);
    } else {
      QStyledItemDelegate::updateEditorGeometry(editor, option, index);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QStyledItemDelegate::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QStyledItemDelegate_Adaptor, QChildEvent *>(&QStyledItemDelegate_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QStyledItemDelegate::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QStyledItemDelegate::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QStyledItemDelegate_Adaptor, QEvent *>(&QStyledItemDelegate_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QStyledItemDelegate::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QStyledItemDelegate::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QStyledItemDelegate_Adaptor, const char *>(&QStyledItemDelegate_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QStyledItemDelegate::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QStyledItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  bool cbs_editorEvent_9073_0(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    return QStyledItemDelegate::editorEvent(event, model, option, index);
  }

  virtual bool editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    if (cb_editorEvent_9073_0.can_issue()) {
      return cb_editorEvent_9073_0.issue<QStyledItemDelegate_Adaptor, bool, QEvent *, QAbstractItemModel *, const QStyleOptionViewItem &, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_editorEvent_9073_0, event, model, option, index);
    } else {
      return QStyledItemDelegate::editorEvent(event, model, option, index);
    }
  }

  //  [adaptor impl] bool QStyledItemDelegate::eventFilter(QObject *object, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *object, QEvent *event)
  {
    return QStyledItemDelegate::eventFilter(object, event);
  }

  virtual bool eventFilter(QObject *object, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QStyledItemDelegate_Adaptor, bool, QObject *, QEvent *>(&QStyledItemDelegate_Adaptor::cbs_eventFilter_2411_0, object, event);
    } else {
      return QStyledItemDelegate::eventFilter(object, event);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::initStyleOption(QStyleOptionViewItem *option, const QModelIndex &index)
  void cbs_initStyleOption_c4962_0(QStyleOptionViewItem *option, const QModelIndex &index) const
  {
    QStyledItemDelegate::initStyleOption(option, index);
  }

  virtual void initStyleOption(QStyleOptionViewItem *option, const QModelIndex &index) const
  {
    if (cb_initStyleOption_c4962_0.can_issue()) {
      cb_initStyleOption_c4962_0.issue<QStyledItemDelegate_Adaptor, QStyleOptionViewItem *, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_initStyleOption_c4962_0, option, index);
    } else {
      QStyledItemDelegate::initStyleOption(option, index);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QStyledItemDelegate::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QStyledItemDelegate_Adaptor, QTimerEvent *>(&QStyledItemDelegate_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QStyledItemDelegate::timerEvent(arg1);
    }
  }

  gsi::Callback cb_createEditor_c6860_0;
  gsi::Callback cb_displayText_c3997_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_paint_c6971_0;
  gsi::Callback cb_setEditorData_c3602_0;
  gsi::Callback cb_setModelData_c5913_0;
  gsi::Callback cb_sizeHint_c5653_0;
  gsi::Callback cb_updateEditorGeometry_c6860_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_editorEvent_9073_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_initStyleOption_c4962_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QStyledItemDelegate_Adaptor::~QStyledItemDelegate_Adaptor() { }

//  Constructor QStyledItemDelegate::QStyledItemDelegate(QObject *parent) (adaptor class)

static void _init_ctor_QStyledItemDelegate_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QStyledItemDelegate_Adaptor *> ();
}

static void _call_ctor_QStyledItemDelegate_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QStyledItemDelegate_Adaptor *> (new QStyledItemDelegate_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QStyledItemDelegate_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStyledItemDelegate::QStyledItemDelegate(QObject *parent)\nThis method creates an object of class QStyledItemDelegate.", &_init_ctor_QStyledItemDelegate_Adaptor_1302, &_call_ctor_QStyledItemDelegate_Adaptor_1302);
}

// int QStyledItemDelegate::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QStyledItemDelegate_Adaptor *)cls)->fp_QStyledItemDelegate_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QStyledItemDelegate::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QStyledItemDelegate::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QStyledItemDelegate_Adaptor *)cls)->fp_QStyledItemDelegate_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QStyledItemDelegate::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QWidget *QStyledItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_createEditor_c6860_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_cbs_createEditor_c6860_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<QWidget * > ((QWidget *)((QStyledItemDelegate_Adaptor *)cls)->cbs_createEditor_c6860_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_createEditor_c6860_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_createEditor_c6860_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_createEditor_c6860_0 ()
{
  return new qt_gsi::GenericMethod ("createEditor", "@hide", true, &_init_cbs_createEditor_c6860_0, &_call_cbs_createEditor_c6860_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_createEditor_c6860_0 ()
{
  return new qt_gsi::GenericMethod ("createEditor", "@brief Virtual method QWidget *QStyledItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_createEditor_c6860_0, &_call_cbs_createEditor_c6860_0, &_set_callback_cbs_createEditor_c6860_0);
}


// QString QStyledItemDelegate::displayText(const QVariant &value, const QLocale &locale)

static void _init_cbs_displayText_c3997_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QVariant & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("locale");
  decl->add_arg<const QLocale & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_cbs_displayText_c3997_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  const QLocale &arg2 = args.read<const QLocale & > ();
  ret.write<QString > ((QString)((QStyledItemDelegate_Adaptor *)cls)->cbs_displayText_c3997_0 (arg1, arg2));
}

static void _set_callback_cbs_displayText_c3997_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_displayText_c3997_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_displayText_c3997_0 ()
{
  return new qt_gsi::GenericMethod ("displayText", "@hide", true, &_init_cbs_displayText_c3997_0, &_call_cbs_displayText_c3997_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_displayText_c3997_0 ()
{
  return new qt_gsi::GenericMethod ("displayText", "@brief Virtual method QString QStyledItemDelegate::displayText(const QVariant &value, const QLocale &locale)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_displayText_c3997_0, &_call_cbs_displayText_c3997_0, &_set_callback_cbs_displayText_c3997_0);
}


// bool QStyledItemDelegate::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QStyledItemDelegate_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QStyledItemDelegate::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QStyledItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_paint_c6971_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_c6971_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_paint_c6971_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_c6971_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_paint_c6971_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paint_c6971_0 ()
{
  return new qt_gsi::GenericMethod ("paint", "@hide", true, &_init_cbs_paint_c6971_0, &_call_cbs_paint_c6971_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paint_c6971_0 ()
{
  return new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QStyledItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paint_c6971_0, &_call_cbs_paint_c6971_0, &_set_callback_cbs_paint_c6971_0);
}


// void QStyledItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)

static void _init_cbs_setEditorData_c3602_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setEditorData_c3602_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_setEditorData_c3602_0 (arg1, arg2);
}

static void _set_callback_cbs_setEditorData_c3602_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_setEditorData_c3602_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setEditorData_c3602_0 ()
{
  return new qt_gsi::GenericMethod ("setEditorData", "@hide", true, &_init_cbs_setEditorData_c3602_0, &_call_cbs_setEditorData_c3602_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setEditorData_c3602_0 ()
{
  return new qt_gsi::GenericMethod ("setEditorData", "@brief Virtual method void QStyledItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_setEditorData_c3602_0, &_call_cbs_setEditorData_c3602_0, &_set_callback_cbs_setEditorData_c3602_0);
}


// void QStyledItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)

static void _init_cbs_setModelData_c5913_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_setModelData_c5913_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  QAbstractItemModel *arg2 = args.read<QAbstractItemModel * > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_setModelData_c5913_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_setModelData_c5913_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_setModelData_c5913_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setModelData_c5913_0 ()
{
  return new qt_gsi::GenericMethod ("setModelData", "@hide", true, &_init_cbs_setModelData_c5913_0, &_call_cbs_setModelData_c5913_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setModelData_c5913_0 ()
{
  return new qt_gsi::GenericMethod ("setModelData", "@brief Virtual method void QStyledItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_setModelData_c5913_0, &_call_cbs_setModelData_c5913_0, &_set_callback_cbs_setModelData_c5913_0);
}


// QSize QStyledItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_sizeHint_c5653_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c5653_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QStyleOptionViewItem &arg1 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ret.write<QSize > ((QSize)((QStyledItemDelegate_Adaptor *)cls)->cbs_sizeHint_c5653_0 (arg1, arg2));
}

static void _set_callback_cbs_sizeHint_c5653_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_sizeHint_c5653_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c5653_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c5653_0, &_call_cbs_sizeHint_c5653_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c5653_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QStyledItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c5653_0, &_call_cbs_sizeHint_c5653_0, &_set_callback_cbs_sizeHint_c5653_0);
}


// void QStyledItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_updateEditorGeometry_c6860_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometry_c6860_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_updateEditorGeometry_c6860_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_updateEditorGeometry_c6860_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_updateEditorGeometry_c6860_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateEditorGeometry_c6860_0 ()
{
  return new qt_gsi::GenericMethod ("updateEditorGeometry", "@hide", true, &_init_cbs_updateEditorGeometry_c6860_0, &_call_cbs_updateEditorGeometry_c6860_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateEditorGeometry_c6860_0 ()
{
  return new qt_gsi::GenericMethod ("updateEditorGeometry", "@brief Virtual method void QStyledItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_updateEditorGeometry_c6860_0, &_call_cbs_updateEditorGeometry_c6860_0, &_set_callback_cbs_updateEditorGeometry_c6860_0);
}


// void QStyledItemDelegate::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QStyledItemDelegate::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QStyledItemDelegate::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QStyledItemDelegate::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QStyledItemDelegate::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QStyledItemDelegate::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// bool QStyledItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_editorEvent_9073_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("index");
  decl->add_arg<const QModelIndex & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_editorEvent_9073_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  QAbstractItemModel *arg2 = args.read<QAbstractItemModel * > ();
  const QStyleOptionViewItem &arg3 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg4 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStyledItemDelegate_Adaptor *)cls)->cbs_editorEvent_9073_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_editorEvent_9073_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_editorEvent_9073_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_editorEvent_9073_0 ()
{
  return new qt_gsi::GenericMethod ("*editorEvent", "@hide", false, &_init_cbs_editorEvent_9073_0, &_call_cbs_editorEvent_9073_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_editorEvent_9073_0 ()
{
  return new qt_gsi::GenericMethod ("*editorEvent", "@brief Virtual method bool QStyledItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorEvent_9073_0, &_call_cbs_editorEvent_9073_0, &_set_callback_cbs_editorEvent_9073_0);
}


// bool QStyledItemDelegate::eventFilter(QObject *object, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QStyledItemDelegate_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QStyledItemDelegate::eventFilter(QObject *object, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QStyledItemDelegate::initStyleOption(QStyleOptionViewItem *option, const QModelIndex &index)

static void _init_cbs_initStyleOption_c4962_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionViewItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c4962_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyleOptionViewItem *arg1 = args.read<QStyleOptionViewItem * > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_initStyleOption_c4962_0 (arg1, arg2);
}

static void _set_callback_cbs_initStyleOption_c4962_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_initStyleOption_c4962_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_initStyleOption_c4962_0 ()
{
  return new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c4962_0, &_call_cbs_initStyleOption_c4962_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_initStyleOption_c4962_0 ()
{
  return new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QStyledItemDelegate::initStyleOption(QStyleOptionViewItem *option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c4962_0, &_call_cbs_initStyleOption_c4962_0, &_set_callback_cbs_initStyleOption_c4962_0);
}


// void QStyledItemDelegate::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QStyledItemDelegate::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QStyledItemDelegate> decl_QStyledItemDelegate;

gsi::Class<QStyledItemDelegate_Adaptor> decl_QStyledItemDelegate_Adaptor (decl_QStyledItemDelegate, "QStyledItemDelegate",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_createEditor_c6860_0 ()) +
  gsi::Methods(_create_callback_cbs_createEditor_c6860_0 ()) +
  gsi::Methods(_create_cbs_displayText_c3997_0 ()) +
  gsi::Methods(_create_callback_cbs_displayText_c3997_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_paint_c6971_0 ()) +
  gsi::Methods(_create_callback_cbs_paint_c6971_0 ()) +
  gsi::Methods(_create_cbs_setEditorData_c3602_0 ()) +
  gsi::Methods(_create_callback_cbs_setEditorData_c3602_0 ()) +
  gsi::Methods(_create_cbs_setModelData_c5913_0 ()) +
  gsi::Methods(_create_callback_cbs_setModelData_c5913_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c5653_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c5653_0 ()) +
  gsi::Methods(_create_cbs_updateEditorGeometry_c6860_0 ()) +
  gsi::Methods(_create_callback_cbs_updateEditorGeometry_c6860_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_editorEvent_9073_0 ()) +
  gsi::Methods(_create_callback_cbs_editorEvent_9073_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_initStyleOption_c4962_0 ()) +
  gsi::Methods(_create_callback_cbs_initStyleOption_c4962_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QStyledItemDelegate_Adaptor_1302 ()),
  "@qt\n@brief Binding of QStyledItemDelegate");

}

