
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSizeF.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSizeF_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSizeF

//  Constructor QSizeF::QSizeF()


static void _init_ctor_QSizeF_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QSizeF *> ();
}

static void _call_ctor_QSizeF_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSizeF *> (new QSizeF ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSizeF_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSizeF::QSizeF()\nThis method creates an object of class QSizeF.", &_init_ctor_QSizeF_0, &_call_ctor_QSizeF_0);
}

//  Constructor QSizeF::QSizeF(const QSize &sz)


static void _init_ctor_QSizeF_1805 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sz");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return_new<QSizeF *> ();
}

static void _call_ctor_QSizeF_1805 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ret.write<QSizeF *> (new QSizeF (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSizeF_1805 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSizeF::QSizeF(const QSize &sz)\nThis method creates an object of class QSizeF.", &_init_ctor_QSizeF_1805, &_call_ctor_QSizeF_1805);
}

//  Constructor QSizeF::QSizeF(double w, double h)


static void _init_ctor_QSizeF_2034 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<double > (argspec_1);
  decl->set_return_new<QSizeF *> ();
}

static void _call_ctor_QSizeF_2034 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QSizeF *> (new QSizeF (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSizeF_2034 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSizeF::QSizeF(double w, double h)\nThis method creates an object of class QSizeF.", &_init_ctor_QSizeF_2034, &_call_ctor_QSizeF_2034);
}

// QSizeF QSizeF::boundedTo(const QSizeF &)


static void _init_f_boundedTo_c1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<QSizeF > ();
}

static void _call_f_boundedTo_c1875 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSizeF &arg1 = args.read<const QSizeF & > ();
  ret.write<QSizeF > ((QSizeF)((QSizeF *)cls)->boundedTo (arg1));
}

static qt_gsi::GenericMethod *_create_f_boundedTo_c1875 ()
{
  return new qt_gsi::GenericMethod ("boundedTo", "@brief Method QSizeF QSizeF::boundedTo(const QSizeF &)\n", true, &_init_f_boundedTo_c1875, &_call_f_boundedTo_c1875);
}

// QSizeF QSizeF::expandedTo(const QSizeF &)


static void _init_f_expandedTo_c1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<QSizeF > ();
}

static void _call_f_expandedTo_c1875 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSizeF &arg1 = args.read<const QSizeF & > ();
  ret.write<QSizeF > ((QSizeF)((QSizeF *)cls)->expandedTo (arg1));
}

static qt_gsi::GenericMethod *_create_f_expandedTo_c1875 ()
{
  return new qt_gsi::GenericMethod ("expandedTo", "@brief Method QSizeF QSizeF::expandedTo(const QSizeF &)\n", true, &_init_f_expandedTo_c1875, &_call_f_expandedTo_c1875);
}

// double QSizeF::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QSizeF *)cls)->height ());
}

static qt_gsi::GenericMethod *_create_f_height_c0 ()
{
  return new qt_gsi::GenericMethod (":height", "@brief Method double QSizeF::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
}

// bool QSizeF::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSizeF *)cls)->isEmpty ());
}

static qt_gsi::GenericMethod *_create_f_isEmpty_c0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QSizeF::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
}

// bool QSizeF::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSizeF *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QSizeF::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// bool QSizeF::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSizeF *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QSizeF::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// QSizeF &QSizeF::operator*=(double c)


static void _init_f_operator_star__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QSizeF & > ();
}

static void _call_f_operator_star__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QSizeF & > ((QSizeF &)((QSizeF *)cls)->operator*= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_star__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("*=", "@brief Method QSizeF &QSizeF::operator*=(double c)\n", false, &_init_f_operator_star__eq__1071, &_call_f_operator_star__eq__1071);
}

// QSizeF &QSizeF::operator+=(const QSizeF &)


static void _init_f_operator_plus__eq__1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<QSizeF & > ();
}

static void _call_f_operator_plus__eq__1875 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSizeF &arg1 = args.read<const QSizeF & > ();
  ret.write<QSizeF & > ((QSizeF &)((QSizeF *)cls)->operator+= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_plus__eq__1875 ()
{
  return new qt_gsi::GenericMethod ("+=", "@brief Method QSizeF &QSizeF::operator+=(const QSizeF &)\n", false, &_init_f_operator_plus__eq__1875, &_call_f_operator_plus__eq__1875);
}

// QSizeF &QSizeF::operator-=(const QSizeF &)


static void _init_f_operator_minus__eq__1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<QSizeF & > ();
}

static void _call_f_operator_minus__eq__1875 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSizeF &arg1 = args.read<const QSizeF & > ();
  ret.write<QSizeF & > ((QSizeF &)((QSizeF *)cls)->operator-= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_minus__eq__1875 ()
{
  return new qt_gsi::GenericMethod ("-=", "@brief Method QSizeF &QSizeF::operator-=(const QSizeF &)\n", false, &_init_f_operator_minus__eq__1875, &_call_f_operator_minus__eq__1875);
}

// QSizeF &QSizeF::operator/=(double c)


static void _init_f_operator_slash__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QSizeF & > ();
}

static void _call_f_operator_slash__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QSizeF & > ((QSizeF &)((QSizeF *)cls)->operator/= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_slash__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("/=", "@brief Method QSizeF &QSizeF::operator/=(double c)\n", false, &_init_f_operator_slash__eq__1071, &_call_f_operator_slash__eq__1071);
}

// double &QSizeF::rheight()


static void _init_f_rheight_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double & > ();
}

static void _call_f_rheight_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double & > ((double &)((QSizeF *)cls)->rheight ());
}

static qt_gsi::GenericMethod *_create_f_rheight_0 ()
{
  return new qt_gsi::GenericMethod ("rheight", "@brief Method double &QSizeF::rheight()\n", false, &_init_f_rheight_0, &_call_f_rheight_0);
}

// double &QSizeF::rwidth()


static void _init_f_rwidth_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double & > ();
}

static void _call_f_rwidth_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double & > ((double &)((QSizeF *)cls)->rwidth ());
}

static qt_gsi::GenericMethod *_create_f_rwidth_0 ()
{
  return new qt_gsi::GenericMethod ("rwidth", "@brief Method double &QSizeF::rwidth()\n", false, &_init_f_rwidth_0, &_call_f_rwidth_0);
}

// void QSizeF::scale(double w, double h, Qt::AspectRatioMode mode)


static void _init_f_scale_4183 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_scale_4183 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > ();
  ((QSizeF *)cls)->scale (arg1, arg2, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_scale_4183 ()
{
  return new qt_gsi::GenericMethod ("scale", "@brief Method void QSizeF::scale(double w, double h, Qt::AspectRatioMode mode)\n", false, &_init_f_scale_4183, &_call_f_scale_4183);
}

// void QSizeF::scale(const QSizeF &s, Qt::AspectRatioMode mode)


static void _init_f_scale_4024 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QSizeF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scale_4024 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSizeF &arg1 = args.read<const QSizeF & > ();
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > ();
  ((QSizeF *)cls)->scale (arg1, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_scale_4024 ()
{
  return new qt_gsi::GenericMethod ("scale", "@brief Method void QSizeF::scale(const QSizeF &s, Qt::AspectRatioMode mode)\n", false, &_init_f_scale_4024, &_call_f_scale_4024);
}

// void QSizeF::setHeight(double h)


static void _init_f_setHeight_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeight_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QSizeF *)cls)->setHeight (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHeight_1071 ()
{
  return new qt_gsi::GenericMethod ("setHeight|height=", "@brief Method void QSizeF::setHeight(double h)\n", false, &_init_f_setHeight_1071, &_call_f_setHeight_1071);
}

// void QSizeF::setWidth(double w)


static void _init_f_setWidth_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWidth_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QSizeF *)cls)->setWidth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWidth_1071 ()
{
  return new qt_gsi::GenericMethod ("setWidth|width=", "@brief Method void QSizeF::setWidth(double w)\n", false, &_init_f_setWidth_1071, &_call_f_setWidth_1071);
}

// QSize QSizeF::toSize()


static void _init_f_toSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_toSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QSizeF *)cls)->toSize ());
}

static qt_gsi::GenericMethod *_create_f_toSize_c0 ()
{
  return new qt_gsi::GenericMethod ("toSize", "@brief Method QSize QSizeF::toSize()\n", true, &_init_f_toSize_c0, &_call_f_toSize_c0);
}

// void QSizeF::transpose()


static void _init_f_transpose_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_transpose_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSizeF *)cls)->transpose ();
}

static qt_gsi::GenericMethod *_create_f_transpose_0 ()
{
  return new qt_gsi::GenericMethod ("transpose", "@brief Method void QSizeF::transpose()\n", false, &_init_f_transpose_0, &_call_f_transpose_0);
}

// double QSizeF::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QSizeF *)cls)->width ());
}

static qt_gsi::GenericMethod *_create_f_width_c0 ()
{
  return new qt_gsi::GenericMethod (":width", "@brief Method double QSizeF::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
}

//  bool ::operator==(const QSizeF &s1, const QSizeF &s2)
static bool op_QSizeF_operator_eq__eq__3642(const QSizeF *_self, const QSizeF &s2) {
  return ::operator==(*_self, s2);
}

//  bool ::operator!=(const QSizeF &s1, const QSizeF &s2)
static bool op_QSizeF_operator_excl__eq__3642(const QSizeF *_self, const QSizeF &s2) {
  return ::operator!=(*_self, s2);
}

//  const QSizeF ::operator+(const QSizeF &s1, const QSizeF &s2)
static const QSizeF op_QSizeF_operator_plus__3642(const QSizeF *_self, const QSizeF &s2) {
  return ::operator+(*_self, s2);
}

//  const QSizeF ::operator-(const QSizeF &s1, const QSizeF &s2)
static const QSizeF op_QSizeF_operator_minus__3642(const QSizeF *_self, const QSizeF &s2) {
  return ::operator-(*_self, s2);
}

//  const QSizeF ::operator*(const QSizeF &s, qreal c)
static const QSizeF op_QSizeF_operator_star__2736(const QSizeF *_self, qreal c) {
  return ::operator*(*_self, c);
}

//  const QSizeF ::operator/(const QSizeF &s, qreal c)
static const QSizeF op_QSizeF_operator_slash__2736(const QSizeF *_self, qreal c) {
  return ::operator/(*_self, c);
}


namespace gsi
{
gsi::Class<QSizeF> decl_QSizeF ("QSizeF",
  gsi::Methods(_create_ctor_QSizeF_0 ()) +
  gsi::Methods(_create_ctor_QSizeF_1805 ()) +
  gsi::Methods(_create_ctor_QSizeF_2034 ()) +
  gsi::Methods(_create_f_boundedTo_c1875 ()) +
  gsi::Methods(_create_f_expandedTo_c1875 ()) +
  gsi::Methods(_create_f_height_c0 ()) +
  gsi::Methods(_create_f_isEmpty_c0 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_operator_star__eq__1071 ()) +
  gsi::Methods(_create_f_operator_plus__eq__1875 ()) +
  gsi::Methods(_create_f_operator_minus__eq__1875 ()) +
  gsi::Methods(_create_f_operator_slash__eq__1071 ()) +
  gsi::Methods(_create_f_rheight_0 ()) +
  gsi::Methods(_create_f_rwidth_0 ()) +
  gsi::Methods(_create_f_scale_4183 ()) +
  gsi::Methods(_create_f_scale_4024 ()) +
  gsi::Methods(_create_f_setHeight_1071 ()) +
  gsi::Methods(_create_f_setWidth_1071 ()) +
  gsi::Methods(_create_f_toSize_c0 ()) +
  gsi::Methods(_create_f_transpose_0 ()) +
  gsi::Methods(_create_f_width_c0 ()) +
  gsi::method_ext("==", &::op_QSizeF_operator_eq__eq__3642, gsi::arg ("s2"), "@brief Operator bool ::operator==(const QSizeF &s1, const QSizeF &s2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("!=", &::op_QSizeF_operator_excl__eq__3642, gsi::arg ("s2"), "@brief Operator bool ::operator!=(const QSizeF &s1, const QSizeF &s2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("+", &::op_QSizeF_operator_plus__3642, gsi::arg ("s2"), "@brief Operator const QSizeF ::operator+(const QSizeF &s1, const QSizeF &s2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("-", &::op_QSizeF_operator_minus__3642, gsi::arg ("s2"), "@brief Operator const QSizeF ::operator-(const QSizeF &s1, const QSizeF &s2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QSizeF_operator_star__2736, gsi::arg ("c"), "@brief Operator const QSizeF ::operator*(const QSizeF &s, qreal c)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("/", &::op_QSizeF_operator_slash__2736, gsi::arg ("c"), "@brief Operator const QSizeF ::operator/(const QSizeF &s, qreal c)\nThis is the mapping of the global operator to the instance method."),
  "@qt\n@brief Binding of QSizeF");

}

