
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPrintPreviewWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQPrintPreviewWidget_EventAdaptor.h"
#include "gsiDeclQPrintPreviewWidget_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPrintPreviewWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPrintPreviewWidget::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// int QPrintPreviewWidget::currentPage()


static void _init_f_currentPage_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentPage_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPrintPreviewWidget *)cls)->currentPage ());
}

static qt_gsi::GenericMethod *_create_f_currentPage_c0 ()
{
  return new qt_gsi::GenericMethod (":currentPage", "@brief Method int QPrintPreviewWidget::currentPage()\n", true, &_init_f_currentPage_c0, &_call_f_currentPage_c0);
}

// void QPrintPreviewWidget::fitInView()


static void _init_f_fitInView_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_fitInView_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPrintPreviewWidget *)cls)->fitInView ();
}

static qt_gsi::GenericMethod *_create_f_fitInView_0 ()
{
  return new qt_gsi::GenericMethod ("fitInView", "@brief Method void QPrintPreviewWidget::fitInView()\n", false, &_init_f_fitInView_0, &_call_f_fitInView_0);
}

// void QPrintPreviewWidget::fitToWidth()


static void _init_f_fitToWidth_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_fitToWidth_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPrintPreviewWidget *)cls)->fitToWidth ();
}

static qt_gsi::GenericMethod *_create_f_fitToWidth_0 ()
{
  return new qt_gsi::GenericMethod ("fitToWidth", "@brief Method void QPrintPreviewWidget::fitToWidth()\n", false, &_init_f_fitToWidth_0, &_call_f_fitToWidth_0);
}

// int QPrintPreviewWidget::numPages()


static void _init_f_numPages_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_numPages_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPrintPreviewWidget *)cls)->numPages ());
}

static qt_gsi::GenericMethod *_create_f_numPages_c0 ()
{
  return new qt_gsi::GenericMethod ("numPages", "@brief Method int QPrintPreviewWidget::numPages()\n", true, &_init_f_numPages_c0, &_call_f_numPages_c0);
}

// QPrinter::Orientation QPrintPreviewWidget::orientation()


static void _init_f_orientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::Orientation>::target_type > ();
}

static void _call_f_orientation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QPrinter::Orientation>::target_type > ((qt_gsi::Converter<QPrinter::Orientation>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::Orientation>(((QPrintPreviewWidget *)cls)->orientation ()));
}

static qt_gsi::GenericMethod *_create_f_orientation_c0 ()
{
  return new qt_gsi::GenericMethod (":orientation", "@brief Method QPrinter::Orientation QPrintPreviewWidget::orientation()\n", true, &_init_f_orientation_c0, &_call_f_orientation_c0);
}

// int QPrintPreviewWidget::pageCount()


static void _init_f_pageCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_pageCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPrintPreviewWidget *)cls)->pageCount ());
}

static qt_gsi::GenericMethod *_create_f_pageCount_c0 ()
{
  return new qt_gsi::GenericMethod ("pageCount", "@brief Method int QPrintPreviewWidget::pageCount()\n", true, &_init_f_pageCount_c0, &_call_f_pageCount_c0);
}

// void QPrintPreviewWidget::print()


static void _init_f_print_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_print_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPrintPreviewWidget *)cls)->print ();
}

static qt_gsi::GenericMethod *_create_f_print_0 ()
{
  return new qt_gsi::GenericMethod ("print", "@brief Method void QPrintPreviewWidget::print()\n", false, &_init_f_print_0, &_call_f_print_0);
}

// void QPrintPreviewWidget::setAllPagesViewMode()


static void _init_f_setAllPagesViewMode_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setAllPagesViewMode_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPrintPreviewWidget *)cls)->setAllPagesViewMode ();
}

static qt_gsi::GenericMethod *_create_f_setAllPagesViewMode_0 ()
{
  return new qt_gsi::GenericMethod ("setAllPagesViewMode", "@brief Method void QPrintPreviewWidget::setAllPagesViewMode()\n", false, &_init_f_setAllPagesViewMode_0, &_call_f_setAllPagesViewMode_0);
}

// void QPrintPreviewWidget::setCurrentPage(int pageNumber)


static void _init_f_setCurrentPage_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentPage_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QPrintPreviewWidget *)cls)->setCurrentPage (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCurrentPage_767 ()
{
  return new qt_gsi::GenericMethod ("setCurrentPage|currentPage=", "@brief Method void QPrintPreviewWidget::setCurrentPage(int pageNumber)\n", false, &_init_f_setCurrentPage_767, &_call_f_setCurrentPage_767);
}

// void QPrintPreviewWidget::setFacingPagesViewMode()


static void _init_f_setFacingPagesViewMode_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setFacingPagesViewMode_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPrintPreviewWidget *)cls)->setFacingPagesViewMode ();
}

static qt_gsi::GenericMethod *_create_f_setFacingPagesViewMode_0 ()
{
  return new qt_gsi::GenericMethod ("setFacingPagesViewMode", "@brief Method void QPrintPreviewWidget::setFacingPagesViewMode()\n", false, &_init_f_setFacingPagesViewMode_0, &_call_f_setFacingPagesViewMode_0);
}

// void QPrintPreviewWidget::setLandscapeOrientation()


static void _init_f_setLandscapeOrientation_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setLandscapeOrientation_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPrintPreviewWidget *)cls)->setLandscapeOrientation ();
}

static qt_gsi::GenericMethod *_create_f_setLandscapeOrientation_0 ()
{
  return new qt_gsi::GenericMethod ("setLandscapeOrientation", "@brief Method void QPrintPreviewWidget::setLandscapeOrientation()\n", false, &_init_f_setLandscapeOrientation_0, &_call_f_setLandscapeOrientation_0);
}

// void QPrintPreviewWidget::setOrientation(QPrinter::Orientation orientation)


static void _init_f_setOrientation_2537 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<QPrinter::Orientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrientation_2537 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPrinter::Orientation>::target_type & arg1 = args.read<const qt_gsi::Converter<QPrinter::Orientation>::target_type & > ();
  ((QPrintPreviewWidget *)cls)->setOrientation (qt_gsi::QtToCppAdaptor<QPrinter::Orientation>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setOrientation_2537 ()
{
  return new qt_gsi::GenericMethod ("setOrientation|orientation=", "@brief Method void QPrintPreviewWidget::setOrientation(QPrinter::Orientation orientation)\n", false, &_init_f_setOrientation_2537, &_call_f_setOrientation_2537);
}

// void QPrintPreviewWidget::setPortraitOrientation()


static void _init_f_setPortraitOrientation_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setPortraitOrientation_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPrintPreviewWidget *)cls)->setPortraitOrientation ();
}

static qt_gsi::GenericMethod *_create_f_setPortraitOrientation_0 ()
{
  return new qt_gsi::GenericMethod ("setPortraitOrientation", "@brief Method void QPrintPreviewWidget::setPortraitOrientation()\n", false, &_init_f_setPortraitOrientation_0, &_call_f_setPortraitOrientation_0);
}

// void QPrintPreviewWidget::setSinglePageViewMode()


static void _init_f_setSinglePageViewMode_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setSinglePageViewMode_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPrintPreviewWidget *)cls)->setSinglePageViewMode ();
}

static qt_gsi::GenericMethod *_create_f_setSinglePageViewMode_0 ()
{
  return new qt_gsi::GenericMethod ("setSinglePageViewMode", "@brief Method void QPrintPreviewWidget::setSinglePageViewMode()\n", false, &_init_f_setSinglePageViewMode_0, &_call_f_setSinglePageViewMode_0);
}

// void QPrintPreviewWidget::setViewMode(QPrintPreviewWidget::ViewMode viewMode)


static void _init_f_setViewMode_3308 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewMode");
  decl->add_arg<const qt_gsi::Converter<QPrintPreviewWidget::ViewMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewMode_3308 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPrintPreviewWidget::ViewMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QPrintPreviewWidget::ViewMode>::target_type & > ();
  ((QPrintPreviewWidget *)cls)->setViewMode (qt_gsi::QtToCppAdaptor<QPrintPreviewWidget::ViewMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setViewMode_3308 ()
{
  return new qt_gsi::GenericMethod ("setViewMode|viewMode=", "@brief Method void QPrintPreviewWidget::setViewMode(QPrintPreviewWidget::ViewMode viewMode)\n", false, &_init_f_setViewMode_3308, &_call_f_setViewMode_3308);
}

// void QPrintPreviewWidget::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPrintPreviewWidget *)cls)->setVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QPrintPreviewWidget::setVisible(bool visible)\nThis is a reimplementation of QWidget::setVisible", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
}

// void QPrintPreviewWidget::setZoomFactor(double zoomFactor)


static void _init_f_setZoomFactor_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("zoomFactor");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setZoomFactor_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QPrintPreviewWidget *)cls)->setZoomFactor (arg1);
}

static qt_gsi::GenericMethod *_create_f_setZoomFactor_1071 ()
{
  return new qt_gsi::GenericMethod ("setZoomFactor|zoomFactor=", "@brief Method void QPrintPreviewWidget::setZoomFactor(double zoomFactor)\n", false, &_init_f_setZoomFactor_1071, &_call_f_setZoomFactor_1071);
}

// void QPrintPreviewWidget::setZoomMode(QPrintPreviewWidget::ZoomMode zoomMode)


static void _init_f_setZoomMode_3318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("zoomMode");
  decl->add_arg<const qt_gsi::Converter<QPrintPreviewWidget::ZoomMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setZoomMode_3318 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPrintPreviewWidget::ZoomMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QPrintPreviewWidget::ZoomMode>::target_type & > ();
  ((QPrintPreviewWidget *)cls)->setZoomMode (qt_gsi::QtToCppAdaptor<QPrintPreviewWidget::ZoomMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setZoomMode_3318 ()
{
  return new qt_gsi::GenericMethod ("setZoomMode|zoomMode=", "@brief Method void QPrintPreviewWidget::setZoomMode(QPrintPreviewWidget::ZoomMode zoomMode)\n", false, &_init_f_setZoomMode_3318, &_call_f_setZoomMode_3318);
}

// void QPrintPreviewWidget::updatePreview()


static void _init_f_updatePreview_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_updatePreview_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPrintPreviewWidget *)cls)->updatePreview ();
}

static qt_gsi::GenericMethod *_create_f_updatePreview_0 ()
{
  return new qt_gsi::GenericMethod ("updatePreview", "@brief Method void QPrintPreviewWidget::updatePreview()\n", false, &_init_f_updatePreview_0, &_call_f_updatePreview_0);
}

// QPrintPreviewWidget::ViewMode QPrintPreviewWidget::viewMode()


static void _init_f_viewMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrintPreviewWidget::ViewMode>::target_type > ();
}

static void _call_f_viewMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QPrintPreviewWidget::ViewMode>::target_type > ((qt_gsi::Converter<QPrintPreviewWidget::ViewMode>::target_type)qt_gsi::CppToQtAdaptor<QPrintPreviewWidget::ViewMode>(((QPrintPreviewWidget *)cls)->viewMode ()));
}

static qt_gsi::GenericMethod *_create_f_viewMode_c0 ()
{
  return new qt_gsi::GenericMethod (":viewMode", "@brief Method QPrintPreviewWidget::ViewMode QPrintPreviewWidget::viewMode()\n", true, &_init_f_viewMode_c0, &_call_f_viewMode_c0);
}

// double QPrintPreviewWidget::zoomFactor()


static void _init_f_zoomFactor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_zoomFactor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QPrintPreviewWidget *)cls)->zoomFactor ());
}

static qt_gsi::GenericMethod *_create_f_zoomFactor_c0 ()
{
  return new qt_gsi::GenericMethod (":zoomFactor", "@brief Method double QPrintPreviewWidget::zoomFactor()\n", true, &_init_f_zoomFactor_c0, &_call_f_zoomFactor_c0);
}

// void QPrintPreviewWidget::zoomIn(double zoom)


static void _init_f_zoomIn_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("zoom", true, "1.1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_zoomIn_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args ? args.read<double > () : (double)(1.1);
  ((QPrintPreviewWidget *)cls)->zoomIn (arg1);
}

static qt_gsi::GenericMethod *_create_f_zoomIn_1071 ()
{
  return new qt_gsi::GenericMethod ("zoomIn", "@brief Method void QPrintPreviewWidget::zoomIn(double zoom)\n", false, &_init_f_zoomIn_1071, &_call_f_zoomIn_1071);
}

// QPrintPreviewWidget::ZoomMode QPrintPreviewWidget::zoomMode()


static void _init_f_zoomMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrintPreviewWidget::ZoomMode>::target_type > ();
}

static void _call_f_zoomMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QPrintPreviewWidget::ZoomMode>::target_type > ((qt_gsi::Converter<QPrintPreviewWidget::ZoomMode>::target_type)qt_gsi::CppToQtAdaptor<QPrintPreviewWidget::ZoomMode>(((QPrintPreviewWidget *)cls)->zoomMode ()));
}

static qt_gsi::GenericMethod *_create_f_zoomMode_c0 ()
{
  return new qt_gsi::GenericMethod (":zoomMode", "@brief Method QPrintPreviewWidget::ZoomMode QPrintPreviewWidget::zoomMode()\n", true, &_init_f_zoomMode_c0, &_call_f_zoomMode_c0);
}

// void QPrintPreviewWidget::zoomOut(double zoom)


static void _init_f_zoomOut_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("zoom", true, "1.1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_zoomOut_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args ? args.read<double > () : (double)(1.1);
  ((QPrintPreviewWidget *)cls)->zoomOut (arg1);
}

static qt_gsi::GenericMethod *_create_f_zoomOut_1071 ()
{
  return new qt_gsi::GenericMethod ("zoomOut", "@brief Method void QPrintPreviewWidget::zoomOut(double zoom)\n", false, &_init_f_zoomOut_1071, &_call_f_zoomOut_1071);
}

// static QString QPrintPreviewWidget::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QPrintPreviewWidget::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPrintPreviewWidget::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QPrintPreviewWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QPrintPreviewWidget::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPrintPreviewWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QPrintPreviewWidget::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QPrintPreviewWidget::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPrintPreviewWidget::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QPrintPreviewWidget::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QPrintPreviewWidget::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPrintPreviewWidget::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QPrintPreviewWidget, QPrintPreviewWidget_EventAdaptor> ea_QPrintPreviewWidget;

namespace gsi
{
extern gsi::Class<QWidget> decl_QWidget;

gsi::Class<QPrintPreviewWidget> decl_QPrintPreviewWidget (ea_QPrintPreviewWidget, decl_QWidget, "QPrintPreviewWidget_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_currentPage_c0 ()) +
  gsi::Methods(_create_f_fitInView_0 ()) +
  gsi::Methods(_create_f_fitToWidth_0 ()) +
  gsi::Methods(_create_f_numPages_c0 ()) +
  gsi::Methods(_create_f_orientation_c0 ()) +
  gsi::Methods(_create_f_pageCount_c0 ()) +
  gsi::Methods(_create_f_print_0 ()) +
  gsi::Methods(_create_f_setAllPagesViewMode_0 ()) +
  gsi::Methods(_create_f_setCurrentPage_767 ()) +
  gsi::Methods(_create_f_setFacingPagesViewMode_0 ()) +
  gsi::Methods(_create_f_setLandscapeOrientation_0 ()) +
  gsi::Methods(_create_f_setOrientation_2537 ()) +
  gsi::Methods(_create_f_setPortraitOrientation_0 ()) +
  gsi::Methods(_create_f_setSinglePageViewMode_0 ()) +
  gsi::Methods(_create_f_setViewMode_3308 ()) +
  gsi::Methods(_create_f_setVisible_864 ()) +
  gsi::Methods(_create_f_setZoomFactor_1071 ()) +
  gsi::Methods(_create_f_setZoomMode_3318 ()) +
  gsi::Methods(_create_f_updatePreview_0 ()) +
  gsi::Methods(_create_f_viewMode_c0 ()) +
  gsi::Methods(_create_f_zoomFactor_c0 ()) +
  gsi::Methods(_create_f_zoomIn_1071 ()) +
  gsi::Methods(_create_f_zoomMode_c0 ()) +
  gsi::Methods(_create_f_zoomOut_1071 ()) +
  qt_gsi::qt_signal<QPrintPreviewWidget, QPrintPreviewWidget_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QPrintPreviewWidget_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QPrintPreviewWidget::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QPrintPreviewWidget, QPrintPreviewWidget_EventAdaptor, QObject *> ("destroyed", &QPrintPreviewWidget_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QPrintPreviewWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QPrintPreviewWidget, QPrintPreviewWidget_EventAdaptor, QPrinter *> ("paintRequested", &QPrintPreviewWidget_EventAdaptor::paintRequested_e_1443, gsi::arg("printer"), "@brief Signal declaration for QPrintPreviewWidget::paintRequested(QPrinter *printer)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QPrintPreviewWidget, QPrintPreviewWidget_EventAdaptor> ("previewChanged", &QPrintPreviewWidget_EventAdaptor::previewChanged_e_0, "@brief Signal declaration for QPrintPreviewWidget::previewChanged()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QPrintPreviewWidget");
}


class QPrintPreviewWidget_Adaptor : public QPrintPreviewWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPrintPreviewWidget_Adaptor();

  //  [adaptor ctor] QPrintPreviewWidget::QPrintPreviewWidget(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewWidget_Adaptor(QPrinter *printer) : QPrintPreviewWidget(printer)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewWidget::QPrintPreviewWidget(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewWidget_Adaptor(QPrinter *printer, QWidget *parent) : QPrintPreviewWidget(printer, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewWidget::QPrintPreviewWidget(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewWidget_Adaptor(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags) : QPrintPreviewWidget(printer, parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewWidget::QPrintPreviewWidget(QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewWidget_Adaptor() : QPrintPreviewWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewWidget::QPrintPreviewWidget(QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewWidget_Adaptor(QWidget *parent) : QPrintPreviewWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewWidget::QPrintPreviewWidget(QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewWidget_Adaptor(QWidget *parent, QFlags<Qt::WindowType> flags) : QPrintPreviewWidget(parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QPrintPreviewWidget::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QPrintPreviewWidget_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QPrintPreviewWidget::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QPrintPreviewWidget::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QPrintPreviewWidget_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QPrintPreviewWidget::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QPrintPreviewWidget::focusNextChild()
  bool fp_QPrintPreviewWidget_focusNextChild_0 () {
    return QPrintPreviewWidget::focusNextChild();
  }

  //  bool QPrintPreviewWidget::focusPreviousChild()
  bool fp_QPrintPreviewWidget_focusPreviousChild_0 () {
    return QPrintPreviewWidget::focusPreviousChild();
  }

  //  int QPrintPreviewWidget::receivers(const char *signal)
  int fp_QPrintPreviewWidget_receivers_c1731 (const char *signal) const {
    return QPrintPreviewWidget::receivers(signal);
  }

  //  void QPrintPreviewWidget::resetInputContext()
  void fp_QPrintPreviewWidget_resetInputContext_0 () {
    QPrintPreviewWidget::resetInputContext();
  }

  //  QObject *QPrintPreviewWidget::sender()
  QObject * fp_QPrintPreviewWidget_sender_c0 () const {
    return QPrintPreviewWidget::sender();
  }

  //  void QPrintPreviewWidget::updateMicroFocus()
  void fp_QPrintPreviewWidget_updateMicroFocus_0 () {
    QPrintPreviewWidget::updateMicroFocus();
  }

  //  [adaptor impl] bool QPrintPreviewWidget::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QPrintPreviewWidget::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPrintPreviewWidget_Adaptor, bool, QObject *, QEvent *>(&QPrintPreviewWidget_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QPrintPreviewWidget::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QPrintPreviewWidget::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QPrintPreviewWidget::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QPrintPreviewWidget_Adaptor, int, int>(&QPrintPreviewWidget_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QPrintPreviewWidget::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QPrintPreviewWidget::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QPrintPreviewWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QPrintPreviewWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QPrintPreviewWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QPrintPreviewWidget::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QPrintPreviewWidget::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QPrintPreviewWidget::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QPrintPreviewWidget_Adaptor, QSize>(&QPrintPreviewWidget_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QPrintPreviewWidget::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QPrintPreviewWidget::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QPrintPreviewWidget::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QPrintPreviewWidget_Adaptor, QPaintEngine *>(&QPrintPreviewWidget_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QPrintPreviewWidget::paintEngine();
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QPrintPreviewWidget::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QPrintPreviewWidget_Adaptor, bool>(&QPrintPreviewWidget_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QPrintPreviewWidget::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QPrintPreviewWidget::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QPrintPreviewWidget::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QPrintPreviewWidget_Adaptor, QSize>(&QPrintPreviewWidget_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QPrintPreviewWidget::sizeHint();
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QPrintPreviewWidget::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QPrintPreviewWidget_Adaptor, QActionEvent *>(&QPrintPreviewWidget_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QPrintPreviewWidget::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QPrintPreviewWidget::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QPrintPreviewWidget_Adaptor, QEvent *>(&QPrintPreviewWidget_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QPrintPreviewWidget::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QPrintPreviewWidget::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPrintPreviewWidget_Adaptor, QChildEvent *>(&QPrintPreviewWidget_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QPrintPreviewWidget::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QPrintPreviewWidget::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QPrintPreviewWidget_Adaptor, QCloseEvent *>(&QPrintPreviewWidget_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QPrintPreviewWidget::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QPrintPreviewWidget::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QPrintPreviewWidget_Adaptor, QContextMenuEvent *>(&QPrintPreviewWidget_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QPrintPreviewWidget::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QPrintPreviewWidget::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPrintPreviewWidget_Adaptor, QEvent *>(&QPrintPreviewWidget_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QPrintPreviewWidget::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QPrintPreviewWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QPrintPreviewWidget_Adaptor, const char *>(&QPrintPreviewWidget_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QPrintPreviewWidget::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QPrintPreviewWidget::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QPrintPreviewWidget_Adaptor, QDragEnterEvent *>(&QPrintPreviewWidget_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QPrintPreviewWidget::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QPrintPreviewWidget::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QPrintPreviewWidget_Adaptor, QDragLeaveEvent *>(&QPrintPreviewWidget_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QPrintPreviewWidget::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QPrintPreviewWidget::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QPrintPreviewWidget_Adaptor, QDragMoveEvent *>(&QPrintPreviewWidget_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QPrintPreviewWidget::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QPrintPreviewWidget::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QPrintPreviewWidget_Adaptor, QDropEvent *>(&QPrintPreviewWidget_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QPrintPreviewWidget::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QPrintPreviewWidget::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QPrintPreviewWidget_Adaptor, bool>(&QPrintPreviewWidget_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QPrintPreviewWidget::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QPrintPreviewWidget::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QPrintPreviewWidget_Adaptor, QEvent *>(&QPrintPreviewWidget_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QPrintPreviewWidget::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPrintPreviewWidget::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QPrintPreviewWidget::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPrintPreviewWidget_Adaptor, bool, QEvent *>(&QPrintPreviewWidget_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QPrintPreviewWidget::event(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QPrintPreviewWidget::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QPrintPreviewWidget_Adaptor, QFocusEvent *>(&QPrintPreviewWidget_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QPrintPreviewWidget::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPrintPreviewWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QPrintPreviewWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QPrintPreviewWidget_Adaptor, bool, bool>(&QPrintPreviewWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QPrintPreviewWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QPrintPreviewWidget::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QPrintPreviewWidget_Adaptor, QFocusEvent *>(&QPrintPreviewWidget_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QPrintPreviewWidget::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QPrintPreviewWidget::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QPrintPreviewWidget_Adaptor, const QFont &>(&QPrintPreviewWidget_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QPrintPreviewWidget::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QPrintPreviewWidget::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QPrintPreviewWidget_Adaptor, QHideEvent *>(&QPrintPreviewWidget_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QPrintPreviewWidget::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QPrintPreviewWidget::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QPrintPreviewWidget_Adaptor, QInputMethodEvent *>(&QPrintPreviewWidget_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QPrintPreviewWidget::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QPrintPreviewWidget::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QPrintPreviewWidget_Adaptor, QKeyEvent *>(&QPrintPreviewWidget_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QPrintPreviewWidget::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QPrintPreviewWidget::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QPrintPreviewWidget_Adaptor, QKeyEvent *>(&QPrintPreviewWidget_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QPrintPreviewWidget::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::languageChange()
  void cbs_languageChange_0_0()
  {
    QPrintPreviewWidget::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QPrintPreviewWidget_Adaptor>(&QPrintPreviewWidget_Adaptor::cbs_languageChange_0_0);
    } else {
      QPrintPreviewWidget::languageChange();
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QPrintPreviewWidget::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QPrintPreviewWidget_Adaptor, QEvent *>(&QPrintPreviewWidget_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QPrintPreviewWidget::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QPrintPreviewWidget::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QPrintPreviewWidget::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPrintPreviewWidget_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPrintPreviewWidget_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QPrintPreviewWidget::metric(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QPrintPreviewWidget::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QPrintPreviewWidget_Adaptor, QMouseEvent *>(&QPrintPreviewWidget_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QPrintPreviewWidget::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QPrintPreviewWidget::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QPrintPreviewWidget_Adaptor, QMouseEvent *>(&QPrintPreviewWidget_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QPrintPreviewWidget::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QPrintPreviewWidget::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QPrintPreviewWidget_Adaptor, QMouseEvent *>(&QPrintPreviewWidget_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QPrintPreviewWidget::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QPrintPreviewWidget::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QPrintPreviewWidget_Adaptor, QMouseEvent *>(&QPrintPreviewWidget_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QPrintPreviewWidget::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QPrintPreviewWidget::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QPrintPreviewWidget_Adaptor, QMoveEvent *>(&QPrintPreviewWidget_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QPrintPreviewWidget::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QPrintPreviewWidget::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QPrintPreviewWidget_Adaptor, QPaintEvent *>(&QPrintPreviewWidget_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QPrintPreviewWidget::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QPrintPreviewWidget::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QPrintPreviewWidget_Adaptor, const QPalette &>(&QPrintPreviewWidget_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QPrintPreviewWidget::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QPrintPreviewWidget::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QPrintPreviewWidget_Adaptor, QResizeEvent *>(&QPrintPreviewWidget_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QPrintPreviewWidget::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QPrintPreviewWidget::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QPrintPreviewWidget_Adaptor, QShowEvent *>(&QPrintPreviewWidget_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QPrintPreviewWidget::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QPrintPreviewWidget::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QPrintPreviewWidget_Adaptor, QStyle &>(&QPrintPreviewWidget_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QPrintPreviewWidget::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QPrintPreviewWidget::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QPrintPreviewWidget_Adaptor, QTabletEvent *>(&QPrintPreviewWidget_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QPrintPreviewWidget::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QPrintPreviewWidget::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPrintPreviewWidget_Adaptor, QTimerEvent *>(&QPrintPreviewWidget_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QPrintPreviewWidget::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QPrintPreviewWidget::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QPrintPreviewWidget_Adaptor, QWheelEvent *>(&QPrintPreviewWidget_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QPrintPreviewWidget::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QPrintPreviewWidget::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QPrintPreviewWidget_Adaptor, bool>(&QPrintPreviewWidget_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QPrintPreviewWidget::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QPrintPreviewWidget_Adaptor::~QPrintPreviewWidget_Adaptor() { }

//  Constructor QPrintPreviewWidget::QPrintPreviewWidget(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QPrintPreviewWidget_Adaptor_5037 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("printer");
  decl->add_arg<QPrinter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_2);
  decl->set_return_new<QPrintPreviewWidget_Adaptor *> ();
}

static void _call_ctor_QPrintPreviewWidget_Adaptor_5037 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPrinter *arg1 = args.read<QPrinter * > ();
  QWidget *arg2 = args ? args.read<QWidget * > () : (QWidget *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<QPrintPreviewWidget_Adaptor *> (new QPrintPreviewWidget_Adaptor (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg3).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPrintPreviewWidget_Adaptor_5037 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPrintPreviewWidget::QPrintPreviewWidget(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QPrintPreviewWidget.", &_init_ctor_QPrintPreviewWidget_Adaptor_5037, &_call_ctor_QPrintPreviewWidget_Adaptor_5037);
}

//  Constructor QPrintPreviewWidget::QPrintPreviewWidget(QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QPrintPreviewWidget_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_1);
  decl->set_return_new<QPrintPreviewWidget_Adaptor *> ();
}

static void _call_ctor_QPrintPreviewWidget_Adaptor_3702 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<QPrintPreviewWidget_Adaptor *> (new QPrintPreviewWidget_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPrintPreviewWidget_Adaptor_3702 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPrintPreviewWidget::QPrintPreviewWidget(QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QPrintPreviewWidget.", &_init_ctor_QPrintPreviewWidget_Adaptor_3702, &_call_ctor_QPrintPreviewWidget_Adaptor_3702);
}

// void QPrintPreviewWidget::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QPrintPreviewWidget::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QPrintPreviewWidget::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QPrintPreviewWidget::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QPrintPreviewWidget::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QPrintPreviewWidget::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QPrintPreviewWidget::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QPrintPreviewWidget::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QPrintPreviewWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QPrintPreviewWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QPrintPreviewWidget::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QPrintPreviewWidget::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QPrintPreviewWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QPrintPreviewWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QPrintPreviewWidget::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QPrintPreviewWidget::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// bool QPrintPreviewWidget::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QPrintPreviewWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QPrintPreviewWidget::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QPrintPreviewWidget::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QPrintPreviewWidget_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QPrintPreviewWidget::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QPrintPreviewWidget::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QPrintPreviewWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QPrintPreviewWidget::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QPrintPreviewWidget::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QPrintPreviewWidget_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QPrintPreviewWidget::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QPrintPreviewWidget::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPrintPreviewWidget_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QPrintPreviewWidget::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QPrintPreviewWidget::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QPrintPreviewWidget::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QPrintPreviewWidget::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QPrintPreviewWidget_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QPrintPreviewWidget::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QPrintPreviewWidget::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QPrintPreviewWidget::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QPrintPreviewWidget::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QPrintPreviewWidget::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QPrintPreviewWidget::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPrintPreviewWidget::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QPrintPreviewWidget::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QPrintPreviewWidget::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QPrintPreviewWidget::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QPrintPreviewWidget::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QPrintPreviewWidget::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPrintPreviewWidget::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QPrintPreviewWidget::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPrintPreviewWidget::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QPrintPreviewWidget::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QPrintPreviewWidget::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QPrintPreviewWidget::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QPrintPreviewWidget::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QPrintPreviewWidget::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QPrintPreviewWidget::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QPrintPreviewWidget::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QPrintPreviewWidget::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QPrintPreviewWidget::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QPrintPreviewWidget::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QPrintPreviewWidget::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QPrintPreviewWidget::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QPrintPreviewWidget::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QPrintPreviewWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QPrintPreviewWidget::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QPrintPreviewWidget::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QPrintPreviewWidget::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QPrintPreviewWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QPrintPreviewWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QPrintPreviewWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QPrintPreviewWidget::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QPrintPreviewWidget::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QPrintPreviewWidget::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QPrintPreviewWidget::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QPrintPreviewWidget::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QPrintPreviewWidget::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QPrintPreviewWidget::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QPrintPreviewWidget::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QPrintPreviewWidget::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QPrintPreviewWidget::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QPrintPreviewWidget::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QPrintPreviewWidget::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QPrintPreviewWidget::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QPrintPreviewWidget::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QPrintPreviewWidget::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QPrintPreviewWidget::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QPrintPreviewWidget::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QPrintPreviewWidget_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QPrintPreviewWidget::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QPrintPreviewWidget::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QPrintPreviewWidget::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QPrintPreviewWidget::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QPrintPreviewWidget::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QPrintPreviewWidget::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QPrintPreviewWidget::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QPrintPreviewWidget::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QPrintPreviewWidget::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QPrintPreviewWidget::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QPrintPreviewWidget::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QPrintPreviewWidget::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QPrintPreviewWidget::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QPrintPreviewWidget::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QPrintPreviewWidget::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QPrintPreviewWidget::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QPrintPreviewWidget::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QPrintPreviewWidget::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QPrintPreviewWidget::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QPrintPreviewWidget::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QPrintPreviewWidget::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QPrintPreviewWidget::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QPrintPreviewWidget::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QPrintPreviewWidget::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPrintPreviewWidget::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QPrintPreviewWidget::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QPrintPreviewWidget::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QPrintPreviewWidget::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QPrintPreviewWidget::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QPrintPreviewWidget> decl_QPrintPreviewWidget;

gsi::Class<QPrintPreviewWidget_Adaptor> decl_QPrintPreviewWidget_Adaptor (decl_QPrintPreviewWidget, "QPrintPreviewWidget",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QPrintPreviewWidget_Adaptor_5037 ()) +
  gsi::Methods(_create_ctor_QPrintPreviewWidget_Adaptor_3702 ()),
  "@qt\n@brief Binding of QPrintPreviewWidget");

}


//  Implementation of the enum wrapper class for QPrintPreviewWidget::ViewMode
namespace qt_gsi
{

static QPrintPreviewWidget_ViewMode_Enum *c_1_QPrintPreviewWidget_ViewMode_Enum () { return new QPrintPreviewWidget_ViewMode_Enum (QPrintPreviewWidget::SinglePageView); }
static QPrintPreviewWidget_ViewMode_Enum *c_2_QPrintPreviewWidget_ViewMode_Enum () { return new QPrintPreviewWidget_ViewMode_Enum (QPrintPreviewWidget::FacingPagesView); }
static QPrintPreviewWidget_ViewMode_Enum *c_3_QPrintPreviewWidget_ViewMode_Enum () { return new QPrintPreviewWidget_ViewMode_Enum (QPrintPreviewWidget::AllPagesView); }

static gsi::Methods mkdefs_QPrintPreviewWidget_ViewMode () {
  return
    gsi::constant ("SinglePageView", &qt_gsi::c_1_QPrintPreviewWidget_ViewMode_Enum, "@brief Enum constant QPrintPreviewWidget::SinglePageView") +
    gsi::constant ("FacingPagesView", &qt_gsi::c_2_QPrintPreviewWidget_ViewMode_Enum, "@brief Enum constant QPrintPreviewWidget::FacingPagesView") +
    gsi::constant ("AllPagesView", &qt_gsi::c_3_QPrintPreviewWidget_ViewMode_Enum, "@brief Enum constant QPrintPreviewWidget::AllPagesView");
}

static std::string to_s_QPrintPreviewWidget_ViewMode_Enum (const QPrintPreviewWidget_ViewMode_Enum *e)
{
  if (e->value () == QPrintPreviewWidget::SinglePageView) { return tl::sprintf ("SinglePageView (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintPreviewWidget::FacingPagesView) { return tl::sprintf ("FacingPagesView (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintPreviewWidget::AllPagesView) { return tl::sprintf ("AllPagesView (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QPrintPreviewWidget_ViewMode_Enum (const QPrintPreviewWidget_ViewMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QPrintPreviewWidget_ViewMode_Enum *from_i_QPrintPreviewWidget_ViewMode_Enum (unsigned int i)
{
  return new QPrintPreviewWidget_ViewMode_Enum ((QPrintPreviewWidget::ViewMode) i);
}

static bool equalQPrintPreviewWidget_ViewMode_Enum (const QPrintPreviewWidget_ViewMode_Enum *e, QPrintPreviewWidget_ViewMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QPrintPreviewWidget_ViewMode_Enum (const QPrintPreviewWidget_ViewMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QPrintPreviewWidget_ViewMode_Enums oropQPrintPreviewWidget_ViewMode_Enums (const QPrintPreviewWidget_ViewMode_Enums *e, const QPrintPreviewWidget_ViewMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QPrintPreviewWidget_ViewMode_Enums andopQPrintPreviewWidget_ViewMode_Enums (const QPrintPreviewWidget_ViewMode_Enums *e, const QPrintPreviewWidget_ViewMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QPrintPreviewWidget_ViewMode_Enums xoropQPrintPreviewWidget_ViewMode_Enums (const QPrintPreviewWidget_ViewMode_Enums *e, const QPrintPreviewWidget_ViewMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QPrintPreviewWidget_ViewMode_Enums (const QPrintPreviewWidget_ViewMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QPrintPreviewWidget::SinglePageView)) { if (!l.empty ()) l += "|"; l += "SinglePageView"; }
  if (e->testFlag (QPrintPreviewWidget::FacingPagesView)) { if (!l.empty ()) l += "|"; l += "FacingPagesView"; }
  if (e->testFlag (QPrintPreviewWidget::AllPagesView)) { if (!l.empty ()) l += "|"; l += "AllPagesView"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QPrintPreviewWidget_ViewMode_Enums (const QPrintPreviewWidget_ViewMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QPrintPreviewWidget_ViewMode_Enums (const QPrintPreviewWidget_ViewMode_Enums *e, const QPrintPreviewWidget_ViewMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QPrintPreviewWidget_ViewMode_Enums> decl_QPrintPreviewWidget_ViewMode_Enums ("QPrintPreviewWidget_QFlags_ViewMode",
  gsi::method_ext ("|", &qt_gsi::oropQPrintPreviewWidget_ViewMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQPrintPreviewWidget_ViewMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQPrintPreviewWidget_ViewMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPrintPreviewWidget_ViewMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPrintPreviewWidget_ViewMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QPrintPreviewWidget_ViewMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QPrintPreviewWidget::ViewMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QPrintPreviewWidget_ViewMode_Enum> decl_QPrintPreviewWidget_ViewMode_Enum (decl_QPrintPreviewWidget_ViewMode_Enums, "QPrintPreviewWidget_ViewMode",
  qt_gsi::mkdefs_QPrintPreviewWidget_ViewMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPrintPreviewWidget_ViewMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPrintPreviewWidget_ViewMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQPrintPreviewWidget_ViewMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QPrintPreviewWidget_ViewMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QPrintPreviewWidget_ViewMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QPrintPreviewWidget::ViewMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrintPreviewWidget> inject_QPrintPreviewWidget_ViewMode_Enum_in_parent (qt_gsi::mkdefs_QPrintPreviewWidget_ViewMode ());
static gsi::ClassExt<QPrintPreviewWidget> decl_QPrintPreviewWidget_ViewMode_Enum_as_child (decl_QPrintPreviewWidget_ViewMode_Enum, "ViewMode");

}


//  Implementation of the enum wrapper class for QPrintPreviewWidget::ZoomMode
namespace qt_gsi
{

static QPrintPreviewWidget_ZoomMode_Enum *c_1_QPrintPreviewWidget_ZoomMode_Enum () { return new QPrintPreviewWidget_ZoomMode_Enum (QPrintPreviewWidget::CustomZoom); }
static QPrintPreviewWidget_ZoomMode_Enum *c_2_QPrintPreviewWidget_ZoomMode_Enum () { return new QPrintPreviewWidget_ZoomMode_Enum (QPrintPreviewWidget::FitToWidth); }
static QPrintPreviewWidget_ZoomMode_Enum *c_3_QPrintPreviewWidget_ZoomMode_Enum () { return new QPrintPreviewWidget_ZoomMode_Enum (QPrintPreviewWidget::FitInView); }

static gsi::Methods mkdefs_QPrintPreviewWidget_ZoomMode () {
  return
    gsi::constant ("CustomZoom", &qt_gsi::c_1_QPrintPreviewWidget_ZoomMode_Enum, "@brief Enum constant QPrintPreviewWidget::CustomZoom") +
    gsi::constant ("FitToWidth", &qt_gsi::c_2_QPrintPreviewWidget_ZoomMode_Enum, "@brief Enum constant QPrintPreviewWidget::FitToWidth") +
    gsi::constant ("FitInView", &qt_gsi::c_3_QPrintPreviewWidget_ZoomMode_Enum, "@brief Enum constant QPrintPreviewWidget::FitInView");
}

static std::string to_s_QPrintPreviewWidget_ZoomMode_Enum (const QPrintPreviewWidget_ZoomMode_Enum *e)
{
  if (e->value () == QPrintPreviewWidget::CustomZoom) { return tl::sprintf ("CustomZoom (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintPreviewWidget::FitToWidth) { return tl::sprintf ("FitToWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintPreviewWidget::FitInView) { return tl::sprintf ("FitInView (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QPrintPreviewWidget_ZoomMode_Enum (const QPrintPreviewWidget_ZoomMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QPrintPreviewWidget_ZoomMode_Enum *from_i_QPrintPreviewWidget_ZoomMode_Enum (unsigned int i)
{
  return new QPrintPreviewWidget_ZoomMode_Enum ((QPrintPreviewWidget::ZoomMode) i);
}

static bool equalQPrintPreviewWidget_ZoomMode_Enum (const QPrintPreviewWidget_ZoomMode_Enum *e, QPrintPreviewWidget_ZoomMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QPrintPreviewWidget_ZoomMode_Enum (const QPrintPreviewWidget_ZoomMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QPrintPreviewWidget_ZoomMode_Enums oropQPrintPreviewWidget_ZoomMode_Enums (const QPrintPreviewWidget_ZoomMode_Enums *e, const QPrintPreviewWidget_ZoomMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QPrintPreviewWidget_ZoomMode_Enums andopQPrintPreviewWidget_ZoomMode_Enums (const QPrintPreviewWidget_ZoomMode_Enums *e, const QPrintPreviewWidget_ZoomMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QPrintPreviewWidget_ZoomMode_Enums xoropQPrintPreviewWidget_ZoomMode_Enums (const QPrintPreviewWidget_ZoomMode_Enums *e, const QPrintPreviewWidget_ZoomMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QPrintPreviewWidget_ZoomMode_Enums (const QPrintPreviewWidget_ZoomMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QPrintPreviewWidget::CustomZoom)) { if (!l.empty ()) l += "|"; l += "CustomZoom"; }
  if (e->testFlag (QPrintPreviewWidget::FitToWidth)) { if (!l.empty ()) l += "|"; l += "FitToWidth"; }
  if (e->testFlag (QPrintPreviewWidget::FitInView)) { if (!l.empty ()) l += "|"; l += "FitInView"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QPrintPreviewWidget_ZoomMode_Enums (const QPrintPreviewWidget_ZoomMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QPrintPreviewWidget_ZoomMode_Enums (const QPrintPreviewWidget_ZoomMode_Enums *e, const QPrintPreviewWidget_ZoomMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QPrintPreviewWidget_ZoomMode_Enums> decl_QPrintPreviewWidget_ZoomMode_Enums ("QPrintPreviewWidget_QFlags_ZoomMode",
  gsi::method_ext ("|", &qt_gsi::oropQPrintPreviewWidget_ZoomMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQPrintPreviewWidget_ZoomMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQPrintPreviewWidget_ZoomMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPrintPreviewWidget_ZoomMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPrintPreviewWidget_ZoomMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QPrintPreviewWidget_ZoomMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QPrintPreviewWidget::ZoomMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QPrintPreviewWidget_ZoomMode_Enum> decl_QPrintPreviewWidget_ZoomMode_Enum (decl_QPrintPreviewWidget_ZoomMode_Enums, "QPrintPreviewWidget_ZoomMode",
  qt_gsi::mkdefs_QPrintPreviewWidget_ZoomMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPrintPreviewWidget_ZoomMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPrintPreviewWidget_ZoomMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQPrintPreviewWidget_ZoomMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QPrintPreviewWidget_ZoomMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QPrintPreviewWidget_ZoomMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QPrintPreviewWidget::ZoomMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrintPreviewWidget> inject_QPrintPreviewWidget_ZoomMode_Enum_in_parent (qt_gsi::mkdefs_QPrintPreviewWidget_ZoomMode ());
static gsi::ClassExt<QPrintPreviewWidget> decl_QPrintPreviewWidget_ZoomMode_Enum_as_child (decl_QPrintPreviewWidget_ZoomMode_Enum, "ZoomMode");

}

