
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPrintEngine.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQPrintEngine_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPrintEngine

// bool QPrintEngine::abort()


static void _init_f_abort_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_abort_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPrintEngine *)cls)->abort ());
}

static qt_gsi::GenericMethod *_create_f_abort_0 ()
{
  return new qt_gsi::GenericMethod ("abort", "@brief Method bool QPrintEngine::abort()\n", false, &_init_f_abort_0, &_call_f_abort_0);
}

// int QPrintEngine::metric(QPaintDevice::PaintDeviceMetric)


static void _init_f_metric_c3445 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_metric_c3445 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QPrintEngine *)cls)->metric (qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_metric_c3445 ()
{
  return new qt_gsi::GenericMethod ("metric", "@brief Method int QPrintEngine::metric(QPaintDevice::PaintDeviceMetric)\n", true, &_init_f_metric_c3445, &_call_f_metric_c3445);
}

// bool QPrintEngine::newPage()


static void _init_f_newPage_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_newPage_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPrintEngine *)cls)->newPage ());
}

static qt_gsi::GenericMethod *_create_f_newPage_0 ()
{
  return new qt_gsi::GenericMethod ("newPage", "@brief Method bool QPrintEngine::newPage()\n", false, &_init_f_newPage_0, &_call_f_newPage_0);
}

// QPrinter::PrinterState QPrintEngine::printerState()


static void _init_f_printerState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::PrinterState>::target_type > ();
}

static void _call_f_printerState_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QPrinter::PrinterState>::target_type > ((qt_gsi::Converter<QPrinter::PrinterState>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::PrinterState>(((QPrintEngine *)cls)->printerState ()));
}

static qt_gsi::GenericMethod *_create_f_printerState_c0 ()
{
  return new qt_gsi::GenericMethod ("printerState", "@brief Method QPrinter::PrinterState QPrintEngine::printerState()\n", true, &_init_f_printerState_c0, &_call_f_printerState_c0);
}

// QVariant QPrintEngine::property(QPrintEngine::PrintEnginePropertyKey key)


static void _init_f_property_c4045 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_property_c4045 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & arg1 = args.read<const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QPrintEngine *)cls)->property (qt_gsi::QtToCppAdaptor<QPrintEngine::PrintEnginePropertyKey>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_property_c4045 ()
{
  return new qt_gsi::GenericMethod ("property", "@brief Method QVariant QPrintEngine::property(QPrintEngine::PrintEnginePropertyKey key)\n", true, &_init_f_property_c4045, &_call_f_property_c4045);
}

// void QPrintEngine::setProperty(QPrintEngine::PrintEnginePropertyKey key, const QVariant &value)


static void _init_f_setProperty_6056 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setProperty_6056 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & arg1 = args.read<const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QPrintEngine *)cls)->setProperty (qt_gsi::QtToCppAdaptor<QPrintEngine::PrintEnginePropertyKey>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setProperty_6056 ()
{
  return new qt_gsi::GenericMethod ("setProperty", "@brief Method void QPrintEngine::setProperty(QPrintEngine::PrintEnginePropertyKey key, const QVariant &value)\n", false, &_init_f_setProperty_6056, &_call_f_setProperty_6056);
}

namespace gsi
{
gsi::Class<QPrintEngine> decl_QPrintEngine ("QPrintEngine_Native",
  gsi::Methods(_create_f_abort_0 ()) +
  gsi::Methods(_create_f_metric_c3445 ()) +
  gsi::Methods(_create_f_newPage_0 ()) +
  gsi::Methods(_create_f_printerState_c0 ()) +
  gsi::Methods(_create_f_property_c4045 ()) +
  gsi::Methods(_create_f_setProperty_6056 ()),
  "@hide\n@alias QPrintEngine");
}


class QPrintEngine_Adaptor : public QPrintEngine, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPrintEngine_Adaptor();

  //  [adaptor ctor] QPrintEngine::QPrintEngine()
  QPrintEngine_Adaptor() : QPrintEngine()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] bool QPrintEngine::abort()
  bool cbs_abort_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("abort");
  }

  virtual bool abort()
  {
    if (cb_abort_0_0.can_issue()) {
      return cb_abort_0_0.issue<QPrintEngine_Adaptor, bool>(&QPrintEngine_Adaptor::cbs_abort_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("abort");
    }
  }

  //  [adaptor impl] int QPrintEngine::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    throw qt_gsi::AbstractMethodCalledException("metric");
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPrintEngine_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPrintEngine_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      throw qt_gsi::AbstractMethodCalledException("metric");
    }
  }

  //  [adaptor impl] bool QPrintEngine::newPage()
  bool cbs_newPage_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("newPage");
  }

  virtual bool newPage()
  {
    if (cb_newPage_0_0.can_issue()) {
      return cb_newPage_0_0.issue<QPrintEngine_Adaptor, bool>(&QPrintEngine_Adaptor::cbs_newPage_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("newPage");
    }
  }

  //  [adaptor impl] QPrinter::PrinterState QPrintEngine::printerState()
  qt_gsi::Converter<QPrinter::PrinterState>::target_type cbs_printerState_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("printerState");
  }

  virtual QPrinter::PrinterState printerState() const
  {
    if (cb_printerState_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QPrinter::PrinterState>(cb_printerState_c0_0.issue<QPrintEngine_Adaptor, qt_gsi::Converter<QPrinter::PrinterState>::target_type>(&QPrintEngine_Adaptor::cbs_printerState_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("printerState");
    }
  }

  //  [adaptor impl] QVariant QPrintEngine::property(QPrintEngine::PrintEnginePropertyKey key)
  QVariant cbs_property_c4045_0(const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & key) const
  {
    throw qt_gsi::AbstractMethodCalledException("property");
  }

  virtual QVariant property(QPrintEngine::PrintEnginePropertyKey key) const
  {
    if (cb_property_c4045_0.can_issue()) {
      return cb_property_c4045_0.issue<QPrintEngine_Adaptor, QVariant, const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type &>(&QPrintEngine_Adaptor::cbs_property_c4045_0, qt_gsi::CppToQtAdaptor<QPrintEngine::PrintEnginePropertyKey>(key));
    } else {
      throw qt_gsi::AbstractMethodCalledException("property");
    }
  }

  //  [adaptor impl] void QPrintEngine::setProperty(QPrintEngine::PrintEnginePropertyKey key, const QVariant &value)
  void cbs_setProperty_6056_0(const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & key, const QVariant &value)
  {
    throw qt_gsi::AbstractMethodCalledException("setProperty");
  }

  virtual void setProperty(QPrintEngine::PrintEnginePropertyKey key, const QVariant &value)
  {
    if (cb_setProperty_6056_0.can_issue()) {
      cb_setProperty_6056_0.issue<QPrintEngine_Adaptor, const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type &, const QVariant &>(&QPrintEngine_Adaptor::cbs_setProperty_6056_0, qt_gsi::CppToQtAdaptor<QPrintEngine::PrintEnginePropertyKey>(key), value);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setProperty");
    }
  }

  gsi::Callback cb_abort_0_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_newPage_0_0;
  gsi::Callback cb_printerState_c0_0;
  gsi::Callback cb_property_c4045_0;
  gsi::Callback cb_setProperty_6056_0;
};

QPrintEngine_Adaptor::~QPrintEngine_Adaptor() { }

//  Constructor QPrintEngine::QPrintEngine() (adaptor class)

static void _init_ctor_QPrintEngine_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QPrintEngine_Adaptor *> ();
}

static void _call_ctor_QPrintEngine_Adaptor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPrintEngine_Adaptor *> (new QPrintEngine_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPrintEngine_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPrintEngine::QPrintEngine()\nThis method creates an object of class QPrintEngine.", &_init_ctor_QPrintEngine_Adaptor_0, &_call_ctor_QPrintEngine_Adaptor_0);
}

// bool QPrintEngine::abort()

static void _init_cbs_abort_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_abort_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPrintEngine_Adaptor *)cls)->cbs_abort_0_0 ());
}

static void _set_callback_cbs_abort_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintEngine_Adaptor *)cls)->cb_abort_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_abort_0_0 ()
{
  return new qt_gsi::GenericMethod ("abort", "@hide", false, &_init_cbs_abort_0_0, &_call_cbs_abort_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_abort_0_0 ()
{
  return new qt_gsi::GenericMethod ("abort", "@brief Virtual method bool QPrintEngine::abort()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_abort_0_0, &_call_cbs_abort_0_0, &_set_callback_cbs_abort_0_0);
}


// int QPrintEngine::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QPrintEngine_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintEngine_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("metric", "@brief Virtual method int QPrintEngine::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// bool QPrintEngine::newPage()

static void _init_cbs_newPage_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_newPage_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPrintEngine_Adaptor *)cls)->cbs_newPage_0_0 ());
}

static void _set_callback_cbs_newPage_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintEngine_Adaptor *)cls)->cb_newPage_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_newPage_0_0 ()
{
  return new qt_gsi::GenericMethod ("newPage", "@hide", false, &_init_cbs_newPage_0_0, &_call_cbs_newPage_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_newPage_0_0 ()
{
  return new qt_gsi::GenericMethod ("newPage", "@brief Virtual method bool QPrintEngine::newPage()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_newPage_0_0, &_call_cbs_newPage_0_0, &_set_callback_cbs_newPage_0_0);
}


// QPrinter::PrinterState QPrintEngine::printerState()

static void _init_cbs_printerState_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::PrinterState>::target_type > ();
}

static void _call_cbs_printerState_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QPrinter::PrinterState>::target_type > ((qt_gsi::Converter<QPrinter::PrinterState>::target_type)((QPrintEngine_Adaptor *)cls)->cbs_printerState_c0_0 ());
}

static void _set_callback_cbs_printerState_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintEngine_Adaptor *)cls)->cb_printerState_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_printerState_c0_0 ()
{
  return new qt_gsi::GenericMethod ("printerState", "@hide", true, &_init_cbs_printerState_c0_0, &_call_cbs_printerState_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_printerState_c0_0 ()
{
  return new qt_gsi::GenericMethod ("printerState", "@brief Virtual method QPrinter::PrinterState QPrintEngine::printerState()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_printerState_c0_0, &_call_cbs_printerState_c0_0, &_set_callback_cbs_printerState_c0_0);
}


// QVariant QPrintEngine::property(QPrintEngine::PrintEnginePropertyKey key)

static void _init_cbs_property_c4045_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_property_c4045_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & arg1 = args.read<const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QPrintEngine_Adaptor *)cls)->cbs_property_c4045_0 (arg1));
}

static void _set_callback_cbs_property_c4045_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintEngine_Adaptor *)cls)->cb_property_c4045_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_property_c4045_0 ()
{
  return new qt_gsi::GenericMethod ("property", "@hide", true, &_init_cbs_property_c4045_0, &_call_cbs_property_c4045_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_property_c4045_0 ()
{
  return new qt_gsi::GenericMethod ("property", "@brief Virtual method QVariant QPrintEngine::property(QPrintEngine::PrintEnginePropertyKey key)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_property_c4045_0, &_call_cbs_property_c4045_0, &_set_callback_cbs_property_c4045_0);
}


// void QPrintEngine::setProperty(QPrintEngine::PrintEnginePropertyKey key, const QVariant &value)

static void _init_cbs_setProperty_6056_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setProperty_6056_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & arg1 = args.read<const qt_gsi::Converter<QPrintEngine::PrintEnginePropertyKey>::target_type & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QPrintEngine_Adaptor *)cls)->cbs_setProperty_6056_0 (arg1, arg2);
}

static void _set_callback_cbs_setProperty_6056_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintEngine_Adaptor *)cls)->cb_setProperty_6056_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setProperty_6056_0 ()
{
  return new qt_gsi::GenericMethod ("setProperty", "@hide", false, &_init_cbs_setProperty_6056_0, &_call_cbs_setProperty_6056_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setProperty_6056_0 ()
{
  return new qt_gsi::GenericMethod ("setProperty", "@brief Virtual method void QPrintEngine::setProperty(QPrintEngine::PrintEnginePropertyKey key, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setProperty_6056_0, &_call_cbs_setProperty_6056_0, &_set_callback_cbs_setProperty_6056_0);
}


namespace gsi
{

extern gsi::Class<QPrintEngine> decl_QPrintEngine;

gsi::Class<QPrintEngine_Adaptor> decl_QPrintEngine_Adaptor (decl_QPrintEngine, "QPrintEngine",
  gsi::Methods(_create_cbs_abort_0_0 ()) +
  gsi::Methods(_create_callback_cbs_abort_0_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_newPage_0_0 ()) +
  gsi::Methods(_create_callback_cbs_newPage_0_0 ()) +
  gsi::Methods(_create_cbs_printerState_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_printerState_c0_0 ()) +
  gsi::Methods(_create_cbs_property_c4045_0 ()) +
  gsi::Methods(_create_callback_cbs_property_c4045_0 ()) +
  gsi::Methods(_create_cbs_setProperty_6056_0 ()) +
  gsi::Methods(_create_callback_cbs_setProperty_6056_0 ()) +
  gsi::Methods(_create_ctor_QPrintEngine_Adaptor_0 ()),
  "@qt\n@brief Binding of QPrintEngine");

}


//  Implementation of the enum wrapper class for QPrintEngine::PrintEnginePropertyKey
namespace qt_gsi
{

static QPrintEngine_PrintEnginePropertyKey_Enum *c_1_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_CollateCopies); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_2_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_ColorMode); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_3_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_Creator); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_4_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_DocumentName); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_5_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_FullPage); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_6_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_NumberOfCopies); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_7_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_Orientation); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_8_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_OutputFileName); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_9_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_PageOrder); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_10_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_PageRect); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_11_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_PageSize); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_12_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_PaperRect); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_13_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_PaperSource); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_14_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_PrinterName); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_15_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_PrinterProgram); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_16_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_Resolution); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_17_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_SelectionOption); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_18_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_SupportedResolutions); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_19_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_WindowsPageSize); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_20_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_FontEmbedding); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_21_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_SuppressSystemPrintStatus); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_22_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_Duplex); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_23_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_PaperSources); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_24_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_CustomPaperSize); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_25_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_PageMargins); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_26_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_PaperSize); }
static QPrintEngine_PrintEnginePropertyKey_Enum *c_27_QPrintEngine_PrintEnginePropertyKey_Enum () { return new QPrintEngine_PrintEnginePropertyKey_Enum (QPrintEngine::PPK_CustomBase); }

static gsi::Methods mkdefs_QPrintEngine_PrintEnginePropertyKey () {
  return
    gsi::constant ("PPK_CollateCopies", &qt_gsi::c_1_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_CollateCopies") +
    gsi::constant ("PPK_ColorMode", &qt_gsi::c_2_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_ColorMode") +
    gsi::constant ("PPK_Creator", &qt_gsi::c_3_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_Creator") +
    gsi::constant ("PPK_DocumentName", &qt_gsi::c_4_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_DocumentName") +
    gsi::constant ("PPK_FullPage", &qt_gsi::c_5_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_FullPage") +
    gsi::constant ("PPK_NumberOfCopies", &qt_gsi::c_6_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_NumberOfCopies") +
    gsi::constant ("PPK_Orientation", &qt_gsi::c_7_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_Orientation") +
    gsi::constant ("PPK_OutputFileName", &qt_gsi::c_8_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_OutputFileName") +
    gsi::constant ("PPK_PageOrder", &qt_gsi::c_9_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_PageOrder") +
    gsi::constant ("PPK_PageRect", &qt_gsi::c_10_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_PageRect") +
    gsi::constant ("PPK_PageSize", &qt_gsi::c_11_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_PageSize") +
    gsi::constant ("PPK_PaperRect", &qt_gsi::c_12_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_PaperRect") +
    gsi::constant ("PPK_PaperSource", &qt_gsi::c_13_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_PaperSource") +
    gsi::constant ("PPK_PrinterName", &qt_gsi::c_14_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_PrinterName") +
    gsi::constant ("PPK_PrinterProgram", &qt_gsi::c_15_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_PrinterProgram") +
    gsi::constant ("PPK_Resolution", &qt_gsi::c_16_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_Resolution") +
    gsi::constant ("PPK_SelectionOption", &qt_gsi::c_17_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_SelectionOption") +
    gsi::constant ("PPK_SupportedResolutions", &qt_gsi::c_18_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_SupportedResolutions") +
    gsi::constant ("PPK_WindowsPageSize", &qt_gsi::c_19_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_WindowsPageSize") +
    gsi::constant ("PPK_FontEmbedding", &qt_gsi::c_20_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_FontEmbedding") +
    gsi::constant ("PPK_SuppressSystemPrintStatus", &qt_gsi::c_21_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_SuppressSystemPrintStatus") +
    gsi::constant ("PPK_Duplex", &qt_gsi::c_22_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_Duplex") +
    gsi::constant ("PPK_PaperSources", &qt_gsi::c_23_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_PaperSources") +
    gsi::constant ("PPK_CustomPaperSize", &qt_gsi::c_24_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_CustomPaperSize") +
    gsi::constant ("PPK_PageMargins", &qt_gsi::c_25_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_PageMargins") +
    gsi::constant ("PPK_PaperSize", &qt_gsi::c_26_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_PaperSize") +
    gsi::constant ("PPK_CustomBase", &qt_gsi::c_27_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Enum constant QPrintEngine::PPK_CustomBase");
}

static std::string to_s_QPrintEngine_PrintEnginePropertyKey_Enum (const QPrintEngine_PrintEnginePropertyKey_Enum *e)
{
  if (e->value () == QPrintEngine::PPK_CollateCopies) { return tl::sprintf ("PPK_CollateCopies (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_ColorMode) { return tl::sprintf ("PPK_ColorMode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_Creator) { return tl::sprintf ("PPK_Creator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_DocumentName) { return tl::sprintf ("PPK_DocumentName (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_FullPage) { return tl::sprintf ("PPK_FullPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_NumberOfCopies) { return tl::sprintf ("PPK_NumberOfCopies (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_Orientation) { return tl::sprintf ("PPK_Orientation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_OutputFileName) { return tl::sprintf ("PPK_OutputFileName (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_PageOrder) { return tl::sprintf ("PPK_PageOrder (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_PageRect) { return tl::sprintf ("PPK_PageRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_PageSize) { return tl::sprintf ("PPK_PageSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_PaperRect) { return tl::sprintf ("PPK_PaperRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_PaperSource) { return tl::sprintf ("PPK_PaperSource (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_PrinterName) { return tl::sprintf ("PPK_PrinterName (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_PrinterProgram) { return tl::sprintf ("PPK_PrinterProgram (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_Resolution) { return tl::sprintf ("PPK_Resolution (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_SelectionOption) { return tl::sprintf ("PPK_SelectionOption (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_SupportedResolutions) { return tl::sprintf ("PPK_SupportedResolutions (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_WindowsPageSize) { return tl::sprintf ("PPK_WindowsPageSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_FontEmbedding) { return tl::sprintf ("PPK_FontEmbedding (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_SuppressSystemPrintStatus) { return tl::sprintf ("PPK_SuppressSystemPrintStatus (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_Duplex) { return tl::sprintf ("PPK_Duplex (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_PaperSources) { return tl::sprintf ("PPK_PaperSources (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_CustomPaperSize) { return tl::sprintf ("PPK_CustomPaperSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_PageMargins) { return tl::sprintf ("PPK_PageMargins (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_PaperSize) { return tl::sprintf ("PPK_PaperSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPrintEngine::PPK_CustomBase) { return tl::sprintf ("PPK_CustomBase (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QPrintEngine_PrintEnginePropertyKey_Enum (const QPrintEngine_PrintEnginePropertyKey_Enum *e)
{
  return (unsigned int) e->value ();
}

static QPrintEngine_PrintEnginePropertyKey_Enum *from_i_QPrintEngine_PrintEnginePropertyKey_Enum (unsigned int i)
{
  return new QPrintEngine_PrintEnginePropertyKey_Enum ((QPrintEngine::PrintEnginePropertyKey) i);
}

static bool equalQPrintEngine_PrintEnginePropertyKey_Enum (const QPrintEngine_PrintEnginePropertyKey_Enum *e, QPrintEngine_PrintEnginePropertyKey_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QPrintEngine_PrintEnginePropertyKey_Enum (const QPrintEngine_PrintEnginePropertyKey_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QPrintEngine_PrintEnginePropertyKey_Enums oropQPrintEngine_PrintEnginePropertyKey_Enums (const QPrintEngine_PrintEnginePropertyKey_Enums *e, const QPrintEngine_PrintEnginePropertyKey_Enums &d)
{
  return e->flags () | d.flags ();
}

static QPrintEngine_PrintEnginePropertyKey_Enums andopQPrintEngine_PrintEnginePropertyKey_Enums (const QPrintEngine_PrintEnginePropertyKey_Enums *e, const QPrintEngine_PrintEnginePropertyKey_Enums &d)
{
  return e->flags () & d.flags ();
}

static QPrintEngine_PrintEnginePropertyKey_Enums xoropQPrintEngine_PrintEnginePropertyKey_Enums (const QPrintEngine_PrintEnginePropertyKey_Enums *e, const QPrintEngine_PrintEnginePropertyKey_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QPrintEngine_PrintEnginePropertyKey_Enums (const QPrintEngine_PrintEnginePropertyKey_Enums *e)
{
  std::string l;
  if (e->testFlag (QPrintEngine::PPK_CollateCopies)) { if (!l.empty ()) l += "|"; l += "PPK_CollateCopies"; }
  if (e->testFlag (QPrintEngine::PPK_ColorMode)) { if (!l.empty ()) l += "|"; l += "PPK_ColorMode"; }
  if (e->testFlag (QPrintEngine::PPK_Creator)) { if (!l.empty ()) l += "|"; l += "PPK_Creator"; }
  if (e->testFlag (QPrintEngine::PPK_DocumentName)) { if (!l.empty ()) l += "|"; l += "PPK_DocumentName"; }
  if (e->testFlag (QPrintEngine::PPK_FullPage)) { if (!l.empty ()) l += "|"; l += "PPK_FullPage"; }
  if (e->testFlag (QPrintEngine::PPK_NumberOfCopies)) { if (!l.empty ()) l += "|"; l += "PPK_NumberOfCopies"; }
  if (e->testFlag (QPrintEngine::PPK_Orientation)) { if (!l.empty ()) l += "|"; l += "PPK_Orientation"; }
  if (e->testFlag (QPrintEngine::PPK_OutputFileName)) { if (!l.empty ()) l += "|"; l += "PPK_OutputFileName"; }
  if (e->testFlag (QPrintEngine::PPK_PageOrder)) { if (!l.empty ()) l += "|"; l += "PPK_PageOrder"; }
  if (e->testFlag (QPrintEngine::PPK_PageRect)) { if (!l.empty ()) l += "|"; l += "PPK_PageRect"; }
  if (e->testFlag (QPrintEngine::PPK_PageSize)) { if (!l.empty ()) l += "|"; l += "PPK_PageSize"; }
  if (e->testFlag (QPrintEngine::PPK_PaperRect)) { if (!l.empty ()) l += "|"; l += "PPK_PaperRect"; }
  if (e->testFlag (QPrintEngine::PPK_PaperSource)) { if (!l.empty ()) l += "|"; l += "PPK_PaperSource"; }
  if (e->testFlag (QPrintEngine::PPK_PrinterName)) { if (!l.empty ()) l += "|"; l += "PPK_PrinterName"; }
  if (e->testFlag (QPrintEngine::PPK_PrinterProgram)) { if (!l.empty ()) l += "|"; l += "PPK_PrinterProgram"; }
  if (e->testFlag (QPrintEngine::PPK_Resolution)) { if (!l.empty ()) l += "|"; l += "PPK_Resolution"; }
  if (e->testFlag (QPrintEngine::PPK_SelectionOption)) { if (!l.empty ()) l += "|"; l += "PPK_SelectionOption"; }
  if (e->testFlag (QPrintEngine::PPK_SupportedResolutions)) { if (!l.empty ()) l += "|"; l += "PPK_SupportedResolutions"; }
  if (e->testFlag (QPrintEngine::PPK_WindowsPageSize)) { if (!l.empty ()) l += "|"; l += "PPK_WindowsPageSize"; }
  if (e->testFlag (QPrintEngine::PPK_FontEmbedding)) { if (!l.empty ()) l += "|"; l += "PPK_FontEmbedding"; }
  if (e->testFlag (QPrintEngine::PPK_SuppressSystemPrintStatus)) { if (!l.empty ()) l += "|"; l += "PPK_SuppressSystemPrintStatus"; }
  if (e->testFlag (QPrintEngine::PPK_Duplex)) { if (!l.empty ()) l += "|"; l += "PPK_Duplex"; }
  if (e->testFlag (QPrintEngine::PPK_PaperSources)) { if (!l.empty ()) l += "|"; l += "PPK_PaperSources"; }
  if (e->testFlag (QPrintEngine::PPK_CustomPaperSize)) { if (!l.empty ()) l += "|"; l += "PPK_CustomPaperSize"; }
  if (e->testFlag (QPrintEngine::PPK_PageMargins)) { if (!l.empty ()) l += "|"; l += "PPK_PageMargins"; }
  if (e->testFlag (QPrintEngine::PPK_PaperSize)) { if (!l.empty ()) l += "|"; l += "PPK_PaperSize"; }
  if (e->testFlag (QPrintEngine::PPK_CustomBase)) { if (!l.empty ()) l += "|"; l += "PPK_CustomBase"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QPrintEngine_PrintEnginePropertyKey_Enums (const QPrintEngine_PrintEnginePropertyKey_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QPrintEngine_PrintEnginePropertyKey_Enums (const QPrintEngine_PrintEnginePropertyKey_Enums *e, const QPrintEngine_PrintEnginePropertyKey_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QPrintEngine_PrintEnginePropertyKey_Enums> decl_QPrintEngine_PrintEnginePropertyKey_Enums ("QPrintEngine_QFlags_PrintEnginePropertyKey",
  gsi::method_ext ("|", &qt_gsi::oropQPrintEngine_PrintEnginePropertyKey_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQPrintEngine_PrintEnginePropertyKey_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQPrintEngine_PrintEnginePropertyKey_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPrintEngine_PrintEnginePropertyKey_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPrintEngine_PrintEnginePropertyKey_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QPrintEngine_PrintEnginePropertyKey_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QPrintEngine::PrintEnginePropertyKey> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QPrintEngine_PrintEnginePropertyKey_Enum> decl_QPrintEngine_PrintEnginePropertyKey_Enum (decl_QPrintEngine_PrintEnginePropertyKey_Enums, "QPrintEngine_PrintEnginePropertyKey",
  qt_gsi::mkdefs_QPrintEngine_PrintEnginePropertyKey () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPrintEngine_PrintEnginePropertyKey_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQPrintEngine_PrintEnginePropertyKey_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QPrintEngine_PrintEnginePropertyKey_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QPrintEngine_PrintEnginePropertyKey_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QPrintEngine::PrintEnginePropertyKey enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrintEngine> inject_QPrintEngine_PrintEnginePropertyKey_Enum_in_parent (qt_gsi::mkdefs_QPrintEngine_PrintEnginePropertyKey ());
static gsi::ClassExt<QPrintEngine> decl_QPrintEngine_PrintEnginePropertyKey_Enum_as_child (decl_QPrintEngine_PrintEnginePropertyKey_Enum, "PrintEnginePropertyKey");

}

