
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPalette.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQPalette_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPalette

//  Constructor QPalette::QPalette()


static void _init_ctor_QPalette_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QPalette *> ();
}

static void _call_ctor_QPalette_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPalette *> (new QPalette ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPalette_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette()\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_0, &_call_ctor_QPalette_0);
}

//  Constructor QPalette::QPalette(const QColor &button)


static void _init_ctor_QPalette_1905 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return_new<QPalette *> ();
}

static void _call_ctor_QPalette_1905 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QColor &arg1 = args.read<const QColor & > ();
  ret.write<QPalette *> (new QPalette (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPalette_1905 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette(const QColor &button)\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_1905, &_call_ctor_QPalette_1905);
}

//  Constructor QPalette::QPalette(Qt::GlobalColor button)


static void _init_ctor_QPalette_1853 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > (argspec_0);
  decl->set_return_new<QPalette *> ();
}

static void _call_ctor_QPalette_1853 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::GlobalColor>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > ();
  ret.write<QPalette *> (new QPalette (qt_gsi::QtToCppAdaptor<Qt::GlobalColor>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPalette_1853 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette(Qt::GlobalColor button)\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_1853, &_call_ctor_QPalette_1853);
}

//  Constructor QPalette::QPalette(const QColor &button, const QColor &window)


static void _init_ctor_QPalette_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const QColor & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("window");
  decl->add_arg<const QColor & > (argspec_1);
  decl->set_return_new<QPalette *> ();
}

static void _call_ctor_QPalette_3702 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QColor &arg1 = args.read<const QColor & > ();
  const QColor &arg2 = args.read<const QColor & > ();
  ret.write<QPalette *> (new QPalette (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPalette_3702 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette(const QColor &button, const QColor &window)\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_3702, &_call_ctor_QPalette_3702);
}

//  Constructor QPalette::QPalette(const QBrush &windowText, const QBrush &button, const QBrush &light, const QBrush &dark, const QBrush &mid, const QBrush &text, const QBrush &bright_text, const QBrush &base, const QBrush &window)


static void _init_ctor_QPalette_16326 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("windowText");
  decl->add_arg<const QBrush & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("button");
  decl->add_arg<const QBrush & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("light");
  decl->add_arg<const QBrush & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("dark");
  decl->add_arg<const QBrush & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("mid");
  decl->add_arg<const QBrush & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QBrush & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("bright_text");
  decl->add_arg<const QBrush & > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("base");
  decl->add_arg<const QBrush & > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("window");
  decl->add_arg<const QBrush & > (argspec_8);
  decl->set_return_new<QPalette *> ();
}

static void _call_ctor_QPalette_16326 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  const QBrush &arg2 = args.read<const QBrush & > ();
  const QBrush &arg3 = args.read<const QBrush & > ();
  const QBrush &arg4 = args.read<const QBrush & > ();
  const QBrush &arg5 = args.read<const QBrush & > ();
  const QBrush &arg6 = args.read<const QBrush & > ();
  const QBrush &arg7 = args.read<const QBrush & > ();
  const QBrush &arg8 = args.read<const QBrush & > ();
  const QBrush &arg9 = args.read<const QBrush & > ();
  ret.write<QPalette *> (new QPalette (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPalette_16326 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette(const QBrush &windowText, const QBrush &button, const QBrush &light, const QBrush &dark, const QBrush &mid, const QBrush &text, const QBrush &bright_text, const QBrush &base, const QBrush &window)\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_16326, &_call_ctor_QPalette_16326);
}

//  Constructor QPalette::QPalette(const QColor &windowText, const QColor &window, const QColor &light, const QColor &dark, const QColor &mid, const QColor &text, const QColor &base)


static void _init_ctor_QPalette_12687 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("windowText");
  decl->add_arg<const QColor & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("window");
  decl->add_arg<const QColor & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("light");
  decl->add_arg<const QColor & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("dark");
  decl->add_arg<const QColor & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("mid");
  decl->add_arg<const QColor & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QColor & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("base");
  decl->add_arg<const QColor & > (argspec_6);
  decl->set_return_new<QPalette *> ();
}

static void _call_ctor_QPalette_12687 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QColor &arg1 = args.read<const QColor & > ();
  const QColor &arg2 = args.read<const QColor & > ();
  const QColor &arg3 = args.read<const QColor & > ();
  const QColor &arg4 = args.read<const QColor & > ();
  const QColor &arg5 = args.read<const QColor & > ();
  const QColor &arg6 = args.read<const QColor & > ();
  const QColor &arg7 = args.read<const QColor & > ();
  ret.write<QPalette *> (new QPalette (arg1, arg2, arg3, arg4, arg5, arg6, arg7));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPalette_12687 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette(const QColor &windowText, const QColor &window, const QColor &light, const QColor &dark, const QColor &mid, const QColor &text, const QColor &base)\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_12687, &_call_ctor_QPalette_12687);
}

//  Constructor QPalette::QPalette(const QPalette &palette)


static void _init_ctor_QPalette_2113 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("palette");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return_new<QPalette *> ();
}

static void _call_ctor_QPalette_2113 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ret.write<QPalette *> (new QPalette (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPalette_2113 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPalette::QPalette(const QPalette &palette)\nThis method creates an object of class QPalette.", &_init_ctor_QPalette_2113, &_call_ctor_QPalette_2113);
}

// const QBrush &QPalette::alternateBase()


static void _init_f_alternateBase_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_alternateBase_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->alternateBase ());
}

static qt_gsi::GenericMethod *_create_f_alternateBase_c0 ()
{
  return new qt_gsi::GenericMethod ("alternateBase", "@brief Method const QBrush &QPalette::alternateBase()\n", true, &_init_f_alternateBase_c0, &_call_f_alternateBase_c0);
}

// const QBrush &QPalette::background()


static void _init_f_background_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_background_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->background ());
}

static qt_gsi::GenericMethod *_create_f_background_c0 ()
{
  return new qt_gsi::GenericMethod ("background", "@brief Method const QBrush &QPalette::background()\n", true, &_init_f_background_c0, &_call_f_background_c0);
}

// const QBrush &QPalette::base()


static void _init_f_base_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_base_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->base ());
}

static qt_gsi::GenericMethod *_create_f_base_c0 ()
{
  return new qt_gsi::GenericMethod ("base", "@brief Method const QBrush &QPalette::base()\n", true, &_init_f_base_c0, &_call_f_base_c0);
}

// const QBrush &QPalette::brightText()


static void _init_f_brightText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_brightText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->brightText ());
}

static qt_gsi::GenericMethod *_create_f_brightText_c0 ()
{
  return new qt_gsi::GenericMethod ("brightText", "@brief Method const QBrush &QPalette::brightText()\n", true, &_init_f_brightText_c0, &_call_f_brightText_c0);
}

// const QBrush &QPalette::brush(QPalette::ColorGroup cg, QPalette::ColorRole cr)


static void _init_f_brush_c4545 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cg");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_1);
  decl->set_return<const QBrush & > ();
}

static void _call_f_brush_c4545 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > ();
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->brush (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_brush_c4545 ()
{
  return new qt_gsi::GenericMethod ("brush", "@brief Method const QBrush &QPalette::brush(QPalette::ColorGroup cg, QPalette::ColorRole cr)\n", true, &_init_f_brush_c4545, &_call_f_brush_c4545);
}

// const QBrush &QPalette::brush(QPalette::ColorRole cr)


static void _init_f_brush_c2265 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_0);
  decl->set_return<const QBrush & > ();
}

static void _call_f_brush_c2265 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->brush (qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_brush_c2265 ()
{
  return new qt_gsi::GenericMethod ("brush", "@brief Method const QBrush &QPalette::brush(QPalette::ColorRole cr)\n", true, &_init_f_brush_c2265, &_call_f_brush_c2265);
}

// const QBrush &QPalette::button()


static void _init_f_button_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_button_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->button ());
}

static qt_gsi::GenericMethod *_create_f_button_c0 ()
{
  return new qt_gsi::GenericMethod ("button", "@brief Method const QBrush &QPalette::button()\n", true, &_init_f_button_c0, &_call_f_button_c0);
}

// const QBrush &QPalette::buttonText()


static void _init_f_buttonText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_buttonText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->buttonText ());
}

static qt_gsi::GenericMethod *_create_f_buttonText_c0 ()
{
  return new qt_gsi::GenericMethod ("buttonText", "@brief Method const QBrush &QPalette::buttonText()\n", true, &_init_f_buttonText_c0, &_call_f_buttonText_c0);
}

// qint64 QPalette::cacheKey()


static void _init_f_cacheKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_cacheKey_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QPalette *)cls)->cacheKey ());
}

static qt_gsi::GenericMethod *_create_f_cacheKey_c0 ()
{
  return new qt_gsi::GenericMethod ("cacheKey", "@brief Method qint64 QPalette::cacheKey()\n", true, &_init_f_cacheKey_c0, &_call_f_cacheKey_c0);
}

// const QColor &QPalette::color(QPalette::ColorGroup cg, QPalette::ColorRole cr)


static void _init_f_color_c4545 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cg");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_1);
  decl->set_return<const QColor & > ();
}

static void _call_f_color_c4545 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > ();
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  ret.write<const QColor & > ((const QColor &)((QPalette *)cls)->color (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_color_c4545 ()
{
  return new qt_gsi::GenericMethod ("color", "@brief Method const QColor &QPalette::color(QPalette::ColorGroup cg, QPalette::ColorRole cr)\n", true, &_init_f_color_c4545, &_call_f_color_c4545);
}

// const QColor &QPalette::color(QPalette::ColorRole cr)


static void _init_f_color_c2265 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_0);
  decl->set_return<const QColor & > ();
}

static void _call_f_color_c2265 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  ret.write<const QColor & > ((const QColor &)((QPalette *)cls)->color (qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_color_c2265 ()
{
  return new qt_gsi::GenericMethod ("color", "@brief Method const QColor &QPalette::color(QPalette::ColorRole cr)\n", true, &_init_f_color_c2265, &_call_f_color_c2265);
}

// QPalette::ColorGroup QPalette::currentColorGroup()


static void _init_f_currentColorGroup_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPalette::ColorGroup>::target_type > ();
}

static void _call_f_currentColorGroup_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QPalette::ColorGroup>::target_type > ((qt_gsi::Converter<QPalette::ColorGroup>::target_type)qt_gsi::CppToQtAdaptor<QPalette::ColorGroup>(((QPalette *)cls)->currentColorGroup ()));
}

static qt_gsi::GenericMethod *_create_f_currentColorGroup_c0 ()
{
  return new qt_gsi::GenericMethod (":currentColorGroup", "@brief Method QPalette::ColorGroup QPalette::currentColorGroup()\n", true, &_init_f_currentColorGroup_c0, &_call_f_currentColorGroup_c0);
}

// const QBrush &QPalette::dark()


static void _init_f_dark_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_dark_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->dark ());
}

static qt_gsi::GenericMethod *_create_f_dark_c0 ()
{
  return new qt_gsi::GenericMethod ("dark", "@brief Method const QBrush &QPalette::dark()\n", true, &_init_f_dark_c0, &_call_f_dark_c0);
}

// const QBrush &QPalette::foreground()


static void _init_f_foreground_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_foreground_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->foreground ());
}

static qt_gsi::GenericMethod *_create_f_foreground_c0 ()
{
  return new qt_gsi::GenericMethod ("foreground", "@brief Method const QBrush &QPalette::foreground()\n", true, &_init_f_foreground_c0, &_call_f_foreground_c0);
}

// const QBrush &QPalette::highlight()


static void _init_f_highlight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_highlight_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->highlight ());
}

static qt_gsi::GenericMethod *_create_f_highlight_c0 ()
{
  return new qt_gsi::GenericMethod ("highlight", "@brief Method const QBrush &QPalette::highlight()\n", true, &_init_f_highlight_c0, &_call_f_highlight_c0);
}

// const QBrush &QPalette::highlightedText()


static void _init_f_highlightedText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_highlightedText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->highlightedText ());
}

static qt_gsi::GenericMethod *_create_f_highlightedText_c0 ()
{
  return new qt_gsi::GenericMethod ("highlightedText", "@brief Method const QBrush &QPalette::highlightedText()\n", true, &_init_f_highlightedText_c0, &_call_f_highlightedText_c0);
}

// bool QPalette::isBrushSet(QPalette::ColorGroup cg, QPalette::ColorRole cr)


static void _init_f_isBrushSet_c4545 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cg");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isBrushSet_c4545 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > ();
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  ret.write<bool > ((bool)((QPalette *)cls)->isBrushSet (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_isBrushSet_c4545 ()
{
  return new qt_gsi::GenericMethod ("isBrushSet?", "@brief Method bool QPalette::isBrushSet(QPalette::ColorGroup cg, QPalette::ColorRole cr)\n", true, &_init_f_isBrushSet_c4545, &_call_f_isBrushSet_c4545);
}

// bool QPalette::isCopyOf(const QPalette &p)


static void _init_f_isCopyOf_c2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isCopyOf_c2113 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ret.write<bool > ((bool)((QPalette *)cls)->isCopyOf (arg1));
}

static qt_gsi::GenericMethod *_create_f_isCopyOf_c2113 ()
{
  return new qt_gsi::GenericMethod ("isCopyOf?", "@brief Method bool QPalette::isCopyOf(const QPalette &p)\n", true, &_init_f_isCopyOf_c2113, &_call_f_isCopyOf_c2113);
}

// bool QPalette::isEqual(QPalette::ColorGroup cr1, QPalette::ColorGroup cr2)


static void _init_f_isEqual_c4668 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cr1");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cr2");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isEqual_c4668 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > ();
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg2 = args.read<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > ();
  ret.write<bool > ((bool)((QPalette *)cls)->isEqual (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_isEqual_c4668 ()
{
  return new qt_gsi::GenericMethod ("isEqual?", "@brief Method bool QPalette::isEqual(QPalette::ColorGroup cr1, QPalette::ColorGroup cr2)\n", true, &_init_f_isEqual_c4668, &_call_f_isEqual_c4668);
}

// const QBrush &QPalette::light()


static void _init_f_light_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_light_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->light ());
}

static qt_gsi::GenericMethod *_create_f_light_c0 ()
{
  return new qt_gsi::GenericMethod ("light", "@brief Method const QBrush &QPalette::light()\n", true, &_init_f_light_c0, &_call_f_light_c0);
}

// const QBrush &QPalette::link()


static void _init_f_link_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_link_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->link ());
}

static qt_gsi::GenericMethod *_create_f_link_c0 ()
{
  return new qt_gsi::GenericMethod ("link", "@brief Method const QBrush &QPalette::link()\n", true, &_init_f_link_c0, &_call_f_link_c0);
}

// const QBrush &QPalette::linkVisited()


static void _init_f_linkVisited_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_linkVisited_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->linkVisited ());
}

static qt_gsi::GenericMethod *_create_f_linkVisited_c0 ()
{
  return new qt_gsi::GenericMethod ("linkVisited", "@brief Method const QBrush &QPalette::linkVisited()\n", true, &_init_f_linkVisited_c0, &_call_f_linkVisited_c0);
}

// const QBrush &QPalette::mid()


static void _init_f_mid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_mid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->mid ());
}

static qt_gsi::GenericMethod *_create_f_mid_c0 ()
{
  return new qt_gsi::GenericMethod ("mid", "@brief Method const QBrush &QPalette::mid()\n", true, &_init_f_mid_c0, &_call_f_mid_c0);
}

// const QBrush &QPalette::midlight()


static void _init_f_midlight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_midlight_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->midlight ());
}

static qt_gsi::GenericMethod *_create_f_midlight_c0 ()
{
  return new qt_gsi::GenericMethod ("midlight", "@brief Method const QBrush &QPalette::midlight()\n", true, &_init_f_midlight_c0, &_call_f_midlight_c0);
}

// bool QPalette::operator!=(const QPalette &p)


static void _init_f_operator_excl__eq__c2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2113 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ret.write<bool > ((bool)((QPalette *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2113 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QPalette::operator!=(const QPalette &p)\n", true, &_init_f_operator_excl__eq__c2113, &_call_f_operator_excl__eq__c2113);
}

// QPalette &QPalette::operator=(const QPalette &palette)


static void _init_f_operator_eq__2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("palette");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<QPalette & > ();
}

static void _call_f_operator_eq__2113 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ret.write<QPalette & > ((QPalette &)((QPalette *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2113 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QPalette &QPalette::operator=(const QPalette &palette)\n", false, &_init_f_operator_eq__2113, &_call_f_operator_eq__2113);
}

// bool QPalette::operator==(const QPalette &p)


static void _init_f_operator_eq__eq__c2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2113 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ret.write<bool > ((bool)((QPalette *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2113 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QPalette::operator==(const QPalette &p)\n", true, &_init_f_operator_eq__eq__c2113, &_call_f_operator_eq__eq__c2113);
}

// QPalette QPalette::resolve(const QPalette &)


static void _init_f_resolve_c2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<QPalette > ();
}

static void _call_f_resolve_c2113 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ret.write<QPalette > ((QPalette)((QPalette *)cls)->resolve (arg1));
}

static qt_gsi::GenericMethod *_create_f_resolve_c2113 ()
{
  return new qt_gsi::GenericMethod ("resolve", "@brief Method QPalette QPalette::resolve(const QPalette &)\n", true, &_init_f_resolve_c2113, &_call_f_resolve_c2113);
}

// int QPalette::serialNumber()


static void _init_f_serialNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_serialNumber_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPalette *)cls)->serialNumber ());
}

static qt_gsi::GenericMethod *_create_f_serialNumber_c0 ()
{
  return new qt_gsi::GenericMethod ("serialNumber", "@brief Method int QPalette::serialNumber()\n", true, &_init_f_serialNumber_c0, &_call_f_serialNumber_c0);
}

// void QPalette::setBrush(QPalette::ColorRole cr, const QBrush &brush)


static void _init_f_setBrush_4067 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("brush");
  decl->add_arg<const QBrush & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setBrush_4067 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  const QBrush &arg2 = args.read<const QBrush & > ();
  ((QPalette *)cls)->setBrush (qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setBrush_4067 ()
{
  return new qt_gsi::GenericMethod ("setBrush", "@brief Method void QPalette::setBrush(QPalette::ColorRole cr, const QBrush &brush)\n", false, &_init_f_setBrush_4067, &_call_f_setBrush_4067);
}

// void QPalette::setBrush(QPalette::ColorGroup cg, QPalette::ColorRole cr, const QBrush &brush)


static void _init_f_setBrush_6347 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cg");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("brush");
  decl->add_arg<const QBrush & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setBrush_6347 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > ();
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  const QBrush &arg3 = args.read<const QBrush & > ();
  ((QPalette *)cls)->setBrush (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg2).cref(), arg3);
}

static qt_gsi::GenericMethod *_create_f_setBrush_6347 ()
{
  return new qt_gsi::GenericMethod ("setBrush", "@brief Method void QPalette::setBrush(QPalette::ColorGroup cg, QPalette::ColorRole cr, const QBrush &brush)\n", false, &_init_f_setBrush_6347, &_call_f_setBrush_6347);
}

// void QPalette::setColor(QPalette::ColorGroup cg, QPalette::ColorRole cr, const QColor &color)


static void _init_f_setColor_6342 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cg");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("color");
  decl->add_arg<const QColor & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setColor_6342 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > ();
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  const QColor &arg3 = args.read<const QColor & > ();
  ((QPalette *)cls)->setColor (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg2).cref(), arg3);
}

static qt_gsi::GenericMethod *_create_f_setColor_6342 ()
{
  return new qt_gsi::GenericMethod ("setColor", "@brief Method void QPalette::setColor(QPalette::ColorGroup cg, QPalette::ColorRole cr, const QColor &color)\n", false, &_init_f_setColor_6342, &_call_f_setColor_6342);
}

// void QPalette::setColor(QPalette::ColorRole cr, const QColor &color)


static void _init_f_setColor_4062 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("color");
  decl->add_arg<const QColor & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColor_4062 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  const QColor &arg2 = args.read<const QColor & > ();
  ((QPalette *)cls)->setColor (qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setColor_4062 ()
{
  return new qt_gsi::GenericMethod ("setColor", "@brief Method void QPalette::setColor(QPalette::ColorRole cr, const QColor &color)\n", false, &_init_f_setColor_4062, &_call_f_setColor_4062);
}

// void QPalette::setColorGroup(QPalette::ColorGroup cr, const QBrush &windowText, const QBrush &button, const QBrush &light, const QBrush &dark, const QBrush &mid, const QBrush &text, const QBrush &bright_text, const QBrush &base, const QBrush &window)


static void _init_f_setColorGroup_18606 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cr");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("windowText");
  decl->add_arg<const QBrush & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("button");
  decl->add_arg<const QBrush & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("light");
  decl->add_arg<const QBrush & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("dark");
  decl->add_arg<const QBrush & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("mid");
  decl->add_arg<const QBrush & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("text");
  decl->add_arg<const QBrush & > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("bright_text");
  decl->add_arg<const QBrush & > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("base");
  decl->add_arg<const QBrush & > (argspec_8);
  static gsi::ArgSpecBase argspec_9 ("window");
  decl->add_arg<const QBrush & > (argspec_9);
  decl->set_return<void > ();
}

static void _call_f_setColorGroup_18606 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > ();
  const QBrush &arg2 = args.read<const QBrush & > ();
  const QBrush &arg3 = args.read<const QBrush & > ();
  const QBrush &arg4 = args.read<const QBrush & > ();
  const QBrush &arg5 = args.read<const QBrush & > ();
  const QBrush &arg6 = args.read<const QBrush & > ();
  const QBrush &arg7 = args.read<const QBrush & > ();
  const QBrush &arg8 = args.read<const QBrush & > ();
  const QBrush &arg9 = args.read<const QBrush & > ();
  const QBrush &arg10 = args.read<const QBrush & > ();
  ((QPalette *)cls)->setColorGroup (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref(), arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
}

static qt_gsi::GenericMethod *_create_f_setColorGroup_18606 ()
{
  return new qt_gsi::GenericMethod ("setColorGroup", "@brief Method void QPalette::setColorGroup(QPalette::ColorGroup cr, const QBrush &windowText, const QBrush &button, const QBrush &light, const QBrush &dark, const QBrush &mid, const QBrush &text, const QBrush &bright_text, const QBrush &base, const QBrush &window)\n", false, &_init_f_setColorGroup_18606, &_call_f_setColorGroup_18606);
}

// void QPalette::setCurrentColorGroup(QPalette::ColorGroup cg)


static void _init_f_setCurrentColorGroup_2388 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cg");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentColorGroup_2388 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorGroup>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorGroup>::target_type & > ();
  ((QPalette *)cls)->setCurrentColorGroup (qt_gsi::QtToCppAdaptor<QPalette::ColorGroup>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setCurrentColorGroup_2388 ()
{
  return new qt_gsi::GenericMethod ("setCurrentColorGroup|currentColorGroup=", "@brief Method void QPalette::setCurrentColorGroup(QPalette::ColorGroup cg)\n", false, &_init_f_setCurrentColorGroup_2388, &_call_f_setCurrentColorGroup_2388);
}

// const QBrush &QPalette::shadow()


static void _init_f_shadow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_shadow_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->shadow ());
}

static qt_gsi::GenericMethod *_create_f_shadow_c0 ()
{
  return new qt_gsi::GenericMethod ("shadow", "@brief Method const QBrush &QPalette::shadow()\n", true, &_init_f_shadow_c0, &_call_f_shadow_c0);
}

// const QBrush &QPalette::text()


static void _init_f_text_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_text_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->text ());
}

static qt_gsi::GenericMethod *_create_f_text_c0 ()
{
  return new qt_gsi::GenericMethod ("text", "@brief Method const QBrush &QPalette::text()\n", true, &_init_f_text_c0, &_call_f_text_c0);
}

// const QBrush &QPalette::toolTipBase()


static void _init_f_toolTipBase_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_toolTipBase_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->toolTipBase ());
}

static qt_gsi::GenericMethod *_create_f_toolTipBase_c0 ()
{
  return new qt_gsi::GenericMethod ("toolTipBase", "@brief Method const QBrush &QPalette::toolTipBase()\n", true, &_init_f_toolTipBase_c0, &_call_f_toolTipBase_c0);
}

// const QBrush &QPalette::toolTipText()


static void _init_f_toolTipText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_toolTipText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->toolTipText ());
}

static qt_gsi::GenericMethod *_create_f_toolTipText_c0 ()
{
  return new qt_gsi::GenericMethod ("toolTipText", "@brief Method const QBrush &QPalette::toolTipText()\n", true, &_init_f_toolTipText_c0, &_call_f_toolTipText_c0);
}

// const QBrush &QPalette::window()


static void _init_f_window_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_window_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->window ());
}

static qt_gsi::GenericMethod *_create_f_window_c0 ()
{
  return new qt_gsi::GenericMethod ("window", "@brief Method const QBrush &QPalette::window()\n", true, &_init_f_window_c0, &_call_f_window_c0);
}

// const QBrush &QPalette::windowText()


static void _init_f_windowText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QBrush & > ();
}

static void _call_f_windowText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QBrush & > ((const QBrush &)((QPalette *)cls)->windowText ());
}

static qt_gsi::GenericMethod *_create_f_windowText_c0 ()
{
  return new qt_gsi::GenericMethod ("windowText", "@brief Method const QBrush &QPalette::windowText()\n", true, &_init_f_windowText_c0, &_call_f_windowText_c0);
}


namespace gsi
{
gsi::Class<QPalette> decl_QPalette ("QPalette",
  gsi::Methods(_create_ctor_QPalette_0 ()) +
  gsi::Methods(_create_ctor_QPalette_1905 ()) +
  gsi::Methods(_create_ctor_QPalette_1853 ()) +
  gsi::Methods(_create_ctor_QPalette_3702 ()) +
  gsi::Methods(_create_ctor_QPalette_16326 ()) +
  gsi::Methods(_create_ctor_QPalette_12687 ()) +
  gsi::Methods(_create_ctor_QPalette_2113 ()) +
  gsi::Methods(_create_f_alternateBase_c0 ()) +
  gsi::Methods(_create_f_background_c0 ()) +
  gsi::Methods(_create_f_base_c0 ()) +
  gsi::Methods(_create_f_brightText_c0 ()) +
  gsi::Methods(_create_f_brush_c4545 ()) +
  gsi::Methods(_create_f_brush_c2265 ()) +
  gsi::Methods(_create_f_button_c0 ()) +
  gsi::Methods(_create_f_buttonText_c0 ()) +
  gsi::Methods(_create_f_cacheKey_c0 ()) +
  gsi::Methods(_create_f_color_c4545 ()) +
  gsi::Methods(_create_f_color_c2265 ()) +
  gsi::Methods(_create_f_currentColorGroup_c0 ()) +
  gsi::Methods(_create_f_dark_c0 ()) +
  gsi::Methods(_create_f_foreground_c0 ()) +
  gsi::Methods(_create_f_highlight_c0 ()) +
  gsi::Methods(_create_f_highlightedText_c0 ()) +
  gsi::Methods(_create_f_isBrushSet_c4545 ()) +
  gsi::Methods(_create_f_isCopyOf_c2113 ()) +
  gsi::Methods(_create_f_isEqual_c4668 ()) +
  gsi::Methods(_create_f_light_c0 ()) +
  gsi::Methods(_create_f_link_c0 ()) +
  gsi::Methods(_create_f_linkVisited_c0 ()) +
  gsi::Methods(_create_f_mid_c0 ()) +
  gsi::Methods(_create_f_midlight_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2113 ()) +
  gsi::Methods(_create_f_operator_eq__2113 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2113 ()) +
  gsi::Methods(_create_f_resolve_c2113 ()) +
  gsi::Methods(_create_f_serialNumber_c0 ()) +
  gsi::Methods(_create_f_setBrush_4067 ()) +
  gsi::Methods(_create_f_setBrush_6347 ()) +
  gsi::Methods(_create_f_setColor_6342 ()) +
  gsi::Methods(_create_f_setColor_4062 ()) +
  gsi::Methods(_create_f_setColorGroup_18606 ()) +
  gsi::Methods(_create_f_setCurrentColorGroup_2388 ()) +
  gsi::Methods(_create_f_shadow_c0 ()) +
  gsi::Methods(_create_f_text_c0 ()) +
  gsi::Methods(_create_f_toolTipBase_c0 ()) +
  gsi::Methods(_create_f_toolTipText_c0 ()) +
  gsi::Methods(_create_f_window_c0 ()) +
  gsi::Methods(_create_f_windowText_c0 ()),
  "@qt\n@brief Binding of QPalette");

}


//  Implementation of the enum wrapper class for QPalette::ColorGroup
namespace qt_gsi
{

static QPalette_ColorGroup_Enum *c_1_QPalette_ColorGroup_Enum () { return new QPalette_ColorGroup_Enum (QPalette::Active); }
static QPalette_ColorGroup_Enum *c_2_QPalette_ColorGroup_Enum () { return new QPalette_ColorGroup_Enum (QPalette::Disabled); }
static QPalette_ColorGroup_Enum *c_3_QPalette_ColorGroup_Enum () { return new QPalette_ColorGroup_Enum (QPalette::Inactive); }
static QPalette_ColorGroup_Enum *c_4_QPalette_ColorGroup_Enum () { return new QPalette_ColorGroup_Enum (QPalette::NColorGroups); }
static QPalette_ColorGroup_Enum *c_5_QPalette_ColorGroup_Enum () { return new QPalette_ColorGroup_Enum (QPalette::Current); }
static QPalette_ColorGroup_Enum *c_6_QPalette_ColorGroup_Enum () { return new QPalette_ColorGroup_Enum (QPalette::All); }
static QPalette_ColorGroup_Enum *c_7_QPalette_ColorGroup_Enum () { return new QPalette_ColorGroup_Enum (QPalette::Normal); }

static gsi::Methods mkdefs_QPalette_ColorGroup () {
  return
    gsi::constant ("Active", &qt_gsi::c_1_QPalette_ColorGroup_Enum, "@brief Enum constant QPalette::Active") +
    gsi::constant ("Disabled", &qt_gsi::c_2_QPalette_ColorGroup_Enum, "@brief Enum constant QPalette::Disabled") +
    gsi::constant ("Inactive", &qt_gsi::c_3_QPalette_ColorGroup_Enum, "@brief Enum constant QPalette::Inactive") +
    gsi::constant ("NColorGroups", &qt_gsi::c_4_QPalette_ColorGroup_Enum, "@brief Enum constant QPalette::NColorGroups") +
    gsi::constant ("Current", &qt_gsi::c_5_QPalette_ColorGroup_Enum, "@brief Enum constant QPalette::Current") +
    gsi::constant ("All", &qt_gsi::c_6_QPalette_ColorGroup_Enum, "@brief Enum constant QPalette::All") +
    gsi::constant ("Normal", &qt_gsi::c_7_QPalette_ColorGroup_Enum, "@brief Enum constant QPalette::Normal");
}

static std::string to_s_QPalette_ColorGroup_Enum (const QPalette_ColorGroup_Enum *e)
{
  if (e->value () == QPalette::Active) { return tl::sprintf ("Active (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Disabled) { return tl::sprintf ("Disabled (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Inactive) { return tl::sprintf ("Inactive (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::NColorGroups) { return tl::sprintf ("NColorGroups (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Current) { return tl::sprintf ("Current (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::All) { return tl::sprintf ("All (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Normal) { return tl::sprintf ("Normal (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QPalette_ColorGroup_Enum (const QPalette_ColorGroup_Enum *e)
{
  return (unsigned int) e->value ();
}

static QPalette_ColorGroup_Enum *from_i_QPalette_ColorGroup_Enum (unsigned int i)
{
  return new QPalette_ColorGroup_Enum ((QPalette::ColorGroup) i);
}

static bool equalQPalette_ColorGroup_Enum (const QPalette_ColorGroup_Enum *e, QPalette_ColorGroup_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QPalette_ColorGroup_Enum (const QPalette_ColorGroup_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QPalette_ColorGroup_Enums oropQPalette_ColorGroup_Enums (const QPalette_ColorGroup_Enums *e, const QPalette_ColorGroup_Enums &d)
{
  return e->flags () | d.flags ();
}

static QPalette_ColorGroup_Enums andopQPalette_ColorGroup_Enums (const QPalette_ColorGroup_Enums *e, const QPalette_ColorGroup_Enums &d)
{
  return e->flags () & d.flags ();
}

static QPalette_ColorGroup_Enums xoropQPalette_ColorGroup_Enums (const QPalette_ColorGroup_Enums *e, const QPalette_ColorGroup_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QPalette_ColorGroup_Enums (const QPalette_ColorGroup_Enums *e)
{
  std::string l;
  if (e->testFlag (QPalette::Active)) { if (!l.empty ()) l += "|"; l += "Active"; }
  if (e->testFlag (QPalette::Disabled)) { if (!l.empty ()) l += "|"; l += "Disabled"; }
  if (e->testFlag (QPalette::Inactive)) { if (!l.empty ()) l += "|"; l += "Inactive"; }
  if (e->testFlag (QPalette::NColorGroups)) { if (!l.empty ()) l += "|"; l += "NColorGroups"; }
  if (e->testFlag (QPalette::Current)) { if (!l.empty ()) l += "|"; l += "Current"; }
  if (e->testFlag (QPalette::All)) { if (!l.empty ()) l += "|"; l += "All"; }
  if (e->testFlag (QPalette::Normal)) { if (!l.empty ()) l += "|"; l += "Normal"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QPalette_ColorGroup_Enums (const QPalette_ColorGroup_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QPalette_ColorGroup_Enums (const QPalette_ColorGroup_Enums *e, const QPalette_ColorGroup_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QPalette_ColorGroup_Enums> decl_QPalette_ColorGroup_Enums ("QPalette_QFlags_ColorGroup",
  gsi::method_ext ("|", &qt_gsi::oropQPalette_ColorGroup_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQPalette_ColorGroup_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQPalette_ColorGroup_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPalette_ColorGroup_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPalette_ColorGroup_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QPalette_ColorGroup_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QPalette::ColorGroup> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QPalette_ColorGroup_Enum> decl_QPalette_ColorGroup_Enum (decl_QPalette_ColorGroup_Enums, "QPalette_ColorGroup",
  qt_gsi::mkdefs_QPalette_ColorGroup () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPalette_ColorGroup_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPalette_ColorGroup_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQPalette_ColorGroup_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QPalette_ColorGroup_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QPalette_ColorGroup_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QPalette::ColorGroup enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QPalette> inject_QPalette_ColorGroup_Enum_in_parent (qt_gsi::mkdefs_QPalette_ColorGroup ());
static gsi::ClassExt<QPalette> decl_QPalette_ColorGroup_Enum_as_child (decl_QPalette_ColorGroup_Enum, "ColorGroup");

}


//  Implementation of the enum wrapper class for QPalette::ColorRole
namespace qt_gsi
{

static QPalette_ColorRole_Enum *c_1_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::WindowText); }
static QPalette_ColorRole_Enum *c_2_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Button); }
static QPalette_ColorRole_Enum *c_3_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Light); }
static QPalette_ColorRole_Enum *c_4_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Midlight); }
static QPalette_ColorRole_Enum *c_5_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Dark); }
static QPalette_ColorRole_Enum *c_6_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Mid); }
static QPalette_ColorRole_Enum *c_7_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Text); }
static QPalette_ColorRole_Enum *c_8_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::BrightText); }
static QPalette_ColorRole_Enum *c_9_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::ButtonText); }
static QPalette_ColorRole_Enum *c_10_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Base); }
static QPalette_ColorRole_Enum *c_11_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Window); }
static QPalette_ColorRole_Enum *c_12_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Shadow); }
static QPalette_ColorRole_Enum *c_13_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Highlight); }
static QPalette_ColorRole_Enum *c_14_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::HighlightedText); }
static QPalette_ColorRole_Enum *c_15_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Link); }
static QPalette_ColorRole_Enum *c_16_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::LinkVisited); }
static QPalette_ColorRole_Enum *c_17_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::AlternateBase); }
static QPalette_ColorRole_Enum *c_18_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::NoRole); }
static QPalette_ColorRole_Enum *c_19_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::ToolTipBase); }
static QPalette_ColorRole_Enum *c_20_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::ToolTipText); }
static QPalette_ColorRole_Enum *c_21_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::NColorRoles); }
static QPalette_ColorRole_Enum *c_22_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Foreground); }
static QPalette_ColorRole_Enum *c_23_QPalette_ColorRole_Enum () { return new QPalette_ColorRole_Enum (QPalette::Background); }

static gsi::Methods mkdefs_QPalette_ColorRole () {
  return
    gsi::constant ("WindowText", &qt_gsi::c_1_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::WindowText") +
    gsi::constant ("Button", &qt_gsi::c_2_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Button") +
    gsi::constant ("Light", &qt_gsi::c_3_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Light") +
    gsi::constant ("Midlight", &qt_gsi::c_4_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Midlight") +
    gsi::constant ("Dark", &qt_gsi::c_5_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Dark") +
    gsi::constant ("Mid", &qt_gsi::c_6_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Mid") +
    gsi::constant ("Text", &qt_gsi::c_7_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Text") +
    gsi::constant ("BrightText", &qt_gsi::c_8_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::BrightText") +
    gsi::constant ("ButtonText", &qt_gsi::c_9_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::ButtonText") +
    gsi::constant ("Base", &qt_gsi::c_10_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Base") +
    gsi::constant ("Window", &qt_gsi::c_11_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Window") +
    gsi::constant ("Shadow", &qt_gsi::c_12_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Shadow") +
    gsi::constant ("Highlight", &qt_gsi::c_13_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Highlight") +
    gsi::constant ("HighlightedText", &qt_gsi::c_14_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::HighlightedText") +
    gsi::constant ("Link", &qt_gsi::c_15_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Link") +
    gsi::constant ("LinkVisited", &qt_gsi::c_16_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::LinkVisited") +
    gsi::constant ("AlternateBase", &qt_gsi::c_17_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::AlternateBase") +
    gsi::constant ("NoRole", &qt_gsi::c_18_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::NoRole") +
    gsi::constant ("ToolTipBase", &qt_gsi::c_19_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::ToolTipBase") +
    gsi::constant ("ToolTipText", &qt_gsi::c_20_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::ToolTipText") +
    gsi::constant ("NColorRoles", &qt_gsi::c_21_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::NColorRoles") +
    gsi::constant ("Foreground", &qt_gsi::c_22_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Foreground") +
    gsi::constant ("Background", &qt_gsi::c_23_QPalette_ColorRole_Enum, "@brief Enum constant QPalette::Background");
}

static std::string to_s_QPalette_ColorRole_Enum (const QPalette_ColorRole_Enum *e)
{
  if (e->value () == QPalette::WindowText) { return tl::sprintf ("WindowText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Button) { return tl::sprintf ("Button (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Light) { return tl::sprintf ("Light (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Midlight) { return tl::sprintf ("Midlight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Dark) { return tl::sprintf ("Dark (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Mid) { return tl::sprintf ("Mid (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Text) { return tl::sprintf ("Text (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::BrightText) { return tl::sprintf ("BrightText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::ButtonText) { return tl::sprintf ("ButtonText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Base) { return tl::sprintf ("Base (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Window) { return tl::sprintf ("Window (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Shadow) { return tl::sprintf ("Shadow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Highlight) { return tl::sprintf ("Highlight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::HighlightedText) { return tl::sprintf ("HighlightedText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Link) { return tl::sprintf ("Link (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::LinkVisited) { return tl::sprintf ("LinkVisited (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::AlternateBase) { return tl::sprintf ("AlternateBase (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::NoRole) { return tl::sprintf ("NoRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::ToolTipBase) { return tl::sprintf ("ToolTipBase (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::ToolTipText) { return tl::sprintf ("ToolTipText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::NColorRoles) { return tl::sprintf ("NColorRoles (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Foreground) { return tl::sprintf ("Foreground (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPalette::Background) { return tl::sprintf ("Background (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QPalette_ColorRole_Enum (const QPalette_ColorRole_Enum *e)
{
  return (unsigned int) e->value ();
}

static QPalette_ColorRole_Enum *from_i_QPalette_ColorRole_Enum (unsigned int i)
{
  return new QPalette_ColorRole_Enum ((QPalette::ColorRole) i);
}

static bool equalQPalette_ColorRole_Enum (const QPalette_ColorRole_Enum *e, QPalette_ColorRole_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QPalette_ColorRole_Enum (const QPalette_ColorRole_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QPalette_ColorRole_Enums oropQPalette_ColorRole_Enums (const QPalette_ColorRole_Enums *e, const QPalette_ColorRole_Enums &d)
{
  return e->flags () | d.flags ();
}

static QPalette_ColorRole_Enums andopQPalette_ColorRole_Enums (const QPalette_ColorRole_Enums *e, const QPalette_ColorRole_Enums &d)
{
  return e->flags () & d.flags ();
}

static QPalette_ColorRole_Enums xoropQPalette_ColorRole_Enums (const QPalette_ColorRole_Enums *e, const QPalette_ColorRole_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QPalette_ColorRole_Enums (const QPalette_ColorRole_Enums *e)
{
  std::string l;
  if (e->testFlag (QPalette::WindowText)) { if (!l.empty ()) l += "|"; l += "WindowText"; }
  if (e->testFlag (QPalette::Button)) { if (!l.empty ()) l += "|"; l += "Button"; }
  if (e->testFlag (QPalette::Light)) { if (!l.empty ()) l += "|"; l += "Light"; }
  if (e->testFlag (QPalette::Midlight)) { if (!l.empty ()) l += "|"; l += "Midlight"; }
  if (e->testFlag (QPalette::Dark)) { if (!l.empty ()) l += "|"; l += "Dark"; }
  if (e->testFlag (QPalette::Mid)) { if (!l.empty ()) l += "|"; l += "Mid"; }
  if (e->testFlag (QPalette::Text)) { if (!l.empty ()) l += "|"; l += "Text"; }
  if (e->testFlag (QPalette::BrightText)) { if (!l.empty ()) l += "|"; l += "BrightText"; }
  if (e->testFlag (QPalette::ButtonText)) { if (!l.empty ()) l += "|"; l += "ButtonText"; }
  if (e->testFlag (QPalette::Base)) { if (!l.empty ()) l += "|"; l += "Base"; }
  if (e->testFlag (QPalette::Window)) { if (!l.empty ()) l += "|"; l += "Window"; }
  if (e->testFlag (QPalette::Shadow)) { if (!l.empty ()) l += "|"; l += "Shadow"; }
  if (e->testFlag (QPalette::Highlight)) { if (!l.empty ()) l += "|"; l += "Highlight"; }
  if (e->testFlag (QPalette::HighlightedText)) { if (!l.empty ()) l += "|"; l += "HighlightedText"; }
  if (e->testFlag (QPalette::Link)) { if (!l.empty ()) l += "|"; l += "Link"; }
  if (e->testFlag (QPalette::LinkVisited)) { if (!l.empty ()) l += "|"; l += "LinkVisited"; }
  if (e->testFlag (QPalette::AlternateBase)) { if (!l.empty ()) l += "|"; l += "AlternateBase"; }
  if (e->testFlag (QPalette::NoRole)) { if (!l.empty ()) l += "|"; l += "NoRole"; }
  if (e->testFlag (QPalette::ToolTipBase)) { if (!l.empty ()) l += "|"; l += "ToolTipBase"; }
  if (e->testFlag (QPalette::ToolTipText)) { if (!l.empty ()) l += "|"; l += "ToolTipText"; }
  if (e->testFlag (QPalette::NColorRoles)) { if (!l.empty ()) l += "|"; l += "NColorRoles"; }
  if (e->testFlag (QPalette::Foreground)) { if (!l.empty ()) l += "|"; l += "Foreground"; }
  if (e->testFlag (QPalette::Background)) { if (!l.empty ()) l += "|"; l += "Background"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QPalette_ColorRole_Enums (const QPalette_ColorRole_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QPalette_ColorRole_Enums (const QPalette_ColorRole_Enums *e, const QPalette_ColorRole_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QPalette_ColorRole_Enums> decl_QPalette_ColorRole_Enums ("QPalette_QFlags_ColorRole",
  gsi::method_ext ("|", &qt_gsi::oropQPalette_ColorRole_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQPalette_ColorRole_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQPalette_ColorRole_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPalette_ColorRole_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPalette_ColorRole_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QPalette_ColorRole_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QPalette::ColorRole> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QPalette_ColorRole_Enum> decl_QPalette_ColorRole_Enum (decl_QPalette_ColorRole_Enums, "QPalette_ColorRole",
  qt_gsi::mkdefs_QPalette_ColorRole () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPalette_ColorRole_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPalette_ColorRole_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQPalette_ColorRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QPalette_ColorRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QPalette_ColorRole_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QPalette::ColorRole enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QPalette> inject_QPalette_ColorRole_Enum_in_parent (qt_gsi::mkdefs_QPalette_ColorRole ());
static gsi::ClassExt<QPalette> decl_QPalette_ColorRole_Enum_as_child (decl_QPalette_ColorRole_Enum, "ColorRole");

}

