
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file generated/gsiDeclQNetworkAccessManager_EventAdaptor.cc
*  @brief Event adaptor implementations for QNetworkAccessManager
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQNetworkAccessManager_EventAdaptor.h"

// -----------------------------------------------------------------------
// class QNetworkAccessManager_EventAdaptor

QNetworkAccessManager_EventAdaptor::QNetworkAccessManager_EventAdaptor (QObject *host)
  : QObject ()
{
  connect (host, SIGNAL(authenticationRequired(QNetworkReply *, QAuthenticator *)), this, SLOT(authenticationRequired(QNetworkReply *, QAuthenticator *)));
  connect (host, SIGNAL(destroyed(QObject *)), this, SLOT(destroyed(QObject *)));
  connect (host, SIGNAL(finished(QNetworkReply *)), this, SLOT(finished(QNetworkReply *)));
  connect (host, SIGNAL(proxyAuthenticationRequired(const QNetworkProxy &, QAuthenticator *)), this, SLOT(proxyAuthenticationRequired(const QNetworkProxy &, QAuthenticator *)));
  connect (host, SIGNAL(sslErrors(QNetworkReply *, const QList<QSslError> &)), this, SLOT(sslErrors(QNetworkReply *, const QList<QSslError> &)));
}

//  Event QNetworkAccessManager::authenticationRequired(QNetworkReply *reply, QAuthenticator *authenticator)
void QNetworkAccessManager_EventAdaptor::authenticationRequired(QNetworkReply *reply, QAuthenticator *authenticator) {
BEGIN_PROTECTED
  authenticationRequired_e_3939(reply, authenticator);
END_PROTECTED
}

//  Event QNetworkAccessManager::destroyed(QObject *arg1)
void QNetworkAccessManager_EventAdaptor::destroyed(QObject *arg1) {
BEGIN_PROTECTED
  destroyed_e_1302(arg1);
END_PROTECTED
}

//  Event QNetworkAccessManager::finished(QNetworkReply *reply)
void QNetworkAccessManager_EventAdaptor::finished(QNetworkReply *reply) {
BEGIN_PROTECTED
  finished_e_1973(reply);
END_PROTECTED
}

//  Event QNetworkAccessManager::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)
void QNetworkAccessManager_EventAdaptor::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator) {
BEGIN_PROTECTED
  proxyAuthenticationRequired_e_4652(proxy, authenticator);
END_PROTECTED
}

//  Event QNetworkAccessManager::sslErrors(QNetworkReply *reply, const QList<QSslError> &errors)
void QNetworkAccessManager_EventAdaptor::sslErrors(QNetworkReply *reply, const QList<QSslError> &errors) {
BEGIN_PROTECTED
  sslErrors_e_4702(reply, qt_gsi::CppToQtAdaptor<QList<QSslError> >(errors));
END_PROTECTED
}
