
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQInputContext.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQInputContext_EventAdaptor.h"
#include "gsiDeclQInputContext_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QInputContext

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QInputContext::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QList<QAction *> QInputContext::actions()


static void _init_f_actions_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QAction *> >::target_type > ();
}

static void _call_f_actions_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QAction *> >::target_type > ((qt_gsi::Converter<QList<QAction *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QAction *> >(((QInputContext *)cls)->actions ()));
}

static qt_gsi::GenericMethod *_create_f_actions_0 ()
{
  return new qt_gsi::GenericMethod ("actions", "@brief Method QList<QAction *> QInputContext::actions()\n", false, &_init_f_actions_0, &_call_f_actions_0);
}

// bool QInputContext::filterEvent(const QEvent *event)


static void _init_f_filterEvent_1912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<const QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_filterEvent_1912 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QEvent *arg1 = args.read<const QEvent * > ();
  ret.write<bool > ((bool)((QInputContext *)cls)->filterEvent (arg1));
}

static qt_gsi::GenericMethod *_create_f_filterEvent_1912 ()
{
  return new qt_gsi::GenericMethod ("filterEvent", "@brief Method bool QInputContext::filterEvent(const QEvent *event)\n", false, &_init_f_filterEvent_1912, &_call_f_filterEvent_1912);
}

// QWidget *QInputContext::focusWidget()


static void _init_f_focusWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_focusWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QInputContext *)cls)->focusWidget ());
}

static qt_gsi::GenericMethod *_create_f_focusWidget_c0 ()
{
  return new qt_gsi::GenericMethod (":focusWidget", "@brief Method QWidget *QInputContext::focusWidget()\n", true, &_init_f_focusWidget_c0, &_call_f_focusWidget_c0);
}

// QFont QInputContext::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFont > ((QFont)((QInputContext *)cls)->font ());
}

static qt_gsi::GenericMethod *_create_f_font_c0 ()
{
  return new qt_gsi::GenericMethod ("font", "@brief Method QFont QInputContext::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
}

// QString QInputContext::identifierName()


static void _init_f_identifierName_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_identifierName_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QInputContext *)cls)->identifierName ());
}

static qt_gsi::GenericMethod *_create_f_identifierName_0 ()
{
  return new qt_gsi::GenericMethod ("identifierName", "@brief Method QString QInputContext::identifierName()\n", false, &_init_f_identifierName_0, &_call_f_identifierName_0);
}

// bool QInputContext::isComposing()


static void _init_f_isComposing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isComposing_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QInputContext *)cls)->isComposing ());
}

static qt_gsi::GenericMethod *_create_f_isComposing_c0 ()
{
  return new qt_gsi::GenericMethod ("isComposing?", "@brief Method bool QInputContext::isComposing()\n", true, &_init_f_isComposing_c0, &_call_f_isComposing_c0);
}

// QString QInputContext::language()


static void _init_f_language_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_language_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QInputContext *)cls)->language ());
}

static qt_gsi::GenericMethod *_create_f_language_0 ()
{
  return new qt_gsi::GenericMethod ("language", "@brief Method QString QInputContext::language()\n", false, &_init_f_language_0, &_call_f_language_0);
}

// void QInputContext::mouseHandler(int x, QMouseEvent *event)


static void _init_f_mouseHandler_2397 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QMouseEvent * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_mouseHandler_2397 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QMouseEvent *arg2 = args.read<QMouseEvent * > ();
  ((QInputContext *)cls)->mouseHandler (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_mouseHandler_2397 ()
{
  return new qt_gsi::GenericMethod ("mouseHandler", "@brief Method void QInputContext::mouseHandler(int x, QMouseEvent *event)\n", false, &_init_f_mouseHandler_2397, &_call_f_mouseHandler_2397);
}

// void QInputContext::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QInputContext *)cls)->reset ();
}

static qt_gsi::GenericMethod *_create_f_reset_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Method void QInputContext::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
}

// void QInputContext::sendEvent(const QInputMethodEvent &event)


static void _init_f_sendEvent_3045 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<const QInputMethodEvent & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_sendEvent_3045 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QInputMethodEvent &arg1 = args.read<const QInputMethodEvent & > ();
  ((QInputContext *)cls)->sendEvent (arg1);
}

static qt_gsi::GenericMethod *_create_f_sendEvent_3045 ()
{
  return new qt_gsi::GenericMethod ("sendEvent", "@brief Method void QInputContext::sendEvent(const QInputMethodEvent &event)\n", false, &_init_f_sendEvent_3045, &_call_f_sendEvent_3045);
}

// void QInputContext::setFocusWidget(QWidget *w)


static void _init_f_setFocusWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusWidget_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QInputContext *)cls)->setFocusWidget (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFocusWidget_1315 ()
{
  return new qt_gsi::GenericMethod ("setFocusWidget|focusWidget=", "@brief Method void QInputContext::setFocusWidget(QWidget *w)\n", false, &_init_f_setFocusWidget_1315, &_call_f_setFocusWidget_1315);
}

// QTextFormat QInputContext::standardFormat(QInputContext::StandardFormat s)


static void _init_f_standardFormat_c3336 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const qt_gsi::Converter<QInputContext::StandardFormat>::target_type & > (argspec_0);
  decl->set_return<QTextFormat > ();
}

static void _call_f_standardFormat_c3336 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QInputContext::StandardFormat>::target_type & arg1 = args.read<const qt_gsi::Converter<QInputContext::StandardFormat>::target_type & > ();
  ret.write<QTextFormat > ((QTextFormat)((QInputContext *)cls)->standardFormat (qt_gsi::QtToCppAdaptor<QInputContext::StandardFormat>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_standardFormat_c3336 ()
{
  return new qt_gsi::GenericMethod ("standardFormat", "@brief Method QTextFormat QInputContext::standardFormat(QInputContext::StandardFormat s)\n", true, &_init_f_standardFormat_c3336, &_call_f_standardFormat_c3336);
}

// void QInputContext::update()


static void _init_f_update_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_update_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QInputContext *)cls)->update ();
}

static qt_gsi::GenericMethod *_create_f_update_0 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QInputContext::update()\n", false, &_init_f_update_0, &_call_f_update_0);
}

// void QInputContext::widgetDestroyed(QWidget *w)


static void _init_f_widgetDestroyed_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_widgetDestroyed_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QInputContext *)cls)->widgetDestroyed (arg1);
}

static qt_gsi::GenericMethod *_create_f_widgetDestroyed_1315 ()
{
  return new qt_gsi::GenericMethod ("widgetDestroyed", "@brief Method void QInputContext::widgetDestroyed(QWidget *w)\n", false, &_init_f_widgetDestroyed_1315, &_call_f_widgetDestroyed_1315);
}

// static QString QInputContext::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QInputContext::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QInputContext::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QInputContext::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QInputContext::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QInputContext::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QInputContext::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QInputContext::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QInputContext::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QInputContext::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QInputContext::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QInputContext::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QInputContext, QInputContext_EventAdaptor> ea_QInputContext;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QInputContext> decl_QInputContext (ea_QInputContext, decl_QObject, "QInputContext_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_actions_0 ()) +
  gsi::Methods(_create_f_filterEvent_1912 ()) +
  gsi::Methods(_create_f_focusWidget_c0 ()) +
  gsi::Methods(_create_f_font_c0 ()) +
  gsi::Methods(_create_f_identifierName_0 ()) +
  gsi::Methods(_create_f_isComposing_c0 ()) +
  gsi::Methods(_create_f_language_0 ()) +
  gsi::Methods(_create_f_mouseHandler_2397 ()) +
  gsi::Methods(_create_f_reset_0 ()) +
  gsi::Methods(_create_f_sendEvent_3045 ()) +
  gsi::Methods(_create_f_setFocusWidget_1315 ()) +
  gsi::Methods(_create_f_standardFormat_c3336 ()) +
  gsi::Methods(_create_f_update_0 ()) +
  gsi::Methods(_create_f_widgetDestroyed_1315 ()) +
  qt_gsi::qt_signal<QInputContext, QInputContext_EventAdaptor, QObject *> ("destroyed", &QInputContext_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QInputContext::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QInputContext");
}


class QInputContext_Adaptor : public QInputContext, public qt_gsi::QtObjectBase
{
public:

  virtual ~QInputContext_Adaptor();

  //  [adaptor ctor] QInputContext::QInputContext(QObject *parent)
  QInputContext_Adaptor() : QInputContext()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QInputContext::QInputContext(QObject *parent)
  QInputContext_Adaptor(QObject *parent) : QInputContext(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QInputContext::receivers(const char *signal)
  int fp_QInputContext_receivers_c1731 (const char *signal) const {
    return QInputContext::receivers(signal);
  }

  //  QObject *QInputContext::sender()
  QObject * fp_QInputContext_sender_c0 () const {
    return QInputContext::sender();
  }

  //  [adaptor impl] QList<QAction *> QInputContext::actions()
  qt_gsi::Converter<QList<QAction *> >::target_type cbs_actions_0_0()
  {
    return qt_gsi::CppToQtAdaptor<QList<QAction *> >(QInputContext::actions());
  }

  virtual QList<QAction *> actions()
  {
    if (cb_actions_0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QList<QAction *> >(cb_actions_0_0.issue<QInputContext_Adaptor, qt_gsi::Converter<QList<QAction *> >::target_type>(&QInputContext_Adaptor::cbs_actions_0_0)).cref();
    } else {
      return QInputContext::actions();
    }
  }

  //  [adaptor impl] bool QInputContext::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QInputContext::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QInputContext_Adaptor, bool, QEvent *>(&QInputContext_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QInputContext::event(arg1);
    }
  }

  //  [adaptor impl] bool QInputContext::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QInputContext::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QInputContext_Adaptor, bool, QObject *, QEvent *>(&QInputContext_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QInputContext::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QInputContext::filterEvent(const QEvent *event)
  bool cbs_filterEvent_1912_0(const QEvent *event)
  {
    return QInputContext::filterEvent(event);
  }

  virtual bool filterEvent(const QEvent *event)
  {
    if (cb_filterEvent_1912_0.can_issue()) {
      return cb_filterEvent_1912_0.issue<QInputContext_Adaptor, bool, const QEvent *>(&QInputContext_Adaptor::cbs_filterEvent_1912_0, event);
    } else {
      return QInputContext::filterEvent(event);
    }
  }

  //  [adaptor impl] QFont QInputContext::font()
  QFont cbs_font_c0_0() const
  {
    return QInputContext::font();
  }

  virtual QFont font() const
  {
    if (cb_font_c0_0.can_issue()) {
      return cb_font_c0_0.issue<QInputContext_Adaptor, QFont>(&QInputContext_Adaptor::cbs_font_c0_0);
    } else {
      return QInputContext::font();
    }
  }

  //  [adaptor impl] QString QInputContext::identifierName()
  QString cbs_identifierName_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("identifierName");
  }

  virtual QString identifierName()
  {
    if (cb_identifierName_0_0.can_issue()) {
      return cb_identifierName_0_0.issue<QInputContext_Adaptor, QString>(&QInputContext_Adaptor::cbs_identifierName_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("identifierName");
    }
  }

  //  [adaptor impl] bool QInputContext::isComposing()
  bool cbs_isComposing_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isComposing");
  }

  virtual bool isComposing() const
  {
    if (cb_isComposing_c0_0.can_issue()) {
      return cb_isComposing_c0_0.issue<QInputContext_Adaptor, bool>(&QInputContext_Adaptor::cbs_isComposing_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isComposing");
    }
  }

  //  [adaptor impl] QString QInputContext::language()
  QString cbs_language_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("language");
  }

  virtual QString language()
  {
    if (cb_language_0_0.can_issue()) {
      return cb_language_0_0.issue<QInputContext_Adaptor, QString>(&QInputContext_Adaptor::cbs_language_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("language");
    }
  }

  //  [adaptor impl] void QInputContext::mouseHandler(int x, QMouseEvent *event)
  void cbs_mouseHandler_2397_0(int x, QMouseEvent *event)
  {
    QInputContext::mouseHandler(x, event);
  }

  virtual void mouseHandler(int x, QMouseEvent *event)
  {
    if (cb_mouseHandler_2397_0.can_issue()) {
      cb_mouseHandler_2397_0.issue<QInputContext_Adaptor, int, QMouseEvent *>(&QInputContext_Adaptor::cbs_mouseHandler_2397_0, x, event);
    } else {
      QInputContext::mouseHandler(x, event);
    }
  }

  //  [adaptor impl] void QInputContext::reset()
  void cbs_reset_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("reset");
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QInputContext_Adaptor>(&QInputContext_Adaptor::cbs_reset_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("reset");
    }
  }

  //  [adaptor impl] void QInputContext::setFocusWidget(QWidget *w)
  void cbs_setFocusWidget_1315_0(QWidget *w)
  {
    QInputContext::setFocusWidget(w);
  }

  virtual void setFocusWidget(QWidget *w)
  {
    if (cb_setFocusWidget_1315_0.can_issue()) {
      cb_setFocusWidget_1315_0.issue<QInputContext_Adaptor, QWidget *>(&QInputContext_Adaptor::cbs_setFocusWidget_1315_0, w);
    } else {
      QInputContext::setFocusWidget(w);
    }
  }

  //  [adaptor impl] void QInputContext::update()
  void cbs_update_0_0()
  {
    QInputContext::update();
  }

  virtual void update()
  {
    if (cb_update_0_0.can_issue()) {
      cb_update_0_0.issue<QInputContext_Adaptor>(&QInputContext_Adaptor::cbs_update_0_0);
    } else {
      QInputContext::update();
    }
  }

  //  [adaptor impl] void QInputContext::widgetDestroyed(QWidget *w)
  void cbs_widgetDestroyed_1315_0(QWidget *w)
  {
    QInputContext::widgetDestroyed(w);
  }

  virtual void widgetDestroyed(QWidget *w)
  {
    if (cb_widgetDestroyed_1315_0.can_issue()) {
      cb_widgetDestroyed_1315_0.issue<QInputContext_Adaptor, QWidget *>(&QInputContext_Adaptor::cbs_widgetDestroyed_1315_0, w);
    } else {
      QInputContext::widgetDestroyed(w);
    }
  }

  //  [adaptor impl] void QInputContext::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QInputContext::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QInputContext_Adaptor, QChildEvent *>(&QInputContext_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QInputContext::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputContext::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QInputContext::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QInputContext_Adaptor, QEvent *>(&QInputContext_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QInputContext::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputContext::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QInputContext::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QInputContext_Adaptor, const char *>(&QInputContext_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QInputContext::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QInputContext::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QInputContext::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QInputContext_Adaptor, QTimerEvent *>(&QInputContext_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QInputContext::timerEvent(arg1);
    }
  }

  gsi::Callback cb_actions_0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_filterEvent_1912_0;
  gsi::Callback cb_font_c0_0;
  gsi::Callback cb_identifierName_0_0;
  gsi::Callback cb_isComposing_c0_0;
  gsi::Callback cb_language_0_0;
  gsi::Callback cb_mouseHandler_2397_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_setFocusWidget_1315_0;
  gsi::Callback cb_update_0_0;
  gsi::Callback cb_widgetDestroyed_1315_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QInputContext_Adaptor::~QInputContext_Adaptor() { }

//  Constructor QInputContext::QInputContext(QObject *parent) (adaptor class)

static void _init_ctor_QInputContext_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QInputContext_Adaptor *> ();
}

static void _call_ctor_QInputContext_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QInputContext_Adaptor *> (new QInputContext_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QInputContext_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QInputContext::QInputContext(QObject *parent)\nThis method creates an object of class QInputContext.", &_init_ctor_QInputContext_Adaptor_1302, &_call_ctor_QInputContext_Adaptor_1302);
}

// int QInputContext::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QInputContext_Adaptor *)cls)->fp_QInputContext_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QInputContext::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QInputContext::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QInputContext_Adaptor *)cls)->fp_QInputContext_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QInputContext::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QList<QAction *> QInputContext::actions()

static void _init_cbs_actions_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QAction *> >::target_type > ();
}

static void _call_cbs_actions_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QAction *> >::target_type > ((qt_gsi::Converter<QList<QAction *> >::target_type)((QInputContext_Adaptor *)cls)->cbs_actions_0_0 ());
}

static void _set_callback_cbs_actions_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_actions_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actions_0_0 ()
{
  return new qt_gsi::GenericMethod ("actions", "@hide", false, &_init_cbs_actions_0_0, &_call_cbs_actions_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actions_0_0 ()
{
  return new qt_gsi::GenericMethod ("actions", "@brief Virtual method QList<QAction *> QInputContext::actions()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actions_0_0, &_call_cbs_actions_0_0, &_set_callback_cbs_actions_0_0);
}


// bool QInputContext::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QInputContext_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QInputContext::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QInputContext::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QInputContext_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QInputContext::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// bool QInputContext::filterEvent(const QEvent *event)

static void _init_cbs_filterEvent_1912_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<const QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_filterEvent_1912_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QEvent *arg1 = args.read<const QEvent * > ();
  ret.write<bool > ((bool)((QInputContext_Adaptor *)cls)->cbs_filterEvent_1912_0 (arg1));
}

static void _set_callback_cbs_filterEvent_1912_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_filterEvent_1912_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_filterEvent_1912_0 ()
{
  return new qt_gsi::GenericMethod ("filterEvent", "@hide", false, &_init_cbs_filterEvent_1912_0, &_call_cbs_filterEvent_1912_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_filterEvent_1912_0 ()
{
  return new qt_gsi::GenericMethod ("filterEvent", "@brief Virtual method bool QInputContext::filterEvent(const QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_filterEvent_1912_0, &_call_cbs_filterEvent_1912_0, &_set_callback_cbs_filterEvent_1912_0);
}


// QFont QInputContext::font()

static void _init_cbs_font_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_cbs_font_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFont > ((QFont)((QInputContext_Adaptor *)cls)->cbs_font_c0_0 ());
}

static void _set_callback_cbs_font_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_font_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_font_c0_0 ()
{
  return new qt_gsi::GenericMethod ("font", "@hide", true, &_init_cbs_font_c0_0, &_call_cbs_font_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_font_c0_0 ()
{
  return new qt_gsi::GenericMethod ("font", "@brief Virtual method QFont QInputContext::font()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_font_c0_0, &_call_cbs_font_c0_0, &_set_callback_cbs_font_c0_0);
}


// QString QInputContext::identifierName()

static void _init_cbs_identifierName_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_identifierName_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QInputContext_Adaptor *)cls)->cbs_identifierName_0_0 ());
}

static void _set_callback_cbs_identifierName_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_identifierName_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_identifierName_0_0 ()
{
  return new qt_gsi::GenericMethod ("identifierName", "@hide", false, &_init_cbs_identifierName_0_0, &_call_cbs_identifierName_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_identifierName_0_0 ()
{
  return new qt_gsi::GenericMethod ("identifierName", "@brief Virtual method QString QInputContext::identifierName()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_identifierName_0_0, &_call_cbs_identifierName_0_0, &_set_callback_cbs_identifierName_0_0);
}


// bool QInputContext::isComposing()

static void _init_cbs_isComposing_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isComposing_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QInputContext_Adaptor *)cls)->cbs_isComposing_c0_0 ());
}

static void _set_callback_cbs_isComposing_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_isComposing_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isComposing_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isComposing", "@hide", true, &_init_cbs_isComposing_c0_0, &_call_cbs_isComposing_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isComposing_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isComposing", "@brief Virtual method bool QInputContext::isComposing()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isComposing_c0_0, &_call_cbs_isComposing_c0_0, &_set_callback_cbs_isComposing_c0_0);
}


// QString QInputContext::language()

static void _init_cbs_language_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_language_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QInputContext_Adaptor *)cls)->cbs_language_0_0 ());
}

static void _set_callback_cbs_language_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_language_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_language_0_0 ()
{
  return new qt_gsi::GenericMethod ("language", "@hide", false, &_init_cbs_language_0_0, &_call_cbs_language_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_language_0_0 ()
{
  return new qt_gsi::GenericMethod ("language", "@brief Virtual method QString QInputContext::language()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_language_0_0, &_call_cbs_language_0_0, &_set_callback_cbs_language_0_0);
}


// void QInputContext::mouseHandler(int x, QMouseEvent *event)

static void _init_cbs_mouseHandler_2397_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QMouseEvent * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_mouseHandler_2397_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QMouseEvent *arg2 = args.read<QMouseEvent * > ();
  ((QInputContext_Adaptor *)cls)->cbs_mouseHandler_2397_0 (arg1, arg2);
}

static void _set_callback_cbs_mouseHandler_2397_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_mouseHandler_2397_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseHandler_2397_0 ()
{
  return new qt_gsi::GenericMethod ("mouseHandler", "@hide", false, &_init_cbs_mouseHandler_2397_0, &_call_cbs_mouseHandler_2397_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseHandler_2397_0 ()
{
  return new qt_gsi::GenericMethod ("mouseHandler", "@brief Virtual method void QInputContext::mouseHandler(int x, QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseHandler_2397_0, &_call_cbs_mouseHandler_2397_0, &_set_callback_cbs_mouseHandler_2397_0);
}


// void QInputContext::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QInputContext_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_reset_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QInputContext::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
}


// void QInputContext::setFocusWidget(QWidget *w)

static void _init_cbs_setFocusWidget_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setFocusWidget_1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QInputContext_Adaptor *)cls)->cbs_setFocusWidget_1315_0 (arg1);
}

static void _set_callback_cbs_setFocusWidget_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_setFocusWidget_1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setFocusWidget_1315_0 ()
{
  return new qt_gsi::GenericMethod ("setFocusWidget", "@hide", false, &_init_cbs_setFocusWidget_1315_0, &_call_cbs_setFocusWidget_1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setFocusWidget_1315_0 ()
{
  return new qt_gsi::GenericMethod ("setFocusWidget", "@brief Virtual method void QInputContext::setFocusWidget(QWidget *w)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFocusWidget_1315_0, &_call_cbs_setFocusWidget_1315_0, &_set_callback_cbs_setFocusWidget_1315_0);
}


// void QInputContext::update()

static void _init_cbs_update_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_update_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QInputContext_Adaptor *)cls)->cbs_update_0_0 ();
}

static void _set_callback_cbs_update_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_update_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_update_0_0 ()
{
  return new qt_gsi::GenericMethod ("update", "@hide", false, &_init_cbs_update_0_0, &_call_cbs_update_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_update_0_0 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Virtual method void QInputContext::update()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_update_0_0, &_call_cbs_update_0_0, &_set_callback_cbs_update_0_0);
}


// void QInputContext::widgetDestroyed(QWidget *w)

static void _init_cbs_widgetDestroyed_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_widgetDestroyed_1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QInputContext_Adaptor *)cls)->cbs_widgetDestroyed_1315_0 (arg1);
}

static void _set_callback_cbs_widgetDestroyed_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_widgetDestroyed_1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_widgetDestroyed_1315_0 ()
{
  return new qt_gsi::GenericMethod ("widgetDestroyed", "@hide", false, &_init_cbs_widgetDestroyed_1315_0, &_call_cbs_widgetDestroyed_1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_widgetDestroyed_1315_0 ()
{
  return new qt_gsi::GenericMethod ("widgetDestroyed", "@brief Virtual method void QInputContext::widgetDestroyed(QWidget *w)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_widgetDestroyed_1315_0, &_call_cbs_widgetDestroyed_1315_0, &_set_callback_cbs_widgetDestroyed_1315_0);
}


// void QInputContext::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QInputContext_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QInputContext::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QInputContext::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QInputContext_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QInputContext::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QInputContext::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QInputContext_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QInputContext::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QInputContext::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QInputContext_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QInputContext::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QInputContext> decl_QInputContext;

gsi::Class<QInputContext_Adaptor> decl_QInputContext_Adaptor (decl_QInputContext, "QInputContext",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_actions_0_0 ()) +
  gsi::Methods(_create_callback_cbs_actions_0_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_filterEvent_1912_0 ()) +
  gsi::Methods(_create_callback_cbs_filterEvent_1912_0 ()) +
  gsi::Methods(_create_cbs_font_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_font_c0_0 ()) +
  gsi::Methods(_create_cbs_identifierName_0_0 ()) +
  gsi::Methods(_create_callback_cbs_identifierName_0_0 ()) +
  gsi::Methods(_create_cbs_isComposing_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_isComposing_c0_0 ()) +
  gsi::Methods(_create_cbs_language_0_0 ()) +
  gsi::Methods(_create_callback_cbs_language_0_0 ()) +
  gsi::Methods(_create_cbs_mouseHandler_2397_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseHandler_2397_0 ()) +
  gsi::Methods(_create_cbs_reset_0_0 ()) +
  gsi::Methods(_create_callback_cbs_reset_0_0 ()) +
  gsi::Methods(_create_cbs_setFocusWidget_1315_0 ()) +
  gsi::Methods(_create_callback_cbs_setFocusWidget_1315_0 ()) +
  gsi::Methods(_create_cbs_update_0_0 ()) +
  gsi::Methods(_create_callback_cbs_update_0_0 ()) +
  gsi::Methods(_create_cbs_widgetDestroyed_1315_0 ()) +
  gsi::Methods(_create_callback_cbs_widgetDestroyed_1315_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QInputContext_Adaptor_1302 ()),
  "@qt\n@brief Binding of QInputContext");

}


//  Implementation of the enum wrapper class for QInputContext::StandardFormat
namespace qt_gsi
{

static QInputContext_StandardFormat_Enum *c_1_QInputContext_StandardFormat_Enum () { return new QInputContext_StandardFormat_Enum (QInputContext::PreeditFormat); }
static QInputContext_StandardFormat_Enum *c_2_QInputContext_StandardFormat_Enum () { return new QInputContext_StandardFormat_Enum (QInputContext::SelectionFormat); }

static gsi::Methods mkdefs_QInputContext_StandardFormat () {
  return
    gsi::constant ("PreeditFormat", &qt_gsi::c_1_QInputContext_StandardFormat_Enum, "@brief Enum constant QInputContext::PreeditFormat") +
    gsi::constant ("SelectionFormat", &qt_gsi::c_2_QInputContext_StandardFormat_Enum, "@brief Enum constant QInputContext::SelectionFormat");
}

static std::string to_s_QInputContext_StandardFormat_Enum (const QInputContext_StandardFormat_Enum *e)
{
  if (e->value () == QInputContext::PreeditFormat) { return tl::sprintf ("PreeditFormat (%u)", (unsigned int) e->value ()); }
  if (e->value () == QInputContext::SelectionFormat) { return tl::sprintf ("SelectionFormat (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QInputContext_StandardFormat_Enum (const QInputContext_StandardFormat_Enum *e)
{
  return (unsigned int) e->value ();
}

static QInputContext_StandardFormat_Enum *from_i_QInputContext_StandardFormat_Enum (unsigned int i)
{
  return new QInputContext_StandardFormat_Enum ((QInputContext::StandardFormat) i);
}

static bool equalQInputContext_StandardFormat_Enum (const QInputContext_StandardFormat_Enum *e, QInputContext_StandardFormat_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QInputContext_StandardFormat_Enum (const QInputContext_StandardFormat_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QInputContext_StandardFormat_Enums oropQInputContext_StandardFormat_Enums (const QInputContext_StandardFormat_Enums *e, const QInputContext_StandardFormat_Enums &d)
{
  return e->flags () | d.flags ();
}

static QInputContext_StandardFormat_Enums andopQInputContext_StandardFormat_Enums (const QInputContext_StandardFormat_Enums *e, const QInputContext_StandardFormat_Enums &d)
{
  return e->flags () & d.flags ();
}

static QInputContext_StandardFormat_Enums xoropQInputContext_StandardFormat_Enums (const QInputContext_StandardFormat_Enums *e, const QInputContext_StandardFormat_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QInputContext_StandardFormat_Enums (const QInputContext_StandardFormat_Enums *e)
{
  std::string l;
  if (e->testFlag (QInputContext::PreeditFormat)) { if (!l.empty ()) l += "|"; l += "PreeditFormat"; }
  if (e->testFlag (QInputContext::SelectionFormat)) { if (!l.empty ()) l += "|"; l += "SelectionFormat"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QInputContext_StandardFormat_Enums (const QInputContext_StandardFormat_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QInputContext_StandardFormat_Enums (const QInputContext_StandardFormat_Enums *e, const QInputContext_StandardFormat_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QInputContext_StandardFormat_Enums> decl_QInputContext_StandardFormat_Enums ("QInputContext_QFlags_StandardFormat",
  gsi::method_ext ("|", &qt_gsi::oropQInputContext_StandardFormat_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQInputContext_StandardFormat_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQInputContext_StandardFormat_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QInputContext_StandardFormat_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QInputContext_StandardFormat_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QInputContext_StandardFormat_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QInputContext::StandardFormat> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QInputContext_StandardFormat_Enum> decl_QInputContext_StandardFormat_Enum (decl_QInputContext_StandardFormat_Enums, "QInputContext_StandardFormat",
  qt_gsi::mkdefs_QInputContext_StandardFormat () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QInputContext_StandardFormat_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QInputContext_StandardFormat_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQInputContext_StandardFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QInputContext_StandardFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QInputContext_StandardFormat_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QInputContext::StandardFormat enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QInputContext> inject_QInputContext_StandardFormat_Enum_in_parent (qt_gsi::mkdefs_QInputContext_StandardFormat ());
static gsi::ClassExt<QInputContext> decl_QInputContext_StandardFormat_Enum_as_child (decl_QInputContext_StandardFormat_Enum, "StandardFormat");

}

