
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQIcon.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQIcon_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QIcon

//  Constructor QIcon::QIcon()


static void _init_ctor_QIcon_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QIcon *> ();
}

static void _call_ctor_QIcon_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIcon *> (new QIcon ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QIcon_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QIcon::QIcon()\nThis method creates an object of class QIcon.", &_init_ctor_QIcon_0, &_call_ctor_QIcon_0);
}

//  Constructor QIcon::QIcon(const QPixmap &pixmap)


static void _init_ctor_QIcon_2017 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_0);
  decl->set_return_new<QIcon *> ();
}

static void _call_ctor_QIcon_2017 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPixmap &arg1 = args.read<const QPixmap & > ();
  ret.write<QIcon *> (new QIcon (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QIcon_2017 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QIcon::QIcon(const QPixmap &pixmap)\nThis method creates an object of class QIcon.", &_init_ctor_QIcon_2017, &_call_ctor_QIcon_2017);
}

//  Constructor QIcon::QIcon(const QIcon &other)


static void _init_ctor_QIcon_1787 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return_new<QIcon *> ();
}

static void _call_ctor_QIcon_1787 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QIcon &arg1 = args.read<const QIcon & > ();
  ret.write<QIcon *> (new QIcon (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QIcon_1787 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QIcon::QIcon(const QIcon &other)\nThis method creates an object of class QIcon.", &_init_ctor_QIcon_1787, &_call_ctor_QIcon_1787);
}

//  Constructor QIcon::QIcon(const QString &fileName)


static void _init_ctor_QIcon_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QIcon *> ();
}

static void _call_ctor_QIcon_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QIcon *> (new QIcon (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QIcon_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QIcon::QIcon(const QString &fileName)\nThis method creates an object of class QIcon.", &_init_ctor_QIcon_2025, &_call_ctor_QIcon_2025);
}

//  Constructor QIcon::QIcon(QIconEngine *engine)


static void _init_ctor_QIcon_1694 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("engine");
  decl->add_arg<QIconEngine * > (argspec_0);
  decl->set_return_new<QIcon *> ();
}

static void _call_ctor_QIcon_1694 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIconEngine *arg1 = args.read<QIconEngine * > ();
  ret.write<QIcon *> (new QIcon (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QIcon_1694 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QIcon::QIcon(QIconEngine *engine)\nThis method creates an object of class QIcon.", &_init_ctor_QIcon_1694, &_call_ctor_QIcon_1694);
}

//  Constructor QIcon::QIcon(QIconEngineV2 *engine)


static void _init_ctor_QIcon_1830 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("engine");
  decl->add_arg<QIconEngineV2 * > (argspec_0);
  decl->set_return_new<QIcon *> ();
}

static void _call_ctor_QIcon_1830 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIconEngineV2 *arg1 = args.read<QIconEngineV2 * > ();
  ret.write<QIcon *> (new QIcon (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QIcon_1830 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QIcon::QIcon(QIconEngineV2 *engine)\nThis method creates an object of class QIcon.", &_init_ctor_QIcon_1830, &_call_ctor_QIcon_1830);
}

// QSize QIcon::actualSize(const QSize &size, QIcon::Mode mode, QIcon::State state)


static void _init_f_actualSize_c4543 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QIcon::Normal");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("state", true, "QIcon::Off");
  decl->add_arg<const qt_gsi::Converter<QIcon::State>::target_type & > (argspec_2);
  decl->set_return<QSize > ();
}

static void _call_f_actualSize_c4543 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > () : (const qt_gsi::Converter<QIcon::Mode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::Mode>(heap, QIcon::Normal));
  const qt_gsi::Converter<QIcon::State>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QIcon::State>::target_type & > () : (const qt_gsi::Converter<QIcon::State>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::State>(heap, QIcon::Off));
  ret.write<QSize > ((QSize)((QIcon *)cls)->actualSize (arg1, qt_gsi::QtToCppAdaptor<QIcon::Mode>(arg2).cref(), qt_gsi::QtToCppAdaptor<QIcon::State>(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_actualSize_c4543 ()
{
  return new qt_gsi::GenericMethod ("actualSize", "@brief Method QSize QIcon::actualSize(const QSize &size, QIcon::Mode mode, QIcon::State state)\n", true, &_init_f_actualSize_c4543, &_call_f_actualSize_c4543);
}

// void QIcon::addFile(const QString &fileName, const QSize &size, QIcon::Mode mode, QIcon::State state)


static void _init_f_addFile_6460 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("size", true, "QSize()");
  decl->add_arg<const QSize & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QIcon::Normal");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("state", true, "QIcon::Off");
  decl->add_arg<const qt_gsi::Converter<QIcon::State>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_addFile_6460 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QSize &arg2 = args ? args.read<const QSize & > () : (const QSize &)(QSize());
  tl::Heap heap;
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > () : (const qt_gsi::Converter<QIcon::Mode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::Mode>(heap, QIcon::Normal));
  const qt_gsi::Converter<QIcon::State>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QIcon::State>::target_type & > () : (const qt_gsi::Converter<QIcon::State>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::State>(heap, QIcon::Off));
  ((QIcon *)cls)->addFile (arg1, arg2, qt_gsi::QtToCppAdaptor<QIcon::Mode>(arg3).cref(), qt_gsi::QtToCppAdaptor<QIcon::State>(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_addFile_6460 ()
{
  return new qt_gsi::GenericMethod ("addFile", "@brief Method void QIcon::addFile(const QString &fileName, const QSize &size, QIcon::Mode mode, QIcon::State state)\n", false, &_init_f_addFile_6460, &_call_f_addFile_6460);
}

// void QIcon::addPixmap(const QPixmap &pixmap, QIcon::Mode mode, QIcon::State state)


static void _init_f_addPixmap_4755 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QIcon::Normal");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("state", true, "QIcon::Off");
  decl->add_arg<const qt_gsi::Converter<QIcon::State>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addPixmap_4755 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPixmap &arg1 = args.read<const QPixmap & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > () : (const qt_gsi::Converter<QIcon::Mode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::Mode>(heap, QIcon::Normal));
  const qt_gsi::Converter<QIcon::State>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QIcon::State>::target_type & > () : (const qt_gsi::Converter<QIcon::State>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::State>(heap, QIcon::Off));
  ((QIcon *)cls)->addPixmap (arg1, qt_gsi::QtToCppAdaptor<QIcon::Mode>(arg2).cref(), qt_gsi::QtToCppAdaptor<QIcon::State>(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_addPixmap_4755 ()
{
  return new qt_gsi::GenericMethod ("addPixmap", "@brief Method void QIcon::addPixmap(const QPixmap &pixmap, QIcon::Mode mode, QIcon::State state)\n", false, &_init_f_addPixmap_4755, &_call_f_addPixmap_4755);
}

// QList<QSize> QIcon::availableSizes(QIcon::Mode mode, QIcon::State state)


static void _init_f_availableSizes_c2846 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode", true, "QIcon::Normal");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("state", true, "QIcon::Off");
  decl->add_arg<const qt_gsi::Converter<QIcon::State>::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<QSize> >::target_type > ();
}

static void _call_f_availableSizes_c2846 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > () : (const qt_gsi::Converter<QIcon::Mode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::Mode>(heap, QIcon::Normal));
  const qt_gsi::Converter<QIcon::State>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QIcon::State>::target_type & > () : (const qt_gsi::Converter<QIcon::State>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::State>(heap, QIcon::Off));
  ret.write<qt_gsi::Converter<QList<QSize> >::target_type > ((qt_gsi::Converter<QList<QSize> >::target_type)qt_gsi::CppToQtAdaptor<QList<QSize> >(((QIcon *)cls)->availableSizes (qt_gsi::QtToCppAdaptor<QIcon::Mode>(arg1).cref(), qt_gsi::QtToCppAdaptor<QIcon::State>(arg2).cref())));
}

static qt_gsi::GenericMethod *_create_f_availableSizes_c2846 ()
{
  return new qt_gsi::GenericMethod ("availableSizes", "@brief Method QList<QSize> QIcon::availableSizes(QIcon::Mode mode, QIcon::State state)\n", true, &_init_f_availableSizes_c2846, &_call_f_availableSizes_c2846);
}

// qint64 QIcon::cacheKey()


static void _init_f_cacheKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_cacheKey_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QIcon *)cls)->cacheKey ());
}

static qt_gsi::GenericMethod *_create_f_cacheKey_c0 ()
{
  return new qt_gsi::GenericMethod ("cacheKey", "@brief Method qint64 QIcon::cacheKey()\n", true, &_init_f_cacheKey_c0, &_call_f_cacheKey_c0);
}

// void QIcon::detach()


static void _init_f_detach_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_detach_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QIcon *)cls)->detach ();
}

static qt_gsi::GenericMethod *_create_f_detach_0 ()
{
  return new qt_gsi::GenericMethod ("detach", "@brief Method void QIcon::detach()\n", false, &_init_f_detach_0, &_call_f_detach_0);
}

// bool QIcon::isDetached()


static void _init_f_isDetached_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDetached_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QIcon *)cls)->isDetached ());
}

static qt_gsi::GenericMethod *_create_f_isDetached_c0 ()
{
  return new qt_gsi::GenericMethod ("isDetached?", "@brief Method bool QIcon::isDetached()\n", true, &_init_f_isDetached_c0, &_call_f_isDetached_c0);
}

// bool QIcon::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QIcon *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QIcon::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// QIcon &QIcon::operator=(const QIcon &other)


static void _init_f_operator_eq__1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<QIcon & > ();
}

static void _call_f_operator_eq__1787 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QIcon &arg1 = args.read<const QIcon & > ();
  ret.write<QIcon & > ((QIcon &)((QIcon *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__1787 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QIcon &QIcon::operator=(const QIcon &other)\n", false, &_init_f_operator_eq__1787, &_call_f_operator_eq__1787);
}

// void QIcon::paint(QPainter *painter, const QRect &rect, QFlags<Qt::AlignmentFlag> alignment, QIcon::Mode mode, QIcon::State state)


static void _init_f_paint_c8490 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alignment", true, "Qt::AlignCenter");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("mode", true, "QIcon::Normal");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("state", true, "QIcon::Off");
  decl->add_arg<const qt_gsi::Converter<QIcon::State>::target_type & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_paint_c8490 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRect &arg2 = args.read<const QRect & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::AlignmentFlag> >(heap, Qt::AlignCenter));
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > () : (const qt_gsi::Converter<QIcon::Mode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::Mode>(heap, QIcon::Normal));
  const qt_gsi::Converter<QIcon::State>::target_type & arg5 = args ? args.read<const qt_gsi::Converter<QIcon::State>::target_type & > () : (const qt_gsi::Converter<QIcon::State>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::State>(heap, QIcon::Off));
  ((QIcon *)cls)->paint (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg3).cref(), qt_gsi::QtToCppAdaptor<QIcon::Mode>(arg4).cref(), qt_gsi::QtToCppAdaptor<QIcon::State>(arg5).cref());
}

static qt_gsi::GenericMethod *_create_f_paint_c8490 ()
{
  return new qt_gsi::GenericMethod ("paint", "@brief Method void QIcon::paint(QPainter *painter, const QRect &rect, QFlags<Qt::AlignmentFlag> alignment, QIcon::Mode mode, QIcon::State state)\n", true, &_init_f_paint_c8490, &_call_f_paint_c8490);
}

// void QIcon::paint(QPainter *painter, int x, int y, int w, int h, QFlags<Qt::AlignmentFlag> alignment, QIcon::Mode mode, QIcon::State state)


static void _init_f_paint_c9442 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("alignment", true, "Qt::AlignCenter");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("mode", true, "QIcon::Normal");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("state", true, "QIcon::Off");
  decl->add_arg<const qt_gsi::Converter<QIcon::State>::target_type & > (argspec_7);
  decl->set_return<void > ();
}

static void _call_f_paint_c9442 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  int arg5 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg6 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::AlignmentFlag> >(heap, Qt::AlignCenter));
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg7 = args ? args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > () : (const qt_gsi::Converter<QIcon::Mode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::Mode>(heap, QIcon::Normal));
  const qt_gsi::Converter<QIcon::State>::target_type & arg8 = args ? args.read<const qt_gsi::Converter<QIcon::State>::target_type & > () : (const qt_gsi::Converter<QIcon::State>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::State>(heap, QIcon::Off));
  ((QIcon *)cls)->paint (arg1, arg2, arg3, arg4, arg5, qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg6).cref(), qt_gsi::QtToCppAdaptor<QIcon::Mode>(arg7).cref(), qt_gsi::QtToCppAdaptor<QIcon::State>(arg8).cref());
}

static qt_gsi::GenericMethod *_create_f_paint_c9442 ()
{
  return new qt_gsi::GenericMethod ("paint", "@brief Method void QIcon::paint(QPainter *painter, int x, int y, int w, int h, QFlags<Qt::AlignmentFlag> alignment, QIcon::Mode mode, QIcon::State state)\n", true, &_init_f_paint_c9442, &_call_f_paint_c9442);
}

// QPixmap QIcon::pixmap(const QSize &size, QIcon::Mode mode, QIcon::State state)


static void _init_f_pixmap_c4543 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QIcon::Normal");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("state", true, "QIcon::Off");
  decl->add_arg<const qt_gsi::Converter<QIcon::State>::target_type & > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_f_pixmap_c4543 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > () : (const qt_gsi::Converter<QIcon::Mode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::Mode>(heap, QIcon::Normal));
  const qt_gsi::Converter<QIcon::State>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QIcon::State>::target_type & > () : (const qt_gsi::Converter<QIcon::State>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::State>(heap, QIcon::Off));
  ret.write<QPixmap > ((QPixmap)((QIcon *)cls)->pixmap (arg1, qt_gsi::QtToCppAdaptor<QIcon::Mode>(arg2).cref(), qt_gsi::QtToCppAdaptor<QIcon::State>(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_pixmap_c4543 ()
{
  return new qt_gsi::GenericMethod ("pixmap", "@brief Method QPixmap QIcon::pixmap(const QSize &size, QIcon::Mode mode, QIcon::State state)\n", true, &_init_f_pixmap_c4543, &_call_f_pixmap_c4543);
}

// QPixmap QIcon::pixmap(int w, int h, QIcon::Mode mode, QIcon::State state)


static void _init_f_pixmap_c4164 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QIcon::Normal");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("state", true, "QIcon::Off");
  decl->add_arg<const qt_gsi::Converter<QIcon::State>::target_type & > (argspec_3);
  decl->set_return<QPixmap > ();
}

static void _call_f_pixmap_c4164 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > () : (const qt_gsi::Converter<QIcon::Mode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::Mode>(heap, QIcon::Normal));
  const qt_gsi::Converter<QIcon::State>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QIcon::State>::target_type & > () : (const qt_gsi::Converter<QIcon::State>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::State>(heap, QIcon::Off));
  ret.write<QPixmap > ((QPixmap)((QIcon *)cls)->pixmap (arg1, arg2, qt_gsi::QtToCppAdaptor<QIcon::Mode>(arg3).cref(), qt_gsi::QtToCppAdaptor<QIcon::State>(arg4).cref()));
}

static qt_gsi::GenericMethod *_create_f_pixmap_c4164 ()
{
  return new qt_gsi::GenericMethod ("pixmap", "@brief Method QPixmap QIcon::pixmap(int w, int h, QIcon::Mode mode, QIcon::State state)\n", true, &_init_f_pixmap_c4164, &_call_f_pixmap_c4164);
}

// QPixmap QIcon::pixmap(int extent, QIcon::Mode mode, QIcon::State state)


static void _init_f_pixmap_c3505 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extent");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QIcon::Normal");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("state", true, "QIcon::Off");
  decl->add_arg<const qt_gsi::Converter<QIcon::State>::target_type & > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_f_pixmap_c3505 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > () : (const qt_gsi::Converter<QIcon::Mode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::Mode>(heap, QIcon::Normal));
  const qt_gsi::Converter<QIcon::State>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QIcon::State>::target_type & > () : (const qt_gsi::Converter<QIcon::State>::target_type &)(qt_gsi::CppToQtReadAdaptor<QIcon::State>(heap, QIcon::Off));
  ret.write<QPixmap > ((QPixmap)((QIcon *)cls)->pixmap (arg1, qt_gsi::QtToCppAdaptor<QIcon::Mode>(arg2).cref(), qt_gsi::QtToCppAdaptor<QIcon::State>(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_pixmap_c3505 ()
{
  return new qt_gsi::GenericMethod ("pixmap_ext", "@brief Method QPixmap QIcon::pixmap(int extent, QIcon::Mode mode, QIcon::State state)\n", true, &_init_f_pixmap_c3505, &_call_f_pixmap_c3505);
}

// int QIcon::serialNumber()


static void _init_f_serialNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_serialNumber_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QIcon *)cls)->serialNumber ());
}

static qt_gsi::GenericMethod *_create_f_serialNumber_c0 ()
{
  return new qt_gsi::GenericMethod ("serialNumber", "@brief Method int QIcon::serialNumber()\n", true, &_init_f_serialNumber_c0, &_call_f_serialNumber_c0);
}

// static QIcon QIcon::fromTheme(const QString &name, const QIcon &fallback)


static void _init_f_fromTheme_3704 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fallback", true, "QIcon()");
  decl->add_arg<const QIcon & > (argspec_1);
  decl->set_return<QIcon > ();
}

static void _call_f_fromTheme_3704 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QIcon &arg2 = args ? args.read<const QIcon & > () : (const QIcon &)(QIcon());
  ret.write<QIcon > ((QIcon)QIcon::fromTheme (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_fromTheme_3704 ()
{
  return new qt_gsi::GenericStaticMethod ("fromTheme", "@brief Static method QIcon QIcon::fromTheme(const QString &name, const QIcon &fallback)\nThis method is static and can be called without an instance.", &_init_f_fromTheme_3704, &_call_f_fromTheme_3704);
}

// static bool QIcon::hasThemeIcon(const QString &name)


static void _init_f_hasThemeIcon_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasThemeIcon_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)QIcon::hasThemeIcon (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_hasThemeIcon_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("hasThemeIcon", "@brief Static method bool QIcon::hasThemeIcon(const QString &name)\nThis method is static and can be called without an instance.", &_init_f_hasThemeIcon_2025, &_call_f_hasThemeIcon_2025);
}

// static void QIcon::setThemeName(const QString &path)


static void _init_f_setThemeName_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setThemeName_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QIcon::setThemeName (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setThemeName_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("setThemeName|themeName=", "@brief Static method void QIcon::setThemeName(const QString &path)\nThis method is static and can be called without an instance.", &_init_f_setThemeName_2025, &_call_f_setThemeName_2025);
}

// static void QIcon::setThemeSearchPaths(const QStringList &searchpath)


static void _init_f_setThemeSearchPaths_2437 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("searchpath");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setThemeSearchPaths_2437 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  QIcon::setThemeSearchPaths (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericStaticMethod *_create_f_setThemeSearchPaths_2437 ()
{
  return new qt_gsi::GenericStaticMethod ("setThemeSearchPaths|themeSearchPaths=", "@brief Static method void QIcon::setThemeSearchPaths(const QStringList &searchpath)\nThis method is static and can be called without an instance.", &_init_f_setThemeSearchPaths_2437, &_call_f_setThemeSearchPaths_2437);
}

// static QString QIcon::themeName()


static void _init_f_themeName_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_themeName_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)QIcon::themeName ());
}

static qt_gsi::GenericStaticMethod *_create_f_themeName_0 ()
{
  return new qt_gsi::GenericStaticMethod (":themeName", "@brief Static method QString QIcon::themeName()\nThis method is static and can be called without an instance.", &_init_f_themeName_0, &_call_f_themeName_0);
}

// static QStringList QIcon::themeSearchPaths()


static void _init_f_themeSearchPaths_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_themeSearchPaths_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(QIcon::themeSearchPaths ()));
}

static qt_gsi::GenericStaticMethod *_create_f_themeSearchPaths_0 ()
{
  return new qt_gsi::GenericStaticMethod (":themeSearchPaths", "@brief Static method QStringList QIcon::themeSearchPaths()\nThis method is static and can be called without an instance.", &_init_f_themeSearchPaths_0, &_call_f_themeSearchPaths_0);
}


namespace gsi
{
gsi::Class<QIcon> decl_QIcon ("QIcon",
  gsi::Methods(_create_ctor_QIcon_0 ()) +
  gsi::Methods(_create_ctor_QIcon_2017 ()) +
  gsi::Methods(_create_ctor_QIcon_1787 ()) +
  gsi::Methods(_create_ctor_QIcon_2025 ()) +
  gsi::Methods(_create_ctor_QIcon_1694 ()) +
  gsi::Methods(_create_ctor_QIcon_1830 ()) +
  gsi::Methods(_create_f_actualSize_c4543 ()) +
  gsi::Methods(_create_f_addFile_6460 ()) +
  gsi::Methods(_create_f_addPixmap_4755 ()) +
  gsi::Methods(_create_f_availableSizes_c2846 ()) +
  gsi::Methods(_create_f_cacheKey_c0 ()) +
  gsi::Methods(_create_f_detach_0 ()) +
  gsi::Methods(_create_f_isDetached_c0 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_operator_eq__1787 ()) +
  gsi::Methods(_create_f_paint_c8490 ()) +
  gsi::Methods(_create_f_paint_c9442 ()) +
  gsi::Methods(_create_f_pixmap_c4543 ()) +
  gsi::Methods(_create_f_pixmap_c4164 ()) +
  gsi::Methods(_create_f_pixmap_c3505 ()) +
  gsi::Methods(_create_f_serialNumber_c0 ()) +
  gsi::Methods(_create_f_fromTheme_3704 ()) +
  gsi::Methods(_create_f_hasThemeIcon_2025 ()) +
  gsi::Methods(_create_f_setThemeName_2025 ()) +
  gsi::Methods(_create_f_setThemeSearchPaths_2437 ()) +
  gsi::Methods(_create_f_themeName_0 ()) +
  gsi::Methods(_create_f_themeSearchPaths_0 ()),
  "@qt\n@brief Binding of QIcon");

}


//  Implementation of the enum wrapper class for QIcon::Mode
namespace qt_gsi
{

static QIcon_Mode_Enum *c_1_QIcon_Mode_Enum () { return new QIcon_Mode_Enum (QIcon::Normal); }
static QIcon_Mode_Enum *c_2_QIcon_Mode_Enum () { return new QIcon_Mode_Enum (QIcon::Disabled); }
static QIcon_Mode_Enum *c_3_QIcon_Mode_Enum () { return new QIcon_Mode_Enum (QIcon::Active); }
static QIcon_Mode_Enum *c_4_QIcon_Mode_Enum () { return new QIcon_Mode_Enum (QIcon::Selected); }

static gsi::Methods mkdefs_QIcon_Mode () {
  return
    gsi::constant ("Normal", &qt_gsi::c_1_QIcon_Mode_Enum, "@brief Enum constant QIcon::Normal") +
    gsi::constant ("Disabled", &qt_gsi::c_2_QIcon_Mode_Enum, "@brief Enum constant QIcon::Disabled") +
    gsi::constant ("Active", &qt_gsi::c_3_QIcon_Mode_Enum, "@brief Enum constant QIcon::Active") +
    gsi::constant ("Selected", &qt_gsi::c_4_QIcon_Mode_Enum, "@brief Enum constant QIcon::Selected");
}

static std::string to_s_QIcon_Mode_Enum (const QIcon_Mode_Enum *e)
{
  if (e->value () == QIcon::Normal) { return tl::sprintf ("Normal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QIcon::Disabled) { return tl::sprintf ("Disabled (%u)", (unsigned int) e->value ()); }
  if (e->value () == QIcon::Active) { return tl::sprintf ("Active (%u)", (unsigned int) e->value ()); }
  if (e->value () == QIcon::Selected) { return tl::sprintf ("Selected (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QIcon_Mode_Enum (const QIcon_Mode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QIcon_Mode_Enum *from_i_QIcon_Mode_Enum (unsigned int i)
{
  return new QIcon_Mode_Enum ((QIcon::Mode) i);
}

static bool equalQIcon_Mode_Enum (const QIcon_Mode_Enum *e, QIcon_Mode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QIcon_Mode_Enum (const QIcon_Mode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QIcon_Mode_Enums oropQIcon_Mode_Enums (const QIcon_Mode_Enums *e, const QIcon_Mode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QIcon_Mode_Enums andopQIcon_Mode_Enums (const QIcon_Mode_Enums *e, const QIcon_Mode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QIcon_Mode_Enums xoropQIcon_Mode_Enums (const QIcon_Mode_Enums *e, const QIcon_Mode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QIcon_Mode_Enums (const QIcon_Mode_Enums *e)
{
  std::string l;
  if (e->testFlag (QIcon::Normal)) { if (!l.empty ()) l += "|"; l += "Normal"; }
  if (e->testFlag (QIcon::Disabled)) { if (!l.empty ()) l += "|"; l += "Disabled"; }
  if (e->testFlag (QIcon::Active)) { if (!l.empty ()) l += "|"; l += "Active"; }
  if (e->testFlag (QIcon::Selected)) { if (!l.empty ()) l += "|"; l += "Selected"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QIcon_Mode_Enums (const QIcon_Mode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QIcon_Mode_Enums (const QIcon_Mode_Enums *e, const QIcon_Mode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QIcon_Mode_Enums> decl_QIcon_Mode_Enums ("QIcon_QFlags_Mode",
  gsi::method_ext ("|", &qt_gsi::oropQIcon_Mode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQIcon_Mode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQIcon_Mode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QIcon_Mode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QIcon_Mode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QIcon_Mode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QIcon::Mode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QIcon_Mode_Enum> decl_QIcon_Mode_Enum (decl_QIcon_Mode_Enums, "QIcon_Mode",
  qt_gsi::mkdefs_QIcon_Mode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QIcon_Mode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QIcon_Mode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQIcon_Mode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QIcon_Mode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QIcon_Mode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QIcon::Mode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QIcon> inject_QIcon_Mode_Enum_in_parent (qt_gsi::mkdefs_QIcon_Mode ());
static gsi::ClassExt<QIcon> decl_QIcon_Mode_Enum_as_child (decl_QIcon_Mode_Enum, "Mode");

}


//  Implementation of the enum wrapper class for QIcon::State
namespace qt_gsi
{

static QIcon_State_Enum *c_1_QIcon_State_Enum () { return new QIcon_State_Enum (QIcon::On); }
static QIcon_State_Enum *c_2_QIcon_State_Enum () { return new QIcon_State_Enum (QIcon::Off); }

static gsi::Methods mkdefs_QIcon_State () {
  return
    gsi::constant ("On", &qt_gsi::c_1_QIcon_State_Enum, "@brief Enum constant QIcon::On") +
    gsi::constant ("Off", &qt_gsi::c_2_QIcon_State_Enum, "@brief Enum constant QIcon::Off");
}

static std::string to_s_QIcon_State_Enum (const QIcon_State_Enum *e)
{
  if (e->value () == QIcon::On) { return tl::sprintf ("On (%u)", (unsigned int) e->value ()); }
  if (e->value () == QIcon::Off) { return tl::sprintf ("Off (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QIcon_State_Enum (const QIcon_State_Enum *e)
{
  return (unsigned int) e->value ();
}

static QIcon_State_Enum *from_i_QIcon_State_Enum (unsigned int i)
{
  return new QIcon_State_Enum ((QIcon::State) i);
}

static bool equalQIcon_State_Enum (const QIcon_State_Enum *e, QIcon_State_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QIcon_State_Enum (const QIcon_State_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QIcon_State_Enums oropQIcon_State_Enums (const QIcon_State_Enums *e, const QIcon_State_Enums &d)
{
  return e->flags () | d.flags ();
}

static QIcon_State_Enums andopQIcon_State_Enums (const QIcon_State_Enums *e, const QIcon_State_Enums &d)
{
  return e->flags () & d.flags ();
}

static QIcon_State_Enums xoropQIcon_State_Enums (const QIcon_State_Enums *e, const QIcon_State_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QIcon_State_Enums (const QIcon_State_Enums *e)
{
  std::string l;
  if (e->testFlag (QIcon::On)) { if (!l.empty ()) l += "|"; l += "On"; }
  if (e->testFlag (QIcon::Off)) { if (!l.empty ()) l += "|"; l += "Off"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QIcon_State_Enums (const QIcon_State_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QIcon_State_Enums (const QIcon_State_Enums *e, const QIcon_State_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QIcon_State_Enums> decl_QIcon_State_Enums ("QIcon_QFlags_State",
  gsi::method_ext ("|", &qt_gsi::oropQIcon_State_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQIcon_State_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQIcon_State_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QIcon_State_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QIcon_State_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QIcon_State_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QIcon::State> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QIcon_State_Enum> decl_QIcon_State_Enum (decl_QIcon_State_Enums, "QIcon_State",
  qt_gsi::mkdefs_QIcon_State () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QIcon_State_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QIcon_State_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQIcon_State_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QIcon_State_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QIcon_State_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QIcon::State enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QIcon> inject_QIcon_State_Enum_in_parent (qt_gsi::mkdefs_QIcon_State ());
static gsi::ClassExt<QIcon> decl_QIcon_State_Enum_as_child (decl_QIcon_State_Enum, "State");

}

