
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQHostAddress.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQHostAddress_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QHostAddress

//  Constructor QHostAddress::QHostAddress()


static void _init_ctor_QHostAddress_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QHostAddress *> ();
}

static void _call_ctor_QHostAddress_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QHostAddress *> (new QHostAddress ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QHostAddress_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QHostAddress::QHostAddress()\nThis method creates an object of class QHostAddress.", &_init_ctor_QHostAddress_0, &_call_ctor_QHostAddress_0);
}

//  Constructor QHostAddress::QHostAddress(quint32 ip4Addr)


static void _init_ctor_QHostAddress_1098 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ip4Addr");
  decl->add_arg<quint32 > (argspec_0);
  decl->set_return_new<QHostAddress *> ();
}

static void _call_ctor_QHostAddress_1098 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  quint32 arg1 = args.read<quint32 > ();
  ret.write<QHostAddress *> (new QHostAddress (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QHostAddress_1098 ()
{
  return new qt_gsi::GenericStaticMethod ("new_ip4", "@brief Constructor QHostAddress::QHostAddress(quint32 ip4Addr)\nThis method creates an object of class QHostAddress.", &_init_ctor_QHostAddress_1098, &_call_ctor_QHostAddress_1098);
}

//  Constructor QHostAddress::QHostAddress(const QString &address)


static void _init_ctor_QHostAddress_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QHostAddress *> ();
}

static void _call_ctor_QHostAddress_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QHostAddress *> (new QHostAddress (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QHostAddress_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QHostAddress::QHostAddress(const QString &address)\nThis method creates an object of class QHostAddress.", &_init_ctor_QHostAddress_2025, &_call_ctor_QHostAddress_2025);
}

//  Constructor QHostAddress::QHostAddress(const QHostAddress &copy)


static void _init_ctor_QHostAddress_2518 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("copy");
  decl->add_arg<const QHostAddress & > (argspec_0);
  decl->set_return_new<QHostAddress *> ();
}

static void _call_ctor_QHostAddress_2518 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QHostAddress &arg1 = args.read<const QHostAddress & > ();
  ret.write<QHostAddress *> (new QHostAddress (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QHostAddress_2518 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QHostAddress::QHostAddress(const QHostAddress &copy)\nThis method creates an object of class QHostAddress.", &_init_ctor_QHostAddress_2518, &_call_ctor_QHostAddress_2518);
}

//  Constructor QHostAddress::QHostAddress(QHostAddress::SpecialAddress address)


static void _init_ctor_QHostAddress_3172 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const qt_gsi::Converter<QHostAddress::SpecialAddress>::target_type & > (argspec_0);
  decl->set_return_new<QHostAddress *> ();
}

static void _call_ctor_QHostAddress_3172 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QHostAddress::SpecialAddress>::target_type & arg1 = args.read<const qt_gsi::Converter<QHostAddress::SpecialAddress>::target_type & > ();
  ret.write<QHostAddress *> (new QHostAddress (qt_gsi::QtToCppAdaptor<QHostAddress::SpecialAddress>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QHostAddress_3172 ()
{
  return new qt_gsi::GenericStaticMethod ("new_special", "@brief Constructor QHostAddress::QHostAddress(QHostAddress::SpecialAddress address)\nThis method creates an object of class QHostAddress.", &_init_ctor_QHostAddress_3172, &_call_ctor_QHostAddress_3172);
}

// void QHostAddress::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHostAddress *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QHostAddress::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// bool QHostAddress::isInSubnet(const QHostAddress &subnet, int netmask)


static void _init_f_isInSubnet_c3177 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("subnet");
  decl->add_arg<const QHostAddress & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("netmask");
  decl->add_arg<int > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isInSubnet_c3177 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QHostAddress &arg1 = args.read<const QHostAddress & > ();
  int arg2 = args.read<int > ();
  ret.write<bool > ((bool)((QHostAddress *)cls)->isInSubnet (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_isInSubnet_c3177 ()
{
  return new qt_gsi::GenericMethod ("isInSubnet?", "@brief Method bool QHostAddress::isInSubnet(const QHostAddress &subnet, int netmask)\n", true, &_init_f_isInSubnet_c3177, &_call_f_isInSubnet_c3177);
}

// bool QHostAddress::isInSubnet(const QPair<QHostAddress, int> &subnet)


static void _init_f_isInSubnet_c3636 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("subnet");
  decl->add_arg<const QPair<QHostAddress, int> & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isInSubnet_c3636 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPair<QHostAddress, int> &arg1 = args.read<const QPair<QHostAddress, int> & > ();
  ret.write<bool > ((bool)((QHostAddress *)cls)->isInSubnet (arg1));
}

static qt_gsi::GenericMethod *_create_f_isInSubnet_c3636 ()
{
  return new qt_gsi::GenericMethod ("isInSubnet?", "@brief Method bool QHostAddress::isInSubnet(const QPair<QHostAddress, int> &subnet)\n", true, &_init_f_isInSubnet_c3636, &_call_f_isInSubnet_c3636);
}

// bool QHostAddress::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QHostAddress *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QHostAddress::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// bool QHostAddress::operator !=(const QHostAddress &address)


static void _init_f_operator_excl__eq__c2518 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const QHostAddress & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2518 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QHostAddress &arg1 = args.read<const QHostAddress & > ();
  ret.write<bool > ((bool)((QHostAddress *)cls)->operator != (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2518 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QHostAddress::operator !=(const QHostAddress &address)\n", true, &_init_f_operator_excl__eq__c2518, &_call_f_operator_excl__eq__c2518);
}

// bool QHostAddress::operator !=(QHostAddress::SpecialAddress address)


static void _init_f_operator_excl__eq__c3172 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const qt_gsi::Converter<QHostAddress::SpecialAddress>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c3172 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QHostAddress::SpecialAddress>::target_type & arg1 = args.read<const qt_gsi::Converter<QHostAddress::SpecialAddress>::target_type & > ();
  ret.write<bool > ((bool)((QHostAddress *)cls)->operator != (qt_gsi::QtToCppAdaptor<QHostAddress::SpecialAddress>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c3172 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QHostAddress::operator !=(QHostAddress::SpecialAddress address)\n", true, &_init_f_operator_excl__eq__c3172, &_call_f_operator_excl__eq__c3172);
}

// bool QHostAddress::operator ==(const QHostAddress &address)


static void _init_f_operator_eq__eq__c2518 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const QHostAddress & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2518 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QHostAddress &arg1 = args.read<const QHostAddress & > ();
  ret.write<bool > ((bool)((QHostAddress *)cls)->operator == (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2518 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QHostAddress::operator ==(const QHostAddress &address)\n", true, &_init_f_operator_eq__eq__c2518, &_call_f_operator_eq__eq__c2518);
}

// bool QHostAddress::operator ==(QHostAddress::SpecialAddress address)


static void _init_f_operator_eq__eq__c3172 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const qt_gsi::Converter<QHostAddress::SpecialAddress>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c3172 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QHostAddress::SpecialAddress>::target_type & arg1 = args.read<const qt_gsi::Converter<QHostAddress::SpecialAddress>::target_type & > ();
  ret.write<bool > ((bool)((QHostAddress *)cls)->operator == (qt_gsi::QtToCppAdaptor<QHostAddress::SpecialAddress>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c3172 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QHostAddress::operator ==(QHostAddress::SpecialAddress address)\n", true, &_init_f_operator_eq__eq__c3172, &_call_f_operator_eq__eq__c3172);
}

// QHostAddress &QHostAddress::operator=(const QHostAddress &other)


static void _init_f_operator_eq__2518 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QHostAddress & > (argspec_0);
  decl->set_return<QHostAddress & > ();
}

static void _call_f_operator_eq__2518 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QHostAddress &arg1 = args.read<const QHostAddress & > ();
  ret.write<QHostAddress & > ((QHostAddress &)((QHostAddress *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2518 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QHostAddress &QHostAddress::operator=(const QHostAddress &other)\n", false, &_init_f_operator_eq__2518, &_call_f_operator_eq__2518);
}

// QHostAddress &QHostAddress::operator=(const QString &address)


static void _init_f_operator_eq__2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QHostAddress & > ();
}

static void _call_f_operator_eq__2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QHostAddress & > ((QHostAddress &)((QHostAddress *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2025 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QHostAddress &QHostAddress::operator=(const QString &address)\n", false, &_init_f_operator_eq__2025, &_call_f_operator_eq__2025);
}

// QAbstractSocket::NetworkLayerProtocol QHostAddress::protocol()


static void _init_f_protocol_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSocket::NetworkLayerProtocol>::target_type > ();
}

static void _call_f_protocol_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QAbstractSocket::NetworkLayerProtocol>::target_type > ((qt_gsi::Converter<QAbstractSocket::NetworkLayerProtocol>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSocket::NetworkLayerProtocol>(((QHostAddress *)cls)->protocol ()));
}

static qt_gsi::GenericMethod *_create_f_protocol_c0 ()
{
  return new qt_gsi::GenericMethod ("protocol", "@brief Method QAbstractSocket::NetworkLayerProtocol QHostAddress::protocol()\n", true, &_init_f_protocol_c0, &_call_f_protocol_c0);
}

// QString QHostAddress::scopeId()


static void _init_f_scopeId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_scopeId_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QHostAddress *)cls)->scopeId ());
}

static qt_gsi::GenericMethod *_create_f_scopeId_c0 ()
{
  return new qt_gsi::GenericMethod (":scopeId", "@brief Method QString QHostAddress::scopeId()\n", true, &_init_f_scopeId_c0, &_call_f_scopeId_c0);
}

// void QHostAddress::setAddress(quint32 ip4Addr)


static void _init_f_setAddress_1098 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ip4Addr");
  decl->add_arg<quint32 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAddress_1098 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  quint32 arg1 = args.read<quint32 > ();
  ((QHostAddress *)cls)->setAddress (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAddress_1098 ()
{
  return new qt_gsi::GenericMethod ("setAddress", "@brief Method void QHostAddress::setAddress(quint32 ip4Addr)\n", false, &_init_f_setAddress_1098, &_call_f_setAddress_1098);
}

// bool QHostAddress::setAddress(const QString &address)


static void _init_f_setAddress_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setAddress_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QHostAddress *)cls)->setAddress (arg1));
}

static qt_gsi::GenericMethod *_create_f_setAddress_2025 ()
{
  return new qt_gsi::GenericMethod ("setAddress", "@brief Method bool QHostAddress::setAddress(const QString &address)\n", false, &_init_f_setAddress_2025, &_call_f_setAddress_2025);
}

// void QHostAddress::setScopeId(const QString &id)


static void _init_f_setScopeId_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScopeId_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QHostAddress *)cls)->setScopeId (arg1);
}

static qt_gsi::GenericMethod *_create_f_setScopeId_2025 ()
{
  return new qt_gsi::GenericMethod ("setScopeId|scopeId=", "@brief Method void QHostAddress::setScopeId(const QString &id)\n", false, &_init_f_setScopeId_2025, &_call_f_setScopeId_2025);
}

// quint32 QHostAddress::toIPv4Address()


static void _init_f_toIPv4Address_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint32 > ();
}

static void _call_f_toIPv4Address_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<quint32 > ((quint32)((QHostAddress *)cls)->toIPv4Address ());
}

static qt_gsi::GenericMethod *_create_f_toIPv4Address_c0 ()
{
  return new qt_gsi::GenericMethod ("toIPv4Address", "@brief Method quint32 QHostAddress::toIPv4Address()\n", true, &_init_f_toIPv4Address_c0, &_call_f_toIPv4Address_c0);
}

// QString QHostAddress::toString()


static void _init_f_toString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toString_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QHostAddress *)cls)->toString ());
}

static qt_gsi::GenericMethod *_create_f_toString_c0 ()
{
  return new qt_gsi::GenericMethod ("toString|to_s", "@brief Method QString QHostAddress::toString()\n", true, &_init_f_toString_c0, &_call_f_toString_c0);
}

// static QPair<QHostAddress, int> QHostAddress::parseSubnet(const QString &subnet)


static void _init_f_parseSubnet_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("subnet");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QPair<QHostAddress, int> > ();
}

static void _call_f_parseSubnet_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QPair<QHostAddress, int> > ((QPair<QHostAddress, int>)QHostAddress::parseSubnet (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_parseSubnet_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("parseSubnet", "@brief Static method QPair<QHostAddress, int> QHostAddress::parseSubnet(const QString &subnet)\nThis method is static and can be called without an instance.", &_init_f_parseSubnet_2025, &_call_f_parseSubnet_2025);
}


namespace gsi
{
gsi::Class<QHostAddress> decl_QHostAddress ("QHostAddress",
  gsi::Methods(_create_ctor_QHostAddress_0 ()) +
  gsi::Methods(_create_ctor_QHostAddress_1098 ()) +
  gsi::Methods(_create_ctor_QHostAddress_2025 ()) +
  gsi::Methods(_create_ctor_QHostAddress_2518 ()) +
  gsi::Methods(_create_ctor_QHostAddress_3172 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_isInSubnet_c3177 ()) +
  gsi::Methods(_create_f_isInSubnet_c3636 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2518 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c3172 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2518 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c3172 ()) +
  gsi::Methods(_create_f_operator_eq__2518 ()) +
  gsi::Methods(_create_f_operator_eq__2025 ()) +
  gsi::Methods(_create_f_protocol_c0 ()) +
  gsi::Methods(_create_f_scopeId_c0 ()) +
  gsi::Methods(_create_f_setAddress_1098 ()) +
  gsi::Methods(_create_f_setAddress_2025 ()) +
  gsi::Methods(_create_f_setScopeId_2025 ()) +
  gsi::Methods(_create_f_toIPv4Address_c0 ()) +
  gsi::Methods(_create_f_toString_c0 ()) +
  gsi::Methods(_create_f_parseSubnet_2025 ()),
  "@qt\n@brief Binding of QHostAddress");

}


//  Implementation of the enum wrapper class for QHostAddress::SpecialAddress
namespace qt_gsi
{

static QHostAddress_SpecialAddress_Enum *c_1_QHostAddress_SpecialAddress_Enum () { return new QHostAddress_SpecialAddress_Enum (QHostAddress::Null); }
static QHostAddress_SpecialAddress_Enum *c_2_QHostAddress_SpecialAddress_Enum () { return new QHostAddress_SpecialAddress_Enum (QHostAddress::Broadcast); }
static QHostAddress_SpecialAddress_Enum *c_3_QHostAddress_SpecialAddress_Enum () { return new QHostAddress_SpecialAddress_Enum (QHostAddress::LocalHost); }
static QHostAddress_SpecialAddress_Enum *c_4_QHostAddress_SpecialAddress_Enum () { return new QHostAddress_SpecialAddress_Enum (QHostAddress::LocalHostIPv6); }
static QHostAddress_SpecialAddress_Enum *c_5_QHostAddress_SpecialAddress_Enum () { return new QHostAddress_SpecialAddress_Enum (QHostAddress::Any); }
static QHostAddress_SpecialAddress_Enum *c_6_QHostAddress_SpecialAddress_Enum () { return new QHostAddress_SpecialAddress_Enum (QHostAddress::AnyIPv6); }

static gsi::Methods mkdefs_QHostAddress_SpecialAddress () {
  return
    gsi::constant ("Null", &qt_gsi::c_1_QHostAddress_SpecialAddress_Enum, "@brief Enum constant QHostAddress::Null") +
    gsi::constant ("Broadcast", &qt_gsi::c_2_QHostAddress_SpecialAddress_Enum, "@brief Enum constant QHostAddress::Broadcast") +
    gsi::constant ("LocalHost", &qt_gsi::c_3_QHostAddress_SpecialAddress_Enum, "@brief Enum constant QHostAddress::LocalHost") +
    gsi::constant ("LocalHostIPv6", &qt_gsi::c_4_QHostAddress_SpecialAddress_Enum, "@brief Enum constant QHostAddress::LocalHostIPv6") +
    gsi::constant ("Any", &qt_gsi::c_5_QHostAddress_SpecialAddress_Enum, "@brief Enum constant QHostAddress::Any") +
    gsi::constant ("AnyIPv6", &qt_gsi::c_6_QHostAddress_SpecialAddress_Enum, "@brief Enum constant QHostAddress::AnyIPv6");
}

static std::string to_s_QHostAddress_SpecialAddress_Enum (const QHostAddress_SpecialAddress_Enum *e)
{
  if (e->value () == QHostAddress::Null) { return tl::sprintf ("Null (%u)", (unsigned int) e->value ()); }
  if (e->value () == QHostAddress::Broadcast) { return tl::sprintf ("Broadcast (%u)", (unsigned int) e->value ()); }
  if (e->value () == QHostAddress::LocalHost) { return tl::sprintf ("LocalHost (%u)", (unsigned int) e->value ()); }
  if (e->value () == QHostAddress::LocalHostIPv6) { return tl::sprintf ("LocalHostIPv6 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QHostAddress::Any) { return tl::sprintf ("Any (%u)", (unsigned int) e->value ()); }
  if (e->value () == QHostAddress::AnyIPv6) { return tl::sprintf ("AnyIPv6 (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QHostAddress_SpecialAddress_Enum (const QHostAddress_SpecialAddress_Enum *e)
{
  return (unsigned int) e->value ();
}

static QHostAddress_SpecialAddress_Enum *from_i_QHostAddress_SpecialAddress_Enum (unsigned int i)
{
  return new QHostAddress_SpecialAddress_Enum ((QHostAddress::SpecialAddress) i);
}

static bool equalQHostAddress_SpecialAddress_Enum (const QHostAddress_SpecialAddress_Enum *e, QHostAddress_SpecialAddress_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QHostAddress_SpecialAddress_Enum (const QHostAddress_SpecialAddress_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QHostAddress_SpecialAddress_Enums oropQHostAddress_SpecialAddress_Enums (const QHostAddress_SpecialAddress_Enums *e, const QHostAddress_SpecialAddress_Enums &d)
{
  return e->flags () | d.flags ();
}

static QHostAddress_SpecialAddress_Enums andopQHostAddress_SpecialAddress_Enums (const QHostAddress_SpecialAddress_Enums *e, const QHostAddress_SpecialAddress_Enums &d)
{
  return e->flags () & d.flags ();
}

static QHostAddress_SpecialAddress_Enums xoropQHostAddress_SpecialAddress_Enums (const QHostAddress_SpecialAddress_Enums *e, const QHostAddress_SpecialAddress_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QHostAddress_SpecialAddress_Enums (const QHostAddress_SpecialAddress_Enums *e)
{
  std::string l;
  if (e->testFlag (QHostAddress::Null)) { if (!l.empty ()) l += "|"; l += "Null"; }
  if (e->testFlag (QHostAddress::Broadcast)) { if (!l.empty ()) l += "|"; l += "Broadcast"; }
  if (e->testFlag (QHostAddress::LocalHost)) { if (!l.empty ()) l += "|"; l += "LocalHost"; }
  if (e->testFlag (QHostAddress::LocalHostIPv6)) { if (!l.empty ()) l += "|"; l += "LocalHostIPv6"; }
  if (e->testFlag (QHostAddress::Any)) { if (!l.empty ()) l += "|"; l += "Any"; }
  if (e->testFlag (QHostAddress::AnyIPv6)) { if (!l.empty ()) l += "|"; l += "AnyIPv6"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QHostAddress_SpecialAddress_Enums (const QHostAddress_SpecialAddress_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QHostAddress_SpecialAddress_Enums (const QHostAddress_SpecialAddress_Enums *e, const QHostAddress_SpecialAddress_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QHostAddress_SpecialAddress_Enums> decl_QHostAddress_SpecialAddress_Enums ("QHostAddress_QFlags_SpecialAddress",
  gsi::method_ext ("|", &qt_gsi::oropQHostAddress_SpecialAddress_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQHostAddress_SpecialAddress_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQHostAddress_SpecialAddress_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QHostAddress_SpecialAddress_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QHostAddress_SpecialAddress_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QHostAddress_SpecialAddress_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QHostAddress::SpecialAddress> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QHostAddress_SpecialAddress_Enum> decl_QHostAddress_SpecialAddress_Enum (decl_QHostAddress_SpecialAddress_Enums, "QHostAddress_SpecialAddress",
  qt_gsi::mkdefs_QHostAddress_SpecialAddress () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QHostAddress_SpecialAddress_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QHostAddress_SpecialAddress_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQHostAddress_SpecialAddress_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QHostAddress_SpecialAddress_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QHostAddress_SpecialAddress_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QHostAddress::SpecialAddress enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QHostAddress> inject_QHostAddress_SpecialAddress_Enum_in_parent (qt_gsi::mkdefs_QHostAddress_SpecialAddress ());
static gsi::ClassExt<QHostAddress> decl_QHostAddress_SpecialAddress_Enum_as_child (decl_QHostAddress_SpecialAddress_Enum, "SpecialAddress");

}

