
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsBlurEffect.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQGraphicsBlurEffect_EventAdaptor.h"
#include "gsiDeclQGraphicsBlurEffect_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsBlurEffect

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsBlurEffect::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QFlags<QGraphicsBlurEffect::BlurHint> QGraphicsBlurEffect::blurHints()


static void _init_f_blurHints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QGraphicsBlurEffect::BlurHint> >::target_type > ();
}

static void _call_f_blurHints_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QGraphicsBlurEffect::BlurHint> >::target_type > ((qt_gsi::Converter<QFlags<QGraphicsBlurEffect::BlurHint> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QGraphicsBlurEffect::BlurHint> >(((QGraphicsBlurEffect *)cls)->blurHints ()));
}

static qt_gsi::GenericMethod *_create_f_blurHints_c0 ()
{
  return new qt_gsi::GenericMethod (":blurHints", "@brief Method QFlags<QGraphicsBlurEffect::BlurHint> QGraphicsBlurEffect::blurHints()\n", true, &_init_f_blurHints_c0, &_call_f_blurHints_c0);
}

// double QGraphicsBlurEffect::blurRadius()


static void _init_f_blurRadius_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_blurRadius_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsBlurEffect *)cls)->blurRadius ());
}

static qt_gsi::GenericMethod *_create_f_blurRadius_c0 ()
{
  return new qt_gsi::GenericMethod (":blurRadius", "@brief Method double QGraphicsBlurEffect::blurRadius()\n", true, &_init_f_blurRadius_c0, &_call_f_blurRadius_c0);
}

// QRectF QGraphicsBlurEffect::boundingRectFor(const QRectF &rect)


static void _init_f_boundingRectFor_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRectFor_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QGraphicsBlurEffect *)cls)->boundingRectFor (arg1));
}

static qt_gsi::GenericMethod *_create_f_boundingRectFor_c1862 ()
{
  return new qt_gsi::GenericMethod ("boundingRectFor", "@brief Method QRectF QGraphicsBlurEffect::boundingRectFor(const QRectF &rect)\nThis is a reimplementation of QGraphicsEffect::boundingRectFor", true, &_init_f_boundingRectFor_c1862, &_call_f_boundingRectFor_c1862);
}

// void QGraphicsBlurEffect::setBlurHints(QFlags<QGraphicsBlurEffect::BlurHint> hints)


static void _init_f_setBlurHints_3948 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hints");
  decl->add_arg<const qt_gsi::Converter<QFlags<QGraphicsBlurEffect::BlurHint> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBlurHints_3948 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QGraphicsBlurEffect::BlurHint> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QGraphicsBlurEffect::BlurHint> >::target_type & > ();
  ((QGraphicsBlurEffect *)cls)->setBlurHints (qt_gsi::QtToCppAdaptor<QFlags<QGraphicsBlurEffect::BlurHint> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setBlurHints_3948 ()
{
  return new qt_gsi::GenericMethod ("setBlurHints|blurHints=", "@brief Method void QGraphicsBlurEffect::setBlurHints(QFlags<QGraphicsBlurEffect::BlurHint> hints)\n", false, &_init_f_setBlurHints_3948, &_call_f_setBlurHints_3948);
}

// void QGraphicsBlurEffect::setBlurRadius(double blurRadius)


static void _init_f_setBlurRadius_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("blurRadius");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBlurRadius_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsBlurEffect *)cls)->setBlurRadius (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBlurRadius_1071 ()
{
  return new qt_gsi::GenericMethod ("setBlurRadius|blurRadius=", "@brief Method void QGraphicsBlurEffect::setBlurRadius(double blurRadius)\n", false, &_init_f_setBlurRadius_1071, &_call_f_setBlurRadius_1071);
}

// static QString QGraphicsBlurEffect::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsBlurEffect::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsBlurEffect::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QGraphicsBlurEffect::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsBlurEffect::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsBlurEffect::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QGraphicsBlurEffect::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsBlurEffect::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsBlurEffect::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QGraphicsBlurEffect::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsBlurEffect::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsBlurEffect::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QGraphicsBlurEffect, QGraphicsBlurEffect_EventAdaptor> ea_QGraphicsBlurEffect;

namespace gsi
{
extern gsi::Class<QGraphicsEffect> decl_QGraphicsEffect;

gsi::Class<QGraphicsBlurEffect> decl_QGraphicsBlurEffect (ea_QGraphicsBlurEffect, decl_QGraphicsEffect, "QGraphicsBlurEffect_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_blurHints_c0 ()) +
  gsi::Methods(_create_f_blurRadius_c0 ()) +
  gsi::Methods(_create_f_boundingRectFor_c1862 ()) +
  gsi::Methods(_create_f_setBlurHints_3948 ()) +
  gsi::Methods(_create_f_setBlurRadius_1071 ()) +
  qt_gsi::qt_signal<QGraphicsBlurEffect, QGraphicsBlurEffect_EventAdaptor, const qt_gsi::Converter<QFlags<QGraphicsBlurEffect::BlurHint> >::target_type &> ("blurHintsChanged", &QGraphicsBlurEffect_EventAdaptor::blurHintsChanged_e_3948, gsi::arg("hints"), "@brief Signal declaration for QGraphicsBlurEffect::blurHintsChanged(QFlags<QGraphicsBlurEffect::BlurHint> hints)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsBlurEffect, QGraphicsBlurEffect_EventAdaptor, double> ("blurRadiusChanged", &QGraphicsBlurEffect_EventAdaptor::blurRadiusChanged_e_1071, gsi::arg("blurRadius"), "@brief Signal declaration for QGraphicsBlurEffect::blurRadiusChanged(double blurRadius)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsBlurEffect, QGraphicsBlurEffect_EventAdaptor, QObject *> ("destroyed", &QGraphicsBlurEffect_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QGraphicsBlurEffect::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsBlurEffect, QGraphicsBlurEffect_EventAdaptor, bool> ("enabledChanged", &QGraphicsBlurEffect_EventAdaptor::enabledChanged_e_864, gsi::arg("enabled"), "@brief Signal declaration for QGraphicsBlurEffect::enabledChanged(bool enabled)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QGraphicsBlurEffect");
}


class QGraphicsBlurEffect_Adaptor : public QGraphicsBlurEffect, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsBlurEffect_Adaptor();

  //  [adaptor ctor] QGraphicsBlurEffect::QGraphicsBlurEffect(QObject *parent)
  QGraphicsBlurEffect_Adaptor() : QGraphicsBlurEffect()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsBlurEffect::QGraphicsBlurEffect(QObject *parent)
  QGraphicsBlurEffect_Adaptor(QObject *parent) : QGraphicsBlurEffect(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QGraphicsBlurEffect::drawSource(QPainter *painter)
  void fp_QGraphicsBlurEffect_drawSource_1426 (QPainter *painter) {
    QGraphicsBlurEffect::drawSource(painter);
  }

  //  int QGraphicsBlurEffect::receivers(const char *signal)
  int fp_QGraphicsBlurEffect_receivers_c1731 (const char *signal) const {
    return QGraphicsBlurEffect::receivers(signal);
  }

  //  QObject *QGraphicsBlurEffect::sender()
  QObject * fp_QGraphicsBlurEffect_sender_c0 () const {
    return QGraphicsBlurEffect::sender();
  }

  //  QRectF QGraphicsBlurEffect::sourceBoundingRect(Qt::CoordinateSystem system)
  QRectF fp_QGraphicsBlurEffect_sourceBoundingRect_c2426 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system) const {
    return QGraphicsBlurEffect::sourceBoundingRect(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref());
  }

  //  bool QGraphicsBlurEffect::sourceIsPixmap()
  bool fp_QGraphicsBlurEffect_sourceIsPixmap_c0 () const {
    return QGraphicsBlurEffect::sourceIsPixmap();
  }

  //  QPixmap QGraphicsBlurEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)
  QPixmap fp_QGraphicsBlurEffect_sourcePixmap_c6763 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system, QPoint *offset, const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & mode) const {
    return QGraphicsBlurEffect::sourcePixmap(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref(), offset, qt_gsi::QtToCppAdaptor<QGraphicsEffect::PixmapPadMode>(mode).cref());
  }

  //  void QGraphicsBlurEffect::updateBoundingRect()
  void fp_QGraphicsBlurEffect_updateBoundingRect_0 () {
    QGraphicsBlurEffect::updateBoundingRect();
  }

  //  [adaptor impl] QRectF QGraphicsBlurEffect::boundingRectFor(const QRectF &rect)
  QRectF cbs_boundingRectFor_c1862_0(const QRectF &rect) const
  {
    return QGraphicsBlurEffect::boundingRectFor(rect);
  }

  virtual QRectF boundingRectFor(const QRectF &rect) const
  {
    if (cb_boundingRectFor_c1862_0.can_issue()) {
      return cb_boundingRectFor_c1862_0.issue<QGraphicsBlurEffect_Adaptor, QRectF, const QRectF &>(&QGraphicsBlurEffect_Adaptor::cbs_boundingRectFor_c1862_0, rect);
    } else {
      return QGraphicsBlurEffect::boundingRectFor(rect);
    }
  }

  //  [adaptor impl] bool QGraphicsBlurEffect::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QGraphicsBlurEffect::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsBlurEffect_Adaptor, bool, QEvent *>(&QGraphicsBlurEffect_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QGraphicsBlurEffect::event(arg1);
    }
  }

  //  [adaptor impl] bool QGraphicsBlurEffect::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QGraphicsBlurEffect::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsBlurEffect_Adaptor, bool, QObject *, QEvent *>(&QGraphicsBlurEffect_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QGraphicsBlurEffect::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QGraphicsBlurEffect::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QGraphicsBlurEffect::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsBlurEffect_Adaptor, QChildEvent *>(&QGraphicsBlurEffect_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QGraphicsBlurEffect::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsBlurEffect::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QGraphicsBlurEffect::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsBlurEffect_Adaptor, QEvent *>(&QGraphicsBlurEffect_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QGraphicsBlurEffect::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsBlurEffect::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QGraphicsBlurEffect::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QGraphicsBlurEffect_Adaptor, const char *>(&QGraphicsBlurEffect_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QGraphicsBlurEffect::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsBlurEffect::draw(QPainter *painter)
  void cbs_draw_1426_0(QPainter *painter)
  {
    QGraphicsBlurEffect::draw(painter);
  }

  virtual void draw(QPainter *painter)
  {
    if (cb_draw_1426_0.can_issue()) {
      cb_draw_1426_0.issue<QGraphicsBlurEffect_Adaptor, QPainter *>(&QGraphicsBlurEffect_Adaptor::cbs_draw_1426_0, painter);
    } else {
      QGraphicsBlurEffect::draw(painter);
    }
  }

  //  [adaptor impl] void QGraphicsBlurEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  void cbs_sourceChanged_3695_0(const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & flags)
  {
    QGraphicsBlurEffect::sourceChanged(qt_gsi::QtToCppAdaptor<QFlags<QGraphicsEffect::ChangeFlag> >(flags).cref());
  }

  virtual void sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  {
    if (cb_sourceChanged_3695_0.can_issue()) {
      cb_sourceChanged_3695_0.issue<QGraphicsBlurEffect_Adaptor, const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type &>(&QGraphicsBlurEffect_Adaptor::cbs_sourceChanged_3695_0, qt_gsi::CppToQtAdaptor<QFlags<QGraphicsEffect::ChangeFlag> >(flags));
    } else {
      QGraphicsBlurEffect::sourceChanged(flags);
    }
  }

  //  [adaptor impl] void QGraphicsBlurEffect::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QGraphicsBlurEffect::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsBlurEffect_Adaptor, QTimerEvent *>(&QGraphicsBlurEffect_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QGraphicsBlurEffect::timerEvent(arg1);
    }
  }

  gsi::Callback cb_boundingRectFor_c1862_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_draw_1426_0;
  gsi::Callback cb_sourceChanged_3695_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QGraphicsBlurEffect_Adaptor::~QGraphicsBlurEffect_Adaptor() { }

//  Constructor QGraphicsBlurEffect::QGraphicsBlurEffect(QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsBlurEffect_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QGraphicsBlurEffect_Adaptor *> ();
}

static void _call_ctor_QGraphicsBlurEffect_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QGraphicsBlurEffect_Adaptor *> (new QGraphicsBlurEffect_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsBlurEffect_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsBlurEffect::QGraphicsBlurEffect(QObject *parent)\nThis method creates an object of class QGraphicsBlurEffect.", &_init_ctor_QGraphicsBlurEffect_Adaptor_1302, &_call_ctor_QGraphicsBlurEffect_Adaptor_1302);
}

// void QGraphicsBlurEffect::drawSource(QPainter *painter)

static void _init_fp_drawSource_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawSource_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_drawSource_1426 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_drawSource_1426 ()
{
  return new qt_gsi::GenericMethod("*drawSource", "@brief Method void QGraphicsBlurEffect::drawSource(QPainter *painter)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawSource_1426, &_call_fp_drawSource_1426);
}


// int QGraphicsBlurEffect::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QGraphicsBlurEffect::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QGraphicsBlurEffect::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QGraphicsBlurEffect::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QRectF QGraphicsBlurEffect::sourceBoundingRect(Qt::CoordinateSystem system)

static void _init_fp_sourceBoundingRect_c2426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_fp_sourceBoundingRect_c2426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > () : (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates));
  ret.write<QRectF > ((QRectF)((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_sourceBoundingRect_c2426 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_sourceBoundingRect_c2426 ()
{
  return new qt_gsi::GenericMethod("*sourceBoundingRect", "@brief Method QRectF QGraphicsBlurEffect::sourceBoundingRect(Qt::CoordinateSystem system)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceBoundingRect_c2426, &_call_fp_sourceBoundingRect_c2426);
}


// bool QGraphicsBlurEffect::sourceIsPixmap()

static void _init_fp_sourceIsPixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_sourceIsPixmap_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_sourceIsPixmap_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sourceIsPixmap_c0 ()
{
  return new qt_gsi::GenericMethod("*sourceIsPixmap", "@brief Method bool QGraphicsBlurEffect::sourceIsPixmap()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceIsPixmap_c0, &_call_fp_sourceIsPixmap_c0);
}


// QPixmap QGraphicsBlurEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)

static void _init_fp_sourcePixmap_c6763 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "0");
  decl->add_arg<QPoint * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QGraphicsEffect::PadToEffectiveBoundingRect");
  decl->add_arg<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_fp_sourcePixmap_c6763 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > () : (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates));
  QPoint *arg2 = args ? args.read<QPoint * > () : (QPoint *)(0);
  const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & > () : (const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QGraphicsEffect::PixmapPadMode>(heap, QGraphicsEffect::PadToEffectiveBoundingRect));
  ret.write<QPixmap > ((QPixmap)((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_sourcePixmap_c6763 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_sourcePixmap_c6763 ()
{
  return new qt_gsi::GenericMethod("*sourcePixmap", "@brief Method QPixmap QGraphicsBlurEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourcePixmap_c6763, &_call_fp_sourcePixmap_c6763);
}


// void QGraphicsBlurEffect::updateBoundingRect()

static void _init_fp_updateBoundingRect_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateBoundingRect_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_updateBoundingRect_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateBoundingRect_0 ()
{
  return new qt_gsi::GenericMethod("*updateBoundingRect", "@brief Method void QGraphicsBlurEffect::updateBoundingRect()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateBoundingRect_0, &_call_fp_updateBoundingRect_0);
}


// QRectF QGraphicsBlurEffect::boundingRectFor(const QRectF &rect)

static void _init_cbs_boundingRectFor_c1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRectFor_c1862_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QGraphicsBlurEffect_Adaptor *)cls)->cbs_boundingRectFor_c1862_0 (arg1));
}

static void _set_callback_cbs_boundingRectFor_c1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_boundingRectFor_c1862_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_boundingRectFor_c1862_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRectFor", "@hide", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_boundingRectFor_c1862_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRectFor", "@brief Virtual method QRectF QGraphicsBlurEffect::boundingRectFor(const QRectF &rect)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0, &_set_callback_cbs_boundingRectFor_c1862_0);
}


// bool QGraphicsBlurEffect::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsBlurEffect_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QGraphicsBlurEffect::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QGraphicsBlurEffect::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsBlurEffect_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsBlurEffect::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QGraphicsBlurEffect::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QGraphicsBlurEffect_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsBlurEffect::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QGraphicsBlurEffect::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsBlurEffect_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsBlurEffect::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QGraphicsBlurEffect::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QGraphicsBlurEffect_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsBlurEffect::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QGraphicsBlurEffect::draw(QPainter *painter)

static void _init_cbs_draw_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_draw_1426_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QGraphicsBlurEffect_Adaptor *)cls)->cbs_draw_1426_0 (arg1);
}

static void _set_callback_cbs_draw_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_draw_1426_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_draw_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*draw", "@hide", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_draw_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*draw", "@brief Virtual method void QGraphicsBlurEffect::draw(QPainter *painter)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0, &_set_callback_cbs_draw_1426_0);
}


// void QGraphicsBlurEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)

static void _init_cbs_sourceChanged_3695_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_sourceChanged_3695_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & > ();
  ((QGraphicsBlurEffect_Adaptor *)cls)->cbs_sourceChanged_3695_0 (arg1);
}

static void _set_callback_cbs_sourceChanged_3695_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_sourceChanged_3695_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sourceChanged_3695_0 ()
{
  return new qt_gsi::GenericMethod ("*sourceChanged", "@hide", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sourceChanged_3695_0 ()
{
  return new qt_gsi::GenericMethod ("*sourceChanged", "@brief Virtual method void QGraphicsBlurEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0, &_set_callback_cbs_sourceChanged_3695_0);
}


// void QGraphicsBlurEffect::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QGraphicsBlurEffect_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsBlurEffect::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QGraphicsBlurEffect> decl_QGraphicsBlurEffect;

gsi::Class<QGraphicsBlurEffect_Adaptor> decl_QGraphicsBlurEffect_Adaptor (decl_QGraphicsBlurEffect, "QGraphicsBlurEffect",
  gsi::Methods(_create_fp_drawSource_1426 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_sourceBoundingRect_c2426 ()) +
  gsi::Methods(_create_fp_sourceIsPixmap_c0 ()) +
  gsi::Methods(_create_fp_sourcePixmap_c6763 ()) +
  gsi::Methods(_create_fp_updateBoundingRect_0 ()) +
  gsi::Methods(_create_cbs_boundingRectFor_c1862_0 ()) +
  gsi::Methods(_create_callback_cbs_boundingRectFor_c1862_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_draw_1426_0 ()) +
  gsi::Methods(_create_callback_cbs_draw_1426_0 ()) +
  gsi::Methods(_create_cbs_sourceChanged_3695_0 ()) +
  gsi::Methods(_create_callback_cbs_sourceChanged_3695_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QGraphicsBlurEffect_Adaptor_1302 ()),
  "@qt\n@brief Binding of QGraphicsBlurEffect");

}


//  Implementation of the enum wrapper class for QGraphicsBlurEffect::BlurHint
namespace qt_gsi
{

static QGraphicsBlurEffect_BlurHint_Enum *c_1_QGraphicsBlurEffect_BlurHint_Enum () { return new QGraphicsBlurEffect_BlurHint_Enum (QGraphicsBlurEffect::PerformanceHint); }
static QGraphicsBlurEffect_BlurHint_Enum *c_2_QGraphicsBlurEffect_BlurHint_Enum () { return new QGraphicsBlurEffect_BlurHint_Enum (QGraphicsBlurEffect::QualityHint); }
static QGraphicsBlurEffect_BlurHint_Enum *c_3_QGraphicsBlurEffect_BlurHint_Enum () { return new QGraphicsBlurEffect_BlurHint_Enum (QGraphicsBlurEffect::AnimationHint); }

static gsi::Methods mkdefs_QGraphicsBlurEffect_BlurHint () {
  return
    gsi::constant ("PerformanceHint", &qt_gsi::c_1_QGraphicsBlurEffect_BlurHint_Enum, "@brief Enum constant QGraphicsBlurEffect::PerformanceHint") +
    gsi::constant ("QualityHint", &qt_gsi::c_2_QGraphicsBlurEffect_BlurHint_Enum, "@brief Enum constant QGraphicsBlurEffect::QualityHint") +
    gsi::constant ("AnimationHint", &qt_gsi::c_3_QGraphicsBlurEffect_BlurHint_Enum, "@brief Enum constant QGraphicsBlurEffect::AnimationHint");
}

static std::string to_s_QGraphicsBlurEffect_BlurHint_Enum (const QGraphicsBlurEffect_BlurHint_Enum *e)
{
  if (e->value () == QGraphicsBlurEffect::PerformanceHint) { return tl::sprintf ("PerformanceHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsBlurEffect::QualityHint) { return tl::sprintf ("QualityHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsBlurEffect::AnimationHint) { return tl::sprintf ("AnimationHint (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsBlurEffect_BlurHint_Enum (const QGraphicsBlurEffect_BlurHint_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsBlurEffect_BlurHint_Enum *from_i_QGraphicsBlurEffect_BlurHint_Enum (unsigned int i)
{
  return new QGraphicsBlurEffect_BlurHint_Enum ((QGraphicsBlurEffect::BlurHint) i);
}

static bool equalQGraphicsBlurEffect_BlurHint_Enum (const QGraphicsBlurEffect_BlurHint_Enum *e, QGraphicsBlurEffect_BlurHint_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsBlurEffect_BlurHint_Enum (const QGraphicsBlurEffect_BlurHint_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsBlurEffect_BlurHint_Enums oropQGraphicsBlurEffect_BlurHint_Enums (const QGraphicsBlurEffect_BlurHint_Enums *e, const QGraphicsBlurEffect_BlurHint_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsBlurEffect_BlurHint_Enums andopQGraphicsBlurEffect_BlurHint_Enums (const QGraphicsBlurEffect_BlurHint_Enums *e, const QGraphicsBlurEffect_BlurHint_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsBlurEffect_BlurHint_Enums xoropQGraphicsBlurEffect_BlurHint_Enums (const QGraphicsBlurEffect_BlurHint_Enums *e, const QGraphicsBlurEffect_BlurHint_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsBlurEffect_BlurHint_Enums (const QGraphicsBlurEffect_BlurHint_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsBlurEffect::PerformanceHint)) { if (!l.empty ()) l += "|"; l += "PerformanceHint"; }
  if (e->testFlag (QGraphicsBlurEffect::QualityHint)) { if (!l.empty ()) l += "|"; l += "QualityHint"; }
  if (e->testFlag (QGraphicsBlurEffect::AnimationHint)) { if (!l.empty ()) l += "|"; l += "AnimationHint"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsBlurEffect_BlurHint_Enums (const QGraphicsBlurEffect_BlurHint_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsBlurEffect_BlurHint_Enums (const QGraphicsBlurEffect_BlurHint_Enums *e, const QGraphicsBlurEffect_BlurHint_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsBlurEffect_BlurHint_Enums> decl_QGraphicsBlurEffect_BlurHint_Enums ("QGraphicsBlurEffect_QFlags_BlurHint",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsBlurEffect_BlurHint_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsBlurEffect_BlurHint_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsBlurEffect_BlurHint_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsBlurEffect_BlurHint_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsBlurEffect_BlurHint_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsBlurEffect_BlurHint_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsBlurEffect::BlurHint> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsBlurEffect_BlurHint_Enum> decl_QGraphicsBlurEffect_BlurHint_Enum (decl_QGraphicsBlurEffect_BlurHint_Enums, "QGraphicsBlurEffect_BlurHint",
  qt_gsi::mkdefs_QGraphicsBlurEffect_BlurHint () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsBlurEffect_BlurHint_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsBlurEffect_BlurHint_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsBlurEffect_BlurHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsBlurEffect_BlurHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsBlurEffect_BlurHint_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsBlurEffect::BlurHint enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsBlurEffect> inject_QGraphicsBlurEffect_BlurHint_Enum_in_parent (qt_gsi::mkdefs_QGraphicsBlurEffect_BlurHint ());
static gsi::ClassExt<QGraphicsBlurEffect> decl_QGraphicsBlurEffect_BlurHint_Enum_as_child (decl_QGraphicsBlurEffect_BlurHint_Enum, "BlurHint");

}

