
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQVector3D.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQVector3D_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QVector3D

//  Constructor QVector3D::QVector3D()


static void _init_ctor_QVector3D_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QVector3D *> ();
}

static void _call_ctor_QVector3D_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QVector3D *> (new QVector3D ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVector3D_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVector3D::QVector3D()\nThis method creates an object of class QVector3D.", &_init_ctor_QVector3D_0, &_call_ctor_QVector3D_0);
}

//  Constructor QVector3D::QVector3D(double xpos, double ypos, double zpos)


static void _init_ctor_QVector3D_2997 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("xpos");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ypos");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("zpos");
  decl->add_arg<double > (argspec_2);
  decl->set_return_new<QVector3D *> ();
}

static void _call_ctor_QVector3D_2997 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  ret.write<QVector3D *> (new QVector3D (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVector3D_2997 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVector3D::QVector3D(double xpos, double ypos, double zpos)\nThis method creates an object of class QVector3D.", &_init_ctor_QVector3D_2997, &_call_ctor_QVector3D_2997);
}

//  Constructor QVector3D::QVector3D(const QPoint &point)


static void _init_ctor_QVector3D_1916 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return_new<QVector3D *> ();
}

static void _call_ctor_QVector3D_1916 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QVector3D *> (new QVector3D (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVector3D_1916 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVector3D::QVector3D(const QPoint &point)\nThis method creates an object of class QVector3D.", &_init_ctor_QVector3D_1916, &_call_ctor_QVector3D_1916);
}

//  Constructor QVector3D::QVector3D(const QPointF &point)


static void _init_ctor_QVector3D_1986 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return_new<QVector3D *> ();
}

static void _call_ctor_QVector3D_1986 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QVector3D *> (new QVector3D (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVector3D_1986 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVector3D::QVector3D(const QPointF &point)\nThis method creates an object of class QVector3D.", &_init_ctor_QVector3D_1986, &_call_ctor_QVector3D_1986);
}

//  Constructor QVector3D::QVector3D(const QVector2D &vector)


static void _init_ctor_QVector3D_2139 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("vector");
  decl->add_arg<const QVector2D & > (argspec_0);
  decl->set_return_new<QVector3D *> ();
}

static void _call_ctor_QVector3D_2139 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector2D &arg1 = args.read<const QVector2D & > ();
  ret.write<QVector3D *> (new QVector3D (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVector3D_2139 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVector3D::QVector3D(const QVector2D &vector)\nThis method creates an object of class QVector3D.", &_init_ctor_QVector3D_2139, &_call_ctor_QVector3D_2139);
}

//  Constructor QVector3D::QVector3D(const QVector2D &vector, double zpos)


static void _init_ctor_QVector3D_3102 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("vector");
  decl->add_arg<const QVector2D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("zpos");
  decl->add_arg<double > (argspec_1);
  decl->set_return_new<QVector3D *> ();
}

static void _call_ctor_QVector3D_3102 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector2D &arg1 = args.read<const QVector2D & > ();
  double arg2 = args.read<double > ();
  ret.write<QVector3D *> (new QVector3D (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVector3D_3102 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVector3D::QVector3D(const QVector2D &vector, double zpos)\nThis method creates an object of class QVector3D.", &_init_ctor_QVector3D_3102, &_call_ctor_QVector3D_3102);
}

//  Constructor QVector3D::QVector3D(const QVector4D &vector)


static void _init_ctor_QVector3D_2141 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("vector");
  decl->add_arg<const QVector4D & > (argspec_0);
  decl->set_return_new<QVector3D *> ();
}

static void _call_ctor_QVector3D_2141 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector4D &arg1 = args.read<const QVector4D & > ();
  ret.write<QVector3D *> (new QVector3D (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QVector3D_2141 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVector3D::QVector3D(const QVector4D &vector)\nThis method creates an object of class QVector3D.", &_init_ctor_QVector3D_2141, &_call_ctor_QVector3D_2141);
}

// double QVector3D::distanceToLine(const QVector3D &point, const QVector3D &direction)


static void _init_f_distanceToLine_c4172 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QVector3D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("direction");
  decl->add_arg<const QVector3D & > (argspec_1);
  decl->set_return<double > ();
}

static void _call_f_distanceToLine_c4172 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  const QVector3D &arg2 = args.read<const QVector3D & > ();
  ret.write<double > ((double)((QVector3D *)cls)->distanceToLine (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_distanceToLine_c4172 ()
{
  return new qt_gsi::GenericMethod ("distanceToLine", "@brief Method double QVector3D::distanceToLine(const QVector3D &point, const QVector3D &direction)\n", true, &_init_f_distanceToLine_c4172, &_call_f_distanceToLine_c4172);
}

// double QVector3D::distanceToPlane(const QVector3D &plane, const QVector3D &normal)


static void _init_f_distanceToPlane_c4172 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("plane");
  decl->add_arg<const QVector3D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("normal");
  decl->add_arg<const QVector3D & > (argspec_1);
  decl->set_return<double > ();
}

static void _call_f_distanceToPlane_c4172 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  const QVector3D &arg2 = args.read<const QVector3D & > ();
  ret.write<double > ((double)((QVector3D *)cls)->distanceToPlane (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_distanceToPlane_c4172 ()
{
  return new qt_gsi::GenericMethod ("distanceToPlane", "@brief Method double QVector3D::distanceToPlane(const QVector3D &plane, const QVector3D &normal)\n", true, &_init_f_distanceToPlane_c4172, &_call_f_distanceToPlane_c4172);
}

// double QVector3D::distanceToPlane(const QVector3D &plane1, const QVector3D &plane2, const QVector3D &plane3)


static void _init_f_distanceToPlane_c6204 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("plane1");
  decl->add_arg<const QVector3D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("plane2");
  decl->add_arg<const QVector3D & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("plane3");
  decl->add_arg<const QVector3D & > (argspec_2);
  decl->set_return<double > ();
}

static void _call_f_distanceToPlane_c6204 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  const QVector3D &arg2 = args.read<const QVector3D & > ();
  const QVector3D &arg3 = args.read<const QVector3D & > ();
  ret.write<double > ((double)((QVector3D *)cls)->distanceToPlane (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_distanceToPlane_c6204 ()
{
  return new qt_gsi::GenericMethod ("distanceToPlane", "@brief Method double QVector3D::distanceToPlane(const QVector3D &plane1, const QVector3D &plane2, const QVector3D &plane3)\n", true, &_init_f_distanceToPlane_c6204, &_call_f_distanceToPlane_c6204);
}

// bool QVector3D::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QVector3D *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QVector3D::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// double QVector3D::length()


static void _init_f_length_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_length_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QVector3D *)cls)->length ());
}

static qt_gsi::GenericMethod *_create_f_length_c0 ()
{
  return new qt_gsi::GenericMethod ("length", "@brief Method double QVector3D::length()\n", true, &_init_f_length_c0, &_call_f_length_c0);
}

// double QVector3D::lengthSquared()


static void _init_f_lengthSquared_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_lengthSquared_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QVector3D *)cls)->lengthSquared ());
}

static qt_gsi::GenericMethod *_create_f_lengthSquared_c0 ()
{
  return new qt_gsi::GenericMethod ("lengthSquared", "@brief Method double QVector3D::lengthSquared()\n", true, &_init_f_lengthSquared_c0, &_call_f_lengthSquared_c0);
}

// void QVector3D::normalize()


static void _init_f_normalize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_normalize_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QVector3D *)cls)->normalize ();
}

static qt_gsi::GenericMethod *_create_f_normalize_0 ()
{
  return new qt_gsi::GenericMethod ("normalize", "@brief Method void QVector3D::normalize()\n", false, &_init_f_normalize_0, &_call_f_normalize_0);
}

// QVector3D QVector3D::normalized()


static void _init_f_normalized_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVector3D > ();
}

static void _call_f_normalized_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QVector3D > ((QVector3D)((QVector3D *)cls)->normalized ());
}

static qt_gsi::GenericMethod *_create_f_normalized_c0 ()
{
  return new qt_gsi::GenericMethod ("normalized", "@brief Method QVector3D QVector3D::normalized()\n", true, &_init_f_normalized_c0, &_call_f_normalized_c0);
}

// QVector3D &QVector3D::operator*=(double factor)


static void _init_f_operator_star__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("factor");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QVector3D & > ();
}

static void _call_f_operator_star__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QVector3D & > ((QVector3D &)((QVector3D *)cls)->operator*= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_star__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("*=", "@brief Method QVector3D &QVector3D::operator*=(double factor)\n", false, &_init_f_operator_star__eq__1071, &_call_f_operator_star__eq__1071);
}

// QVector3D &QVector3D::operator*=(const QVector3D &vector)


static void _init_f_operator_star__eq__2140 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("vector");
  decl->add_arg<const QVector3D & > (argspec_0);
  decl->set_return<QVector3D & > ();
}

static void _call_f_operator_star__eq__2140 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  ret.write<QVector3D & > ((QVector3D &)((QVector3D *)cls)->operator*= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_star__eq__2140 ()
{
  return new qt_gsi::GenericMethod ("*=", "@brief Method QVector3D &QVector3D::operator*=(const QVector3D &vector)\n", false, &_init_f_operator_star__eq__2140, &_call_f_operator_star__eq__2140);
}

// QVector3D &QVector3D::operator+=(const QVector3D &vector)


static void _init_f_operator_plus__eq__2140 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("vector");
  decl->add_arg<const QVector3D & > (argspec_0);
  decl->set_return<QVector3D & > ();
}

static void _call_f_operator_plus__eq__2140 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  ret.write<QVector3D & > ((QVector3D &)((QVector3D *)cls)->operator+= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_plus__eq__2140 ()
{
  return new qt_gsi::GenericMethod ("+=", "@brief Method QVector3D &QVector3D::operator+=(const QVector3D &vector)\n", false, &_init_f_operator_plus__eq__2140, &_call_f_operator_plus__eq__2140);
}

// QVector3D &QVector3D::operator-=(const QVector3D &vector)


static void _init_f_operator_minus__eq__2140 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("vector");
  decl->add_arg<const QVector3D & > (argspec_0);
  decl->set_return<QVector3D & > ();
}

static void _call_f_operator_minus__eq__2140 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  ret.write<QVector3D & > ((QVector3D &)((QVector3D *)cls)->operator-= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_minus__eq__2140 ()
{
  return new qt_gsi::GenericMethod ("-=", "@brief Method QVector3D &QVector3D::operator-=(const QVector3D &vector)\n", false, &_init_f_operator_minus__eq__2140, &_call_f_operator_minus__eq__2140);
}

// QVector3D &QVector3D::operator/=(double divisor)


static void _init_f_operator_slash__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("divisor");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QVector3D & > ();
}

static void _call_f_operator_slash__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QVector3D & > ((QVector3D &)((QVector3D *)cls)->operator/= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_slash__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("/=", "@brief Method QVector3D &QVector3D::operator/=(double divisor)\n", false, &_init_f_operator_slash__eq__1071, &_call_f_operator_slash__eq__1071);
}

// void QVector3D::setX(double x)


static void _init_f_setX_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setX_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QVector3D *)cls)->setX (arg1);
}

static qt_gsi::GenericMethod *_create_f_setX_1071 ()
{
  return new qt_gsi::GenericMethod ("setX|x=", "@brief Method void QVector3D::setX(double x)\n", false, &_init_f_setX_1071, &_call_f_setX_1071);
}

// void QVector3D::setY(double y)


static void _init_f_setY_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setY_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QVector3D *)cls)->setY (arg1);
}

static qt_gsi::GenericMethod *_create_f_setY_1071 ()
{
  return new qt_gsi::GenericMethod ("setY|y=", "@brief Method void QVector3D::setY(double y)\n", false, &_init_f_setY_1071, &_call_f_setY_1071);
}

// void QVector3D::setZ(double z)


static void _init_f_setZ_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("z");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setZ_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QVector3D *)cls)->setZ (arg1);
}

static qt_gsi::GenericMethod *_create_f_setZ_1071 ()
{
  return new qt_gsi::GenericMethod ("setZ|z=", "@brief Method void QVector3D::setZ(double z)\n", false, &_init_f_setZ_1071, &_call_f_setZ_1071);
}

// QPoint QVector3D::toPoint()


static void _init_f_toPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_toPoint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint > ((QPoint)((QVector3D *)cls)->toPoint ());
}

static qt_gsi::GenericMethod *_create_f_toPoint_c0 ()
{
  return new qt_gsi::GenericMethod ("toPoint", "@brief Method QPoint QVector3D::toPoint()\n", true, &_init_f_toPoint_c0, &_call_f_toPoint_c0);
}

// QPointF QVector3D::toPointF()


static void _init_f_toPointF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_toPointF_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QVector3D *)cls)->toPointF ());
}

static qt_gsi::GenericMethod *_create_f_toPointF_c0 ()
{
  return new qt_gsi::GenericMethod ("toPointF", "@brief Method QPointF QVector3D::toPointF()\n", true, &_init_f_toPointF_c0, &_call_f_toPointF_c0);
}

// QVector2D QVector3D::toVector2D()


static void _init_f_toVector2D_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVector2D > ();
}

static void _call_f_toVector2D_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QVector2D > ((QVector2D)((QVector3D *)cls)->toVector2D ());
}

static qt_gsi::GenericMethod *_create_f_toVector2D_c0 ()
{
  return new qt_gsi::GenericMethod ("toVector2D", "@brief Method QVector2D QVector3D::toVector2D()\n", true, &_init_f_toVector2D_c0, &_call_f_toVector2D_c0);
}

// QVector4D QVector3D::toVector4D()


static void _init_f_toVector4D_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVector4D > ();
}

static void _call_f_toVector4D_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QVector4D > ((QVector4D)((QVector3D *)cls)->toVector4D ());
}

static qt_gsi::GenericMethod *_create_f_toVector4D_c0 ()
{
  return new qt_gsi::GenericMethod ("toVector4D", "@brief Method QVector4D QVector3D::toVector4D()\n", true, &_init_f_toVector4D_c0, &_call_f_toVector4D_c0);
}

// double QVector3D::x()


static void _init_f_x_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_x_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QVector3D *)cls)->x ());
}

static qt_gsi::GenericMethod *_create_f_x_c0 ()
{
  return new qt_gsi::GenericMethod (":x", "@brief Method double QVector3D::x()\n", true, &_init_f_x_c0, &_call_f_x_c0);
}

// double QVector3D::y()


static void _init_f_y_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_y_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QVector3D *)cls)->y ());
}

static qt_gsi::GenericMethod *_create_f_y_c0 ()
{
  return new qt_gsi::GenericMethod (":y", "@brief Method double QVector3D::y()\n", true, &_init_f_y_c0, &_call_f_y_c0);
}

// double QVector3D::z()


static void _init_f_z_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_z_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QVector3D *)cls)->z ());
}

static qt_gsi::GenericMethod *_create_f_z_c0 ()
{
  return new qt_gsi::GenericMethod (":z", "@brief Method double QVector3D::z()\n", true, &_init_f_z_c0, &_call_f_z_c0);
}

// static QVector3D QVector3D::crossProduct(const QVector3D &v1, const QVector3D &v2)


static void _init_f_crossProduct_4172 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("v1");
  decl->add_arg<const QVector3D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("v2");
  decl->add_arg<const QVector3D & > (argspec_1);
  decl->set_return<QVector3D > ();
}

static void _call_f_crossProduct_4172 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  const QVector3D &arg2 = args.read<const QVector3D & > ();
  ret.write<QVector3D > ((QVector3D)QVector3D::crossProduct (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_crossProduct_4172 ()
{
  return new qt_gsi::GenericStaticMethod ("crossProduct", "@brief Static method QVector3D QVector3D::crossProduct(const QVector3D &v1, const QVector3D &v2)\nThis method is static and can be called without an instance.", &_init_f_crossProduct_4172, &_call_f_crossProduct_4172);
}

// static double QVector3D::dotProduct(const QVector3D &v1, const QVector3D &v2)


static void _init_f_dotProduct_4172 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("v1");
  decl->add_arg<const QVector3D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("v2");
  decl->add_arg<const QVector3D & > (argspec_1);
  decl->set_return<double > ();
}

static void _call_f_dotProduct_4172 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  const QVector3D &arg2 = args.read<const QVector3D & > ();
  ret.write<double > ((double)QVector3D::dotProduct (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_dotProduct_4172 ()
{
  return new qt_gsi::GenericStaticMethod ("dotProduct", "@brief Static method double QVector3D::dotProduct(const QVector3D &v1, const QVector3D &v2)\nThis method is static and can be called without an instance.", &_init_f_dotProduct_4172, &_call_f_dotProduct_4172);
}

// static QVector3D QVector3D::normal(const QVector3D &v1, const QVector3D &v2)


static void _init_f_normal_4172 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("v1");
  decl->add_arg<const QVector3D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("v2");
  decl->add_arg<const QVector3D & > (argspec_1);
  decl->set_return<QVector3D > ();
}

static void _call_f_normal_4172 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  const QVector3D &arg2 = args.read<const QVector3D & > ();
  ret.write<QVector3D > ((QVector3D)QVector3D::normal (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_normal_4172 ()
{
  return new qt_gsi::GenericStaticMethod ("normal", "@brief Static method QVector3D QVector3D::normal(const QVector3D &v1, const QVector3D &v2)\nThis method is static and can be called without an instance.", &_init_f_normal_4172, &_call_f_normal_4172);
}

// static QVector3D QVector3D::normal(const QVector3D &v1, const QVector3D &v2, const QVector3D &v3)


static void _init_f_normal_6204 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("v1");
  decl->add_arg<const QVector3D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("v2");
  decl->add_arg<const QVector3D & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("v3");
  decl->add_arg<const QVector3D & > (argspec_2);
  decl->set_return<QVector3D > ();
}

static void _call_f_normal_6204 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  const QVector3D &arg2 = args.read<const QVector3D & > ();
  const QVector3D &arg3 = args.read<const QVector3D & > ();
  ret.write<QVector3D > ((QVector3D)QVector3D::normal (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_normal_6204 ()
{
  return new qt_gsi::GenericStaticMethod ("normal", "@brief Static method QVector3D QVector3D::normal(const QVector3D &v1, const QVector3D &v2, const QVector3D &v3)\nThis method is static and can be called without an instance.", &_init_f_normal_6204, &_call_f_normal_6204);
}

//  bool ::operator==(const QVector3D &v1, const QVector3D &v2)
static bool op_QVector3D_operator_eq__eq__4172(const QVector3D *_self, const QVector3D &v2) {
  return ::operator==(*_self, v2);
}

//  bool ::operator!=(const QVector3D &v1, const QVector3D &v2)
static bool op_QVector3D_operator_excl__eq__4172(const QVector3D *_self, const QVector3D &v2) {
  return ::operator!=(*_self, v2);
}

//  const QVector3D ::operator+(const QVector3D &v1, const QVector3D &v2)
static const QVector3D op_QVector3D_operator_plus__4172(const QVector3D *_self, const QVector3D &v2) {
  return ::operator+(*_self, v2);
}

//  const QVector3D ::operator-(const QVector3D &v1, const QVector3D &v2)
static const QVector3D op_QVector3D_operator_minus__4172(const QVector3D *_self, const QVector3D &v2) {
  return ::operator-(*_self, v2);
}

//  const QVector3D ::operator*(const QVector3D &vector, qreal factor)
static const QVector3D op_QVector3D_operator_star__3001(const QVector3D *_self, qreal factor) {
  return ::operator*(*_self, factor);
}

//  const QVector3D ::operator*(const QVector3D &v1, const QVector3D &v2)
static const QVector3D op_QVector3D_operator_star__4172(const QVector3D *_self, const QVector3D &v2) {
  return ::operator*(*_self, v2);
}

//  const QVector3D ::operator-(const QVector3D &vector)
static const QVector3D op_QVector3D_operator_minus__2140(const QVector3D *_self) {
  return ::operator-(*_self);
}

//  const QVector3D ::operator/(const QVector3D &vector, qreal divisor)
static const QVector3D op_QVector3D_operator_slash__3001(const QVector3D *_self, qreal divisor) {
  return ::operator/(*_self, divisor);
}

//  QVector3D ::operator*(const QVector3D &vector, const QMatrix4x4 &matrix)
static QVector3D op_QVector3D_operator_star__4279u1(const QVector3D *_self, const QMatrix4x4 &matrix) {
  return ::operator*(*_self, matrix);
}


namespace gsi
{
gsi::Class<QVector3D> decl_QVector3D ("QVector3D",
  gsi::Methods(_create_ctor_QVector3D_0 ()) +
  gsi::Methods(_create_ctor_QVector3D_2997 ()) +
  gsi::Methods(_create_ctor_QVector3D_1916 ()) +
  gsi::Methods(_create_ctor_QVector3D_1986 ()) +
  gsi::Methods(_create_ctor_QVector3D_2139 ()) +
  gsi::Methods(_create_ctor_QVector3D_3102 ()) +
  gsi::Methods(_create_ctor_QVector3D_2141 ()) +
  gsi::Methods(_create_f_distanceToLine_c4172 ()) +
  gsi::Methods(_create_f_distanceToPlane_c4172 ()) +
  gsi::Methods(_create_f_distanceToPlane_c6204 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_length_c0 ()) +
  gsi::Methods(_create_f_lengthSquared_c0 ()) +
  gsi::Methods(_create_f_normalize_0 ()) +
  gsi::Methods(_create_f_normalized_c0 ()) +
  gsi::Methods(_create_f_operator_star__eq__1071 ()) +
  gsi::Methods(_create_f_operator_star__eq__2140 ()) +
  gsi::Methods(_create_f_operator_plus__eq__2140 ()) +
  gsi::Methods(_create_f_operator_minus__eq__2140 ()) +
  gsi::Methods(_create_f_operator_slash__eq__1071 ()) +
  gsi::Methods(_create_f_setX_1071 ()) +
  gsi::Methods(_create_f_setY_1071 ()) +
  gsi::Methods(_create_f_setZ_1071 ()) +
  gsi::Methods(_create_f_toPoint_c0 ()) +
  gsi::Methods(_create_f_toPointF_c0 ()) +
  gsi::Methods(_create_f_toVector2D_c0 ()) +
  gsi::Methods(_create_f_toVector4D_c0 ()) +
  gsi::Methods(_create_f_x_c0 ()) +
  gsi::Methods(_create_f_y_c0 ()) +
  gsi::Methods(_create_f_z_c0 ()) +
  gsi::Methods(_create_f_crossProduct_4172 ()) +
  gsi::Methods(_create_f_dotProduct_4172 ()) +
  gsi::Methods(_create_f_normal_4172 ()) +
  gsi::Methods(_create_f_normal_6204 ()) +
  gsi::method_ext("==", &::op_QVector3D_operator_eq__eq__4172, gsi::arg ("v2"), "@brief Operator bool ::operator==(const QVector3D &v1, const QVector3D &v2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("!=", &::op_QVector3D_operator_excl__eq__4172, gsi::arg ("v2"), "@brief Operator bool ::operator!=(const QVector3D &v1, const QVector3D &v2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("+", &::op_QVector3D_operator_plus__4172, gsi::arg ("v2"), "@brief Operator const QVector3D ::operator+(const QVector3D &v1, const QVector3D &v2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("-", &::op_QVector3D_operator_minus__4172, gsi::arg ("v2"), "@brief Operator const QVector3D ::operator-(const QVector3D &v1, const QVector3D &v2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QVector3D_operator_star__3001, gsi::arg ("factor"), "@brief Operator const QVector3D ::operator*(const QVector3D &vector, qreal factor)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QVector3D_operator_star__4172, gsi::arg ("v2"), "@brief Operator const QVector3D ::operator*(const QVector3D &v1, const QVector3D &v2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("-", &::op_QVector3D_operator_minus__2140, "@brief Operator const QVector3D ::operator-(const QVector3D &vector)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("/", &::op_QVector3D_operator_slash__3001, gsi::arg ("divisor"), "@brief Operator const QVector3D ::operator/(const QVector3D &vector, qreal divisor)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QVector3D_operator_star__4279u1, gsi::arg ("matrix"), "@brief Operator QVector3D ::operator*(const QVector3D &vector, const QMatrix4x4 &matrix)\nThis is the mapping of the global operator to the instance method."),
  "@qt\n@brief Binding of QVector3D");

}

