
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTimeLine.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTimeLine_EventAdaptor.h"
#include "gsiDeclQTimeLine_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTimeLine

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTimeLine::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// int QTimeLine::currentFrame()


static void _init_f_currentFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentFrame_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTimeLine *)cls)->currentFrame ());
}

static qt_gsi::GenericMethod *_create_f_currentFrame_c0 ()
{
  return new qt_gsi::GenericMethod ("currentFrame", "@brief Method int QTimeLine::currentFrame()\n", true, &_init_f_currentFrame_c0, &_call_f_currentFrame_c0);
}

// int QTimeLine::currentTime()


static void _init_f_currentTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentTime_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTimeLine *)cls)->currentTime ());
}

static qt_gsi::GenericMethod *_create_f_currentTime_c0 ()
{
  return new qt_gsi::GenericMethod (":currentTime", "@brief Method int QTimeLine::currentTime()\n", true, &_init_f_currentTime_c0, &_call_f_currentTime_c0);
}

// double QTimeLine::currentValue()


static void _init_f_currentValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_currentValue_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTimeLine *)cls)->currentValue ());
}

static qt_gsi::GenericMethod *_create_f_currentValue_c0 ()
{
  return new qt_gsi::GenericMethod ("currentValue", "@brief Method double QTimeLine::currentValue()\n", true, &_init_f_currentValue_c0, &_call_f_currentValue_c0);
}

// QTimeLine::CurveShape QTimeLine::curveShape()


static void _init_f_curveShape_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTimeLine::CurveShape>::target_type > ();
}

static void _call_f_curveShape_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QTimeLine::CurveShape>::target_type > ((qt_gsi::Converter<QTimeLine::CurveShape>::target_type)qt_gsi::CppToQtAdaptor<QTimeLine::CurveShape>(((QTimeLine *)cls)->curveShape ()));
}

static qt_gsi::GenericMethod *_create_f_curveShape_c0 ()
{
  return new qt_gsi::GenericMethod (":curveShape", "@brief Method QTimeLine::CurveShape QTimeLine::curveShape()\n", true, &_init_f_curveShape_c0, &_call_f_curveShape_c0);
}

// QTimeLine::Direction QTimeLine::direction()


static void _init_f_direction_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTimeLine::Direction>::target_type > ();
}

static void _call_f_direction_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QTimeLine::Direction>::target_type > ((qt_gsi::Converter<QTimeLine::Direction>::target_type)qt_gsi::CppToQtAdaptor<QTimeLine::Direction>(((QTimeLine *)cls)->direction ()));
}

static qt_gsi::GenericMethod *_create_f_direction_c0 ()
{
  return new qt_gsi::GenericMethod (":direction", "@brief Method QTimeLine::Direction QTimeLine::direction()\n", true, &_init_f_direction_c0, &_call_f_direction_c0);
}

// int QTimeLine::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTimeLine *)cls)->duration ());
}

static qt_gsi::GenericMethod *_create_f_duration_c0 ()
{
  return new qt_gsi::GenericMethod (":duration", "@brief Method int QTimeLine::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
}

// QEasingCurve QTimeLine::easingCurve()


static void _init_f_easingCurve_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QEasingCurve > ();
}

static void _call_f_easingCurve_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QEasingCurve > ((QEasingCurve)((QTimeLine *)cls)->easingCurve ());
}

static qt_gsi::GenericMethod *_create_f_easingCurve_c0 ()
{
  return new qt_gsi::GenericMethod (":easingCurve", "@brief Method QEasingCurve QTimeLine::easingCurve()\n", true, &_init_f_easingCurve_c0, &_call_f_easingCurve_c0);
}

// int QTimeLine::endFrame()


static void _init_f_endFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_endFrame_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTimeLine *)cls)->endFrame ());
}

static qt_gsi::GenericMethod *_create_f_endFrame_c0 ()
{
  return new qt_gsi::GenericMethod (":endFrame", "@brief Method int QTimeLine::endFrame()\n", true, &_init_f_endFrame_c0, &_call_f_endFrame_c0);
}

// int QTimeLine::frameForTime(int msec)


static void _init_f_frameForTime_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msec");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_frameForTime_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QTimeLine *)cls)->frameForTime (arg1));
}

static qt_gsi::GenericMethod *_create_f_frameForTime_c767 ()
{
  return new qt_gsi::GenericMethod ("frameForTime", "@brief Method int QTimeLine::frameForTime(int msec)\n", true, &_init_f_frameForTime_c767, &_call_f_frameForTime_c767);
}

// int QTimeLine::loopCount()


static void _init_f_loopCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_loopCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTimeLine *)cls)->loopCount ());
}

static qt_gsi::GenericMethod *_create_f_loopCount_c0 ()
{
  return new qt_gsi::GenericMethod (":loopCount", "@brief Method int QTimeLine::loopCount()\n", true, &_init_f_loopCount_c0, &_call_f_loopCount_c0);
}

// void QTimeLine::resume()


static void _init_f_resume_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resume_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTimeLine *)cls)->resume ();
}

static qt_gsi::GenericMethod *_create_f_resume_0 ()
{
  return new qt_gsi::GenericMethod ("resume", "@brief Method void QTimeLine::resume()\n", false, &_init_f_resume_0, &_call_f_resume_0);
}

// void QTimeLine::setCurrentTime(int msec)


static void _init_f_setCurrentTime_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msec");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentTime_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTimeLine *)cls)->setCurrentTime (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCurrentTime_767 ()
{
  return new qt_gsi::GenericMethod ("setCurrentTime|currentTime=", "@brief Method void QTimeLine::setCurrentTime(int msec)\n", false, &_init_f_setCurrentTime_767, &_call_f_setCurrentTime_767);
}

// void QTimeLine::setCurveShape(QTimeLine::CurveShape shape)


static void _init_f_setCurveShape_2438 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("shape");
  decl->add_arg<const qt_gsi::Converter<QTimeLine::CurveShape>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurveShape_2438 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTimeLine::CurveShape>::target_type & arg1 = args.read<const qt_gsi::Converter<QTimeLine::CurveShape>::target_type & > ();
  ((QTimeLine *)cls)->setCurveShape (qt_gsi::QtToCppAdaptor<QTimeLine::CurveShape>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setCurveShape_2438 ()
{
  return new qt_gsi::GenericMethod ("setCurveShape|curveShape=", "@brief Method void QTimeLine::setCurveShape(QTimeLine::CurveShape shape)\n", false, &_init_f_setCurveShape_2438, &_call_f_setCurveShape_2438);
}

// void QTimeLine::setDirection(QTimeLine::Direction direction)


static void _init_f_setDirection_2353 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<QTimeLine::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirection_2353 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTimeLine::Direction>::target_type & arg1 = args.read<const qt_gsi::Converter<QTimeLine::Direction>::target_type & > ();
  ((QTimeLine *)cls)->setDirection (qt_gsi::QtToCppAdaptor<QTimeLine::Direction>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setDirection_2353 ()
{
  return new qt_gsi::GenericMethod ("setDirection|direction=", "@brief Method void QTimeLine::setDirection(QTimeLine::Direction direction)\n", false, &_init_f_setDirection_2353, &_call_f_setDirection_2353);
}

// void QTimeLine::setDuration(int duration)


static void _init_f_setDuration_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDuration_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTimeLine *)cls)->setDuration (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDuration_767 ()
{
  return new qt_gsi::GenericMethod ("setDuration|duration=", "@brief Method void QTimeLine::setDuration(int duration)\n", false, &_init_f_setDuration_767, &_call_f_setDuration_767);
}

// void QTimeLine::setEasingCurve(const QEasingCurve &curve)


static void _init_f_setEasingCurve_2510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("curve");
  decl->add_arg<const QEasingCurve & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEasingCurve_2510 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QEasingCurve &arg1 = args.read<const QEasingCurve & > ();
  ((QTimeLine *)cls)->setEasingCurve (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEasingCurve_2510 ()
{
  return new qt_gsi::GenericMethod ("setEasingCurve|easingCurve=", "@brief Method void QTimeLine::setEasingCurve(const QEasingCurve &curve)\n", false, &_init_f_setEasingCurve_2510, &_call_f_setEasingCurve_2510);
}

// void QTimeLine::setEndFrame(int frame)


static void _init_f_setEndFrame_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frame");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEndFrame_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTimeLine *)cls)->setEndFrame (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEndFrame_767 ()
{
  return new qt_gsi::GenericMethod ("setEndFrame|endFrame=", "@brief Method void QTimeLine::setEndFrame(int frame)\n", false, &_init_f_setEndFrame_767, &_call_f_setEndFrame_767);
}

// void QTimeLine::setFrameRange(int startFrame, int endFrame)


static void _init_f_setFrameRange_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startFrame");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endFrame");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFrameRange_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QTimeLine *)cls)->setFrameRange (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setFrameRange_1426 ()
{
  return new qt_gsi::GenericMethod ("setFrameRange", "@brief Method void QTimeLine::setFrameRange(int startFrame, int endFrame)\n", false, &_init_f_setFrameRange_1426, &_call_f_setFrameRange_1426);
}

// void QTimeLine::setLoopCount(int count)


static void _init_f_setLoopCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("count");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLoopCount_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTimeLine *)cls)->setLoopCount (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLoopCount_767 ()
{
  return new qt_gsi::GenericMethod ("setLoopCount|loopCount=", "@brief Method void QTimeLine::setLoopCount(int count)\n", false, &_init_f_setLoopCount_767, &_call_f_setLoopCount_767);
}

// void QTimeLine::setPaused(bool paused)


static void _init_f_setPaused_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("paused");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPaused_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTimeLine *)cls)->setPaused (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPaused_864 ()
{
  return new qt_gsi::GenericMethod ("setPaused", "@brief Method void QTimeLine::setPaused(bool paused)\n", false, &_init_f_setPaused_864, &_call_f_setPaused_864);
}

// void QTimeLine::setStartFrame(int frame)


static void _init_f_setStartFrame_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frame");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartFrame_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTimeLine *)cls)->setStartFrame (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStartFrame_767 ()
{
  return new qt_gsi::GenericMethod ("setStartFrame|startFrame=", "@brief Method void QTimeLine::setStartFrame(int frame)\n", false, &_init_f_setStartFrame_767, &_call_f_setStartFrame_767);
}

// void QTimeLine::setUpdateInterval(int interval)


static void _init_f_setUpdateInterval_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("interval");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUpdateInterval_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTimeLine *)cls)->setUpdateInterval (arg1);
}

static qt_gsi::GenericMethod *_create_f_setUpdateInterval_767 ()
{
  return new qt_gsi::GenericMethod ("setUpdateInterval|updateInterval=", "@brief Method void QTimeLine::setUpdateInterval(int interval)\n", false, &_init_f_setUpdateInterval_767, &_call_f_setUpdateInterval_767);
}

// void QTimeLine::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTimeLine *)cls)->start ();
}

static qt_gsi::GenericMethod *_create_f_start_0 ()
{
  return new qt_gsi::GenericMethod ("start", "@brief Method void QTimeLine::start()\n", false, &_init_f_start_0, &_call_f_start_0);
}

// int QTimeLine::startFrame()


static void _init_f_startFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startFrame_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTimeLine *)cls)->startFrame ());
}

static qt_gsi::GenericMethod *_create_f_startFrame_c0 ()
{
  return new qt_gsi::GenericMethod (":startFrame", "@brief Method int QTimeLine::startFrame()\n", true, &_init_f_startFrame_c0, &_call_f_startFrame_c0);
}

// QTimeLine::State QTimeLine::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTimeLine::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QTimeLine::State>::target_type > ((qt_gsi::Converter<QTimeLine::State>::target_type)qt_gsi::CppToQtAdaptor<QTimeLine::State>(((QTimeLine *)cls)->state ()));
}

static qt_gsi::GenericMethod *_create_f_state_c0 ()
{
  return new qt_gsi::GenericMethod ("state", "@brief Method QTimeLine::State QTimeLine::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
}

// void QTimeLine::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTimeLine *)cls)->stop ();
}

static qt_gsi::GenericMethod *_create_f_stop_0 ()
{
  return new qt_gsi::GenericMethod ("stop", "@brief Method void QTimeLine::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
}

// void QTimeLine::toggleDirection()


static void _init_f_toggleDirection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_toggleDirection_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTimeLine *)cls)->toggleDirection ();
}

static qt_gsi::GenericMethod *_create_f_toggleDirection_0 ()
{
  return new qt_gsi::GenericMethod ("toggleDirection", "@brief Method void QTimeLine::toggleDirection()\n", false, &_init_f_toggleDirection_0, &_call_f_toggleDirection_0);
}

// int QTimeLine::updateInterval()


static void _init_f_updateInterval_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_updateInterval_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTimeLine *)cls)->updateInterval ());
}

static qt_gsi::GenericMethod *_create_f_updateInterval_c0 ()
{
  return new qt_gsi::GenericMethod (":updateInterval", "@brief Method int QTimeLine::updateInterval()\n", true, &_init_f_updateInterval_c0, &_call_f_updateInterval_c0);
}

// double QTimeLine::valueForTime(int msec)


static void _init_f_valueForTime_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msec");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_valueForTime_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<double > ((double)((QTimeLine *)cls)->valueForTime (arg1));
}

static qt_gsi::GenericMethod *_create_f_valueForTime_c767 ()
{
  return new qt_gsi::GenericMethod ("valueForTime", "@brief Method double QTimeLine::valueForTime(int msec)\n", true, &_init_f_valueForTime_c767, &_call_f_valueForTime_c767);
}

// static QString QTimeLine::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTimeLine::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTimeLine::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QTimeLine::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTimeLine::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTimeLine::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QTimeLine::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTimeLine::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTimeLine::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QTimeLine::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTimeLine::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTimeLine::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QTimeLine, QTimeLine_EventAdaptor> ea_QTimeLine;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QTimeLine> decl_QTimeLine (ea_QTimeLine, decl_QObject, "QTimeLine_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_currentFrame_c0 ()) +
  gsi::Methods(_create_f_currentTime_c0 ()) +
  gsi::Methods(_create_f_currentValue_c0 ()) +
  gsi::Methods(_create_f_curveShape_c0 ()) +
  gsi::Methods(_create_f_direction_c0 ()) +
  gsi::Methods(_create_f_duration_c0 ()) +
  gsi::Methods(_create_f_easingCurve_c0 ()) +
  gsi::Methods(_create_f_endFrame_c0 ()) +
  gsi::Methods(_create_f_frameForTime_c767 ()) +
  gsi::Methods(_create_f_loopCount_c0 ()) +
  gsi::Methods(_create_f_resume_0 ()) +
  gsi::Methods(_create_f_setCurrentTime_767 ()) +
  gsi::Methods(_create_f_setCurveShape_2438 ()) +
  gsi::Methods(_create_f_setDirection_2353 ()) +
  gsi::Methods(_create_f_setDuration_767 ()) +
  gsi::Methods(_create_f_setEasingCurve_2510 ()) +
  gsi::Methods(_create_f_setEndFrame_767 ()) +
  gsi::Methods(_create_f_setFrameRange_1426 ()) +
  gsi::Methods(_create_f_setLoopCount_767 ()) +
  gsi::Methods(_create_f_setPaused_864 ()) +
  gsi::Methods(_create_f_setStartFrame_767 ()) +
  gsi::Methods(_create_f_setUpdateInterval_767 ()) +
  gsi::Methods(_create_f_start_0 ()) +
  gsi::Methods(_create_f_startFrame_c0 ()) +
  gsi::Methods(_create_f_state_c0 ()) +
  gsi::Methods(_create_f_stop_0 ()) +
  gsi::Methods(_create_f_toggleDirection_0 ()) +
  gsi::Methods(_create_f_updateInterval_c0 ()) +
  gsi::Methods(_create_f_valueForTime_c767 ()) +
  qt_gsi::qt_signal<QTimeLine, QTimeLine_EventAdaptor, QObject *> ("destroyed", &QTimeLine_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QTimeLine::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTimeLine, QTimeLine_EventAdaptor> ("finished", &QTimeLine_EventAdaptor::finished_e_0, "@brief Signal declaration for QTimeLine::finished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTimeLine, QTimeLine_EventAdaptor, int> ("frameChanged", &QTimeLine_EventAdaptor::frameChanged_e_767, gsi::arg("arg1"), "@brief Signal declaration for QTimeLine::frameChanged(int)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTimeLine, QTimeLine_EventAdaptor, const qt_gsi::Converter<QTimeLine::State>::target_type &> ("stateChanged", &QTimeLine_EventAdaptor::stateChanged_e_1937, gsi::arg("newState"), "@brief Signal declaration for QTimeLine::stateChanged(QTimeLine::State newState)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTimeLine, QTimeLine_EventAdaptor, double> ("valueChanged", &QTimeLine_EventAdaptor::valueChanged_e_1071, gsi::arg("x"), "@brief Signal declaration for QTimeLine::valueChanged(double x)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QTimeLine");
}


class QTimeLine_Adaptor : public QTimeLine, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTimeLine_Adaptor();

  //  [adaptor ctor] QTimeLine::QTimeLine(int duration, QObject *parent)
  QTimeLine_Adaptor() : QTimeLine()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTimeLine::QTimeLine(int duration, QObject *parent)
  QTimeLine_Adaptor(int duration) : QTimeLine(duration)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTimeLine::QTimeLine(int duration, QObject *parent)
  QTimeLine_Adaptor(int duration, QObject *parent) : QTimeLine(duration, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QTimeLine::receivers(const char *signal)
  int fp_QTimeLine_receivers_c1731 (const char *signal) const {
    return QTimeLine::receivers(signal);
  }

  //  QObject *QTimeLine::sender()
  QObject * fp_QTimeLine_sender_c0 () const {
    return QTimeLine::sender();
  }

  //  [adaptor impl] bool QTimeLine::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QTimeLine::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTimeLine_Adaptor, bool, QEvent *>(&QTimeLine_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QTimeLine::event(arg1);
    }
  }

  //  [adaptor impl] bool QTimeLine::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QTimeLine::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTimeLine_Adaptor, bool, QObject *, QEvent *>(&QTimeLine_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QTimeLine::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] double QTimeLine::valueForTime(int msec)
  double cbs_valueForTime_c767_0(int msec) const
  {
    return QTimeLine::valueForTime(msec);
  }

  virtual double valueForTime(int msec) const
  {
    if (cb_valueForTime_c767_0.can_issue()) {
      return cb_valueForTime_c767_0.issue<QTimeLine_Adaptor, double, int>(&QTimeLine_Adaptor::cbs_valueForTime_c767_0, msec);
    } else {
      return QTimeLine::valueForTime(msec);
    }
  }

  //  [adaptor impl] void QTimeLine::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QTimeLine::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTimeLine_Adaptor, QChildEvent *>(&QTimeLine_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QTimeLine::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QTimeLine::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QTimeLine::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTimeLine_Adaptor, QEvent *>(&QTimeLine_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QTimeLine::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QTimeLine::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QTimeLine::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QTimeLine_Adaptor, const char *>(&QTimeLine_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QTimeLine::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QTimeLine::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QTimeLine::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTimeLine_Adaptor, QTimerEvent *>(&QTimeLine_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QTimeLine::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_valueForTime_c767_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QTimeLine_Adaptor::~QTimeLine_Adaptor() { }

//  Constructor QTimeLine::QTimeLine(int duration, QObject *parent) (adaptor class)

static void _init_ctor_QTimeLine_Adaptor_1961 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration", true, "1000");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QTimeLine_Adaptor *> ();
}

static void _call_ctor_QTimeLine_Adaptor_1961 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(1000);
  QObject *arg2 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QTimeLine_Adaptor *> (new QTimeLine_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTimeLine_Adaptor_1961 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTimeLine::QTimeLine(int duration, QObject *parent)\nThis method creates an object of class QTimeLine.", &_init_ctor_QTimeLine_Adaptor_1961, &_call_ctor_QTimeLine_Adaptor_1961);
}

// int QTimeLine::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QTimeLine_Adaptor *)cls)->fp_QTimeLine_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QTimeLine::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QTimeLine::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QTimeLine_Adaptor *)cls)->fp_QTimeLine_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QTimeLine::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QTimeLine::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTimeLine_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QTimeLine::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QTimeLine::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTimeLine_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTimeLine::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// double QTimeLine::valueForTime(int msec)

static void _init_cbs_valueForTime_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msec");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_cbs_valueForTime_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<double > ((double)((QTimeLine_Adaptor *)cls)->cbs_valueForTime_c767_0 (arg1));
}

static void _set_callback_cbs_valueForTime_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_valueForTime_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_valueForTime_c767_0 ()
{
  return new qt_gsi::GenericMethod ("valueForTime", "@hide", true, &_init_cbs_valueForTime_c767_0, &_call_cbs_valueForTime_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_valueForTime_c767_0 ()
{
  return new qt_gsi::GenericMethod ("valueForTime", "@brief Virtual method double QTimeLine::valueForTime(int msec)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_valueForTime_c767_0, &_call_cbs_valueForTime_c767_0, &_set_callback_cbs_valueForTime_c767_0);
}


// void QTimeLine::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QTimeLine_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTimeLine::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QTimeLine::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QTimeLine_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTimeLine::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QTimeLine::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QTimeLine_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTimeLine::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QTimeLine::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QTimeLine_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTimeLine_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTimeLine::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QTimeLine> decl_QTimeLine;

gsi::Class<QTimeLine_Adaptor> decl_QTimeLine_Adaptor (decl_QTimeLine, "QTimeLine",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_valueForTime_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_valueForTime_c767_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QTimeLine_Adaptor_1961 ()),
  "@qt\n@brief Binding of QTimeLine");

}


//  Implementation of the enum wrapper class for QTimeLine::CurveShape
namespace qt_gsi
{

static QTimeLine_CurveShape_Enum *c_1_QTimeLine_CurveShape_Enum () { return new QTimeLine_CurveShape_Enum (QTimeLine::EaseInCurve); }
static QTimeLine_CurveShape_Enum *c_2_QTimeLine_CurveShape_Enum () { return new QTimeLine_CurveShape_Enum (QTimeLine::EaseOutCurve); }
static QTimeLine_CurveShape_Enum *c_3_QTimeLine_CurveShape_Enum () { return new QTimeLine_CurveShape_Enum (QTimeLine::EaseInOutCurve); }
static QTimeLine_CurveShape_Enum *c_4_QTimeLine_CurveShape_Enum () { return new QTimeLine_CurveShape_Enum (QTimeLine::LinearCurve); }
static QTimeLine_CurveShape_Enum *c_5_QTimeLine_CurveShape_Enum () { return new QTimeLine_CurveShape_Enum (QTimeLine::SineCurve); }
static QTimeLine_CurveShape_Enum *c_6_QTimeLine_CurveShape_Enum () { return new QTimeLine_CurveShape_Enum (QTimeLine::CosineCurve); }

static gsi::Methods mkdefs_QTimeLine_CurveShape () {
  return
    gsi::constant ("EaseInCurve", &qt_gsi::c_1_QTimeLine_CurveShape_Enum, "@brief Enum constant QTimeLine::EaseInCurve") +
    gsi::constant ("EaseOutCurve", &qt_gsi::c_2_QTimeLine_CurveShape_Enum, "@brief Enum constant QTimeLine::EaseOutCurve") +
    gsi::constant ("EaseInOutCurve", &qt_gsi::c_3_QTimeLine_CurveShape_Enum, "@brief Enum constant QTimeLine::EaseInOutCurve") +
    gsi::constant ("LinearCurve", &qt_gsi::c_4_QTimeLine_CurveShape_Enum, "@brief Enum constant QTimeLine::LinearCurve") +
    gsi::constant ("SineCurve", &qt_gsi::c_5_QTimeLine_CurveShape_Enum, "@brief Enum constant QTimeLine::SineCurve") +
    gsi::constant ("CosineCurve", &qt_gsi::c_6_QTimeLine_CurveShape_Enum, "@brief Enum constant QTimeLine::CosineCurve");
}

static std::string to_s_QTimeLine_CurveShape_Enum (const QTimeLine_CurveShape_Enum *e)
{
  if (e->value () == QTimeLine::EaseInCurve) { return tl::sprintf ("EaseInCurve (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTimeLine::EaseOutCurve) { return tl::sprintf ("EaseOutCurve (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTimeLine::EaseInOutCurve) { return tl::sprintf ("EaseInOutCurve (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTimeLine::LinearCurve) { return tl::sprintf ("LinearCurve (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTimeLine::SineCurve) { return tl::sprintf ("SineCurve (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTimeLine::CosineCurve) { return tl::sprintf ("CosineCurve (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTimeLine_CurveShape_Enum (const QTimeLine_CurveShape_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTimeLine_CurveShape_Enum *from_i_QTimeLine_CurveShape_Enum (unsigned int i)
{
  return new QTimeLine_CurveShape_Enum ((QTimeLine::CurveShape) i);
}

static bool equalQTimeLine_CurveShape_Enum (const QTimeLine_CurveShape_Enum *e, QTimeLine_CurveShape_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTimeLine_CurveShape_Enum (const QTimeLine_CurveShape_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTimeLine_CurveShape_Enums oropQTimeLine_CurveShape_Enums (const QTimeLine_CurveShape_Enums *e, const QTimeLine_CurveShape_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTimeLine_CurveShape_Enums andopQTimeLine_CurveShape_Enums (const QTimeLine_CurveShape_Enums *e, const QTimeLine_CurveShape_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTimeLine_CurveShape_Enums xoropQTimeLine_CurveShape_Enums (const QTimeLine_CurveShape_Enums *e, const QTimeLine_CurveShape_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTimeLine_CurveShape_Enums (const QTimeLine_CurveShape_Enums *e)
{
  std::string l;
  if (e->testFlag (QTimeLine::EaseInCurve)) { if (!l.empty ()) l += "|"; l += "EaseInCurve"; }
  if (e->testFlag (QTimeLine::EaseOutCurve)) { if (!l.empty ()) l += "|"; l += "EaseOutCurve"; }
  if (e->testFlag (QTimeLine::EaseInOutCurve)) { if (!l.empty ()) l += "|"; l += "EaseInOutCurve"; }
  if (e->testFlag (QTimeLine::LinearCurve)) { if (!l.empty ()) l += "|"; l += "LinearCurve"; }
  if (e->testFlag (QTimeLine::SineCurve)) { if (!l.empty ()) l += "|"; l += "SineCurve"; }
  if (e->testFlag (QTimeLine::CosineCurve)) { if (!l.empty ()) l += "|"; l += "CosineCurve"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTimeLine_CurveShape_Enums (const QTimeLine_CurveShape_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTimeLine_CurveShape_Enums (const QTimeLine_CurveShape_Enums *e, const QTimeLine_CurveShape_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTimeLine_CurveShape_Enums> decl_QTimeLine_CurveShape_Enums ("QTimeLine_QFlags_CurveShape",
  gsi::method_ext ("|", &qt_gsi::oropQTimeLine_CurveShape_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTimeLine_CurveShape_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTimeLine_CurveShape_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTimeLine_CurveShape_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTimeLine_CurveShape_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTimeLine_CurveShape_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTimeLine::CurveShape> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTimeLine_CurveShape_Enum> decl_QTimeLine_CurveShape_Enum (decl_QTimeLine_CurveShape_Enums, "QTimeLine_CurveShape",
  qt_gsi::mkdefs_QTimeLine_CurveShape () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTimeLine_CurveShape_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTimeLine_CurveShape_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTimeLine_CurveShape_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTimeLine_CurveShape_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTimeLine_CurveShape_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTimeLine::CurveShape enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTimeLine> inject_QTimeLine_CurveShape_Enum_in_parent (qt_gsi::mkdefs_QTimeLine_CurveShape ());
static gsi::ClassExt<QTimeLine> decl_QTimeLine_CurveShape_Enum_as_child (decl_QTimeLine_CurveShape_Enum, "CurveShape");

}


//  Implementation of the enum wrapper class for QTimeLine::Direction
namespace qt_gsi
{

static QTimeLine_Direction_Enum *c_1_QTimeLine_Direction_Enum () { return new QTimeLine_Direction_Enum (QTimeLine::Forward); }
static QTimeLine_Direction_Enum *c_2_QTimeLine_Direction_Enum () { return new QTimeLine_Direction_Enum (QTimeLine::Backward); }

static gsi::Methods mkdefs_QTimeLine_Direction () {
  return
    gsi::constant ("Forward", &qt_gsi::c_1_QTimeLine_Direction_Enum, "@brief Enum constant QTimeLine::Forward") +
    gsi::constant ("Backward", &qt_gsi::c_2_QTimeLine_Direction_Enum, "@brief Enum constant QTimeLine::Backward");
}

static std::string to_s_QTimeLine_Direction_Enum (const QTimeLine_Direction_Enum *e)
{
  if (e->value () == QTimeLine::Forward) { return tl::sprintf ("Forward (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTimeLine::Backward) { return tl::sprintf ("Backward (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTimeLine_Direction_Enum (const QTimeLine_Direction_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTimeLine_Direction_Enum *from_i_QTimeLine_Direction_Enum (unsigned int i)
{
  return new QTimeLine_Direction_Enum ((QTimeLine::Direction) i);
}

static bool equalQTimeLine_Direction_Enum (const QTimeLine_Direction_Enum *e, QTimeLine_Direction_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTimeLine_Direction_Enum (const QTimeLine_Direction_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTimeLine_Direction_Enums oropQTimeLine_Direction_Enums (const QTimeLine_Direction_Enums *e, const QTimeLine_Direction_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTimeLine_Direction_Enums andopQTimeLine_Direction_Enums (const QTimeLine_Direction_Enums *e, const QTimeLine_Direction_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTimeLine_Direction_Enums xoropQTimeLine_Direction_Enums (const QTimeLine_Direction_Enums *e, const QTimeLine_Direction_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTimeLine_Direction_Enums (const QTimeLine_Direction_Enums *e)
{
  std::string l;
  if (e->testFlag (QTimeLine::Forward)) { if (!l.empty ()) l += "|"; l += "Forward"; }
  if (e->testFlag (QTimeLine::Backward)) { if (!l.empty ()) l += "|"; l += "Backward"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTimeLine_Direction_Enums (const QTimeLine_Direction_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTimeLine_Direction_Enums (const QTimeLine_Direction_Enums *e, const QTimeLine_Direction_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTimeLine_Direction_Enums> decl_QTimeLine_Direction_Enums ("QTimeLine_QFlags_Direction",
  gsi::method_ext ("|", &qt_gsi::oropQTimeLine_Direction_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTimeLine_Direction_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTimeLine_Direction_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTimeLine_Direction_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTimeLine_Direction_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTimeLine_Direction_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTimeLine::Direction> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTimeLine_Direction_Enum> decl_QTimeLine_Direction_Enum (decl_QTimeLine_Direction_Enums, "QTimeLine_Direction",
  qt_gsi::mkdefs_QTimeLine_Direction () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTimeLine_Direction_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTimeLine_Direction_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTimeLine_Direction_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTimeLine_Direction_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTimeLine_Direction_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTimeLine::Direction enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTimeLine> inject_QTimeLine_Direction_Enum_in_parent (qt_gsi::mkdefs_QTimeLine_Direction ());
static gsi::ClassExt<QTimeLine> decl_QTimeLine_Direction_Enum_as_child (decl_QTimeLine_Direction_Enum, "Direction");

}


//  Implementation of the enum wrapper class for QTimeLine::State
namespace qt_gsi
{

static QTimeLine_State_Enum *c_1_QTimeLine_State_Enum () { return new QTimeLine_State_Enum (QTimeLine::NotRunning); }
static QTimeLine_State_Enum *c_2_QTimeLine_State_Enum () { return new QTimeLine_State_Enum (QTimeLine::Paused); }
static QTimeLine_State_Enum *c_3_QTimeLine_State_Enum () { return new QTimeLine_State_Enum (QTimeLine::Running); }

static gsi::Methods mkdefs_QTimeLine_State () {
  return
    gsi::constant ("NotRunning", &qt_gsi::c_1_QTimeLine_State_Enum, "@brief Enum constant QTimeLine::NotRunning") +
    gsi::constant ("Paused", &qt_gsi::c_2_QTimeLine_State_Enum, "@brief Enum constant QTimeLine::Paused") +
    gsi::constant ("Running", &qt_gsi::c_3_QTimeLine_State_Enum, "@brief Enum constant QTimeLine::Running");
}

static std::string to_s_QTimeLine_State_Enum (const QTimeLine_State_Enum *e)
{
  if (e->value () == QTimeLine::NotRunning) { return tl::sprintf ("NotRunning (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTimeLine::Paused) { return tl::sprintf ("Paused (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTimeLine::Running) { return tl::sprintf ("Running (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTimeLine_State_Enum (const QTimeLine_State_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTimeLine_State_Enum *from_i_QTimeLine_State_Enum (unsigned int i)
{
  return new QTimeLine_State_Enum ((QTimeLine::State) i);
}

static bool equalQTimeLine_State_Enum (const QTimeLine_State_Enum *e, QTimeLine_State_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTimeLine_State_Enum (const QTimeLine_State_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTimeLine_State_Enums oropQTimeLine_State_Enums (const QTimeLine_State_Enums *e, const QTimeLine_State_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTimeLine_State_Enums andopQTimeLine_State_Enums (const QTimeLine_State_Enums *e, const QTimeLine_State_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTimeLine_State_Enums xoropQTimeLine_State_Enums (const QTimeLine_State_Enums *e, const QTimeLine_State_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTimeLine_State_Enums (const QTimeLine_State_Enums *e)
{
  std::string l;
  if (e->testFlag (QTimeLine::NotRunning)) { if (!l.empty ()) l += "|"; l += "NotRunning"; }
  if (e->testFlag (QTimeLine::Paused)) { if (!l.empty ()) l += "|"; l += "Paused"; }
  if (e->testFlag (QTimeLine::Running)) { if (!l.empty ()) l += "|"; l += "Running"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTimeLine_State_Enums (const QTimeLine_State_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTimeLine_State_Enums (const QTimeLine_State_Enums *e, const QTimeLine_State_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTimeLine_State_Enums> decl_QTimeLine_State_Enums ("QTimeLine_QFlags_State",
  gsi::method_ext ("|", &qt_gsi::oropQTimeLine_State_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTimeLine_State_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTimeLine_State_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTimeLine_State_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTimeLine_State_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTimeLine_State_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTimeLine::State> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTimeLine_State_Enum> decl_QTimeLine_State_Enum (decl_QTimeLine_State_Enums, "QTimeLine_State",
  qt_gsi::mkdefs_QTimeLine_State () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTimeLine_State_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTimeLine_State_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTimeLine_State_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTimeLine_State_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTimeLine_State_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTimeLine::State enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTimeLine> inject_QTimeLine_State_Enum_in_parent (qt_gsi::mkdefs_QTimeLine_State ());
static gsi::ClassExt<QTimeLine> decl_QTimeLine_State_Enum_as_child (decl_QTimeLine_State_Enum, "State");

}

