
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextFrameFormat.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTextFrameFormat_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextFrameFormat

//  Constructor QTextFrameFormat::QTextFrameFormat()


static void _init_ctor_QTextFrameFormat_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTextFrameFormat *> ();
}

static void _call_ctor_QTextFrameFormat_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextFrameFormat *> (new QTextFrameFormat ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextFrameFormat_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextFrameFormat::QTextFrameFormat()\nThis method creates an object of class QTextFrameFormat.", &_init_ctor_QTextFrameFormat_0, &_call_ctor_QTextFrameFormat_0);
}

// double QTextFrameFormat::border()


static void _init_f_border_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_border_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextFrameFormat *)cls)->border ());
}

static qt_gsi::GenericMethod *_create_f_border_c0 ()
{
  return new qt_gsi::GenericMethod (":border", "@brief Method double QTextFrameFormat::border()\n", true, &_init_f_border_c0, &_call_f_border_c0);
}

// QBrush QTextFrameFormat::borderBrush()


static void _init_f_borderBrush_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_borderBrush_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QBrush > ((QBrush)((QTextFrameFormat *)cls)->borderBrush ());
}

static qt_gsi::GenericMethod *_create_f_borderBrush_c0 ()
{
  return new qt_gsi::GenericMethod (":borderBrush", "@brief Method QBrush QTextFrameFormat::borderBrush()\n", true, &_init_f_borderBrush_c0, &_call_f_borderBrush_c0);
}

// QTextFrameFormat::BorderStyle QTextFrameFormat::borderStyle()


static void _init_f_borderStyle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextFrameFormat::BorderStyle>::target_type > ();
}

static void _call_f_borderStyle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QTextFrameFormat::BorderStyle>::target_type > ((qt_gsi::Converter<QTextFrameFormat::BorderStyle>::target_type)qt_gsi::CppToQtAdaptor<QTextFrameFormat::BorderStyle>(((QTextFrameFormat *)cls)->borderStyle ()));
}

static qt_gsi::GenericMethod *_create_f_borderStyle_c0 ()
{
  return new qt_gsi::GenericMethod (":borderStyle", "@brief Method QTextFrameFormat::BorderStyle QTextFrameFormat::borderStyle()\n", true, &_init_f_borderStyle_c0, &_call_f_borderStyle_c0);
}

// double QTextFrameFormat::bottomMargin()


static void _init_f_bottomMargin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_bottomMargin_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextFrameFormat *)cls)->bottomMargin ());
}

static qt_gsi::GenericMethod *_create_f_bottomMargin_c0 ()
{
  return new qt_gsi::GenericMethod (":bottomMargin", "@brief Method double QTextFrameFormat::bottomMargin()\n", true, &_init_f_bottomMargin_c0, &_call_f_bottomMargin_c0);
}

// QTextLength QTextFrameFormat::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextLength > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextLength > ((QTextLength)((QTextFrameFormat *)cls)->height ());
}

static qt_gsi::GenericMethod *_create_f_height_c0 ()
{
  return new qt_gsi::GenericMethod ("height", "@brief Method QTextLength QTextFrameFormat::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
}

// bool QTextFrameFormat::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextFrameFormat *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QTextFrameFormat::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// double QTextFrameFormat::leftMargin()


static void _init_f_leftMargin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_leftMargin_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextFrameFormat *)cls)->leftMargin ());
}

static qt_gsi::GenericMethod *_create_f_leftMargin_c0 ()
{
  return new qt_gsi::GenericMethod (":leftMargin", "@brief Method double QTextFrameFormat::leftMargin()\n", true, &_init_f_leftMargin_c0, &_call_f_leftMargin_c0);
}

// double QTextFrameFormat::margin()


static void _init_f_margin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_margin_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextFrameFormat *)cls)->margin ());
}

static qt_gsi::GenericMethod *_create_f_margin_c0 ()
{
  return new qt_gsi::GenericMethod (":margin", "@brief Method double QTextFrameFormat::margin()\n", true, &_init_f_margin_c0, &_call_f_margin_c0);
}

// double QTextFrameFormat::padding()


static void _init_f_padding_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_padding_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextFrameFormat *)cls)->padding ());
}

static qt_gsi::GenericMethod *_create_f_padding_c0 ()
{
  return new qt_gsi::GenericMethod (":padding", "@brief Method double QTextFrameFormat::padding()\n", true, &_init_f_padding_c0, &_call_f_padding_c0);
}

// QFlags<QTextFormat::PageBreakFlag> QTextFrameFormat::pageBreakPolicy()


static void _init_f_pageBreakPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QTextFormat::PageBreakFlag> >::target_type > ();
}

static void _call_f_pageBreakPolicy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QTextFormat::PageBreakFlag> >::target_type > ((qt_gsi::Converter<QFlags<QTextFormat::PageBreakFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QTextFormat::PageBreakFlag> >(((QTextFrameFormat *)cls)->pageBreakPolicy ()));
}

static qt_gsi::GenericMethod *_create_f_pageBreakPolicy_c0 ()
{
  return new qt_gsi::GenericMethod (":pageBreakPolicy", "@brief Method QFlags<QTextFormat::PageBreakFlag> QTextFrameFormat::pageBreakPolicy()\n", true, &_init_f_pageBreakPolicy_c0, &_call_f_pageBreakPolicy_c0);
}

// QTextFrameFormat::Position QTextFrameFormat::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextFrameFormat::Position>::target_type > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QTextFrameFormat::Position>::target_type > ((qt_gsi::Converter<QTextFrameFormat::Position>::target_type)qt_gsi::CppToQtAdaptor<QTextFrameFormat::Position>(((QTextFrameFormat *)cls)->position ()));
}

static qt_gsi::GenericMethod *_create_f_position_c0 ()
{
  return new qt_gsi::GenericMethod (":position", "@brief Method QTextFrameFormat::Position QTextFrameFormat::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
}

// double QTextFrameFormat::rightMargin()


static void _init_f_rightMargin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_rightMargin_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextFrameFormat *)cls)->rightMargin ());
}

static qt_gsi::GenericMethod *_create_f_rightMargin_c0 ()
{
  return new qt_gsi::GenericMethod (":rightMargin", "@brief Method double QTextFrameFormat::rightMargin()\n", true, &_init_f_rightMargin_c0, &_call_f_rightMargin_c0);
}

// void QTextFrameFormat::setBorder(double border)


static void _init_f_setBorder_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("border");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBorder_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextFrameFormat *)cls)->setBorder (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBorder_1071 ()
{
  return new qt_gsi::GenericMethod ("setBorder|border=", "@brief Method void QTextFrameFormat::setBorder(double border)\n", false, &_init_f_setBorder_1071, &_call_f_setBorder_1071);
}

// void QTextFrameFormat::setBorderBrush(const QBrush &brush)


static void _init_f_setBorderBrush_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBorderBrush_1910 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  ((QTextFrameFormat *)cls)->setBorderBrush (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBorderBrush_1910 ()
{
  return new qt_gsi::GenericMethod ("setBorderBrush|borderBrush=", "@brief Method void QTextFrameFormat::setBorderBrush(const QBrush &brush)\n", false, &_init_f_setBorderBrush_1910, &_call_f_setBorderBrush_1910);
}

// void QTextFrameFormat::setBorderStyle(QTextFrameFormat::BorderStyle style)


static void _init_f_setBorderStyle_3297 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<QTextFrameFormat::BorderStyle>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBorderStyle_3297 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTextFrameFormat::BorderStyle>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextFrameFormat::BorderStyle>::target_type & > ();
  ((QTextFrameFormat *)cls)->setBorderStyle (qt_gsi::QtToCppAdaptor<QTextFrameFormat::BorderStyle>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setBorderStyle_3297 ()
{
  return new qt_gsi::GenericMethod ("setBorderStyle|borderStyle=", "@brief Method void QTextFrameFormat::setBorderStyle(QTextFrameFormat::BorderStyle style)\n", false, &_init_f_setBorderStyle_3297, &_call_f_setBorderStyle_3297);
}

// void QTextFrameFormat::setBottomMargin(double margin)


static void _init_f_setBottomMargin_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margin");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBottomMargin_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextFrameFormat *)cls)->setBottomMargin (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBottomMargin_1071 ()
{
  return new qt_gsi::GenericMethod ("setBottomMargin|bottomMargin=", "@brief Method void QTextFrameFormat::setBottomMargin(double margin)\n", false, &_init_f_setBottomMargin_1071, &_call_f_setBottomMargin_1071);
}

// void QTextFrameFormat::setHeight(double height)


static void _init_f_setHeight_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("height");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeight_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextFrameFormat *)cls)->setHeight (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHeight_1071 ()
{
  return new qt_gsi::GenericMethod ("setHeight", "@brief Method void QTextFrameFormat::setHeight(double height)\n", false, &_init_f_setHeight_1071, &_call_f_setHeight_1071);
}

// void QTextFrameFormat::setHeight(const QTextLength &height)


static void _init_f_setHeight_2425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("height");
  decl->add_arg<const QTextLength & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeight_2425 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextLength &arg1 = args.read<const QTextLength & > ();
  ((QTextFrameFormat *)cls)->setHeight (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHeight_2425 ()
{
  return new qt_gsi::GenericMethod ("setHeight", "@brief Method void QTextFrameFormat::setHeight(const QTextLength &height)\n", false, &_init_f_setHeight_2425, &_call_f_setHeight_2425);
}

// void QTextFrameFormat::setLeftMargin(double margin)


static void _init_f_setLeftMargin_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margin");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLeftMargin_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextFrameFormat *)cls)->setLeftMargin (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLeftMargin_1071 ()
{
  return new qt_gsi::GenericMethod ("setLeftMargin|leftMargin=", "@brief Method void QTextFrameFormat::setLeftMargin(double margin)\n", false, &_init_f_setLeftMargin_1071, &_call_f_setLeftMargin_1071);
}

// void QTextFrameFormat::setMargin(double margin)


static void _init_f_setMargin_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margin");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMargin_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextFrameFormat *)cls)->setMargin (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMargin_1071 ()
{
  return new qt_gsi::GenericMethod ("setMargin|margin=", "@brief Method void QTextFrameFormat::setMargin(double margin)\n", false, &_init_f_setMargin_1071, &_call_f_setMargin_1071);
}

// void QTextFrameFormat::setPadding(double padding)


static void _init_f_setPadding_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("padding");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPadding_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextFrameFormat *)cls)->setPadding (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPadding_1071 ()
{
  return new qt_gsi::GenericMethod ("setPadding|padding=", "@brief Method void QTextFrameFormat::setPadding(double padding)\n", false, &_init_f_setPadding_1071, &_call_f_setPadding_1071);
}

// void QTextFrameFormat::setPageBreakPolicy(QFlags<QTextFormat::PageBreakFlag> flags)


static void _init_f_setPageBreakPolicy_3611 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<QTextFormat::PageBreakFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPageBreakPolicy_3611 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QTextFormat::PageBreakFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QTextFormat::PageBreakFlag> >::target_type & > ();
  ((QTextFrameFormat *)cls)->setPageBreakPolicy (qt_gsi::QtToCppAdaptor<QFlags<QTextFormat::PageBreakFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setPageBreakPolicy_3611 ()
{
  return new qt_gsi::GenericMethod ("setPageBreakPolicy|pageBreakPolicy=", "@brief Method void QTextFrameFormat::setPageBreakPolicy(QFlags<QTextFormat::PageBreakFlag> flags)\n", false, &_init_f_setPageBreakPolicy_3611, &_call_f_setPageBreakPolicy_3611);
}

// void QTextFrameFormat::setPosition(QTextFrameFormat::Position f)


static void _init_f_setPosition_3015 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const qt_gsi::Converter<QTextFrameFormat::Position>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPosition_3015 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTextFrameFormat::Position>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextFrameFormat::Position>::target_type & > ();
  ((QTextFrameFormat *)cls)->setPosition (qt_gsi::QtToCppAdaptor<QTextFrameFormat::Position>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setPosition_3015 ()
{
  return new qt_gsi::GenericMethod ("setPosition|position=", "@brief Method void QTextFrameFormat::setPosition(QTextFrameFormat::Position f)\n", false, &_init_f_setPosition_3015, &_call_f_setPosition_3015);
}

// void QTextFrameFormat::setRightMargin(double margin)


static void _init_f_setRightMargin_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margin");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRightMargin_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextFrameFormat *)cls)->setRightMargin (arg1);
}

static qt_gsi::GenericMethod *_create_f_setRightMargin_1071 ()
{
  return new qt_gsi::GenericMethod ("setRightMargin|rightMargin=", "@brief Method void QTextFrameFormat::setRightMargin(double margin)\n", false, &_init_f_setRightMargin_1071, &_call_f_setRightMargin_1071);
}

// void QTextFrameFormat::setTopMargin(double margin)


static void _init_f_setTopMargin_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margin");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTopMargin_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextFrameFormat *)cls)->setTopMargin (arg1);
}

static qt_gsi::GenericMethod *_create_f_setTopMargin_1071 ()
{
  return new qt_gsi::GenericMethod ("setTopMargin|topMargin=", "@brief Method void QTextFrameFormat::setTopMargin(double margin)\n", false, &_init_f_setTopMargin_1071, &_call_f_setTopMargin_1071);
}

// void QTextFrameFormat::setWidth(double width)


static void _init_f_setWidth_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWidth_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextFrameFormat *)cls)->setWidth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWidth_1071 ()
{
  return new qt_gsi::GenericMethod ("setWidth", "@brief Method void QTextFrameFormat::setWidth(double width)\n", false, &_init_f_setWidth_1071, &_call_f_setWidth_1071);
}

// void QTextFrameFormat::setWidth(const QTextLength &length)


static void _init_f_setWidth_2425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("length");
  decl->add_arg<const QTextLength & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWidth_2425 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextLength &arg1 = args.read<const QTextLength & > ();
  ((QTextFrameFormat *)cls)->setWidth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWidth_2425 ()
{
  return new qt_gsi::GenericMethod ("setWidth", "@brief Method void QTextFrameFormat::setWidth(const QTextLength &length)\n", false, &_init_f_setWidth_2425, &_call_f_setWidth_2425);
}

// double QTextFrameFormat::topMargin()


static void _init_f_topMargin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_topMargin_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextFrameFormat *)cls)->topMargin ());
}

static qt_gsi::GenericMethod *_create_f_topMargin_c0 ()
{
  return new qt_gsi::GenericMethod (":topMargin", "@brief Method double QTextFrameFormat::topMargin()\n", true, &_init_f_topMargin_c0, &_call_f_topMargin_c0);
}

// QTextLength QTextFrameFormat::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextLength > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextLength > ((QTextLength)((QTextFrameFormat *)cls)->width ());
}

static qt_gsi::GenericMethod *_create_f_width_c0 ()
{
  return new qt_gsi::GenericMethod ("width", "@brief Method QTextLength QTextFrameFormat::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
}


namespace gsi
{
extern gsi::Class<QTextFormat> decl_QTextFormat;

gsi::Class<QTextFrameFormat> decl_QTextFrameFormat (decl_QTextFormat, "QTextFrameFormat",
  gsi::Methods(_create_ctor_QTextFrameFormat_0 ()) +
  gsi::Methods(_create_f_border_c0 ()) +
  gsi::Methods(_create_f_borderBrush_c0 ()) +
  gsi::Methods(_create_f_borderStyle_c0 ()) +
  gsi::Methods(_create_f_bottomMargin_c0 ()) +
  gsi::Methods(_create_f_height_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_leftMargin_c0 ()) +
  gsi::Methods(_create_f_margin_c0 ()) +
  gsi::Methods(_create_f_padding_c0 ()) +
  gsi::Methods(_create_f_pageBreakPolicy_c0 ()) +
  gsi::Methods(_create_f_position_c0 ()) +
  gsi::Methods(_create_f_rightMargin_c0 ()) +
  gsi::Methods(_create_f_setBorder_1071 ()) +
  gsi::Methods(_create_f_setBorderBrush_1910 ()) +
  gsi::Methods(_create_f_setBorderStyle_3297 ()) +
  gsi::Methods(_create_f_setBottomMargin_1071 ()) +
  gsi::Methods(_create_f_setHeight_1071 ()) +
  gsi::Methods(_create_f_setHeight_2425 ()) +
  gsi::Methods(_create_f_setLeftMargin_1071 ()) +
  gsi::Methods(_create_f_setMargin_1071 ()) +
  gsi::Methods(_create_f_setPadding_1071 ()) +
  gsi::Methods(_create_f_setPageBreakPolicy_3611 ()) +
  gsi::Methods(_create_f_setPosition_3015 ()) +
  gsi::Methods(_create_f_setRightMargin_1071 ()) +
  gsi::Methods(_create_f_setTopMargin_1071 ()) +
  gsi::Methods(_create_f_setWidth_1071 ()) +
  gsi::Methods(_create_f_setWidth_2425 ()) +
  gsi::Methods(_create_f_topMargin_c0 ()) +
  gsi::Methods(_create_f_width_c0 ()),
  "@qt\n@brief Binding of QTextFrameFormat");

}


//  Implementation of the enum wrapper class for QTextFrameFormat::BorderStyle
namespace qt_gsi
{

static QTextFrameFormat_BorderStyle_Enum *c_1_QTextFrameFormat_BorderStyle_Enum () { return new QTextFrameFormat_BorderStyle_Enum (QTextFrameFormat::BorderStyle_None); }
static QTextFrameFormat_BorderStyle_Enum *c_2_QTextFrameFormat_BorderStyle_Enum () { return new QTextFrameFormat_BorderStyle_Enum (QTextFrameFormat::BorderStyle_Dotted); }
static QTextFrameFormat_BorderStyle_Enum *c_3_QTextFrameFormat_BorderStyle_Enum () { return new QTextFrameFormat_BorderStyle_Enum (QTextFrameFormat::BorderStyle_Dashed); }
static QTextFrameFormat_BorderStyle_Enum *c_4_QTextFrameFormat_BorderStyle_Enum () { return new QTextFrameFormat_BorderStyle_Enum (QTextFrameFormat::BorderStyle_Solid); }
static QTextFrameFormat_BorderStyle_Enum *c_5_QTextFrameFormat_BorderStyle_Enum () { return new QTextFrameFormat_BorderStyle_Enum (QTextFrameFormat::BorderStyle_Double); }
static QTextFrameFormat_BorderStyle_Enum *c_6_QTextFrameFormat_BorderStyle_Enum () { return new QTextFrameFormat_BorderStyle_Enum (QTextFrameFormat::BorderStyle_DotDash); }
static QTextFrameFormat_BorderStyle_Enum *c_7_QTextFrameFormat_BorderStyle_Enum () { return new QTextFrameFormat_BorderStyle_Enum (QTextFrameFormat::BorderStyle_DotDotDash); }
static QTextFrameFormat_BorderStyle_Enum *c_8_QTextFrameFormat_BorderStyle_Enum () { return new QTextFrameFormat_BorderStyle_Enum (QTextFrameFormat::BorderStyle_Groove); }
static QTextFrameFormat_BorderStyle_Enum *c_9_QTextFrameFormat_BorderStyle_Enum () { return new QTextFrameFormat_BorderStyle_Enum (QTextFrameFormat::BorderStyle_Ridge); }
static QTextFrameFormat_BorderStyle_Enum *c_10_QTextFrameFormat_BorderStyle_Enum () { return new QTextFrameFormat_BorderStyle_Enum (QTextFrameFormat::BorderStyle_Inset); }
static QTextFrameFormat_BorderStyle_Enum *c_11_QTextFrameFormat_BorderStyle_Enum () { return new QTextFrameFormat_BorderStyle_Enum (QTextFrameFormat::BorderStyle_Outset); }

static gsi::Methods mkdefs_QTextFrameFormat_BorderStyle () {
  return
    gsi::constant ("BorderStyle_None", &qt_gsi::c_1_QTextFrameFormat_BorderStyle_Enum, "@brief Enum constant QTextFrameFormat::BorderStyle_None") +
    gsi::constant ("BorderStyle_Dotted", &qt_gsi::c_2_QTextFrameFormat_BorderStyle_Enum, "@brief Enum constant QTextFrameFormat::BorderStyle_Dotted") +
    gsi::constant ("BorderStyle_Dashed", &qt_gsi::c_3_QTextFrameFormat_BorderStyle_Enum, "@brief Enum constant QTextFrameFormat::BorderStyle_Dashed") +
    gsi::constant ("BorderStyle_Solid", &qt_gsi::c_4_QTextFrameFormat_BorderStyle_Enum, "@brief Enum constant QTextFrameFormat::BorderStyle_Solid") +
    gsi::constant ("BorderStyle_Double", &qt_gsi::c_5_QTextFrameFormat_BorderStyle_Enum, "@brief Enum constant QTextFrameFormat::BorderStyle_Double") +
    gsi::constant ("BorderStyle_DotDash", &qt_gsi::c_6_QTextFrameFormat_BorderStyle_Enum, "@brief Enum constant QTextFrameFormat::BorderStyle_DotDash") +
    gsi::constant ("BorderStyle_DotDotDash", &qt_gsi::c_7_QTextFrameFormat_BorderStyle_Enum, "@brief Enum constant QTextFrameFormat::BorderStyle_DotDotDash") +
    gsi::constant ("BorderStyle_Groove", &qt_gsi::c_8_QTextFrameFormat_BorderStyle_Enum, "@brief Enum constant QTextFrameFormat::BorderStyle_Groove") +
    gsi::constant ("BorderStyle_Ridge", &qt_gsi::c_9_QTextFrameFormat_BorderStyle_Enum, "@brief Enum constant QTextFrameFormat::BorderStyle_Ridge") +
    gsi::constant ("BorderStyle_Inset", &qt_gsi::c_10_QTextFrameFormat_BorderStyle_Enum, "@brief Enum constant QTextFrameFormat::BorderStyle_Inset") +
    gsi::constant ("BorderStyle_Outset", &qt_gsi::c_11_QTextFrameFormat_BorderStyle_Enum, "@brief Enum constant QTextFrameFormat::BorderStyle_Outset");
}

static std::string to_s_QTextFrameFormat_BorderStyle_Enum (const QTextFrameFormat_BorderStyle_Enum *e)
{
  if (e->value () == QTextFrameFormat::BorderStyle_None) { return tl::sprintf ("BorderStyle_None (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFrameFormat::BorderStyle_Dotted) { return tl::sprintf ("BorderStyle_Dotted (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFrameFormat::BorderStyle_Dashed) { return tl::sprintf ("BorderStyle_Dashed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFrameFormat::BorderStyle_Solid) { return tl::sprintf ("BorderStyle_Solid (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFrameFormat::BorderStyle_Double) { return tl::sprintf ("BorderStyle_Double (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFrameFormat::BorderStyle_DotDash) { return tl::sprintf ("BorderStyle_DotDash (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFrameFormat::BorderStyle_DotDotDash) { return tl::sprintf ("BorderStyle_DotDotDash (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFrameFormat::BorderStyle_Groove) { return tl::sprintf ("BorderStyle_Groove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFrameFormat::BorderStyle_Ridge) { return tl::sprintf ("BorderStyle_Ridge (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFrameFormat::BorderStyle_Inset) { return tl::sprintf ("BorderStyle_Inset (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFrameFormat::BorderStyle_Outset) { return tl::sprintf ("BorderStyle_Outset (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextFrameFormat_BorderStyle_Enum (const QTextFrameFormat_BorderStyle_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextFrameFormat_BorderStyle_Enum *from_i_QTextFrameFormat_BorderStyle_Enum (unsigned int i)
{
  return new QTextFrameFormat_BorderStyle_Enum ((QTextFrameFormat::BorderStyle) i);
}

static bool equalQTextFrameFormat_BorderStyle_Enum (const QTextFrameFormat_BorderStyle_Enum *e, QTextFrameFormat_BorderStyle_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextFrameFormat_BorderStyle_Enum (const QTextFrameFormat_BorderStyle_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextFrameFormat_BorderStyle_Enums oropQTextFrameFormat_BorderStyle_Enums (const QTextFrameFormat_BorderStyle_Enums *e, const QTextFrameFormat_BorderStyle_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextFrameFormat_BorderStyle_Enums andopQTextFrameFormat_BorderStyle_Enums (const QTextFrameFormat_BorderStyle_Enums *e, const QTextFrameFormat_BorderStyle_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextFrameFormat_BorderStyle_Enums xoropQTextFrameFormat_BorderStyle_Enums (const QTextFrameFormat_BorderStyle_Enums *e, const QTextFrameFormat_BorderStyle_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextFrameFormat_BorderStyle_Enums (const QTextFrameFormat_BorderStyle_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextFrameFormat::BorderStyle_None)) { if (!l.empty ()) l += "|"; l += "BorderStyle_None"; }
  if (e->testFlag (QTextFrameFormat::BorderStyle_Dotted)) { if (!l.empty ()) l += "|"; l += "BorderStyle_Dotted"; }
  if (e->testFlag (QTextFrameFormat::BorderStyle_Dashed)) { if (!l.empty ()) l += "|"; l += "BorderStyle_Dashed"; }
  if (e->testFlag (QTextFrameFormat::BorderStyle_Solid)) { if (!l.empty ()) l += "|"; l += "BorderStyle_Solid"; }
  if (e->testFlag (QTextFrameFormat::BorderStyle_Double)) { if (!l.empty ()) l += "|"; l += "BorderStyle_Double"; }
  if (e->testFlag (QTextFrameFormat::BorderStyle_DotDash)) { if (!l.empty ()) l += "|"; l += "BorderStyle_DotDash"; }
  if (e->testFlag (QTextFrameFormat::BorderStyle_DotDotDash)) { if (!l.empty ()) l += "|"; l += "BorderStyle_DotDotDash"; }
  if (e->testFlag (QTextFrameFormat::BorderStyle_Groove)) { if (!l.empty ()) l += "|"; l += "BorderStyle_Groove"; }
  if (e->testFlag (QTextFrameFormat::BorderStyle_Ridge)) { if (!l.empty ()) l += "|"; l += "BorderStyle_Ridge"; }
  if (e->testFlag (QTextFrameFormat::BorderStyle_Inset)) { if (!l.empty ()) l += "|"; l += "BorderStyle_Inset"; }
  if (e->testFlag (QTextFrameFormat::BorderStyle_Outset)) { if (!l.empty ()) l += "|"; l += "BorderStyle_Outset"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextFrameFormat_BorderStyle_Enums (const QTextFrameFormat_BorderStyle_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextFrameFormat_BorderStyle_Enums (const QTextFrameFormat_BorderStyle_Enums *e, const QTextFrameFormat_BorderStyle_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextFrameFormat_BorderStyle_Enums> decl_QTextFrameFormat_BorderStyle_Enums ("QTextFrameFormat_QFlags_BorderStyle",
  gsi::method_ext ("|", &qt_gsi::oropQTextFrameFormat_BorderStyle_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextFrameFormat_BorderStyle_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextFrameFormat_BorderStyle_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextFrameFormat_BorderStyle_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextFrameFormat_BorderStyle_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextFrameFormat_BorderStyle_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextFrameFormat::BorderStyle> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextFrameFormat_BorderStyle_Enum> decl_QTextFrameFormat_BorderStyle_Enum (decl_QTextFrameFormat_BorderStyle_Enums, "QTextFrameFormat_BorderStyle",
  qt_gsi::mkdefs_QTextFrameFormat_BorderStyle () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextFrameFormat_BorderStyle_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextFrameFormat_BorderStyle_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextFrameFormat_BorderStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextFrameFormat_BorderStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextFrameFormat_BorderStyle_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextFrameFormat::BorderStyle enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextFrameFormat> inject_QTextFrameFormat_BorderStyle_Enum_in_parent (qt_gsi::mkdefs_QTextFrameFormat_BorderStyle ());
static gsi::ClassExt<QTextFrameFormat> decl_QTextFrameFormat_BorderStyle_Enum_as_child (decl_QTextFrameFormat_BorderStyle_Enum, "BorderStyle");

}


//  Implementation of the enum wrapper class for QTextFrameFormat::Position
namespace qt_gsi
{

static QTextFrameFormat_Position_Enum *c_1_QTextFrameFormat_Position_Enum () { return new QTextFrameFormat_Position_Enum (QTextFrameFormat::InFlow); }
static QTextFrameFormat_Position_Enum *c_2_QTextFrameFormat_Position_Enum () { return new QTextFrameFormat_Position_Enum (QTextFrameFormat::FloatLeft); }
static QTextFrameFormat_Position_Enum *c_3_QTextFrameFormat_Position_Enum () { return new QTextFrameFormat_Position_Enum (QTextFrameFormat::FloatRight); }

static gsi::Methods mkdefs_QTextFrameFormat_Position () {
  return
    gsi::constant ("InFlow", &qt_gsi::c_1_QTextFrameFormat_Position_Enum, "@brief Enum constant QTextFrameFormat::InFlow") +
    gsi::constant ("FloatLeft", &qt_gsi::c_2_QTextFrameFormat_Position_Enum, "@brief Enum constant QTextFrameFormat::FloatLeft") +
    gsi::constant ("FloatRight", &qt_gsi::c_3_QTextFrameFormat_Position_Enum, "@brief Enum constant QTextFrameFormat::FloatRight");
}

static std::string to_s_QTextFrameFormat_Position_Enum (const QTextFrameFormat_Position_Enum *e)
{
  if (e->value () == QTextFrameFormat::InFlow) { return tl::sprintf ("InFlow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFrameFormat::FloatLeft) { return tl::sprintf ("FloatLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFrameFormat::FloatRight) { return tl::sprintf ("FloatRight (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextFrameFormat_Position_Enum (const QTextFrameFormat_Position_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextFrameFormat_Position_Enum *from_i_QTextFrameFormat_Position_Enum (unsigned int i)
{
  return new QTextFrameFormat_Position_Enum ((QTextFrameFormat::Position) i);
}

static bool equalQTextFrameFormat_Position_Enum (const QTextFrameFormat_Position_Enum *e, QTextFrameFormat_Position_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextFrameFormat_Position_Enum (const QTextFrameFormat_Position_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextFrameFormat_Position_Enums oropQTextFrameFormat_Position_Enums (const QTextFrameFormat_Position_Enums *e, const QTextFrameFormat_Position_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextFrameFormat_Position_Enums andopQTextFrameFormat_Position_Enums (const QTextFrameFormat_Position_Enums *e, const QTextFrameFormat_Position_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextFrameFormat_Position_Enums xoropQTextFrameFormat_Position_Enums (const QTextFrameFormat_Position_Enums *e, const QTextFrameFormat_Position_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextFrameFormat_Position_Enums (const QTextFrameFormat_Position_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextFrameFormat::InFlow)) { if (!l.empty ()) l += "|"; l += "InFlow"; }
  if (e->testFlag (QTextFrameFormat::FloatLeft)) { if (!l.empty ()) l += "|"; l += "FloatLeft"; }
  if (e->testFlag (QTextFrameFormat::FloatRight)) { if (!l.empty ()) l += "|"; l += "FloatRight"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextFrameFormat_Position_Enums (const QTextFrameFormat_Position_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextFrameFormat_Position_Enums (const QTextFrameFormat_Position_Enums *e, const QTextFrameFormat_Position_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextFrameFormat_Position_Enums> decl_QTextFrameFormat_Position_Enums ("QTextFrameFormat_QFlags_Position",
  gsi::method_ext ("|", &qt_gsi::oropQTextFrameFormat_Position_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextFrameFormat_Position_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextFrameFormat_Position_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextFrameFormat_Position_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextFrameFormat_Position_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextFrameFormat_Position_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextFrameFormat::Position> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextFrameFormat_Position_Enum> decl_QTextFrameFormat_Position_Enum (decl_QTextFrameFormat_Position_Enums, "QTextFrameFormat_Position",
  qt_gsi::mkdefs_QTextFrameFormat_Position () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextFrameFormat_Position_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextFrameFormat_Position_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextFrameFormat_Position_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextFrameFormat_Position_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextFrameFormat_Position_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextFrameFormat::Position enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextFrameFormat> inject_QTextFrameFormat_Position_Enum_in_parent (qt_gsi::mkdefs_QTextFrameFormat_Position ());
static gsi::ClassExt<QTextFrameFormat> decl_QTextFrameFormat_Position_Enum_as_child (decl_QTextFrameFormat_Position_Enum, "Position");

}

