
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextFormat.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTextFormat_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextFormat

//  Constructor QTextFormat::QTextFormat()


static void _init_ctor_QTextFormat_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTextFormat *> ();
}

static void _call_ctor_QTextFormat_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextFormat *> (new QTextFormat ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextFormat_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextFormat::QTextFormat()\nThis method creates an object of class QTextFormat.", &_init_ctor_QTextFormat_0, &_call_ctor_QTextFormat_0);
}

//  Constructor QTextFormat::QTextFormat(int type)


static void _init_ctor_QTextFormat_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QTextFormat *> ();
}

static void _call_ctor_QTextFormat_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextFormat *> (new QTextFormat (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextFormat_767 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextFormat::QTextFormat(int type)\nThis method creates an object of class QTextFormat.", &_init_ctor_QTextFormat_767, &_call_ctor_QTextFormat_767);
}

//  Constructor QTextFormat::QTextFormat(const QTextFormat &rhs)


static void _init_ctor_QTextFormat_2432 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextFormat & > (argspec_0);
  decl->set_return_new<QTextFormat *> ();
}

static void _call_ctor_QTextFormat_2432 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextFormat &arg1 = args.read<const QTextFormat & > ();
  ret.write<QTextFormat *> (new QTextFormat (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextFormat_2432 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextFormat::QTextFormat(const QTextFormat &rhs)\nThis method creates an object of class QTextFormat.", &_init_ctor_QTextFormat_2432, &_call_ctor_QTextFormat_2432);
}

// QBrush QTextFormat::background()


static void _init_f_background_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_background_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QBrush > ((QBrush)((QTextFormat *)cls)->background ());
}

static qt_gsi::GenericMethod *_create_f_background_c0 ()
{
  return new qt_gsi::GenericMethod (":background", "@brief Method QBrush QTextFormat::background()\n", true, &_init_f_background_c0, &_call_f_background_c0);
}

// bool QTextFormat::boolProperty(int propertyId)


static void _init_f_boolProperty_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_boolProperty_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)((QTextFormat *)cls)->boolProperty (arg1));
}

static qt_gsi::GenericMethod *_create_f_boolProperty_c767 ()
{
  return new qt_gsi::GenericMethod ("boolProperty", "@brief Method bool QTextFormat::boolProperty(int propertyId)\n", true, &_init_f_boolProperty_c767, &_call_f_boolProperty_c767);
}

// QBrush QTextFormat::brushProperty(int propertyId)


static void _init_f_brushProperty_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QBrush > ();
}

static void _call_f_brushProperty_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QBrush > ((QBrush)((QTextFormat *)cls)->brushProperty (arg1));
}

static qt_gsi::GenericMethod *_create_f_brushProperty_c767 ()
{
  return new qt_gsi::GenericMethod ("brushProperty", "@brief Method QBrush QTextFormat::brushProperty(int propertyId)\n", true, &_init_f_brushProperty_c767, &_call_f_brushProperty_c767);
}

// void QTextFormat::clearBackground()


static void _init_f_clearBackground_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearBackground_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextFormat *)cls)->clearBackground ();
}

static qt_gsi::GenericMethod *_create_f_clearBackground_0 ()
{
  return new qt_gsi::GenericMethod ("clearBackground", "@brief Method void QTextFormat::clearBackground()\n", false, &_init_f_clearBackground_0, &_call_f_clearBackground_0);
}

// void QTextFormat::clearForeground()


static void _init_f_clearForeground_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearForeground_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextFormat *)cls)->clearForeground ();
}

static qt_gsi::GenericMethod *_create_f_clearForeground_0 ()
{
  return new qt_gsi::GenericMethod ("clearForeground", "@brief Method void QTextFormat::clearForeground()\n", false, &_init_f_clearForeground_0, &_call_f_clearForeground_0);
}

// void QTextFormat::clearProperty(int propertyId)


static void _init_f_clearProperty_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_clearProperty_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTextFormat *)cls)->clearProperty (arg1);
}

static qt_gsi::GenericMethod *_create_f_clearProperty_767 ()
{
  return new qt_gsi::GenericMethod ("clearProperty", "@brief Method void QTextFormat::clearProperty(int propertyId)\n", false, &_init_f_clearProperty_767, &_call_f_clearProperty_767);
}

// QColor QTextFormat::colorProperty(int propertyId)


static void _init_f_colorProperty_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QColor > ();
}

static void _call_f_colorProperty_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QColor > ((QColor)((QTextFormat *)cls)->colorProperty (arg1));
}

static qt_gsi::GenericMethod *_create_f_colorProperty_c767 ()
{
  return new qt_gsi::GenericMethod ("colorProperty", "@brief Method QColor QTextFormat::colorProperty(int propertyId)\n", true, &_init_f_colorProperty_c767, &_call_f_colorProperty_c767);
}

// double QTextFormat::doubleProperty(int propertyId)


static void _init_f_doubleProperty_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_doubleProperty_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<double > ((double)((QTextFormat *)cls)->doubleProperty (arg1));
}

static qt_gsi::GenericMethod *_create_f_doubleProperty_c767 ()
{
  return new qt_gsi::GenericMethod ("doubleProperty", "@brief Method double QTextFormat::doubleProperty(int propertyId)\n", true, &_init_f_doubleProperty_c767, &_call_f_doubleProperty_c767);
}

// QBrush QTextFormat::foreground()


static void _init_f_foreground_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_foreground_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QBrush > ((QBrush)((QTextFormat *)cls)->foreground ());
}

static qt_gsi::GenericMethod *_create_f_foreground_c0 ()
{
  return new qt_gsi::GenericMethod (":foreground", "@brief Method QBrush QTextFormat::foreground()\n", true, &_init_f_foreground_c0, &_call_f_foreground_c0);
}

// bool QTextFormat::hasProperty(int propertyId)


static void _init_f_hasProperty_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasProperty_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)((QTextFormat *)cls)->hasProperty (arg1));
}

static qt_gsi::GenericMethod *_create_f_hasProperty_c767 ()
{
  return new qt_gsi::GenericMethod ("hasProperty", "@brief Method bool QTextFormat::hasProperty(int propertyId)\n", true, &_init_f_hasProperty_c767, &_call_f_hasProperty_c767);
}

// int QTextFormat::intProperty(int propertyId)


static void _init_f_intProperty_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_intProperty_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QTextFormat *)cls)->intProperty (arg1));
}

static qt_gsi::GenericMethod *_create_f_intProperty_c767 ()
{
  return new qt_gsi::GenericMethod ("intProperty", "@brief Method int QTextFormat::intProperty(int propertyId)\n", true, &_init_f_intProperty_c767, &_call_f_intProperty_c767);
}

// bool QTextFormat::isBlockFormat()


static void _init_f_isBlockFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isBlockFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextFormat *)cls)->isBlockFormat ());
}

static qt_gsi::GenericMethod *_create_f_isBlockFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("isBlockFormat?", "@brief Method bool QTextFormat::isBlockFormat()\n", true, &_init_f_isBlockFormat_c0, &_call_f_isBlockFormat_c0);
}

// bool QTextFormat::isCharFormat()


static void _init_f_isCharFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isCharFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextFormat *)cls)->isCharFormat ());
}

static qt_gsi::GenericMethod *_create_f_isCharFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("isCharFormat?", "@brief Method bool QTextFormat::isCharFormat()\n", true, &_init_f_isCharFormat_c0, &_call_f_isCharFormat_c0);
}

// bool QTextFormat::isFrameFormat()


static void _init_f_isFrameFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFrameFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextFormat *)cls)->isFrameFormat ());
}

static qt_gsi::GenericMethod *_create_f_isFrameFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("isFrameFormat?", "@brief Method bool QTextFormat::isFrameFormat()\n", true, &_init_f_isFrameFormat_c0, &_call_f_isFrameFormat_c0);
}

// bool QTextFormat::isImageFormat()


static void _init_f_isImageFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isImageFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextFormat *)cls)->isImageFormat ());
}

static qt_gsi::GenericMethod *_create_f_isImageFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("isImageFormat?", "@brief Method bool QTextFormat::isImageFormat()\n", true, &_init_f_isImageFormat_c0, &_call_f_isImageFormat_c0);
}

// bool QTextFormat::isListFormat()


static void _init_f_isListFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isListFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextFormat *)cls)->isListFormat ());
}

static qt_gsi::GenericMethod *_create_f_isListFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("isListFormat?", "@brief Method bool QTextFormat::isListFormat()\n", true, &_init_f_isListFormat_c0, &_call_f_isListFormat_c0);
}

// bool QTextFormat::isTableCellFormat()


static void _init_f_isTableCellFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTableCellFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextFormat *)cls)->isTableCellFormat ());
}

static qt_gsi::GenericMethod *_create_f_isTableCellFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("isTableCellFormat?", "@brief Method bool QTextFormat::isTableCellFormat()\n", true, &_init_f_isTableCellFormat_c0, &_call_f_isTableCellFormat_c0);
}

// bool QTextFormat::isTableFormat()


static void _init_f_isTableFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTableFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextFormat *)cls)->isTableFormat ());
}

static qt_gsi::GenericMethod *_create_f_isTableFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("isTableFormat?", "@brief Method bool QTextFormat::isTableFormat()\n", true, &_init_f_isTableFormat_c0, &_call_f_isTableFormat_c0);
}

// bool QTextFormat::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextFormat *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QTextFormat::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// Qt::LayoutDirection QTextFormat::layoutDirection()


static void _init_f_layoutDirection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_layoutDirection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(((QTextFormat *)cls)->layoutDirection ()));
}

static qt_gsi::GenericMethod *_create_f_layoutDirection_c0 ()
{
  return new qt_gsi::GenericMethod (":layoutDirection", "@brief Method Qt::LayoutDirection QTextFormat::layoutDirection()\n", true, &_init_f_layoutDirection_c0, &_call_f_layoutDirection_c0);
}

// QTextLength QTextFormat::lengthProperty(int propertyId)


static void _init_f_lengthProperty_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextLength > ();
}

static void _call_f_lengthProperty_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextLength > ((QTextLength)((QTextFormat *)cls)->lengthProperty (arg1));
}

static qt_gsi::GenericMethod *_create_f_lengthProperty_c767 ()
{
  return new qt_gsi::GenericMethod ("lengthProperty", "@brief Method QTextLength QTextFormat::lengthProperty(int propertyId)\n", true, &_init_f_lengthProperty_c767, &_call_f_lengthProperty_c767);
}

// QVector<QTextLength> QTextFormat::lengthVectorProperty(int propertyId)


static void _init_f_lengthVectorProperty_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<qt_gsi::Converter<QVector<QTextLength> >::target_type > ();
}

static void _call_f_lengthVectorProperty_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<qt_gsi::Converter<QVector<QTextLength> >::target_type > ((qt_gsi::Converter<QVector<QTextLength> >::target_type)qt_gsi::CppToQtAdaptor<QVector<QTextLength> >(((QTextFormat *)cls)->lengthVectorProperty (arg1)));
}

static qt_gsi::GenericMethod *_create_f_lengthVectorProperty_c767 ()
{
  return new qt_gsi::GenericMethod ("lengthVectorProperty", "@brief Method QVector<QTextLength> QTextFormat::lengthVectorProperty(int propertyId)\n", true, &_init_f_lengthVectorProperty_c767, &_call_f_lengthVectorProperty_c767);
}

// void QTextFormat::merge(const QTextFormat &other)


static void _init_f_merge_2432 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QTextFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_merge_2432 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextFormat &arg1 = args.read<const QTextFormat & > ();
  ((QTextFormat *)cls)->merge (arg1);
}

static qt_gsi::GenericMethod *_create_f_merge_2432 ()
{
  return new qt_gsi::GenericMethod ("merge", "@brief Method void QTextFormat::merge(const QTextFormat &other)\n", false, &_init_f_merge_2432, &_call_f_merge_2432);
}

// int QTextFormat::objectIndex()


static void _init_f_objectIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_objectIndex_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextFormat *)cls)->objectIndex ());
}

static qt_gsi::GenericMethod *_create_f_objectIndex_c0 ()
{
  return new qt_gsi::GenericMethod (":objectIndex", "@brief Method int QTextFormat::objectIndex()\n", true, &_init_f_objectIndex_c0, &_call_f_objectIndex_c0);
}

// int QTextFormat::objectType()


static void _init_f_objectType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_objectType_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextFormat *)cls)->objectType ());
}

static qt_gsi::GenericMethod *_create_f_objectType_c0 ()
{
  return new qt_gsi::GenericMethod (":objectType", "@brief Method int QTextFormat::objectType()\n", true, &_init_f_objectType_c0, &_call_f_objectType_c0);
}

// bool QTextFormat::operator!=(const QTextFormat &rhs)


static void _init_f_operator_excl__eq__c2432 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2432 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextFormat &arg1 = args.read<const QTextFormat & > ();
  ret.write<bool > ((bool)((QTextFormat *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2432 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QTextFormat::operator!=(const QTextFormat &rhs)\n", true, &_init_f_operator_excl__eq__c2432, &_call_f_operator_excl__eq__c2432);
}

// QTextFormat &QTextFormat::operator=(const QTextFormat &rhs)


static void _init_f_operator_eq__2432 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextFormat & > (argspec_0);
  decl->set_return<QTextFormat & > ();
}

static void _call_f_operator_eq__2432 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextFormat &arg1 = args.read<const QTextFormat & > ();
  ret.write<QTextFormat & > ((QTextFormat &)((QTextFormat *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2432 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QTextFormat &QTextFormat::operator=(const QTextFormat &rhs)\n", false, &_init_f_operator_eq__2432, &_call_f_operator_eq__2432);
}

// bool QTextFormat::operator==(const QTextFormat &rhs)


static void _init_f_operator_eq__eq__c2432 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2432 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextFormat &arg1 = args.read<const QTextFormat & > ();
  ret.write<bool > ((bool)((QTextFormat *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2432 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QTextFormat::operator==(const QTextFormat &rhs)\n", true, &_init_f_operator_eq__eq__c2432, &_call_f_operator_eq__eq__c2432);
}

// QPen QTextFormat::penProperty(int propertyId)


static void _init_f_penProperty_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QPen > ();
}

static void _call_f_penProperty_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QPen > ((QPen)((QTextFormat *)cls)->penProperty (arg1));
}

static qt_gsi::GenericMethod *_create_f_penProperty_c767 ()
{
  return new qt_gsi::GenericMethod ("penProperty", "@brief Method QPen QTextFormat::penProperty(int propertyId)\n", true, &_init_f_penProperty_c767, &_call_f_penProperty_c767);
}

// QVariant QTextFormat::property(int propertyId)


static void _init_f_property_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_property_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QTextFormat *)cls)->property (arg1));
}

static qt_gsi::GenericMethod *_create_f_property_c767 ()
{
  return new qt_gsi::GenericMethod ("property", "@brief Method QVariant QTextFormat::property(int propertyId)\n", true, &_init_f_property_c767, &_call_f_property_c767);
}

// int QTextFormat::propertyCount()


static void _init_f_propertyCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_propertyCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextFormat *)cls)->propertyCount ());
}

static qt_gsi::GenericMethod *_create_f_propertyCount_c0 ()
{
  return new qt_gsi::GenericMethod ("propertyCount", "@brief Method int QTextFormat::propertyCount()\n", true, &_init_f_propertyCount_c0, &_call_f_propertyCount_c0);
}

// void QTextFormat::setBackground(const QBrush &brush)


static void _init_f_setBackground_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackground_1910 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  ((QTextFormat *)cls)->setBackground (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBackground_1910 ()
{
  return new qt_gsi::GenericMethod ("setBackground|background=", "@brief Method void QTextFormat::setBackground(const QBrush &brush)\n", false, &_init_f_setBackground_1910, &_call_f_setBackground_1910);
}

// void QTextFormat::setForeground(const QBrush &brush)


static void _init_f_setForeground_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setForeground_1910 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  ((QTextFormat *)cls)->setForeground (arg1);
}

static qt_gsi::GenericMethod *_create_f_setForeground_1910 ()
{
  return new qt_gsi::GenericMethod ("setForeground|foreground=", "@brief Method void QTextFormat::setForeground(const QBrush &brush)\n", false, &_init_f_setForeground_1910, &_call_f_setForeground_1910);
}

// void QTextFormat::setLayoutDirection(Qt::LayoutDirection direction)


static void _init_f_setLayoutDirection_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayoutDirection_2316 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > ();
  ((QTextFormat *)cls)->setLayoutDirection (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setLayoutDirection_2316 ()
{
  return new qt_gsi::GenericMethod ("setLayoutDirection|layoutDirection=", "@brief Method void QTextFormat::setLayoutDirection(Qt::LayoutDirection direction)\n", false, &_init_f_setLayoutDirection_2316, &_call_f_setLayoutDirection_2316);
}

// void QTextFormat::setObjectIndex(int object)


static void _init_f_setObjectIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setObjectIndex_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTextFormat *)cls)->setObjectIndex (arg1);
}

static qt_gsi::GenericMethod *_create_f_setObjectIndex_767 ()
{
  return new qt_gsi::GenericMethod ("setObjectIndex|objectIndex=", "@brief Method void QTextFormat::setObjectIndex(int object)\n", false, &_init_f_setObjectIndex_767, &_call_f_setObjectIndex_767);
}

// void QTextFormat::setObjectType(int type)


static void _init_f_setObjectType_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setObjectType_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTextFormat *)cls)->setObjectType (arg1);
}

static qt_gsi::GenericMethod *_create_f_setObjectType_767 ()
{
  return new qt_gsi::GenericMethod ("setObjectType|objectType=", "@brief Method void QTextFormat::setObjectType(int type)\n", false, &_init_f_setObjectType_767, &_call_f_setObjectType_767);
}

// void QTextFormat::setProperty(int propertyId, const QVariant &value)


static void _init_f_setProperty_2778 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setProperty_2778 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QTextFormat *)cls)->setProperty (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setProperty_2778 ()
{
  return new qt_gsi::GenericMethod ("setProperty", "@brief Method void QTextFormat::setProperty(int propertyId, const QVariant &value)\n", false, &_init_f_setProperty_2778, &_call_f_setProperty_2778);
}

// void QTextFormat::setProperty(int propertyId, const QVector<QTextLength> &lengths)


static void _init_f_setProperty_3914 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("lengths");
  decl->add_arg<const qt_gsi::Converter<QVector<QTextLength> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setProperty_3914 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QVector<QTextLength> >::target_type & arg2 = args.read<const qt_gsi::Converter<QVector<QTextLength> >::target_type & > ();
  ((QTextFormat *)cls)->setProperty (arg1, qt_gsi::QtToCppAdaptor<QVector<QTextLength> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setProperty_3914 ()
{
  return new qt_gsi::GenericMethod ("setProperty", "@brief Method void QTextFormat::setProperty(int propertyId, const QVector<QTextLength> &lengths)\n", false, &_init_f_setProperty_3914, &_call_f_setProperty_3914);
}

// QString QTextFormat::stringProperty(int propertyId)


static void _init_f_stringProperty_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_stringProperty_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QString > ((QString)((QTextFormat *)cls)->stringProperty (arg1));
}

static qt_gsi::GenericMethod *_create_f_stringProperty_c767 ()
{
  return new qt_gsi::GenericMethod ("stringProperty", "@brief Method QString QTextFormat::stringProperty(int propertyId)\n", true, &_init_f_stringProperty_c767, &_call_f_stringProperty_c767);
}

// QTextBlockFormat QTextFormat::toBlockFormat()


static void _init_f_toBlockFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlockFormat > ();
}

static void _call_f_toBlockFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextBlockFormat > ((QTextBlockFormat)((QTextFormat *)cls)->toBlockFormat ());
}

static qt_gsi::GenericMethod *_create_f_toBlockFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("toBlockFormat", "@brief Method QTextBlockFormat QTextFormat::toBlockFormat()\n", true, &_init_f_toBlockFormat_c0, &_call_f_toBlockFormat_c0);
}

// QTextCharFormat QTextFormat::toCharFormat()


static void _init_f_toCharFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCharFormat > ();
}

static void _call_f_toCharFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextCharFormat > ((QTextCharFormat)((QTextFormat *)cls)->toCharFormat ());
}

static qt_gsi::GenericMethod *_create_f_toCharFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("toCharFormat", "@brief Method QTextCharFormat QTextFormat::toCharFormat()\n", true, &_init_f_toCharFormat_c0, &_call_f_toCharFormat_c0);
}

// QTextFrameFormat QTextFormat::toFrameFormat()


static void _init_f_toFrameFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextFrameFormat > ();
}

static void _call_f_toFrameFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextFrameFormat > ((QTextFrameFormat)((QTextFormat *)cls)->toFrameFormat ());
}

static qt_gsi::GenericMethod *_create_f_toFrameFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("toFrameFormat", "@brief Method QTextFrameFormat QTextFormat::toFrameFormat()\n", true, &_init_f_toFrameFormat_c0, &_call_f_toFrameFormat_c0);
}

// QTextImageFormat QTextFormat::toImageFormat()


static void _init_f_toImageFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextImageFormat > ();
}

static void _call_f_toImageFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextImageFormat > ((QTextImageFormat)((QTextFormat *)cls)->toImageFormat ());
}

static qt_gsi::GenericMethod *_create_f_toImageFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("toImageFormat", "@brief Method QTextImageFormat QTextFormat::toImageFormat()\n", true, &_init_f_toImageFormat_c0, &_call_f_toImageFormat_c0);
}

// QTextListFormat QTextFormat::toListFormat()


static void _init_f_toListFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextListFormat > ();
}

static void _call_f_toListFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextListFormat > ((QTextListFormat)((QTextFormat *)cls)->toListFormat ());
}

static qt_gsi::GenericMethod *_create_f_toListFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("toListFormat", "@brief Method QTextListFormat QTextFormat::toListFormat()\n", true, &_init_f_toListFormat_c0, &_call_f_toListFormat_c0);
}

// QTextTableCellFormat QTextFormat::toTableCellFormat()


static void _init_f_toTableCellFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextTableCellFormat > ();
}

static void _call_f_toTableCellFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextTableCellFormat > ((QTextTableCellFormat)((QTextFormat *)cls)->toTableCellFormat ());
}

static qt_gsi::GenericMethod *_create_f_toTableCellFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("toTableCellFormat", "@brief Method QTextTableCellFormat QTextFormat::toTableCellFormat()\n", true, &_init_f_toTableCellFormat_c0, &_call_f_toTableCellFormat_c0);
}

// QTextTableFormat QTextFormat::toTableFormat()


static void _init_f_toTableFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextTableFormat > ();
}

static void _call_f_toTableFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextTableFormat > ((QTextTableFormat)((QTextFormat *)cls)->toTableFormat ());
}

static qt_gsi::GenericMethod *_create_f_toTableFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("toTableFormat", "@brief Method QTextTableFormat QTextFormat::toTableFormat()\n", true, &_init_f_toTableFormat_c0, &_call_f_toTableFormat_c0);
}

// int QTextFormat::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextFormat *)cls)->type ());
}

static qt_gsi::GenericMethod *_create_f_type_c0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Method int QTextFormat::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
}


namespace gsi
{
gsi::Class<QTextFormat> decl_QTextFormat ("QTextFormat",
  gsi::Methods(_create_ctor_QTextFormat_0 ()) +
  gsi::Methods(_create_ctor_QTextFormat_767 ()) +
  gsi::Methods(_create_ctor_QTextFormat_2432 ()) +
  gsi::Methods(_create_f_background_c0 ()) +
  gsi::Methods(_create_f_boolProperty_c767 ()) +
  gsi::Methods(_create_f_brushProperty_c767 ()) +
  gsi::Methods(_create_f_clearBackground_0 ()) +
  gsi::Methods(_create_f_clearForeground_0 ()) +
  gsi::Methods(_create_f_clearProperty_767 ()) +
  gsi::Methods(_create_f_colorProperty_c767 ()) +
  gsi::Methods(_create_f_doubleProperty_c767 ()) +
  gsi::Methods(_create_f_foreground_c0 ()) +
  gsi::Methods(_create_f_hasProperty_c767 ()) +
  gsi::Methods(_create_f_intProperty_c767 ()) +
  gsi::Methods(_create_f_isBlockFormat_c0 ()) +
  gsi::Methods(_create_f_isCharFormat_c0 ()) +
  gsi::Methods(_create_f_isFrameFormat_c0 ()) +
  gsi::Methods(_create_f_isImageFormat_c0 ()) +
  gsi::Methods(_create_f_isListFormat_c0 ()) +
  gsi::Methods(_create_f_isTableCellFormat_c0 ()) +
  gsi::Methods(_create_f_isTableFormat_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_layoutDirection_c0 ()) +
  gsi::Methods(_create_f_lengthProperty_c767 ()) +
  gsi::Methods(_create_f_lengthVectorProperty_c767 ()) +
  gsi::Methods(_create_f_merge_2432 ()) +
  gsi::Methods(_create_f_objectIndex_c0 ()) +
  gsi::Methods(_create_f_objectType_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2432 ()) +
  gsi::Methods(_create_f_operator_eq__2432 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2432 ()) +
  gsi::Methods(_create_f_penProperty_c767 ()) +
  gsi::Methods(_create_f_property_c767 ()) +
  gsi::Methods(_create_f_propertyCount_c0 ()) +
  gsi::Methods(_create_f_setBackground_1910 ()) +
  gsi::Methods(_create_f_setForeground_1910 ()) +
  gsi::Methods(_create_f_setLayoutDirection_2316 ()) +
  gsi::Methods(_create_f_setObjectIndex_767 ()) +
  gsi::Methods(_create_f_setObjectType_767 ()) +
  gsi::Methods(_create_f_setProperty_2778 ()) +
  gsi::Methods(_create_f_setProperty_3914 ()) +
  gsi::Methods(_create_f_stringProperty_c767 ()) +
  gsi::Methods(_create_f_toBlockFormat_c0 ()) +
  gsi::Methods(_create_f_toCharFormat_c0 ()) +
  gsi::Methods(_create_f_toFrameFormat_c0 ()) +
  gsi::Methods(_create_f_toImageFormat_c0 ()) +
  gsi::Methods(_create_f_toListFormat_c0 ()) +
  gsi::Methods(_create_f_toTableCellFormat_c0 ()) +
  gsi::Methods(_create_f_toTableFormat_c0 ()) +
  gsi::Methods(_create_f_type_c0 ()),
  "@qt\n@brief Binding of QTextFormat");

}


//  Implementation of the enum wrapper class for QTextFormat::PageBreakFlag
namespace qt_gsi
{

static QTextFormat_PageBreakFlag_Enum *c_1_QTextFormat_PageBreakFlag_Enum () { return new QTextFormat_PageBreakFlag_Enum (QTextFormat::PageBreak_Auto); }
static QTextFormat_PageBreakFlag_Enum *c_2_QTextFormat_PageBreakFlag_Enum () { return new QTextFormat_PageBreakFlag_Enum (QTextFormat::PageBreak_AlwaysBefore); }
static QTextFormat_PageBreakFlag_Enum *c_3_QTextFormat_PageBreakFlag_Enum () { return new QTextFormat_PageBreakFlag_Enum (QTextFormat::PageBreak_AlwaysAfter); }

static gsi::Methods mkdefs_QTextFormat_PageBreakFlag () {
  return
    gsi::constant ("PageBreak_Auto", &qt_gsi::c_1_QTextFormat_PageBreakFlag_Enum, "@brief Enum constant QTextFormat::PageBreak_Auto") +
    gsi::constant ("PageBreak_AlwaysBefore", &qt_gsi::c_2_QTextFormat_PageBreakFlag_Enum, "@brief Enum constant QTextFormat::PageBreak_AlwaysBefore") +
    gsi::constant ("PageBreak_AlwaysAfter", &qt_gsi::c_3_QTextFormat_PageBreakFlag_Enum, "@brief Enum constant QTextFormat::PageBreak_AlwaysAfter");
}

static std::string to_s_QTextFormat_PageBreakFlag_Enum (const QTextFormat_PageBreakFlag_Enum *e)
{
  if (e->value () == QTextFormat::PageBreak_Auto) { return tl::sprintf ("PageBreak_Auto (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFormat::PageBreak_AlwaysBefore) { return tl::sprintf ("PageBreak_AlwaysBefore (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextFormat::PageBreak_AlwaysAfter) { return tl::sprintf ("PageBreak_AlwaysAfter (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextFormat_PageBreakFlag_Enum (const QTextFormat_PageBreakFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextFormat_PageBreakFlag_Enum *from_i_QTextFormat_PageBreakFlag_Enum (unsigned int i)
{
  return new QTextFormat_PageBreakFlag_Enum ((QTextFormat::PageBreakFlag) i);
}

static bool equalQTextFormat_PageBreakFlag_Enum (const QTextFormat_PageBreakFlag_Enum *e, QTextFormat_PageBreakFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextFormat_PageBreakFlag_Enum (const QTextFormat_PageBreakFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextFormat_PageBreakFlag_Enums oropQTextFormat_PageBreakFlag_Enums (const QTextFormat_PageBreakFlag_Enums *e, const QTextFormat_PageBreakFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextFormat_PageBreakFlag_Enums andopQTextFormat_PageBreakFlag_Enums (const QTextFormat_PageBreakFlag_Enums *e, const QTextFormat_PageBreakFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextFormat_PageBreakFlag_Enums xoropQTextFormat_PageBreakFlag_Enums (const QTextFormat_PageBreakFlag_Enums *e, const QTextFormat_PageBreakFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextFormat_PageBreakFlag_Enums (const QTextFormat_PageBreakFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextFormat::PageBreak_Auto)) { if (!l.empty ()) l += "|"; l += "PageBreak_Auto"; }
  if (e->testFlag (QTextFormat::PageBreak_AlwaysBefore)) { if (!l.empty ()) l += "|"; l += "PageBreak_AlwaysBefore"; }
  if (e->testFlag (QTextFormat::PageBreak_AlwaysAfter)) { if (!l.empty ()) l += "|"; l += "PageBreak_AlwaysAfter"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextFormat_PageBreakFlag_Enums (const QTextFormat_PageBreakFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextFormat_PageBreakFlag_Enums (const QTextFormat_PageBreakFlag_Enums *e, const QTextFormat_PageBreakFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextFormat_PageBreakFlag_Enums> decl_QTextFormat_PageBreakFlag_Enums ("QTextFormat_QFlags_PageBreakFlag",
  gsi::method_ext ("|", &qt_gsi::oropQTextFormat_PageBreakFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextFormat_PageBreakFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextFormat_PageBreakFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextFormat_PageBreakFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextFormat_PageBreakFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextFormat_PageBreakFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextFormat::PageBreakFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextFormat_PageBreakFlag_Enum> decl_QTextFormat_PageBreakFlag_Enum (decl_QTextFormat_PageBreakFlag_Enums, "QTextFormat_PageBreakFlag",
  qt_gsi::mkdefs_QTextFormat_PageBreakFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextFormat_PageBreakFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextFormat_PageBreakFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextFormat_PageBreakFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextFormat_PageBreakFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextFormat_PageBreakFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextFormat::PageBreakFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextFormat> inject_QTextFormat_PageBreakFlag_Enum_in_parent (qt_gsi::mkdefs_QTextFormat_PageBreakFlag ());
static gsi::ClassExt<QTextFormat> decl_QTextFormat_PageBreakFlag_Enum_as_child (decl_QTextFormat_PageBreakFlag_Enum, "PageBreakFlag");

}

