
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPinchGesture.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQPinchGesture_EventAdaptor.h"
#include "gsiDeclQPinchGesture_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPinchGesture

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPinchGesture::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QPointF QPinchGesture::centerPoint()


static void _init_f_centerPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_centerPoint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QPinchGesture *)cls)->centerPoint ());
}

static qt_gsi::GenericMethod *_create_f_centerPoint_c0 ()
{
  return new qt_gsi::GenericMethod (":centerPoint", "@brief Method QPointF QPinchGesture::centerPoint()\n", true, &_init_f_centerPoint_c0, &_call_f_centerPoint_c0);
}

// QFlags<QPinchGesture::ChangeFlag> QPinchGesture::changeFlags()


static void _init_f_changeFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QPinchGesture::ChangeFlag> >::target_type > ();
}

static void _call_f_changeFlags_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QPinchGesture::ChangeFlag> >::target_type > ((qt_gsi::Converter<QFlags<QPinchGesture::ChangeFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QPinchGesture::ChangeFlag> >(((QPinchGesture *)cls)->changeFlags ()));
}

static qt_gsi::GenericMethod *_create_f_changeFlags_c0 ()
{
  return new qt_gsi::GenericMethod (":changeFlags", "@brief Method QFlags<QPinchGesture::ChangeFlag> QPinchGesture::changeFlags()\n", true, &_init_f_changeFlags_c0, &_call_f_changeFlags_c0);
}

// QPointF QPinchGesture::lastCenterPoint()


static void _init_f_lastCenterPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_lastCenterPoint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QPinchGesture *)cls)->lastCenterPoint ());
}

static qt_gsi::GenericMethod *_create_f_lastCenterPoint_c0 ()
{
  return new qt_gsi::GenericMethod (":lastCenterPoint", "@brief Method QPointF QPinchGesture::lastCenterPoint()\n", true, &_init_f_lastCenterPoint_c0, &_call_f_lastCenterPoint_c0);
}

// double QPinchGesture::lastRotationAngle()


static void _init_f_lastRotationAngle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_lastRotationAngle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QPinchGesture *)cls)->lastRotationAngle ());
}

static qt_gsi::GenericMethod *_create_f_lastRotationAngle_c0 ()
{
  return new qt_gsi::GenericMethod (":lastRotationAngle", "@brief Method double QPinchGesture::lastRotationAngle()\n", true, &_init_f_lastRotationAngle_c0, &_call_f_lastRotationAngle_c0);
}

// double QPinchGesture::lastScaleFactor()


static void _init_f_lastScaleFactor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_lastScaleFactor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QPinchGesture *)cls)->lastScaleFactor ());
}

static qt_gsi::GenericMethod *_create_f_lastScaleFactor_c0 ()
{
  return new qt_gsi::GenericMethod (":lastScaleFactor", "@brief Method double QPinchGesture::lastScaleFactor()\n", true, &_init_f_lastScaleFactor_c0, &_call_f_lastScaleFactor_c0);
}

// double QPinchGesture::rotationAngle()


static void _init_f_rotationAngle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_rotationAngle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QPinchGesture *)cls)->rotationAngle ());
}

static qt_gsi::GenericMethod *_create_f_rotationAngle_c0 ()
{
  return new qt_gsi::GenericMethod (":rotationAngle", "@brief Method double QPinchGesture::rotationAngle()\n", true, &_init_f_rotationAngle_c0, &_call_f_rotationAngle_c0);
}

// double QPinchGesture::scaleFactor()


static void _init_f_scaleFactor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_scaleFactor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QPinchGesture *)cls)->scaleFactor ());
}

static qt_gsi::GenericMethod *_create_f_scaleFactor_c0 ()
{
  return new qt_gsi::GenericMethod (":scaleFactor", "@brief Method double QPinchGesture::scaleFactor()\n", true, &_init_f_scaleFactor_c0, &_call_f_scaleFactor_c0);
}

// void QPinchGesture::setCenterPoint(const QPointF &value)


static void _init_f_setCenterPoint_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCenterPoint_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QPinchGesture *)cls)->setCenterPoint (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCenterPoint_1986 ()
{
  return new qt_gsi::GenericMethod ("setCenterPoint|centerPoint=", "@brief Method void QPinchGesture::setCenterPoint(const QPointF &value)\n", false, &_init_f_setCenterPoint_1986, &_call_f_setCenterPoint_1986);
}

// void QPinchGesture::setChangeFlags(QFlags<QPinchGesture::ChangeFlag> value)


static void _init_f_setChangeFlags_3522 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const qt_gsi::Converter<QFlags<QPinchGesture::ChangeFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setChangeFlags_3522 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QPinchGesture::ChangeFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QPinchGesture::ChangeFlag> >::target_type & > ();
  ((QPinchGesture *)cls)->setChangeFlags (qt_gsi::QtToCppAdaptor<QFlags<QPinchGesture::ChangeFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setChangeFlags_3522 ()
{
  return new qt_gsi::GenericMethod ("setChangeFlags|changeFlags=", "@brief Method void QPinchGesture::setChangeFlags(QFlags<QPinchGesture::ChangeFlag> value)\n", false, &_init_f_setChangeFlags_3522, &_call_f_setChangeFlags_3522);
}

// void QPinchGesture::setLastCenterPoint(const QPointF &value)


static void _init_f_setLastCenterPoint_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLastCenterPoint_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QPinchGesture *)cls)->setLastCenterPoint (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLastCenterPoint_1986 ()
{
  return new qt_gsi::GenericMethod ("setLastCenterPoint|lastCenterPoint=", "@brief Method void QPinchGesture::setLastCenterPoint(const QPointF &value)\n", false, &_init_f_setLastCenterPoint_1986, &_call_f_setLastCenterPoint_1986);
}

// void QPinchGesture::setLastRotationAngle(double value)


static void _init_f_setLastRotationAngle_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLastRotationAngle_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QPinchGesture *)cls)->setLastRotationAngle (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLastRotationAngle_1071 ()
{
  return new qt_gsi::GenericMethod ("setLastRotationAngle|lastRotationAngle=", "@brief Method void QPinchGesture::setLastRotationAngle(double value)\n", false, &_init_f_setLastRotationAngle_1071, &_call_f_setLastRotationAngle_1071);
}

// void QPinchGesture::setLastScaleFactor(double value)


static void _init_f_setLastScaleFactor_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLastScaleFactor_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QPinchGesture *)cls)->setLastScaleFactor (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLastScaleFactor_1071 ()
{
  return new qt_gsi::GenericMethod ("setLastScaleFactor|lastScaleFactor=", "@brief Method void QPinchGesture::setLastScaleFactor(double value)\n", false, &_init_f_setLastScaleFactor_1071, &_call_f_setLastScaleFactor_1071);
}

// void QPinchGesture::setRotationAngle(double value)


static void _init_f_setRotationAngle_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRotationAngle_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QPinchGesture *)cls)->setRotationAngle (arg1);
}

static qt_gsi::GenericMethod *_create_f_setRotationAngle_1071 ()
{
  return new qt_gsi::GenericMethod ("setRotationAngle|rotationAngle=", "@brief Method void QPinchGesture::setRotationAngle(double value)\n", false, &_init_f_setRotationAngle_1071, &_call_f_setRotationAngle_1071);
}

// void QPinchGesture::setScaleFactor(double value)


static void _init_f_setScaleFactor_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScaleFactor_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QPinchGesture *)cls)->setScaleFactor (arg1);
}

static qt_gsi::GenericMethod *_create_f_setScaleFactor_1071 ()
{
  return new qt_gsi::GenericMethod ("setScaleFactor|scaleFactor=", "@brief Method void QPinchGesture::setScaleFactor(double value)\n", false, &_init_f_setScaleFactor_1071, &_call_f_setScaleFactor_1071);
}

// void QPinchGesture::setStartCenterPoint(const QPointF &value)


static void _init_f_setStartCenterPoint_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartCenterPoint_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QPinchGesture *)cls)->setStartCenterPoint (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStartCenterPoint_1986 ()
{
  return new qt_gsi::GenericMethod ("setStartCenterPoint|startCenterPoint=", "@brief Method void QPinchGesture::setStartCenterPoint(const QPointF &value)\n", false, &_init_f_setStartCenterPoint_1986, &_call_f_setStartCenterPoint_1986);
}

// void QPinchGesture::setTotalChangeFlags(QFlags<QPinchGesture::ChangeFlag> value)


static void _init_f_setTotalChangeFlags_3522 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const qt_gsi::Converter<QFlags<QPinchGesture::ChangeFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTotalChangeFlags_3522 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QPinchGesture::ChangeFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QPinchGesture::ChangeFlag> >::target_type & > ();
  ((QPinchGesture *)cls)->setTotalChangeFlags (qt_gsi::QtToCppAdaptor<QFlags<QPinchGesture::ChangeFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setTotalChangeFlags_3522 ()
{
  return new qt_gsi::GenericMethod ("setTotalChangeFlags|totalChangeFlags=", "@brief Method void QPinchGesture::setTotalChangeFlags(QFlags<QPinchGesture::ChangeFlag> value)\n", false, &_init_f_setTotalChangeFlags_3522, &_call_f_setTotalChangeFlags_3522);
}

// void QPinchGesture::setTotalRotationAngle(double value)


static void _init_f_setTotalRotationAngle_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTotalRotationAngle_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QPinchGesture *)cls)->setTotalRotationAngle (arg1);
}

static qt_gsi::GenericMethod *_create_f_setTotalRotationAngle_1071 ()
{
  return new qt_gsi::GenericMethod ("setTotalRotationAngle|totalRotationAngle=", "@brief Method void QPinchGesture::setTotalRotationAngle(double value)\n", false, &_init_f_setTotalRotationAngle_1071, &_call_f_setTotalRotationAngle_1071);
}

// void QPinchGesture::setTotalScaleFactor(double value)


static void _init_f_setTotalScaleFactor_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTotalScaleFactor_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QPinchGesture *)cls)->setTotalScaleFactor (arg1);
}

static qt_gsi::GenericMethod *_create_f_setTotalScaleFactor_1071 ()
{
  return new qt_gsi::GenericMethod ("setTotalScaleFactor|totalScaleFactor=", "@brief Method void QPinchGesture::setTotalScaleFactor(double value)\n", false, &_init_f_setTotalScaleFactor_1071, &_call_f_setTotalScaleFactor_1071);
}

// QPointF QPinchGesture::startCenterPoint()


static void _init_f_startCenterPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_startCenterPoint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QPinchGesture *)cls)->startCenterPoint ());
}

static qt_gsi::GenericMethod *_create_f_startCenterPoint_c0 ()
{
  return new qt_gsi::GenericMethod (":startCenterPoint", "@brief Method QPointF QPinchGesture::startCenterPoint()\n", true, &_init_f_startCenterPoint_c0, &_call_f_startCenterPoint_c0);
}

// QFlags<QPinchGesture::ChangeFlag> QPinchGesture::totalChangeFlags()


static void _init_f_totalChangeFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QPinchGesture::ChangeFlag> >::target_type > ();
}

static void _call_f_totalChangeFlags_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QPinchGesture::ChangeFlag> >::target_type > ((qt_gsi::Converter<QFlags<QPinchGesture::ChangeFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QPinchGesture::ChangeFlag> >(((QPinchGesture *)cls)->totalChangeFlags ()));
}

static qt_gsi::GenericMethod *_create_f_totalChangeFlags_c0 ()
{
  return new qt_gsi::GenericMethod (":totalChangeFlags", "@brief Method QFlags<QPinchGesture::ChangeFlag> QPinchGesture::totalChangeFlags()\n", true, &_init_f_totalChangeFlags_c0, &_call_f_totalChangeFlags_c0);
}

// double QPinchGesture::totalRotationAngle()


static void _init_f_totalRotationAngle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_totalRotationAngle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QPinchGesture *)cls)->totalRotationAngle ());
}

static qt_gsi::GenericMethod *_create_f_totalRotationAngle_c0 ()
{
  return new qt_gsi::GenericMethod (":totalRotationAngle", "@brief Method double QPinchGesture::totalRotationAngle()\n", true, &_init_f_totalRotationAngle_c0, &_call_f_totalRotationAngle_c0);
}

// double QPinchGesture::totalScaleFactor()


static void _init_f_totalScaleFactor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_totalScaleFactor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QPinchGesture *)cls)->totalScaleFactor ());
}

static qt_gsi::GenericMethod *_create_f_totalScaleFactor_c0 ()
{
  return new qt_gsi::GenericMethod (":totalScaleFactor", "@brief Method double QPinchGesture::totalScaleFactor()\n", true, &_init_f_totalScaleFactor_c0, &_call_f_totalScaleFactor_c0);
}

// static QString QPinchGesture::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QPinchGesture::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPinchGesture::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QPinchGesture::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QPinchGesture::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPinchGesture::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QPinchGesture::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QPinchGesture::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPinchGesture::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QPinchGesture::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QPinchGesture::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPinchGesture::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QPinchGesture, QPinchGesture_EventAdaptor> ea_QPinchGesture;

namespace gsi
{
extern gsi::Class<QGesture> decl_QGesture;

gsi::Class<QPinchGesture> decl_QPinchGesture (ea_QPinchGesture, decl_QGesture, "QPinchGesture_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_centerPoint_c0 ()) +
  gsi::Methods(_create_f_changeFlags_c0 ()) +
  gsi::Methods(_create_f_lastCenterPoint_c0 ()) +
  gsi::Methods(_create_f_lastRotationAngle_c0 ()) +
  gsi::Methods(_create_f_lastScaleFactor_c0 ()) +
  gsi::Methods(_create_f_rotationAngle_c0 ()) +
  gsi::Methods(_create_f_scaleFactor_c0 ()) +
  gsi::Methods(_create_f_setCenterPoint_1986 ()) +
  gsi::Methods(_create_f_setChangeFlags_3522 ()) +
  gsi::Methods(_create_f_setLastCenterPoint_1986 ()) +
  gsi::Methods(_create_f_setLastRotationAngle_1071 ()) +
  gsi::Methods(_create_f_setLastScaleFactor_1071 ()) +
  gsi::Methods(_create_f_setRotationAngle_1071 ()) +
  gsi::Methods(_create_f_setScaleFactor_1071 ()) +
  gsi::Methods(_create_f_setStartCenterPoint_1986 ()) +
  gsi::Methods(_create_f_setTotalChangeFlags_3522 ()) +
  gsi::Methods(_create_f_setTotalRotationAngle_1071 ()) +
  gsi::Methods(_create_f_setTotalScaleFactor_1071 ()) +
  gsi::Methods(_create_f_startCenterPoint_c0 ()) +
  gsi::Methods(_create_f_totalChangeFlags_c0 ()) +
  gsi::Methods(_create_f_totalRotationAngle_c0 ()) +
  gsi::Methods(_create_f_totalScaleFactor_c0 ()) +
  qt_gsi::qt_signal<QPinchGesture, QPinchGesture_EventAdaptor, QObject *> ("destroyed", &QPinchGesture_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QPinchGesture::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QPinchGesture");
}


class QPinchGesture_Adaptor : public QPinchGesture, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPinchGesture_Adaptor();

  //  [adaptor ctor] QPinchGesture::QPinchGesture(QObject *parent)
  QPinchGesture_Adaptor() : QPinchGesture()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPinchGesture::QPinchGesture(QObject *parent)
  QPinchGesture_Adaptor(QObject *parent) : QPinchGesture(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QPinchGesture::receivers(const char *signal)
  int fp_QPinchGesture_receivers_c1731 (const char *signal) const {
    return QPinchGesture::receivers(signal);
  }

  //  QObject *QPinchGesture::sender()
  QObject * fp_QPinchGesture_sender_c0 () const {
    return QPinchGesture::sender();
  }

  //  [adaptor impl] bool QPinchGesture::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QPinchGesture::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPinchGesture_Adaptor, bool, QEvent *>(&QPinchGesture_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QPinchGesture::event(arg1);
    }
  }

  //  [adaptor impl] bool QPinchGesture::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QPinchGesture::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPinchGesture_Adaptor, bool, QObject *, QEvent *>(&QPinchGesture_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QPinchGesture::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QPinchGesture::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QPinchGesture::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPinchGesture_Adaptor, QChildEvent *>(&QPinchGesture_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QPinchGesture::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QPinchGesture::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QPinchGesture::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPinchGesture_Adaptor, QEvent *>(&QPinchGesture_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QPinchGesture::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QPinchGesture::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QPinchGesture::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QPinchGesture_Adaptor, const char *>(&QPinchGesture_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QPinchGesture::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QPinchGesture::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QPinchGesture::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPinchGesture_Adaptor, QTimerEvent *>(&QPinchGesture_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QPinchGesture::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QPinchGesture_Adaptor::~QPinchGesture_Adaptor() { }

//  Constructor QPinchGesture::QPinchGesture(QObject *parent) (adaptor class)

static void _init_ctor_QPinchGesture_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QPinchGesture_Adaptor *> ();
}

static void _call_ctor_QPinchGesture_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QPinchGesture_Adaptor *> (new QPinchGesture_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPinchGesture_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPinchGesture::QPinchGesture(QObject *parent)\nThis method creates an object of class QPinchGesture.", &_init_ctor_QPinchGesture_Adaptor_1302, &_call_ctor_QPinchGesture_Adaptor_1302);
}

// int QPinchGesture::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QPinchGesture_Adaptor *)cls)->fp_QPinchGesture_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QPinchGesture::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QPinchGesture::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QPinchGesture_Adaptor *)cls)->fp_QPinchGesture_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QPinchGesture::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QPinchGesture::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QPinchGesture_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPinchGesture_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QPinchGesture::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QPinchGesture::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QPinchGesture_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPinchGesture_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QPinchGesture::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QPinchGesture::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QPinchGesture_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPinchGesture_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPinchGesture::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QPinchGesture::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QPinchGesture_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPinchGesture_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPinchGesture::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QPinchGesture::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QPinchGesture_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QPinchGesture_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPinchGesture::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QPinchGesture::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QPinchGesture_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPinchGesture_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPinchGesture::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QPinchGesture> decl_QPinchGesture;

gsi::Class<QPinchGesture_Adaptor> decl_QPinchGesture_Adaptor (decl_QPinchGesture, "QPinchGesture",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QPinchGesture_Adaptor_1302 ()),
  "@qt\n@brief Binding of QPinchGesture");

}


//  Implementation of the enum wrapper class for QPinchGesture::ChangeFlag
namespace qt_gsi
{

static QPinchGesture_ChangeFlag_Enum *c_1_QPinchGesture_ChangeFlag_Enum () { return new QPinchGesture_ChangeFlag_Enum (QPinchGesture::ScaleFactorChanged); }
static QPinchGesture_ChangeFlag_Enum *c_2_QPinchGesture_ChangeFlag_Enum () { return new QPinchGesture_ChangeFlag_Enum (QPinchGesture::RotationAngleChanged); }
static QPinchGesture_ChangeFlag_Enum *c_3_QPinchGesture_ChangeFlag_Enum () { return new QPinchGesture_ChangeFlag_Enum (QPinchGesture::CenterPointChanged); }

static gsi::Methods mkdefs_QPinchGesture_ChangeFlag () {
  return
    gsi::constant ("ScaleFactorChanged", &qt_gsi::c_1_QPinchGesture_ChangeFlag_Enum, "@brief Enum constant QPinchGesture::ScaleFactorChanged") +
    gsi::constant ("RotationAngleChanged", &qt_gsi::c_2_QPinchGesture_ChangeFlag_Enum, "@brief Enum constant QPinchGesture::RotationAngleChanged") +
    gsi::constant ("CenterPointChanged", &qt_gsi::c_3_QPinchGesture_ChangeFlag_Enum, "@brief Enum constant QPinchGesture::CenterPointChanged");
}

static std::string to_s_QPinchGesture_ChangeFlag_Enum (const QPinchGesture_ChangeFlag_Enum *e)
{
  if (e->value () == QPinchGesture::ScaleFactorChanged) { return tl::sprintf ("ScaleFactorChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPinchGesture::RotationAngleChanged) { return tl::sprintf ("RotationAngleChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QPinchGesture::CenterPointChanged) { return tl::sprintf ("CenterPointChanged (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QPinchGesture_ChangeFlag_Enum (const QPinchGesture_ChangeFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QPinchGesture_ChangeFlag_Enum *from_i_QPinchGesture_ChangeFlag_Enum (unsigned int i)
{
  return new QPinchGesture_ChangeFlag_Enum ((QPinchGesture::ChangeFlag) i);
}

static bool equalQPinchGesture_ChangeFlag_Enum (const QPinchGesture_ChangeFlag_Enum *e, QPinchGesture_ChangeFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QPinchGesture_ChangeFlag_Enum (const QPinchGesture_ChangeFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QPinchGesture_ChangeFlag_Enums oropQPinchGesture_ChangeFlag_Enums (const QPinchGesture_ChangeFlag_Enums *e, const QPinchGesture_ChangeFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QPinchGesture_ChangeFlag_Enums andopQPinchGesture_ChangeFlag_Enums (const QPinchGesture_ChangeFlag_Enums *e, const QPinchGesture_ChangeFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QPinchGesture_ChangeFlag_Enums xoropQPinchGesture_ChangeFlag_Enums (const QPinchGesture_ChangeFlag_Enums *e, const QPinchGesture_ChangeFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QPinchGesture_ChangeFlag_Enums (const QPinchGesture_ChangeFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QPinchGesture::ScaleFactorChanged)) { if (!l.empty ()) l += "|"; l += "ScaleFactorChanged"; }
  if (e->testFlag (QPinchGesture::RotationAngleChanged)) { if (!l.empty ()) l += "|"; l += "RotationAngleChanged"; }
  if (e->testFlag (QPinchGesture::CenterPointChanged)) { if (!l.empty ()) l += "|"; l += "CenterPointChanged"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QPinchGesture_ChangeFlag_Enums (const QPinchGesture_ChangeFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QPinchGesture_ChangeFlag_Enums (const QPinchGesture_ChangeFlag_Enums *e, const QPinchGesture_ChangeFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QPinchGesture_ChangeFlag_Enums> decl_QPinchGesture_ChangeFlag_Enums ("QPinchGesture_QFlags_ChangeFlag",
  gsi::method_ext ("|", &qt_gsi::oropQPinchGesture_ChangeFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQPinchGesture_ChangeFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQPinchGesture_ChangeFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPinchGesture_ChangeFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPinchGesture_ChangeFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QPinchGesture_ChangeFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QPinchGesture::ChangeFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QPinchGesture_ChangeFlag_Enum> decl_QPinchGesture_ChangeFlag_Enum (decl_QPinchGesture_ChangeFlag_Enums, "QPinchGesture_ChangeFlag",
  qt_gsi::mkdefs_QPinchGesture_ChangeFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QPinchGesture_ChangeFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QPinchGesture_ChangeFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQPinchGesture_ChangeFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QPinchGesture_ChangeFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QPinchGesture_ChangeFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QPinchGesture::ChangeFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QPinchGesture> inject_QPinchGesture_ChangeFlag_Enum_in_parent (qt_gsi::mkdefs_QPinchGesture_ChangeFlag ());
static gsi::ClassExt<QPinchGesture> decl_QPinchGesture_ChangeFlag_Enum_as_child (decl_QPinchGesture_ChangeFlag_Enum, "ChangeFlag");

}

