
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQLocalSocket.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQLocalSocket_EventAdaptor.h"
#include "gsiDeclQLocalSocket_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QLocalSocket

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QLocalSocket::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

//  Constructor QLocalSocket::QLocalSocket(QObject *parent)


static void _init_ctor_QLocalSocket_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QLocalSocket *> ();
}

static void _call_ctor_QLocalSocket_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QLocalSocket *> (new QLocalSocket (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLocalSocket_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocalSocket::QLocalSocket(QObject *parent)\nThis method creates an object of class QLocalSocket.", &_init_ctor_QLocalSocket_1302, &_call_ctor_QLocalSocket_1302);
}

// void QLocalSocket::abort()


static void _init_f_abort_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_abort_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QLocalSocket *)cls)->abort ();
}

static qt_gsi::GenericMethod *_create_f_abort_0 ()
{
  return new qt_gsi::GenericMethod ("abort", "@brief Method void QLocalSocket::abort()\n", false, &_init_f_abort_0, &_call_f_abort_0);
}

// qint64 QLocalSocket::bytesAvailable()


static void _init_f_bytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesAvailable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QLocalSocket *)cls)->bytesAvailable ());
}

static qt_gsi::GenericMethod *_create_f_bytesAvailable_c0 ()
{
  return new qt_gsi::GenericMethod ("bytesAvailable", "@brief Method qint64 QLocalSocket::bytesAvailable()\nThis is a reimplementation of QIODevice::bytesAvailable", true, &_init_f_bytesAvailable_c0, &_call_f_bytesAvailable_c0);
}

// qint64 QLocalSocket::bytesToWrite()


static void _init_f_bytesToWrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesToWrite_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QLocalSocket *)cls)->bytesToWrite ());
}

static qt_gsi::GenericMethod *_create_f_bytesToWrite_c0 ()
{
  return new qt_gsi::GenericMethod ("bytesToWrite", "@brief Method qint64 QLocalSocket::bytesToWrite()\nThis is a reimplementation of QIODevice::bytesToWrite", true, &_init_f_bytesToWrite_c0, &_call_f_bytesToWrite_c0);
}

// bool QLocalSocket::canReadLine()


static void _init_f_canReadLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canReadLine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLocalSocket *)cls)->canReadLine ());
}

static qt_gsi::GenericMethod *_create_f_canReadLine_c0 ()
{
  return new qt_gsi::GenericMethod ("canReadLine", "@brief Method bool QLocalSocket::canReadLine()\nThis is a reimplementation of QIODevice::canReadLine", true, &_init_f_canReadLine_c0, &_call_f_canReadLine_c0);
}

// void QLocalSocket::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QLocalSocket *)cls)->close ();
}

static qt_gsi::GenericMethod *_create_f_close_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Method void QLocalSocket::close()\nThis is a reimplementation of QIODevice::close", false, &_init_f_close_0, &_call_f_close_0);
}

// void QLocalSocket::connectToServer(const QString &name, QFlags<QIODevice::OpenModeFlag> openMode)


static void _init_f_connectToServer_5159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("openMode", true, "QIODevice::ReadWrite");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_connectToServer_5159 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::ReadWrite));
  ((QLocalSocket *)cls)->connectToServer (arg1, qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_connectToServer_5159 ()
{
  return new qt_gsi::GenericMethod ("connectToServer", "@brief Method void QLocalSocket::connectToServer(const QString &name, QFlags<QIODevice::OpenModeFlag> openMode)\n", false, &_init_f_connectToServer_5159, &_call_f_connectToServer_5159);
}

// void QLocalSocket::disconnectFromServer()


static void _init_f_disconnectFromServer_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_disconnectFromServer_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QLocalSocket *)cls)->disconnectFromServer ();
}

static qt_gsi::GenericMethod *_create_f_disconnectFromServer_0 ()
{
  return new qt_gsi::GenericMethod ("disconnectFromServer", "@brief Method void QLocalSocket::disconnectFromServer()\n", false, &_init_f_disconnectFromServer_0, &_call_f_disconnectFromServer_0);
}

// QLocalSocket::LocalSocketError QLocalSocket::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLocalSocket::LocalSocketError>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QLocalSocket::LocalSocketError>::target_type > ((qt_gsi::Converter<QLocalSocket::LocalSocketError>::target_type)qt_gsi::CppToQtAdaptor<QLocalSocket::LocalSocketError>(((QLocalSocket *)cls)->error ()));
}

static qt_gsi::GenericMethod *_create_f_error_c0 ()
{
  return new qt_gsi::GenericMethod ("error", "@brief Method QLocalSocket::LocalSocketError QLocalSocket::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
}

// bool QLocalSocket::flush()


static void _init_f_flush_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_flush_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLocalSocket *)cls)->flush ());
}

static qt_gsi::GenericMethod *_create_f_flush_0 ()
{
  return new qt_gsi::GenericMethod ("flush", "@brief Method bool QLocalSocket::flush()\n", false, &_init_f_flush_0, &_call_f_flush_0);
}

// QString QLocalSocket::fullServerName()


static void _init_f_fullServerName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fullServerName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QLocalSocket *)cls)->fullServerName ());
}

static qt_gsi::GenericMethod *_create_f_fullServerName_c0 ()
{
  return new qt_gsi::GenericMethod ("fullServerName", "@brief Method QString QLocalSocket::fullServerName()\n", true, &_init_f_fullServerName_c0, &_call_f_fullServerName_c0);
}

// bool QLocalSocket::isSequential()


static void _init_f_isSequential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSequential_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLocalSocket *)cls)->isSequential ());
}

static qt_gsi::GenericMethod *_create_f_isSequential_c0 ()
{
  return new qt_gsi::GenericMethod ("isSequential?", "@brief Method bool QLocalSocket::isSequential()\nThis is a reimplementation of QIODevice::isSequential", true, &_init_f_isSequential_c0, &_call_f_isSequential_c0);
}

// bool QLocalSocket::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLocalSocket *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QLocalSocket::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// qint64 QLocalSocket::readBufferSize()


static void _init_f_readBufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_readBufferSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QLocalSocket *)cls)->readBufferSize ());
}

static qt_gsi::GenericMethod *_create_f_readBufferSize_c0 ()
{
  return new qt_gsi::GenericMethod (":readBufferSize", "@brief Method qint64 QLocalSocket::readBufferSize()\n", true, &_init_f_readBufferSize_c0, &_call_f_readBufferSize_c0);
}

// QString QLocalSocket::serverName()


static void _init_f_serverName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_serverName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QLocalSocket *)cls)->serverName ());
}

static qt_gsi::GenericMethod *_create_f_serverName_c0 ()
{
  return new qt_gsi::GenericMethod ("serverName", "@brief Method QString QLocalSocket::serverName()\n", true, &_init_f_serverName_c0, &_call_f_serverName_c0);
}

// void QLocalSocket::setReadBufferSize(qint64 size)


static void _init_f_setReadBufferSize_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadBufferSize_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ((QLocalSocket *)cls)->setReadBufferSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setReadBufferSize_986 ()
{
  return new qt_gsi::GenericMethod ("setReadBufferSize|readBufferSize=", "@brief Method void QLocalSocket::setReadBufferSize(qint64 size)\n", false, &_init_f_setReadBufferSize_986, &_call_f_setReadBufferSize_986);
}

// bool QLocalSocket::setSocketDescriptor(quintptr socketDescriptor, QLocalSocket::LocalSocketState socketState, QFlags<QIODevice::OpenModeFlag> openMode)


static void _init_f_setSocketDescriptor_7727 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socketDescriptor");
  decl->add_arg<quintptr > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("socketState", true, "QLocalSocket::ConnectedState");
  decl->add_arg<const qt_gsi::Converter<QLocalSocket::LocalSocketState>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("openMode", true, "QIODevice::ReadWrite");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setSocketDescriptor_7727 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  quintptr arg1 = args.read<quintptr > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLocalSocket::LocalSocketState>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QLocalSocket::LocalSocketState>::target_type & > () : (const qt_gsi::Converter<QLocalSocket::LocalSocketState>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocalSocket::LocalSocketState>(heap, QLocalSocket::ConnectedState));
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::ReadWrite));
  ret.write<bool > ((bool)((QLocalSocket *)cls)->setSocketDescriptor (arg1, qt_gsi::QtToCppAdaptor<QLocalSocket::LocalSocketState>(arg2).cref(), qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_setSocketDescriptor_7727 ()
{
  return new qt_gsi::GenericMethod ("setSocketDescriptor", "@brief Method bool QLocalSocket::setSocketDescriptor(quintptr socketDescriptor, QLocalSocket::LocalSocketState socketState, QFlags<QIODevice::OpenModeFlag> openMode)\n", false, &_init_f_setSocketDescriptor_7727, &_call_f_setSocketDescriptor_7727);
}

// quintptr QLocalSocket::socketDescriptor()


static void _init_f_socketDescriptor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quintptr > ();
}

static void _call_f_socketDescriptor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<quintptr > ((quintptr)((QLocalSocket *)cls)->socketDescriptor ());
}

static qt_gsi::GenericMethod *_create_f_socketDescriptor_c0 ()
{
  return new qt_gsi::GenericMethod ("socketDescriptor", "@brief Method quintptr QLocalSocket::socketDescriptor()\n", true, &_init_f_socketDescriptor_c0, &_call_f_socketDescriptor_c0);
}

// QLocalSocket::LocalSocketState QLocalSocket::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLocalSocket::LocalSocketState>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QLocalSocket::LocalSocketState>::target_type > ((qt_gsi::Converter<QLocalSocket::LocalSocketState>::target_type)qt_gsi::CppToQtAdaptor<QLocalSocket::LocalSocketState>(((QLocalSocket *)cls)->state ()));
}

static qt_gsi::GenericMethod *_create_f_state_c0 ()
{
  return new qt_gsi::GenericMethod ("state", "@brief Method QLocalSocket::LocalSocketState QLocalSocket::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
}

// bool QLocalSocket::waitForBytesWritten(int msecs)


static void _init_f_waitForBytesWritten_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForBytesWritten_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QLocalSocket *)cls)->waitForBytesWritten (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForBytesWritten_767 ()
{
  return new qt_gsi::GenericMethod ("waitForBytesWritten", "@brief Method bool QLocalSocket::waitForBytesWritten(int msecs)\nThis is a reimplementation of QIODevice::waitForBytesWritten", false, &_init_f_waitForBytesWritten_767, &_call_f_waitForBytesWritten_767);
}

// bool QLocalSocket::waitForConnected(int msecs)


static void _init_f_waitForConnected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForConnected_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QLocalSocket *)cls)->waitForConnected (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForConnected_767 ()
{
  return new qt_gsi::GenericMethod ("waitForConnected", "@brief Method bool QLocalSocket::waitForConnected(int msecs)\n", false, &_init_f_waitForConnected_767, &_call_f_waitForConnected_767);
}

// bool QLocalSocket::waitForDisconnected(int msecs)


static void _init_f_waitForDisconnected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForDisconnected_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QLocalSocket *)cls)->waitForDisconnected (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForDisconnected_767 ()
{
  return new qt_gsi::GenericMethod ("waitForDisconnected", "@brief Method bool QLocalSocket::waitForDisconnected(int msecs)\n", false, &_init_f_waitForDisconnected_767, &_call_f_waitForDisconnected_767);
}

// bool QLocalSocket::waitForReadyRead(int msecs)


static void _init_f_waitForReadyRead_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForReadyRead_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QLocalSocket *)cls)->waitForReadyRead (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForReadyRead_767 ()
{
  return new qt_gsi::GenericMethod ("waitForReadyRead", "@brief Method bool QLocalSocket::waitForReadyRead(int msecs)\nThis is a reimplementation of QIODevice::waitForReadyRead", false, &_init_f_waitForReadyRead_767, &_call_f_waitForReadyRead_767);
}

// static QString QLocalSocket::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QLocalSocket::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QLocalSocket::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QLocalSocket::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QLocalSocket::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QLocalSocket::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QLocalSocket::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QLocalSocket::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QLocalSocket::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QLocalSocket::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QLocalSocket::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QLocalSocket::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QLocalSocket, QLocalSocket_EventAdaptor> ea_QLocalSocket;


namespace gsi
{
extern gsi::Class<QIODevice> decl_QIODevice;

gsi::Class<QLocalSocket> decl_QLocalSocket (ea_QLocalSocket, decl_QIODevice, "QLocalSocket",
  gsi::Methods(_create_ctor_QLocalSocket_1302 ()) +
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_abort_0 ()) +
  gsi::Methods(_create_f_bytesAvailable_c0 ()) +
  gsi::Methods(_create_f_bytesToWrite_c0 ()) +
  gsi::Methods(_create_f_canReadLine_c0 ()) +
  gsi::Methods(_create_f_close_0 ()) +
  gsi::Methods(_create_f_connectToServer_5159 ()) +
  gsi::Methods(_create_f_disconnectFromServer_0 ()) +
  gsi::Methods(_create_f_error_c0 ()) +
  gsi::Methods(_create_f_flush_0 ()) +
  gsi::Methods(_create_f_fullServerName_c0 ()) +
  gsi::Methods(_create_f_isSequential_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_readBufferSize_c0 ()) +
  gsi::Methods(_create_f_serverName_c0 ()) +
  gsi::Methods(_create_f_setReadBufferSize_986 ()) +
  gsi::Methods(_create_f_setSocketDescriptor_7727 ()) +
  gsi::Methods(_create_f_socketDescriptor_c0 ()) +
  gsi::Methods(_create_f_state_c0 ()) +
  gsi::Methods(_create_f_waitForBytesWritten_767 ()) +
  gsi::Methods(_create_f_waitForConnected_767 ()) +
  gsi::Methods(_create_f_waitForDisconnected_767 ()) +
  gsi::Methods(_create_f_waitForReadyRead_767 ()) +
  qt_gsi::qt_signal<QLocalSocket, QLocalSocket_EventAdaptor> ("aboutToClose", &QLocalSocket_EventAdaptor::aboutToClose_e_0, "@brief Signal declaration for QLocalSocket::aboutToClose()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QLocalSocket, QLocalSocket_EventAdaptor, qint64> ("bytesWritten", &QLocalSocket_EventAdaptor::bytesWritten_e_986, gsi::arg("bytes"), "@brief Signal declaration for QLocalSocket::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QLocalSocket, QLocalSocket_EventAdaptor> ("connected", &QLocalSocket_EventAdaptor::connected_e_0, "@brief Signal declaration for QLocalSocket::connected()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QLocalSocket, QLocalSocket_EventAdaptor, QObject *> ("destroyed", &QLocalSocket_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QLocalSocket::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QLocalSocket, QLocalSocket_EventAdaptor> ("disconnected", &QLocalSocket_EventAdaptor::disconnected_e_0, "@brief Signal declaration for QLocalSocket::disconnected()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QLocalSocket, QLocalSocket_EventAdaptor, const qt_gsi::Converter<QLocalSocket::LocalSocketError>::target_type &> ("error", &QLocalSocket_EventAdaptor::error_e_3371, gsi::arg("socketError"), "@brief Signal declaration for QLocalSocket::error(QLocalSocket::LocalSocketError socketError)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QLocalSocket, QLocalSocket_EventAdaptor> ("readChannelFinished", &QLocalSocket_EventAdaptor::readChannelFinished_e_0, "@brief Signal declaration for QLocalSocket::readChannelFinished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QLocalSocket, QLocalSocket_EventAdaptor> ("readyRead", &QLocalSocket_EventAdaptor::readyRead_e_0, "@brief Signal declaration for QLocalSocket::readyRead()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QLocalSocket, QLocalSocket_EventAdaptor, const qt_gsi::Converter<QLocalSocket::LocalSocketState>::target_type &> ("stateChanged", &QLocalSocket_EventAdaptor::stateChanged_e_3362, gsi::arg("socketState"), "@brief Signal declaration for QLocalSocket::stateChanged(QLocalSocket::LocalSocketState socketState)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@qt\n@brief Binding of QLocalSocket");

}


//  Implementation of the enum wrapper class for QLocalSocket::LocalSocketError
namespace qt_gsi
{

static QLocalSocket_LocalSocketError_Enum *c_1_QLocalSocket_LocalSocketError_Enum () { return new QLocalSocket_LocalSocketError_Enum (QLocalSocket::ConnectionRefusedError); }
static QLocalSocket_LocalSocketError_Enum *c_2_QLocalSocket_LocalSocketError_Enum () { return new QLocalSocket_LocalSocketError_Enum (QLocalSocket::PeerClosedError); }
static QLocalSocket_LocalSocketError_Enum *c_3_QLocalSocket_LocalSocketError_Enum () { return new QLocalSocket_LocalSocketError_Enum (QLocalSocket::ServerNotFoundError); }
static QLocalSocket_LocalSocketError_Enum *c_4_QLocalSocket_LocalSocketError_Enum () { return new QLocalSocket_LocalSocketError_Enum (QLocalSocket::SocketAccessError); }
static QLocalSocket_LocalSocketError_Enum *c_5_QLocalSocket_LocalSocketError_Enum () { return new QLocalSocket_LocalSocketError_Enum (QLocalSocket::SocketResourceError); }
static QLocalSocket_LocalSocketError_Enum *c_6_QLocalSocket_LocalSocketError_Enum () { return new QLocalSocket_LocalSocketError_Enum (QLocalSocket::SocketTimeoutError); }
static QLocalSocket_LocalSocketError_Enum *c_7_QLocalSocket_LocalSocketError_Enum () { return new QLocalSocket_LocalSocketError_Enum (QLocalSocket::DatagramTooLargeError); }
static QLocalSocket_LocalSocketError_Enum *c_8_QLocalSocket_LocalSocketError_Enum () { return new QLocalSocket_LocalSocketError_Enum (QLocalSocket::ConnectionError); }
static QLocalSocket_LocalSocketError_Enum *c_9_QLocalSocket_LocalSocketError_Enum () { return new QLocalSocket_LocalSocketError_Enum (QLocalSocket::UnsupportedSocketOperationError); }
static QLocalSocket_LocalSocketError_Enum *c_10_QLocalSocket_LocalSocketError_Enum () { return new QLocalSocket_LocalSocketError_Enum (QLocalSocket::UnknownSocketError); }

static gsi::Methods mkdefs_QLocalSocket_LocalSocketError () {
  return
    gsi::constant ("ConnectionRefusedError", &qt_gsi::c_1_QLocalSocket_LocalSocketError_Enum, "@brief Enum constant QLocalSocket::ConnectionRefusedError") +
    gsi::constant ("PeerClosedError", &qt_gsi::c_2_QLocalSocket_LocalSocketError_Enum, "@brief Enum constant QLocalSocket::PeerClosedError") +
    gsi::constant ("ServerNotFoundError", &qt_gsi::c_3_QLocalSocket_LocalSocketError_Enum, "@brief Enum constant QLocalSocket::ServerNotFoundError") +
    gsi::constant ("SocketAccessError", &qt_gsi::c_4_QLocalSocket_LocalSocketError_Enum, "@brief Enum constant QLocalSocket::SocketAccessError") +
    gsi::constant ("SocketResourceError", &qt_gsi::c_5_QLocalSocket_LocalSocketError_Enum, "@brief Enum constant QLocalSocket::SocketResourceError") +
    gsi::constant ("SocketTimeoutError", &qt_gsi::c_6_QLocalSocket_LocalSocketError_Enum, "@brief Enum constant QLocalSocket::SocketTimeoutError") +
    gsi::constant ("DatagramTooLargeError", &qt_gsi::c_7_QLocalSocket_LocalSocketError_Enum, "@brief Enum constant QLocalSocket::DatagramTooLargeError") +
    gsi::constant ("ConnectionError", &qt_gsi::c_8_QLocalSocket_LocalSocketError_Enum, "@brief Enum constant QLocalSocket::ConnectionError") +
    gsi::constant ("UnsupportedSocketOperationError", &qt_gsi::c_9_QLocalSocket_LocalSocketError_Enum, "@brief Enum constant QLocalSocket::UnsupportedSocketOperationError") +
    gsi::constant ("UnknownSocketError", &qt_gsi::c_10_QLocalSocket_LocalSocketError_Enum, "@brief Enum constant QLocalSocket::UnknownSocketError");
}

static std::string to_s_QLocalSocket_LocalSocketError_Enum (const QLocalSocket_LocalSocketError_Enum *e)
{
  if (e->value () == QLocalSocket::ConnectionRefusedError) { return tl::sprintf ("ConnectionRefusedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocalSocket::PeerClosedError) { return tl::sprintf ("PeerClosedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocalSocket::ServerNotFoundError) { return tl::sprintf ("ServerNotFoundError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocalSocket::SocketAccessError) { return tl::sprintf ("SocketAccessError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocalSocket::SocketResourceError) { return tl::sprintf ("SocketResourceError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocalSocket::SocketTimeoutError) { return tl::sprintf ("SocketTimeoutError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocalSocket::DatagramTooLargeError) { return tl::sprintf ("DatagramTooLargeError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocalSocket::ConnectionError) { return tl::sprintf ("ConnectionError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocalSocket::UnsupportedSocketOperationError) { return tl::sprintf ("UnsupportedSocketOperationError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocalSocket::UnknownSocketError) { return tl::sprintf ("UnknownSocketError (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QLocalSocket_LocalSocketError_Enum (const QLocalSocket_LocalSocketError_Enum *e)
{
  return (unsigned int) e->value ();
}

static QLocalSocket_LocalSocketError_Enum *from_i_QLocalSocket_LocalSocketError_Enum (unsigned int i)
{
  return new QLocalSocket_LocalSocketError_Enum ((QLocalSocket::LocalSocketError) i);
}

static bool equalQLocalSocket_LocalSocketError_Enum (const QLocalSocket_LocalSocketError_Enum *e, QLocalSocket_LocalSocketError_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QLocalSocket_LocalSocketError_Enum (const QLocalSocket_LocalSocketError_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QLocalSocket_LocalSocketError_Enums oropQLocalSocket_LocalSocketError_Enums (const QLocalSocket_LocalSocketError_Enums *e, const QLocalSocket_LocalSocketError_Enums &d)
{
  return e->flags () | d.flags ();
}

static QLocalSocket_LocalSocketError_Enums andopQLocalSocket_LocalSocketError_Enums (const QLocalSocket_LocalSocketError_Enums *e, const QLocalSocket_LocalSocketError_Enums &d)
{
  return e->flags () & d.flags ();
}

static QLocalSocket_LocalSocketError_Enums xoropQLocalSocket_LocalSocketError_Enums (const QLocalSocket_LocalSocketError_Enums *e, const QLocalSocket_LocalSocketError_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QLocalSocket_LocalSocketError_Enums (const QLocalSocket_LocalSocketError_Enums *e)
{
  std::string l;
  if (e->testFlag (QLocalSocket::ConnectionRefusedError)) { if (!l.empty ()) l += "|"; l += "ConnectionRefusedError"; }
  if (e->testFlag (QLocalSocket::PeerClosedError)) { if (!l.empty ()) l += "|"; l += "PeerClosedError"; }
  if (e->testFlag (QLocalSocket::ServerNotFoundError)) { if (!l.empty ()) l += "|"; l += "ServerNotFoundError"; }
  if (e->testFlag (QLocalSocket::SocketAccessError)) { if (!l.empty ()) l += "|"; l += "SocketAccessError"; }
  if (e->testFlag (QLocalSocket::SocketResourceError)) { if (!l.empty ()) l += "|"; l += "SocketResourceError"; }
  if (e->testFlag (QLocalSocket::SocketTimeoutError)) { if (!l.empty ()) l += "|"; l += "SocketTimeoutError"; }
  if (e->testFlag (QLocalSocket::DatagramTooLargeError)) { if (!l.empty ()) l += "|"; l += "DatagramTooLargeError"; }
  if (e->testFlag (QLocalSocket::ConnectionError)) { if (!l.empty ()) l += "|"; l += "ConnectionError"; }
  if (e->testFlag (QLocalSocket::UnsupportedSocketOperationError)) { if (!l.empty ()) l += "|"; l += "UnsupportedSocketOperationError"; }
  if (e->testFlag (QLocalSocket::UnknownSocketError)) { if (!l.empty ()) l += "|"; l += "UnknownSocketError"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QLocalSocket_LocalSocketError_Enums (const QLocalSocket_LocalSocketError_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QLocalSocket_LocalSocketError_Enums (const QLocalSocket_LocalSocketError_Enums *e, const QLocalSocket_LocalSocketError_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QLocalSocket_LocalSocketError_Enums> decl_QLocalSocket_LocalSocketError_Enums ("QLocalSocket_QFlags_LocalSocketError",
  gsi::method_ext ("|", &qt_gsi::oropQLocalSocket_LocalSocketError_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQLocalSocket_LocalSocketError_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQLocalSocket_LocalSocketError_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocalSocket_LocalSocketError_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocalSocket_LocalSocketError_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QLocalSocket_LocalSocketError_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QLocalSocket::LocalSocketError> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QLocalSocket_LocalSocketError_Enum> decl_QLocalSocket_LocalSocketError_Enum (decl_QLocalSocket_LocalSocketError_Enums, "QLocalSocket_LocalSocketError",
  qt_gsi::mkdefs_QLocalSocket_LocalSocketError () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocalSocket_LocalSocketError_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocalSocket_LocalSocketError_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQLocalSocket_LocalSocketError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QLocalSocket_LocalSocketError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QLocalSocket_LocalSocketError_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QLocalSocket::LocalSocketError enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocalSocket> inject_QLocalSocket_LocalSocketError_Enum_in_parent (qt_gsi::mkdefs_QLocalSocket_LocalSocketError ());
static gsi::ClassExt<QLocalSocket> decl_QLocalSocket_LocalSocketError_Enum_as_child (decl_QLocalSocket_LocalSocketError_Enum, "LocalSocketError");

}


//  Implementation of the enum wrapper class for QLocalSocket::LocalSocketState
namespace qt_gsi
{

static QLocalSocket_LocalSocketState_Enum *c_1_QLocalSocket_LocalSocketState_Enum () { return new QLocalSocket_LocalSocketState_Enum (QLocalSocket::UnconnectedState); }
static QLocalSocket_LocalSocketState_Enum *c_2_QLocalSocket_LocalSocketState_Enum () { return new QLocalSocket_LocalSocketState_Enum (QLocalSocket::ConnectingState); }
static QLocalSocket_LocalSocketState_Enum *c_3_QLocalSocket_LocalSocketState_Enum () { return new QLocalSocket_LocalSocketState_Enum (QLocalSocket::ConnectedState); }
static QLocalSocket_LocalSocketState_Enum *c_4_QLocalSocket_LocalSocketState_Enum () { return new QLocalSocket_LocalSocketState_Enum (QLocalSocket::ClosingState); }

static gsi::Methods mkdefs_QLocalSocket_LocalSocketState () {
  return
    gsi::constant ("UnconnectedState", &qt_gsi::c_1_QLocalSocket_LocalSocketState_Enum, "@brief Enum constant QLocalSocket::UnconnectedState") +
    gsi::constant ("ConnectingState", &qt_gsi::c_2_QLocalSocket_LocalSocketState_Enum, "@brief Enum constant QLocalSocket::ConnectingState") +
    gsi::constant ("ConnectedState", &qt_gsi::c_3_QLocalSocket_LocalSocketState_Enum, "@brief Enum constant QLocalSocket::ConnectedState") +
    gsi::constant ("ClosingState", &qt_gsi::c_4_QLocalSocket_LocalSocketState_Enum, "@brief Enum constant QLocalSocket::ClosingState");
}

static std::string to_s_QLocalSocket_LocalSocketState_Enum (const QLocalSocket_LocalSocketState_Enum *e)
{
  if (e->value () == QLocalSocket::UnconnectedState) { return tl::sprintf ("UnconnectedState (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocalSocket::ConnectingState) { return tl::sprintf ("ConnectingState (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocalSocket::ConnectedState) { return tl::sprintf ("ConnectedState (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocalSocket::ClosingState) { return tl::sprintf ("ClosingState (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QLocalSocket_LocalSocketState_Enum (const QLocalSocket_LocalSocketState_Enum *e)
{
  return (unsigned int) e->value ();
}

static QLocalSocket_LocalSocketState_Enum *from_i_QLocalSocket_LocalSocketState_Enum (unsigned int i)
{
  return new QLocalSocket_LocalSocketState_Enum ((QLocalSocket::LocalSocketState) i);
}

static bool equalQLocalSocket_LocalSocketState_Enum (const QLocalSocket_LocalSocketState_Enum *e, QLocalSocket_LocalSocketState_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QLocalSocket_LocalSocketState_Enum (const QLocalSocket_LocalSocketState_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QLocalSocket_LocalSocketState_Enums oropQLocalSocket_LocalSocketState_Enums (const QLocalSocket_LocalSocketState_Enums *e, const QLocalSocket_LocalSocketState_Enums &d)
{
  return e->flags () | d.flags ();
}

static QLocalSocket_LocalSocketState_Enums andopQLocalSocket_LocalSocketState_Enums (const QLocalSocket_LocalSocketState_Enums *e, const QLocalSocket_LocalSocketState_Enums &d)
{
  return e->flags () & d.flags ();
}

static QLocalSocket_LocalSocketState_Enums xoropQLocalSocket_LocalSocketState_Enums (const QLocalSocket_LocalSocketState_Enums *e, const QLocalSocket_LocalSocketState_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QLocalSocket_LocalSocketState_Enums (const QLocalSocket_LocalSocketState_Enums *e)
{
  std::string l;
  if (e->testFlag (QLocalSocket::UnconnectedState)) { if (!l.empty ()) l += "|"; l += "UnconnectedState"; }
  if (e->testFlag (QLocalSocket::ConnectingState)) { if (!l.empty ()) l += "|"; l += "ConnectingState"; }
  if (e->testFlag (QLocalSocket::ConnectedState)) { if (!l.empty ()) l += "|"; l += "ConnectedState"; }
  if (e->testFlag (QLocalSocket::ClosingState)) { if (!l.empty ()) l += "|"; l += "ClosingState"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QLocalSocket_LocalSocketState_Enums (const QLocalSocket_LocalSocketState_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QLocalSocket_LocalSocketState_Enums (const QLocalSocket_LocalSocketState_Enums *e, const QLocalSocket_LocalSocketState_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QLocalSocket_LocalSocketState_Enums> decl_QLocalSocket_LocalSocketState_Enums ("QLocalSocket_QFlags_LocalSocketState",
  gsi::method_ext ("|", &qt_gsi::oropQLocalSocket_LocalSocketState_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQLocalSocket_LocalSocketState_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQLocalSocket_LocalSocketState_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocalSocket_LocalSocketState_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocalSocket_LocalSocketState_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QLocalSocket_LocalSocketState_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QLocalSocket::LocalSocketState> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QLocalSocket_LocalSocketState_Enum> decl_QLocalSocket_LocalSocketState_Enum (decl_QLocalSocket_LocalSocketState_Enums, "QLocalSocket_LocalSocketState",
  qt_gsi::mkdefs_QLocalSocket_LocalSocketState () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocalSocket_LocalSocketState_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocalSocket_LocalSocketState_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQLocalSocket_LocalSocketState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QLocalSocket_LocalSocketState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QLocalSocket_LocalSocketState_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QLocalSocket::LocalSocketState enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocalSocket> inject_QLocalSocket_LocalSocketState_Enum_in_parent (qt_gsi::mkdefs_QLocalSocket_LocalSocketState ());
static gsi::ClassExt<QLocalSocket> decl_QLocalSocket_LocalSocketState_Enum_as_child (decl_QLocalSocket_LocalSocketState_Enum, "LocalSocketState");

}

