
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQListWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQListWidget_EventAdaptor.h"
#include "gsiDeclQListWidget_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QListWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QListWidget::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QListWidget::addItem(const QString &label)


static void _init_f_addItem_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItem_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QListWidget *)cls)->addItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_addItem_2025 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Method void QListWidget::addItem(const QString &label)\n", false, &_init_f_addItem_2025, &_call_f_addItem_2025);
}

// void QListWidget::addItem(QListWidgetItem *item)


static void _init_f_addItem_2126 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QListWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItem_2126 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QListWidgetItem *arg1 = args.read<QListWidgetItem * > ();
  qt_gsi::qt_keep (arg1);
  ((QListWidget *)cls)->addItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_addItem_2126 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Method void QListWidget::addItem(QListWidgetItem *item)\n", false, &_init_f_addItem_2126, &_call_f_addItem_2126);
}

// void QListWidget::addItems(const QStringList &labels)


static void _init_f_addItems_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("labels");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItems_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QListWidget *)cls)->addItems (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_addItems_2437 ()
{
  return new qt_gsi::GenericMethod ("addItems", "@brief Method void QListWidget::addItems(const QStringList &labels)\n", false, &_init_f_addItems_2437, &_call_f_addItems_2437);
}

// void QListWidget::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QListWidget::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// void QListWidget::closePersistentEditor(QListWidgetItem *item)


static void _init_f_closePersistentEditor_2126 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QListWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_closePersistentEditor_2126 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QListWidgetItem *arg1 = args.read<QListWidgetItem * > ();
  ((QListWidget *)cls)->closePersistentEditor (arg1);
}

static qt_gsi::GenericMethod *_create_f_closePersistentEditor_2126 ()
{
  return new qt_gsi::GenericMethod ("closePersistentEditor", "@brief Method void QListWidget::closePersistentEditor(QListWidgetItem *item)\n", false, &_init_f_closePersistentEditor_2126, &_call_f_closePersistentEditor_2126);
}

// int QListWidget::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QListWidget *)cls)->count ());
}

static qt_gsi::GenericMethod *_create_f_count_c0 ()
{
  return new qt_gsi::GenericMethod (":count", "@brief Method int QListWidget::count()\n", true, &_init_f_count_c0, &_call_f_count_c0);
}

// QListWidgetItem *QListWidget::currentItem()


static void _init_f_currentItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QListWidgetItem * > ();
}

static void _call_f_currentItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QListWidgetItem * > ((QListWidgetItem *)((QListWidget *)cls)->currentItem ());
}

static qt_gsi::GenericMethod *_create_f_currentItem_c0 ()
{
  return new qt_gsi::GenericMethod (":currentItem", "@brief Method QListWidgetItem *QListWidget::currentItem()\n", true, &_init_f_currentItem_c0, &_call_f_currentItem_c0);
}

// int QListWidget::currentRow()


static void _init_f_currentRow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentRow_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QListWidget *)cls)->currentRow ());
}

static qt_gsi::GenericMethod *_create_f_currentRow_c0 ()
{
  return new qt_gsi::GenericMethod (":currentRow", "@brief Method int QListWidget::currentRow()\n", true, &_init_f_currentRow_c0, &_call_f_currentRow_c0);
}

// void QListWidget::dropEvent(QDropEvent *event)


static void _init_f_dropEvent_1622 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_dropEvent_1622 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QListWidget *)cls)->dropEvent (arg1);
}

static qt_gsi::GenericMethod *_create_f_dropEvent_1622 ()
{
  return new qt_gsi::GenericMethod ("dropEvent", "@brief Method void QListWidget::dropEvent(QDropEvent *event)\nThis is a reimplementation of QListView::dropEvent", false, &_init_f_dropEvent_1622, &_call_f_dropEvent_1622);
}

// void QListWidget::editItem(QListWidgetItem *item)


static void _init_f_editItem_2126 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QListWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_editItem_2126 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QListWidgetItem *arg1 = args.read<QListWidgetItem * > ();
  ((QListWidget *)cls)->editItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_editItem_2126 ()
{
  return new qt_gsi::GenericMethod ("editItem", "@brief Method void QListWidget::editItem(QListWidgetItem *item)\n", false, &_init_f_editItem_2126, &_call_f_editItem_2126);
}

// QList<QListWidgetItem *> QListWidget::findItems(const QString &text, QFlags<Qt::MatchFlag> flags)


static void _init_f_findItems_c4233 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<QListWidgetItem *> >::target_type > ();
}

static void _call_f_findItems_c4233 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > ();
  ret.write<qt_gsi::Converter<QList<QListWidgetItem *> >::target_type > ((qt_gsi::Converter<QList<QListWidgetItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QListWidgetItem *> >(((QListWidget *)cls)->findItems (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::MatchFlag> >(arg2).cref())));
}

static qt_gsi::GenericMethod *_create_f_findItems_c4233 ()
{
  return new qt_gsi::GenericMethod ("findItems", "@brief Method QList<QListWidgetItem *> QListWidget::findItems(const QString &text, QFlags<Qt::MatchFlag> flags)\n", true, &_init_f_findItems_c4233, &_call_f_findItems_c4233);
}

// void QListWidget::insertItem(int row, QListWidgetItem *item)


static void _init_f_insertItem_2785 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("item");
  decl->add_arg<QListWidgetItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertItem_2785 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QListWidgetItem *arg2 = args.read<QListWidgetItem * > ();
  qt_gsi::qt_keep (arg2);
  ((QListWidget *)cls)->insertItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertItem_2785 ()
{
  return new qt_gsi::GenericMethod ("insertItem", "@brief Method void QListWidget::insertItem(int row, QListWidgetItem *item)\n", false, &_init_f_insertItem_2785, &_call_f_insertItem_2785);
}

// void QListWidget::insertItem(int row, const QString &label)


static void _init_f_insertItem_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("label");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertItem_2684 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QListWidget *)cls)->insertItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertItem_2684 ()
{
  return new qt_gsi::GenericMethod ("insertItem", "@brief Method void QListWidget::insertItem(int row, const QString &label)\n", false, &_init_f_insertItem_2684, &_call_f_insertItem_2684);
}

// void QListWidget::insertItems(int row, const QStringList &labels)


static void _init_f_insertItems_3096 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("labels");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertItems_3096 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QStringList>::target_type & arg2 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QListWidget *)cls)->insertItems (arg1, qt_gsi::QtToCppAdaptor<QStringList>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_insertItems_3096 ()
{
  return new qt_gsi::GenericMethod ("insertItems", "@brief Method void QListWidget::insertItems(int row, const QStringList &labels)\n", false, &_init_f_insertItems_3096, &_call_f_insertItems_3096);
}

// bool QListWidget::isItemHidden(const QListWidgetItem *item)


static void _init_f_isItemHidden_c2821 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QListWidgetItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isItemHidden_c2821 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QListWidgetItem *arg1 = args.read<const QListWidgetItem * > ();
  ret.write<bool > ((bool)((QListWidget *)cls)->isItemHidden (arg1));
}

static qt_gsi::GenericMethod *_create_f_isItemHidden_c2821 ()
{
  return new qt_gsi::GenericMethod ("isItemHidden?", "@brief Method bool QListWidget::isItemHidden(const QListWidgetItem *item)\n", true, &_init_f_isItemHidden_c2821, &_call_f_isItemHidden_c2821);
}

// bool QListWidget::isItemSelected(const QListWidgetItem *item)


static void _init_f_isItemSelected_c2821 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QListWidgetItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isItemSelected_c2821 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QListWidgetItem *arg1 = args.read<const QListWidgetItem * > ();
  ret.write<bool > ((bool)((QListWidget *)cls)->isItemSelected (arg1));
}

static qt_gsi::GenericMethod *_create_f_isItemSelected_c2821 ()
{
  return new qt_gsi::GenericMethod ("isItemSelected?", "@brief Method bool QListWidget::isItemSelected(const QListWidgetItem *item)\n", true, &_init_f_isItemSelected_c2821, &_call_f_isItemSelected_c2821);
}

// bool QListWidget::isSortingEnabled()


static void _init_f_isSortingEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSortingEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QListWidget *)cls)->isSortingEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isSortingEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isSortingEnabled?|:sortingEnabled", "@brief Method bool QListWidget::isSortingEnabled()\n", true, &_init_f_isSortingEnabled_c0, &_call_f_isSortingEnabled_c0);
}

// QListWidgetItem *QListWidget::item(int row)


static void _init_f_item_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QListWidgetItem * > ();
}

static void _call_f_item_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QListWidgetItem * > ((QListWidgetItem *)((QListWidget *)cls)->item (arg1));
}

static qt_gsi::GenericMethod *_create_f_item_c767 ()
{
  return new qt_gsi::GenericMethod ("item", "@brief Method QListWidgetItem *QListWidget::item(int row)\n", true, &_init_f_item_c767, &_call_f_item_c767);
}

// QListWidgetItem *QListWidget::itemAt(const QPoint &p)


static void _init_f_itemAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QListWidgetItem * > ();
}

static void _call_f_itemAt_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QListWidgetItem * > ((QListWidgetItem *)((QListWidget *)cls)->itemAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c1916 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QListWidgetItem *QListWidget::itemAt(const QPoint &p)\n", true, &_init_f_itemAt_c1916, &_call_f_itemAt_c1916);
}

// QListWidgetItem *QListWidget::itemAt(int x, int y)


static void _init_f_itemAt_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QListWidgetItem * > ();
}

static void _call_f_itemAt_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QListWidgetItem * > ((QListWidgetItem *)((QListWidget *)cls)->itemAt (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c1426 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QListWidgetItem *QListWidget::itemAt(int x, int y)\n", true, &_init_f_itemAt_c1426, &_call_f_itemAt_c1426);
}

// QWidget *QListWidget::itemWidget(QListWidgetItem *item)


static void _init_f_itemWidget_c2126 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QListWidgetItem * > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_itemWidget_c2126 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QListWidgetItem *arg1 = args.read<QListWidgetItem * > ();
  ret.write<QWidget * > ((QWidget *)((QListWidget *)cls)->itemWidget (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemWidget_c2126 ()
{
  return new qt_gsi::GenericMethod ("itemWidget", "@brief Method QWidget *QListWidget::itemWidget(QListWidgetItem *item)\n", true, &_init_f_itemWidget_c2126, &_call_f_itemWidget_c2126);
}

// void QListWidget::openPersistentEditor(QListWidgetItem *item)


static void _init_f_openPersistentEditor_2126 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QListWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_openPersistentEditor_2126 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QListWidgetItem *arg1 = args.read<QListWidgetItem * > ();
  ((QListWidget *)cls)->openPersistentEditor (arg1);
}

static qt_gsi::GenericMethod *_create_f_openPersistentEditor_2126 ()
{
  return new qt_gsi::GenericMethod ("openPersistentEditor", "@brief Method void QListWidget::openPersistentEditor(QListWidgetItem *item)\n", false, &_init_f_openPersistentEditor_2126, &_call_f_openPersistentEditor_2126);
}

// void QListWidget::removeItemWidget(QListWidgetItem *item)


static void _init_f_removeItemWidget_2126 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QListWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeItemWidget_2126 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QListWidgetItem *arg1 = args.read<QListWidgetItem * > ();
  ((QListWidget *)cls)->removeItemWidget (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeItemWidget_2126 ()
{
  return new qt_gsi::GenericMethod ("removeItemWidget", "@brief Method void QListWidget::removeItemWidget(QListWidgetItem *item)\n", false, &_init_f_removeItemWidget_2126, &_call_f_removeItemWidget_2126);
}

// int QListWidget::row(const QListWidgetItem *item)


static void _init_f_row_c2821 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QListWidgetItem * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_row_c2821 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QListWidgetItem *arg1 = args.read<const QListWidgetItem * > ();
  ret.write<int > ((int)((QListWidget *)cls)->row (arg1));
}

static qt_gsi::GenericMethod *_create_f_row_c2821 ()
{
  return new qt_gsi::GenericMethod ("row", "@brief Method int QListWidget::row(const QListWidgetItem *item)\n", true, &_init_f_row_c2821, &_call_f_row_c2821);
}

// void QListWidget::scrollToItem(const QListWidgetItem *item, QAbstractItemView::ScrollHint hint)


static void _init_f_scrollToItem_6002 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QListWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemView::EnsureVisible");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scrollToItem_6002 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QListWidgetItem *arg1 = args.read<const QListWidgetItem * > ();
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > () : (const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type &)(qt_gsi::CppToQtReadAdaptor<QAbstractItemView::ScrollHint>(heap, QAbstractItemView::EnsureVisible));
  ((QListWidget *)cls)->scrollToItem (arg1, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_scrollToItem_6002 ()
{
  return new qt_gsi::GenericMethod ("scrollToItem", "@brief Method void QListWidget::scrollToItem(const QListWidgetItem *item, QAbstractItemView::ScrollHint hint)\n", false, &_init_f_scrollToItem_6002, &_call_f_scrollToItem_6002);
}

// QList<QListWidgetItem *> QListWidget::selectedItems()


static void _init_f_selectedItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QListWidgetItem *> >::target_type > ();
}

static void _call_f_selectedItems_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QListWidgetItem *> >::target_type > ((qt_gsi::Converter<QList<QListWidgetItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QListWidgetItem *> >(((QListWidget *)cls)->selectedItems ()));
}

static qt_gsi::GenericMethod *_create_f_selectedItems_c0 ()
{
  return new qt_gsi::GenericMethod ("selectedItems", "@brief Method QList<QListWidgetItem *> QListWidget::selectedItems()\n", true, &_init_f_selectedItems_c0, &_call_f_selectedItems_c0);
}

// void QListWidget::setCurrentItem(QListWidgetItem *item)


static void _init_f_setCurrentItem_2126 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QListWidgetItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentItem_2126 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QListWidgetItem *arg1 = args.read<QListWidgetItem * > ();
  ((QListWidget *)cls)->setCurrentItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCurrentItem_2126 ()
{
  return new qt_gsi::GenericMethod ("setCurrentItem|currentItem=", "@brief Method void QListWidget::setCurrentItem(QListWidgetItem *item)\n", false, &_init_f_setCurrentItem_2126, &_call_f_setCurrentItem_2126);
}

// void QListWidget::setCurrentItem(QListWidgetItem *item, QFlags<QItemSelectionModel::SelectionFlag> command)


static void _init_f_setCurrentItem_6489 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QListWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCurrentItem_6489 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QListWidgetItem *arg1 = args.read<QListWidgetItem * > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QListWidget *)cls)->setCurrentItem (arg1, qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setCurrentItem_6489 ()
{
  return new qt_gsi::GenericMethod ("setCurrentItem", "@brief Method void QListWidget::setCurrentItem(QListWidgetItem *item, QFlags<QItemSelectionModel::SelectionFlag> command)\n", false, &_init_f_setCurrentItem_6489, &_call_f_setCurrentItem_6489);
}

// void QListWidget::setCurrentRow(int row)


static void _init_f_setCurrentRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentRow_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QListWidget *)cls)->setCurrentRow (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCurrentRow_767 ()
{
  return new qt_gsi::GenericMethod ("setCurrentRow|currentRow=", "@brief Method void QListWidget::setCurrentRow(int row)\n", false, &_init_f_setCurrentRow_767, &_call_f_setCurrentRow_767);
}

// void QListWidget::setCurrentRow(int row, QFlags<QItemSelectionModel::SelectionFlag> command)


static void _init_f_setCurrentRow_5130 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCurrentRow_5130 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QListWidget *)cls)->setCurrentRow (arg1, qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setCurrentRow_5130 ()
{
  return new qt_gsi::GenericMethod ("setCurrentRow", "@brief Method void QListWidget::setCurrentRow(int row, QFlags<QItemSelectionModel::SelectionFlag> command)\n", false, &_init_f_setCurrentRow_5130, &_call_f_setCurrentRow_5130);
}

// void QListWidget::setItemHidden(const QListWidgetItem *item, bool hide)


static void _init_f_setItemHidden_3577 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QListWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hide");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemHidden_3577 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QListWidgetItem *arg1 = args.read<const QListWidgetItem * > ();
  bool arg2 = args.read<bool > ();
  ((QListWidget *)cls)->setItemHidden (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setItemHidden_3577 ()
{
  return new qt_gsi::GenericMethod ("setItemHidden", "@brief Method void QListWidget::setItemHidden(const QListWidgetItem *item, bool hide)\n", false, &_init_f_setItemHidden_3577, &_call_f_setItemHidden_3577);
}

// void QListWidget::setItemSelected(const QListWidgetItem *item, bool select)


static void _init_f_setItemSelected_3577 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QListWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("select");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemSelected_3577 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QListWidgetItem *arg1 = args.read<const QListWidgetItem * > ();
  bool arg2 = args.read<bool > ();
  ((QListWidget *)cls)->setItemSelected (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setItemSelected_3577 ()
{
  return new qt_gsi::GenericMethod ("setItemSelected", "@brief Method void QListWidget::setItemSelected(const QListWidgetItem *item, bool select)\n", false, &_init_f_setItemSelected_3577, &_call_f_setItemSelected_3577);
}

// void QListWidget::setItemWidget(QListWidgetItem *item, QWidget *widget)


static void _init_f_setItemWidget_3333 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QListWidgetItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("widget");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemWidget_3333 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QListWidgetItem *arg1 = args.read<QListWidgetItem * > ();
  QWidget *arg2 = args.read<QWidget * > ();
  ((QListWidget *)cls)->setItemWidget (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setItemWidget_3333 ()
{
  return new qt_gsi::GenericMethod ("setItemWidget", "@brief Method void QListWidget::setItemWidget(QListWidgetItem *item, QWidget *widget)\n", false, &_init_f_setItemWidget_3333, &_call_f_setItemWidget_3333);
}

// void QListWidget::setSortingEnabled(bool enable)


static void _init_f_setSortingEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSortingEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QListWidget *)cls)->setSortingEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSortingEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setSortingEnabled|sortingEnabled=", "@brief Method void QListWidget::setSortingEnabled(bool enable)\n", false, &_init_f_setSortingEnabled_864, &_call_f_setSortingEnabled_864);
}

// void QListWidget::sortItems(Qt::SortOrder order)


static void _init_f_sortItems_1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("order", true, "Qt::AscendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_sortItems_1681 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > () : (const qt_gsi::Converter<Qt::SortOrder>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::AscendingOrder));
  ((QListWidget *)cls)->sortItems (qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_sortItems_1681 ()
{
  return new qt_gsi::GenericMethod ("sortItems", "@brief Method void QListWidget::sortItems(Qt::SortOrder order)\n", false, &_init_f_sortItems_1681, &_call_f_sortItems_1681);
}

// QListWidgetItem *QListWidget::takeItem(int row)


static void _init_f_takeItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QListWidgetItem * > ();
}

static void _call_f_takeItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QListWidgetItem * > ((QListWidgetItem *)((QListWidget *)cls)->takeItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_takeItem_767 ()
{
  return new qt_gsi::GenericMethod ("takeItem", "@brief Method QListWidgetItem *QListWidget::takeItem(int row)\n", false, &_init_f_takeItem_767, &_call_f_takeItem_767);
}

// QRect QListWidget::visualItemRect(const QListWidgetItem *item)


static void _init_f_visualItemRect_c2821 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QListWidgetItem * > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_visualItemRect_c2821 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QListWidgetItem *arg1 = args.read<const QListWidgetItem * > ();
  ret.write<QRect > ((QRect)((QListWidget *)cls)->visualItemRect (arg1));
}

static qt_gsi::GenericMethod *_create_f_visualItemRect_c2821 ()
{
  return new qt_gsi::GenericMethod ("visualItemRect", "@brief Method QRect QListWidget::visualItemRect(const QListWidgetItem *item)\n", true, &_init_f_visualItemRect_c2821, &_call_f_visualItemRect_c2821);
}

// static QString QListWidget::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QListWidget::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QListWidget::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QListWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QListWidget::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QListWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QListWidget::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QListWidget::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QListWidget::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QListWidget::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QListWidget::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QListWidget::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QListWidget, QListWidget_EventAdaptor> ea_QListWidget;

namespace gsi
{
extern gsi::Class<QListView> decl_QListView;

gsi::Class<QListWidget> decl_QListWidget (ea_QListWidget, decl_QListView, "QListWidget_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_addItem_2025 ()) +
  gsi::Methods(_create_f_addItem_2126 ()) +
  gsi::Methods(_create_f_addItems_2437 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_closePersistentEditor_2126 ()) +
  gsi::Methods(_create_f_count_c0 ()) +
  gsi::Methods(_create_f_currentItem_c0 ()) +
  gsi::Methods(_create_f_currentRow_c0 ()) +
  gsi::Methods(_create_f_dropEvent_1622 ()) +
  gsi::Methods(_create_f_editItem_2126 ()) +
  gsi::Methods(_create_f_findItems_c4233 ()) +
  gsi::Methods(_create_f_insertItem_2785 ()) +
  gsi::Methods(_create_f_insertItem_2684 ()) +
  gsi::Methods(_create_f_insertItems_3096 ()) +
  gsi::Methods(_create_f_isItemHidden_c2821 ()) +
  gsi::Methods(_create_f_isItemSelected_c2821 ()) +
  gsi::Methods(_create_f_isSortingEnabled_c0 ()) +
  gsi::Methods(_create_f_item_c767 ()) +
  gsi::Methods(_create_f_itemAt_c1916 ()) +
  gsi::Methods(_create_f_itemAt_c1426 ()) +
  gsi::Methods(_create_f_itemWidget_c2126 ()) +
  gsi::Methods(_create_f_openPersistentEditor_2126 ()) +
  gsi::Methods(_create_f_removeItemWidget_2126 ()) +
  gsi::Methods(_create_f_row_c2821 ()) +
  gsi::Methods(_create_f_scrollToItem_6002 ()) +
  gsi::Methods(_create_f_selectedItems_c0 ()) +
  gsi::Methods(_create_f_setCurrentItem_2126 ()) +
  gsi::Methods(_create_f_setCurrentItem_6489 ()) +
  gsi::Methods(_create_f_setCurrentRow_767 ()) +
  gsi::Methods(_create_f_setCurrentRow_5130 ()) +
  gsi::Methods(_create_f_setItemHidden_3577 ()) +
  gsi::Methods(_create_f_setItemSelected_3577 ()) +
  gsi::Methods(_create_f_setItemWidget_3333 ()) +
  gsi::Methods(_create_f_setSortingEnabled_864 ()) +
  gsi::Methods(_create_f_sortItems_1681 ()) +
  gsi::Methods(_create_f_takeItem_767 ()) +
  gsi::Methods(_create_f_visualItemRect_c2821 ()) +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, const QModelIndex &> ("activated", &QListWidget_EventAdaptor::activated_e_2395, gsi::arg("index"), "@brief Signal declaration for QListWidget::activated(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, const QModelIndex &> ("clicked", &QListWidget_EventAdaptor::clicked_e_2395, gsi::arg("index"), "@brief Signal declaration for QListWidget::clicked(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, QListWidgetItem *, QListWidgetItem *> ("currentItemChanged", &QListWidget_EventAdaptor::currentItemChanged_e_4144, gsi::arg("current"), gsi::arg("previous"), "@brief Signal declaration for QListWidget::currentItemChanged(QListWidgetItem *current, QListWidgetItem *previous)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, int> ("currentRowChanged", &QListWidget_EventAdaptor::currentRowChanged_e_767, gsi::arg("currentRow"), "@brief Signal declaration for QListWidget::currentRowChanged(int currentRow)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, const QString &> ("currentTextChanged", &QListWidget_EventAdaptor::currentTextChanged_e_2025, gsi::arg("currentText"), "@brief Signal declaration for QListWidget::currentTextChanged(const QString &currentText)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QListWidget_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QListWidget::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, QObject *> ("destroyed", &QListWidget_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QListWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, const QModelIndex &> ("doubleClicked", &QListWidget_EventAdaptor::doubleClicked_e_2395, gsi::arg("index"), "@brief Signal declaration for QListWidget::doubleClicked(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, const QModelIndex &> ("entered", &QListWidget_EventAdaptor::entered_e_2395, gsi::arg("index"), "@brief Signal declaration for QListWidget::entered(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, const qt_gsi::Converter<QList<QModelIndex> >::target_type &> ("indexesMoved", &QListWidget_EventAdaptor::indexesMoved_e_3010, gsi::arg("indexes"), "@brief Signal declaration for QListWidget::indexesMoved(const QList<QModelIndex> &indexes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, QListWidgetItem *> ("itemActivated", &QListWidget_EventAdaptor::itemActivated_e_2126, gsi::arg("item"), "@brief Signal declaration for QListWidget::itemActivated(QListWidgetItem *item)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, QListWidgetItem *> ("itemChanged", &QListWidget_EventAdaptor::itemChanged_e_2126, gsi::arg("item"), "@brief Signal declaration for QListWidget::itemChanged(QListWidgetItem *item)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, QListWidgetItem *> ("itemClicked", &QListWidget_EventAdaptor::itemClicked_e_2126, gsi::arg("item"), "@brief Signal declaration for QListWidget::itemClicked(QListWidgetItem *item)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, QListWidgetItem *> ("itemDoubleClicked", &QListWidget_EventAdaptor::itemDoubleClicked_e_2126, gsi::arg("item"), "@brief Signal declaration for QListWidget::itemDoubleClicked(QListWidgetItem *item)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, QListWidgetItem *> ("itemEntered", &QListWidget_EventAdaptor::itemEntered_e_2126, gsi::arg("item"), "@brief Signal declaration for QListWidget::itemEntered(QListWidgetItem *item)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, QListWidgetItem *> ("itemPressed", &QListWidget_EventAdaptor::itemPressed_e_2126, gsi::arg("item"), "@brief Signal declaration for QListWidget::itemPressed(QListWidgetItem *item)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor> ("itemSelectionChanged", &QListWidget_EventAdaptor::itemSelectionChanged_e_0, "@brief Signal declaration for QListWidget::itemSelectionChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor, const QModelIndex &> ("pressed", &QListWidget_EventAdaptor::pressed_e_2395, gsi::arg("index"), "@brief Signal declaration for QListWidget::pressed(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QListWidget, QListWidget_EventAdaptor> ("viewportEntered", &QListWidget_EventAdaptor::viewportEntered_e_0, "@brief Signal declaration for QListWidget::viewportEntered()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QListWidget");
}


class QListWidget_Adaptor : public QListWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QListWidget_Adaptor();

  //  [adaptor ctor] QListWidget::QListWidget(QWidget *parent)
  QListWidget_Adaptor() : QListWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QListWidget::QListWidget(QWidget *parent)
  QListWidget_Adaptor(QWidget *parent) : QListWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  QSize QListWidget::contentsSize()
  QSize fp_QListWidget_contentsSize_c0 () const {
    return QListWidget::contentsSize();
  }

  //  void QListWidget::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QListWidget_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QListWidget::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QListWidget::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QListWidget_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QListWidget::destroy(destroyWindow, destroySubWindows);
  }

  //  QPoint QListWidget::dirtyRegionOffset()
  QPoint fp_QListWidget_dirtyRegionOffset_c0 () const {
    return QListWidget::dirtyRegionOffset();
  }

  //  void QListWidget::doAutoScroll()
  void fp_QListWidget_doAutoScroll_0 () {
    QListWidget::doAutoScroll();
  }

  //  void QListWidget::drawFrame(QPainter *)
  void fp_QListWidget_drawFrame_1426 (QPainter *arg1) {
    QListWidget::drawFrame(arg1);
  }

  //  QAbstractItemView::DropIndicatorPosition QListWidget::dropIndicatorPosition()
  unsigned int fp_QListWidget_dropIndicatorPosition_c0 () const {
    return (unsigned int)(QListWidget::dropIndicatorPosition());
  }

  //  void QListWidget::executeDelayedItemsLayout()
  void fp_QListWidget_executeDelayedItemsLayout_0 () {
    QListWidget::executeDelayedItemsLayout();
  }

  //  bool QListWidget::focusNextChild()
  bool fp_QListWidget_focusNextChild_0 () {
    return QListWidget::focusNextChild();
  }

  //  bool QListWidget::focusPreviousChild()
  bool fp_QListWidget_focusPreviousChild_0 () {
    return QListWidget::focusPreviousChild();
  }

  //  int QListWidget::horizontalStepsPerItem()
  int fp_QListWidget_horizontalStepsPerItem_c0 () const {
    return QListWidget::horizontalStepsPerItem();
  }

  //  QModelIndex QListWidget::indexFromItem(QListWidgetItem *item)
  QModelIndex fp_QListWidget_indexFromItem_c2126 (QListWidgetItem *item) const {
    return QListWidget::indexFromItem(item);
  }

  //  void QListWidget::internalDrag(QFlags<Qt::DropAction> supportedActions)
  void fp_QListWidget_internalDrag_2456 (const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & supportedActions) {
    QListWidget::internalDrag(qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(supportedActions).cref());
  }

  //  void QListWidget::internalDrop(QDropEvent *e)
  void fp_QListWidget_internalDrop_1622 (QDropEvent *e) {
    QListWidget::internalDrop(e);
  }

  //  QListWidgetItem *QListWidget::itemFromIndex(const QModelIndex &index)
  QListWidgetItem * fp_QListWidget_itemFromIndex_c2395 (const QModelIndex &index) const {
    return QListWidget::itemFromIndex(index);
  }

  //  QList<QListWidgetItem *> QListWidget::items(const QMimeData *data)
  qt_gsi::Converter<QList<QListWidgetItem *> >::target_type fp_QListWidget_items_c2168 (const QMimeData *data) const {
    return qt_gsi::CppToQtAdaptor<QList<QListWidgetItem *> >(QListWidget::items(data));
  }

  //  int QListWidget::receivers(const char *signal)
  int fp_QListWidget_receivers_c1731 (const char *signal) const {
    return QListWidget::receivers(signal);
  }

  //  QRect QListWidget::rectForIndex(const QModelIndex &index)
  QRect fp_QListWidget_rectForIndex_c2395 (const QModelIndex &index) const {
    return QListWidget::rectForIndex(index);
  }

  //  void QListWidget::resetInputContext()
  void fp_QListWidget_resetInputContext_0 () {
    QListWidget::resetInputContext();
  }

  //  void QListWidget::resizeContents(int width, int height)
  void fp_QListWidget_resizeContents_1426 (int width, int height) {
    QListWidget::resizeContents(width, height);
  }

  //  void QListWidget::scheduleDelayedItemsLayout()
  void fp_QListWidget_scheduleDelayedItemsLayout_0 () {
    QListWidget::scheduleDelayedItemsLayout();
  }

  //  void QListWidget::scrollDirtyRegion(int dx, int dy)
  void fp_QListWidget_scrollDirtyRegion_1426 (int dx, int dy) {
    QListWidget::scrollDirtyRegion(dx, dy);
  }

  //  QObject *QListWidget::sender()
  QObject * fp_QListWidget_sender_c0 () const {
    return QListWidget::sender();
  }

  //  void QListWidget::setDirtyRegion(const QRegion &region)
  void fp_QListWidget_setDirtyRegion_2006 (const QRegion &region) {
    QListWidget::setDirtyRegion(region);
  }

  //  void QListWidget::setHorizontalStepsPerItem(int steps)
  void fp_QListWidget_setHorizontalStepsPerItem_767 (int steps) {
    QListWidget::setHorizontalStepsPerItem(steps);
  }

  //  void QListWidget::setPositionForIndex(const QPoint &position, const QModelIndex &index)
  void fp_QListWidget_setPositionForIndex_4203 (const QPoint &position, const QModelIndex &index) {
    QListWidget::setPositionForIndex(position, index);
  }

  //  void QListWidget::setState(QAbstractItemView::State state)
  void fp_QListWidget_setState_2776 (unsigned int state) {
    QListWidget::setState(QAbstractItemView::State(state));
  }

  //  void QListWidget::setVerticalStepsPerItem(int steps)
  void fp_QListWidget_setVerticalStepsPerItem_767 (int steps) {
    QListWidget::setVerticalStepsPerItem(steps);
  }

  //  void QListWidget::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QListWidget_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QListWidget::setViewportMargins(left, top, right, bottom);
  }

  //  void QListWidget::setViewportMargins(const QMargins &margins)
  void fp_QListWidget_setViewportMargins_2115 (const QMargins &margins) {
    QListWidget::setViewportMargins(margins);
  }

  //  void QListWidget::setupViewport(QWidget *viewport)
  void fp_QListWidget_setupViewport_1315 (QWidget *viewport) {
    QListWidget::setupViewport(viewport);
  }

  //  void QListWidget::startAutoScroll()
  void fp_QListWidget_startAutoScroll_0 () {
    QListWidget::startAutoScroll();
  }

  //  QAbstractItemView::State QListWidget::state()
  unsigned int fp_QListWidget_state_c0 () const {
    return (unsigned int)(QListWidget::state());
  }

  //  void QListWidget::stopAutoScroll()
  void fp_QListWidget_stopAutoScroll_0 () {
    QListWidget::stopAutoScroll();
  }

  //  void QListWidget::updateMicroFocus()
  void fp_QListWidget_updateMicroFocus_0 () {
    QListWidget::updateMicroFocus();
  }

  //  int QListWidget::verticalStepsPerItem()
  int fp_QListWidget_verticalStepsPerItem_c0 () const {
    return QListWidget::verticalStepsPerItem();
  }

  //  [adaptor impl] void QListWidget::doItemsLayout()
  void cbs_doItemsLayout_0_0()
  {
    QListWidget::doItemsLayout();
  }

  virtual void doItemsLayout()
  {
    if (cb_doItemsLayout_0_0.can_issue()) {
      cb_doItemsLayout_0_0.issue<QListWidget_Adaptor>(&QListWidget_Adaptor::cbs_doItemsLayout_0_0);
    } else {
      QListWidget::doItemsLayout();
    }
  }

  //  [adaptor impl] void QListWidget::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QListWidget::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QListWidget_Adaptor, QDropEvent *>(&QListWidget_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QListWidget::dropEvent(event);
    }
  }

  //  [adaptor impl] bool QListWidget::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QListWidget::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QListWidget_Adaptor, bool, QObject *, QEvent *>(&QListWidget_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QListWidget::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QListWidget::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QListWidget::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QListWidget_Adaptor, int, int>(&QListWidget_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QListWidget::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QModelIndex QListWidget::indexAt(const QPoint &p)
  QModelIndex cbs_indexAt_c1916_0(const QPoint &p) const
  {
    return QListWidget::indexAt(p);
  }

  virtual QModelIndex indexAt(const QPoint &p) const
  {
    if (cb_indexAt_c1916_0.can_issue()) {
      return cb_indexAt_c1916_0.issue<QListWidget_Adaptor, QModelIndex, const QPoint &>(&QListWidget_Adaptor::cbs_indexAt_c1916_0, p);
    } else {
      return QListWidget::indexAt(p);
    }
  }

  //  [adaptor impl] QVariant QListWidget::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QListWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QListWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QListWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QListWidget::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] void QListWidget::keyboardSearch(const QString &search)
  void cbs_keyboardSearch_2025_0(const QString &search)
  {
    QListWidget::keyboardSearch(search);
  }

  virtual void keyboardSearch(const QString &search)
  {
    if (cb_keyboardSearch_2025_0.can_issue()) {
      cb_keyboardSearch_2025_0.issue<QListWidget_Adaptor, const QString &>(&QListWidget_Adaptor::cbs_keyboardSearch_2025_0, search);
    } else {
      QListWidget::keyboardSearch(search);
    }
  }

  //  [adaptor impl] QSize QListWidget::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QListWidget::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QListWidget_Adaptor, QSize>(&QListWidget_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QListWidget::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QListWidget::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QListWidget::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QListWidget_Adaptor, QPaintEngine *>(&QListWidget_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QListWidget::paintEngine();
    }
  }

  //  [adaptor impl] void QListWidget::reset()
  void cbs_reset_0_0()
  {
    QListWidget::reset();
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QListWidget_Adaptor>(&QListWidget_Adaptor::cbs_reset_0_0);
    } else {
      QListWidget::reset();
    }
  }

  //  [adaptor impl] void QListWidget::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  void cbs_scrollTo_5576_1(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & hint)
  {
    QListWidget::scrollTo(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(hint).cref());
  }

  virtual void scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  {
    if (cb_scrollTo_5576_1.can_issue()) {
      cb_scrollTo_5576_1.issue<QListWidget_Adaptor, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type &>(&QListWidget_Adaptor::cbs_scrollTo_5576_1, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::ScrollHint>(hint));
    } else {
      QListWidget::scrollTo(index, hint);
    }
  }

  //  [adaptor impl] void QListWidget::selectAll()
  void cbs_selectAll_0_0()
  {
    QListWidget::selectAll();
  }

  virtual void selectAll()
  {
    if (cb_selectAll_0_0.can_issue()) {
      cb_selectAll_0_0.issue<QListWidget_Adaptor>(&QListWidget_Adaptor::cbs_selectAll_0_0);
    } else {
      QListWidget::selectAll();
    }
  }

  //  [adaptor impl] void QListWidget::setRootIndex(const QModelIndex &index)
  void cbs_setRootIndex_2395_0(const QModelIndex &index)
  {
    QListWidget::setRootIndex(index);
  }

  virtual void setRootIndex(const QModelIndex &index)
  {
    if (cb_setRootIndex_2395_0.can_issue()) {
      cb_setRootIndex_2395_0.issue<QListWidget_Adaptor, const QModelIndex &>(&QListWidget_Adaptor::cbs_setRootIndex_2395_0, index);
    } else {
      QListWidget::setRootIndex(index);
    }
  }

  //  [adaptor impl] void QListWidget::setSelectionModel(QItemSelectionModel *selectionModel)
  void cbs_setSelectionModel_2533_0(QItemSelectionModel *selectionModel)
  {
    QListWidget::setSelectionModel(selectionModel);
  }

  virtual void setSelectionModel(QItemSelectionModel *selectionModel)
  {
    if (cb_setSelectionModel_2533_0.can_issue()) {
      cb_setSelectionModel_2533_0.issue<QListWidget_Adaptor, QItemSelectionModel *>(&QListWidget_Adaptor::cbs_setSelectionModel_2533_0, selectionModel);
    } else {
      QListWidget::setSelectionModel(selectionModel);
    }
  }

  //  [adaptor impl] void QListWidget::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QListWidget::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QListWidget_Adaptor, bool>(&QListWidget_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QListWidget::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QListWidget::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QListWidget::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QListWidget_Adaptor, QSize>(&QListWidget_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QListWidget::sizeHint();
    }
  }

  //  [adaptor impl] int QListWidget::sizeHintForColumn(int column)
  int cbs_sizeHintForColumn_c767_0(int column) const
  {
    return QListWidget::sizeHintForColumn(column);
  }

  virtual int sizeHintForColumn(int column) const
  {
    if (cb_sizeHintForColumn_c767_0.can_issue()) {
      return cb_sizeHintForColumn_c767_0.issue<QListWidget_Adaptor, int, int>(&QListWidget_Adaptor::cbs_sizeHintForColumn_c767_0, column);
    } else {
      return QListWidget::sizeHintForColumn(column);
    }
  }

  //  [adaptor impl] int QListWidget::sizeHintForRow(int row)
  int cbs_sizeHintForRow_c767_0(int row) const
  {
    return QListWidget::sizeHintForRow(row);
  }

  virtual int sizeHintForRow(int row) const
  {
    if (cb_sizeHintForRow_c767_0.can_issue()) {
      return cb_sizeHintForRow_c767_0.issue<QListWidget_Adaptor, int, int>(&QListWidget_Adaptor::cbs_sizeHintForRow_c767_0, row);
    } else {
      return QListWidget::sizeHintForRow(row);
    }
  }

  //  [adaptor impl] QRect QListWidget::visualRect(const QModelIndex &index)
  QRect cbs_visualRect_c2395_0(const QModelIndex &index) const
  {
    return QListWidget::visualRect(index);
  }

  virtual QRect visualRect(const QModelIndex &index) const
  {
    if (cb_visualRect_c2395_0.can_issue()) {
      return cb_visualRect_c2395_0.issue<QListWidget_Adaptor, QRect, const QModelIndex &>(&QListWidget_Adaptor::cbs_visualRect_c2395_0, index);
    } else {
      return QListWidget::visualRect(index);
    }
  }

  //  [adaptor impl] void QListWidget::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QListWidget::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QListWidget_Adaptor, QActionEvent *>(&QListWidget_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QListWidget::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QListWidget::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QListWidget_Adaptor, QEvent *>(&QListWidget_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QListWidget::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QListWidget::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QListWidget_Adaptor, QChildEvent *>(&QListWidget_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QListWidget::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  void cbs_closeEditor_4926_0(QWidget *editor, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & hint)
  {
    QListWidget::closeEditor(editor, qt_gsi::QtToCppAdaptor<QAbstractItemDelegate::EndEditHint>(hint).cref());
  }

  virtual void closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  {
    if (cb_closeEditor_4926_0.can_issue()) {
      cb_closeEditor_4926_0.issue<QListWidget_Adaptor, QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type &>(&QListWidget_Adaptor::cbs_closeEditor_4926_0, editor, qt_gsi::CppToQtAdaptor<QAbstractItemDelegate::EndEditHint>(hint));
    } else {
      QListWidget::closeEditor(editor, hint);
    }
  }

  //  [adaptor impl] void QListWidget::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QListWidget::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QListWidget_Adaptor, QCloseEvent *>(&QListWidget_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QListWidget::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::commitData(QWidget *editor)
  void cbs_commitData_1315_0(QWidget *editor)
  {
    QListWidget::commitData(editor);
  }

  virtual void commitData(QWidget *editor)
  {
    if (cb_commitData_1315_0.can_issue()) {
      cb_commitData_1315_0.issue<QListWidget_Adaptor, QWidget *>(&QListWidget_Adaptor::cbs_commitData_1315_0, editor);
    } else {
      QListWidget::commitData(editor);
    }
  }

  //  [adaptor impl] void QListWidget::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QListWidget::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QListWidget_Adaptor, QContextMenuEvent *>(&QListWidget_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QListWidget::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::currentChanged(const QModelIndex &current, const QModelIndex &previous)
  void cbs_currentChanged_4682_0(const QModelIndex &current, const QModelIndex &previous)
  {
    QListWidget::currentChanged(current, previous);
  }

  virtual void currentChanged(const QModelIndex &current, const QModelIndex &previous)
  {
    if (cb_currentChanged_4682_0.can_issue()) {
      cb_currentChanged_4682_0.issue<QListWidget_Adaptor, const QModelIndex &, const QModelIndex &>(&QListWidget_Adaptor::cbs_currentChanged_4682_0, current, previous);
    } else {
      QListWidget::currentChanged(current, previous);
    }
  }

  //  [adaptor impl] void QListWidget::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QListWidget::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QListWidget_Adaptor, QEvent *>(&QListWidget_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QListWidget::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  void cbs_dataChanged_4682_0(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    QListWidget::dataChanged(topLeft, bottomRight);
  }

  virtual void dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    if (cb_dataChanged_4682_0.can_issue()) {
      cb_dataChanged_4682_0.issue<QListWidget_Adaptor, const QModelIndex &, const QModelIndex &>(&QListWidget_Adaptor::cbs_dataChanged_4682_0, topLeft, bottomRight);
    } else {
      QListWidget::dataChanged(topLeft, bottomRight);
    }
  }

  //  [adaptor impl] void QListWidget::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QListWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QListWidget_Adaptor, const char *>(&QListWidget_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QListWidget::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QListWidget::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QListWidget::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QListWidget_Adaptor, QDragEnterEvent *>(&QListWidget_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QListWidget::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QListWidget::dragLeaveEvent(QDragLeaveEvent *e)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *e)
  {
    QListWidget::dragLeaveEvent(e);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *e)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QListWidget_Adaptor, QDragLeaveEvent *>(&QListWidget_Adaptor::cbs_dragLeaveEvent_2092_0, e);
    } else {
      QListWidget::dragLeaveEvent(e);
    }
  }

  //  [adaptor impl] void QListWidget::dragMoveEvent(QDragMoveEvent *e)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *e)
  {
    QListWidget::dragMoveEvent(e);
  }

  virtual void dragMoveEvent(QDragMoveEvent *e)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QListWidget_Adaptor, QDragMoveEvent *>(&QListWidget_Adaptor::cbs_dragMoveEvent_2006_0, e);
    } else {
      QListWidget::dragMoveEvent(e);
    }
  }

  //  [adaptor impl] bool QListWidget::dropMimeData(int index, const QMimeData *data, Qt::DropAction action)
  bool cbs_dropMimeData_4479_0(int index, const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action)
  {
    return QListWidget::dropMimeData(index, data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref());
  }

  virtual bool dropMimeData(int index, const QMimeData *data, Qt::DropAction action)
  {
    if (cb_dropMimeData_4479_0.can_issue()) {
      return cb_dropMimeData_4479_0.issue<QListWidget_Adaptor, bool, int, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &>(&QListWidget_Adaptor::cbs_dropMimeData_4479_0, index, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action));
    } else {
      return QListWidget::dropMimeData(index, data, action);
    }
  }

  //  [adaptor impl] bool QListWidget::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  bool cbs_edit_6773_0(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & trigger, QEvent *event)
  {
    return QListWidget::edit(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::EditTrigger>(trigger).cref(), event);
  }

  virtual bool edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  {
    if (cb_edit_6773_0.can_issue()) {
      return cb_edit_6773_0.issue<QListWidget_Adaptor, bool, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type &, QEvent *>(&QListWidget_Adaptor::cbs_edit_6773_0, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::EditTrigger>(trigger), event);
    } else {
      return QListWidget::edit(index, trigger, event);
    }
  }

  //  [adaptor impl] void QListWidget::editorDestroyed(QObject *editor)
  void cbs_editorDestroyed_1302_0(QObject *editor)
  {
    QListWidget::editorDestroyed(editor);
  }

  virtual void editorDestroyed(QObject *editor)
  {
    if (cb_editorDestroyed_1302_0.can_issue()) {
      cb_editorDestroyed_1302_0.issue<QListWidget_Adaptor, QObject *>(&QListWidget_Adaptor::cbs_editorDestroyed_1302_0, editor);
    } else {
      QListWidget::editorDestroyed(editor);
    }
  }

  //  [adaptor impl] void QListWidget::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QListWidget::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QListWidget_Adaptor, bool>(&QListWidget_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QListWidget::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QListWidget::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QListWidget_Adaptor, QEvent *>(&QListWidget_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QListWidget::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QListWidget::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QListWidget::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QListWidget_Adaptor, bool, QEvent *>(&QListWidget_Adaptor::cbs_event_1217_0, e);
    } else {
      return QListWidget::event(e);
    }
  }

  //  [adaptor impl] void QListWidget::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QListWidget::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QListWidget_Adaptor, QFocusEvent *>(&QListWidget_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QListWidget::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QListWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QListWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QListWidget_Adaptor, bool, bool>(&QListWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QListWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QListWidget::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QListWidget::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QListWidget_Adaptor, QFocusEvent *>(&QListWidget_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QListWidget::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QListWidget::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QListWidget::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QListWidget_Adaptor, const QFont &>(&QListWidget_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QListWidget::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QListWidget::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QListWidget_Adaptor, QHideEvent *>(&QListWidget_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QListWidget::hideEvent(arg1);
    }
  }

  //  [adaptor impl] int QListWidget::horizontalOffset()
  int cbs_horizontalOffset_c0_0() const
  {
    return QListWidget::horizontalOffset();
  }

  virtual int horizontalOffset() const
  {
    if (cb_horizontalOffset_c0_0.can_issue()) {
      return cb_horizontalOffset_c0_0.issue<QListWidget_Adaptor, int>(&QListWidget_Adaptor::cbs_horizontalOffset_c0_0);
    } else {
      return QListWidget::horizontalOffset();
    }
  }

  //  [adaptor impl] void QListWidget::horizontalScrollbarAction(int action)
  void cbs_horizontalScrollbarAction_767_0(int action)
  {
    QListWidget::horizontalScrollbarAction(action);
  }

  virtual void horizontalScrollbarAction(int action)
  {
    if (cb_horizontalScrollbarAction_767_0.can_issue()) {
      cb_horizontalScrollbarAction_767_0.issue<QListWidget_Adaptor, int>(&QListWidget_Adaptor::cbs_horizontalScrollbarAction_767_0, action);
    } else {
      QListWidget::horizontalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QListWidget::horizontalScrollbarValueChanged(int value)
  void cbs_horizontalScrollbarValueChanged_767_0(int value)
  {
    QListWidget::horizontalScrollbarValueChanged(value);
  }

  virtual void horizontalScrollbarValueChanged(int value)
  {
    if (cb_horizontalScrollbarValueChanged_767_0.can_issue()) {
      cb_horizontalScrollbarValueChanged_767_0.issue<QListWidget_Adaptor, int>(&QListWidget_Adaptor::cbs_horizontalScrollbarValueChanged_767_0, value);
    } else {
      QListWidget::horizontalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] void QListWidget::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QListWidget::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QListWidget_Adaptor, QInputMethodEvent *>(&QListWidget_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QListWidget::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] bool QListWidget::isIndexHidden(const QModelIndex &index)
  bool cbs_isIndexHidden_c2395_0(const QModelIndex &index) const
  {
    return QListWidget::isIndexHidden(index);
  }

  virtual bool isIndexHidden(const QModelIndex &index) const
  {
    if (cb_isIndexHidden_c2395_0.can_issue()) {
      return cb_isIndexHidden_c2395_0.issue<QListWidget_Adaptor, bool, const QModelIndex &>(&QListWidget_Adaptor::cbs_isIndexHidden_c2395_0, index);
    } else {
      return QListWidget::isIndexHidden(index);
    }
  }

  //  [adaptor impl] void QListWidget::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QListWidget::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QListWidget_Adaptor, QKeyEvent *>(&QListWidget_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QListWidget::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QListWidget::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QListWidget::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QListWidget_Adaptor, QKeyEvent *>(&QListWidget_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QListWidget::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::languageChange()
  void cbs_languageChange_0_0()
  {
    QListWidget::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QListWidget_Adaptor>(&QListWidget_Adaptor::cbs_languageChange_0_0);
    } else {
      QListWidget::languageChange();
    }
  }

  //  [adaptor impl] void QListWidget::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QListWidget::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QListWidget_Adaptor, QEvent *>(&QListWidget_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QListWidget::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QListWidget::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QListWidget::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QListWidget_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QListWidget_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QListWidget::metric(arg1);
    }
  }

  //  [adaptor impl] QMimeData *QListWidget::mimeData(const QList<QListWidgetItem *> items)
  QMimeData * cbs_mimeData_c3436_0(const qt_gsi::Converter<QList<QListWidgetItem *> >::target_type & items) const
  {
    return QListWidget::mimeData(qt_gsi::QtToCppAdaptor<QList<QListWidgetItem *> >(items).cref());
  }

  virtual QMimeData * mimeData(const QList<QListWidgetItem *> items) const
  {
    if (cb_mimeData_c3436_0.can_issue()) {
      return cb_mimeData_c3436_0.issue<QListWidget_Adaptor, QMimeData *, const qt_gsi::Converter<QList<QListWidgetItem *> >::target_type &>(&QListWidget_Adaptor::cbs_mimeData_c3436_0, qt_gsi::CppToQtAdaptor<QList<QListWidgetItem *> >(items));
    } else {
      return QListWidget::mimeData(items);
    }
  }

  //  [adaptor impl] QStringList QListWidget::mimeTypes()
  qt_gsi::Converter<QStringList>::target_type cbs_mimeTypes_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QStringList>(QListWidget::mimeTypes());
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStringList>(cb_mimeTypes_c0_0.issue<QListWidget_Adaptor, qt_gsi::Converter<QStringList>::target_type>(&QListWidget_Adaptor::cbs_mimeTypes_c0_0)).cref();
    } else {
      return QListWidget::mimeTypes();
    }
  }

  //  [adaptor impl] void QListWidget::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QListWidget::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QListWidget_Adaptor, QMouseEvent *>(&QListWidget_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QListWidget::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QListWidget::mouseMoveEvent(QMouseEvent *e)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *e)
  {
    QListWidget::mouseMoveEvent(e);
  }

  virtual void mouseMoveEvent(QMouseEvent *e)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QListWidget_Adaptor, QMouseEvent *>(&QListWidget_Adaptor::cbs_mouseMoveEvent_1738_0, e);
    } else {
      QListWidget::mouseMoveEvent(e);
    }
  }

  //  [adaptor impl] void QListWidget::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QListWidget::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QListWidget_Adaptor, QMouseEvent *>(&QListWidget_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QListWidget::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QListWidget::mouseReleaseEvent(QMouseEvent *e)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *e)
  {
    QListWidget::mouseReleaseEvent(e);
  }

  virtual void mouseReleaseEvent(QMouseEvent *e)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QListWidget_Adaptor, QMouseEvent *>(&QListWidget_Adaptor::cbs_mouseReleaseEvent_1738_0, e);
    } else {
      QListWidget::mouseReleaseEvent(e);
    }
  }

  //  [adaptor impl] QModelIndex QListWidget::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  QModelIndex cbs_moveCursor_6476_0(unsigned int cursorAction, const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & modifiers)
  {
    return QListWidget::moveCursor(QAbstractItemView::CursorAction(cursorAction), qt_gsi::QtToCppAdaptor<QFlags<Qt::KeyboardModifier> >(modifiers).cref());
  }

  virtual QModelIndex moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  {
    if (cb_moveCursor_6476_0.can_issue()) {
      return cb_moveCursor_6476_0.issue<QListWidget_Adaptor, QModelIndex, unsigned int, const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type &>(&QListWidget_Adaptor::cbs_moveCursor_6476_0, (unsigned int)(cursorAction), qt_gsi::CppToQtAdaptor<QFlags<Qt::KeyboardModifier> >(modifiers));
    } else {
      return QListWidget::moveCursor(cursorAction, modifiers);
    }
  }

  //  [adaptor impl] void QListWidget::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QListWidget::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QListWidget_Adaptor, QMoveEvent *>(&QListWidget_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QListWidget::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::paintEvent(QPaintEvent *e)
  void cbs_paintEvent_1725_0(QPaintEvent *e)
  {
    QListWidget::paintEvent(e);
  }

  virtual void paintEvent(QPaintEvent *e)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QListWidget_Adaptor, QPaintEvent *>(&QListWidget_Adaptor::cbs_paintEvent_1725_0, e);
    } else {
      QListWidget::paintEvent(e);
    }
  }

  //  [adaptor impl] void QListWidget::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QListWidget::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QListWidget_Adaptor, const QPalette &>(&QListWidget_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QListWidget::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::resizeEvent(QResizeEvent *e)
  void cbs_resizeEvent_1843_0(QResizeEvent *e)
  {
    QListWidget::resizeEvent(e);
  }

  virtual void resizeEvent(QResizeEvent *e)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QListWidget_Adaptor, QResizeEvent *>(&QListWidget_Adaptor::cbs_resizeEvent_1843_0, e);
    } else {
      QListWidget::resizeEvent(e);
    }
  }

  //  [adaptor impl] void QListWidget::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  void cbs_rowsAboutToBeRemoved_3713_0(const QModelIndex &parent, int start, int end)
  {
    QListWidget::rowsAboutToBeRemoved(parent, start, end);
  }

  virtual void rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsAboutToBeRemoved_3713_0.can_issue()) {
      cb_rowsAboutToBeRemoved_3713_0.issue<QListWidget_Adaptor, const QModelIndex &, int, int>(&QListWidget_Adaptor::cbs_rowsAboutToBeRemoved_3713_0, parent, start, end);
    } else {
      QListWidget::rowsAboutToBeRemoved(parent, start, end);
    }
  }

  //  [adaptor impl] void QListWidget::rowsInserted(const QModelIndex &parent, int start, int end)
  void cbs_rowsInserted_3713_0(const QModelIndex &parent, int start, int end)
  {
    QListWidget::rowsInserted(parent, start, end);
  }

  virtual void rowsInserted(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsInserted_3713_0.can_issue()) {
      cb_rowsInserted_3713_0.issue<QListWidget_Adaptor, const QModelIndex &, int, int>(&QListWidget_Adaptor::cbs_rowsInserted_3713_0, parent, start, end);
    } else {
      QListWidget::rowsInserted(parent, start, end);
    }
  }

  //  [adaptor impl] void QListWidget::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QListWidget::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QListWidget_Adaptor, int, int>(&QListWidget_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QListWidget::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QListWidget::selectedIndexes()
  qt_gsi::Converter<QList<QModelIndex> >::target_type cbs_selectedIndexes_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QListWidget::selectedIndexes());
  }

  virtual QList<QModelIndex> selectedIndexes() const
  {
    if (cb_selectedIndexes_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(cb_selectedIndexes_c0_0.issue<QListWidget_Adaptor, qt_gsi::Converter<QList<QModelIndex> >::target_type>(&QListWidget_Adaptor::cbs_selectedIndexes_c0_0)).cref();
    } else {
      return QListWidget::selectedIndexes();
    }
  }

  //  [adaptor impl] void QListWidget::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  void cbs_selectionChanged_5346_0(const QItemSelection &selected, const QItemSelection &deselected)
  {
    QListWidget::selectionChanged(selected, deselected);
  }

  virtual void selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  {
    if (cb_selectionChanged_5346_0.can_issue()) {
      cb_selectionChanged_5346_0.issue<QListWidget_Adaptor, const QItemSelection &, const QItemSelection &>(&QListWidget_Adaptor::cbs_selectionChanged_5346_0, selected, deselected);
    } else {
      QListWidget::selectionChanged(selected, deselected);
    }
  }

  //  [adaptor impl] QFlags<QItemSelectionModel::SelectionFlag> QListWidget::selectionCommand(const QModelIndex &index, const QEvent *event)
  qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type cbs_selectionCommand_c4199_1(const QModelIndex &index, const QEvent *event) const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(QListWidget::selectionCommand(index, event));
  }

  virtual QFlags<QItemSelectionModel::SelectionFlag> selectionCommand(const QModelIndex &index, const QEvent *event) const
  {
    if (cb_selectionCommand_c4199_1.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(cb_selectionCommand_c4199_1.issue<QListWidget_Adaptor, qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type, const QModelIndex &, const QEvent *>(&QListWidget_Adaptor::cbs_selectionCommand_c4199_1, index, event)).cref();
    } else {
      return QListWidget::selectionCommand(index, event);
    }
  }

  //  [adaptor impl] void QListWidget::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  void cbs_setSelection_6155_0(const QRect &rect, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & command)
  {
    QListWidget::setSelection(rect, qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(command).cref());
  }

  virtual void setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    if (cb_setSelection_6155_0.can_issue()) {
      cb_setSelection_6155_0.issue<QListWidget_Adaptor, const QRect &, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type &>(&QListWidget_Adaptor::cbs_setSelection_6155_0, rect, qt_gsi::CppToQtAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(command));
    } else {
      QListWidget::setSelection(rect, command);
    }
  }

  //  [adaptor impl] void QListWidget::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QListWidget::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QListWidget_Adaptor, QShowEvent *>(&QListWidget_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QListWidget::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::startDrag(QFlags<Qt::DropAction> supportedActions)
  void cbs_startDrag_2456_0(const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & supportedActions)
  {
    QListWidget::startDrag(qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(supportedActions).cref());
  }

  virtual void startDrag(QFlags<Qt::DropAction> supportedActions)
  {
    if (cb_startDrag_2456_0.can_issue()) {
      cb_startDrag_2456_0.issue<QListWidget_Adaptor, const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type &>(&QListWidget_Adaptor::cbs_startDrag_2456_0, qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(supportedActions));
    } else {
      QListWidget::startDrag(supportedActions);
    }
  }

  //  [adaptor impl] void QListWidget::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QListWidget::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QListWidget_Adaptor, QStyle &>(&QListWidget_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QListWidget::styleChange(arg1);
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QListWidget::supportedDropActions()
  qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type cbs_supportedDropActions_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(QListWidget::supportedDropActions());
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(cb_supportedDropActions_c0_0.issue<QListWidget_Adaptor, qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type>(&QListWidget_Adaptor::cbs_supportedDropActions_c0_0)).cref();
    } else {
      return QListWidget::supportedDropActions();
    }
  }

  //  [adaptor impl] void QListWidget::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QListWidget::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QListWidget_Adaptor, QTabletEvent *>(&QListWidget_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QListWidget::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::timerEvent(QTimerEvent *e)
  void cbs_timerEvent_1730_0(QTimerEvent *e)
  {
    QListWidget::timerEvent(e);
  }

  virtual void timerEvent(QTimerEvent *e)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QListWidget_Adaptor, QTimerEvent *>(&QListWidget_Adaptor::cbs_timerEvent_1730_0, e);
    } else {
      QListWidget::timerEvent(e);
    }
  }

  //  [adaptor impl] void QListWidget::updateEditorData()
  void cbs_updateEditorData_0_0()
  {
    QListWidget::updateEditorData();
  }

  virtual void updateEditorData()
  {
    if (cb_updateEditorData_0_0.can_issue()) {
      cb_updateEditorData_0_0.issue<QListWidget_Adaptor>(&QListWidget_Adaptor::cbs_updateEditorData_0_0);
    } else {
      QListWidget::updateEditorData();
    }
  }

  //  [adaptor impl] void QListWidget::updateEditorGeometries()
  void cbs_updateEditorGeometries_0_0()
  {
    QListWidget::updateEditorGeometries();
  }

  virtual void updateEditorGeometries()
  {
    if (cb_updateEditorGeometries_0_0.can_issue()) {
      cb_updateEditorGeometries_0_0.issue<QListWidget_Adaptor>(&QListWidget_Adaptor::cbs_updateEditorGeometries_0_0);
    } else {
      QListWidget::updateEditorGeometries();
    }
  }

  //  [adaptor impl] void QListWidget::updateGeometries()
  void cbs_updateGeometries_0_0()
  {
    QListWidget::updateGeometries();
  }

  virtual void updateGeometries()
  {
    if (cb_updateGeometries_0_0.can_issue()) {
      cb_updateGeometries_0_0.issue<QListWidget_Adaptor>(&QListWidget_Adaptor::cbs_updateGeometries_0_0);
    } else {
      QListWidget::updateGeometries();
    }
  }

  //  [adaptor impl] int QListWidget::verticalOffset()
  int cbs_verticalOffset_c0_0() const
  {
    return QListWidget::verticalOffset();
  }

  virtual int verticalOffset() const
  {
    if (cb_verticalOffset_c0_0.can_issue()) {
      return cb_verticalOffset_c0_0.issue<QListWidget_Adaptor, int>(&QListWidget_Adaptor::cbs_verticalOffset_c0_0);
    } else {
      return QListWidget::verticalOffset();
    }
  }

  //  [adaptor impl] void QListWidget::verticalScrollbarAction(int action)
  void cbs_verticalScrollbarAction_767_0(int action)
  {
    QListWidget::verticalScrollbarAction(action);
  }

  virtual void verticalScrollbarAction(int action)
  {
    if (cb_verticalScrollbarAction_767_0.can_issue()) {
      cb_verticalScrollbarAction_767_0.issue<QListWidget_Adaptor, int>(&QListWidget_Adaptor::cbs_verticalScrollbarAction_767_0, action);
    } else {
      QListWidget::verticalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QListWidget::verticalScrollbarValueChanged(int value)
  void cbs_verticalScrollbarValueChanged_767_0(int value)
  {
    QListWidget::verticalScrollbarValueChanged(value);
  }

  virtual void verticalScrollbarValueChanged(int value)
  {
    if (cb_verticalScrollbarValueChanged_767_0.can_issue()) {
      cb_verticalScrollbarValueChanged_767_0.issue<QListWidget_Adaptor, int>(&QListWidget_Adaptor::cbs_verticalScrollbarValueChanged_767_0, value);
    } else {
      QListWidget::verticalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] QStyleOptionViewItem QListWidget::viewOptions()
  QStyleOptionViewItem cbs_viewOptions_c0_0() const
  {
    return QListWidget::viewOptions();
  }

  virtual QStyleOptionViewItem viewOptions() const
  {
    if (cb_viewOptions_c0_0.can_issue()) {
      return cb_viewOptions_c0_0.issue<QListWidget_Adaptor, QStyleOptionViewItem>(&QListWidget_Adaptor::cbs_viewOptions_c0_0);
    } else {
      return QListWidget::viewOptions();
    }
  }

  //  [adaptor impl] bool QListWidget::viewportEvent(QEvent *event)
  bool cbs_viewportEvent_1217_0(QEvent *event)
  {
    return QListWidget::viewportEvent(event);
  }

  virtual bool viewportEvent(QEvent *event)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QListWidget_Adaptor, bool, QEvent *>(&QListWidget_Adaptor::cbs_viewportEvent_1217_0, event);
    } else {
      return QListWidget::viewportEvent(event);
    }
  }

  //  [adaptor impl] QRegion QListWidget::visualRegionForSelection(const QItemSelection &selection)
  QRegion cbs_visualRegionForSelection_c2727_0(const QItemSelection &selection) const
  {
    return QListWidget::visualRegionForSelection(selection);
  }

  virtual QRegion visualRegionForSelection(const QItemSelection &selection) const
  {
    if (cb_visualRegionForSelection_c2727_0.can_issue()) {
      return cb_visualRegionForSelection_c2727_0.issue<QListWidget_Adaptor, QRegion, const QItemSelection &>(&QListWidget_Adaptor::cbs_visualRegionForSelection_c2727_0, selection);
    } else {
      return QListWidget::visualRegionForSelection(selection);
    }
  }

  //  [adaptor impl] void QListWidget::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QListWidget::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QListWidget_Adaptor, QWheelEvent *>(&QListWidget_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QListWidget::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QListWidget::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QListWidget::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QListWidget_Adaptor, bool>(&QListWidget_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QListWidget::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_doItemsLayout_0_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexAt_c1916_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_keyboardSearch_2025_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_scrollTo_5576_1;
  gsi::Callback cb_selectAll_0_0;
  gsi::Callback cb_setRootIndex_2395_0;
  gsi::Callback cb_setSelectionModel_2533_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_sizeHintForColumn_c767_0;
  gsi::Callback cb_sizeHintForRow_c767_0;
  gsi::Callback cb_visualRect_c2395_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEditor_4926_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_commitData_1315_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_currentChanged_4682_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_dataChanged_4682_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropMimeData_4479_0;
  gsi::Callback cb_edit_6773_0;
  gsi::Callback cb_editorDestroyed_1302_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_horizontalOffset_c0_0;
  gsi::Callback cb_horizontalScrollbarAction_767_0;
  gsi::Callback cb_horizontalScrollbarValueChanged_767_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_isIndexHidden_c2395_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mimeData_c3436_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveCursor_6476_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_rowsAboutToBeRemoved_3713_0;
  gsi::Callback cb_rowsInserted_3713_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_selectedIndexes_c0_0;
  gsi::Callback cb_selectionChanged_5346_0;
  gsi::Callback cb_selectionCommand_c4199_1;
  gsi::Callback cb_setSelection_6155_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_startDrag_2456_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateEditorData_0_0;
  gsi::Callback cb_updateEditorGeometries_0_0;
  gsi::Callback cb_updateGeometries_0_0;
  gsi::Callback cb_verticalOffset_c0_0;
  gsi::Callback cb_verticalScrollbarAction_767_0;
  gsi::Callback cb_verticalScrollbarValueChanged_767_0;
  gsi::Callback cb_viewOptions_c0_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_visualRegionForSelection_c2727_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QListWidget_Adaptor::~QListWidget_Adaptor() { }

//  Constructor QListWidget::QListWidget(QWidget *parent) (adaptor class)

static void _init_ctor_QListWidget_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QListWidget_Adaptor *> ();
}

static void _call_ctor_QListWidget_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QListWidget_Adaptor *> (new QListWidget_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QListWidget_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QListWidget::QListWidget(QWidget *parent)\nThis method creates an object of class QListWidget.", &_init_ctor_QListWidget_Adaptor_1315, &_call_ctor_QListWidget_Adaptor_1315);
}

// QSize QListWidget::contentsSize()

static void _init_fp_contentsSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_fp_contentsSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QListWidget_Adaptor *)cls)->fp_QListWidget_contentsSize_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_contentsSize_c0 ()
{
  return new qt_gsi::GenericMethod("*contentsSize", "@brief Method QSize QListWidget::contentsSize()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_contentsSize_c0, &_call_fp_contentsSize_c0);
}


// void QListWidget::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QListWidget::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QListWidget::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QListWidget::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// QPoint QListWidget::dirtyRegionOffset()

static void _init_fp_dirtyRegionOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_fp_dirtyRegionOffset_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint > ((QPoint)((QListWidget_Adaptor *)cls)->fp_QListWidget_dirtyRegionOffset_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_dirtyRegionOffset_c0 ()
{
  return new qt_gsi::GenericMethod("*dirtyRegionOffset", "@brief Method QPoint QListWidget::dirtyRegionOffset()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dirtyRegionOffset_c0, &_call_fp_dirtyRegionOffset_c0);
}


// void QListWidget::doAutoScroll()

static void _init_fp_doAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_doAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_doAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_doAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*doAutoScroll", "@brief Method void QListWidget::doAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_doAutoScroll_0, &_call_fp_doAutoScroll_0);
}


// void QListWidget::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_drawFrame_1426 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_drawFrame_1426 ()
{
  return new qt_gsi::GenericMethod("*drawFrame", "@brief Method void QListWidget::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
}


// QAbstractItemView::DropIndicatorPosition QListWidget::dropIndicatorPosition()

static void _init_fp_dropIndicatorPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_dropIndicatorPosition_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QListWidget_Adaptor *)cls)->fp_QListWidget_dropIndicatorPosition_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_dropIndicatorPosition_c0 ()
{
  return new qt_gsi::GenericMethod("*dropIndicatorPosition", "@brief Method QAbstractItemView::DropIndicatorPosition QListWidget::dropIndicatorPosition()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dropIndicatorPosition_c0, &_call_fp_dropIndicatorPosition_c0);
}


// void QListWidget::executeDelayedItemsLayout()

static void _init_fp_executeDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_executeDelayedItemsLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_executeDelayedItemsLayout_0 ();
}

static qt_gsi::GenericMethod*_create_fp_executeDelayedItemsLayout_0 ()
{
  return new qt_gsi::GenericMethod("*executeDelayedItemsLayout", "@brief Method void QListWidget::executeDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_executeDelayedItemsLayout_0, &_call_fp_executeDelayedItemsLayout_0);
}


// bool QListWidget::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QListWidget_Adaptor *)cls)->fp_QListWidget_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QListWidget::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QListWidget::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QListWidget_Adaptor *)cls)->fp_QListWidget_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QListWidget::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QListWidget::horizontalStepsPerItem()

static void _init_fp_horizontalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_horizontalStepsPerItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QListWidget_Adaptor *)cls)->fp_QListWidget_horizontalStepsPerItem_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_horizontalStepsPerItem_c0 ()
{
  return new qt_gsi::GenericMethod("*horizontalStepsPerItem", "@brief Method int QListWidget::horizontalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_horizontalStepsPerItem_c0, &_call_fp_horizontalStepsPerItem_c0);
}


// QModelIndex QListWidget::indexFromItem(QListWidgetItem *item)

static void _init_fp_indexFromItem_c2126 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QListWidgetItem * > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_indexFromItem_c2126 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QListWidgetItem *arg1 = args.read<QListWidgetItem * > ();
  ret.write<QModelIndex > ((QModelIndex)((QListWidget_Adaptor *)cls)->fp_QListWidget_indexFromItem_c2126 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_indexFromItem_c2126 ()
{
  return new qt_gsi::GenericMethod("*indexFromItem", "@brief Method QModelIndex QListWidget::indexFromItem(QListWidgetItem *item)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_indexFromItem_c2126, &_call_fp_indexFromItem_c2126);
}


// void QListWidget::internalDrag(QFlags<Qt::DropAction> supportedActions)

static void _init_fp_internalDrag_2456 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("supportedActions");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_internalDrag_2456 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_internalDrag_2456 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_internalDrag_2456 ()
{
  return new qt_gsi::GenericMethod("*internalDrag", "@brief Method void QListWidget::internalDrag(QFlags<Qt::DropAction> supportedActions)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_internalDrag_2456, &_call_fp_internalDrag_2456);
}


// void QListWidget::internalDrop(QDropEvent *e)

static void _init_fp_internalDrop_1622 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_internalDrop_1622 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_internalDrop_1622 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_internalDrop_1622 ()
{
  return new qt_gsi::GenericMethod("*internalDrop", "@brief Method void QListWidget::internalDrop(QDropEvent *e)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_internalDrop_1622, &_call_fp_internalDrop_1622);
}


// QListWidgetItem *QListWidget::itemFromIndex(const QModelIndex &index)

static void _init_fp_itemFromIndex_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QListWidgetItem * > ();
}

static void _call_fp_itemFromIndex_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QListWidgetItem * > ((QListWidgetItem *)((QListWidget_Adaptor *)cls)->fp_QListWidget_itemFromIndex_c2395 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_itemFromIndex_c2395 ()
{
  return new qt_gsi::GenericMethod("*itemFromIndex", "@brief Method QListWidgetItem *QListWidget::itemFromIndex(const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_itemFromIndex_c2395, &_call_fp_itemFromIndex_c2395);
}


// QList<QListWidgetItem *> QListWidget::items(const QMimeData *data)

static void _init_fp_items_c2168 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QListWidgetItem *> >::target_type > ();
}

static void _call_fp_items_c2168 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMimeData *arg1 = args.read<const QMimeData * > ();
  ret.write<qt_gsi::Converter<QList<QListWidgetItem *> >::target_type > ((qt_gsi::Converter<QList<QListWidgetItem *> >::target_type)((QListWidget_Adaptor *)cls)->fp_QListWidget_items_c2168 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_items_c2168 ()
{
  return new qt_gsi::GenericMethod("*items", "@brief Method QList<QListWidgetItem *> QListWidget::items(const QMimeData *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_items_c2168, &_call_fp_items_c2168);
}


// int QListWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QListWidget_Adaptor *)cls)->fp_QListWidget_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QListWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QRect QListWidget::rectForIndex(const QModelIndex &index)

static void _init_fp_rectForIndex_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_fp_rectForIndex_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QRect > ((QRect)((QListWidget_Adaptor *)cls)->fp_QListWidget_rectForIndex_c2395 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_rectForIndex_c2395 ()
{
  return new qt_gsi::GenericMethod("*rectForIndex", "@brief Method QRect QListWidget::rectForIndex(const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_rectForIndex_c2395, &_call_fp_rectForIndex_c2395);
}


// void QListWidget::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QListWidget::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// void QListWidget::resizeContents(int width, int height)

static void _init_fp_resizeContents_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("height");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_resizeContents_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_resizeContents_1426 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_resizeContents_1426 ()
{
  return new qt_gsi::GenericMethod("*resizeContents", "@brief Method void QListWidget::resizeContents(int width, int height)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resizeContents_1426, &_call_fp_resizeContents_1426);
}


// void QListWidget::scheduleDelayedItemsLayout()

static void _init_fp_scheduleDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_scheduleDelayedItemsLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_scheduleDelayedItemsLayout_0 ();
}

static qt_gsi::GenericMethod*_create_fp_scheduleDelayedItemsLayout_0 ()
{
  return new qt_gsi::GenericMethod("*scheduleDelayedItemsLayout", "@brief Method void QListWidget::scheduleDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scheduleDelayedItemsLayout_0, &_call_fp_scheduleDelayedItemsLayout_0);
}


// void QListWidget::scrollDirtyRegion(int dx, int dy)

static void _init_fp_scrollDirtyRegion_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_scrollDirtyRegion_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_scrollDirtyRegion_1426 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_scrollDirtyRegion_1426 ()
{
  return new qt_gsi::GenericMethod("*scrollDirtyRegion", "@brief Method void QListWidget::scrollDirtyRegion(int dx, int dy)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scrollDirtyRegion_1426, &_call_fp_scrollDirtyRegion_1426);
}


// QObject *QListWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QListWidget_Adaptor *)cls)->fp_QListWidget_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QListWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QListWidget::setDirtyRegion(const QRegion &region)

static void _init_fp_setDirtyRegion_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setDirtyRegion_2006 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_setDirtyRegion_2006 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setDirtyRegion_2006 ()
{
  return new qt_gsi::GenericMethod("*setDirtyRegion", "@brief Method void QListWidget::setDirtyRegion(const QRegion &region)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setDirtyRegion_2006, &_call_fp_setDirtyRegion_2006);
}


// void QListWidget::setHorizontalStepsPerItem(int steps)

static void _init_fp_setHorizontalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setHorizontalStepsPerItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_setHorizontalStepsPerItem_767 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setHorizontalStepsPerItem_767 ()
{
  return new qt_gsi::GenericMethod("*setHorizontalStepsPerItem", "@brief Method void QListWidget::setHorizontalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setHorizontalStepsPerItem_767, &_call_fp_setHorizontalStepsPerItem_767);
}


// void QListWidget::setPositionForIndex(const QPoint &position, const QModelIndex &index)

static void _init_fp_setPositionForIndex_4203 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_setPositionForIndex_4203 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_setPositionForIndex_4203 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_setPositionForIndex_4203 ()
{
  return new qt_gsi::GenericMethod("*setPositionForIndex", "@brief Method void QListWidget::setPositionForIndex(const QPoint &position, const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setPositionForIndex_4203, &_call_fp_setPositionForIndex_4203);
}


// void QListWidget::setState(QAbstractItemView::State state)

static void _init_fp_setState_2776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setState_2776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_setState_2776 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setState_2776 ()
{
  return new qt_gsi::GenericMethod("*setState", "@brief Method void QListWidget::setState(QAbstractItemView::State state)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setState_2776, &_call_fp_setState_2776);
}


// void QListWidget::setVerticalStepsPerItem(int steps)

static void _init_fp_setVerticalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setVerticalStepsPerItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_setVerticalStepsPerItem_767 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setVerticalStepsPerItem_767 ()
{
  return new qt_gsi::GenericMethod("*setVerticalStepsPerItem", "@brief Method void QListWidget::setVerticalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setVerticalStepsPerItem_767, &_call_fp_setVerticalStepsPerItem_767);
}


// void QListWidget::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2744 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QListWidget::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
}


// void QListWidget::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMargins &arg1 = args.read<const QMargins & > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_setViewportMargins_2115 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2115 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QListWidget::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
}


// void QListWidget::setupViewport(QWidget *viewport)

static void _init_fp_setupViewport_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setupViewport_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_setupViewport_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setupViewport_1315 ()
{
  return new qt_gsi::GenericMethod("*setupViewport", "@brief Method void QListWidget::setupViewport(QWidget *viewport)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setupViewport_1315, &_call_fp_setupViewport_1315);
}


// void QListWidget::startAutoScroll()

static void _init_fp_startAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_startAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_startAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_startAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*startAutoScroll", "@brief Method void QListWidget::startAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_startAutoScroll_0, &_call_fp_startAutoScroll_0);
}


// QAbstractItemView::State QListWidget::state()

static void _init_fp_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_state_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QListWidget_Adaptor *)cls)->fp_QListWidget_state_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_state_c0 ()
{
  return new qt_gsi::GenericMethod("*state", "@brief Method QAbstractItemView::State QListWidget::state()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_state_c0, &_call_fp_state_c0);
}


// void QListWidget::stopAutoScroll()

static void _init_fp_stopAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_stopAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_stopAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_stopAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*stopAutoScroll", "@brief Method void QListWidget::stopAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_stopAutoScroll_0, &_call_fp_stopAutoScroll_0);
}


// void QListWidget::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->fp_QListWidget_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QListWidget::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// int QListWidget::verticalStepsPerItem()

static void _init_fp_verticalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_verticalStepsPerItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QListWidget_Adaptor *)cls)->fp_QListWidget_verticalStepsPerItem_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_verticalStepsPerItem_c0 ()
{
  return new qt_gsi::GenericMethod("*verticalStepsPerItem", "@brief Method int QListWidget::verticalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_verticalStepsPerItem_c0, &_call_fp_verticalStepsPerItem_c0);
}


// void QListWidget::doItemsLayout()

static void _init_cbs_doItemsLayout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_doItemsLayout_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->cbs_doItemsLayout_0_0 ();
}

static void _set_callback_cbs_doItemsLayout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_doItemsLayout_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_doItemsLayout_0_0 ()
{
  return new qt_gsi::GenericMethod ("doItemsLayout", "@hide", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_doItemsLayout_0_0 ()
{
  return new qt_gsi::GenericMethod ("doItemsLayout", "@brief Virtual method void QListWidget::doItemsLayout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0, &_set_callback_cbs_doItemsLayout_0_0);
}


// void QListWidget::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("dropEvent", "@brief Virtual method void QListWidget::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// bool QListWidget::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QListWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QListWidget::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QListWidget::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QListWidget_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QListWidget::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QModelIndex QListWidget::indexAt(const QPoint &p)

static void _init_cbs_indexAt_c1916_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_indexAt_c1916_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QModelIndex > ((QModelIndex)((QListWidget_Adaptor *)cls)->cbs_indexAt_c1916_0 (arg1));
}

static void _set_callback_cbs_indexAt_c1916_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_indexAt_c1916_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_indexAt_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("indexAt", "@hide", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_indexAt_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("indexAt", "@brief Virtual method QModelIndex QListWidget::indexAt(const QPoint &p)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0, &_set_callback_cbs_indexAt_c1916_0);
}


// QVariant QListWidget::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QListWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QListWidget::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// void QListWidget::keyboardSearch(const QString &search)

static void _init_cbs_keyboardSearch_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("search");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyboardSearch_2025_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QListWidget_Adaptor *)cls)->cbs_keyboardSearch_2025_0 (arg1);
}

static void _set_callback_cbs_keyboardSearch_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_keyboardSearch_2025_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyboardSearch_2025_0 ()
{
  return new qt_gsi::GenericMethod ("keyboardSearch", "@hide", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyboardSearch_2025_0 ()
{
  return new qt_gsi::GenericMethod ("keyboardSearch", "@brief Virtual method void QListWidget::keyboardSearch(const QString &search)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0, &_set_callback_cbs_keyboardSearch_2025_0);
}


// QSize QListWidget::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QListWidget_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QListWidget::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QListWidget::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QListWidget_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QListWidget::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QListWidget::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_reset_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QListWidget::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
}


// void QListWidget::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)

static void _init_cbs_scrollTo_5576_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollTo_5576_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > ();
  ((QListWidget_Adaptor *)cls)->cbs_scrollTo_5576_1 (arg1, arg2);
}

static void _set_callback_cbs_scrollTo_5576_1 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_scrollTo_5576_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_scrollTo_5576_1 ()
{
  return new qt_gsi::GenericMethod ("scrollTo", "@hide", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_scrollTo_5576_1 ()
{
  return new qt_gsi::GenericMethod ("scrollTo", "@brief Virtual method void QListWidget::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1, &_set_callback_cbs_scrollTo_5576_1);
}


// void QListWidget::selectAll()

static void _init_cbs_selectAll_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_selectAll_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->cbs_selectAll_0_0 ();
}

static void _set_callback_cbs_selectAll_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_selectAll_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectAll_0_0 ()
{
  return new qt_gsi::GenericMethod ("selectAll", "@hide", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectAll_0_0 ()
{
  return new qt_gsi::GenericMethod ("selectAll", "@brief Virtual method void QListWidget::selectAll()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0, &_set_callback_cbs_selectAll_0_0);
}


// void QListWidget::setRootIndex(const QModelIndex &index)

static void _init_cbs_setRootIndex_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setRootIndex_2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QListWidget_Adaptor *)cls)->cbs_setRootIndex_2395_0 (arg1);
}

static void _set_callback_cbs_setRootIndex_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_setRootIndex_2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setRootIndex_2395_0 ()
{
  return new qt_gsi::GenericMethod ("setRootIndex", "@hide", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setRootIndex_2395_0 ()
{
  return new qt_gsi::GenericMethod ("setRootIndex", "@brief Virtual method void QListWidget::setRootIndex(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0, &_set_callback_cbs_setRootIndex_2395_0);
}


// void QListWidget::setSelectionModel(QItemSelectionModel *selectionModel)

static void _init_cbs_setSelectionModel_2533_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionModel");
  decl->add_arg<QItemSelectionModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSelectionModel_2533_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QItemSelectionModel *arg1 = args.read<QItemSelectionModel * > ();
  ((QListWidget_Adaptor *)cls)->cbs_setSelectionModel_2533_0 (arg1);
}

static void _set_callback_cbs_setSelectionModel_2533_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_setSelectionModel_2533_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setSelectionModel_2533_0 ()
{
  return new qt_gsi::GenericMethod ("setSelectionModel", "@hide", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setSelectionModel_2533_0 ()
{
  return new qt_gsi::GenericMethod ("setSelectionModel", "@brief Virtual method void QListWidget::setSelectionModel(QItemSelectionModel *selectionModel)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0, &_set_callback_cbs_setSelectionModel_2533_0);
}


// void QListWidget::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QListWidget_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QListWidget::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QListWidget::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QListWidget_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QListWidget::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// int QListWidget::sizeHintForColumn(int column)

static void _init_cbs_sizeHintForColumn_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForColumn_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QListWidget_Adaptor *)cls)->cbs_sizeHintForColumn_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForColumn_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_sizeHintForColumn_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHintForColumn_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForColumn", "@hide", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHintForColumn_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForColumn", "@brief Virtual method int QListWidget::sizeHintForColumn(int column)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0, &_set_callback_cbs_sizeHintForColumn_c767_0);
}


// int QListWidget::sizeHintForRow(int row)

static void _init_cbs_sizeHintForRow_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForRow_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QListWidget_Adaptor *)cls)->cbs_sizeHintForRow_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForRow_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_sizeHintForRow_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHintForRow_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForRow", "@hide", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHintForRow_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForRow", "@brief Virtual method int QListWidget::sizeHintForRow(int row)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0, &_set_callback_cbs_sizeHintForRow_c767_0);
}


// QRect QListWidget::visualRect(const QModelIndex &index)

static void _init_cbs_visualRect_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_cbs_visualRect_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QRect > ((QRect)((QListWidget_Adaptor *)cls)->cbs_visualRect_c2395_0 (arg1));
}

static void _set_callback_cbs_visualRect_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_visualRect_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_visualRect_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("visualRect", "@hide", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_visualRect_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("visualRect", "@brief Virtual method QRect QListWidget::visualRect(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0, &_set_callback_cbs_visualRect_c2395_0);
}


// void QListWidget::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QListWidget::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QListWidget::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QListWidget::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QListWidget::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QListWidget::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QListWidget::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)

static void _init_cbs_closeEditor_4926_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_closeEditor_4926_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > ();
  ((QListWidget_Adaptor *)cls)->cbs_closeEditor_4926_0 (arg1, arg2);
}

static void _set_callback_cbs_closeEditor_4926_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_closeEditor_4926_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEditor_4926_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEditor", "@hide", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEditor_4926_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEditor", "@brief Virtual method void QListWidget::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0, &_set_callback_cbs_closeEditor_4926_0);
}


// void QListWidget::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QListWidget::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QListWidget::commitData(QWidget *editor)

static void _init_cbs_commitData_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_commitData_1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QListWidget_Adaptor *)cls)->cbs_commitData_1315_0 (arg1);
}

static void _set_callback_cbs_commitData_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_commitData_1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_commitData_1315_0 ()
{
  return new qt_gsi::GenericMethod ("*commitData", "@hide", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_commitData_1315_0 ()
{
  return new qt_gsi::GenericMethod ("*commitData", "@brief Virtual method void QListWidget::commitData(QWidget *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0, &_set_callback_cbs_commitData_1315_0);
}


// void QListWidget::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QListWidget::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QListWidget::currentChanged(const QModelIndex &current, const QModelIndex &previous)

static void _init_cbs_currentChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("previous");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_currentChanged_4682_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QListWidget_Adaptor *)cls)->cbs_currentChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_currentChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_currentChanged_4682_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_currentChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*currentChanged", "@hide", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_currentChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*currentChanged", "@brief Virtual method void QListWidget::currentChanged(const QModelIndex &current, const QModelIndex &previous)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0, &_set_callback_cbs_currentChanged_4682_0);
}


// void QListWidget::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QListWidget::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QListWidget::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)

static void _init_cbs_dataChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_dataChanged_4682_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QListWidget_Adaptor *)cls)->cbs_dataChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_dataChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_dataChanged_4682_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dataChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*dataChanged", "@hide", false, &_init_cbs_dataChanged_4682_0, &_call_cbs_dataChanged_4682_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dataChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*dataChanged", "@brief Virtual method void QListWidget::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dataChanged_4682_0, &_call_cbs_dataChanged_4682_0, &_set_callback_cbs_dataChanged_4682_0);
}


// void QListWidget::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QListWidget_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QListWidget::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QListWidget::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QListWidget::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QListWidget::dragLeaveEvent(QDragLeaveEvent *e)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QListWidget::dragLeaveEvent(QDragLeaveEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QListWidget::dragMoveEvent(QDragMoveEvent *e)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QListWidget::dragMoveEvent(QDragMoveEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// bool QListWidget::dropMimeData(int index, const QMimeData *data, Qt::DropAction action)

static void _init_cbs_dropMimeData_4479_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<const QMimeData * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_4479_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QMimeData *arg2 = args.read<const QMimeData * > ();
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > ();
  ret.write<bool > ((bool)((QListWidget_Adaptor *)cls)->cbs_dropMimeData_4479_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_dropMimeData_4479_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_dropMimeData_4479_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropMimeData_4479_0 ()
{
  return new qt_gsi::GenericMethod ("*dropMimeData", "@hide", false, &_init_cbs_dropMimeData_4479_0, &_call_cbs_dropMimeData_4479_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropMimeData_4479_0 ()
{
  return new qt_gsi::GenericMethod ("*dropMimeData", "@brief Virtual method bool QListWidget::dropMimeData(int index, const QMimeData *data, Qt::DropAction action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_4479_0, &_call_cbs_dropMimeData_4479_0, &_set_callback_cbs_dropMimeData_4479_0);
}


// bool QListWidget::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)

static void _init_cbs_edit_6773_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("trigger");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("event");
  decl->add_arg<QEvent * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_edit_6773_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > ();
  QEvent *arg3 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QListWidget_Adaptor *)cls)->cbs_edit_6773_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_edit_6773_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_edit_6773_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_edit_6773_0 ()
{
  return new qt_gsi::GenericMethod ("*edit", "@hide", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_edit_6773_0 ()
{
  return new qt_gsi::GenericMethod ("*edit", "@brief Virtual method bool QListWidget::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0, &_set_callback_cbs_edit_6773_0);
}


// void QListWidget::editorDestroyed(QObject *editor)

static void _init_cbs_editorDestroyed_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_editorDestroyed_1302_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ((QListWidget_Adaptor *)cls)->cbs_editorDestroyed_1302_0 (arg1);
}

static void _set_callback_cbs_editorDestroyed_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_editorDestroyed_1302_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_editorDestroyed_1302_0 ()
{
  return new qt_gsi::GenericMethod ("*editorDestroyed", "@hide", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_editorDestroyed_1302_0 ()
{
  return new qt_gsi::GenericMethod ("*editorDestroyed", "@brief Virtual method void QListWidget::editorDestroyed(QObject *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0, &_set_callback_cbs_editorDestroyed_1302_0);
}


// void QListWidget::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QListWidget_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QListWidget::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QListWidget::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QListWidget::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QListWidget::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QListWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QListWidget::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QListWidget::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QListWidget::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QListWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QListWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QListWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QListWidget::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QListWidget::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QListWidget::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QListWidget_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QListWidget::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QListWidget::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QListWidget::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// int QListWidget::horizontalOffset()

static void _init_cbs_horizontalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_horizontalOffset_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QListWidget_Adaptor *)cls)->cbs_horizontalOffset_c0_0 ());
}

static void _set_callback_cbs_horizontalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_horizontalOffset_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalOffset", "@hide", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalOffset", "@brief Virtual method int QListWidget::horizontalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0, &_set_callback_cbs_horizontalOffset_c0_0);
}


// void QListWidget::horizontalScrollbarAction(int action)

static void _init_cbs_horizontalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarAction_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QListWidget_Adaptor *)cls)->cbs_horizontalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_horizontalScrollbarAction_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@hide", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@brief Virtual method void QListWidget::horizontalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0, &_set_callback_cbs_horizontalScrollbarAction_767_0);
}


// void QListWidget::horizontalScrollbarValueChanged(int value)

static void _init_cbs_horizontalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QListWidget_Adaptor *)cls)->cbs_horizontalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_horizontalScrollbarValueChanged_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@hide", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@brief Virtual method void QListWidget::horizontalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0, &_set_callback_cbs_horizontalScrollbarValueChanged_767_0);
}


// void QListWidget::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QListWidget::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// bool QListWidget::isIndexHidden(const QModelIndex &index)

static void _init_cbs_isIndexHidden_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isIndexHidden_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QListWidget_Adaptor *)cls)->cbs_isIndexHidden_c2395_0 (arg1));
}

static void _set_callback_cbs_isIndexHidden_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_isIndexHidden_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isIndexHidden_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("*isIndexHidden", "@hide", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isIndexHidden_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("*isIndexHidden", "@brief Virtual method bool QListWidget::isIndexHidden(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0, &_set_callback_cbs_isIndexHidden_c2395_0);
}


// void QListWidget::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QListWidget::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QListWidget::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QListWidget::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QListWidget::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QListWidget::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QListWidget::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QListWidget::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QListWidget::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QListWidget_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QListWidget::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// QMimeData *QListWidget::mimeData(const QList<QListWidgetItem *> items)

static void _init_cbs_mimeData_c3436_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const qt_gsi::Converter<QList<QListWidgetItem *> >::target_type & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3436_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QListWidgetItem *> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QListWidgetItem *> >::target_type & > ();
  ret.write<QMimeData * > ((QMimeData *)((QListWidget_Adaptor *)cls)->cbs_mimeData_c3436_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3436_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_mimeData_c3436_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeData_c3436_0 ()
{
  return new qt_gsi::GenericMethod ("*mimeData", "@hide", true, &_init_cbs_mimeData_c3436_0, &_call_cbs_mimeData_c3436_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeData_c3436_0 ()
{
  return new qt_gsi::GenericMethod ("*mimeData", "@brief Virtual method QMimeData *QListWidget::mimeData(const QList<QListWidgetItem *> items)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3436_0, &_call_cbs_mimeData_c3436_0, &_set_callback_cbs_mimeData_c3436_0);
}


// QStringList QListWidget::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)((QListWidget_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*mimeTypes", "@brief Virtual method QStringList QListWidget::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
}


// void QListWidget::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QListWidget::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QListWidget::mouseMoveEvent(QMouseEvent *e)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QListWidget::mouseMoveEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QListWidget::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QListWidget::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QListWidget::mouseReleaseEvent(QMouseEvent *e)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QListWidget::mouseReleaseEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// QModelIndex QListWidget::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)

static void _init_cbs_moveCursor_6476_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursorAction");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("modifiers");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & > (argspec_1);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_moveCursor_6476_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & > ();
  ret.write<QModelIndex > ((QModelIndex)((QListWidget_Adaptor *)cls)->cbs_moveCursor_6476_0 (arg1, arg2));
}

static void _set_callback_cbs_moveCursor_6476_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_moveCursor_6476_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveCursor_6476_0 ()
{
  return new qt_gsi::GenericMethod ("*moveCursor", "@hide", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveCursor_6476_0 ()
{
  return new qt_gsi::GenericMethod ("*moveCursor", "@brief Virtual method QModelIndex QListWidget::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0, &_set_callback_cbs_moveCursor_6476_0);
}


// void QListWidget::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QListWidget::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QListWidget::paintEvent(QPaintEvent *e)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QListWidget::paintEvent(QPaintEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QListWidget::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QListWidget_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QListWidget::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QListWidget::resizeEvent(QResizeEvent *e)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QListWidget::resizeEvent(QResizeEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QListWidget::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsAboutToBeRemoved_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsAboutToBeRemoved_3713_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QListWidget_Adaptor *)cls)->cbs_rowsAboutToBeRemoved_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsAboutToBeRemoved_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_rowsAboutToBeRemoved_3713_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowsAboutToBeRemoved_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@hide", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowsAboutToBeRemoved_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@brief Virtual method void QListWidget::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0, &_set_callback_cbs_rowsAboutToBeRemoved_3713_0);
}


// void QListWidget::rowsInserted(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsInserted_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsInserted_3713_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QListWidget_Adaptor *)cls)->cbs_rowsInserted_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsInserted_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_rowsInserted_3713_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowsInserted_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsInserted", "@hide", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowsInserted_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsInserted", "@brief Virtual method void QListWidget::rowsInserted(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0, &_set_callback_cbs_rowsInserted_3713_0);
}


// void QListWidget::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QListWidget_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QListWidget::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
}


// QList<QModelIndex> QListWidget::selectedIndexes()

static void _init_cbs_selectedIndexes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_cbs_selectedIndexes_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QListWidget_Adaptor *)cls)->cbs_selectedIndexes_c0_0 ());
}

static void _set_callback_cbs_selectedIndexes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_selectedIndexes_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectedIndexes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*selectedIndexes", "@hide", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectedIndexes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*selectedIndexes", "@brief Virtual method QList<QModelIndex> QListWidget::selectedIndexes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0, &_set_callback_cbs_selectedIndexes_c0_0);
}


// void QListWidget::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)

static void _init_cbs_selectionChanged_5346_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selected");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deselected");
  decl->add_arg<const QItemSelection & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_selectionChanged_5346_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  const QItemSelection &arg2 = args.read<const QItemSelection & > ();
  ((QListWidget_Adaptor *)cls)->cbs_selectionChanged_5346_0 (arg1, arg2);
}

static void _set_callback_cbs_selectionChanged_5346_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_selectionChanged_5346_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectionChanged_5346_0 ()
{
  return new qt_gsi::GenericMethod ("*selectionChanged", "@hide", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectionChanged_5346_0 ()
{
  return new qt_gsi::GenericMethod ("*selectionChanged", "@brief Virtual method void QListWidget::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0, &_set_callback_cbs_selectionChanged_5346_0);
}


// QFlags<QItemSelectionModel::SelectionFlag> QListWidget::selectionCommand(const QModelIndex &index, const QEvent *event)

static void _init_cbs_selectionCommand_c4199_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<const QEvent * > (argspec_1);
  decl->set_return<qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type > ();
}

static void _call_cbs_selectionCommand_c4199_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QEvent *arg2 = args.read<const QEvent * > ();
  ret.write<qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type > ((qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type)((QListWidget_Adaptor *)cls)->cbs_selectionCommand_c4199_1 (arg1, arg2));
}

static void _set_callback_cbs_selectionCommand_c4199_1 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_selectionCommand_c4199_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectionCommand_c4199_1 ()
{
  return new qt_gsi::GenericMethod ("*selectionCommand", "@hide", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectionCommand_c4199_1 ()
{
  return new qt_gsi::GenericMethod ("*selectionCommand", "@brief Virtual method QFlags<QItemSelectionModel::SelectionFlag> QListWidget::selectionCommand(const QModelIndex &index, const QEvent *event)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1, &_set_callback_cbs_selectionCommand_c4199_1);
}


// void QListWidget::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)

static void _init_cbs_setSelection_6155_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setSelection_6155_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QListWidget_Adaptor *)cls)->cbs_setSelection_6155_0 (arg1, arg2);
}

static void _set_callback_cbs_setSelection_6155_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_setSelection_6155_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setSelection_6155_0 ()
{
  return new qt_gsi::GenericMethod ("*setSelection", "@hide", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setSelection_6155_0 ()
{
  return new qt_gsi::GenericMethod ("*setSelection", "@brief Virtual method void QListWidget::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0, &_set_callback_cbs_setSelection_6155_0);
}


// void QListWidget::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QListWidget::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QListWidget::startDrag(QFlags<Qt::DropAction> supportedActions)

static void _init_cbs_startDrag_2456_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("supportedActions");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_startDrag_2456_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > ();
  ((QListWidget_Adaptor *)cls)->cbs_startDrag_2456_0 (arg1);
}

static void _set_callback_cbs_startDrag_2456_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_startDrag_2456_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_startDrag_2456_0 ()
{
  return new qt_gsi::GenericMethod ("*startDrag", "@hide", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_startDrag_2456_0 ()
{
  return new qt_gsi::GenericMethod ("*startDrag", "@brief Virtual method void QListWidget::startDrag(QFlags<Qt::DropAction> supportedActions)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0, &_set_callback_cbs_startDrag_2456_0);
}


// void QListWidget::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QListWidget_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QListWidget::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// QFlags<Qt::DropAction> QListWidget::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ((qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type)((QListWidget_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QListWidget::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
}


// void QListWidget::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QListWidget::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QListWidget::timerEvent(QTimerEvent *e)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QListWidget::timerEvent(QTimerEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QListWidget::updateEditorData()

static void _init_cbs_updateEditorData_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorData_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->cbs_updateEditorData_0_0 ();
}

static void _set_callback_cbs_updateEditorData_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_updateEditorData_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateEditorData_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorData", "@hide", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateEditorData_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorData", "@brief Virtual method void QListWidget::updateEditorData()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0, &_set_callback_cbs_updateEditorData_0_0);
}


// void QListWidget::updateEditorGeometries()

static void _init_cbs_updateEditorGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometries_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->cbs_updateEditorGeometries_0_0 ();
}

static void _set_callback_cbs_updateEditorGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_updateEditorGeometries_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateEditorGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorGeometries", "@hide", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateEditorGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorGeometries", "@brief Virtual method void QListWidget::updateEditorGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0, &_set_callback_cbs_updateEditorGeometries_0_0);
}


// void QListWidget::updateGeometries()

static void _init_cbs_updateGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometries_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QListWidget_Adaptor *)cls)->cbs_updateGeometries_0_0 ();
}

static void _set_callback_cbs_updateGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_updateGeometries_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateGeometries", "@hide", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateGeometries", "@brief Virtual method void QListWidget::updateGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0, &_set_callback_cbs_updateGeometries_0_0);
}


// int QListWidget::verticalOffset()

static void _init_cbs_verticalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_verticalOffset_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QListWidget_Adaptor *)cls)->cbs_verticalOffset_c0_0 ());
}

static void _set_callback_cbs_verticalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_verticalOffset_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalOffset", "@hide", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalOffset", "@brief Virtual method int QListWidget::verticalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0, &_set_callback_cbs_verticalOffset_c0_0);
}


// void QListWidget::verticalScrollbarAction(int action)

static void _init_cbs_verticalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarAction_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QListWidget_Adaptor *)cls)->cbs_verticalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_verticalScrollbarAction_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@hide", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@brief Virtual method void QListWidget::verticalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0, &_set_callback_cbs_verticalScrollbarAction_767_0);
}


// void QListWidget::verticalScrollbarValueChanged(int value)

static void _init_cbs_verticalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QListWidget_Adaptor *)cls)->cbs_verticalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_verticalScrollbarValueChanged_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@hide", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@brief Virtual method void QListWidget::verticalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0, &_set_callback_cbs_verticalScrollbarValueChanged_767_0);
}


// QStyleOptionViewItem QListWidget::viewOptions()

static void _init_cbs_viewOptions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyleOptionViewItem > ();
}

static void _call_cbs_viewOptions_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStyleOptionViewItem > ((QStyleOptionViewItem)((QListWidget_Adaptor *)cls)->cbs_viewOptions_c0_0 ());
}

static void _set_callback_cbs_viewOptions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_viewOptions_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_viewOptions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*viewOptions", "@hide", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_viewOptions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*viewOptions", "@brief Virtual method QStyleOptionViewItem QListWidget::viewOptions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0, &_set_callback_cbs_viewOptions_c0_0);
}


// bool QListWidget::viewportEvent(QEvent *event)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QListWidget_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QListWidget::viewportEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
}


// QRegion QListWidget::visualRegionForSelection(const QItemSelection &selection)

static void _init_cbs_visualRegionForSelection_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QRegion > ();
}

static void _call_cbs_visualRegionForSelection_c2727_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  ret.write<QRegion > ((QRegion)((QListWidget_Adaptor *)cls)->cbs_visualRegionForSelection_c2727_0 (arg1));
}

static void _set_callback_cbs_visualRegionForSelection_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_visualRegionForSelection_c2727_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_visualRegionForSelection_c2727_0 ()
{
  return new qt_gsi::GenericMethod ("*visualRegionForSelection", "@hide", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_visualRegionForSelection_c2727_0 ()
{
  return new qt_gsi::GenericMethod ("*visualRegionForSelection", "@brief Virtual method QRegion QListWidget::visualRegionForSelection(const QItemSelection &selection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0, &_set_callback_cbs_visualRegionForSelection_c2727_0);
}


// void QListWidget::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QListWidget_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QListWidget::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QListWidget::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QListWidget_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidget_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QListWidget::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QListWidget> decl_QListWidget;

gsi::Class<QListWidget_Adaptor> decl_QListWidget_Adaptor (decl_QListWidget, "QListWidget",
  gsi::Methods(_create_fp_contentsSize_c0 ()) +
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_dirtyRegionOffset_c0 ()) +
  gsi::Methods(_create_fp_doAutoScroll_0 ()) +
  gsi::Methods(_create_fp_drawFrame_1426 ()) +
  gsi::Methods(_create_fp_dropIndicatorPosition_c0 ()) +
  gsi::Methods(_create_fp_executeDelayedItemsLayout_0 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_horizontalStepsPerItem_c0 ()) +
  gsi::Methods(_create_fp_indexFromItem_c2126 ()) +
  gsi::Methods(_create_fp_internalDrag_2456 ()) +
  gsi::Methods(_create_fp_internalDrop_1622 ()) +
  gsi::Methods(_create_fp_itemFromIndex_c2395 ()) +
  gsi::Methods(_create_fp_items_c2168 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_rectForIndex_c2395 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_resizeContents_1426 ()) +
  gsi::Methods(_create_fp_scheduleDelayedItemsLayout_0 ()) +
  gsi::Methods(_create_fp_scrollDirtyRegion_1426 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_setDirtyRegion_2006 ()) +
  gsi::Methods(_create_fp_setHorizontalStepsPerItem_767 ()) +
  gsi::Methods(_create_fp_setPositionForIndex_4203 ()) +
  gsi::Methods(_create_fp_setState_2776 ()) +
  gsi::Methods(_create_fp_setVerticalStepsPerItem_767 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2744 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2115 ()) +
  gsi::Methods(_create_fp_setupViewport_1315 ()) +
  gsi::Methods(_create_fp_startAutoScroll_0 ()) +
  gsi::Methods(_create_fp_state_c0 ()) +
  gsi::Methods(_create_fp_stopAutoScroll_0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_fp_verticalStepsPerItem_c0 ()) +
  gsi::Methods(_create_cbs_doItemsLayout_0_0 ()) +
  gsi::Methods(_create_callback_cbs_doItemsLayout_0_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_indexAt_c1916_0 ()) +
  gsi::Methods(_create_callback_cbs_indexAt_c1916_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_keyboardSearch_2025_0 ()) +
  gsi::Methods(_create_callback_cbs_keyboardSearch_2025_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_reset_0_0 ()) +
  gsi::Methods(_create_callback_cbs_reset_0_0 ()) +
  gsi::Methods(_create_cbs_scrollTo_5576_1 ()) +
  gsi::Methods(_create_callback_cbs_scrollTo_5576_1 ()) +
  gsi::Methods(_create_cbs_selectAll_0_0 ()) +
  gsi::Methods(_create_callback_cbs_selectAll_0_0 ()) +
  gsi::Methods(_create_cbs_setRootIndex_2395_0 ()) +
  gsi::Methods(_create_callback_cbs_setRootIndex_2395_0 ()) +
  gsi::Methods(_create_cbs_setSelectionModel_2533_0 ()) +
  gsi::Methods(_create_callback_cbs_setSelectionModel_2533_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_sizeHintForColumn_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHintForColumn_c767_0 ()) +
  gsi::Methods(_create_cbs_sizeHintForRow_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHintForRow_c767_0 ()) +
  gsi::Methods(_create_cbs_visualRect_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_visualRect_c2395_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEditor_4926_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEditor_4926_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_commitData_1315_0 ()) +
  gsi::Methods(_create_callback_cbs_commitData_1315_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_currentChanged_4682_0 ()) +
  gsi::Methods(_create_callback_cbs_currentChanged_4682_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_dataChanged_4682_0 ()) +
  gsi::Methods(_create_callback_cbs_dataChanged_4682_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropMimeData_4479_0 ()) +
  gsi::Methods(_create_callback_cbs_dropMimeData_4479_0 ()) +
  gsi::Methods(_create_cbs_edit_6773_0 ()) +
  gsi::Methods(_create_callback_cbs_edit_6773_0 ()) +
  gsi::Methods(_create_cbs_editorDestroyed_1302_0 ()) +
  gsi::Methods(_create_callback_cbs_editorDestroyed_1302_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_horizontalOffset_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalOffset_c0_0 ()) +
  gsi::Methods(_create_cbs_horizontalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_cbs_horizontalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_isIndexHidden_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_isIndexHidden_c2395_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mimeData_c3436_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeData_c3436_0 ()) +
  gsi::Methods(_create_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveCursor_6476_0 ()) +
  gsi::Methods(_create_callback_cbs_moveCursor_6476_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_rowsAboutToBeRemoved_3713_0 ()) +
  gsi::Methods(_create_callback_cbs_rowsAboutToBeRemoved_3713_0 ()) +
  gsi::Methods(_create_cbs_rowsInserted_3713_0 ()) +
  gsi::Methods(_create_callback_cbs_rowsInserted_3713_0 ()) +
  gsi::Methods(_create_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_callback_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_cbs_selectedIndexes_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_selectedIndexes_c0_0 ()) +
  gsi::Methods(_create_cbs_selectionChanged_5346_0 ()) +
  gsi::Methods(_create_callback_cbs_selectionChanged_5346_0 ()) +
  gsi::Methods(_create_cbs_selectionCommand_c4199_1 ()) +
  gsi::Methods(_create_callback_cbs_selectionCommand_c4199_1 ()) +
  gsi::Methods(_create_cbs_setSelection_6155_0 ()) +
  gsi::Methods(_create_callback_cbs_setSelection_6155_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_startDrag_2456_0 ()) +
  gsi::Methods(_create_callback_cbs_startDrag_2456_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_updateEditorData_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateEditorData_0_0 ()) +
  gsi::Methods(_create_cbs_updateEditorGeometries_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateEditorGeometries_0_0 ()) +
  gsi::Methods(_create_cbs_updateGeometries_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateGeometries_0_0 ()) +
  gsi::Methods(_create_cbs_verticalOffset_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalOffset_c0_0 ()) +
  gsi::Methods(_create_cbs_verticalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_cbs_verticalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_cbs_viewOptions_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_viewOptions_c0_0 ()) +
  gsi::Methods(_create_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_visualRegionForSelection_c2727_0 ()) +
  gsi::Methods(_create_callback_cbs_visualRegionForSelection_c2727_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QListWidget_Adaptor_1315 ()),
  "@qt\n@brief Binding of QListWidget");

}

